/*************************************************************************
 *
 *  $RCSfile: stbmgr.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: cd $ $Date: 2001/08/03 19:40:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXSTBMGR_HXX
#define _SFXSTBMGR_HXX

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#include <framework/statusbarconfiguration.hxx>

#include "app.hxx"
#include "cfgitem.hxx"

//--------------------------------------------------------------------

class SfxStatusItemArr_Impl;
class SfxStatusItemInfArr_Impl;
class SfxStatusBarControl;
class SfxBindings;

//--------------------------------------------------------------------

class SfxStatusBarManager: public SfxConfigItem, public SfxListener
{
friend class SfxStatusBar_Impl;

	StatusBar*					pBar;
	SfxStatusItemArr_Impl*		pBoundItems;
	SfxBindings*				pBindings;
	ULONG						nMaxProgress;
	SfxStatusItemInfArr_Impl*	pItems;
	SfxShell*					pShell;

private:
#if _SOLAR__PRIVATE
    BOOL                        Store( SvStream& rStream );
    int                         Load( SvStream& rStream );
	void						Construct();
	SfxStatusBarControl*		FindControl_Impl( USHORT nId ) const;
	void						Clear_Impl();
#endif

public:
					SfxStatusBarManager( Window* pParent, SfxBindings&,
						SfxShell*, SfxConfigManager*, USHORT nId=SFX_ITEMTYPE_STATBAR,
						StatusBar*p=NULL );
                    SfxStatusBarManager( Window* pParent, const SfxStatusBarManager& rOther, SfxConfigManager* );
					~SfxStatusBarManager();

	static BOOL     Import( SvStream& rInStream, SvStream& rOutStream );
    static BOOL     Export( SvStream& rInStream, SvStream& rOutStream );

    virtual BOOL    Store( SotStorage& rStream );
    virtual int     Load( SotStorage& rStream );
	virtual	void	UseDefault();
    virtual String  GetStreamName() const;
	StatusBar*		GetStatusBar() const
					{ return pBar; }

	BOOL			AddItem( USHORT nItemId, long nWidth,
							USHORT nOffset = STATUSBAR_OFFSET,
							USHORT nPos = STATUSBAR_APPEND );

	void			RemoveItem( USHORT nItemId);
	void			SetItemWidth (USHORT nId, long nWidth);
	USHORT			GetItemPos(USHORT nId)
						{ return pBar->GetItemPos(nId); }

	void			Clear();
	void			Show();
	void			Hide();
	void			DestroyingBindings(SfxBindings*);

	BOOL			IsVisible() const
						{ return pBar->IsVisible(); }
	long			GetWidth( const String& rStr ) const
						{ return pBar->GetTextWidth(rStr); }

	// Beginn Fortschrittsanzeige
	void			StartProgressMode(const String &rText, ULONG nMax);
	// Status Fortschrittsanzeige
	void			SetProgressState(ULONG nVal);
	void			EndProgressMode();
	void            SetProgressMaxValue(ULONG nVal){nMaxProgress=nVal;}
	BOOL			IsProgressMode() const { return pBar->IsProgressMode(); }
	// Hilfetext anzeigen
	void			ShowHelpText(const String &rText );
	// Items anzeigen
	void			ShowItems()
						{ pBar->ShowItems(); }

	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
						 const SfxHint& rHint, const TypeId& rHintType );
#if _SOLAR__PRIVATE
	SfxBindings*	GetBindings_Impl()
					{ return pBindings; }
#endif
};

#endif
