/*************************************************************************
 *
 *  $RCSfile: statcach.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 19:22:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HPP_
#include <com/sun/star/frame/XFrameActionListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HPP_
#include <com/sun/star/frame/FrameActionEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMEACTION_HPP_
#include <com/sun/star/frame/FrameAction.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#include <svtools/eitem.hxx>
#include <svtools/intitem.hxx>
#include <svtools/stritem.hxx>
#include <comphelper/processfactory.hxx>

#pragma hdrstop

#include "statcach.hxx"
#include "msg.hxx"
#include "ctrlitem.hxx"
#include "dispatch.hxx"
#include "sfxtypes.hxx"
#include "sfxuno.hxx"
#include "unoctitm.hxx"
#include "msgpool.hxx"
#include "viewfrm.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;

//====================================================================

DBG_NAME(SfxStateCache);
DBG_NAME(SfxStateCacheSetState);

SFX_IMPL_XINTERFACE_2( BindDispatch_Impl, OWeakObject, ::com::sun::star::frame::XStatusListener, ::com::sun::star::lang::XEventListener )
SFX_IMPL_XTYPEPROVIDER_2( BindDispatch_Impl, ::com::sun::star::frame::XStatusListener, ::com::sun::star::lang::XEventListener )

//-----------------------------------------------------------------------------
BindDispatch_Impl::BindDispatch_Impl( const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch > & rDisp, const ::com::sun::star::util::URL& rURL, SfxStateCache *pStateCache )
	: xDisp( rDisp )
	, aURL( rURL )
	, pCache( pStateCache )
    , pSlot( pCache->aSlotServ.GetSlot() )
{
    if ( !pSlot )
        pSlot = SFX_SLOTPOOL().GetSlot( pCache->GetId() );
    DBG_ASSERT( pSlot, "Unknown slot!");
    aStatus.IsEnabled = sal_True;
}

void SAL_CALL BindDispatch_Impl::disposing( const ::com::sun::star::lang::EventObject& rEvent ) throw( ::com::sun::star::uno::RuntimeException )
{
	if ( xDisp.is() )
	{
        xDisp->removeStatusListener( (::com::sun::star::frame::XStatusListener*) this, aURL );
		xDisp = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch > ();
	}
}

void SAL_CALL  BindDispatch_Impl::statusChanged( const ::com::sun::star::frame::FeatureStateEvent& rEvent ) throw( ::com::sun::star::uno::RuntimeException )
{
	aStatus = rEvent;
	if ( !pCache )
		return;

	::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >  xRef( (::cppu::OWeakObject*)this, ::com::sun::star::uno::UNO_QUERY );
	if ( aStatus.Requery )
		pCache->Invalidate( sal_True );
	else
	{
		pCache->Invalidate( sal_False );
		if ( !aStatus.IsEnabled )
			pCache->SetState_Impl( SFX_ITEM_DISABLED, NULL );
        else if (aStatus.State.hasValue())
		{
            sal_uInt16 nId = pCache->GetId();
			SfxItemState eState = SFX_ITEM_AVAILABLE;
			::com::sun::star::uno::Any aAny = aStatus.State;

			SfxPoolItem *pItem=NULL;
			::com::sun::star::uno::Type pType =	aAny.getValueType();
			if ( pType == ::getBooleanCppuType() )
			{
				sal_Bool bTemp ;
				aAny >>= bTemp ;
				pItem = new SfxBoolItem( nId, bTemp );
			}
			else if ( pType == ::getCppuType((const sal_uInt16*)0) )
			{
				sal_uInt16 nTemp ;
				aAny >>= nTemp ;
				pItem = new SfxUInt16Item( nId, nTemp );
			}
			else if ( pType == ::getCppuType((const sal_uInt32*)0) )
			{
				sal_uInt32 nTemp ;
				aAny >>= nTemp ;
				pItem = new SfxUInt32Item( nId, nTemp );
			}
			else if ( pType == ::getCppuType((const ::rtl::OUString*)0) )
			{
				::rtl::OUString sTemp ;
				aAny >>= sTemp ;
				pItem = new SfxStringItem( nId, sTemp );
			}
			else
            {
                if ( pSlot )
                    pItem = pSlot->GetType()->CreateItem();
                if ( pItem )
                {
                    pItem->SetWhich( nId );
                    pItem->PutValue( aAny );
                }
                else
                    pItem = new SfxVoidItem( nId );
            }

            pCache->SetState_Impl( eState, pItem );
            delete pItem;
		}
		else
		{
			// DONTCARE status
			SfxVoidItem aVoid(0);
			pCache->SetState_Impl( SFX_ITEM_UNKNOWN, &aVoid );
		}
	}
}

void BindDispatch_Impl::Release()
{
	if ( xDisp.is() )
	{
        xDisp->removeStatusListener( (::com::sun::star::frame::XStatusListener*) this, aURL );
		xDisp = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch > ();
	}

	pCache = NULL;
	release();
}

const ::com::sun::star::frame::FeatureStateEvent& BindDispatch_Impl::GetStatus() const
{
	return aStatus;
}

void BindDispatch_Impl::Dispatch( sal_Bool bForceSynchron )
{
    if ( xDisp.is() && aStatus.IsEnabled )
    {
        ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue > aProps(1);
        aProps.getArray()[0].Name = DEFINE_CONST_UNICODE("SynchronMode");
        aProps.getArray()[0].Value <<= bForceSynchron ;
        xDisp->dispatch( aURL, aProps );
    }
}

//--------------------------------------------------------------------

/*	Dieser Konstruktor fuer einen ungueltigen Cache, der sich also
	bei der ersten Anfrage zun"achst updated.
 */

SfxStateCache::SfxStateCache( sal_uInt16 nFuncId ):
	nId(nFuncId),
	pController(0),
	pLastItem( 0 ),
	eLastState( 0 ),
	pDispatch( 0 )
{
	DBG_MEMTEST();
	DBG_CTOR(SfxStateCache,	0);
	bCtrlDirty = sal_True;
	bSlotDirty = sal_True;
	bItemDirty = sal_True;
}

//--------------------------------------------------------------------

/*	Der Destruktor pr"uft per Assertion, ob noch Controller angemeldet
	sind.
 */

SfxStateCache::~SfxStateCache()
{
	DBG_MEMTEST();
	DBG_DTOR(SfxStateCache,	0);
	DBG_ASSERT( pController == 0, "es sind noch Controller angemeldet" );
	if ( !IsInvalidItem(pLastItem) )
		delete pLastItem;
	if ( pDispatch )
	{
		pDispatch->Release();
		pDispatch = NULL;
	}
}

//--------------------------------------------------------------------
// invalidates the cache (next request will force update)
void SfxStateCache::Invalidate( sal_Bool bWithMsg )
{
	bCtrlDirty = sal_True;
	if ( bWithMsg )
	{
		bSlotDirty = sal_True;
		aSlotServ.SetSlot( 0 );
		if ( pDispatch )
		{
			pDispatch->Release();
			pDispatch = NULL;
		}
	}
}

//--------------------------------------------------------------------

// gets the corresponding function from the dispatcher or the cache

const SfxSlotServer* SfxStateCache::GetSlotServer( SfxDispatcher &rDispat , const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > & xProv )
{
	DBG_MEMTEST();
	DBG_CHKTHIS(SfxStateCache, 0);


	if ( bSlotDirty )
	{
        if ( xProv.is() )
        {
            DBG_ASSERT( !pDispatch, "Altes Dispatch nicht entfernt!" );

            // get the slot - even if it is disabled on the dispatcher
            const SfxSlot* pSlot = SFX_APP()->GetSlotPool( rDispat.GetFrame() ).GetSlot( nId );

            // create the dispatch name from the slot data
            ::com::sun::star::util::URL aURL;
            String aName( pSlot && pSlot->pUnoName ? String::CreateFromAscii(pSlot->GetUnoName()) : String() );
            String aCmd;
            if ( aName.Len() )
            {
                aCmd = DEFINE_CONST_UNICODE(".uno:");
                aCmd += aName;
            }
            else
            {
                aCmd = DEFINE_CONST_UNICODE("slot:");
                aCmd += String::CreateFromInt32( nId );
            }

            // try to get a dispatch object for this command
            aURL.Complete = aCmd;
            Reference < XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance( rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
            xTrans->parseStrict( aURL );
            ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  xDisp = xProv->queryDispatch( aURL, ::rtl::OUString(), 0 );
            if ( xDisp.is() )
            {
                // test the dispatch object if it is just a wrapper for a SfxDispatcher
				::com::sun::star::uno::Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel( xDisp, ::com::sun::star::uno::UNO_QUERY );
                SfxOfficeDispatch* pDisp = NULL;
                if ( xTunnel.is() )
                {
                    sal_Int64 nImplementation = xTunnel->getSomething(SfxOfficeDispatch::impl_getStaticIdentifier());
                    pDisp = (SfxOfficeDispatch*)(nImplementation);
                }

                if ( pDisp )
                {
                    // The intercepting object is an SFX component
					// If it's not using the wanted dispatcher or the AppDispatcher, it's treated like any other UNO component
                    SfxDispatcher *pDispatcher = pDisp->GetDispatcher_Impl();
					if ( pDispatcher == &rDispat || pDispatcher == SFX_APP()->GetAppDispatcher_Impl() )
					{
                        // so we can use this shell direct without StarONE connection
                    	rDispat._FindServer( nId, aSlotServ, sal_False );
                        bSlotDirty = sal_False;
                        bCtrlDirty = sal_True;

                        //MI: wozu das? bItemDirty = sal_True;
                        return aSlotServ.GetSlot()? &aSlotServ: 0;
                    }
                }

                // here we are if the dispatch object isn't a SfxDispatcher wrapper or if the wrapper uses another
                // dispatcher, but not rDispat
                // first we need the SlotServer temporarily, because the BindDispatch will need it to access the slot
                rDispat._FindServer( nId, aSlotServ, sal_False );
                pDispatch = new BindDispatch_Impl( xDisp, aURL, this );
                pDispatch->acquire();

                // flags must be set before adding StatusListener because the dispatch object will set the state
                bSlotDirty = sal_False;
                bCtrlDirty = sal_True;
                xDisp->addStatusListener( pDispatch, aURL );

                // now we must forget the SlotServer
                aSlotServ.SetSlot(0);
                return NULL;
            }

            else if ( rDispat.GetFrame() )
            {
                ::com::sun::star::uno::Reference < ::com::sun::star::frame::XDispatchProvider > xFrameProv(
                        rDispat.GetFrame()->GetFrame()->GetFrameInterface(), ::com::sun::star::uno::UNO_QUERY );
                if ( xFrameProv != xProv )
                    return GetSlotServer( rDispat, xFrameProv );
            }
        }
		else
		{
            // Without a dispatch provider we are on our own!
            // Don't find a server for the case "Dispatch Provider, but no dispatch".
            // We have a configuration file that can disable specified commands. See bug #98419#
			rDispat._FindServer(nId, aSlotServ, sal_False);
		}

		bSlotDirty = sal_False;
		bCtrlDirty = sal_True;
        //MI: wozu das? bItemDirty = sal_True;
	}

	return aSlotServ.GetSlot()? &aSlotServ: 0;
}


//--------------------------------------------------------------------

// Status setzen in allen Controllern

void SfxStateCache::SetState
(
	SfxItemState		eState, 	// <SfxItemState> von 'pState'
	const SfxPoolItem*	pState,		// Status des Slots, ggf. 0 oder -1
	BOOL bMaybeDirty
)

/*	[Beschreibung]

	Diese Methode verteilt die Status auf alle an dieser SID gebundenen
	<SfxControllerItem>s. Ist der Wert derselbe wie zuvor und wurde in-
	zwischen weder ein Controller angemeldet, noch ein Controller invalidiert,
	dann wird kein Wert weitergeleitet. Dadurch wird z.B. Flackern in
	ListBoxen vermieden.
*/

{
	if ( pDispatch )
		return;
	SetState_Impl( eState, pState, bMaybeDirty );
}


void SfxStateCache::SetState_Impl
(
	SfxItemState		eState, 	// <SfxItemState> von 'pState'
	const SfxPoolItem*	pState,		// Status des Slots, ggf. 0 oder -1
	BOOL bMaybeDirty
)
{
	DBG_MEMTEST();
	DBG_CHKTHIS(SfxStateCache, 0);

	// wenn zwischen Enter- und LeaveRegistrations ein hartes Update kommt
	// k"onnen zwischenzeitlich auch Cached ohne Controller exisitieren
	if ( !pController )
		return;

	DBG_ASSERT( pController->GetId()==nId, "Cache mit falschem ControllerItem" );
	DBG_ASSERT( bMaybeDirty || !bSlotDirty, "setting state of dirty message" );
	DBG_ASSERT( bCtrlDirty || ( aSlotServ.GetSlot() && aSlotServ.GetSlot()->IsMode(SFX_SLOT_VOLATILE) ),
				"setting state of non dirty controller" );
	DBG_ASSERT( SfxControllerItem::GetItemState(pState) == eState,
				"invalid SfxItemState" );
	DBG_PROFSTART(SfxStateCacheSetState);

	// m"ussen die Controller "uberhaupt benachrichtigt werden?
	FASTBOOL bNotify = bItemDirty;
	if ( !bItemDirty )
	{
		FASTBOOL bBothAvailable = pLastItem && pState &&
					!IsInvalidItem(pState) && !IsInvalidItem(pLastItem);
		DBG_ASSERT( !bBothAvailable || pState != pLastItem, "setting state with own item" );
		if ( bBothAvailable )
			bNotify = pState->Type() != pLastItem->Type() ||
					  *pState != *pLastItem;
		else
			bNotify = ( pState != pLastItem ) || ( eState != eLastState );
	}

	if ( bNotify )
	{
		// Controller updaten
		for ( SfxControllerItem *pCtrl = pController;
			  pCtrl;
			  pCtrl = pCtrl->GetItemLink() )
			pCtrl->StateChanged( nId, eState, pState );

		// neuen Wert merken
		if ( !IsInvalidItem(pLastItem) )
			DELETEZ(pLastItem);
		if ( pState && !IsInvalidItem(pState) )
			pLastItem = pState->Clone();
		else
			pLastItem = 0;
		eLastState = eState;
		bItemDirty = sal_False;
	}

	bCtrlDirty = sal_False;
	DBG_PROFSTOP(SfxStateCacheSetState);
}


//--------------------------------------------------------------------

// alten Status in allen Controllern nochmal setzen

void SfxStateCache::SetCachedState( BOOL bAlways )
{
	DBG_MEMTEST();
	DBG_CHKTHIS(SfxStateCache, 0);
	DBG_ASSERT( pController, "Cache ohne ControllerItem" );
	DBG_ASSERT( pController->GetId()==nId, "Cache mit falschem ControllerItem" );
	DBG_PROFSTART(SfxStateCacheSetState);

	// nur updaten wenn cached item vorhanden und auch verarbeitbar
	// (Wenn der State gesendet wird, mu\s sichergestellt sein, da\s ein
	// Slotserver vorhanden ist, s. SfxControllerItem::GetCoreMetric() )
	if ( bAlways || ( !bItemDirty && !bSlotDirty ) )
	{
		// Controller updaten
		for ( SfxControllerItem *pCtrl = pController;
			  pCtrl;
			  pCtrl = pCtrl->GetItemLink() )
			pCtrl->StateChanged( nId, eLastState, pLastItem );

		// Controller sind jetzt ok
		bCtrlDirty = sal_True;
	}

	DBG_PROFSTOP(SfxStateCacheSetState);
}


//--------------------------------------------------------------------

// FloatingWindows in allen Controls mit dieser Id zerstoeren

void SfxStateCache::DeleteFloatingWindows()
{
	DBG_MEMTEST();
	DBG_CHKTHIS(SfxStateCache, 0);

	SfxControllerItem *pNextCtrl=0;
	for ( SfxControllerItem *pCtrl=pController; pCtrl; pCtrl=pNextCtrl )
	{
		DBG_TRACE((ByteString("pCtrl: ").Append(ByteString::CreateFromInt32((sal_uInt32)pCtrl))).GetBuffer());
		pNextCtrl = pCtrl->GetItemLink();
		pCtrl->DeleteFloatingWindow();
	}
}

::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  SfxStateCache::GetDispatch() const
{
	if ( pDispatch )
		return pDispatch->xDisp;
	return ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch > ();
}

void SfxStateCache::Dispatch( sal_Bool bForceSynchron )
{
	// protect pDispatch against destruction in the call
	::com::sun::star::uno::Reference < ::com::sun::star::frame::XStatusListener > xKeepAlive( pDispatch );
	if ( pDispatch )
        pDispatch->Dispatch( bForceSynchron );
}


