/*************************************************************************
 *
 *  $RCSfile: frameobj.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: mba $ $Date: 2002/09/17 08:17:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sot/formats.hxx>
#ifndef _SOT_CLSIDS_HXX
#include <sot/clsids.hxx>
#endif
#include <tools/list.hxx>
#ifndef _SOERR_HXX //autogen
#include <so3/soerr.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _IPWIN_HXX //autogen
#include <so3/ipwin.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif

#include <svtools/urihelper.hxx>

#pragma hdrstop

#include "frameobj.hxx"

#include "frmenv.hxx"
#include "frmdescr.hxx"
#include "urlframe.hxx"
#include "viewfrm.hxx"
#include "viewsh.hxx"
#include "clientsh.hxx"
#include "docfile.hxx"
#include "basedlgs.hxx"
#include "framedlg.hxx"
#include "doc.hrc"
#include "sfxresid.hxx"
#include "request.hxx"
#include "interno.hxx"
#include "filedlghelper.hxx"

#include <appdata.hxx>

class SfxFrameObjectEditDialog_Impl : public SfxSingleTabDialog
{
public:
	SfxFrameObjectEditDialog_Impl( Window* pParent, const SfxItemSet& rOptionsSet, USHORT nUniqueId );
};

SfxFrameObjectEditDialog_Impl::SfxFrameObjectEditDialog_Impl( Window* pParent,
						const SfxItemSet& rOptionsSet, USHORT nUniqueId )
	: SfxSingleTabDialog( pParent, rOptionsSet, nUniqueId )
{
	SetTabPage( new SfxFramePropertiesPage_Impl( this, rOptionsSet ) );
};

SfxInsertFloatingFrameDialog::SfxInsertFloatingFrameDialog( Window *pParent )
	: pParentWindow( pParent )
{
}

SvInPlaceObjectRef SfxInsertFloatingFrameDialog::Execute( SvStorage* pStor )
{
	SfxFrameObjectRef aObj;
	SfxFrameDescriptor aDescr(0);
	SfxItemSet aSet( SFX_APP()->GetPool(), SID_FRAMEDESCRIPTOR, SID_FRAMEDESCRIPTOR );
	SfxFrameDescriptorItem aItem( &aDescr );
	aSet.Put( aItem );
	SfxFrameObjectEditDialog_Impl aDlg(
			pParentWindow,
			aSet,
			SID_FRAMEDESCRIPTOR );

	if ( aDlg.Execute() == RET_OK )
	{
		// Item auswerten und in Descriptor "ubernehmen
		const SfxPoolItem *pItem;
		SfxItemState eState = aDlg.GetOutputItemSet()->GetItemState( SID_FRAMEDESCRIPTOR, FALSE, &pItem );
		if ( eState == SFX_ITEM_SET )
			aDescr.TakeProperties( ((SfxFrameDescriptorItem*)pItem)->GetProperties() );

		// FrameObject anlegen
		aObj = new SfxFrameObject;
		aObj->DoInitNew( pStor );

		// Daten "ubertragen
		aObj->EnableSetModified( FALSE );
		aObj->SetFrameDescriptor( &aDescr );
		aObj->EnableSetModified( TRUE );
	}

	return (SvInPlaceObject*)&aObj;
}



struct SfxFrameObject_Impl
/*	[Beschreibung]

	Impl-Struktur des SfxFrameObjects.
*/
{
	SfxFrameObjectEnv_Impl* 		pEnv;
	SfxFrameDescriptor*		pFrmDescr;
	SfxURLFrame*			pFrame;
	Timer* 					pNewObjectTimer;
	SfxObjectShellLock		xDoc;

				SfxFrameObject_Impl()
					: pFrame( NULL )
					, pEnv( NULL )
					, pFrmDescr( new SfxFrameDescriptor( NULL ) )
					, pNewObjectTimer( NULL )
				{
				}

				~SfxFrameObject_Impl()
				{
					// Der Descriptor geh"ort dem Object, andere erhalten
					// davon immer nur Clones
					delete pFrmDescr;
				}
};


class SfxFrameObjectWindow_Impl : public Window
{
	SfxFrameObject*	pObj;

protected:
	virtual void	Resize();

public:
                    SfxFrameObjectWindow_Impl( SfxFrameObject *p,
									Window *pParent, USHORT nBits )
						: Window( pParent, nBits )
						, pObj( p )
					{}
};


void SfxFrameObjectWindow_Impl::Resize()
{
	// Die neue Fenstergr"o\se an den Frame weitergeben
	if ( pObj->GetFrame() )
        ((SfxURLFrame*)pObj->GetFrame())->GetFrameWindow_Impl()->SetOutputSizePixel( GetOutputSizePixel() );
}

//=========================================================================
SfxFrameObjectEnv_Impl::SfxFrameObjectEnv_Impl
(
	SvContainerEnvironment * pFrm,	/* Das Callback Gegenst"uck zum
									   InPlace-Environment */
	SfxFrameObject * pObj			/* Das zum Environment geh"orende
									   Objekt */
)
/*	[Beschreibung]

	Das Environment wird im <SfxFrameObject::InPlaceActivate()> angelegt.
	Durch die Verbindung mit dem Container Environment kann "uber die
	UI-Tools und Fenster verhandelt werden.

	[Querverweise]

	<SvInPlaceEnvironment>, <SvContainerEnvironment>
*/
	: SvInPlaceEnvironment( pFrm, pObj )
	, pFrameObject( pObj )
{
	// Das Border- und Clip-Window werden erzeugt
	MakeWindows();
	SvInPlaceWindow *pBW = GetBorderWin();
	pBW->SetHatchBorderPixel( Size() );

	// Eigentliches Fenster erzeugen
	Window *pWin = new SfxFrameObjectWindow_Impl( pObj, pBW, WB_CLIPCHILDREN );
	SetEditWin( pWin );
	pWin->Show();

	// Fenster zuordnen (fuers Resize)
	pBW->SetObjWin( pWin );
}

//=========================================================================
SfxFrameObjectEnv_Impl::~SfxFrameObjectEnv_Impl()
/*	[Beschreibung]

	Die angelegten Fenster werden zerst"ort.
*/
{
	Window *pWin = GetEditWin();
	pWin->Hide();
	SetEditWin( NULL );
	delete pWin;
	DeleteWindows();
}

void SfxFrameObjectEnv_Impl::ReleaseFrame()
{
	pFrameObject->ReleaseFrame_Impl();
}

//=========================================================================
//============== SfxFrameObject ===========================================
//=========================================================================
SO2_IMPL_BASIC_CLASS1_DLL( SfxFrameObject, SvFactory, SvInPlaceObject,
			  SvGlobalName( SO3_IFRAME_CLASSID ) )

//=========================================================================
SfxFrameObject::SfxFrameObject()
	: pImpl( new SfxFrameObject_Impl )
/*	[Beschreibung]

	Konstruktor der Klasse SfxFrameObject. Die Verbliste und das
	Format werden global initialisiert.
*/
{
	// Verben der Superklasse bekanntgeben, um GetVerbs nicht
	// ueberlagern zu muessen
//    SetTypeList( SvDataTypeList() );
	SvVerbList *pVerbs = new SvVerbList;
	pVerbs->Append( SvVerb( 1, String( SfxResId( STR_FRAMEOBJECT_PROPERTIES ) ) ) );
	SetVerbList( pVerbs );
}

//=========================================================================
SfxFrameObject::~SfxFrameObject()
/*	[Beschreibung]

	Destruktor der Klasse SfxFrameObject.
*/
{
	delete pImpl;
}

//=========================================================================
IMPL_LINK( SfxFrameObject, NewObjectHdl_Impl, Timer *, pTimer )
/*	[Beschreibung]

	Wurde kein URL im Objekt gesetzt, dann fragt es im InPlaceActivate
	nach einem. Dies muss asynchron geschehen, da in den Hndlern
	des IP-Protocol eine modale Dialogbox verboten ist.
*/
{
    sfx2::FileDialogHelper aDlg( WB_OPEN );

    if( ERRCODE_NONE == aDlg.Execute() )
	{
        String aName( URIHelper::SmartRelToAbs( aDlg.GetPath() ) );

		// Namen "ubertragen
		pImpl->pFrmDescr->SetURL( aName );
		pImpl->pFrame->GetDescriptor()->SetURL( aName );
		pImpl->pFrame->Update();
	}

    return 0;
}

//=========================================================================
BOOL SfxFrameObject::ConstructFrame()
/*	[Beschreibung]

	Die Methode erzeugt den Frame. Es ist notwendig, da\s das Objekt
	InPlace-Active ist.
*/
{
	// Nur in SfxApps kann ein Frame aufgebaut werden
	SfxInPlaceClientRef aClient = GetIPClient();
	if ( !aClient.Is() )
		return FALSE;

	DBG_ASSERT( !pImpl->pFrame, "Doppelter Aufruf ConstructFrame!" );
	if ( !pImpl->pFrame)
	{
		pImpl->xDoc.Clear();

		// Der Frame erh"alt als Parent den ViewFrame seines Clients
		SfxViewFrame *pView = aClient->GetViewShell()->GetViewFrame();
		SfxFrame *pParent = pView->GetFrame();

		// Den URLFrame erzeugen, der l"adt dann asynchron das Dokument
		pImpl->pFrame = new SfxURLFrame( pImpl->pFrmDescr->Clone(),
			pImpl->pEnv, pImpl->pEnv, pParent );

		// Dieser Frame wird nicht "uber eine Id, sondern "uber seinen
		// Objektnamen identifiziert; daher auf keinen Fall die Id setzen,
		// wohl aber den IdName.
		pImpl->pFrame->SetFrameIdName_Impl( GetParent()->Find(this)->GetObjName() );
	}

	// Focus setzen, Frame zieht ihn dann auf seine ViewShell weiter
	return TRUE;
}

//=========================================================================
void SfxFrameObject::DataChanged_Impl
(
	BOOL bOnlyEmbedSource	/* TRUE, es "andert sich nur die persistenten
							   Daten. FALSE, auch das MetaFile "andert
							   sich */
)
/*	[Beschreibung]

	Wenn die Daten sich "andern, muss das Modify-Flag gesetzt werden.
	Ausserdem m"ussen alle angemeldeten Advises benachrichtigt werden.
	In Abh"angigkeit des Parameters wird angezeigt, dass sich auch
	die View und das Mtf ge"andert hat.
*/
{
	if( IsEnableSetModified() )
	{ // nicht im init oder deinit
		SetModified( TRUE );
		if( bOnlyEmbedSource )
		{
		}
		else
		{
			ViewChanged( ASPECT_CONTENT );
		}
	}
}

//=========================================================================
void SfxFrameObject::FillClass
(
	SvGlobalName * pClassName,	/* Der Typ der Klasse */
	ULONG * pFormat,			/* Das Dateiformat in dem geschrieben wird */
	String * pAppName,			/* Der Applikationsname */
	String * pFullTypeName,     /* Der genaue Name des Typs	*/
    String * pShortTypeName     /* Der kurze Name des Typs  */
    , long /* nFileFormat */
) const
/*	[Beschreibung]

	Mit dieser Methode werden Informationen "uber das Objekt angefordert.
	Wird das Objekt gesichert, dann werden diese Informationen in den
	Storage geschrieben.

	[Anmerkung]
*/
{
	*pClassName     = *GetSvFactory();
	*pFormat    	= 0;
	*pAppName		= DEFINE_CONST_UNICODE( "StarDivision FloatingFrame 1.0" );
	*pFullTypeName  = DEFINE_CONST_UNICODE( "StarDivision FloatingFrame 1.0" );
	*pShortTypeName = DEFINE_CONST_UNICODE( "FloatingFrame" );
}

//=========================================================================
void SfxFrameObject::Open
(
	BOOL bOpen	/* TRUE, es handelt sich um eine Open.
				   FALSE, es handelt sich um Close. */
)
/*	[Beschreibung]

	Die Verbindung zum Client wird ge"offnet oder geschlossen.

	[Querverweise]

	<SvEmbeddedObject::Open()>
*/
{
	// l"asst Environment los
	SvInPlaceObject::Open( bOpen );
}

//=========================================================================
void SfxFrameObject::InPlaceActivate
(
	BOOL bActivate	/* TRUE, InPlace Aktivierung beginnt.
					   FALSE, InPlace Aktivierung endet. */
)
/*	[Beschreibung]

	Das Objekt wird InPlace aktiviert oder deaktiviert.

	[Querverweise]

	<SvInPlaceObject::InPlaceActivate()>
*/
{
	if( bActivate )
	{
		SvContainerEnvironment* pEnv = GetIPClient()->GetEnv();
		pImpl->pEnv = new SfxFrameObjectEnv_Impl( pEnv, this );

		// wird in die Verwaltung eingesetzt
		SetIPEnv( pImpl->pEnv );
		pImpl->pEnv->GetClipWin()->Show();

		if( !ConstructFrame() )
		{
			// Es konnte kein Frame erzeugt werden, da der Client keine
			// SfxApp ist
			DoClose();
			return;
		}
	}

	SvInPlaceObject::InPlaceActivate( bActivate );

	if( !bActivate )
	{
		DELETEZ( pImpl->pNewObjectTimer );
		if ( pImpl->pFrame )
		{
			// Dokument bis zum Abr"aumen des Frames festhalten
			pImpl->xDoc = pImpl->pFrame->GetCurrentDocument();

			// Frame hat sich noch nicht abgemeldet
			if ( pImpl->xDoc.Is() )
            	pImpl->xDoc->SetModified(FALSE);
			pImpl->pFrame->DoClose();
			pImpl->pFrame = NULL;
		}

		DELETEZ( pImpl->pEnv );
	}
}

//=========================================================================
ErrCode SfxFrameObject::Verb
(
	long 				nVerb,		/* welche Art des Aktivierens ist
									   gew"unscht */
	SvEmbeddedClient *	pCl,		/* Callback-Svhnittstelle des Aufruffers */
	Window * 			pWin,		/* Parent auf dem aktiviert werden soll */
	const Rectangle * pWorkRectPixel/* Position und Gr"osse, an der das Objekt
									   aktiviert werden soll */
)
/*	[Beschreibung]

	Es wird Versucht ein Applet zu starten. Es gibt nur die M"oglichkeit
	InPlace zu aktivieren. Deshalb sind auch nur die Verben gestattet,
	die dies ausl"osen.

	[R"uckgabewert]

	BOOL			TRUE, es wurde InPlace aktiviert.
					FALSE, es wurde nicht InPLace aktiviert.

	[Querverweise]

	<SvPseudoObject::Verb>
*/
{
	ErrCode nRet = ERRCODE_SO_NOT_INPLACEACTIVE;
	switch( nVerb )
	{
		case SVVERB_SHOW:
		case SVVERB_IPACTIVATE:
		case 0L:
			nRet = GetProtocol().IPProtocol();
			break;
		case SVVERB_HIDE:
			nRet = DoInPlaceActivate( FALSE );
			break;
		case 2:
			{
/*
				SfxObjectShell* pObj = pImpl->pFrame->GetCurrentDocument();
				if ( pObj )
				{
					String aFileName( pObj->GetMedium()->GetName() );
					if ( aFileName.Len() )
					{
						SfxStringItem aName( SID_FILE_NAME, aFileName );
						SfxBoolItem aCreateView( SID_OPEN_NEW_VIEW, TRUE );
						SFX_APP()->GetAppDispatcher().Execute( SID_OPENDOC,
								SFX_CALLMODE_ASYNCHRON, &aName,
								&aCreateView, 0L);
						bRet = TRUE;
					}
				}
*/
				break;
			}
		case 1:
			{
				SfxInPlaceClientRef aClient = GetIPClient();
				if ( !aClient.Is() )
					return ERRCODE_SO_NOT_INPLACEACTIVE;

				// Dialogaufruf gew"unscht; FrameDescriptor zur ItemId suchen
				SfxFrameDescriptor *pD = pImpl->pFrmDescr;
				String aName = GetParent()->Find(this)->GetObjName();

				// Der Objectname als FrameName soll nur intern sein
				if ( pD->GetName() == aName)
					pD->SetName( String() );

				SfxItemSet aSet( SFX_APP()->GetPool(), SID_FRAMEDESCRIPTOR, SID_FRAMEDESCRIPTOR );
				SfxFrameDescriptorItem aItem( pD );
				aSet.Put( aItem );

				SfxFrameObjectEditDialog_Impl *pDlg = new SfxFrameObjectEditDialog_Impl(
						&aClient->GetViewShell()->GetViewFrame()->GetWindow(),
						aSet,
						SID_FRAMEDESCRIPTOR );

				int nChanged = pDlg->Execute();
				if ( nChanged == RET_OK )
				{
					// Item auswerten und in Descriptor "ubernehmen
					const SfxPoolItem *pItem;
					SfxItemState eState = pDlg->GetOutputItemSet()->GetItemState( SID_FRAMEDESCRIPTOR, FALSE, &pItem );
					if ( eState == SFX_ITEM_SET )
						pD->TakeProperties( ((SfxFrameDescriptorItem*)pItem)->GetProperties() );
					DataChanged_Impl( FALSE );
				}

				// Falls der Benutzer keinen Namen vergeben hat, den internen wieder einsetzen
				if ( ! pD->GetName().Len() )
					pD->SetName( aName );

				// ggf. Frame updaten
				if ( nChanged == RET_OK && pImpl->pFrame )
				{
					SfxFrameDescriptor *pFD = pImpl->pFrame->GetDescriptor();
					SfxFrameSetDescriptor *pSD = pFD->GetParent();
					pImpl->pFrame->Update( pImpl->pFrmDescr->Clone( pSD ) );
					delete pFD;
				}

				nRet = ERRCODE_NONE;
				delete pDlg;
				break;
			}
	}
	return nRet;
}

//=========================================================================
void SfxFrameObject::SetVisArea
(
	const Rectangle & rVisArea	/* neue Position und Groesse des
								   sichtbaren Ausschnitts */
)
/*	[Beschreibung]

	Der sichtbare Ausschnitt beginnt immer an der Position (0, 0).
*/
{
	Rectangle aR( rVisArea );
	aR.SetPos( Point() );
	SvInPlaceObject::SetVisArea( aR );

	DataChanged_Impl( TRUE );
/*
	if ( pImpl->pFrame )
	{
		SfxObjectShell *pDoc = pImpl->pFrame->GetCurrentDocument();
		if ( pDoc && pDoc->GetInPlaceObject() )
			pDoc->GetInPlaceObject()->SetVisArea( rVisArea );
	}
*/
}

Rectangle SfxFrameObject::GetVisArea( USHORT nAspect ) const
{
/*
	if ( pImpl->pFrame || pImpl->xDoc.Is() )
	{
		SfxObjectShell* pDoc;
		if(pImpl->pFrame)
			pDoc = pImpl->pFrame->GetCurrentDocument();
		else
			pDoc = pImpl->xDoc;
		if ( pDoc && pDoc->GetInPlaceObject() )
			return pDoc->GetInPlaceObject()->GetVisArea( nAspect );
	}
*/
	return SvInPlaceObject::GetVisArea( nAspect );
}

//=========================================================================
// aus PlugIn
void SoPaintReplacement( const Rectangle &rRect, String &rText,
						 OutputDevice *pOut );

//=========================================================================
void SfxFrameObject::Draw
(
	OutputDevice * 	pDev,	/* in dieses Device findet die Ausgabe statt */
	const JobSetup &rSetup, /* fuer dieses Device soll formatiert werden */
	USHORT 			nAspect /* Darstellungsvariante des Objektes */
)
/*	[Beschreibung]

	Ein Ausgabe ist nicht m"oglich und auch nicht n"otig.
	und als Unterschrift der URL ausgegeben,

	[Querverweise]

	<SvEmbeddedObject::Draw>
*/
{
	if ( !pImpl->pFrame )
	{
/*
		if ( pImpl->xDoc.Is() && pImpl->xDoc->GetInPlaceObject() )
		{
			SfxInPlaceObject *pObj = pImpl->xDoc->GetInPlaceObject();
			pObj->DoDraw( pDev, Point(), pObj->GetVisArea().GetSize(),
				rSetup, nAspect );
		}
		else
*/
		{
			Rectangle aVisArea = GetVisArea( nAspect );
			String aString( DEFINE_CONST_UNICODE( "FloatingFrame" ) );
			SoPaintReplacement( aVisArea, aString, pDev );
		}
	}
}

//=========================================================================
BOOL SfxFrameObject::InitNew
(
	SvStorage * pStor	/* Storage auf dem das Objekt arbeitet. Der kann
						   auch NULL sein, das Bedeutet, es wird auf einem
						   tempor"aren Storage gearbeitet */
)
/*	[Beschreibung]

	Nach dem Konstruktor muss diese Methode oder Load gerufen werden,
	um das Objekt zu initialisieren.
	<SvPersist::InitNew>

	[R"uckgabewert]

	BOOL			TRUE, Initialisierung hat geklappt.
					FALSE, Initialisierung hat nicht geklappt, das Objekt
					muss sofort freigegeben werden.

	[Querverweise]

*/
{
	if( SvInPlaceObject::InitNew( pStor ) )
	{
		// Standardgr"osse
		SetVisArea( Rectangle( Point(), Size( 10000, 5000 ) ) );
		return TRUE;
	}
	return FALSE;
}

//=========================================================================
static const char * pDocName = "FloatingFrame";
#define nVersion 3

BOOL SfxFrameObject::Load
(
	SvStorage * pStor	/* Storage aus dem das Objekt geladen wird. */
)
/*	[Beschreibung]

	Nach dem Konstruktor muss diese Methode oder InitNew gerufen werden,
	um das Objekt zu initialisieren.

	[R"uckgabewert]

	BOOL			TRUE, das Objekt wurde geladen.
					FALSE, das Objekt wurde nicht geladen, es
					muss sofort freigegeben werden.

	[Querverweise]

	<SvPersist::Load>
*/
{
	if( SvInPlaceObject::Load( pStor ) )
	{
		SvStorageStreamRef xStm;
		xStm = pStor->OpenStream( String::CreateFromAscii( pDocName ), STREAM_STD_READ );
		xStm->SetBufferSize( 8192 );

		// nicht vorhandener Stream ist kein Fehler
		if( xStm->GetError() == SVSTREAM_FILE_NOT_FOUND )
			return TRUE;

		BYTE nFileVersion;
		*xStm >> nFileVersion;
		if( nFileVersion < nVersion )
			pImpl->pFrmDescr->Load( *xStm, 2 );
		else
			pImpl->pFrmDescr->Load( *xStm, nFileVersion );

		return xStm->GetError() == ERRCODE_NONE;
	}
	return FALSE;
}

//=========================================================================
BOOL SfxFrameObject::Save()
/*	[Beschreibung]

	Der Inhalt des Objektes wird in den, in <SfxFrameObject::InitNew>
	oder <SfxFrameObject::Load> "ubergebenen Storage, geschrieben.

	[R"uckgabewert]

	BOOL			TRUE, das Objekt wurde geschreiben.
					FALSE, das Objekt wurde nicht geschrieben. Es muss
					die in der Klasse <SvPersist> beschrieben
					Fehlerbehandlung erfolgen.

	[Querverweise]

	<SvPersist::Save>
*/
{
	if( SvInPlaceObject::Save() )
	{
		SvStorageStreamRef xStm;
		xStm = GetStorage()->OpenStream( String::CreateFromAscii( pDocName ),
										 STREAM_STD_WRITE | STREAM_TRUNC );
		xStm->SetBufferSize( 8192 );

		*xStm << (BYTE) nVersion;
		pImpl->pFrmDescr->Store( *xStm );
		return xStm->GetError() == ERRCODE_NONE;
	}
	return FALSE;
}

//=========================================================================
BOOL SfxFrameObject::SaveAs
(
	SvStorage *pStor	/* Storage, in den der Inhalt des Objekte
						   geschrieben wird */
)
/*	[Beschreibung]

	Der Inhalt des Objektes wird in pStor geschrieben.

	[Anmerkung]

	Der Storage wird nicht behalten.

	[R"uckgabewert]

	BOOL			TRUE, das Objekt wurde geschreiben.
					FALSE, das Objekt wurde nicht geschrieben. Es muss
					die in der Klasse <SvPersist> beschrieben
					Fehlerbehandlung erfolgen.

	[Querverweise]

	<SvPersist::SaveAs>
*/
{
	if( SvInPlaceObject::SaveAs( pStor ) )
	{
		SvStorageStreamRef xStm;
		xStm = pStor->OpenStream( String::CreateFromAscii( pDocName ),
								  STREAM_STD_WRITE | STREAM_TRUNC );
		xStm->SetBufferSize( 8192 );

		*xStm << (BYTE) nVersion;
		pImpl->pFrmDescr->Store( *xStm );

		return xStm->GetError() == ERRCODE_NONE;
	}
	return FALSE;
}

//=========================================================================
void SfxFrameObject::HandsOff()
/*	[Beschreibung]

	Ab diesen Zeitpunkt, bis zum <SfxFrameObject::SaveCompleted>,
	darf auf den Storage im Objekt nicht zugegriffen werden.

	[Querverweise]

	<SvPersist::HandsOff>
*/
{
	SvInPlaceObject::HandsOff();
}

//=========================================================================
BOOL SfxFrameObject::SaveCompleted
(
	SvStorage * pStor	/* Storage auf dem das Objekt arbeitet. Der kann
						   auch NULL sein. Dies Bedeutet, es wird auf
						   dem alten Storage weiter gearbeitet */
)
/*	[Beschreibung]

	Nach dem Aufruf dieser Methode ist das Verhalten des Objektes
	wieder definiert.

	[R"uckgabewert]

	BOOL			TRUE, es kann auf dem neuen Storage gearbeitet werden.
					FALSE, es kann nicht auf dem neuen Storage gearbeitet
					werden

	[Querverweise]

	<SvPersist::SaveCompleted>
*/
{
	return SvInPlaceObject::SaveCompleted( pStor );
}

//=========================================================================
ULONG SfxFrameObject::GetMiscStatus() const
/*	[Beschreibung]

	Da ein Applet immer aktiviert wird, es ein Link ist und er
	keine UI-Tools braucht, muss dieser Status zur"uckgegeben werden.

	[R"uckgabewert]

	ULONG           Es wird immer  SVOBJ_MISCSTATUS_LINK,
					SVOBJ_MISCSTATUS_INSIDEOUT und
					SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE zur"uckgegeben

	[Querverweise]

	<SvPseudoObject::GetMiscStatus()>
*/
{
	ULONG nMisc = 0;

	//nMisc = SVOBJ_MISCSTATUS_LINK;
	nMisc |= SVOBJ_MISCSTATUS_INSIDEOUT;
	nMisc |= SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE;
    nMisc |= SVOBJ_MISCSTATUS_SPECIALOBJECT;
	return nMisc;
}

//=========================================================================
BOOL SfxFrameObject::IsLink() const
/*	[Beschreibung]

	Dieser Typ von Objekt ist immer ein Link.

	[R"uckgabewert]

	BOOL            Immer TRUE.

	[Querverweise]

	<SvPseudoObject::IsLink()>
*/
{
	//return TRUE;
	return FALSE;
}

void SfxFrameObject::SetFrameDescriptor( const SfxFrameDescriptor *pD )
{
	DBG_ASSERT( pD, "Kein Descriptor!" );
	if ( pD )
	{
		if ( pImpl->pFrmDescr )
			delete pImpl->pFrmDescr;
		pImpl->pFrmDescr = pD->Clone( NULL );
		if ( pImpl->pFrame )
		{
			SfxFrameDescriptor *pFD = pImpl->pFrame->GetDescriptor();
			SfxFrameSetDescriptor *pSD = pFD->GetParent();
			pImpl->pFrame->Update( pImpl->pFrmDescr->Clone( pSD ) );
			delete pFD;
		}

		DataChanged_Impl( FALSE );
	}
}

const SfxFrameDescriptor* SfxFrameObject::GetFrameDescriptor() const
{
	return pImpl->pFrmDescr;
}

SfxFrame* SfxFrameObject::GetFrame() const
{
	return pImpl->pFrame;
}

void SfxFrameObject::ReleaseFrame_Impl()
{
	pImpl->pFrame = NULL;
}

SfxFrameObjectFactoryPtr* SfxFrameObject::GetFactoryPtr()
{
	return SFX_APP()->Get_Impl()->pSfxFrameObjectFactoryPtr;
}

