/*************************************************************************
 *
 *  $RCSfile: xmlprsr.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2002/08/26 10:53:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _GLOBAL_HXX_
#include "global.hxx"
#endif

#ifndef _XMLPRSR_HXX_
#include "xmlprsr.hxx"
#endif

#ifndef _IDOCHDL_HXX_
#include "idochdl.hxx"
#endif

#ifndef _SAXPRSREXCPTN_HXX_
#include "saxprsrexcptn.hxx"
#endif

#pragma warning(disable : 4800)

//---------------------------------
// constants
//---------------------------------

#if defined(XML_UNICODE) || defined(XML_UNICODE_WCHAR_T)
	XML_Char COLON = L':';
#else
	XML_Char COLON = ':';
#endif


namespace /* private */
{

	//----------------------------------------		
	/** Extracts the local part of tag without
		namespace decoration
		e.g. meta:creator -> creator
	*/
	const XML_Char* GetLocalName(const XML_Char* RawName)
	{
		const XML_Char* p = RawName;

		// go to the end
		while (*p) p++;
		
		// go back until the first ':' 
		while (*p != COLON && p > RawName)
			p--;

		// if we are on a colon one step forward
		if (*p == COLON)
			p++;

		return p;
	}

}

//---------------------------------
//
//---------------------------------

SaxParser::SaxParser(const XML_Char* EncodingName) : 
	m_SaxDocumentHandler(0),		
	m_SaxDTDHandler(0),
	m_SaxEntityResolver(0),
	m_XmlParser(XML_ParserCreate(EncodingName))
{
	Init();
}

//---------------------------------
//
//---------------------------------

SaxParser::SaxParser(const XML_Char* EncodingName, XML_Char NamespaceSeparator) :
	m_SaxDocumentHandler(0),		
	m_SaxDTDHandler(0),
	m_SaxEntityResolver(0),
	m_XmlParser(XML_ParserCreate(EncodingName))
{
	Init();
}

//---------------------------------
//
//---------------------------------

SaxParser::~SaxParser()
{	
	XML_ParserFree(m_XmlParser);
}

//---------------------------------
//
//---------------------------------

void SaxParser::Init()
{
	XML_SetUserData(m_XmlParser, this);

	// we use the parser as handler argument,
	// so we could use it if necessary, the
	// UserData are usable anyway using
	// XML_GetUserData(...)
	XML_UseParserAsHandlerArg(m_XmlParser);

	XML_SetElementHandler(
		m_XmlParser, 
		XmlStartElementHandler, 
		XmlEndElementHandler);

	XML_SetCharacterDataHandler(
		m_XmlParser,
		XmlCharacterDataHandler);

	XML_SetCommentHandler(
		m_XmlParser, 
		XmlCommentHandler);
}

//---------------------------------
//
//---------------------------------

void SaxParser::Parse(const char* XmlData, size_t Length, bool IsFinal)
{
	if (0 == XML_Parse(m_XmlParser, XmlData, Length, IsFinal))			
		throw SaxParserException(
			XML_ErrorString(XML_GetErrorCode(m_XmlParser)),
			XML_GetErrorCode(m_XmlParser),
			XML_GetCurrentLineNumber(m_XmlParser),
			XML_GetCurrentColumnNumber(m_XmlParser),
			XML_GetCurrentByteIndex(m_XmlParser));
}

//---------------------------------
//
//---------------------------------

void SaxParser::SetDocumentHandler(ISaxDocumentHandler* SaxDocumentHandler)
{
	m_SaxDocumentHandler = SaxDocumentHandler;	
	POST_CONDITION(m_SaxDocumentHandler == SaxDocumentHandler, "Couldn't set new document handler");
}

//---------------------------------
//
//---------------------------------

ISaxDocumentHandler* SaxParser::GetDocumentHandler() const
{
	return m_SaxDocumentHandler;
}

//---------------------------------
//
//---------------------------------

void SaxParser::SetDTDHandler(ISaxDTDHandler* SaxDTDHandler)
{
	m_SaxDTDHandler = SaxDTDHandler;
	POST_CONDITION(m_SaxDTDHandler == SaxDTDHandler, "Couldn't set new DTD handler");
}

//---------------------------------
//
//---------------------------------

ISaxDTDHandler* SaxParser::GetDTDHandler() const
{
	return m_SaxDTDHandler;
}

//---------------------------------
//
//---------------------------------

void SaxParser::SetEntityResolver(ISaxEntityResolver* SaxEntityResolver)
{
	m_SaxEntityResolver = SaxEntityResolver;
	POST_CONDITION(m_SaxEntityResolver == SaxEntityResolver, "Couldn't set new Entity resolver");
}

//---------------------------------
//
//---------------------------------

ISaxEntityResolver* SaxParser::GetEntityResolver() const
{
	return m_SaxEntityResolver;
}

//---------------------------------
//
//---------------------------------

void SaxParser::SetEncoding(const XML_Char* Encoding)
{
	XML_SetEncoding(m_XmlParser, Encoding);
}


//#################################
// Callback functions will be 
// called by the parser on 
// different events
//#################################


//---------------------------------
//
//---------------------------------

void SaxParser::XmlStartElementHandler(void* UserData, const XML_Char* name, const XML_Char** atts)
{	
	PRE_CONDITION(UserData, "Invalid UserData parameter");

	XML_Parser parser = UserData;
	SaxParser* pImpl  = reinterpret_cast<SaxParser*>(XML_GetUserData(parser));
			
	if (pImpl->m_SaxDocumentHandler)
	{		
		XmlTagAttributes_t xml_attribs;

		int i = 0;

		while(atts[i])
		{			
			xml_attribs[GetLocalName(atts[i])] = atts[i+1];
			i += 2; // skip to next pair
		}

		pImpl->m_SaxDocumentHandler->StartElement(name, GetLocalName(name), xml_attribs);
	}		
}

//---------------------------------
//
//---------------------------------

void SaxParser::XmlEndElementHandler(void* UserData, const XML_Char* name)
{
	PRE_CONDITION(UserData, "Invalid UserData parameter");
	
	XML_Parser parser = UserData;
	SaxParser* pImpl  = reinterpret_cast<SaxParser*>(XML_GetUserData(parser));
			
	if (pImpl->m_SaxDocumentHandler)
		pImpl->m_SaxDocumentHandler->EndElement(name, GetLocalName(name));
}

//---------------------------------
//
//---------------------------------

void SaxParser::XmlCharacterDataHandler(void* UserData, const XML_Char* s, int len)
{
	PRE_CONDITION(UserData, "Invalid UserData parameter");
	
	XML_Parser parser = UserData;
	SaxParser* pImpl  = reinterpret_cast<SaxParser*>(XML_GetUserData(parser));
			
	if (pImpl->m_SaxDocumentHandler)
		pImpl->m_SaxDocumentHandler->Characters(std::wstring(s, len));
}

//---------------------------------
//
//---------------------------------

void SaxParser::XmlCommentHandler(void* UserData, const XML_Char* Data)
{
	PRE_CONDITION(UserData, "Invalid UserData parameter");

	XML_Parser parser = UserData;
	SaxParser* pImpl  = reinterpret_cast<SaxParser*>(XML_GetUserData(parser));
	
	if (pImpl->m_SaxDocumentHandler)
		pImpl->m_SaxDocumentHandler->Comment(Data);
}
