/*************************************************************************
 *
 *  $RCSfile: pathoptions.hxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#define INCLUDED_SVTOOLS_PATHOPTIONS_HXX

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif

#define SVT_SEARCHPATH_DELIMITER      ';'
class SvtPathOptions_Impl;

// class SvtPathOptions --------------------------------------------------

class SvtPathOptions_Impl;
class SvtPathOptions
{
private:
	SvtPathOptions_Impl*	pImp;

public:
	enum Pathes
	{
		PATH_ADDIN,
		PATH_AUTOCORRECT,
		PATH_AUTOTEXT,
		PATH_BACKUP,
		PATH_BASIC,
		PATH_BITMAP,
		PATH_CONFIG,
		PATH_DICTIONARY,
		PATH_FAVORITES,
		PATH_FILTER,
		PATH_GALLERY,
		PATH_GRAPHIC,
		PATH_HELP,
		PATH_LINGUISTIC,
		PATH_MODULE,
		PATH_PALETTE,
		PATH_PLUGIN,
		PATH_STORAGE,
		PATH_TEMP,
		PATH_TEMPLATE,
		PATH_USERCONFIG,
		PATH_USERDICTIONARY,
        PATH_WORK,
        PATH_UICONFIG,
		PATH_COUNT // should always be the last element
	};

	SvtPathOptions();
	~SvtPathOptions();

	// get the pathes, not const because of using a mutex
	const String&	GetAddinPath() const;
	const String&	GetAutoCorrectPath() const;
	const String&	GetAutoTextPath() const;
	const String&	GetBackupPath() const;
	const String&	GetBasicPath() const;
	const String&	GetBitmapPath() const;
	const String&	GetConfigPath() const;
	const String&	GetDictionaryPath() const;
	const String&	GetFavoritesPath() const;
	const String&	GetFilterPath() const;
	const String&	GetGalleryPath() const;
	const String&	GetGraphicPath() const;
	const String&	GetHelpPath() const;
	const String&	GetLinguisticPath() const;
	const String&	GetModulePath() const;
	const String&	GetPalettePath() const;
	const String&	GetPluginPath() const;
	const String&	GetStoragePath() const;
	const String&	GetTempPath() const;
	const String&	GetTemplatePath() const;
	const String&	GetUserConfigPath() const;
	const String&	GetUserDictionaryPath() const;
	const String&	GetWorkPath() const;
    const String&   GetUIConfigPath() const;

    BOOL            IsPathReadonly(Pathes ePath)const;

	// set the pathes
	void			SetAddinPath( const String& rPath );
	void			SetAutoCorrectPath( const String& rPath );
	void			SetAutoTextPath( const String& rPath );
	void			SetBackupPath( const String& rPath );
	void			SetBasicPath( const String& rPath );
	void			SetBitmapPath( const String& rPath );
	void			SetConfigPath( const String& rPath );
	void			SetDictionaryPath( const String& rPath );
	void			SetFavoritesPath( const String& rPath );
	void			SetFilterPath( const String& rPath );
	void			SetGalleryPath( const String& rPath );
	void			SetGraphicPath( const String& rPath );
	void			SetHelpPath( const String& rPath );
	void			SetLinguisticPath( const String& rPath );
	void			SetModulePath( const String& rPath );
	void			SetPalettePath( const String& rPath );
	void			SetPluginPath( const String& rPath );
	void			SetStoragePath( const String& rPath );
	void			SetTempPath( const String& rPath );
	void			SetTemplatePath( const String& rPath );
	void			SetUserConfigPath( const String& rPath );
	void			SetUserDictionaryPath( const String& rPath );
	void			SetWorkPath( const String& rPath );

	String			SubstituteVariable( const String& rVar );
	String			UseVariable( const String& rVar );
	sal_Bool		SearchFile( String& rIniFile, Pathes ePath = PATH_USERCONFIG );
	LanguageType	GetLanguageType() const;
    sal_Bool        IsReadonly() const;
};

// class PathService -----------------------------------------------------

#ifndef _COM_SUN_STAR_FRAME_XCONFIGMANAGER_HPP_
#include <com/sun/star/frame/XConfigManager.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif

class PathService : public ::cppu::WeakImplHelper2< ::com::sun::star::frame::XConfigManager, ::com::sun::star::lang::XServiceInfo >
{
    virtual ::rtl::OUString	SAL_CALL	getImplementationName(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL			supportsService( const ::rtl::OUString& ServiceName ) throw(::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
										getSupportedServiceNames(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL	substituteVariables( const ::rtl::OUString& sText ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL				addPropertyChangeListener( const ::rtl::OUString& sKeyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& xListener ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL				removePropertyChangeListener( const ::rtl::OUString& sKeyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& xListener ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL				flush(  ) throw(::com::sun::star::uno::RuntimeException);
};

#endif // #ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX

