/*************************************************************************
 *
 *  $RCSfile: AccessibleShapeTreeInfo.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 16:50:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SVX_ACCESSIBILITY_ACCESSIBLE_SHAPE_TREE_INFO_HXX
#define _SVX_ACCESSIBILITY_ACCESSIBLE_SHAPE_TREE_INFO_HXX

#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECOMPONENT_HPP_
#include <com/sun/star/accessibility/XAccessibleComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTBROADCASTER_HPP_
#include <com/sun/star/document/XEventBroadcaster.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _SVX_ACCESSIBILITY_IACCESSIBLE_VIEW_FORWARDER_HXX
#include "IAccessibleViewForwarder.hxx"
#endif

class SdrView;
class Window;

namespace accessibility {

/** This class bundles all information that is passed down the tree of
    accessible shapes so that each shape has access to that info.

    There are basically four members that can be set and queried:
    <ul>
    <li>The model broadcaster is used for getting notified about shape
    changes.  Using this broadcaster makes in unnecessary to register at
    each shape seperately.</li>
    <li>The view forwarder is responsible for transformation between
    coordinate systems and for providing the visible area both with respect
    to a specific window.</li>
    <li>The SdrView is used for creating accessible edit engines.</li>
    <li>The Window is used for creating accessible edit engines.</li>
    </ul>
*/
class AccessibleShapeTreeInfo
{
public:
    /** Deprecated.  Don't use this constructor any more.
    */
    AccessibleShapeTreeInfo (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::accessibility::XAccessibleComponent>& rxDocumentWindow,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::document::XEventBroadcaster>& rxBroadcaster);

    /** Use this constructor to create an empty object that is filled later
        with more meaningfull data.
    */
    AccessibleShapeTreeInfo (void);

    /** Create a copy of the given shape info.
        @param rInfo
            The shape tree info object to copy.
    */
    AccessibleShapeTreeInfo (const AccessibleShapeTreeInfo& rInfo);

    ~AccessibleShapeTreeInfo (void);

    AccessibleShapeTreeInfo& operator= (const AccessibleShapeTreeInfo& rInfo);

    /** Deprecated.  Don't use this method.
    */
    void SetDocumentWindow (const ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessibleComponent>& rxViewWindow);
    /** Deprecated.  Don't use this method.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessibleComponent>
        GetDocumentWindow (void) const;

    /** Deprecated.   Use the correctly named SetModelBroadcaster method
        instead.
    */
    void SetControllerBroadcaster (const ::com::sun::star::uno::Reference<
        ::com::sun::star::document::XEventBroadcaster>& rxControllerBroadcaster);
    /** Deprecated.   Use the correctly named GetModelBroadcaster method
        instead.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::document::XEventBroadcaster>
        GetControllerBroadcaster (void) const;

    
    /** Set a new broadcaster that sends events indicating shape changes.
        The broadcaster usually is or belongs to a document model.
        @param rxModelBroadcaster
            The new broadcaster.  It replaces the current one.  An empty
            reference may be passed to unset the broadcaster
    */
    void SetModelBroadcaster (const ::com::sun::star::uno::Reference<
        ::com::sun::star::document::XEventBroadcaster>& rxModelBroadcaster);

    /** Return the current model broadcaster.
        @return
            The returned reference may be empty if the broadcaster has not
            been set or has been set to an empty reference.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::document::XEventBroadcaster>
        GetModelBroadcaster (void) const;
    
    /** Set the view that will be used to construct SvxTextEditSources which
        in turn are used to create accessible edit engines.
        @param pView
            The new SdrView that replaces the current one.  A NULL pointer
            may be passed to unset the view.
    */
    void SetSdrView (SdrView* pView);

    /** Return the current SdrView.
        @return
            The returned value may be NULL.
    */
    SdrView* GetSdrView (void) const;

    /** Set a new controller.  This will usually but not necessarily
        correspond to the SdrView.
        @param rxController
            The new controller that replaces the current one.  An empty
            reference may be passed to unset the controller.
    */
    void SetController (const ::com::sun::star::uno::Reference<
        ::com::sun::star::frame::XController>& rxController);

    /** Return the currently set controller.
        @return
            The reference to the currently set controller may be empty.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::frame::XController>
        GetController (void) const;

    /** Set the window that is used to construct SvxTextEditSources which in
        turn is used to create accessible edit engines.
    */
    void SetWindow (Window* pWindow);

    /** Return the current Window.
        @return
            The returned value may be NULL.
    */
    Window* GetWindow (void) const;

    /** The view forwarder allows the transformation between internal
        and pixel coordinates and can be asked for the visible area.
        @param pViewForwarder
            This view forwarder replaces the current one.
    */
    void SetViewForwarder (const IAccessibleViewForwarder* pViewForwarder);

    /** Return the current view forwarder.
        @return
            The returned pointer may be NULL.
    */
    const IAccessibleViewForwarder* GetViewForwarder (void) const;

private:
    /** Deprecated.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessibleComponent> mxDocumentWindow;

    /** this broadcaster sends events indicating shape changes.
        The broadcaster usually is or belongs to a document model.

        This once was named mxControllerBroadcaster.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::document::XEventBroadcaster> mxModelBroadcaster;

    /** This view is necessary to construct an SvxTextEditSource which in
        turn is used to create an accessible edit engine.
    */
    SdrView* mpView;

    /** The controller is used e.g. for obtaining the selected shapes.
    */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::frame::XController> mxController;

    /** This window is necessary to construct an SvxTextEditSource which in
        turn is used to create an accessible edit engine.
    */
    Window* mpWindow;

    /** The view forwarder allows the transformation between internal
        and pixel coordinates and can be asked for the visible area.
    */
    const IAccessibleViewForwarder* mpViewForwarder;
};


} // end of namespace accessibility

#endif
