/*************************************************************************
 *
 *  $RCSfile: adritem.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/26 08:19:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SBXVAR_HXX //autogen
#include <svtools/sbxvar.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif
#pragma hdrstop

#include "adritem.hxx"
#include "svxids.hrc"

#define INVALID_TOKEN ((USHORT)0xFFFF)

// -----------------------------------------------------------------------

String ConvertToStore_Impl( const String& rText )
{
	String sRet;
	USHORT i = 0;

	while ( i < rText.Len() )
	{
		if ( rText.GetChar(i) == '\\' || rText.GetChar(i) == '#' )
			sRet += '\\';
		sRet += rText.GetChar(i++);
	}
	return sRet;
}

// -----------------------------------------------------------------------

TYPEINIT1(SvxAddressItem, SfxStringItem);

// -----------------------------------------------------------------------

SvxAddressItem::SvxAddressItem( USHORT nWhich ) :

	SfxStringItem( nWhich, String() )

{
	SvtUserOptions aUserOpt;

	aName = aUserOpt.GetLastName();
	aFirstName = aUserOpt.GetFirstName();
	aShortName = aUserOpt.GetID();

	SetToken( POS_COMPANY, aUserOpt.GetCompany() );
	SetToken( POS_STREET, aUserOpt.GetStreet() );
	SetToken( POS_CITY, aUserOpt.GetCity() );
	SetToken( POS_STATE, aUserOpt.GetState() );
	SetToken( POS_PLZ, aUserOpt.GetZip() );
	SetToken( POS_COUNTRY, aUserOpt.GetCountry() );
	SetToken( POS_POSITION, aUserOpt.GetPosition() );
	SetToken( POS_TITLE, aUserOpt.GetTitle() );
	SetToken( POS_TEL_PRIVATE, aUserOpt.GetTelephoneHome() );
	SetToken( POS_TEL_COMPANY, aUserOpt.GetTelephoneWork() );
	SetToken( POS_FAX, aUserOpt.GetFax() );
	SetToken( POS_EMAIL, aUserOpt.GetEmail() );
}

// -----------------------------------------------------------------------

SvxAddressItem::SvxAddressItem( const SvxAddressItem& rItem ) :

	SfxStringItem( rItem.Which(), rItem.GetValue() ),

	aName		( rItem.aName ),
	aFirstName	( rItem.aFirstName ),
	aShortName	( rItem.aShortName )

{
}

// -----------------------------------------------------------------------

SvxAddressItem::SvxAddressItem( const String &rAdress,
								const String &rShortName,
								const String &rFirstName,
								const String &rName,
								USHORT nWhich ) :

	SfxStringItem( nWhich, rAdress ),

	aName		( rName ),
	aFirstName	( rFirstName ),
	aShortName	( rShortName )

{
}

// -----------------------------------------------------------------------

void SvxAddressItem::Store()
{
	SvtUserOptions aUserOpt;
	aUserOpt.SetCompany( GetCompany() );
	aUserOpt.SetFirstName( GetFirstName() );
	aUserOpt.SetLastName( GetName() );
	aUserOpt.SetID( GetShortName() );
	aUserOpt.SetStreet( GetStreet() );
	aUserOpt.SetCity( GetCity() );
	aUserOpt.SetState( GetState() );
	aUserOpt.SetZip( GetPLZ() );
	aUserOpt.SetCountry( GetCountry() );
	aUserOpt.SetPosition( GetPosition() );
	aUserOpt.SetTitle( GetTitle() );
	aUserOpt.SetTelephoneHome( GetTelPriv() );
	aUserOpt.SetTelephoneWork( GetTelCompany() );
	aUserOpt.SetFax( GetFax() );
	aUserOpt.SetEmail( GetEmail() );
}

// -----------------------------------------------------------------------

SfxPoolItem* SvxAddressItem::Clone( SfxItemPool * ) const
{
	return new SvxAddressItem( *this );
}

// -----------------------------------------------------------------------

SfxPoolItem* SvxAddressItem::Create( SvStream& rStream, USHORT nVersion ) const
{
	DBG_ERROR( "wer will denn ein SvxAdddressItem laden?" );

	String aAdr, aShortName, aFirstName, aName;
	rStream.ReadByteString(aAdr);
	rStream.ReadByteString(aShortName);
	rStream.ReadByteString(aFirstName);
	rStream.ReadByteString(aName);
	return new SvxAddressItem( aAdr, aShortName, aFirstName, aName, Which() );
}

// -----------------------------------------------------------------------

int SvxAddressItem::operator==( const SfxPoolItem& rAttr ) const
{
	DBG_ASSERT( SfxPoolItem::operator==(rAttr), "unequal types" );

	const SvxAddressItem& rItem = (const SvxAddressItem&)rAttr;

	return SfxStringItem::operator==(rAttr) &&
		   ( rItem.GetName() == aName ) &&
		   ( rItem.GetFirstName() == aFirstName ) &&
		   ( rItem.GetShortName() == aShortName );
}

// -----------------------------------------------------------------------

sal_Bool SvxAddressItem::QueryValue( com::sun::star::uno::Any& rVal, BYTE nMemberId ) const
{
    sal_Bool bConvert = 0!=(nMemberId&CONVERT_TWIPS);
    nMemberId &= ~CONVERT_TWIPS;
	USHORT nPos = USHRT_MAX;
    switch ( nMemberId )
	{
        case MID_ADR_CITY           : nPos = (USHORT)POS_CITY; break;
        case MID_ADR_COMPANY        : nPos = (USHORT)POS_COMPANY; break;
        case MID_ADR_COUNTRY        : nPos = (USHORT)POS_COUNTRY; break;
        case MID_ADR_EMAIL          : nPos = (USHORT)POS_EMAIL; break;
        case MID_ADR_FAX            : nPos = (USHORT)POS_FAX; break;
        case MID_ADR_FIRSTNAME      : rVal <<= (::rtl::OUString) aFirstName; break;
        case MID_ADR_ID             : rVal <<= (::rtl::OUString) aShortName; break;
        case MID_ADR_LASTNAME       : rVal <<= (::rtl::OUString) aName; break;
        case MID_ADR_PHONE          : nPos = (USHORT)POS_TEL_COMPANY; break;
        case MID_ADR_PHONEPRIVATE   : nPos = (USHORT)POS_TEL_PRIVATE; break;
        case MID_ADR_POSITION       : nPos = (USHORT)POS_POSITION; break;
        case MID_ADR_STREET         : nPos = (USHORT)POS_STREET; break;
        case MID_ADR_TITLE          : nPos = (USHORT)POS_TITLE; break;
        case MID_ADR_ZIPCODE        : nPos = (USHORT)POS_PLZ; break;
        case MID_ADR_STATE          : nPos = (USHORT)POS_STATE ; break;
        case MID_ADR_FATHERSNAME    : nPos = (USHORT)POS_FATHERSNAME ; break;
        case MID_ADR_APARTMENT      : nPos = (USHORT)POS_APARTMENT ; break;
		default:
            DBG_ERROR( "can't interprete Id" );
            return sal_False;
	}

	if ( nPos != USHRT_MAX )
        rVal <<= (::rtl::OUString) GetToken(nPos);
    return sal_True;
}

// -----------------------------------------------------------------------

sal_Bool SvxAddressItem::PutValue( const com::sun::star::uno::Any& rVal, BYTE nMemberId )
{
    sal_Bool bConvert = 0!=(nMemberId&CONVERT_TWIPS);
    nMemberId &= ~CONVERT_TWIPS;
    ::rtl::OUString aString;
    rVal >>= aString;

	String sOld;
	USHORT nId = USHRT_MAX;
    switch ( nMemberId )
	{
        case MID_ADR_CITY           : nId = (USHORT)POS_CITY; break;
        case MID_ADR_COMPANY        : nId = (USHORT)POS_COMPANY; break;
        case MID_ADR_COUNTRY        : nId = (USHORT)POS_COUNTRY; break;
        case MID_ADR_EMAIL          : nId = (USHORT)POS_EMAIL; break;
        case MID_ADR_FAX            : nId = (USHORT)POS_FAX; break;
        case MID_ADR_FIRSTNAME      : aFirstName = aString; break;
        case MID_ADR_ID             : aShortName = aString; break;
        case MID_ADR_LASTNAME       : aName = aString; break;
        case MID_ADR_PHONE          : nId = (USHORT)POS_TEL_COMPANY; break;
        case MID_ADR_PHONEPRIVATE   : nId = (USHORT)POS_TEL_PRIVATE; break;
        case MID_ADR_POSITION       : nId = (USHORT)POS_POSITION; break;
        case MID_ADR_STREET         : nId = (USHORT)POS_STREET; break;
        case MID_ADR_TITLE          : nId = (USHORT)POS_TITLE; break;
        case MID_ADR_ZIPCODE        : nId = (USHORT)POS_PLZ; break;
        case MID_ADR_STATE          : nId = (USHORT)POS_STATE ; break;
        case MID_ADR_FATHERSNAME    : nId = (USHORT)POS_FATHERSNAME ; break;
        case MID_ADR_APARTMENT      : nId = (USHORT)POS_APARTMENT ; break;

		default:
            DBG_ERROR( "can't interprete Id" );
	}

	if ( nId != USHRT_MAX )
	{
		// mache ggf. aus '#' -> "\#"
        String aVal = ConvertToStore_Impl( aString );
		SetToken( nId, aVal );
	}

	return 0;
}

// -----------------------------------------------------------------------

BOOL SvxAddressItem::SetToken( USHORT nPos, const String &rVal )
{
	// nach dem 'nPos'-ten Token suchen
	String aAdress( GetValue() );
	USHORT nStart, nEnd = 0;
	for ( USHORT nNo = 0; nNo <= nPos; ++nNo )
	{
		// End-'#' finden
		for ( nStart = nEnd;
			  nEnd < aAdress.Len() && aAdress.GetChar(nEnd) != '#';
			  ++nEnd )
			if ( aAdress.GetChar(nEnd) == '\\' )
				++nEnd;

		// aAdress[nEnd] == '#' oder am Ende, also eine Position weiter gehen
		++nEnd;

		// ggf. fehlende '#' auff"ullen
		if ( nNo < nPos && nEnd >= aAdress.Len() )
			aAdress += '#';
	}

	// gefunden
	aAdress.Erase( nStart, nEnd-nStart-1 );
	aAdress.Insert( ::ConvertToStore_Impl( rVal ), nStart );
	SetValue( aAdress );
	return TRUE;
}

// -----------------------------------------------------------------------

String SvxAddressItem::GetToken( USHORT nPos ) const
{
	String sRet, sEmpty;
	const String &rAdress = GetValue();
	USHORT i = 0, nTxt = 0;

	while ( i < rAdress.Len() )
	{
		while ( i < rAdress.Len() && rAdress.GetChar(i) != '#' )
		{
			if ( rAdress.GetChar(i) == '\\' )
				i++;
			sRet += rAdress.GetChar(i++);
		}

		// rAdress[i] == '#' oder am Ende, also eine Position weiter gehen
		i++;

		if ( nPos == nTxt )
			return sRet;
		else if ( i >= rAdress.Len() )
			return sEmpty;
		else
		{
			sRet.Erase();
			nTxt++;
		}
	}
	return sEmpty;
}

// -----------------------------------------------------------------------

sal_Bool SvxAddressItem::IsTokenReadonly( USHORT nToken ) const
{
	sal_Bool bRet = sal_False;

	switch ( nToken )
	{
		case POS_COMPANY :		nToken = USER_OPT_COMPANY;			break;
		case POS_STREET :		nToken = USER_OPT_STREET;			break;
		case POS_COUNTRY :		nToken = USER_OPT_COUNTRY;			break;
		case POS_PLZ :			nToken = USER_OPT_ZIP;				break;
		case POS_CITY :			nToken = USER_OPT_CITY;				break;
		case POS_TITLE :		nToken = USER_OPT_TITLE;			break;
		case POS_POSITION :		nToken = USER_OPT_POSITION;			break;
		case POS_TEL_PRIVATE :	nToken = USER_OPT_TELEPHONEHOME;	break;
		case POS_TEL_COMPANY :	nToken = USER_OPT_TELEPHONEWORK;	break;
		case POS_FAX :			nToken = USER_OPT_FAX;				break;
		case POS_EMAIL :		nToken = USER_OPT_EMAIL;			break;
		case POS_STATE :		nToken = USER_OPT_STATE;			break;
		case POS_FIRSTNAME :	nToken = USER_OPT_FIRSTNAME;		break;
		case POS_LASTNAME :		nToken = USER_OPT_LASTNAME;			break;
		case POS_SHORTNAME :	nToken = USER_OPT_ID;				break;

		case POS_FATHERSNAME :
		case POS_APARTMENT :
		default:
		{
			nToken = INVALID_TOKEN;
			DBG_ERRORFILE( "SvxAddressItem::IsTokenReadonly(): invalid token" );
		}
	}

	return SvtUserOptions().IsTokenReadonly( nToken );
}

