/*************************************************************************
 *
 *  $RCSfile: ldapdlg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#pragma hdrstop

#include "ldapdlg.hxx"
#include "dialmgr.hxx"

#include "dialogs.hrc"
#include "optldap.hrc"

// class SvxLDAPServerDlg_Impl -------------------------------------------

IMPL_LINK( SvxLDAPServerDlg_Impl, ModifyHdl, Edit *, EMPTYARG )
{
	String aStr = aPortED.GetText();

	if ( !ByteString(aStr,RTL_TEXTENCODING_UTF8).IsNumericAscii() )
	{
		aPortED.SetText( aStr.Copy( 0, aStr.Len() - 1 ) );
		aPortED.SetSelection( Selection( SELECTION_MAX, SELECTION_MAX ) );
		Sound::Beep();
	}
	return 0;
}

// -----------------------------------------------------------------------

SvxLDAPServerDlg_Impl::SvxLDAPServerDlg_Impl( Window* pParent ) :

	ModalDialog( pParent, SVX_RES( RID_SVXDLG_LDAP ) ),

	aDescriptionFT	( this, ResId( FT_LDAP_PROP_DESC ) ),
	aDescriptionED	( this, ResId( ED_LDAP_PROP_DESC ) ),
	aServerFT		( this, ResId( FT_LDAP_PROP_SERVER ) ),
	aServerED		( this, ResId( ED_LDAP_PROP_SERVER ) ),
	aRootFT			( this, ResId( FT_LDAP_PROP_ROOT ) ),
	aRootED			( this, ResId( ED_LDAP_PROP_ROOT ) ),
	aPortFT			( this, ResId( FT_LDAP_PROP_PORT ) ),
	aPortED			( this, ResId( ED_LDAP_PROP_PORT ) ),
	aMaxHitsFT		( this, ResId( FT_LDAP_PROP_MAXHITS ) ),
	aMaxHitsED		( this, ResId( ED_LDAP_PROP_MAXHITS ) ),
	aMaxHitsNullFT	( this, ResId( FT_LDAP_PROP_MAXHITS_NULL ) ),
	aPropertyBox	( this, ResId( GB_LDAP_PROP ) ),
	aOKBtn			( this, ResId( BTN_LDAP_PROP_OK ) ),
	aCancelBtn		( this, ResId( BTN_LDAP_PROP_CANCEL ) ),
	aHelpBtn		( this, ResId( BTN_LDAP_PROP_HELP ) )

{
	FreeResource();

	aPortED.SetModifyHdl( LINK( this, SvxLDAPServerDlg_Impl, ModifyHdl ) );
}

// -----------------------------------------------------------------------

SvxLDAPServerDlg_Impl::~SvxLDAPServerDlg_Impl()
{
}

// -----------------------------------------------------------------------

String SvxLDAPServerDlg_Impl::GetIniString() const
{
	String aIniStr = aDescriptionED.GetText();
	( aIniStr += LDAP_TOKEN_DELIM ) += aServerED.GetText();
	( aIniStr += LDAP_TOKEN_DELIM ) += aRootED.GetText();
	( aIniStr += LDAP_TOKEN_DELIM ) += aPortED.GetText();
	( aIniStr += LDAP_TOKEN_DELIM ) += aMaxHitsED.GetText();
	return aIniStr;
}

// -----------------------------------------------------------------------

void SvxLDAPServerDlg_Impl::SetIniString( const String& rIniStr )
{
	DBG_ASSERT( rIniStr.GetTokenCount( LDAP_TOKEN_DELIM ) == 5,
				"wrong token count" );

	aDescriptionED.SetText( rIniStr.GetToken( 0, LDAP_TOKEN_DELIM ) );
	aServerED.SetText( rIniStr.GetToken( 1, LDAP_TOKEN_DELIM ) );
	aRootED.SetText( rIniStr.GetToken( 2, LDAP_TOKEN_DELIM ) );
	aPortED.SetText( rIniStr.GetToken( 3, LDAP_TOKEN_DELIM ) );
	aMaxHitsED.SetText( rIniStr.GetToken( 4, LDAP_TOKEN_DELIM ) );
}


