/*************************************************************************
 *
 *  $RCSfile: deco.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

class DecoName;

typedef unsigned char uchar;

extern "C" {
	int uu_init();
int encode_line (uchar *indata, uchar *outdata, int bytes_in);
}

#include <string.hxx>
#include <list.hxx>

#define MAN_TYPE_NULL		0x00000000
#define MAN_TYPE_VOID		0x00000001
#define MAN_TYPE_BOOL		0x00000002
#define MAN_TYPE_SHORT		0x00000004
#define MAN_TYPE_INT		0x00000008
#define MAN_TYPE_LONG		0x00000010
#define MAN_TYPE_UNSIGNED 	0x00000020
#define MAN_TYPE_CHAR		0x00000040
#define MAN_TYPE_PTR		0x00000080
#define MAN_TYPE_CONST		0x00000100
#define MAN_TYPE_ENUM		0x00000200
#define MAN_TYPE_REF		0x00000400
#define MAN_TYPE_DOUBLE		0x00000800
#define MAN_TYPE_FLOAT		0x00001000
#define MAN_TYPE_PUBLIC		0x00002000
#define MAN_TYPE_PRIVATE	0x00004000
#define MAN_TYPE_PROTECTED	0x00008000
#define MAN_TYPE_CDECL		0x00010000
#define MAN_TYPE_STDCALL	0x00020000
#define MAN_TYPE_FUNCTION	0x00040000
#define MAN_TYPE_PTRPTR		0x00080000

#define MAN_TYPE_CLASS		0x00100000
#define MAN_TYPE_STRUCT		0x00200000
#define MAN_TYPE_USER		0x00800000
#define MAN_TYPE_STATIC		0x01000000
#define MAN_TYPE_VIRTUAL	0x02000000
#define MAN_TYPE_FUNCPTR	0x04000000
#define MAN_TYPE_SCOPE		0x08000000
#define MAN_TYPE_TEMPLATE	0x10000000
#define MAN_TYPE_THISCALL	0x20000000
#define MAN_TYPE_VTABLE		0x40000000


#define MAN_FUNCTYPE_CTOR	0x00000001
#define MAN_FUNCTYPE_DTOR	0x00000002
#define MAN_FUNCTYPE_ASSIGN	0x00000004

enum FunctionType { Default, Ctor, Dtor, CCTor, Plus, Minus, Reference,
	Dereference, PlusPlus, MinusMinus, ShiftLeft, ShiftRight, Not,
	PointerToMember, Cast, Assign, Equal, GreaterEqual, LessEqual,
	UnEqual, Greater, Less };

DECLARE_LIST( ScopeList, ByteString* );

class NName
{
	ScopeList*		pScope;
	ByteString*		pName;
	NName*			pTempl;
public:
					NName(ByteString* pName);
					NName();

	ScopeList*		GetScope(){ return pScope; }
	void			AddScope( ByteString* pSName );
	ByteString*		GetName(){ return pName; }

	void			SetTemplate( NName* pNName ){ pTempl = pNName; }
	NName*			GetTemplate(){ return pTempl; }
};

class DecoType
{
	unsigned long	aType;
	NName*			pUserType;
	DecoName* 		pDeco;

public:
					DecoType();
	NName*			GetUserType(){ return pUserType;}
	DecoName*		GetDecoName(){ return pDeco;}
	void			SetUserType( NName* pName ){ pUserType = pName; }
	void			SetDecoName( DecoName* pDN ){ pDeco = pDN; }
	unsigned long	GetType(){return aType;}
	void			SetType( unsigned long nType ){ aType = nType; }
	void			AddType( unsigned long nType ){ aType |= nType; }
};

DECLARE_LIST( ParamList, DecoType* );

class DecoName
{
private:
	ByteString		aMangledName;
	ByteString		aName;

	ByteString 		aSolsMName;
	ByteString 		aLnxiMName;
	ByteString 		aFunc;
	ScopeList*		pNameList;
	ParamList*		pTypeList;

	ByteString 		aFuncName;
	ParamList*		pFuncParams;
	NName*			pClassName;

	ULONG			nAccessType;
	FunctionType	eFunctionType;
	ULONG			nCalling;

	BOOL			bInRet;

	void			ParseFunc();
	void			ParseScope();
	void			PrintBody();
	void			PrintRefs();
public:
					DecoName();
					DecoName( ByteString aManName );
					~DecoName();

	ParamList*		GetParamList(){ return pFuncParams; }
	ULONG			GetRetType();

	ByteString		PrintName();
	void 			PrintSolsName();
	void			Parse();

	ByteString		PrintType( ULONG nType, DecoType* pType = 0 );
	ByteString		PrintAccessType( ULONG nType );

	void			DbgPrintParams();

	USHORT			GetTemplate( ByteString& );
	NName*			ParseTemplate( ByteString& );

	USHORT			GetName( ByteString& );
	NName*			ParseName( ByteString& );

	USHORT			GetType( ByteString& );
	DecoType*		ParseType( ByteString& );

	USHORT			GetFuncName( ByteString& );
	ByteString 		ParseFuncName( ByteString& );

	USHORT 			GetAccess( ByteString& );
	void			ParseAccess( ByteString& );
};


