/*************************************************************************
 *
 *  $RCSfile: extattr.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: armin $ $Date: 2001/03/08 09:51:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENDED_ATTRIBUTES_HXX
#define _EXTENDED_ATTRIBUTES_HXX

#ifndef _SVPM_H
#include <svpm.h>
#endif

#ifndef _STRING_HXX
#include <string.hxx>
#endif

#include <map>

/***************************************************************************************
 *
 * EA - Base class for extended Attributes
 *
 ***************************************************************************************
 */

class EA
{
public:
	typedef PM_USHORT Identifier;

	typedef PM_BYTE FlagSet;
	typedef map<String, FlagSet, less<const String> > NameSet;

private:
	Identifier id;

public:
	static PM_USHORT queryList(const String& file, NameSet& aNameSet);
	static BOOL		 queryName(const String& file, const String& name);

	EA(Identifier eaid) : id(eaid) {};
	virtual ~EA(void) {};

	Identifier attributeId(void) const { return id; };

	static void remove(const String& file, const String& name);

	void getFrom(const String& file, const String& name);
	void storeTo(const String& file, const String& name);

protected:
	virtual PM_USHORT readFrom(PVOID, PM_USHORT) = 0;
	virtual PM_USHORT writeTo (PVOID, PM_USHORT) = 0;
};


/***************************************************************************************
 *
 * TEA - Template class for extended Attributes
 *
 ***************************************************************************************
 */

template <class T, EA::Identifier eaid>
class TEA : public EA
{
public:
	enum { id = eaid };
	
	TEA(void) : EA(eaid) {};
	virtual ~TEA(void) {};

//	  static T* cast(EA *);
//	  static const T* cast(const EA *);

};

/***************************************************************************************
 *
 * StringEA - class for string based extended Attributes
 *
 ***************************************************************************************
 */

class StringEA : public TEA<StringEA, EAT_ASCII>, public String
{
public:
	StringEA() {};
	StringEA(const StringEA& s) : TEA<StringEA, StringEA::id>(s), String(s) {};

	// read value of eaname from file
	StringEA(const String& file, const String& eaname) { getFrom(file, eaname); };

	// set value directly
	StringEA(const String& eavalue) : TEA<StringEA, StringEA::id>(), String(eavalue) {};

protected:
	virtual PM_USHORT readFrom(PVOID, PM_USHORT);
	virtual PM_USHORT writeTo (PVOID, PM_USHORT);
};

/***************************************************************************************
 *
 * UrlEA - extract URL from WPUrl-File
 *
 ***************************************************************************************
 */

class UrlEA : public TEA<UrlEA, EAT_BINARY>, public String
{
public:
	UrlEA() {};
	UrlEA(const UrlEA& s) : TEA<UrlEA, UrlEA::id>(s), String(s) {};

	// read value of eaname from file
	UrlEA(const String& file, const String& eaname) { getFrom(file, eaname); };

	// set value directly
	UrlEA(const String& eavalue) : TEA<UrlEA, UrlEA::id>(), String(eavalue) {};

protected:
	virtual PM_USHORT readFrom(PVOID, PM_USHORT);
	virtual PM_USHORT writeTo (PVOID, PM_USHORT);
};

#endif /* EXTENDED_ATTRIBUTES_HXX */
