/*************************************************************************
 *
 *  $RCSfile: rapofflinecontent.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/12 11:13:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINECONTENT_HXX
#define INCLUDED_UCB_RAPOFFLINECONTENT_HXX

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX
#include "rapofflinecommandmap.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDPROCESSOR_HXX
#include "rapofflinecommandprocessor.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEERROR_HXX
#include "rapofflinestorageerror.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGENOTIFIER_HPP_
#include "com/sun/star/beans/XPropertiesChangeNotifier.hpp"
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include "com/sun/star/container/XChild.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include "com/sun/star/lang/XComponent.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include "com/sun/star/lang/XTypeProvider.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include "com/sun/star/ucb/XContent.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTCREATOR_HPP_
#include "com/sun/star/ucb/XContentCreator.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include "com/sun/star/uno/Exception.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _OSL_INTERLOCK_H_
#include "osl/interlck.h"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include "salhelper/simplereferenceobject.hxx"
#endif

#ifndef INCLUDED_MAP
#include <map>
#define INCLUDED_MAP
#endif
#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

namespace com { namespace sun { namespace star {
    namespace io { class XStream; }
    namespace lang { class XMultiServiceFactory; }
    namespace ucb { class XCommandEnvironment; }
    namespace uno {
        class Any;
        class XInterface;
    }
    namespace util { struct DateTime; }
} } }
namespace ucprmt { namespace offline {
    class Content;
    class ContentTypeData;
    class Storage;
    class StorageNode;
} }

namespace ucprmt { namespace offline {

class ContentContainer: public salhelper::SimpleReferenceObject
{
public:
    ContentContainer(
        com::sun::star::uno::Reference<
                com::sun::star::lang::XMultiServiceFactory > const &
            rServiceFactory,
        rtl::Reference< Storage > const & rStorage,
        rtl::Reference< ContentTypeData > const & rContentTypeData);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    queryContent(rtl::OUString const & rId)
        SAL_THROW((StorageError, com::sun::star::uno::RuntimeException));

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    createNewContent(
        com::sun::star::uno::Sequence< rtl::OUString > const & rChildren,
        rtl::OUString const & rParent,
        rtl::OUString const & rContentType,
        rtl::OUString const & rTitle,
        com::sun::star::util::DateTime const & rDateCreated,
        bool bFolder,
        bool bDocument,
        bool bReadOnly)
        SAL_THROW((StorageError));

private:
    typedef std::map< rtl::OUString, Content * > Map;

    Map m_aMap;
    osl::Mutex m_aMutex;
    com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory >
        m_xServiceFactory;
    rtl::Reference< Storage > m_xStorage;
    rtl::Reference< ContentTypeData > m_xContentTypeData;

    virtual ~ContentContainer() SAL_THROW(());

    void releaseElement(Content * pElement) SAL_THROW(());

    rtl::Reference< Content > find(rtl::OUString const & rId)
        SAL_THROW((StorageError));

    bool moveContent(rtl::Reference< Content > const & rContent,
                     rtl::OUString const & rId,
                     bool bReplaceExisting);

    bool deleteContent(rtl::Reference< Content > const & rContent);

    friend class Content;
        // to access Map, m_xStorage, releaseElement(), moveContent(),
        // deleteContent()
};

class Content: public com::sun::star::lang::XTypeProvider,
               public com::sun::star::ucb::XContent,
               public com::sun::star::lang::XComponent,
               public com::sun::star::beans::XPropertiesChangeNotifier,
               public com::sun::star::ucb::XContentCreator,
               public com::sun::star::container::XChild,
               public CommandProcessor,
               public CommandMapSupplier
{
public:
    virtual com::sun::star::uno::Any SAL_CALL
    queryInterface(com::sun::star::uno::Type const & rType)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

    virtual
    com::sun::star::uno::Sequence< com::sun::star::uno::Type > SAL_CALL
    getTypes()
        throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL
    getImplementationId()
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    SAL_CALL
    getIdentifier()
        throw (com::sun::star::uno::RuntimeException);

    virtual rtl::OUString SAL_CALL getContentType()
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    addContentEventListener(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentEventListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    removeContentEventListener(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentEventListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL dispose()
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    addEventListener(com::sun::star::uno::Reference<
                             com::sun::star::lang::XEventListener > const &
                         rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    removeEventListener(com::sun::star::uno::Reference<
                                com::sun::star::lang::XEventListener > const &
                            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    addPropertiesChangeListener(
        com::sun::star::uno::Sequence< rtl::OUString > const & rPropertyNames,
        com::sun::star::uno::Reference<
                com::sun::star::beans::XPropertiesChangeListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    removePropertiesChangeListener(
        com::sun::star::uno::Sequence< rtl::OUString > const & rPropertyNames,
        com::sun::star::uno::Reference<
                com::sun::star::beans::XPropertiesChangeListener > const &
            rListener)
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Sequence< com::sun::star::ucb::ContentInfo > SAL_CALL
    queryCreatableContentsInfo()
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
    createNewContent(com::sun::star::ucb::ContentInfo const & rInfo)
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
    getParent()
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    setParent(com::sun::star::uno::Reference<
                      com::sun::star::uno::XInterface > const &
                  rParent)
        throw (com::sun::star::lang::NoSupportException,
               com::sun::star::uno::RuntimeException);

    virtual rtl::Reference< CommandMap > getCommandMap();

    static com::sun::star::uno::Any
    executeGetCommandInfo(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeGetCommandInfo(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeGetPropertySetInfo(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeGetPropertySetInfo(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeGetPropertyValues(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeGetPropertyValues(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeSetPropertyValues(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeSetPropertyValues(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeOpen(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeOpen(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeUpdate(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeUpdate(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeDelete(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeDelete(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeInsert(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeInsert(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    static com::sun::star::uno::Any
    executeTransfer(
        void * pContent,
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Any
    executeTransfer(
        com::sun::star::uno::Any const & rArgument,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnviroment)
        SAL_THROW((com::sun::star::uno::Exception));

private:
    rtl::Reference< ContentContainer > m_xContainer;
    ContentContainer::Map::iterator m_aContainerIt;
    oslInterlockedCount m_nRefCount;
    rtl::OUString m_aId;
    rtl::Reference< StorageNode > m_xStorageNode;

    inline Content(rtl::Reference< ContentContainer > const & rContainer,
                   rtl::OUString const & rId,
                   rtl::Reference< StorageNode > const & rStorageNode);

    inline ~Content() SAL_THROW(());

    inline
    operator
        com::sun::star::uno::Reference< com::sun::star::uno::XInterface >()
        SAL_THROW(());
        // avoid ambigious casts

    void
    checkUninserted(com::sun::star::uno::Reference<
                            com::sun::star::ucb::XCommandEnvironment > const &
                        rEnvironment)
        SAL_THROW((com::sun::star::uno::Exception));

    void
    checkDeleted(com::sun::star::uno::Reference<
                         com::sun::star::ucb::XCommandEnvironment > const &
                     rEnvironment)
        SAL_THROW((com::sun::star::uno::Exception));

    com::sun::star::uno::Reference< com::sun::star::io::XStream >
    getStream(com::sun::star::uno::Reference<
                      com::sun::star::ucb::XCommandEnvironment > const &
                  rEnviroment)
        SAL_THROW((com::sun::star::uno::RuntimeException));

    rtl::OUString getParentId() SAL_THROW((StorageError));

    void addChildId(rtl::OUString const & rId);

    void removeChildId(rtl::OUString const & rId);

    void insert(rtl::OUString const & rId);

    void rebind(rtl::OUString const & rId,
                rtl::Reference< StorageNode > const & rNode);

    void reset(rtl::Reference< StorageNode > const & rNode);

    Content(Content &); // not implemented
    void operator =(Content); // not implemented

    friend class ContentContainer;
        // to access m_aContainerIt, m_nRefCount, m_aId, m_xStorageNode,
        // Content(), ~Content(), getParentId(), addChildId(),
        // removeChildId(), insert(), reset(), rebind()
#if defined WNT
    friend struct std::auto_ptr< Content >; // to access ~Content()
        // work around compiler bug...
#else // WNT
    friend class std::auto_ptr< Content >; // to access ~Content()
#endif // WNT
};

} }

#endif // INCLUDED_UCB_RAPOFFLINECONTENT_HXX
