/*************************************************************************
 *
 *  $RCSfile: object.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/object.hxx>


// NOT FULLY DEFINED SERVICES
#include <udm/creator.hxx>
#include <udm/struct.hxx>


namespace udm
{

void                GiveBack_Data(
                        DYN Data &            let_drData );


inline void
Object::ExchangeData( Data & io_rNewData )
{
    Acquire(io_rNewData);
    ReleaseData();
    pData = &io_rNewData;
}

inline void
Object::ReleaseData()
{
    if (pData->release())
        pData->dispose();
}

inline Data *
Object::Acquire(Data & io_rNewData)
{
    io_rNewData.acquire();
    return &io_rNewData;
}



Object::Object()
    :   pData( Acquire(Data::null_()) )
{
}

Object::Object( Data & i_rData )
    :   pData( Acquire(i_rData) )
{
}

Object::Object( const Object & i_rObj )
    :   pData( Acquire(*i_rObj) )
{
}

Object::~Object()
{
    ReleaseData();
}

Object::operator bool() const
{
 	return pData->is_null();
}

Object &
Object::operator=( Data & i_rData )
{
    ExchangeData( i_rData );
    return *this;
}

Object &
Object::operator=( const Object & i_rObj )
{
    ExchangeData( *i_rObj.pData );
    return *this;
}

csv::bostream &
Object::bin_write( csv::bostream & o_out ) const
{
    pData->bin_write(o_out);
    return o_out;
}

csv::bistream &
Object::bin_read( csv::bistream &     io_in,
                  Creator &           io_rCreationInfo  )
{
    ExchangeData( io_rCreationInfo.CreateFromBinary(io_in) );
    return io_in;
}

Object
Object::get( int i_nKey ) const
{
 	return r_struct().search_by_key(i_nKey);
}

bool
Object::is_type( Data::accessor_type i_type ) const
{
    return pData->type() == i_type;
}

Data::accessor_type
Object::type() const
{
    return pData->type();
}

Data::description
Object::type_description() const
{
    return pData->type_description();
}


}   // namespace udm

