/*************************************************************************
 *
 *  $RCSfile: struct.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/struct.hxx>


// NOT FULLY DEFINED SERVICES





namespace udm
{

Struct::~Struct()
{
}



void
Struct::do_BinWrite( csv::bostream & o_out ) const
{
    for ( member_id m = 0; m <= size(); ++m )
    {
     	Object obj = member(m);
        if (obj)
        {
            o_out.write(&m, sizeof(member_id));
            obj.bin_write(o_out);
        }
    }
}

#if 0
void
Struct::do_XmlWrite( csv::bostream & o_out ) const
{
    o_out.write("\n<struct>");
    for ( member_id m = 1; m <= max_member_id(); ++m )
    {
        xml_WriteMember(o_out, m);
    }
    o_out.write("</struct>\n");
}
#endif // 0 

Data::accessor_type
Struct::inq_Type() const
{
 	return t_Struct;
}

Struct::description
Struct::inq_TypeDescription() const
{
    // KORR
 	return "S{}";
}

Struct &
Struct::access_Struct()
{
 	return *this;
}

#if 0
void
Struct::xml_WriteMember( csv::bostream &    o_out,
                         member_id          i_m ) const
{
    static StreamStr sNr(10);

    Object obj = member(i_m);
    if (obj)
    {
        o_out.write("\n<member nr=\"");
        sNr.seekp(0);
        sNr << i_m;
        o_out.write(sNr.c_str());
        o_out.write("\">");

        obj.xml_write(o_out);

        o_out.write("</member>\n");
    }
}
#endif // 0 




//*********************       Struct_Null      *******************//

class Struct_Null : public Struct
{
  public:
    virtual             ~Struct_Null();

  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    virtual description inq_TypeDescription() const;

    // Interface Struct
    virtual Object      inq_Member(
                            member_id           i_m ) const;
    virtual Object      inq_SearchByKey(
                            int                 i_nKey ) const;
    virtual member_id   size() const;
};


Struct_Null::~Struct_Null()
{
}

void                Struct_Null::do_Dispose() { }
void                Struct_Null::do_BinWrite( csv::bostream & ) const    {}
Data::description   Struct_Null::inq_TypeDescription() const { return "S{}"; }


Object
Struct_Null::inq_Member( member_id i_m ) const
{
    return Object();
}

Object
Struct_Null::inq_SearchByKey( int i_nKey ) const
{
    return Object();
}

member_id
Struct_Null::size() const
{
    return 0;
}


template <>
Struct &
get_null<Struct>( csv::Type2Type<Struct> )
{
    static Struct * pNull_ = new Struct_Null;
    return *pNull_;
}





}   // namespace udm



