/*************************************************************************
 *
 *  $RCSfile: image.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2002/08/22 13:54:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_IMAGE_HXX
#define _SV_IMAGE_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_RESID_HXX
#include <resid.hxx>
#endif

class ImplImage;
class ImplImageList;
class Bitmap;
class BitmapEx;
class Color;

// ---------------
// - Image-Types -
// ---------------

// TH-01.03.99: Was soll das ifdef MAC hier???
#ifdef MAC
#ifdef IMAGE_STDBTN_COLOR
#undef IMAGE_STDBTN_COLOR
#endif
#endif
#define IMAGE_STDBTN_COLOR		Color( 0xC0, 0xC0, 0xC0 )

// -----------------------
// - ImageColorTransform -
// -----------------------

enum ImageColorTransform
{
    IMAGECOLORTRANSFORM_NONE = 0,
    IMAGECOLORTRANSFORM_HIGHCONTRAST = 1
};

// ---------
// - Image -
// ---------

class Image
{
	friend class ImageList;

private:
	ImplImage*		mpImplData;

public:
					Image();
					Image( const ResId& rResId );
					Image( const Image& rImage );
					Image( const Bitmap& rBitmap );
					Image( const Bitmap& rBitmap, const Bitmap& rMaskBitmap );
					Image( const Bitmap& rBitmap, const Color& rColor );
					Image( const BitmapEx& rBitmapEx );
					~Image();

	Size			GetSizePixel() const;

	Bitmap			GetBitmap()		const;	
	BOOL			HasMaskBitmap()	const;
	Bitmap			GetMaskBitmap() const;
	BOOL			HasMaskColor()	const;
	Color			GetMaskColor()	const;

    Image           GetColorTransformedImage( ImageColorTransform eColorTransform ) const;
    static void     GetColorTransformArrays( ImageColorTransform eColorTransform, Color*& rpSrcColor, Color*& rpDstColor, ULONG& rColorCount );

	BOOL			operator!() const;

	Image&			operator=( const Image& rImage );
	BOOL			operator==( const Image& rImage ) const;
	BOOL			operator!=( const Image& rImage ) const { return !(Image::operator==( rImage )); }

    void            ClearCaches();
};

inline BOOL Image::operator!() const
{
	if ( !mpImplData )
		return TRUE;
	else
		return FALSE;
}

// -------------------
// - ImageList-Types -
// -------------------

#define IMAGELIST_IMAGE_NOTFOUND	((USHORT)0xFFFF)

// -------------
// - ImageList -
// -------------

class ImageList
{
private:
	ImplImageList*	mpImplData;
	USHORT			mnInitSize;
	USHORT			mnGrowSize;

public:
					ImageList( USHORT nInit = 8, USHORT nGrow = 4 );
					ImageList( const ResId& rResId );
					ImageList( const ImageList& rImageList );
					ImageList( const Bitmap& rBitmap,
							   USHORT nInitSize, USHORT* pIdAry = NULL,
							   USHORT nGrow = 4 );
					ImageList( const Bitmap& rBitmap, const Bitmap& rMaskBmp,
							   USHORT nInitSize, USHORT* pIdAry = NULL,
							   USHORT nGrow = 4 );
					ImageList( const Bitmap& rBitmap, const Color& rColor,
							   USHORT nInitSize, USHORT* pIdAry = NULL,
							   USHORT nGrow = 4 );
					~ImageList();

	void			AddImage( USHORT nNewId, const Image& rImage );
	void			CopyImage( USHORT nNewId, USHORT nCopyId );
	void			ReplaceImage( USHORT nId, const Image& rImage );
	void			ReplaceImage( USHORT nId, USHORT nReplaceId );
	void			MergeImage( USHORT nId, USHORT nMergeId );
	void			RemoveImage( USHORT nId );
	Image			GetImage( USHORT nId ) const;
	void			Clear();

	USHORT			GetImageCount() const;
	USHORT			GetImagePos( USHORT nId ) const;
	USHORT			GetImageId( USHORT nPos ) const;
	Size			GetImageSize() const;

	Bitmap			GetBitmap() const;
	Bitmap			GetMaskBitmap() const;
	BOOL			HasMaskBitmap() const;
	Color			GetMaskColor() const;
	BOOL			HasMaskColor() const;

    ImageList       GetColorTransformedImageList( ImageColorTransform eColorTransform ) const;

	ImageList&		operator=( const ImageList& rImageList );
	BOOL			operator==( const ImageList& rImageList ) const;
	BOOL			operator!=( const ImageList& rImageList ) const
						{ return !(ImageList::operator==( rImageList )); }

	friend SvStream& operator>>( SvStream& rIStream, ImageList& rImageList );
	friend SvStream& operator<<( SvStream& rOStream, const ImageList& rImageList );
};

#endif	// _SV_IMAGE_HXX
