/*************************************************************************
 *
 *  $RCSfile: xevthdl.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: ssa $ $Date: 2001/11/23 12:16:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_XEVTHDL_HXX
#define _SV_XEVTHDL_HXX

#include "rvp.hxx"

// ----------------
// - XRmsEventHdl -
// ----------------

class Window; 

class XRmsEventHdl : public ::cppu::WeakImplHelper1< NMSP_CLIENT::XEventHdl >
{
private:

	Window*						mpEventWindow;	

public:

								XRmsEventHdl( Window* pEventWindow );
	virtual						~XRmsEventHdl();

	void 						setWindow( Window* pEventWindow );
        Window*                                         getWindow() { return mpEventWindow; }

    virtual void SAL_CALL		MouseButtonUp( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nMode, sal_uInt16 nCode, sal_uInt32 nSysTime ) throw();
    virtual void SAL_CALL		MouseButtonDown( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nMode, sal_uInt16 nCode, sal_uInt32 nSysTime ) throw();
    virtual void SAL_CALL		MouseMove( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nMode, sal_uInt16 nCode, sal_uInt32 nSysTime ) throw();
    virtual void SAL_CALL		MouseWheel( sal_Int32 nX, sal_Int32 nY, sal_uInt16 nCode, sal_uInt32 nSysTime, sal_Int32 nDelta, sal_Int32 nNotchDelta, sal_uInt32 nScrollLines, sal_Bool bHorz ) throw();
    virtual void SAL_CALL		KeyInput( sal_uInt16 nKeyCode, sal_uInt16 nChar, sal_uInt16 nCount ) throw();
    virtual void SAL_CALL		KeyUp( sal_uInt16 nKeyCode, sal_uInt16 nChar ) throw();
    virtual void SAL_CALL		Paint( sal_Int32 nX, sal_Int32 nY, sal_Int32 nWidth, sal_Int32 nHeight ) throw();
    virtual void SAL_CALL		Resize( sal_Int16 nWidth, sal_Int16 nHeight ) throw();
    virtual void SAL_CALL		GetFocus() throw();
    virtual void SAL_CALL		LoseFocus() throw();
    virtual sal_Bool SAL_CALL	QueryDropFile( NMSP_CLIENT::RmDropFileEvent& rDropFileEvent ) throw();
    virtual sal_Bool SAL_CALL	DropFile( const NMSP_CLIENT::RmDropFileEvent& aDropFileEvent ) throw();
    virtual void SAL_CALL		Close() throw();
	virtual void SAL_CALL		UserEvent( sal_uInt32 EventID, const ::com::sun::star::uno::Any& Parameter ) throw();
    virtual void SAL_CALL       StartExtTextInput() throw();
    virtual void SAL_CALL       ExtTextInput( const ::rtl::OUString& aText, const ::com::sun::star::uno::Sequence< sal_uInt16 >& aAttributes, sal_uInt32 nCursorPos, sal_uInt16 nCursorFlags, sal_uInt32 nSysTime ) throw();
    virtual void SAL_CALL       EndExtTextInput() throw();
    virtual void SAL_CALL       InputContextChange( const ::rtl::OUString& aLanguage ) throw();
    virtual void SAL_CALL		GeometryChange( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nWidth, sal_uInt16 nHeight ) throw ();
    virtual void SAL_CALL		DecorationChange( sal_uInt16 nLeftDecoration, sal_uInt16 nTopDecoration, sal_uInt16 nRightDecoration, sal_uInt16 nBottomDecoration ) throw ();
};

#endif	// _SV_XEVTHDL_HXX
