/*************************************************************************
 *
 *  $RCSfile: salbmp.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <string.h>

#include <svmac.h>



#define _SV_SALBMP_CXX


#ifndef _RTL_ALLOC_H_
#include <rtl/alloc.h>
#endif

#ifndef _NEW_HXX

#include <tools/new.hxx>

#endif

#ifndef _SV_SALBTYPE_HXX

#include <salbtype.hxx>

#endif

#ifndef _SV_SALGDI_HXX

#include <salgdi.hxx>

#endif

#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif

#ifndef _SV_SALBMP_HXX

#include <salbmp.hxx>

#endif

#include <string.h>



// -------------

// - SalBitmap -

// -------------



SalBitmap::SalBitmap() :

		mhPixMap	( 0 ),

		mnBitCount	( 0 )

{

}



// ------------------------------------------------------------------



SalBitmap::~SalBitmap()

{

	Destroy();

}



// ------------------------------------------------------------------



BOOL SalBitmap::ImplCreate( PixMapHandle hPixMap, BOOL bCopyHandle )

{ 

	BOOL bRet = FALSE;



	if( bCopyHandle )

	{

		HLock( (Handle) hPixMap );



		const Size aSize( (**hPixMap).bounds.right - (**hPixMap).bounds.left,

						  (**hPixMap).bounds.bottom - (**hPixMap).bounds.top );



		mhPixMap = NewPixMap();



		if( mhPixMap )

		{

			CopyPixMap( hPixMap, mhPixMap );



			const ULONG nImageSize = AlignedWidth4Bytes( (**hPixMap).pixelSize * aSize.Width() ) * aSize.Height();

			MAC_Ptr		pCopyData = (MAC_Ptr) rtl_allocateZeroMemory( nImageSize );



			memcpy( pCopyData, (**hPixMap).baseAddr, nImageSize );

			(**mhPixMap).baseAddr = pCopyData;

		}



		HUnlock( (Handle) hPixMap );

	}

	else

		mhPixMap = hPixMap;



	if( mhPixMap )

	{

		HLock( (Handle) mhPixMap );

		

		Rect aBounds( (**mhPixMap).bounds );

        maSize = Size( aBounds.right - aBounds.left, aBounds.bottom - aBounds.top );

		mnBitCount = (**hPixMap).pixelSize;



		if( mnBitCount )

			mnBitCount = ( mnBitCount <= 1 ) ? 1 : ( mnBitCount <= 4 ) ? 4 : ( mnBitCount <= 8 ) ? 8 : 24;



		HUnlock( (Handle) mhPixMap );

		

		bRet = TRUE;

	}



	return bRet;

}



// ------------------------------------------------------------------



BOOL SalBitmap::Create( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal )

{	

	BOOL bRet = FALSE;



	mhPixMap = ImplCreatePixMap( rSize, nBitCount, rPal );



	if( mhPixMap )

	{

		maSize = rSize;

		mnBitCount = nBitCount;

		bRet = TRUE;

	}



	return bRet;

}



// ------------------------------------------------------------------



BOOL SalBitmap::Create( const SalBitmap& rSalBmp )

{

	BOOL bRet = FALSE;



	if( rSalBmp.mhPixMap )

	{

		PixMapHandle	hOldPixMap = rSalBmp.mhPixMap;

		const Size&		rSize = rSalBmp.maSize;

		

		mhPixMap = NewPixMap();

		CopyPixMap( hOldPixMap, mhPixMap );

		const ULONG nImageSize = AlignedWidth4Bytes( (**hOldPixMap).pixelSize * rSize.Width() ) * rSize.Height();

		MAC_Ptr pCopyData = (MAC_Ptr) rtl_allocateZeroMemory( nImageSize );

		memcpy( pCopyData, (**hOldPixMap).baseAddr, nImageSize );

		(**mhPixMap).baseAddr = pCopyData;

		maSize = rSalBmp.maSize;

		mnBitCount = rSalBmp.mnBitCount;

		bRet = TRUE;

	}



	return bRet;

}



// ------------------------------------------------------------------



BOOL SalBitmap::Create( const SalBitmap& rSalBmp, SalGraphics* pGraphics )

{

	return Create( rSalBmp );

}



// ------------------------------------------------------------------



BOOL SalBitmap::Create( const SalBitmap& rSalBmp, USHORT nNewBitCount )

{

	return Create( rSalBmp );

}



// ------------------------------------------------------------------



void SalBitmap::Destroy()

{

	if( mhPixMap )

	{

		HLock( (Handle) mhPixMap );

		rtl_freeMemory( (**mhPixMap).baseAddr );



		if( ( (**mhPixMap).rowBytes & 0x8000 ) && ( (**mhPixMap).pmTable ) )

			DisposeCTable( (**mhPixMap).pmTable );

		

		HUnlock( (Handle) mhPixMap );

		DisposeHandle( (Handle) mhPixMap );

	}



	maSize = Size();

	mnBitCount = 0;

}



// ------------------------------------------------------------------



PixMapHandle SalBitmap::ImplCreatePixMap( const Size& rSize, USHORT nBits, const BitmapPalette& rPal )

{

	DBG_ASSERT( nBits == 1 || nBits == 4 || nBits == 8 ||

				nBits == 16 || nBits == 24 || nBits == 32,

				"Unsupported BitCount!" );



	PixMapHandle hPixMap = 0;



	if ( rSize.Width() && rSize.Height() )

	{

		const USHORT	nDepth = ( nBits <= 16 ) ? nBits : 32;

		const ULONG		nAlignedWidth = AlignedWidth4Bytes( nDepth * rSize.Width() );



		hPixMap = (PixMapHandle) NewHandle( sizeof( PixMap ) );

		

		if( hPixMap )

		{

			if( nAlignedWidth <= 0x3FFE )

			{

				const ULONG		nImageSize = nAlignedWidth * rSize.Height();

				const USHORT	nColors = ( nBits <= 8 ) ? ( 1 << nBits ) : 0;



				MAC_Ptr pData = (MAC_Ptr) rtl_allocateZeroMemory( nImageSize );

			

				if( pData ) 

				{

					Rect aRect;

					

					SetRect( &aRect, 0, 0, rSize.Width(), rSize.Height() );

				

					(**hPixMap).baseAddr = pData;

					(**hPixMap).rowBytes = nAlignedWidth | 0x8000;

					(**hPixMap).bounds = aRect;

					(**hPixMap).pmVersion = 0;

					(**hPixMap).packType = 0;

					(**hPixMap).packSize = 0;

					(**hPixMap).hRes = 0x00480000;

					(**hPixMap).vRes = 0x00480000;

					(**hPixMap).pixelSize = nDepth;

					(**hPixMap).planeBytes = 0;

					(**hPixMap).pmReserved = 0;



					if( nDepth <= 8 ) 

					{

						const USHORT	nMinCount = Min( nColors, rPal.GetEntryCount() );

						USHORT			nVal;

						CTabHandle		hCTab = (CTabHandle) NewHandle( sizeof ( ColorTable ) + 

																		sizeof ( ColorSpec ) * ( nColors - 1 ) );



						(**hCTab).ctSeed = GetCTSeed();

						(**hCTab).ctFlags = 0;

						(**hCTab).ctSize = nColors - 1;



						for( USHORT i = 0; i < nMinCount; i++ )

						{

							const BitmapColor& rColor = rPal[ i ];



							(**hCTab).ctTable[i].value = (short) i;



							nVal = rColor.GetRed();

							(**hCTab).ctTable[i].rgb.red = ( nVal << 8 ) | nVal;



							nVal = rColor.GetGreen();

							(**hCTab).ctTable[i].rgb.green = ( nVal << 8 ) | nVal ;



							nVal = rColor.GetBlue();

							(**hCTab).ctTable[i].rgb.blue = ( nVal << 8 ) | nVal;

						}



						(**hPixMap).pixelType = 0;

						(**hPixMap).cmpCount = 1;

						(**hPixMap).cmpSize = nDepth;

						(**hPixMap).pmTable = hCTab;

					} 

					else 

					{

						CTabHandle hCTab = (CTabHandle) NewHandle( sizeof( ColorTable ) - sizeof( CSpecArray ) );



						(**hPixMap).pixelType = RGBDirect;

						(**hPixMap).cmpCount = 3;       

						

						if( nDepth == 16)

							(**hPixMap).cmpSize = 5;

						else

							(**hPixMap).cmpSize = 8;



						(**hCTab).ctSeed = 3 * (**hPixMap).cmpSize;

						(**hCTab).ctFlags = 0;

						(**hCTab).ctSize = 0;



						(**hPixMap).pmTable = hCTab;

					}

				}

				else

				{

					DisposeHandle( (Handle) hPixMap );

					hPixMap = 0;

				}

			} 

			else

			{

				DisposeHandle( (Handle) hPixMap );

				hPixMap = 0;

			}

		}

	}



	return hPixMap;

}



// ------------------------------------------------------------------



BitmapBuffer* SalBitmap::AcquireBuffer( BOOL bReadOnly )

{

	BitmapBuffer* pBuffer = NULL;



	if( mhPixMap )

	{

		HLock( (Handle) mhPixMap );



		const USHORT nCmpCount = (**mhPixMap).cmpCount;

		const USHORT nCmpSize = (**mhPixMap).cmpSize;

		USHORT nBits;



		pBuffer = new BitmapBuffer;

		pBuffer->mnFormat = BMP_FORMAT_TOP_DOWN;



		if( nCmpCount == 1 )

		{

			switch( nBits = nCmpSize )

			{

				case( 1 ): pBuffer->mnFormat |= BMP_FORMAT_1BIT_MSB_PAL; break;

				case( 4 ): pBuffer->mnFormat |= BMP_FORMAT_4BIT_MSN_PAL; break;

				case( 8 ): pBuffer->mnFormat |= BMP_FORMAT_8BIT_PAL; break;



				default:

				break;

			}

		}

		else if( nCmpSize == 5 )

		{

			pBuffer->mnFormat |= BMP_FORMAT_16BIT_TC_MASK;

			pBuffer->maColorMask = ColorMask( 0x7b00, 0x03e0, 0x001f);

			nBits = 16;

		}

		else if( nCmpSize == 8 )

		{

			pBuffer->mnFormat |= BMP_FORMAT_32BIT_TC_ARGB;

			nBits = 32;

		}



		if( BMP_SCANLINE_FORMAT( pBuffer->mnFormat ) )

		{

			pBuffer->mnWidth = maSize.Width();

			pBuffer->mnHeight = maSize.Height();

			pBuffer->mnScanlineSize = AlignedWidth4Bytes( maSize.Width() * nBits );

			pBuffer->mnBitCount = ( nBits <= 8 ) ? nBits : 24;



			if( pBuffer->mnBitCount <= 8 )

			{

				CTabHandle		hCTab = (**mhPixMap).pmTable;

				const USHORT	nColors = (**hCTab).ctSize + 1;

				BitmapPalette&	rPal = pBuffer->maPalette;

				

				rPal.SetEntryCount( nColors );



				for( USHORT i = 0; i < nColors; i++ )

				{

					BitmapColor& rCol = rPal[ i ];



					rCol.SetRed( (BYTE) ( (**hCTab).ctTable[i].rgb.red >> 8 ) );

					rCol.SetGreen( (BYTE) ( (**hCTab).ctTable[i].rgb.green >> 8 ) );

					rCol.SetBlue( (BYTE) ( (**hCTab).ctTable[i].rgb.blue >> 8 ) );

				}

			}



			pBuffer->mpBits = (HPBYTE) (**mhPixMap).baseAddr;

		}

		else

		{

			HUnlock( (Handle) mhPixMap );

			delete pBuffer;

			pBuffer = NULL;

		}

	}



	return pBuffer;

}



// ------------------------------------------------------------------



void SalBitmap::ReleaseBuffer( BitmapBuffer* pBuffer, BOOL bReadOnly )

{

	if( pBuffer )

	{

		if( mhPixMap )

		{

			if( !bReadOnly && !!pBuffer->maPalette )

			{

				CTabHandle				hCTab = (**mhPixMap).pmTable;

				const BitmapPalette&	rPal = pBuffer->maPalette;

				const USHORT			nMinCount = Min( (**hCTab).ctSize + 1, rPal.GetEntryCount() );

				USHORT					nVal;



				for( USHORT i = 0; i < nMinCount; i++ )

				{

					const BitmapColor& rColor = rPal[ i ];



					(**hCTab).ctTable[i].value = (short) i;



					nVal = rColor.GetRed();

					(**hCTab).ctTable[i].rgb.red = ( nVal << 8 ) | nVal;



					nVal = rColor.GetGreen();

					(**hCTab).ctTable[i].rgb.green = ( nVal << 8 ) | nVal ;



					nVal = rColor.GetBlue();

					(**hCTab).ctTable[i].rgb.blue = ( nVal << 8 ) | nVal;

				}

			}



			HUnlock( (Handle) mhPixMap );

		}



		delete pBuffer;

	}

}

