/*************************************************************************
 *
 *	$RCSfile: rmprint.cxx,v $
 *
 *	$Revision: 1.13 $
 *
 *	last change: $Author: hr $ $Date: 2002/03/19 11:12:03 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/debug.hxx>
#include <svdata.hxx>
#include <svapp.hxx>
#include <event.hxx>
#include <print.h>
#include <vos/thread.hxx>
#include <vos/process.hxx>
#include "rmprint.hxx"
#include <unotools/atom.hxx>
#include <jobset.hxx>
#include <jobset.h>
#include <com/sun/star/portal/client/Orientation.hpp>

using namespace ::com::sun::star::uno;

// -----------------------------------------------------------------------

class ImplRmPrinterChangedClass
{
  public:

	DECL_STATIC_LINK( ImplRmPrinterChangedClass, CallEvent, void* pEvent );
};

// -----------------------------------------------------------------------

IMPL_STATIC_LINK( ImplRmPrinterChangedClass, CallEvent, void*, pEvent )
{
	::vos::OGuard guard( Application::GetSolarMutex() );

	ImplDeletePrnQueueList();

    CHECK_FOR_RVPSYNC_NORMAL();
    ImplSVData* pSVData = ImplGetSVData();
    try
    {
        *pSVData->mpPrinterEnvironment = pSVData->mxRmPrinterEnvironment->GetPrinterEnvironment();
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
    }

	Application* pApp = GetpApp();
	DataChangedEvent aDCEvt( DATACHANGED_PRINTER );
	pApp->DataChanged( aDCEvt );
	pApp->NotifyAllWindows( aDCEvt );
	delete (ApplicationEvent*)pEvent;

	return 0;
}

// -----------------------------------------------------------------------

void ORmPrinterObserver::PrinterSettingsChanged() throw()
{
	ApplicationEvent*	pEvent = 0;
	String				sEmptyString;

	pEvent = new ApplicationEvent( sEmptyString, sEmptyString, "PRINTERCHANGED", sEmptyString );
	Application::PostUserEvent( STATIC_LINK( NULL, ImplRmPrinterChangedClass, CallEvent ), pEvent );
}

// -------------
// - RmPrinter -
// -------------

void RmPrinter::CreateInfoInstance( const NMSP_CLIENT::RmQueueInfo& rRmQueueInfo, NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );

	if( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemotePrinter->CreateInfoInstance( rRmQueueInfo, rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

void RmPrinter::CreatePrintInstance( const NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );

	if( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemotePrinter->CreatePrintInstance( rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

BOOL RmPrinter::SetJobSetup( NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxRemotePrinter->SetJobSetup( rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return FALSE;
        }
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------------

BOOL RmPrinter::SetOrientation( USHORT nOrientation, NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxRemotePrinter->SetOrientation( nOrientation, rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return FALSE;
        }
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------------

BOOL RmPrinter::SetPaperBin( USHORT nPaperBin, NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxRemotePrinter->SetPaperBin( nPaperBin, rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return FALSE;
        }
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------------

BOOL RmPrinter::SetPaper( USHORT nPaper, NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxRemotePrinter->SetPaper( nPaper, rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return FALSE;
        }
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------------

BOOL RmPrinter::SetPaperSizeUser( long nWidth, long nHeight, NMSP_CLIENT::RmJobSetup& rRmJobSetup )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxRemotePrinter->SetPaperSizeUser( nWidth, nHeight, rRmJobSetup );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return FALSE;
        }
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------------

void RmPrinter::GetPageInfo( long& rOutWidth, long& rOutHeight, long& rPageOffX, long& rPageOffY,
							 long& rPageWidth, long& rPageHeight )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );

	if( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemotePrinter->GetPageInfo( rOutWidth, rOutHeight, rPageOffX, rPageOffY, rPageWidth, rPageHeight );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            rOutWidth = rOutHeight = rPageOffX = rPageOffY = rPageWidth = rPageHeight = 0;
        }
	}
}

// -----------------------------------------------------------------------------

USHORT RmPrinter::GetPaperBinCount()
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );

	if ( !maPaperBins.getLength() && mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    maPaperBins = mxRemotePrinter->GetPaperBins();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
    return maPaperBins.getLength();
}

// -----------------------------------------------------------------------------

OUSTRING RmPrinter::GetPaperBinName( USHORT nPaperBin )
{
	DBG_ASSERT( mxRemotePrinter.is(), "XRmPrinter object is _not_ valid!" );

	if ( ! maPaperBins.getLength() && mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    maPaperBins = mxRemotePrinter->GetPaperBins();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
    return nPaperBin < maPaperBins.getLength() ? ::rtl::OUString( maPaperBins.getConstArray()[nPaperBin] ) : ::rtl::OUString();
}

// -----------------------------------------------------------------------------

unsigned long RmPrinter::GetCapabilities( USHORT nType )
{
	DBG_ASSERT( mxRemotePrinter.is() , "XRmPrinter is not valid" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxRemotePrinter->GetCapabilities( nType );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return 0;
        }
	}
	else
		return 0;
}

// -----------------------------------------------------------------------------

void RmPrinter::UserSetup( const REF( NMSP_CLIENT::XRmFrameWindow )& xParent, sal_uInt32 EventID )
{
	DBG_ASSERT( mxRemotePrinter.is() , "XRmPrinter is not valid" );
	if ( mxRemotePrinter.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemotePrinter->UserSetup( xParent, EventID );
            // user setup may invalidate bin list
            maPaperBins = Sequence< ::rtl::OUString >();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

JobSetup& JobSetup::operator=( const NMSP_CLIENT::RmJobSetup& rJS )
{
	if ( mpData )
	{
		if ( mpData->mnRefCount == 1 )
			delete mpData;
		else
			mpData->mnRefCount--;
	}

    mpData = new ImplJobSetup();

    mpData->mnRefCount		= 1;
    mpData->mnSystem		= rJS.System;
    mpData->maPrinterName	= rJS.PrinterName;
    mpData->maDriver		= rJS.Driver;
    mpData->meOrientation	= rJS.Orientation == ::com::sun::star::portal::client::Orientation::PORTRAIT ? ORIENTATION_PORTRAIT : ORIENTATION_LANDSCAPE;
    mpData->mnPaperBin		= rJS.PaperBin;
    mpData->mePaperFormat	= rJS.Paper;
    mpData->mnPaperWidth	= rJS.PaperWidth;
    mpData->mnPaperHeight	= rJS.PaperHeight;
    mpData->mnDriverDataLen	= rJS.DriverData.getLength();
    if( mpData->mnDriverDataLen )
    {
        mpData->mpDriverData	= new BYTE[ mpData->mnDriverDataLen ];
        memcpy( mpData->mpDriverData, rJS.DriverData.getConstArray(), mpData->mnDriverDataLen );
    }
    else
        mpData->mpDriverData = NULL;

    return *this;
}

void JobSetup::SetRmJobSetup( NMSP_CLIENT::RmJobSetup& rRmJobSetup ) const
{
    rRmJobSetup.System		= mpData->mnSystem;
    rRmJobSetup.PrinterName	= mpData->maPrinterName;
    rRmJobSetup.Driver		= mpData->maDriver;
    rRmJobSetup.Orientation	= mpData->meOrientation == ORIENTATION_PORTRAIT ? ::com::sun::star::portal::client::Orientation::PORTRAIT : ::com::sun::star::portal::client::Orientation::LANDSCAPE;
    rRmJobSetup.PaperBin	= mpData->mnPaperBin;
    rRmJobSetup.Paper		= mpData->mePaperFormat;
    rRmJobSetup.PaperWidth	= mpData->mnPaperWidth;
    rRmJobSetup.PaperHeight	= mpData->mnPaperHeight;
    if( mpData->mnDriverDataLen )
        rRmJobSetup.DriverData	= Sequence< sal_Int8 >( (sal_Int8*)mpData->mpDriverData, mpData->mnDriverDataLen );
    else
        rRmJobSetup.DriverData = Sequence< sal_Int8 >();
}

// -----------------------------------------------------------------------------------

RmPageRequestor::~RmPageRequestor()
{
}

// -----------------------------------------------------------------------------------

NMSP_CLIENT::RmJobSetup SAL_CALL RmPageRequestor::requestJobSetup( sal_uInt32 nPage ) throw()
{
    NMSP_CLIENT::RmJobSetup aSetup;

    m_pPrinter->GetRemotePageSetup( nPage, aSetup );
    return aSetup;
}

// -----------------------------------------------------------------------------------

void SAL_CALL RmPageRequestor::requestPage( sal_uInt32 nPage ) throw()
{
    Application::PostUserEvent( LINK( this, RmPageRequestor, PrintPageHdl ), (void*)nPage );
}

// -----------------------------------------------------------------------------------

IMPL_LINK( RmPageRequestor, PrintPageHdl, void*, nPage )
{
    m_pPrinter->PrintRemotePage( (ULONG)nPage );
    return 0;
}

// -----------------------------------------------------------------------------------

void SAL_CALL RmPageRequestor::requestCompleted() throw()
{
    m_bCompleted = true;
}
