/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.ClassElementFilter;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.util.WeakListener;

public class ClassChildren
extends Children.Keys
implements FilterCookie {
    private static int PPP_MASK = 7;
    protected static HashMap propToFilter;
    private static Comparator comparator;
    protected ClassElement element;
    protected ClassElementFilter filter;
    protected ElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private ElementListener propL;
    protected Collection[] cpl;
    private boolean nodesInited = false;
    static /* synthetic */ Class class$org$openide$src$nodes$ClassElementFilter;
    static /* synthetic */ Class class$org$openide$src$MemberElement;

    public ClassChildren(ClassElement classElement) {
        this(DefaultFactory.READ_WRITE, classElement);
    }

    public ClassChildren(ElementNodeFactory elementNodeFactory, ClassElement classElement) {
        this.element = classElement;
        this.factory = elementNodeFactory;
        this.filter = null;
    }

    public Class getFilterClass() {
        return class$org$openide$src$nodes$ClassElementFilter == null ? (class$org$openide$src$nodes$ClassElementFilter = ClassChildren.class$("org.openide.src.nodes.ClassElementFilter")) : class$org$openide$src$nodes$ClassElementFilter;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof ClassElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (ClassElementFilter)object;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        this.refreshAllKeys();
        if (this.wPropL == null) {
            this.propL = new ElementListener();
            this.wPropL = WeakListener.propertyChange(this.propL, this.element);
        }
        this.element.addPropertyChangeListener(this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    private Node hookNodeName(Node node) {
        MemberElement memberElement = (MemberElement)node.getCookie(class$org$openide$src$MemberElement == null ? (class$org$openide$src$MemberElement = ClassChildren.class$("org.openide.src.MemberElement")) : class$org$openide$src$MemberElement);
        if (memberElement != null) {
            memberElement.addPropertyChangeListener(this.wPropL);
        }
        return node;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof MethodElement) {
            return new Node[]{this.hookNodeName(this.factory.createMethodNode((MethodElement)object))};
        }
        if (object instanceof FieldElement) {
            return new Node[]{this.hookNodeName(this.factory.createFieldNode((FieldElement)object))};
        }
        if (object instanceof ConstructorElement) {
            return new Node[]{this.hookNodeName(this.factory.createConstructorNode((ConstructorElement)object))};
        }
        if (object instanceof ClassElement) {
            return new Node[]{this.hookNodeName(this.factory.createClassNode((ClassElement)object))};
        }
        if (object instanceof InitializerElement) {
            return new Node[]{this.hookNodeName(this.factory.createInitializerNode((InitializerElement)object))};
        }
        return new Node[0];
    }

    protected void refreshAllKeys() {
        this.cpl = new Collection[this.getOrder().length];
        this.refreshKeys(255);
    }

    protected void refreshKeys(int n) {
        int[] nArray = this.getOrder();
        LinkedList linkedList = new LinkedList();
        int n2 = 0;
        while (n2 < nArray.length) {
            if ((nArray[n2] & n) != 0 || this.cpl[n2] == null) {
                this.cpl[n2] = this.getKeysOfType(nArray[n2]);
                linkedList.addAll(this.cpl[n2]);
            } else {
                linkedList.addAll(this.cpl[n2]);
            }
            ++n2;
        }
        this.setKeys(linkedList);
    }

    protected Collection getKeysOfType(int n) {
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        if ((n & 0x40) != 0) {
            linkedList.add(this.element.getSuperclass());
        }
        if ((n & 0x80) != 0) {
            linkedList.addAll(Arrays.asList(this.element.getInterfaces()));
        }
        if ((n & 0x10) != 0) {
            this.filterModifiers(this.element.getFields(), linkedList);
        }
        if ((n & 8) != 0) {
            this.filterModifiers(this.element.getConstructors(), linkedList);
            linkedList.addAll(Arrays.asList(this.element.getInitializers()));
        }
        if ((n & 0x20) != 0) {
            this.filterModifiers(this.element.getMethods(), linkedList);
        }
        if ((n & 6) != 0) {
            this.filterClassModifiers(this.element.getClasses(), linkedList, n);
        }
        if (this.filter == null || this.filter.isSorted()) {
            Collections.sort(linkedList, comparator);
        }
        return linkedList;
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? ClassElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    private int getModifierFilter() {
        if (this.filter == null) {
            return 65543;
        }
        return this.filter.getModifiers();
    }

    private void filterModifiers(MemberElement[] memberElementArray, Collection collection) {
        int n = this.getModifierFilter();
        int n2 = memberElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = memberElementArray[n3].getModifiers();
            if ((n4 & PPP_MASK) == 0) {
                n4 += 65536;
            }
            if ((n4 & n) != 0) {
                collection.add(memberElementArray[n3]);
            }
            ++n3;
        }
    }

    private void filterClassModifiers(ClassElement[] classElementArray, Collection collection, int n) {
        int n2 = this.getModifierFilter();
        int n3 = classElementArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = classElementArray[n4].getModifiers();
            if ((n5 & PPP_MASK) == 0) {
                n5 += 65536;
            }
            if ((n5 & n2) != 0) {
                if (classElementArray[n4].isClass()) {
                    if ((n & 2) != 0) {
                        collection.add(classElementArray[n4]);
                    }
                } else if ((n & 4) != 0) {
                    collection.add(classElementArray[n4]);
                }
            }
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof MemberElement) {
                    if (object2 instanceof MemberElement) {
                        return ((MemberElement)object).getName().getName().compareToIgnoreCase(((MemberElement)object2).getName().getName());
                    }
                    return -1;
                }
                if (object2 instanceof MemberElement) {
                    return 1;
                }
                return 0;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("classes", new Integer(6));
        propToFilter.put("methods", new Integer(32));
        propToFilter.put("fields", new Integer(16));
        propToFilter.put("constructors", new Integer(8));
        propToFilter.put("initializers", new Integer(8));
    }

    private final class ElementListener
    implements PropertyChangeListener {
        private ElementListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n;
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object != ClassChildren.this.element) {
                if (!(object instanceof MemberElement) || string != null && "name" != string) return;
                n = object instanceof MethodElement ? 32 : (object instanceof ConstructorElement ? 8 : (object instanceof FieldElement ? 16 : 6));
            } else {
                Integer n2 = (Integer)propToFilter.get(string);
                if (n2 == null) {
                    return;
                }
                n = n2;
            }
            ClassChildren.this.refreshKeys(n);
        }
    }
}

