/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.XYDataPair;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class XYSeriesCollection
extends AbstractSeriesDataset
implements XYDataset {
    private List data = new ArrayList();

    public XYSeriesCollection() {
    }

    public XYSeriesCollection(XYSeries xYSeries) {
        if (xYSeries != null) {
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
        }
    }

    public void addSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataPair xYDataPair = xYSeries.getDataPair(n2);
        return xYDataPair.getX();
    }

    public Number getYValue(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataPair xYDataPair = xYSeries.getDataPair(n2);
        return xYDataPair.getY();
    }

    public void removeAllSeries() {
        int n = 0;
        while (n < this.data.size()) {
            XYSeries xYSeries = (XYSeries)this.data.get(n);
            xYSeries.removeChangeListener(this);
            ++n;
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            this.data.remove(xYSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }
}

