/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SecondaryQueryInputServlet.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:37:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public final class SecondaryQueryInputServlet extends HttpServlet {
  public void service(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
      SearchState state = SearchState.getSearchState(request);
      String lastQuery = state.getLastQuery();
      response.setContentType("text/html");
      PrintWriter out = response.getWriter();
      out.write("<html><head></head><body bgcolor=\"#CCCCCC\">");
      out.write("<form method=POST action=\"/servlet/search\" target=\"_top\">");
      out.write("<input type=text name=\"query\"");
      if (lastQuery != null) {
	out.write(" value=\"");
	out.write(lastQuery);
	out.write('"');
      }
      out.write(">&nbsp;<nobr><input type=submit value=\"search\"><br>");
      out.write("<input type=submit name=\"goback\" value=\"refine context\">");
      out.write("</form></body></html>");
      out.close();
  }
}
