/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: PrefixTranslator.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:49:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

import java.util.Hashtable;
import java.util.Enumeration;

public final class PrefixTranslator {
    private Hashtable _transTable = new Hashtable();
    private String[] _prefixArray = null;
  
    public static PrefixTranslator makePrefixTranslator(String[] table) {
	PrefixTranslator result = null;
	if (table != null && table.length > 0) {
	    result = new PrefixTranslator();
	    for (int i = 0; i < table.length; )
		result.addPrefixTranslation(table[i++], table[i++]);
	}
	return result;
    }

    public void addPrefixTranslation(String prefix, String replacement) {
	if (_transTable.get(prefix) != null)
	    System.err.println("prefix already known: " + prefix);
	_transTable.put(prefix, replacement);
	sortPrefixes();
    }

    public String translatePrefix(String input) {
	for (int i = 0; i < _prefixArray.length; i++)
	    if (input.startsWith(_prefixArray[i]))
		return (String)_transTable.get(_prefixArray[i]) +
		    input.substring(_prefixArray[i].length());
	return input;
    }

    private void sortPrefixes() {
	if (_transTable.size() > 0)
	    _prefixArray = new String[_transTable.size()];
	int k = 0;
	for (Enumeration keys = _transTable.keys(); keys.hasMoreElements(); )
	    _prefixArray[k++] = (String)keys.nextElement();
	for (int i = 0; i < k - 1; i++)
	    for (int j = i + 1; j < k; j++)
		if (_prefixArray[j].length() > _prefixArray[i].length()) {
		    String temp = _prefixArray[j];
		    _prefixArray[j] = _prefixArray[i];
		    _prefixArray[i] = temp;
		}
    }
}
