/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SearchEngineEntry.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:02:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import net.jini.entry.AbstractEntry;

public class SearchEngineEntry extends AbstractEntry {
    public String _name;
    public XmlSearchServer _server;

    public SearchEngineEntry() {}

    // for creating templates
    public SearchEngineEntry(String name) {
	_name = name;
	_server = null;
    }

    public SearchEngineEntry(XmlSearchServer server) {
	super();
	try {
	    _name = server.getName();
	    _server = server;
	}
	catch (Exception e) {
	    e.printStackTrace();
	    _name = "***Error***";
	}
    }
  
    public XmlSearchServer getServer() {
	return _server;
    }
  
    public String toString() {
	return _name;
    }
}
