/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: it_builtin.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:53:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDL_IT_BUILTIN_HXX
#define ARY_IDL_IT_BUILTIN_HXX



// USED SERVICES
    // BASE CLASSES
#include "it_named.hxx"
    // COMPONENTS
    // PARAMETERS


namespace ary
{
namespace idl
{



/** A type defined by the IDL language.
*/
class BuiltInType : public Named_Type
{
  public:
    enum E_ClassId { class_id = 2200 };

    // LIFECYCLE
                        BuiltInType(
                            const char *        i_sName );
    virtual             ~BuiltInType();

  private:
    // Interface RepositoryEntity:
    virtual void        do_Visit( Host & io_rHost ) const;
    virtual RCid        inq_ClassId() const;

    // Interface Type:
    virtual void        inq_Get_Text(
                            StringVector &      o_module,
                            String &            o_name,
                            Ce_id &             o_nRelatedCe,
                            int &               o_nSequenceCount,
                            const Gate &        i_rGate ) const;
};




}   // namespace idl
}   // namespace ary


#endif

