/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sto_locs.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:20:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <sto_locs.hxx>


// NOT FULLY DEFINED SERVICES
#include <ary/loc/loc_root.hxx>
#include <ary/loc/loc_dir.hxx>
#include <ary/loc/loc_file.hxx>
#include "t_storg.hxx"




namespace ary
{
namespace store
{



//************************          Locations_Impl         *******************//


struct Locations::Locations_Impl
{
                        Locations_Impl();
                        ~Locations_Impl();

    StdReStorage< ary::loc::LocationRoot >
                        aRoots;
    StdReStorage< ary::loc::SubDirectory >
                        aSubDirectories;
    StdReStorage< ary::loc::SourceCodeFile >
                        aFiles;
};

Locations::
Locations_Impl::Locations_Impl()
{
}

Locations::
Locations_Impl::~Locations_Impl()
{
}



//************************          Locations         *******************//

Locations::Locations()
    :   pi( new Locations_Impl )
{
}

Locations::~Locations()
{
}

ReStorage< ary::loc::LocationRoot > &
Locations::Roots()
{
 	return pi->aRoots;
}

ReStorage< ary::loc::SubDirectory > &
Locations::SubDirectories()
{
 	return pi->aSubDirectories;
}

ReStorage< ary::loc::SourceCodeFile > &
Locations::Files()
{
 	return pi->aFiles;
}




}   // namespace store
}   // namespace ary


