/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_apearcfg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:08:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#pragma hdrstop

#include "app.hrc"
#include "app.hxx"
#include "apearcfg.hxx"
#include "resid.hxx"
#include "optgdlg.hxx"
namespace binfilter {

#define DEFAULT_LOOKNFEEL   0
#define DEFAULT_DRAGMODE    2
#define DEFAULT_SNAPMODE    0
#define DEFAULT_SCALEFACTOR 100
#define DEFAULT_AAMINHEIGHT	8

using namespace ::rtl;
using namespace ::com::sun::star::uno;

sal_Bool OfaTabAppearanceCfg::bInitialized = sal_False;

/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/
/*N*/ OfaTabAppearanceCfg::OfaTabAppearanceCfg()
/*N*/ 	:ConfigItem(OUString::createFromAscii("Office.Common/View"))
/*N*/ 	,nLookNFeel			( DEFAULT_LOOKNFEEL )
/*N*/ 	,nDragMode			( DEFAULT_DRAGMODE )
/*N*/ 	,nSnapMode			( DEFAULT_SNAPMODE )
/*N*/     ,nMiddleMouse       ( MOUSE_MIDDLE_AUTOSCROLL )
/*N*/ 	,nScaleFactor ( DEFAULT_SCALEFACTOR )
/*N*/ 	,bMenuMouseFollow(FALSE)
/*N*/ 	,bSingleLineTabCtrl(FALSE)
/*N*/     ,bColoredTabCtrl(FALSE)
/*N*/ #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
/*N*/ 	,nAAMinPixelHeight	( DEFAULT_AAMINHEIGHT )
/*N*/ 	,bFontAntialiasing	( TRUE )
/*N*/ #endif
/*N*/ {
/*N*/     const Sequence<OUString>& rNames = GetPropertyNames();
/*N*/     Sequence<Any> aValues = GetProperties(rNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/     DBG_ASSERT(aValues.getLength() == rNames.getLength(), "GetProperties failed")
/*N*/ 
/*N*/ 	if(aValues.getLength() == rNames.getLength())
/*N*/ 	{
/*N*/         for(int nProp = 0; nProp < rNames.getLength(); ++nProp, ++pValues)
/*N*/ 		{
/*N*/ 			if(pValues->hasValue())
/*N*/ 			{
/*N*/ 				switch(nProp)
/*N*/ 				{
/*N*/                     case  0: *pValues >>= nScaleFactor; break; //"FontScaling",
/*N*/                     case  1: *pValues >>= nLookNFeel; break;  //"LookAndFeel",
/*N*/                     case  2: *pValues >>= nDragMode; break;   //"Window/Drag",
/*N*/                     case  3: bMenuMouseFollow = *(sal_Bool*)pValues->getValue(); break; //"Menu/FollowMouse",
/*N*/                     case  4: bSingleLineTabCtrl      = *(sal_Bool*)pValues->getValue(); break; //"Dialog/SingleLineTab",
/*N*/                     case  5: bColoredTabCtrl = *(sal_Bool*)pValues->getValue(); break; //"Dialog/ColoredTab",
/*N*/                     case  6: *pValues >>= nSnapMode; break; //"Dialog/MousePositioning",
/*N*/                     case  7: *pValues >>= nMiddleMouse; break; //"Dialog/MiddleMouseButton",
/*N*/ #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
/*N*/                     case  8: bFontAntialiasing = *(sal_Bool*)pValues->getValue(); break;    // "FontAntialising/Enabled",
/*N*/                     case  9: *pValues >>= nAAMinPixelHeight; break;                         // "FontAntialising/MinPixelHeight",
/*N*/ #endif
/*N*/                 }
/*N*/ 			}
/*N*/ 		}
/*N*/     }
/*N*/ }
/* -----------------------------22.05.01 11:53--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ OfaTabAppearanceCfg::~OfaTabAppearanceCfg( )
/*N*/ {
/*N*/ }
/* -----------------------------22.05.01 11:54--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ const Sequence<OUString>& OfaTabAppearanceCfg::GetPropertyNames()
/*N*/ {
/*N*/     static Sequence<OUString> aNames;
/*N*/     if(!aNames.getLength())
/*N*/     {
/*N*/         static const sal_Char* aPropNames[] =
/*N*/         {
/*N*/              "FontScaling"                       //  0
/*N*/             ,"LookAndFeel"                       //  1
/*N*/             ,"Window/Drag"                       //  2
/*N*/             ,"Menu/FollowMouse"                  //  3
/*N*/             ,"Dialog/SingleLineTab"              //  4
/*N*/             ,"Dialog/ColoredTab"                 //  5
/*N*/             ,"Dialog/MousePositioning"           //  6
/*N*/             ,"Dialog/MiddleMouseButton"          //  7
/*N*/ #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
/*N*/             ,"FontAntiAliasing/Enabled"         //  8
/*N*/             ,"FontAntiAliasing/MinPixelHeight"  //  9
/*N*/ #endif
/*N*/         };
/*N*/         const int nCount = sizeof( aPropNames ) / sizeof( aPropNames[0] );
/*N*/         aNames.realloc(nCount);
/*N*/ 
/*N*/ 		const sal_Char** pAsciiNames = aPropNames;
/*N*/         OUString* pNames = aNames.getArray();
/*N*/         for(int i = 0; i < nCount; ++i, ++pNames, ++pAsciiNames)
/*N*/             *pNames = OUString::createFromAscii( *pAsciiNames );
/*N*/     }
/*N*/     return aNames;
/*N*/ }
/* -----------------------------22.05.01 11:54--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void  OfaTabAppearanceCfg::Commit()
//STRIP001 {
//STRIP001     const Sequence<OUString>& rNames = GetPropertyNames();
//STRIP001     const OUString* pNames = rNames.getConstArray();
//STRIP001     Sequence<Any> aValues(rNames.getLength());
//STRIP001 	Any* pValues = aValues.getArray();
//STRIP001 
//STRIP001 	const Type& rType = ::getBooleanCppuType();
//STRIP001     for(int nProp = 0; nProp < rNames.getLength(); nProp++)
//STRIP001 	{
//STRIP001 		switch(nProp)
//STRIP001 		{
//STRIP001             case  0: pValues[nProp] <<= nScaleFactor; break;            // "FontScaling",
//STRIP001             case  1: pValues[nProp] <<= nLookNFeel; break;              //"LookAndFeel",
//STRIP001             case  2: pValues[nProp] <<= nDragMode; break;               //"Window/Drag",
//STRIP001             case  3: pValues[nProp].setValue(&bMenuMouseFollow, rType); break; //"Menu/FollowMouse",
//STRIP001             case  4: pValues[nProp].setValue(&bSingleLineTabCtrl, rType); break; //"Dialog/SingleLineTab",
//STRIP001             case  5: pValues[nProp].setValue(&bColoredTabCtrl, rType); break; //"Dialog/ColoredTab",
//STRIP001             case  6: pValues[nProp] <<= nSnapMode; break;               //"Dialog/MousePositioning",
//STRIP001             case  7: pValues[nProp] <<= nMiddleMouse; break;               //"Dialog/MiddleMouseButton",
//STRIP001 #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
//STRIP001             case  8: pValues[nProp].setValue(&bFontAntialiasing, rType); break; // "FontAntialising/Enabled",
//STRIP001             case  9: pValues[nProp] <<= nAAMinPixelHeight; break;               // "FontAntialising/MinPixelHeight",
//STRIP001 #endif
//STRIP001         }
//STRIP001 	}
//STRIP001     PutProperties(rNames, aValues);
//STRIP001 }
/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void OfaTabAppearanceCfg::SetLookNFeel ( USHORT nSet )
//STRIP001 {
//STRIP001 	nLookNFeel = nSet;
//STRIP001     SetModified();
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void OfaTabAppearanceCfg::SetDragMode  ( USHORT nSet )
//STRIP001 {
//STRIP001 	nDragMode = nSet;
//STRIP001     SetModified();
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void OfaTabAppearanceCfg::SetScaleFactor ( USHORT nSet )
//STRIP001 {
//STRIP001 	nScaleFactor = nSet;
//STRIP001     SetModified();
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void OfaTabAppearanceCfg::SetSnapMode ( USHORT nSet )
//STRIP001 {
//STRIP001 	nSnapMode = nSet;
//STRIP001     SetModified();
//STRIP001 }
/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/
//STRIP001 void OfaTabAppearanceCfg::SetMiddleMouseButton ( USHORT nSet )
//STRIP001 {
//STRIP001     nMiddleMouse = nSet;
//STRIP001     SetModified();
//STRIP001 }
/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ void OfaTabAppearanceCfg::SetApplicationDefaults ( Application* pApp )
/*N*/ {
/*N*/ 	AllSettings   hAppSettings = pApp->GetSettings();
/*N*/ 	StyleSettings hAppStyle    = hAppSettings.GetStyleSettings();
/*N*/ 
/*N*/ 	// Look & Feel
/*N*/ 
/*N*/ 	// SetStandard...Styles() resets the UseSystemUIFonts flag,
/*N*/ 	// but we don't want to change it now, so save the flag before ...
/*N*/ 	BOOL bUseSystemUIFonts = hAppStyle.GetUseSystemUIFonts();
/*N*/ 
/*N*/ 	switch ( nLookNFeel )
/*N*/ 	{
/*N*/ 		case LookMotif:
/*N*/ 			hAppStyle.SetStandardUnixStyles();	break;
/*N*/ 
/*N*/ 		case LookOSTwo:
/*N*/ 			hAppStyle.SetStandardOS2Styles();	break;
/*N*/ 
/*N*/ 		case LookMacintosh:
/*N*/ 			hAppStyle.SetStandardMacStyles();	break;
/*N*/ 
/*N*/ 		case LookWindows:
/*N*/ 			hAppStyle.SetStandardWinStyles();	break;
/*N*/ 
/*N*/ 		case LookStardivision:
/*N*/ 		default:
/*N*/ 			hAppStyle.SetStandardStyles();		break;
/*N*/ 	}
/*N*/ 
/*N*/ 	// and set it here
/*N*/ 	hAppStyle.SetUseSystemUIFonts( bUseSystemUIFonts );
/*N*/ 
/*N*/ 	// Screen and ScreenFont Scaling
/*N*/ 
/*N*/ 	hAppStyle.SetScreenZoom( nScaleFactor );
/*N*/ 	hAppStyle.SetScreenFontZoom( nScaleFactor );
/*N*/ 
/*N*/ #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
/*N*/ 	// font anti aliasing
/*N*/ 	hAppStyle.SetAntialiasingMinPixelHeight( nAAMinPixelHeight );
/*N*/ 	hAppStyle.SetDisplayOptions( bFontAntialiasing ? 0 : DISPLAY_OPTION_AA_DISABLE );
/*N*/ #endif

	// Mouse Snap

/*N*/ 	MouseSettings hMouseSettings = hAppSettings.GetMouseSettings();
/*N*/ 	ULONG         nMouseOptions  = hMouseSettings.GetOptions();

/*N*/ 	nMouseOptions &=  ! (MOUSE_OPTION_AUTOCENTERPOS | MOUSE_OPTION_AUTODEFBTNPOS);

/*N*/ 	switch ( nSnapMode )
/*N*/ 	{
/*N*/ 	case SnapToButton:
/*?*/ 		nMouseOptions |= MOUSE_OPTION_AUTODEFBTNPOS;
/*N*/ 		break;
/*N*/ 	case SnapToMiddle:
/*?*/ 		nMouseOptions |= MOUSE_OPTION_AUTOCENTERPOS;
/*N*/ 		break;
/*N*/ 	case NoSnap:
/*N*/ 	default:
/*N*/ 		break;
/*N*/ 	}
/*N*/     hMouseSettings.SetOptions(nMouseOptions);
/*N*/     hMouseSettings.SetMiddleButtonAction(nMiddleMouse);

    // Merge and Publish Settings

/*N*/     ULONG nFollow = hMouseSettings.GetFollow();
/*N*/     if(bMenuMouseFollow)
/*N*/         nFollow |= MOUSE_FOLLOW_MENU;
/*N*/     else
/*?*/         nFollow &= ~MOUSE_FOLLOW_MENU;
/*N*/     hMouseSettings.SetFollow( nFollow );
/*N*/     sal_uInt16 nTabStyle = 0;
/*N*/     if(bSingleLineTabCtrl)
/*?*/         nTabStyle |= STYLE_TABCONTROL_SINGLELINE;
/*N*/ 
/*N*/     if(bColoredTabCtrl)
/*N*/         nTabStyle |= STYLE_TABCONTROL_COLOR;
/*N*/     hAppStyle.SetTabControlStyle(nTabStyle);
/*N*/ 
/*N*/ 
/*N*/     hAppSettings.SetMouseSettings( hMouseSettings );
/*N*/ 
/*N*/ 	hAppSettings.SetStyleSettings( hAppStyle );
/*N*/ 	pApp->MergeSystemSettings    ( hAppSettings );      // Allow system-settings to apply
/*N*/ 	pApp->SystemSettingsChanging ( hAppSettings, NULL );// Allow overruling of system-settings
/*N*/ 														//is concerned with window drag
/*N*/ 
/*N*/ 	pApp->SetSettings ( hAppSettings );
/*N*/ }



}
