/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_consdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:55:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes ---------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// auto strip #include <bf_sfx2/dispatch.hxx>

// INCLUDE -------------------------------------------------------------------

// auto strip #include "tabvwsh.hxx"
// auto strip #include "uiitems.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "reffact.hxx"
// auto strip #include "document.hxx"
// auto strip #include "scresid.hxx"

#include "globstr.hrc"
#include "consdlg.hrc"

#define _CONSDLG_CXX
// auto strip #include "consdlg.hxx"
#undef _CONSDLG_CXX

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
namespace binfilter {

#define INFOBOX(id) InfoBox(this, ScGlobal::GetRscString(id)).Execute()

//============================================================================
//	class ScAreaData

//STRIP001 class ScAreaData
//STRIP001 {
//STRIP001 public:
//STRIP001 	ScAreaData()  {}
//STRIP001 	~ScAreaData() {}
//STRIP001 
//STRIP001 	void Set( const String& rName, const String& rArea, BOOL bDb )
//STRIP001 				{
//STRIP001 					aStrName  = rName;
//STRIP001 					aStrArea  = rArea;
//STRIP001 					bIsDbArea = bDb;
//STRIP001 				}
//STRIP001 
//STRIP001 	String	aStrName;
//STRIP001 	String	aStrArea;
//STRIP001 	BOOL	bIsDbArea;
//STRIP001 };


//============================================================================
//	class ScConsolidateDialog


//STRIP001 ScConsolidateDlg::ScConsolidateDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
//STRIP001 									const SfxItemSet&	rArgSet )
//STRIP001 
//STRIP001 	:	ScAnyRefDlg	( pB, pCW, pParent, RID_SCDLG_CONSOLIDATE ),
//STRIP001 		//
//STRIP001 		aFtFunc			( this, ScResId( FT_FUNC ) ),
//STRIP001 		aLbFunc			( this, ScResId( LB_FUNC ) ),
//STRIP001 
//STRIP001 		aFtConsAreas	( this, ScResId( FT_CONSAREAS ) ),
//STRIP001 		aLbConsAreas	( this, ScResId( LB_CONSAREAS ) ),
//STRIP001 
//STRIP001 		aFtDataArea		( this, ScResId( FT_DATA_AREA ) ),
//STRIP001 		aLbDataArea		( this, ScResId( LB_DATA_AREA ) ),
//STRIP001 		aEdDataArea		( this, ScResId( ED_DATA_AREA ) ),
//STRIP001 		aRbDataArea		( this, ScResId( RB_DATA_AREA ), &aEdDataArea ),
//STRIP001 
//STRIP001 		aFtDestArea		( this, ScResId( FT_DEST_AREA ) ),
//STRIP001 		aLbDestArea		( this, ScResId( LB_DEST_AREA ) ),
//STRIP001 		aEdDestArea		( this, ScResId( ED_DEST_AREA ) ),
//STRIP001 		aRbDestArea		( this, ScResId( RB_DEST_AREA ), &aEdDestArea ),
//STRIP001 
//STRIP001         aFlConsBy       ( this, ScResId( FL_CONSBY ) ),
//STRIP001 		aBtnByRow		( this, ScResId( BTN_BYROW ) ),
//STRIP001 		aBtnByCol		( this, ScResId( BTN_BYCOL) ),
//STRIP001 
//STRIP001         aFlSep          ( this, ScResId( FL_SEP ) ),
//STRIP001         aFlOptions      ( this, ScResId( FL_OPTIONS ) ),
//STRIP001 		aBtnRefs		( this, ScResId( BTN_REFS ) ),
//STRIP001 
//STRIP001 		aBtnOk			( this, ScResId( BTN_OK ) ),
//STRIP001 		aBtnCancel		( this, ScResId( BTN_CANCEL ) ),
//STRIP001 		aBtnHelp		( this, ScResId( BTN_HELP ) ),
//STRIP001 		aBtnMore		( this, ScResId( BTN_MORE ) ),
//STRIP001 		aBtnAdd			( this, ScResId( BTN_ADD ) ),
//STRIP001 		aBtnRemove		( this, ScResId( BTN_REMOVE ) ),
//STRIP001 
//STRIP001 		aStrUndefined	( ScResId( SCSTR_UNDEFINED ) ),
//STRIP001 		//
//STRIP001 		nWhichCons		( rArgSet.GetPool()->GetWhich( SID_CONSOLIDATE ) ),
//STRIP001 		theConsData		( ((const ScConsolidateItem&)
//STRIP001 						   rArgSet.Get( rArgSet.GetPool()->
//STRIP001 											GetWhich( SID_CONSOLIDATE ) )
//STRIP001 									  ).GetData() ),
//STRIP001 
//STRIP001 		pViewData		( ((ScTabViewShell*)SfxViewShell::Current())->
//STRIP001 								GetViewData() ),
//STRIP001 		pDoc			( ((ScTabViewShell*)SfxViewShell::Current())->
//STRIP001 								GetViewData()->GetDocument() ),
//STRIP001 		pRangeUtil		( new ScRangeUtil ),
//STRIP001 		pAreaData		( NULL ),
//STRIP001 		nAreaDataCount	( 0 ),
//STRIP001 		pRefInputEdit	( &aEdDataArea )
//STRIP001 {
//STRIP001 	Init();
//STRIP001 	FreeResource();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScConsolidateDlg::~ScConsolidateDlg()
//STRIP001 {
//STRIP001 	delete [] pAreaData;
//STRIP001 	delete pRangeUtil;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScConsolidateDlg::Init()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pViewData && pDoc && pRangeUtil, "Error in Ctor" );
//STRIP001 
//STRIP001 	String aStr;
//STRIP001 	USHORT i=0;
//STRIP001 
//STRIP001 	aEdDataArea	.SetGetFocusHdl( LINK( this, ScConsolidateDlg, GetFocusHdl ) );
//STRIP001 	aEdDestArea	.SetGetFocusHdl( LINK( this, ScConsolidateDlg, GetFocusHdl ) );
//STRIP001 	aLbDataArea .SetGetFocusHdl( LINK( this, ScConsolidateDlg, GetFocusHdl ) );
//STRIP001 	aLbDestArea .SetGetFocusHdl( LINK( this, ScConsolidateDlg, GetFocusHdl ) );
//STRIP001 	aEdDataArea	.SetModifyHdl	( LINK( this, ScConsolidateDlg, ModifyHdl ) );
//STRIP001 	aEdDestArea	.SetModifyHdl	( LINK( this, ScConsolidateDlg, ModifyHdl ) );
//STRIP001 	aLbConsAreas.SetSelectHdl	( LINK( this, ScConsolidateDlg, SelectHdl ) );
//STRIP001 	aLbDataArea .SetSelectHdl	( LINK( this, ScConsolidateDlg, SelectHdl ) );
//STRIP001 	aLbDestArea .SetSelectHdl	( LINK( this, ScConsolidateDlg, SelectHdl ) );
//STRIP001 	aBtnOk		.SetClickHdl	( LINK( this, ScConsolidateDlg, OkHdl ) );
//STRIP001 	aBtnCancel	.SetClickHdl	( LINK( this, ScConsolidateDlg, ClickHdl ) );
//STRIP001 	aBtnAdd		.SetClickHdl	( LINK( this, ScConsolidateDlg, ClickHdl ) );
//STRIP001 	aBtnRemove	.SetClickHdl	( LINK( this, ScConsolidateDlg, ClickHdl ) );
//STRIP001 
//STRIP001     aBtnMore.AddWindow( &aFlConsBy );
//STRIP001 	aBtnMore.AddWindow( &aBtnByRow );
//STRIP001 	aBtnMore.AddWindow( &aBtnByCol );
//STRIP001     aBtnMore.AddWindow( &aFlSep );
//STRIP001     aBtnMore.AddWindow( &aFlOptions );
//STRIP001 	aBtnMore.AddWindow( &aBtnRefs );
//STRIP001 
//STRIP001 	aBtnAdd.Disable();
//STRIP001 	aBtnRemove.Disable();
//STRIP001 
//STRIP001 	aBtnByRow.Check( theConsData.bByRow );
//STRIP001 	aBtnByCol.Check( theConsData.bByCol );
//STRIP001 	aBtnRefs .Check( theConsData.bReferenceData );
//STRIP001 
//STRIP001 	aLbFunc.SelectEntryPos( FuncToLbPos( theConsData.eFunction ) );
//STRIP001 
//STRIP001 	// Einlesen der Konsolidierungsbereiche
//STRIP001 	aLbConsAreas.Clear();
//STRIP001 	for ( i=0; i<theConsData.nDataAreaCount; i++ )
//STRIP001 	{
//STRIP001 		const ScArea& rArea = *(theConsData.ppDataAreas[i] );
//STRIP001 		if ( rArea.nTab < pDoc->GetTableCount() )
//STRIP001 		{
//STRIP001             ScRange( rArea.nColStart, rArea.nRowStart, rArea.nTab,
//STRIP001                     rArea.nColEnd, rArea.nRowEnd, rArea.nTab ).Format( aStr,
//STRIP001                         SCR_ABS_3D, pDoc );
//STRIP001             aLbConsAreas.InsertEntry( aStr );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	if ( theConsData.nTab < pDoc->GetTableCount() )
//STRIP001     {
//STRIP001         ScAddress( theConsData.nCol, theConsData.nRow, theConsData.nTab
//STRIP001                 ).Format( aStr, SCA_ABS_3D, pDoc );
//STRIP001         aEdDestArea.SetText( aStr );
//STRIP001     }
//STRIP001 	else
//STRIP001 		aEdDestArea.SetText( EMPTY_STRING );
//STRIP001 
//STRIP001 	//----------------------------------------------------------
//STRIP001 
//STRIP001 	/*
//STRIP001 	 * Aus den RangeNames und Datenbankbereichen werden sich
//STRIP001 	 * in der Hilfsklasse ScAreaData die Bereichsnamen gemerkt,
//STRIP001 	 * die in den ListBoxen erscheinen.
//STRIP001 	 */
//STRIP001 
//STRIP001 	ScRangeName*    pRangeNames  = pDoc->GetRangeName();
//STRIP001 	ScDBCollection* pDbNames     = pDoc->GetDBCollection();
//STRIP001 	const USHORT    nRangeCount  = pRangeNames ? pRangeNames->GetCount() : 0;
//STRIP001 	const USHORT    nDbCount	 = pDbNames	   ? pDbNames   ->GetCount() : 0;
//STRIP001 
//STRIP001 	nAreaDataCount = nRangeCount+nDbCount;
//STRIP001 	pAreaData	   = NULL;
//STRIP001 
//STRIP001 	if ( nAreaDataCount > 0 )
//STRIP001 	{
//STRIP001 		pAreaData = new ScAreaData[nAreaDataCount];
//STRIP001 
//STRIP001 		String aStrName;
//STRIP001 		String aStrArea;
//STRIP001 		USHORT nAt = 0;
//STRIP001 		ScRange aRange;
//STRIP001 		ScAreaNameIterator aIter( pDoc );
//STRIP001 		while ( aIter.Next( aStrName, aRange ) )
//STRIP001 		{
//STRIP001 			aRange.Format( aStrArea, SCA_ABS_3D, pDoc );
//STRIP001 			pAreaData[nAt++].Set( aStrName, aStrArea, aIter.WasDBName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	FillAreaLists();
//STRIP001 	ModifyHdl( &aEdDestArea );
//STRIP001 	aLbDataArea.SelectEntryPos( 0 );
//STRIP001 	aEdDataArea.SetText( EMPTY_STRING );
//STRIP001 	aEdDataArea.GrabFocus();
//STRIP001 
//STRIP001     aFlSep.SetStyle( aFlSep.GetStyle() | WB_VERT );
//STRIP001 
//STRIP001 	//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 	//SFX_APPWINDOW->Enable();
//STRIP001 }


//----------------------------------------------------------------------------
//STRIP001 void ScConsolidateDlg::FillAreaLists()
//STRIP001 {
//STRIP001 	aLbDataArea.Clear();
//STRIP001 	aLbDestArea.Clear();
//STRIP001 	aLbDataArea.InsertEntry( aStrUndefined );
//STRIP001 	aLbDestArea.InsertEntry( aStrUndefined );
//STRIP001 
//STRIP001 	if ( pRangeUtil && pAreaData && (nAreaDataCount > 0) )
//STRIP001 	{
//STRIP001 		String aString;
//STRIP001 
//STRIP001 		for ( USHORT i=0;
//STRIP001 			  (i<nAreaDataCount) && (pAreaData[i].aStrName.Len()>0);
//STRIP001 			  i++ )
//STRIP001 		{
//STRIP001 			aLbDataArea.InsertEntry( pAreaData[i].aStrName, i+1 );
//STRIP001 
//STRIP001 //			if ( !pAreaData[i].bIsDbArea )
//STRIP001 				aLbDestArea.InsertEntry( pAreaData[i].aStrName, i+1 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------
// Uebergabe eines mit der Maus selektierten Tabellenbereiches, der dann als
//  neue Selektion im Referenz-Fenster angezeigt wird.


//STRIP001 void ScConsolidateDlg::SetReference( const ScRange& rRef, ScDocument* pDoc )
//STRIP001 {
//STRIP001 	if ( pRefInputEdit )
//STRIP001 	{
//STRIP001 		if ( rRef.aStart != rRef.aEnd )
//STRIP001 			RefInputStart( pRefInputEdit );
//STRIP001 
//STRIP001 		String		aStr;
//STRIP001 		USHORT	 	nFmt = SCR_ABS_3D;		 //!!! nCurTab fehlt noch
//STRIP001 
//STRIP001 		if ( rRef.aStart.Tab() != rRef.aEnd.Tab() )
//STRIP001 			nFmt |= SCA_TAB2_3D;
//STRIP001 
//STRIP001 		if ( pRefInputEdit == &aEdDataArea)
//STRIP001 			rRef.Format( aStr, nFmt, pDoc );
//STRIP001 		else if ( pRefInputEdit == &aEdDestArea )
//STRIP001 			rRef.aStart.Format( aStr, nFmt, pDoc );
//STRIP001 
//STRIP001 		pRefInputEdit->SetRefString( aStr );
//STRIP001 	}
//STRIP001 
//STRIP001 	ModifyHdl( pRefInputEdit );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScConsolidateDlg::Close()
//STRIP001 {
//STRIP001 	return DoClose( ScConsolidateDlgWrapper::GetChildWindowId() );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScConsolidateDlg::SetActive()
//STRIP001 {
//STRIP001 	if ( bDlgLostFocus )
//STRIP001 	{
//STRIP001 		bDlgLostFocus = FALSE;
//STRIP001 
//STRIP001 		if ( pRefInputEdit )
//STRIP001 		{
//STRIP001 			pRefInputEdit->GrabFocus();
//STRIP001 			ModifyHdl( pRefInputEdit );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		GrabFocus();
//STRIP001 
//STRIP001 	RefInputDone();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScConsolidateDlg::Deactivate()
//STRIP001 {
//STRIP001 	bDlgLostFocus = TRUE;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScConsolidateDlg::VerifyEdit( ScRefEdit* pEd )
//STRIP001 {
//STRIP001 	if ( !pRangeUtil || !pDoc || !pViewData ||
//STRIP001 		 ((pEd != &aEdDataArea) && (pEd != &aEdDestArea)) )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	USHORT	nTab	= pViewData->GetTabNo();
//STRIP001 	BOOL	bEditOk = FALSE;
//STRIP001 	String	theCompleteStr;
//STRIP001 
//STRIP001 	if ( pEd == &aEdDataArea )
//STRIP001 	{
//STRIP001 		bEditOk = pRangeUtil->IsAbsArea( pEd->GetText(), pDoc,
//STRIP001 										 nTab, &theCompleteStr );
//STRIP001 	}
//STRIP001 	else if ( pEd == &aEdDestArea )
//STRIP001 	{
//STRIP001 		String aPosStr;
//STRIP001 
//STRIP001 		pRangeUtil->CutPosString( pEd->GetText(), aPosStr );
//STRIP001 		bEditOk = pRangeUtil->IsAbsPos( aPosStr, pDoc,
//STRIP001 										nTab, &theCompleteStr );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bEditOk )
//STRIP001 		pEd->SetText( theCompleteStr );
//STRIP001 
//STRIP001 	return bEditOk;
//STRIP001 }


//----------------------------------------------------------------------------
// Handler:
// ========

//STRIP001 IMPL_LINK( ScConsolidateDlg, GetFocusHdl, Control*, pCtr )
//STRIP001 {
//STRIP001 	if ( pCtr ==(Control*)&aEdDataArea ||
//STRIP001 		 pCtr ==(Control*)&aEdDestArea)
//STRIP001 	{
//STRIP001 		pRefInputEdit = (ScRefEdit*)pCtr;
//STRIP001 	}
//STRIP001 	else if(pCtr ==(Control*)&aLbDataArea )
//STRIP001 	{
//STRIP001 		pRefInputEdit = &aEdDataArea;
//STRIP001 	}
//STRIP001 	else if(pCtr ==(Control*)&aLbDestArea )
//STRIP001 	{
//STRIP001 		pRefInputEdit = &aEdDestArea;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScConsolidateDlg, OkHdl, void*, p )
//STRIP001 {
//STRIP001 	USHORT nDataAreaCount = aLbConsAreas.GetEntryCount();
//STRIP001 
//STRIP001 	if ( nDataAreaCount > 0 )
//STRIP001 	{
//STRIP001 		ScRefTripel	aDestTripel;
//STRIP001 		USHORT		nTab = pViewData->GetTabNo();
//STRIP001 		String		aDestPosStr( aEdDestArea.GetText() );
//STRIP001 
//STRIP001 		if ( pRangeUtil->IsAbsPos( aDestPosStr, pDoc, nTab, NULL, &aDestTripel ) )
//STRIP001 		{
//STRIP001 			ScConsolidateParam	theOutParam( theConsData );
//STRIP001 			ScArea**			ppDataAreas = new ScArea*[nDataAreaCount];
//STRIP001 			ScArea*				pArea;
//STRIP001 			USHORT				i=0;
//STRIP001 
//STRIP001 			for ( i=0; i<nDataAreaCount; i++ )
//STRIP001 			{
//STRIP001 				pArea = new ScArea;
//STRIP001 				pRangeUtil->MakeArea( aLbConsAreas.GetEntry( i ),
//STRIP001 									  *pArea, pDoc, nTab );
//STRIP001 				ppDataAreas[i] = pArea;
//STRIP001 			}
//STRIP001 
//STRIP001 			theOutParam.nCol			= aDestTripel.GetCol();
//STRIP001 			theOutParam.nRow			= aDestTripel.GetRow();
//STRIP001 			theOutParam.nTab			= aDestTripel.GetTab();
//STRIP001 			theOutParam.eFunction		= LbPosToFunc( aLbFunc.GetSelectEntryPos() );
//STRIP001 			theOutParam.bByCol			= aBtnByCol.IsChecked();
//STRIP001 			theOutParam.bByRow			= aBtnByRow.IsChecked();
//STRIP001 			theOutParam.bReferenceData	= aBtnRefs.IsChecked();
//STRIP001 			theOutParam.SetAreas( ppDataAreas, nDataAreaCount );
//STRIP001 
//STRIP001 			for ( i=0; i<nDataAreaCount; i++ )
//STRIP001 				delete ppDataAreas[i];
//STRIP001 			delete [] ppDataAreas;
//STRIP001 
//STRIP001 			ScConsolidateItem aOutItem( nWhichCons, &theOutParam );
//STRIP001 
//STRIP001 			SetDispatcherLock( FALSE );
//STRIP001 			SwitchToDocument();
//STRIP001 			GetBindings().GetDispatcher()->Execute( SID_CONSOLIDATE,
//STRIP001 									  SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 									  &aOutItem, 0L, 0L );
//STRIP001 			Close();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			INFOBOX( STR_INVALID_TABREF );
//STRIP001 			aEdDestArea.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Close(); // keine Datenbereiche definiert -> Cancel
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScConsolidateDlg, ClickHdl, PushButton*, pBtn )
//STRIP001 {
//STRIP001 	if ( pBtn == &aBtnCancel )
//STRIP001 		Close();
//STRIP001 	else if ( pBtn == &aBtnAdd )
//STRIP001 	{
//STRIP001 		if ( aEdDataArea.GetText().Len() > 0 )
//STRIP001 		{
//STRIP001 			String		aNewEntry( aEdDataArea.GetText() );
//STRIP001 			ScArea**	ppAreas = NULL;
//STRIP001 			USHORT		nAreaCount = 0;
//STRIP001 
//STRIP001 			if ( pRangeUtil->IsAbsTabArea( aNewEntry, pDoc, &ppAreas, &nAreaCount, TRUE ) )
//STRIP001 			{
//STRIP001 				// IsAbsTabArea() legt ein Array von ScArea-Zeigern an,
//STRIP001 				// welche ebenfalls dynamisch erzeugt wurden.
//STRIP001 				// Diese Objekte muessen hier abgeraeumt werden.
//STRIP001 
//STRIP001 				for ( USHORT i=0; i<nAreaCount; i++ )
//STRIP001 				{
//STRIP001 					String aNewArea;
//STRIP001 
//STRIP001 					if ( ppAreas[i] )
//STRIP001 					{
//STRIP001                         const ScArea& rArea = *(ppAreas[i]);
//STRIP001                         ScRange( rArea.nColStart, rArea.nRowStart, rArea.nTab,
//STRIP001                                 rArea.nColEnd, rArea.nRowEnd, rArea.nTab
//STRIP001                                 ).Format( aNewArea, SCR_ABS_3D, pDoc );
//STRIP001 
//STRIP001 						if ( aLbConsAreas.GetEntryPos( aNewArea )
//STRIP001 							 == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 						{
//STRIP001 							aLbConsAreas.InsertEntry( aNewArea );
//STRIP001 						}
//STRIP001 						delete ppAreas[i];
//STRIP001 					}
//STRIP001 				}
//STRIP001 				delete [] ppAreas;
//STRIP001 			}
//STRIP001 			else if ( VerifyEdit( &aEdDataArea ) )
//STRIP001 			{
//STRIP001 				String aNewArea( aEdDataArea.GetText() );
//STRIP001 
//STRIP001 				if ( aLbConsAreas.GetEntryPos( aNewArea ) == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 					aLbConsAreas.InsertEntry( aNewArea );
//STRIP001 				else
//STRIP001 					INFOBOX( STR_AREA_ALREADY_INSERTED );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				INFOBOX( STR_INVALID_TABREF );
//STRIP001 				aEdDataArea.GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aBtnRemove )
//STRIP001 	{
//STRIP001 		while ( aLbConsAreas.GetSelectEntryCount() )
//STRIP001 			aLbConsAreas.RemoveEntry( aLbConsAreas.GetSelectEntryPos() );
//STRIP001 		aBtnRemove.Disable();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScConsolidateDlg, SelectHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &aLbConsAreas )
//STRIP001 	{
//STRIP001 		if ( aLbConsAreas.GetSelectEntryCount() > 0 )
//STRIP001 			aBtnRemove.Enable();
//STRIP001 		else
//STRIP001 			aBtnRemove.Disable();
//STRIP001 	}
//STRIP001 	else if ( (pLb == &aLbDataArea) || (pLb == &aLbDestArea) )
//STRIP001 	{
//STRIP001 		Edit*	pEd = (pLb == &aLbDataArea) ? &aEdDataArea : &aEdDestArea;
//STRIP001 		USHORT	nSelPos = pLb->GetSelectEntryPos();
//STRIP001 
//STRIP001 		if (    pRangeUtil
//STRIP001 			&& (nSelPos > 0)
//STRIP001 			&& (nAreaDataCount > 0)
//STRIP001 			&& (pAreaData != NULL) )
//STRIP001 		{
//STRIP001 			if ( nSelPos <= nAreaDataCount )
//STRIP001 			{
//STRIP001 				String aString( pAreaData[nSelPos-1].aStrArea );
//STRIP001 
//STRIP001 				if ( pLb == &aLbDestArea )
//STRIP001 					pRangeUtil->CutPosString( aString, aString );
//STRIP001 
//STRIP001 				pEd->SetText( aString );
//STRIP001 
//STRIP001 				if ( pEd == &aEdDataArea )
//STRIP001 					aBtnAdd.Enable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pEd->SetText( EMPTY_STRING );
//STRIP001 			if ( pEd == &aEdDataArea )
//STRIP001 				aBtnAdd.Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScConsolidateDlg, ModifyHdl, ScRefEdit*, pEd )
//STRIP001 {
//STRIP001 	if ( pEd == &aEdDataArea )
//STRIP001 	{
//STRIP001 		String aAreaStr( pEd->GetText() );
//STRIP001 		if ( aAreaStr.Len() > 0 )
//STRIP001 		{
//STRIP001 			aBtnAdd.Enable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aBtnAdd.Disable();
//STRIP001 	}
//STRIP001 	else if ( pEd == &aEdDestArea )
//STRIP001 	{
//STRIP001 		aLbDestArea.SelectEntryPos(0);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------
// Verallgemeinern!!! :
// Resource der ListBox und diese beiden Umrechnungsmethoden gibt es
// auch noch in tpsubt bzw. ueberall, wo StarCalc-Funktionen
// auswaehlbar sind.

//STRIP001 ScSubTotalFunc ScConsolidateDlg::LbPosToFunc( USHORT nPos )
//STRIP001 {
//STRIP001 	switch ( nPos )
//STRIP001 	{
//STRIP001 		case  2:	return SUBTOTAL_FUNC_AVE;
//STRIP001 		case  6:	return SUBTOTAL_FUNC_CNT;
//STRIP001 		case  1:	return SUBTOTAL_FUNC_CNT2;
//STRIP001 		case  3:	return SUBTOTAL_FUNC_MAX;
//STRIP001 		case  4:	return SUBTOTAL_FUNC_MIN;
//STRIP001 		case  5:	return SUBTOTAL_FUNC_PROD;
//STRIP001 		case  7:	return SUBTOTAL_FUNC_STD;
//STRIP001 		case  8:	return SUBTOTAL_FUNC_STDP;
//STRIP001 		case  9:	return SUBTOTAL_FUNC_VAR;
//STRIP001 		case 10:	return SUBTOTAL_FUNC_VARP;
//STRIP001 		case  0:
//STRIP001 		default:
//STRIP001 			return SUBTOTAL_FUNC_SUM;
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 USHORT ScConsolidateDlg::FuncToLbPos( ScSubTotalFunc eFunc )
//STRIP001 {
//STRIP001 	switch ( eFunc )
//STRIP001 	{
//STRIP001 		case SUBTOTAL_FUNC_AVE:		return 2;
//STRIP001 		case SUBTOTAL_FUNC_CNT:		return 6;
//STRIP001 		case SUBTOTAL_FUNC_CNT2:	return 1;
//STRIP001 		case SUBTOTAL_FUNC_MAX:		return 3;
//STRIP001 		case SUBTOTAL_FUNC_MIN:		return 4;
//STRIP001 		case SUBTOTAL_FUNC_PROD:	return 5;
//STRIP001 		case SUBTOTAL_FUNC_STD:		return 7;
//STRIP001 		case SUBTOTAL_FUNC_STDP:	return 8;
//STRIP001 		case SUBTOTAL_FUNC_VAR:		return 9;
//STRIP001 		case SUBTOTAL_FUNC_VARP:	return 10;
//STRIP001 		case SUBTOTAL_FUNC_NONE:
//STRIP001 		case SUBTOTAL_FUNC_SUM:
//STRIP001 		default:
//STRIP001 			return 0;
//STRIP001 	}
//STRIP001 }

}
