/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_csvgrid.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:56:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif
#pragma hdrstop

// ============================================================================

// auto strip #ifndef _SC_CSVGRID_HXX
// auto strip #include "csvgrid.hxx"
// auto strip #endif

#include <algorithm>

// auto strip #ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
// auto strip #include <svtools/colorcfg.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSMPLHINT_HXX
// auto strip #include <svtools/smplhint.hxx>
// auto strip #endif
// auto strip #ifndef _TL_POLY_HXX
// auto strip #include <tools/poly.hxx>
// auto strip #endif

#ifndef SC_SCMOD_HXX
#include "scmod.hxx"
#endif
#ifndef SC_ASCIIOPT_HXX
#include "asciiopt.hxx"
#endif
// auto strip #ifndef SC_IMPEX_HXX
// auto strip #include "impex.hxx"
// auto strip #endif

// auto strip #ifndef _SC_ACCESSIBLECSVCONTROL_HXX
// auto strip #include "AccessibleCsvControl.hxx"
// auto strip #endif

// *** edit engine ***
#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/colritem.hxx>
// auto strip #include <bf_svx/fhgtitem.hxx>
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #include <svtools/itemset.hxx>

#ifndef SC_EDITUTIL_HXX
#include "editutil.hxx"
#endif
namespace binfilter {
// *** edit engine ***


// ============================================================================

/*M*/ struct Func_SetType
/*M*/ {
/*M*/     sal_Int32                   mnType;
/*M*/     inline                      Func_SetType( sal_Int32 nType ) : mnType( nType ) {}
/*M*/     inline void                 operator()( ScCsvColState& rState ) { rState.mnType = mnType; }
/*M*/ };

/*M*/ struct Func_Select
/*M*/ {
/*M*/     bool                        mbSelect;
/*M*/     inline                      Func_Select( bool bSelect ) : mbSelect( bSelect ) {}
/*M*/     inline void                 operator()( ScCsvColState& rState ) { rState.Select( mbSelect ); }
/*M*/ };


// ============================================================================

/*M*/ ScCsvGrid::ScCsvGrid( ScCsvControl& rParent ) :
/*M*/     ScCsvControl( rParent ),
/*M*/     mrColorConfig( SC_MOD()->GetColorConfig() ),
/*M*/     mpEditEngine( new ScEditEngineDefaulter( EditEngine::CreatePool(), TRUE ) ),
/*M*/     maHeaderFont( GetFont() ),
/*M*/     maColStates( 1 ),
/*M*/     maTypeNames( 1 ),
/*N*/     mnFirstImpLine( 0 ),
/*M*/     mnRecentSelCol( CSV_COLUMN_INVALID )
/*M*/ {
/*M*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 mpEditEngine->SetRefDevice( &maBackgrDev );
//STRIP001     mpEditEngine->SetRefMapMode( MapMode( MAP_PIXEL ) );
//STRIP001     maEdEngSize = mpEditEngine->GetPaperSize();
//STRIP001 
//STRIP001     maPopup.SetMenuFlags( maPopup.GetMenuFlags() | MENU_FLAG_NOAUTOMNEMONICS );
//STRIP001 
//STRIP001     EnableRTL( false ); // #107812# RTL
//STRIP001     InitColors();
//STRIP001     InitFonts();
//STRIP001     ImplClearSplits();
//STRIP001     StartListening( mrColorConfig );
/*M*/ }

/*N*/ ScCsvGrid::~ScCsvGrid()
/*N*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     EndListening( mrColorConfig );
/*N*/ }


// common grid handling -------------------------------------------------------

//STRIP001 void ScCsvGrid::UpdateLayoutData()
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     SetFont( maMonoFont );
//STRIP001     Execute( CSVCMD_SETCHARWIDTH, GetTextWidth( String( 'X' ) ) );
//STRIP001     Execute( CSVCMD_SETLINEHEIGHT, GetTextHeight() + 1 );
//STRIP001     SetFont( maHeaderFont );
//STRIP001     Execute( CSVCMD_SETHDRHEIGHT, GetTextHeight() + 1 );
//STRIP001     UpdateOffsetX();
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::UpdateOffsetX()
//STRIP001 {
//STRIP001     sal_Int32 nLastLine = GetLastVisLine() + 1;
//STRIP001     sal_Int32 nDigits = 2;
//STRIP001     while( nLastLine /= 10 ) ++nDigits;
//STRIP001     nDigits = Max( nDigits, 3L );
//STRIP001     Execute( CSVCMD_SETHDRWIDTH, GetTextWidth( String( '0' ) ) * nDigits );
//STRIP001 }

//STRIP001 void ScCsvGrid::ApplyLayout( const ScCsvLayoutData& rOldData )
//STRIP001 {
//STRIP001     ScCsvDiff nDiff = GetLayoutData().GetDiff( rOldData );
//STRIP001     if( nDiff == CSV_DIFF_EQUAL ) return;
//STRIP001 
//STRIP001     DisableRepaint();
//STRIP001 
//STRIP001     if( nDiff & CSV_DIFF_RULERCURSOR )
//STRIP001     {
//STRIP001         ImplInvertCursor( rOldData.mnPosCursor );
//STRIP001         ImplInvertCursor( GetRulerCursorPos() );
//STRIP001     }
//STRIP001 
//STRIP001     if( nDiff & CSV_DIFF_POSCOUNT )
//STRIP001     {
//STRIP001         if( GetPosCount() < rOldData.mnPosCount )
//STRIP001         {
//STRIP001             SelectAll( false );
//STRIP001             maSplits.RemoveRange( GetPosCount(), rOldData.mnPosCount );
//STRIP001         }
//STRIP001         else
//STRIP001             maSplits.Remove( rOldData.mnPosCount );
//STRIP001         maSplits.Insert( GetPosCount() );
//STRIP001         maColStates.resize( maSplits.Count() - 1 );
//STRIP001     }
//STRIP001 
//STRIP001     if( nDiff & CSV_DIFF_LINEOFFSET )
//STRIP001     {
//STRIP001         Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001         UpdateOffsetX();
//STRIP001     }
//STRIP001 
//STRIP001     ScCsvDiff nHVDiff = nDiff & (CSV_DIFF_HORIZONTAL | CSV_DIFF_VERTICAL);
//STRIP001     if( nHVDiff == CSV_DIFF_POSOFFSET )
//STRIP001         ImplDrawHorzScrolled( rOldData.mnPosOffset );
//STRIP001     else if( nHVDiff != CSV_DIFF_EQUAL )
//STRIP001         InvalidateGfx();
//STRIP001 
//STRIP001     EnableRepaint();
//STRIP001 
//STRIP001     if( nDiff & (CSV_DIFF_POSOFFSET | CSV_DIFF_LINEOFFSET) )
//STRIP001         AccSendVisibleEvent();
//STRIP001 }

//STRIP001 void ScCsvGrid::SetFirstImportedLine( sal_Int32 nLine )
//STRIP001 {
//STRIP001     ImplDrawFirstLineSep( false );
//STRIP001     mnFirstImpLine = nLine;
//STRIP001     ImplDrawFirstLineSep( true );
//STRIP001     ImplDrawGridDev();
//STRIP001     Repaint();
//STRIP001 }

//STRIP001 sal_Int32 ScCsvGrid::GetNoScrollCol( sal_Int32 nPos ) const
//STRIP001 {
//STRIP001     sal_Int32 nNewPos = nPos;
//STRIP001     if( nNewPos != CSV_POS_INVALID )
//STRIP001     {
//STRIP001         if( nNewPos < GetFirstVisPos() + CSV_SCROLL_DIST )
//STRIP001         {
//STRIP001             sal_Int32 nScroll = (GetFirstVisPos() > 0) ? CSV_SCROLL_DIST : 0;
//STRIP001             nNewPos = GetFirstVisPos() + nScroll;
//STRIP001         }
//STRIP001         else if( nNewPos > GetLastVisPos() - CSV_SCROLL_DIST - 1L )
//STRIP001         {
//STRIP001             sal_Int32 nScroll = (GetFirstVisPos() < GetMaxPosOffset()) ? CSV_SCROLL_DIST : 0;
//STRIP001             nNewPos = GetLastVisPos() - nScroll - 1;
//STRIP001         }
//STRIP001     }
//STRIP001     return nNewPos;
//STRIP001 }

//STRIP001 void ScCsvGrid::InitColors()
//STRIP001 {
//STRIP001     maBackColor = Color( mrColorConfig.GetColorValue( ::svtools::DOCCOLOR ).nColor );
//STRIP001     maGridColor = Color( mrColorConfig.GetColorValue( ::svtools::CALCGRID ).nColor );
//STRIP001     maGridPBColor = Color( mrColorConfig.GetColorValue( ::svtools::CALCPAGEBREAK ).nColor );
//STRIP001     maAppBackColor = Color( mrColorConfig.GetColorValue( ::svtools::APPBACKGROUND ).nColor );
//STRIP001 
//STRIP001     const StyleSettings& rSett = GetSettings().GetStyleSettings();
//STRIP001     maTextColor = rSett.GetWindowTextColor();
//STRIP001     maHeaderBackColor = rSett.GetFaceColor();
//STRIP001     maHeaderGridColor = rSett.GetDarkShadowColor();
//STRIP001     maHeaderTextColor = rSett.GetButtonTextColor();
//STRIP001     maSelectColor = rSett.GetActiveColor();
//STRIP001 
//STRIP001     InvalidateGfx();
//STRIP001 }

//STRIP001 void ScCsvGrid::InitFonts()
//STRIP001 {
//STRIP001     maMonoFont = OutputDevice::GetDefaultFont( DEFAULTFONT_FIXED, LANGUAGE_ENGLISH_US, 0 );
//STRIP001     maMonoFont.SetSize( Size( maMonoFont.GetSize().Width(), maHeaderFont.GetSize().Height() ) );
//STRIP001 
//STRIP001     /* *** Set edit engine defaults ***
//STRIP001         maMonoFont for Latin script, smaller default font for Asian and Complex script. */
//STRIP001 
//STRIP001     // get default fonts
//STRIP001     SvxFontItem aLatinItem( EE_CHAR_FONTINFO );
//STRIP001     SvxFontItem aAsianItem( EE_CHAR_FONTINFO_CJK );
//STRIP001     SvxFontItem aComplexItem( EE_CHAR_FONTINFO_CTL );
//STRIP001     ::GetDefaultFonts( aLatinItem, aAsianItem, aComplexItem );
//STRIP001 
//STRIP001     // create item set for defaults
//STRIP001     SfxItemSet aDefSet( mpEditEngine->GetEmptyItemSet() );
//STRIP001     EditEngine::SetFontInfoInItemSet( aDefSet, maMonoFont );
//STRIP001     aDefSet.Put( aAsianItem );
//STRIP001     aDefSet.Put( aComplexItem );
//STRIP001 
//STRIP001     // set Asian/Complex font size to width of character in Latin font
//STRIP001     aDefSet.Put( SvxFontHeightItem( GetCharWidth(), 100, EE_CHAR_FONTHEIGHT_CJK ) );
//STRIP001     aDefSet.Put( SvxFontHeightItem( GetCharWidth(), 100, EE_CHAR_FONTHEIGHT_CTL ) );
//STRIP001 
//STRIP001     // copy other items from default font
//STRIP001     const SfxPoolItem& rWeightItem = aDefSet.Get( EE_CHAR_WEIGHT );
//STRIP001     aDefSet.Put( rWeightItem, EE_CHAR_WEIGHT_CJK );
//STRIP001     aDefSet.Put( rWeightItem, EE_CHAR_WEIGHT_CTL );
//STRIP001     const SfxPoolItem& rItalicItem = aDefSet.Get( EE_CHAR_ITALIC );
//STRIP001     aDefSet.Put( rItalicItem, EE_CHAR_ITALIC_CJK );
//STRIP001     aDefSet.Put( rItalicItem, EE_CHAR_ITALIC_CTL );
//STRIP001     const SfxPoolItem& rLangItem = aDefSet.Get( EE_CHAR_LANGUAGE );
//STRIP001     aDefSet.Put( rLangItem, EE_CHAR_LANGUAGE_CJK );
//STRIP001     aDefSet.Put( rLangItem, EE_CHAR_LANGUAGE_CTL );
//STRIP001 
//STRIP001     mpEditEngine->SetDefaults( aDefSet );
//STRIP001     InvalidateGfx();
//STRIP001 }

//STRIP001 void ScCsvGrid::InitSizeData()
//STRIP001 {
//STRIP001     maWinSize = GetSizePixel();
//STRIP001     maBackgrDev.SetOutputSizePixel( maWinSize );
//STRIP001     maGridDev.SetOutputSizePixel( maWinSize );
//STRIP001     InvalidateGfx();
//STRIP001 }


// split handling -------------------------------------------------------------

//STRIP001 void ScCsvGrid::InsertSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( ImplInsertSplit( nPos ) )
//STRIP001     {
//STRIP001         DisableRepaint();
//STRIP001         Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001         Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001         sal_uInt32 nColIx = GetColumnFromPos( nPos );
//STRIP001         ImplDrawColumn( nColIx - 1 );
//STRIP001         ImplDrawColumn( nColIx );
//STRIP001         ValidateGfx();  // performance: do not redraw all columns
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::RemoveSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( ImplRemoveSplit( nPos ) )
//STRIP001     {
//STRIP001         DisableRepaint();
//STRIP001         Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001         Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001         ImplDrawColumn( GetColumnFromPos( nPos ) );
//STRIP001         ValidateGfx();  // performance: do not redraw all columns
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::MoveSplit( sal_Int32 nPos, sal_Int32 nNewPos )
//STRIP001 {
//STRIP001     sal_uInt32 nColIx = GetColumnFromPos( nPos );
//STRIP001     if( nColIx != CSV_COLUMN_INVALID )
//STRIP001     {
//STRIP001         DisableRepaint();
//STRIP001         if( (GetColumnPos( nColIx - 1 ) < nNewPos) && (nNewPos < GetColumnPos( nColIx + 1 )) )
//STRIP001         {
//STRIP001             // move a split in the range between 2 others -> keep selection state of both columns
//STRIP001             maSplits.Remove( nPos );
//STRIP001             maSplits.Insert( nNewPos );
//STRIP001             Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001             ImplDrawColumn( nColIx - 1 );
//STRIP001             ImplDrawColumn( nColIx );
//STRIP001             ValidateGfx();  // performance: do not redraw all columns
//STRIP001             AccSendTableUpdateEvent( nColIx - 1, nColIx );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             ImplRemoveSplit( nPos );
//STRIP001             ImplInsertSplit( nNewPos );
//STRIP001             Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001             Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001         }
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::RemoveAllSplits()
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     ImplClearSplits();
//STRIP001     Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001     Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::SetSplits( const ScCsvSplits& rSplits )
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     ImplClearSplits();
//STRIP001     sal_uInt32 nCount = rSplits.Count();
//STRIP001     for( sal_uInt32 nIx = 0; nIx < nCount; ++nIx )
//STRIP001         maSplits.Insert( rSplits[ nIx ] );
//STRIP001     maColStates.clear();
//STRIP001     maColStates.resize( maSplits.Count() - 1 );
//STRIP001     Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001     Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 bool ScCsvGrid::ImplInsertSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     sal_uInt32 nColIx = GetColumnFromPos( nPos );
//STRIP001     bool bRet = (nColIx < GetColumnCount()) && maSplits.Insert( nPos );
//STRIP001     if( bRet )
//STRIP001     {
//STRIP001         ScCsvColState aState( GetColumnType( nColIx ) );
//STRIP001         aState.Select( IsSelected( nColIx ) && IsSelected( nColIx + 1 ) );
//STRIP001         maColStates.insert( maColStates.begin() + nColIx + 1, aState );
//STRIP001         AccSendInsertColumnEvent( nColIx + 1, nColIx + 1 );
//STRIP001         AccSendTableUpdateEvent( nColIx, nColIx );
//STRIP001     }
//STRIP001     return bRet;
//STRIP001 }

//STRIP001 bool ScCsvGrid::ImplRemoveSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     bool bRet = maSplits.Remove( nPos );
//STRIP001     if( bRet )
//STRIP001     {
//STRIP001         sal_uInt32 nColIx = GetColumnFromPos( nPos );
//STRIP001         bool bSel = IsSelected( nColIx ) || IsSelected( nColIx + 1 );
//STRIP001         maColStates.erase( maColStates.begin() + nColIx + 1 );
//STRIP001         maColStates[ nColIx ].Select( bSel );
//STRIP001         AccSendRemoveColumnEvent( nColIx + 1, nColIx + 1 );
//STRIP001         AccSendTableUpdateEvent( nColIx, nColIx );
//STRIP001     }
//STRIP001     return bRet;
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplClearSplits()
//STRIP001 {
//STRIP001     sal_uInt32 nColumns = GetColumnCount();
//STRIP001     maSplits.Clear();
//STRIP001     maSplits.Insert( 0 );
//STRIP001     maSplits.Insert( GetPosCount() );
//STRIP001     maColStates.resize( 1 );
//STRIP001     InvalidateGfx();
//STRIP001     AccSendRemoveColumnEvent( 1, nColumns - 1 );
//STRIP001 }

// columns/column types -------------------------------------------------------

//STRIP001 sal_uInt32 ScCsvGrid::GetFirstVisColumn() const
//STRIP001 {
//STRIP001     return GetColumnFromPos( GetFirstVisPos() );
//STRIP001 }

//STRIP001 sal_uInt32 ScCsvGrid::GetLastVisColumn() const
//STRIP001 {
//STRIP001     return GetColumnFromPos( Min( GetLastVisPos(), GetPosCount() ) - 1 );
//STRIP001 }

//STRIP001 bool ScCsvGrid::IsValidColumn( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     return nColIndex < GetColumnCount();
//STRIP001 }

//STRIP001 bool ScCsvGrid::IsVisibleColumn( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     return  IsValidColumn( nColIndex ) &&
//STRIP001             (GetColumnPos( nColIndex ) < GetLastVisPos()) &&
//STRIP001             (GetFirstVisPos() < GetColumnPos( nColIndex + 1 ));
//STRIP001 }

//STRIP001 sal_Int32 ScCsvGrid::GetColumnX( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     return GetX( GetColumnPos( nColIndex ) );
//STRIP001 }

//STRIP001 sal_uInt32 ScCsvGrid::GetColumnFromX( sal_Int32 nX ) const
//STRIP001 {
//STRIP001     sal_Int32 nPos = (nX - GetFirstX()) / GetCharWidth() + GetFirstVisPos();
//STRIP001     return ((GetFirstVisPos() <= nPos) && (nPos <= GetLastVisPos())) ?
//STRIP001         GetColumnFromPos( nPos ) : CSV_COLUMN_INVALID;
//STRIP001 }

//STRIP001 sal_uInt32 ScCsvGrid::GetColumnFromPos( sal_Int32 nPos ) const
//STRIP001 {
//STRIP001     return maSplits.UpperBound( nPos );
//STRIP001 }

//STRIP001 sal_Int32 ScCsvGrid::GetColumnWidth( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     return IsValidColumn( nColIndex ) ? (GetColumnPos( nColIndex + 1 ) - GetColumnPos( nColIndex )) : 0;
//STRIP001 }

//STRIP001 void ScCsvGrid::SetColumnStates( const ScCsvColStateVec& rStates )
//STRIP001 {
//STRIP001     maColStates = rStates;
//STRIP001     maColStates.resize( maSplits.Count() - 1 );
//STRIP001     Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001     AccSendTableUpdateEvent( 0, GetColumnCount(), false );
//STRIP001     AccSendSelectionEvent();
//STRIP001 }

//STRIP001 sal_Int32 ScCsvGrid::GetColumnType( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     return IsValidColumn( nColIndex ) ? maColStates[ nColIndex ].mnType : CSV_TYPE_NOSELECTION;
//STRIP001 }

//STRIP001 void ScCsvGrid::SetColumnType( sal_uInt32 nColIndex, sal_Int32 nColType )
//STRIP001 {
//STRIP001     if( IsValidColumn( nColIndex ) )
//STRIP001     {
//STRIP001         maColStates[ nColIndex ].mnType = nColType;
//STRIP001         AccSendTableUpdateEvent( nColIndex, nColIndex, false );
//STRIP001     }
//STRIP001 }

//STRIP001 sal_Int32 ScCsvGrid::GetSelColumnType() const
//STRIP001 {
//STRIP001     sal_uInt32 nColIx = GetFirstSelected();
//STRIP001     if( nColIx == CSV_COLUMN_INVALID )
//STRIP001         return CSV_TYPE_NOSELECTION;
//STRIP001 
//STRIP001     sal_Int32 nType = GetColumnType( nColIx );
//STRIP001     while( (nColIx != CSV_COLUMN_INVALID) && (nType != CSV_TYPE_MULTI) )
//STRIP001     {
//STRIP001         if( nType != GetColumnType( nColIx ) )
//STRIP001             nType = CSV_TYPE_MULTI;
//STRIP001         nColIx = GetNextSelected( nColIx );
//STRIP001     }
//STRIP001     return nType;
//STRIP001 }

//STRIP001 void ScCsvGrid::SetSelColumnType( sal_Int32 nType )
//STRIP001 {
//STRIP001     if( (nType != CSV_TYPE_MULTI) && (nType != CSV_TYPE_NOSELECTION) )
//STRIP001     {
//STRIP001         for( sal_uInt32 nColIx = GetFirstSelected(); nColIx != CSV_COLUMN_INVALID; nColIx = GetNextSelected( nColIx ) )
//STRIP001             SetColumnType( nColIx, nType );
//STRIP001         Repaint( true );
//STRIP001         Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::SetTypeNames( const StringVec& rTypeNames )
//STRIP001 {
//STRIP001     DBG_ASSERT( !rTypeNames.empty(), "ScCsvGrid::SetTypeNames - vector is empty" );
//STRIP001     maTypeNames = rTypeNames;
//STRIP001     Repaint( true );
//STRIP001 
//STRIP001     maPopup.Clear();
//STRIP001     sal_uInt32 nCount = maTypeNames.size();
//STRIP001     sal_uInt32 nIx;
//STRIP001     sal_uInt16 nItemId;
//STRIP001     for( nIx = 0, nItemId = 1; nIx < nCount; ++nIx, ++nItemId )
//STRIP001         maPopup.InsertItem( nItemId, maTypeNames[ nIx ] );
//STRIP001 
//STRIP001     ::std::for_each( maColStates.begin(), maColStates.end(), Func_SetType( CSV_TYPE_DEFAULT ) );
//STRIP001 }

//STRIP001 const String& ScCsvGrid::GetColumnTypeName( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     sal_uInt32 nTypeIx = static_cast< sal_uInt32 >( GetColumnType( nColIndex ) );
//STRIP001     return (nTypeIx < maTypeNames.size()) ? maTypeNames[ nTypeIx ] : EMPTY_STRING;
//STRIP001 }

//STRIP001 sal_uInt8 lcl_GetExtColumnType( sal_Int32 nIntType )
//STRIP001 {
//STRIP001     static sal_uInt8 pExtTypes[] =
//STRIP001         { SC_COL_STANDARD, SC_COL_TEXT, SC_COL_DMY, SC_COL_MDY, SC_COL_YMD, SC_COL_ENGLISH, SC_COL_SKIP };
//STRIP001     static sal_Int32 nExtTypeCount = sizeof( pExtTypes ) / sizeof( *pExtTypes );
//STRIP001     return pExtTypes[ ((0 <= nIntType) && (nIntType < nExtTypeCount)) ? nIntType : 0 ];
//STRIP001 }

//STRIP001 void ScCsvGrid::FillColumnDataSep( ScAsciiOptions& rOptions ) const
//STRIP001 {
//STRIP001     sal_uInt32 nCount = GetColumnCount();
//STRIP001     ScCsvExpDataVec aDataVec;
//STRIP001 
//STRIP001     for( sal_uInt32 nColIx = 0; nColIx < nCount; ++nColIx )
//STRIP001     {
//STRIP001         if( GetColumnType( nColIx ) != CSV_TYPE_DEFAULT )
//STRIP001             // 1-based column index
//STRIP001             aDataVec.push_back( ScCsvExpData(
//STRIP001                 static_cast< xub_StrLen >( nColIx + 1 ),
//STRIP001                 lcl_GetExtColumnType( GetColumnType( nColIx ) ) ) );
//STRIP001     }
//STRIP001     rOptions.SetColumnInfo( aDataVec );
//STRIP001 }

//STRIP001 void ScCsvGrid::FillColumnDataFix( ScAsciiOptions& rOptions ) const
//STRIP001 {
//STRIP001     sal_uInt32 nCount = Min( GetColumnCount(), MAXCOL + 1UL );
//STRIP001     ScCsvExpDataVec aDataVec( nCount + 1 );
//STRIP001 
//STRIP001     for( sal_uInt32 nColIx = 0; nColIx < nCount; ++nColIx )
//STRIP001     {
//STRIP001         ScCsvExpData& rData = aDataVec[ nColIx ];
//STRIP001         rData.mnIndex = static_cast< xub_StrLen >(
//STRIP001             Min( static_cast< sal_Int32 >( STRING_MAXLEN ), GetColumnPos( nColIx ) ) );
//STRIP001         rData.mnType = lcl_GetExtColumnType( GetColumnType( nColIx ) );
//STRIP001     }
//STRIP001     aDataVec[ nCount ].mnIndex = STRING_MAXLEN;
//STRIP001     aDataVec[ nCount ].mnType = SC_COL_SKIP;
//STRIP001     rOptions.SetColumnInfo( aDataVec );
//STRIP001 }

//STRIP001 void ScCsvGrid::ScrollVertRel( ScMoveMode eDir )
//STRIP001 {
//STRIP001     sal_Int32 nLine = GetFirstVisLine();
//STRIP001     switch( eDir )
//STRIP001     {
//STRIP001         case MOVE_PREV:     --nLine;                        break;
//STRIP001         case MOVE_NEXT:     ++nLine;                        break;
//STRIP001         case MOVE_FIRST:    nLine = 0;                      break;
//STRIP001         case MOVE_LAST:     nLine = GetMaxLineOffset();     break;
//STRIP001         case MOVE_PREVPAGE: nLine -= GetVisLineCount() - 2; break;
//STRIP001         case MOVE_NEXTPAGE: nLine += GetVisLineCount() - 2; break;
//STRIP001     }
//STRIP001     Execute( CSVCMD_SETLINEOFFSET, nLine );
//STRIP001 }

//STRIP001 void ScCsvGrid::ExecutePopup( const Point& rPos )
//STRIP001 {
//STRIP001     sal_uInt16 nItemId = maPopup.Execute( this, rPos );
//STRIP001     if( nItemId )   // 0 = cancelled
//STRIP001         Execute( CSVCMD_SETCOLUMNTYPE, maPopup.GetItemPos( nItemId ) );
//STRIP001 }


// selection handling ---------------------------------------------------------

//STRIP001 bool ScCsvGrid::IsSelected( sal_uInt32 nColIndex ) const
//STRIP001 {
//STRIP001     return IsValidColumn( nColIndex ) && maColStates[ nColIndex ].IsSelected();
//STRIP001 }

//STRIP001 sal_uInt32 ScCsvGrid::GetFirstSelected() const
//STRIP001 {
//STRIP001     return IsSelected( 0 ) ? 0 : GetNextSelected( 0 );
//STRIP001 }

//STRIP001 sal_uInt32 ScCsvGrid::GetNextSelected( sal_uInt32 nFromIndex ) const
//STRIP001 {
//STRIP001     sal_uInt32 nColCount = GetColumnCount();
//STRIP001     for( sal_uInt32 nColIx = nFromIndex + 1; nColIx < nColCount; ++nColIx )
//STRIP001         if( IsSelected( nColIx ) )
//STRIP001             return nColIx;
//STRIP001     return CSV_COLUMN_INVALID;
//STRIP001 }

//STRIP001 void ScCsvGrid::Select( sal_uInt32 nColIndex, bool bSelect )
//STRIP001 {
//STRIP001     if( IsValidColumn( nColIndex ) )
//STRIP001     {
//STRIP001         maColStates[ nColIndex ].Select( bSelect );
//STRIP001         ImplDrawColumnSelection( nColIndex );
//STRIP001         Repaint();
//STRIP001         Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001         if( bSelect )
//STRIP001             mnRecentSelCol = nColIndex;
//STRIP001         AccSendSelectionEvent();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::ToggleSelect( sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     Select( nColIndex, !IsSelected( nColIndex ) );
//STRIP001 }

//STRIP001 void ScCsvGrid::SelectRange( sal_uInt32 nColIndex1, sal_uInt32 nColIndex2, bool bSelect )
//STRIP001 {
//STRIP001     if( nColIndex1 == CSV_COLUMN_INVALID )
//STRIP001         Select( nColIndex2 );
//STRIP001     else if( nColIndex2 == CSV_COLUMN_INVALID )
//STRIP001         Select( nColIndex1 );
//STRIP001     else if( nColIndex1 > nColIndex2 )
//STRIP001     {
//STRIP001         SelectRange( nColIndex2, nColIndex1, bSelect );
//STRIP001         if( bSelect )
//STRIP001             mnRecentSelCol = nColIndex1;
//STRIP001     }
//STRIP001     else if( IsValidColumn( nColIndex1 ) && IsValidColumn( nColIndex2 ) )
//STRIP001     {
//STRIP001         for( sal_uInt32 nColIx = nColIndex1; nColIx <= nColIndex2; ++nColIx )
//STRIP001         {
//STRIP001             maColStates[ nColIx ].Select( bSelect );
//STRIP001             ImplDrawColumnSelection( nColIx );
//STRIP001         }
//STRIP001         Repaint();
//STRIP001         Execute( CSVCMD_EXPORTCOLUMNTYPE );
//STRIP001         if( bSelect )
//STRIP001             mnRecentSelCol = nColIndex1;
//STRIP001         AccSendSelectionEvent();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::SelectAll( bool bSelect )
//STRIP001 {
//STRIP001     SelectRange( 0, GetColumnCount() - 1, bSelect );
//STRIP001 }

//STRIP001 void ScCsvGrid::MoveCursor( sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     if( IsValidColumn( nColIndex ) )
//STRIP001     {
//STRIP001         sal_Int32 nPosBeg = GetColumnPos( nColIndex );
//STRIP001         sal_Int32 nPosEnd = GetColumnPos( nColIndex + 1 );
//STRIP001         sal_Int32 nMinPos = Max( nPosBeg - CSV_SCROLL_DIST, 0L );
//STRIP001         sal_Int32 nMaxPos = Min( nPosEnd - GetVisPosCount() + CSV_SCROLL_DIST + 1L, nMinPos );
//STRIP001         if( nPosBeg - CSV_SCROLL_DIST + 1 <= GetFirstVisPos() )
//STRIP001             Execute( CSVCMD_SETPOSOFFSET, nMinPos );
//STRIP001         else if( nPosEnd + CSV_SCROLL_DIST >= GetLastVisPos() )
//STRIP001             Execute( CSVCMD_SETPOSOFFSET, nMaxPos );
//STRIP001     }
//STRIP001     Execute( CSVCMD_MOVEGRIDCURSOR, GetColumnPos( nColIndex ) );
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::MoveCursorRel( ScMoveMode eDir )
//STRIP001 {
//STRIP001     if( GetFocusColumn() != CSV_COLUMN_INVALID )
//STRIP001     {
//STRIP001         switch( eDir )
//STRIP001         {
//STRIP001             case MOVE_FIRST:
//STRIP001                 MoveCursor( 0 );
//STRIP001             break;
//STRIP001             case MOVE_LAST:
//STRIP001                 MoveCursor( GetColumnCount() - 1 );
//STRIP001             break;
//STRIP001             case MOVE_PREV:
//STRIP001                 if( GetFocusColumn() > 0 )
//STRIP001                     MoveCursor( GetFocusColumn() - 1 );
//STRIP001             break;
//STRIP001             case MOVE_NEXT:
//STRIP001                 if( GetFocusColumn() < GetColumnCount() - 1 )
//STRIP001                     MoveCursor( GetFocusColumn() + 1 );
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplClearSelection()
//STRIP001 {
//STRIP001     ::std::for_each( maColStates.begin(), maColStates.end(), Func_Select( false ) );
//STRIP001     ImplDrawGridDev();
//STRIP001 }

//STRIP001 void ScCsvGrid::DoSelectAction( sal_uInt32 nColIndex, sal_uInt16 nModifier )
//STRIP001 {
//STRIP001     if( !(nModifier & KEY_MOD1) )
//STRIP001         ImplClearSelection();
//STRIP001     if( nModifier & KEY_SHIFT )             // SHIFT always expands
//STRIP001         SelectRange( mnRecentSelCol, nColIndex );
//STRIP001     else if( !(nModifier & KEY_MOD1) )      // no SHIFT/CTRL always selects 1 column
//STRIP001         Select( nColIndex );
//STRIP001     else if( IsTracking() )                 // CTRL in tracking does not toggle
//STRIP001         Select( nColIndex, mbMTSelecting );
//STRIP001     else                                    // CTRL only toggles
//STRIP001         ToggleSelect( nColIndex );
//STRIP001     Execute( CSVCMD_MOVEGRIDCURSOR, GetColumnPos( nColIndex ) );
//STRIP001 }


// cell contents --------------------------------------------------------------

//STRIP001 void ScCsvGrid::ImplSetTextLineSep(
//STRIP001         sal_Int32 nLine, const String& rTextLine,
//STRIP001         const String& rSepChars, sal_Unicode cTextSep, bool bMergeSep )
//STRIP001 {
//STRIP001     if( nLine < GetFirstVisLine() ) return;
//STRIP001 
//STRIP001     sal_uInt32 nLineIx = nLine - GetFirstVisLine();
//STRIP001     while( maTexts.size() <= nLineIx )
//STRIP001         maTexts.push_back( StringVec() );
//STRIP001     StringVec& rStrVec = maTexts[ nLineIx ];
//STRIP001     rStrVec.clear();
//STRIP001 
//STRIP001     // scan for separators
//STRIP001     String aCellText;
//STRIP001     const sal_Unicode* pSepChars = rSepChars.GetBuffer();
//STRIP001     const sal_Unicode* pChar = rTextLine.GetBuffer();
//STRIP001     sal_uInt32 nColIx = 0;
//STRIP001 
//STRIP001     while( *pChar && (nColIx < CSV_MAXCOLCOUNT) )
//STRIP001     {
//STRIP001         // scan for next cell text
//STRIP001         pChar = ScImportExport::ScanNextFieldFromString( pChar, aCellText, cTextSep, pSepChars, bMergeSep );
//STRIP001 
//STRIP001         // update column width
//STRIP001         sal_Int32 nWidth = Max( CSV_MINCOLWIDTH, aCellText.Len() + 1L );
//STRIP001         if( IsValidColumn( nColIx ) )
//STRIP001         {
//STRIP001             // expand existing column
//STRIP001             sal_Int32 nDiff = nWidth - GetColumnWidth( nColIx );
//STRIP001             if( nDiff > 0 )
//STRIP001             {
//STRIP001                 Execute( CSVCMD_SETPOSCOUNT, GetPosCount() + nDiff );
//STRIP001                 for( sal_uInt32 nSplitIx = GetColumnCount() - 1; nSplitIx > nColIx; --nSplitIx )
//STRIP001                 {
//STRIP001                     sal_Int32 nPos = maSplits[ nSplitIx ];
//STRIP001                     maSplits.Remove( nPos );
//STRIP001                     maSplits.Insert( nPos + nDiff );
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // append new column
//STRIP001             sal_Int32 nLastPos = GetPosCount();
//STRIP001             Execute( CSVCMD_SETPOSCOUNT, nLastPos + nWidth );
//STRIP001             ImplInsertSplit( nLastPos );
//STRIP001         }
//STRIP001 
//STRIP001         if( aCellText.Len() <= CSV_MAXSTRLEN )
//STRIP001             rStrVec.push_back( aCellText );
//STRIP001         else
//STRIP001             rStrVec.push_back( aCellText.Copy( 0, CSV_MAXSTRLEN ) );
//STRIP001         ++nColIx;
//STRIP001     }
//STRIP001     InvalidateGfx();
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplSetTextLineFix( sal_Int32 nLine, const String& rTextLine )
//STRIP001 {
//STRIP001     if( nLine < GetFirstVisLine() ) return;
//STRIP001 
//STRIP001     sal_Int32 nChars = rTextLine.Len();
//STRIP001     if( nChars > GetPosCount() )
//STRIP001         Execute( CSVCMD_SETPOSCOUNT, nChars );
//STRIP001 
//STRIP001     sal_uInt32 nLineIx = nLine - GetFirstVisLine();
//STRIP001     while( maTexts.size() <= nLineIx )
//STRIP001         maTexts.push_back( StringVec() );
//STRIP001 
//STRIP001     StringVec& rStrVec = maTexts[ nLineIx ];
//STRIP001     rStrVec.clear();
//STRIP001     sal_uInt32 nColCount = GetColumnCount();
//STRIP001     xub_StrLen nStrLen = rTextLine.Len();
//STRIP001     xub_StrLen nStrIx = 0;
//STRIP001     for( sal_uInt32 nColIx = 0; (nColIx < nColCount) && (nStrIx < nStrLen); ++nColIx )
//STRIP001     {
//STRIP001         xub_StrLen nChars = static_cast< xub_StrLen >( GetColumnWidth( nColIx ) );
//STRIP001         rStrVec.push_back( rTextLine.Copy( nStrIx, Max( nChars, CSV_MAXSTRLEN ) ) );
//STRIP001         nStrIx += nChars;
//STRIP001     }
//STRIP001     InvalidateGfx();
//STRIP001 }

//STRIP001 const String& ScCsvGrid::GetCellText( sal_uInt32 nColIndex, sal_Int32 nLine ) const
//STRIP001 {
//STRIP001     if( nLine < GetFirstVisLine() ) return EMPTY_STRING;
//STRIP001 
//STRIP001     sal_uInt32 nLineIx = nLine - GetFirstVisLine();
//STRIP001     if( nLineIx >= maTexts.size() ) return EMPTY_STRING;
//STRIP001 
//STRIP001     const StringVec& rStrVec = maTexts[ nLineIx ];
//STRIP001     if( nColIndex >= rStrVec.size() ) return EMPTY_STRING;
//STRIP001 
//STRIP001     return rStrVec[ nColIndex ];
//STRIP001 }


// event handling -------------------------------------------------------------

//STRIP001 void ScCsvGrid::Resize()
//STRIP001 {
//STRIP001     ScCsvControl::Resize();
//STRIP001     InitSizeData();
//STRIP001     Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001 }

//STRIP001 void ScCsvGrid::GetFocus()
//STRIP001 {
//STRIP001     ScCsvControl::GetFocus();
//STRIP001     Execute( CSVCMD_MOVEGRIDCURSOR, GetNoScrollCol( GetGridCursorPos() ) );
//STRIP001     Repaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::LoseFocus()
//STRIP001 {
//STRIP001     ScCsvControl::LoseFocus();
//STRIP001     Repaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     if( !HasFocus() )
//STRIP001         GrabFocus();
//STRIP001 
//STRIP001     Point aPos( rMEvt.GetPosPixel() );
//STRIP001     sal_uInt32 nColIx = GetColumnFromX( aPos.X() );
//STRIP001 
//STRIP001     if( rMEvt.IsLeft() )
//STRIP001     {
//STRIP001         if( (GetFirstX() > aPos.X()) || (aPos.X() > GetLastX()) )   // in header column
//STRIP001         {
//STRIP001             if( aPos.Y() <= GetHdrHeight() )
//STRIP001                 SelectAll();
//STRIP001         }
//STRIP001         else if( IsValidColumn( nColIx ) )
//STRIP001         {
//STRIP001             DoSelectAction( nColIx, rMEvt.GetModifier() );
//STRIP001             mnMTCurrCol = nColIx;
//STRIP001             mbMTSelecting = IsSelected( nColIx );
//STRIP001             StartTracking( STARTTRACK_BUTTONREPEAT );
//STRIP001         }
//STRIP001     }
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::Tracking( const TrackingEvent& rTEvt )
//STRIP001 {
//STRIP001     if( rTEvt.IsTrackingEnded() || rTEvt.IsTrackingRepeat() )
//STRIP001     {
//STRIP001         DisableRepaint();
//STRIP001         const MouseEvent& rMEvt = rTEvt.GetMouseEvent();
//STRIP001 
//STRIP001         sal_Int32 nPos = (rMEvt.GetPosPixel().X() - GetFirstX()) / GetCharWidth() + GetFirstVisPos();
//STRIP001         // on mouse tracking: keep position valid
//STRIP001         nPos = Max( Min( nPos, GetPosCount() - 1L ), 0L );
//STRIP001         Execute( CSVCMD_MAKEPOSVISIBLE, nPos );
//STRIP001 
//STRIP001         sal_uInt32 nColIx = GetColumnFromPos( nPos );
//STRIP001         if( mnMTCurrCol != nColIx )
//STRIP001         {
//STRIP001             DoSelectAction( nColIx, rMEvt.GetModifier() );
//STRIP001             mnMTCurrCol = nColIx;
//STRIP001         }
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     const KeyCode& rKCode = rKEvt.GetKeyCode();
//STRIP001     sal_uInt16 nCode = rKCode.GetCode();
//STRIP001     bool bShift = rKCode.IsShift() == TRUE;
//STRIP001     bool bMod1 = rKCode.IsMod1() == TRUE;
//STRIP001 
//STRIP001     if( !rKCode.IsMod2() )
//STRIP001     {
//STRIP001         ScMoveMode eHDir = GetHorzDirection( nCode, !bMod1 );
//STRIP001         ScMoveMode eVDir = GetVertDirection( nCode, bMod1 );
//STRIP001 
//STRIP001         if( eHDir != MOVE_NONE )
//STRIP001         {
//STRIP001             DisableRepaint();
//STRIP001             MoveCursorRel( eHDir );
//STRIP001             if( !bMod1 )
//STRIP001                 ImplClearSelection();
//STRIP001             if( bShift )
//STRIP001                 SelectRange( mnRecentSelCol, GetFocusColumn() );
//STRIP001             else if( !bMod1 )
//STRIP001                 Select( GetFocusColumn() );
//STRIP001             EnableRepaint();
//STRIP001         }
//STRIP001         else if( eVDir != MOVE_NONE )
//STRIP001             ScrollVertRel( eVDir );
//STRIP001         else if( nCode == KEY_SPACE )
//STRIP001         {
//STRIP001             if( !bMod1 )
//STRIP001                 ImplClearSelection();
//STRIP001             if( bShift )
//STRIP001                 SelectRange( mnRecentSelCol, GetFocusColumn() );
//STRIP001             else if( bMod1 )
//STRIP001                 ToggleSelect( GetFocusColumn() );
//STRIP001             else
//STRIP001                 Select( GetFocusColumn() );
//STRIP001         }
//STRIP001         else if( !bShift && bMod1 )
//STRIP001         {
//STRIP001             if( nCode == KEY_A )
//STRIP001                 SelectAll();
//STRIP001             else if( (KEY_1 <= nCode) && (nCode <= KEY_9) )
//STRIP001             {
//STRIP001                 sal_uInt32 nType = nCode - KEY_1;
//STRIP001                 if( nType < maTypeNames.size() )
//STRIP001                     Execute( CSVCMD_SETCOLUMNTYPE, nType );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if( rKCode.GetGroup() != KEYGROUP_CURSOR )
//STRIP001         ScCsvControl::KeyInput( rKEvt );
//STRIP001 }

//STRIP001 void ScCsvGrid::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001     switch( rCEvt.GetCommand() )
//STRIP001     {
//STRIP001         case COMMAND_CONTEXTMENU:
//STRIP001         {
//STRIP001             if( rCEvt.IsMouseEvent() )
//STRIP001             {
//STRIP001                 Point aPos( rCEvt.GetMousePosPixel() );
//STRIP001                 sal_uInt32 nColIx = GetColumnFromX( aPos.X() );
//STRIP001                 if( IsValidColumn( nColIx ) && (GetFirstX() <= aPos.X()) && (aPos.X() <= GetLastX()) )
//STRIP001                 {
//STRIP001                     if( !IsSelected( nColIx ) )
//STRIP001                         DoSelectAction( nColIx, 0 );    // focus & select
//STRIP001                     ExecutePopup( aPos );
//STRIP001                 }
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 sal_uInt32 nColIx = GetFocusColumn();
//STRIP001                 if( !IsSelected( nColIx ) )
//STRIP001                     Select( nColIx );
//STRIP001                 sal_Int32 nX1 = Max( GetColumnX( nColIx ), GetFirstX() );
//STRIP001                 sal_Int32 nX2 = Min( GetColumnX( nColIx + 1 ), GetWidth() );
//STRIP001                 ExecutePopup( Point( (nX1 + nX2) / 2, GetHeight() / 2 ) );
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001         case COMMAND_WHEEL:
//STRIP001         {
//STRIP001             Point aPoint;
//STRIP001             Rectangle aRect( aPoint, maWinSize );
//STRIP001             if( aRect.IsInside( rCEvt.GetMousePosPixel() ) )
//STRIP001             {
//STRIP001                 const CommandWheelData* pData = rCEvt.GetWheelData();
//STRIP001                 if( pData && (pData->GetMode() == COMMAND_WHEEL_SCROLL) && !pData->IsHorz() )
//STRIP001                     Execute( CSVCMD_SETLINEOFFSET, GetFirstVisLine() - pData->GetNotchDelta() );
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001         default:
//STRIP001             ScCsvControl::Command( rCEvt );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         InitColors();
//STRIP001         InitFonts();
//STRIP001         UpdateLayoutData();
//STRIP001         Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001     }
//STRIP001     ScCsvControl::DataChanged( rDCEvt );
//STRIP001 }

//STRIP001 void ScCsvGrid::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001     if( rHint.ISA( SfxSimpleHint ) &&
//STRIP001         (static_cast< const SfxSimpleHint& >( rHint ).GetId() == SFX_HINT_COLORS_CHANGED) )
//STRIP001     {
//STRIP001         InitColors();
//STRIP001         Repaint();
//STRIP001     }
//STRIP001 }


// painting -------------------------------------------------------------------

//STRIP001 void ScCsvGrid::Paint( const Rectangle& )
//STRIP001 {
//STRIP001     Repaint();
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplRedraw()
//STRIP001 {
//STRIP001     if( IsVisible() )
//STRIP001     {
//STRIP001         if( !IsValidGfx() )
//STRIP001         {
//STRIP001             ValidateGfx();
//STRIP001             ImplDrawBackgrDev();
//STRIP001             ImplDrawGridDev();
//STRIP001         }
//STRIP001         DrawOutDev( Point(), maWinSize, Point(), maWinSize, maGridDev );
//STRIP001         ImplDrawTrackingRect( GetFocusColumn() );
//STRIP001     }
//STRIP001 }

//STRIP001 EditEngine* ScCsvGrid::GetEditEngine()
//STRIP001 {
//STRIP001     return mpEditEngine.get();
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplSetColumnClipRegion( OutputDevice& rOutDev, sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     rOutDev.SetClipRegion( Region( Rectangle(
//STRIP001         Max( GetColumnX( nColIndex ), GetFirstX() ) + 1, 0,
//STRIP001         Min( GetColumnX( nColIndex + 1 ), GetLastX() ), GetHeight() - 1 ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 void ScCsvGrid::ImplDrawColumnHeader( OutputDevice& rOutDev, sal_uInt32 nColIndex, Color aFillColor )
//STRIP001 {
//STRIP001     sal_Int32 nX1 = GetColumnX( nColIndex ) + 1;
//STRIP001     sal_Int32 nX2 = GetColumnX( nColIndex + 1 );
//STRIP001     sal_Int32 nHdrHt = GetHdrHeight();
//STRIP001 
//STRIP001     rOutDev.SetLineColor();
//STRIP001     rOutDev.SetFillColor( aFillColor );
//STRIP001     rOutDev.DrawRect( Rectangle( nX1, 0, nX2, nHdrHt ) );
//STRIP001 
//STRIP001     rOutDev.SetFont( maHeaderFont );
//STRIP001     rOutDev.SetTextColor( maHeaderTextColor );
//STRIP001     rOutDev.SetTextFillColor();
//STRIP001     rOutDev.DrawText( Point( nX1 + 1, 0 ), GetColumnTypeName( nColIndex ) );
//STRIP001 
//STRIP001     rOutDev.SetLineColor( maHeaderGridColor );
//STRIP001     rOutDev.DrawLine( Point( nX1, nHdrHt ), Point( nX2, nHdrHt ) );
//STRIP001     rOutDev.DrawLine( Point( nX2, 0 ), Point( nX2, nHdrHt ) );
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawCellText( const Point& rPos, const String& rText )
//STRIP001 {
//STRIP001     String aText( rText );
//STRIP001     aText.SearchAndReplaceAll( '\t', ' ' );
//STRIP001     mpEditEngine->SetPaperSize( maEdEngSize );
//STRIP001     mpEditEngine->SetText( aText );
//STRIP001     mpEditEngine->Draw( &maBackgrDev, rPos );
//STRIP001 
//STRIP001     xub_StrLen nCharIx = 0;
//STRIP001     while( (nCharIx = rText.Search( '\t', nCharIx )) != STRING_NOTFOUND )
//STRIP001     {
//STRIP001         sal_Int32 nX1 = rPos.X() + GetCharWidth() * nCharIx;
//STRIP001         sal_Int32 nX2 = nX1 + GetCharWidth() - 2;
//STRIP001         sal_Int32 nY = rPos.Y() + GetLineHeight() / 2;
//STRIP001         Color aColor( maTextColor );
//STRIP001         maBackgrDev.SetLineColor( aColor );
//STRIP001         maBackgrDev.DrawLine( Point( nX1, nY ), Point( nX2 - 1, nY ) );
//STRIP001         maBackgrDev.DrawLine( Point( nX2 - 2, nY - 1 ), Point( nX2 - 2, nY + 1 ) );
//STRIP001         aColor.Merge( maBackColor, 50 );
//STRIP001         maBackgrDev.SetLineColor( aColor );
//STRIP001         maBackgrDev.DrawLine( Point( nX2 - 2, nY - 2 ), Point( nX2, nY ) );
//STRIP001         maBackgrDev.DrawLine( Point( nX2 - 2, nY + 2 ), Point( nX2, nY ) );
//STRIP001         ++nCharIx;
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawFirstLineSep( bool bSet )
//STRIP001 {
//STRIP001     if( IsVisibleLine( mnFirstImpLine ) && (mnFirstImpLine != GetFirstVisLine() ) )
//STRIP001     {
//STRIP001         sal_Int32 nY = GetY( mnFirstImpLine );
//STRIP001         sal_Int32 nX = Min( GetColumnX( GetLastVisColumn() + 1 ), GetLastX() );
//STRIP001         maBackgrDev.SetLineColor( bSet ? maGridPBColor : maGridColor );
//STRIP001         maBackgrDev.DrawLine( Point( GetFirstX() + 1, nY ), Point( nX, nY ) );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void ScCsvGrid::ImplDrawColumnBackgr( sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     if( !IsVisibleColumn( nColIndex ) )
//STRIP001         return;
//STRIP001 
//STRIP001     ImplSetColumnClipRegion( maBackgrDev, nColIndex );
//STRIP001 
//STRIP001     sal_Int32 nX1 = GetColumnX( nColIndex ) + 1;
//STRIP001     sal_Int32 nX2 = GetColumnX( nColIndex + 1 );
//STRIP001     sal_Int32 nY2 = GetY( GetLastVisLine() + 1 );
//STRIP001     sal_Int32 nHdrHt = GetHdrHeight();
//STRIP001 
//STRIP001     // grid
//STRIP001     maBackgrDev.SetLineColor();
//STRIP001     maBackgrDev.SetFillColor( maBackColor );
//STRIP001     Rectangle aRect( nX1, nHdrHt, nX2, nY2 );
//STRIP001     maBackgrDev.DrawRect( aRect );
//STRIP001     maBackgrDev.SetLineColor( maGridColor );
//STRIP001     maBackgrDev.DrawGrid( aRect, Size( 1, GetLineHeight() ), GRID_HORZLINES );
//STRIP001     maBackgrDev.DrawLine( Point( nX2, nHdrHt ), Point( nX2, nY2 ) );
//STRIP001     ImplDrawFirstLineSep( true );
//STRIP001 
//STRIP001     // cell texts
//STRIP001     mpEditEngine->SetDefaultItem( SvxColorItem( maTextColor, EE_CHAR_COLOR ) );
//STRIP001     sal_Int32 nLineCount = Min( GetLastVisLine() - GetFirstVisLine() + 1UL, maTexts.size() );
//STRIP001     for( sal_Int32 nLine = 0; nLine < nLineCount; ++nLine )
//STRIP001     {
//STRIP001         StringVec& rStrVec = maTexts[ nLine ];
//STRIP001         if( nColIndex < rStrVec.size() )
//STRIP001             ImplDrawCellText( Point( nX1, GetY( GetFirstVisLine() + nLine ) ), rStrVec[ nColIndex ] );
//STRIP001     }
//STRIP001 
//STRIP001     // header
//STRIP001     ImplDrawColumnHeader( maBackgrDev, nColIndex, maHeaderBackColor );
//STRIP001 
//STRIP001     maBackgrDev.SetClipRegion();
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawRowHeaders()
//STRIP001 {
//STRIP001     maBackgrDev.SetLineColor();
//STRIP001     maBackgrDev.SetFillColor( maAppBackColor );
//STRIP001     Point aPoint( GetHdrX(), 0 );
//STRIP001     Rectangle aRect( aPoint, Size( GetHdrWidth() + 1, GetHeight() ) );
//STRIP001     maBackgrDev.DrawRect( aRect );
//STRIP001 
//STRIP001     maBackgrDev.SetFillColor( maHeaderBackColor );
//STRIP001     aRect.Bottom() = GetY( GetLastVisLine() + 1 );
//STRIP001     maBackgrDev.DrawRect( aRect );
//STRIP001 
//STRIP001     // line numbers
//STRIP001     maBackgrDev.SetFont( maHeaderFont );
//STRIP001     maBackgrDev.SetTextColor( maHeaderTextColor );
//STRIP001     maBackgrDev.SetTextFillColor();
//STRIP001     sal_Int32 nLastLine = GetLastVisLine();
//STRIP001     for( sal_Int32 nLine = GetFirstVisLine(); nLine <= nLastLine; ++nLine )
//STRIP001     {
//STRIP001         String aText( String::CreateFromInt32( nLine + 1 ) );
//STRIP001         sal_Int32 nX = GetHdrX() + (GetHdrWidth() - maBackgrDev.GetTextWidth( aText )) / 2;
//STRIP001         maBackgrDev.DrawText( Point( nX, GetY( nLine ) ), aText );
//STRIP001     }
//STRIP001 
//STRIP001     // grid
//STRIP001     maBackgrDev.SetLineColor( maHeaderGridColor );
//STRIP001     if( IsRTL() )
//STRIP001     {
//STRIP001         maBackgrDev.DrawLine( Point( 0, 0 ), Point( 0, GetHeight() - 1 ) );
//STRIP001         maBackgrDev.DrawLine( aRect.TopLeft(), aRect.BottomLeft() );
//STRIP001     }
//STRIP001     else
//STRIP001         maBackgrDev.DrawLine( aRect.TopRight(), aRect.BottomRight() );
//STRIP001     aRect.Top() = GetHdrHeight();
//STRIP001     maBackgrDev.DrawGrid( aRect, Size( 1, GetLineHeight() ), GRID_HORZLINES );
//STRIP001 }
//STRIP001 
//STRIP001 void ScCsvGrid::ImplDrawBackgrDev()
//STRIP001 {
//STRIP001     maBackgrDev.SetLineColor();
//STRIP001     maBackgrDev.SetFillColor( maAppBackColor );
//STRIP001     maBackgrDev.DrawRect( Rectangle(
//STRIP001         Point( GetFirstX() + 1, 0 ), Size( GetWidth() - GetHdrWidth(), GetHeight() ) ) );
//STRIP001 
//STRIP001     sal_uInt32 nLastCol = GetLastVisColumn();
//STRIP001     for( sal_uInt32 nColIx = GetFirstVisColumn(); nColIx <= nLastCol; ++nColIx )
//STRIP001         ImplDrawColumnBackgr( nColIx );
//STRIP001 
//STRIP001     ImplDrawRowHeaders();
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawColumnSelection( sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     ImplInvertCursor( GetRulerCursorPos() );
//STRIP001     ImplSetColumnClipRegion( maGridDev, nColIndex );
//STRIP001     maGridDev.DrawOutDev( Point(), maWinSize, Point(), maWinSize, maBackgrDev );
//STRIP001 
//STRIP001     if( IsSelected( nColIndex ) )
//STRIP001     {
//STRIP001         sal_Int32 nX1 = GetColumnX( nColIndex ) + 1;
//STRIP001         sal_Int32 nX2 = GetColumnX( nColIndex + 1 );
//STRIP001 
//STRIP001         // header
//STRIP001         Rectangle aRect( nX1, 0, nX2, GetHdrHeight() );
//STRIP001         maGridDev.SetLineColor();
//STRIP001         if( maHeaderBackColor.IsDark() )
//STRIP001             // redraw with light gray background in dark mode
//STRIP001             ImplDrawColumnHeader( maGridDev, nColIndex, COL_LIGHTGRAY );
//STRIP001         else
//STRIP001         {
//STRIP001             // use transparent active color
//STRIP001             maGridDev.SetFillColor( maSelectColor );
//STRIP001             maGridDev.DrawTransparent( PolyPolygon( Polygon( aRect ) ), CSV_HDR_TRANSPARENCY );
//STRIP001         }
//STRIP001 
//STRIP001         // column selection
//STRIP001         aRect = Rectangle( nX1, GetHdrHeight() + 1, nX2, GetY( GetLastVisLine() + 1 ) - 1 );
//STRIP001         ImplInvertRect( maGridDev, aRect );
//STRIP001     }
//STRIP001 
//STRIP001     maGridDev.SetClipRegion();
//STRIP001     ImplInvertCursor( GetRulerCursorPos() );
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawGridDev()
//STRIP001 {
//STRIP001     maGridDev.DrawOutDev( Point(), maWinSize, Point(), maWinSize, maBackgrDev );
//STRIP001     sal_uInt32 nLastCol = GetLastVisColumn();
//STRIP001     for( sal_uInt32 nColIx = GetFirstVisColumn(); nColIx <= nLastCol; ++nColIx )
//STRIP001         ImplDrawColumnSelection( nColIx );
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawColumn( sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     ImplDrawColumnBackgr( nColIndex );
//STRIP001     ImplDrawColumnSelection( nColIndex );
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplDrawHorzScrolled( sal_Int32 nOldPos )
//STRIP001 {
//STRIP001     sal_Int32 nPos = GetFirstVisPos();
//STRIP001     if( !IsValidGfx() || (nPos == nOldPos) )
//STRIP001         return;
//STRIP001     if( Abs( nPos - nOldPos ) > GetVisPosCount() / 2 )
//STRIP001     {
//STRIP001         ImplDrawBackgrDev();
//STRIP001         ImplDrawGridDev();
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001     Point aSrc, aDest;
//STRIP001     sal_uInt32 nFirstColIx, nLastColIx;
//STRIP001     if( nPos < nOldPos )
//STRIP001     {
//STRIP001         aSrc = Point( GetFirstX() + 1, 0 );
//STRIP001         aDest = Point( GetFirstX() + GetCharWidth() * (nOldPos - nPos) + 1, 0 );
//STRIP001         nFirstColIx = GetColumnFromPos( nPos );
//STRIP001         nLastColIx = GetColumnFromPos( nOldPos );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aSrc = Point( GetFirstX() + GetCharWidth() * (nPos - nOldPos) + 1, 0 );
//STRIP001         aDest = Point( GetFirstX() + 1, 0 );
//STRIP001         nFirstColIx = GetColumnFromPos( Min( nOldPos + GetVisPosCount(), GetPosCount() ) - 1 );
//STRIP001         nLastColIx = GetColumnFromPos( Min( nPos + GetVisPosCount(), GetPosCount() ) - 1 );
//STRIP001     }
//STRIP001 
//STRIP001     ImplInvertCursor( GetRulerCursorPos() + (nPos - nOldPos) );
//STRIP001     Rectangle aRectangle( GetFirstX(), 0, GetLastX(), GetHeight() - 1 );
//STRIP001     Region aClipReg( aRectangle );
//STRIP001     maBackgrDev.SetClipRegion( aClipReg );
//STRIP001     maBackgrDev.CopyArea( aDest, aSrc, maWinSize );
//STRIP001     maBackgrDev.SetClipRegion();
//STRIP001     maGridDev.SetClipRegion( aClipReg );
//STRIP001     maGridDev.CopyArea( aDest, aSrc, maWinSize );
//STRIP001     maGridDev.SetClipRegion();
//STRIP001     ImplInvertCursor( GetRulerCursorPos() );
//STRIP001 
//STRIP001     for( sal_uInt32 nColIx = nFirstColIx; nColIx <= nLastColIx; ++nColIx )
//STRIP001         ImplDrawColumn( nColIx );
//STRIP001 
//STRIP001     sal_Int32 nLastX = GetX( GetPosCount() ) + 1;
//STRIP001     if( nLastX <= GetLastX() )
//STRIP001     {
//STRIP001         Rectangle aRect( nLastX, 0, GetLastX(), GetHeight() - 1 );
//STRIP001         maBackgrDev.SetLineColor();
//STRIP001         maBackgrDev.SetFillColor( maAppBackColor );
//STRIP001         maBackgrDev.DrawRect( aRect );
//STRIP001         maGridDev.SetLineColor();
//STRIP001         maGridDev.SetFillColor( maAppBackColor );
//STRIP001         maGridDev.DrawRect( aRect );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvGrid::ImplInvertCursor( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( IsVisibleSplitPos( nPos ) )
//STRIP001     {
//STRIP001         sal_Int32 nX = GetX( nPos ) - 1;
//STRIP001         Rectangle aRect( Point( nX, 0 ), Size( 3, GetHdrHeight() ) );
//STRIP001         ImplInvertRect( maGridDev, aRect );
//STRIP001         aRect.Top() = GetHdrHeight() + 1;
//STRIP001         aRect.Bottom() = GetY( GetLastVisLine() + 1 );
//STRIP001         ImplInvertRect( maGridDev, aRect );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void ScCsvGrid::ImplDrawTrackingRect( sal_uInt32 nColIndex )
//STRIP001 {
//STRIP001     if( HasFocus() && IsVisibleColumn( nColIndex ) )
//STRIP001     {
//STRIP001         sal_Int32 nX1 = Max( GetColumnX( nColIndex ), GetFirstX() ) + 1;
//STRIP001         sal_Int32 nX2 = Min( GetColumnX( nColIndex + 1 ) - 1L, GetLastX() );
//STRIP001         sal_Int32 nY2 = Min( GetY( GetLastVisLine() + 1 ), GetHeight() ) - 1;
//STRIP001         InvertTracking( Rectangle( nX1, 0, nX2, nY2 ), SHOWTRACK_SMALL | SHOWTRACK_WINDOW );
//STRIP001     }
//STRIP001 }


// accessibility ==============================================================

//STRIP001 ScAccessibleCsvControl* ScCsvGrid::ImplCreateAccessible()
//STRIP001 {
//STRIP001     return new ScAccessibleCsvGrid( *this );
//STRIP001 }


// ============================================================================

}
