/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dapidata.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:57:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include <tools/debug.hxx>
#include <vcl/waitobj.hxx>
#include <comphelper/processfactory.hxx>

#include <com/sun/star/sheet/DataImportMode.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#include <com/sun/star/sdb/XQueriesSupplier.hpp>
#include <com/sun/star/sdb/XCompletedConnection.hpp>

using namespace ::com::sun::star;

#include "dapidata.hxx"
#include "scresid.hxx"
#include "bf_sc.hrc"
#include "dapitype.hrc"
#include "miscuno.hxx"
#include "dpsdbtab.hxx"			// ScImportSourceDesc
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {
//-------------------------------------------------------------------------

#define DP_SERVICE_DBCONTEXT		"com.sun.star.sdb.DatabaseContext"
#define SC_SERVICE_INTHANDLER		"com.sun.star.sdb.InteractionHandler"

//	entries in the "type" ListBox
#define DP_TYPELIST_TABLE	0
#define DP_TYPELIST_QUERY	1
#define DP_TYPELIST_SQL		2
#define DP_TYPELIST_SQLNAT	3

//-------------------------------------------------------------------------

//STRIP001 ScDataPilotDatabaseDlg::ScDataPilotDatabaseDlg( Window* pParent ) :
//STRIP001 	ModalDialog     ( pParent, ScResId( RID_SCDLG_DAPIDATA ) ),
//STRIP001 	//
//STRIP001 	aBtnOk          ( this, ScResId( BTN_OK ) ),
//STRIP001 	aBtnCancel      ( this, ScResId( BTN_CANCEL ) ),
//STRIP001 	aBtnHelp        ( this, ScResId( BTN_HELP ) ),
//STRIP001 	aFtDatabase     ( this, ScResId( FT_DATABASE ) ),
//STRIP001 	aLbDatabase     ( this, ScResId( LB_DATABASE ) ),
//STRIP001 	aFtObject       ( this, ScResId( FT_OBJECT ) ),
//STRIP001 	aCbObject       ( this, ScResId( CB_OBJECT ) ),
//STRIP001 	aFtType         ( this, ScResId( FT_OBJTYPE ) ),
//STRIP001 	aLbType         ( this, ScResId( LB_OBJTYPE ) ),
//STRIP001     aFlFrame        ( this, ScResId( FL_FRAME ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	WaitObject aWait( this );		// initializing the database service the first time takes a while
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		//	get database names
//STRIP001 
//STRIP001 		uno::Reference<container::XNameAccess> xContext(
//STRIP001 				::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 					::rtl::OUString::createFromAscii( DP_SERVICE_DBCONTEXT ) ),
//STRIP001 				uno::UNO_QUERY);
//STRIP001 		if (xContext.is())
//STRIP001 		{
//STRIP001 			uno::Sequence<rtl::OUString> aNames = xContext->getElementNames();
//STRIP001 			long nCount = aNames.getLength();
//STRIP001 			const ::rtl::OUString* pArray = aNames.getConstArray();
//STRIP001 			for (long nPos = 0; nPos < nCount; nPos++)
//STRIP001 			{
//STRIP001 				String aName = pArray[nPos];
//STRIP001 				aLbDatabase.InsertEntry( aName );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch(uno::Exception&)
//STRIP001 	{
//STRIP001 		DBG_ERROR("exception in database");
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbDatabase.SelectEntryPos( 0 );
//STRIP001 	aLbType.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 	FillObjects();
//STRIP001 
//STRIP001 	aLbDatabase.SetSelectHdl( LINK( this, ScDataPilotDatabaseDlg, SelectHdl ) );
//STRIP001 	aLbType.SetSelectHdl( LINK( this, ScDataPilotDatabaseDlg, SelectHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 ScDataPilotDatabaseDlg::~ScDataPilotDatabaseDlg()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void ScDataPilotDatabaseDlg::GetValues( ScImportSourceDesc& rDesc )
//STRIP001 {
//STRIP001 	USHORT nSelect = aLbType.GetSelectEntryPos();
//STRIP001 
//STRIP001 	rDesc.aDBName = aLbDatabase.GetSelectEntry();
//STRIP001 	rDesc.aObject = aCbObject.GetText();
//STRIP001 
//STRIP001 	if ( !rDesc.aDBName.Len() || !rDesc.aObject.Len() )
//STRIP001 		rDesc.nType = sheet::DataImportMode_NONE;
//STRIP001 	else if ( nSelect == DP_TYPELIST_TABLE )
//STRIP001 		rDesc.nType = sheet::DataImportMode_TABLE;
//STRIP001 	else if ( nSelect == DP_TYPELIST_QUERY )
//STRIP001 		rDesc.nType = sheet::DataImportMode_QUERY;
//STRIP001 	else
//STRIP001 		rDesc.nType = sheet::DataImportMode_SQL;
//STRIP001 
//STRIP001 	rDesc.bNative = ( nSelect == DP_TYPELIST_SQLNAT );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( ScDataPilotDatabaseDlg, SelectHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	FillObjects();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void ScDataPilotDatabaseDlg::FillObjects()
//STRIP001 {
//STRIP001 	aCbObject.Clear();
//STRIP001 
//STRIP001 	String aDatabaseName = aLbDatabase.GetSelectEntry();
//STRIP001 	if (!aDatabaseName.Len())
//STRIP001 		return;
//STRIP001 
//STRIP001 	USHORT nSelect = aLbType.GetSelectEntryPos();
//STRIP001 	if ( nSelect > DP_TYPELIST_QUERY )
//STRIP001 		return;									// only tables and queries
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		//	open connection (for tables or queries)
//STRIP001 
//STRIP001 		uno::Reference<container::XNameAccess> xContext(
//STRIP001 				::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 					::rtl::OUString::createFromAscii( DP_SERVICE_DBCONTEXT ) ),
//STRIP001 				uno::UNO_QUERY);
//STRIP001 		if ( !xContext.is() ) return;
//STRIP001 
//STRIP001 		uno::Any aSourceAny = xContext->getByName( aDatabaseName );
//STRIP001 		uno::Reference<sdb::XCompletedConnection> xSource(
//STRIP001 				ScUnoHelpFunctions::AnyToInterface( aSourceAny ), uno::UNO_QUERY );
//STRIP001 		if ( !xSource.is() ) return;
//STRIP001 
//STRIP001 		uno::Reference<task::XInteractionHandler> xHandler(
//STRIP001 				::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 					::rtl::OUString::createFromAscii( SC_SERVICE_INTHANDLER ) ),
//STRIP001 				uno::UNO_QUERY);
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XConnection> xConnection = xSource->connectWithCompletion( xHandler );
//STRIP001 
//STRIP001 		uno::Sequence<rtl::OUString> aNames;
//STRIP001 		if ( nSelect == DP_TYPELIST_TABLE )
//STRIP001 		{
//STRIP001 			//	get all tables
//STRIP001 
//STRIP001 			uno::Reference<sdbcx::XTablesSupplier> xTablesSupp( xConnection, uno::UNO_QUERY );
//STRIP001 			if ( !xTablesSupp.is() ) return;
//STRIP001 
//STRIP001 			uno::Reference<container::XNameAccess> xTables = xTablesSupp->getTables(); 
//STRIP001 			if ( !xTables.is() ) return;
//STRIP001 
//STRIP001 			aNames = xTables->getElementNames();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	get all queries
//STRIP001 
//STRIP001 			uno::Reference<sdb::XQueriesSupplier> xQueriesSupp( xConnection, uno::UNO_QUERY );
//STRIP001 			if ( !xQueriesSupp.is() ) return;
//STRIP001 
//STRIP001 			uno::Reference<container::XNameAccess> xQueries = xQueriesSupp->getQueries(); 
//STRIP001 			if ( !xQueries.is() ) return;
//STRIP001 
//STRIP001 			aNames = xQueries->getElementNames();
//STRIP001 		}
//STRIP001 		
//STRIP001 		//	fill list
//STRIP001 
//STRIP001 		long nCount = aNames.getLength();
//STRIP001 		const ::rtl::OUString* pArray = aNames.getConstArray();
//STRIP001 		for( long nPos=0; nPos<nCount; nPos++ )
//STRIP001 		{
//STRIP001 			String aName = pArray[nPos];
//STRIP001 			aCbObject.InsertEntry( aName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch(uno::Exception&)
//STRIP001 	{
//STRIP001 		//	#71604# this may happen if an invalid database is selected -> no DBG_ERROR
//STRIP001 		DBG_WARNING("exception in database");
//STRIP001 	}
//STRIP001 }




}
