/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_output2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:30:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop


// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/adjitem.hxx>
#include <bf_svx/algitem.hxx>
// auto strip #include <bf_svx/brshitem.hxx>
#include <svtools/colorcfg.hxx>
// auto strip #include <bf_svx/colritem.hxx>
// auto strip #include <bf_svx/editobj.hxx>
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #include <bf_svx/fhgtitem.hxx>
// auto strip #include <bf_svx/forbiddencharacterstable.hxx>
// auto strip #include <bf_svx/frmdiritem.hxx>
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #include <bf_svx/rotmodit.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #include <bf_svx/udlnitem.hxx>
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #include <svtools/zforlist.hxx>
#include <vcl/svapp.hxx>
#include <vcl/metric.hxx>
#include <vcl/outdev.hxx>
#include <math.h>

#include "output.hxx"
#include "document.hxx"
// auto strip #include "cell.hxx"
// auto strip #include "attrib.hxx"
#include "patattr.hxx"
// auto strip #include "cellform.hxx"
#include "editutil.hxx"
// auto strip #include "progress.hxx"
#include "scmod.hxx"
namespace binfilter {

			//!	Autofilter-Breite mit column.cxx zusammenfassen
#define DROPDOWN_BITMAP_SIZE		17

#define DRAWTEXT_MAX	32767


// STATIC DATA -----------------------------------------------------------

// -----------------------------------------------------------------------

class ScDrawStringsVars
{
	ScOutputData*		pOutput;				// Verbindung
	SvNumberFormatter*	pFormatter;

	const ScPatternAttr* pPattern;				// Attribute
	const SfxItemSet*	pCondSet;				// aus bedingter Formatierung

	Font				aFont;					// aus Attributen erzeugt
	FontMetric			aMetric;
	long				nAscentPixel;			// always pixels
	SvxCellOrientation	eAttrOrient;
	SvxCellHorJustify	eAttrHorJust;
	SvxCellVerJustify	eAttrVerJust;
	const SvxMarginItem* pMargin;
	USHORT				nIndent;
	BOOL				bRotated;

	String				aString;				// Inhalte
	Size				aTextSize;
	long				nOriginalWidth;

	ScBaseCell*			pLastCell;
	ULONG				nValueFormat;
	BOOL				bLineBreak;

	BOOL				bPixelToLogic;
	BOOL				bCellContrast;

	Color				aBackConfigColor;		// used for ScPatternAttr::GetFont calls
	Color				aTextConfigColor;

public:
				ScDrawStringsVars(ScOutputData* pData, BOOL bPTL);
				~ScDrawStringsVars();

				//	SetPattern = ex-SetVars
				//	SetPatternSimple: ohne Font

//STRIP001 	void		SetPattern( const ScPatternAttr* pNew, const SfxItemSet* pSet, ScBaseCell* pCell, BYTE nScript );
//STRIP001 	void		SetPatternSimple( const ScPatternAttr* pNew, const SfxItemSet* pSet );

//STRIP001 	BOOL		SetText( ScBaseCell* pCell );	// TRUE -> pOldPattern vergessen
//STRIP001 	void		ResetText();
//STRIP001 	void		SetHashText();

	const ScPatternAttr*	GetPattern() const		{ return pPattern; }
	SvxCellOrientation		GetOrient() const		{ return eAttrOrient; }
	SvxCellHorJustify		GetHorJust() const		{ return eAttrHorJust; }
	SvxCellVerJustify		GetVerJust() const		{ return eAttrVerJust; }
	const SvxMarginItem*	GetMargin() const		{ return pMargin; }

	USHORT	GetLeftTotal() const		{ return pMargin->GetLeftMargin() + nIndent; }

	const String&			GetString() const		{ return aString; }
	const Size&				GetTextSize() const		{ return aTextSize; }
	long					GetOriginalWidth() const { return nOriginalWidth; }

	ULONG	GetValueFormat() const					{ return nValueFormat; }
	BOOL	GetLineBreak() const					{ return bLineBreak; }

	long	GetAscent() const	{ return nAscentPixel; }
	BOOL	IsRotated() const	{ return bRotated; }

	BOOL	HasCondHeight() const	{ return pCondSet && SFX_ITEM_SET ==
										pCondSet->GetItemState( ATTR_FONT_HEIGHT, TRUE ); }

	BOOL	IsRightToLeftAttr() const;
};

//==================================================================

/*M*/ ScDrawStringsVars::ScDrawStringsVars(ScOutputData* pData, BOOL bPTL) :
/*M*/ 	pOutput		( pData ),
/*M*/ 	bPixelToLogic( bPTL ),
/*M*/ 	pPattern	( NULL ),
/*M*/ 	pCondSet	( NULL ),
/*M*/ 	pMargin		( NULL ),
/*M*/ 	nOriginalWidth( 0 ),
/*M*/ 	nIndent		( 0 ),
/*M*/ 	bRotated	( FALSE ),
/*M*/ 	eAttrHorJust( SVX_HOR_JUSTIFY_STANDARD ),
/*M*/ 	eAttrVerJust( SVX_VER_JUSTIFY_BOTTOM ),
/*M*/ 	eAttrOrient	( SVX_ORIENTATION_STANDARD ),
/*M*/ 	bLineBreak	( FALSE ),
/*M*/ 	nValueFormat( 0 ),
/*M*/ 	pLastCell	( NULL )
/*M*/ {
/*M*/ 	pFormatter = pData->pDoc->GetFormatTable();
/*M*/ 
/*M*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	bCellContrast = pOutput->bUseStyleColor &&
/*N*/ 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/ 
/*N*/     const svtools::ColorConfig& rColorConfig = pScMod->GetColorConfig();
/*N*/     aBackConfigColor.SetColor( rColorConfig.GetColorValue(svtools::DOCCOLOR).nColor );
/*N*/     aTextConfigColor.SetColor( rColorConfig.GetColorValue(svtools::FONTCOLOR).nColor );
/*M*/ }

/*N*/ ScDrawStringsVars::~ScDrawStringsVars()
/*N*/ {
/*N*/ }

//STRIP001 void ScDrawStringsVars::SetPattern( const ScPatternAttr* pNew, const SfxItemSet* pSet,
//STRIP001 									ScBaseCell* pCell, BYTE nScript )
//STRIP001 {
//STRIP001 	pPattern = pNew;
//STRIP001 	pCondSet = pSet;
//STRIP001 
//STRIP001 	//	pPattern auswerten
//STRIP001 
//STRIP001 	OutputDevice* pDev = pOutput->pDev;
//STRIP001 	OutputDevice* pRefDevice = pOutput->pRefDevice;
//STRIP001 	OutputDevice* pFmtDevice = pOutput->pFmtDevice;
//STRIP001 
//STRIP001 	//	Font
//STRIP001 
//STRIP001 	ScAutoFontColorMode eColorMode;
//STRIP001 	if ( pOutput->bUseStyleColor )
//STRIP001 	{
//STRIP001 		if ( pOutput->bForceAutoColor )
//STRIP001 			eColorMode = bCellContrast ? SC_AUTOCOL_IGNOREALL : SC_AUTOCOL_IGNOREFONT;
//STRIP001 		else
//STRIP001 			eColorMode = bCellContrast ? SC_AUTOCOL_IGNOREBACK : SC_AUTOCOL_DISPLAY;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eColorMode = SC_AUTOCOL_PRINT;
//STRIP001 
//STRIP001 	if ( bPixelToLogic )
//STRIP001 		pPattern->GetFont( aFont, eColorMode, pFmtDevice, NULL, pCondSet, nScript,
//STRIP001 							&aBackConfigColor, &aTextConfigColor );
//STRIP001 	else
//STRIP001 		pPattern->GetFont( aFont, eColorMode, pFmtDevice, &pOutput->aZoomY, pCondSet, nScript,
//STRIP001 							&aBackConfigColor, &aTextConfigColor );
//STRIP001 	aFont.SetAlign(ALIGN_BASELINE);
//STRIP001 
//STRIP001 	//	Orientierung
//STRIP001 
//STRIP001 	const SfxPoolItem* pCondItem;
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_ORIENTATION, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		eAttrOrient = (SvxCellOrientation)((const SvxOrientationItem*)pCondItem)->GetValue();
//STRIP001 	else
//STRIP001 		eAttrOrient = (SvxCellOrientation)
//STRIP001 			((const SvxOrientationItem&)pPattern->GetItem(ATTR_ORIENTATION)).GetValue();
//STRIP001 
//STRIP001 	short nRot;
//STRIP001 	switch (eAttrOrient)
//STRIP001 	{
//STRIP001 		case SVX_ORIENTATION_STANDARD:
//STRIP001 			nRot = 0;
//STRIP001 			long nRotate;
//STRIP001 			if ( pCondSet && pCondSet->GetItemState( ATTR_ROTATE_VALUE, TRUE, &pCondItem ) ==
//STRIP001 								SFX_ITEM_SET )
//STRIP001 				nRotate = ((const SfxInt32Item*)pCondItem)->GetValue();
//STRIP001 			else
//STRIP001 				nRotate = ((const SfxInt32Item&)pPattern->GetItem(ATTR_ROTATE_VALUE)).GetValue();
//STRIP001 			bRotated = ( nRotate != 0 );
//STRIP001 			break;
//STRIP001 		case SVX_ORIENTATION_STACKED:
//STRIP001 			nRot = 0;
//STRIP001 			bRotated = FALSE;
//STRIP001 			break;
//STRIP001 		case SVX_ORIENTATION_TOPBOTTOM:
//STRIP001 			nRot = 2700;
//STRIP001 			bRotated = FALSE;
//STRIP001 			break;
//STRIP001 		case SVX_ORIENTATION_BOTTOMTOP:
//STRIP001 			nRot = 900;
//STRIP001 			bRotated = FALSE;
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			DBG_ERROR("Falscher SvxCellOrientation Wert");
//STRIP001 			nRot = 0;
//STRIP001 			bRotated = FALSE;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	aFont.SetOrientation( nRot );
//STRIP001 
//STRIP001 	//	Syntax-Modus
//STRIP001 
//STRIP001 	if (pOutput->bSyntaxMode)
//STRIP001 		pOutput->SetSyntaxColor( &aFont, pCell );
//STRIP001 
//STRIP001 	pDev->SetFont( aFont );
//STRIP001 	if ( pFmtDevice != pDev )
//STRIP001 		pFmtDevice->SetFont( aFont );
//STRIP001 
//STRIP001 	aMetric = pFmtDevice->GetFontMetric();
//STRIP001 
//STRIP001 	//
//STRIP001 	//	Wenn auf dem Drucker das Leading 0 ist, gibt es Probleme
//STRIP001 	//	-> Metric vom Bildschirm nehmen (wie EditEngine!)
//STRIP001 	//
//STRIP001 
//STRIP001 	if ( pFmtDevice->GetOutDevType() == OUTDEV_PRINTER && aMetric.GetLeading() == 0 )
//STRIP001 	{
//STRIP001 		OutputDevice* pDefaultDev = Application::GetDefaultDevice();
//STRIP001 		MapMode aOld = pDefaultDev->GetMapMode();
//STRIP001 		pDefaultDev->SetMapMode( pFmtDevice->GetMapMode() );
//STRIP001 		aMetric = pDefaultDev->GetFontMetric( aFont );
//STRIP001 		pDefaultDev->SetMapMode( aOld );
//STRIP001 	}
//STRIP001 
//STRIP001 	nAscentPixel = aMetric.GetAscent();
//STRIP001 	if ( bPixelToLogic )
//STRIP001 		nAscentPixel = pRefDevice->LogicToPixel( Size( 0, nAscentPixel ) ).Height();
//STRIP001 
//STRIP001 	Color aULineColor;
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_FONT_UNDERLINE, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		aULineColor = ((const SvxUnderlineItem*)pCondItem)->GetColor();
//STRIP001 	else
//STRIP001 		aULineColor = ((const SvxUnderlineItem&)pPattern->GetItem(ATTR_FONT_UNDERLINE)).GetColor();
//STRIP001 	pDev->SetTextLineColor( aULineColor );
//STRIP001 
//STRIP001 	//	Ausrichtung
//STRIP001 
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_HOR_JUSTIFY, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		eAttrHorJust = (SvxCellHorJustify)
//STRIP001 			((const SvxHorJustifyItem*)pCondItem)->GetValue();
//STRIP001 	else
//STRIP001 		eAttrHorJust = (SvxCellHorJustify)
//STRIP001 			((const SvxHorJustifyItem&)pPattern->GetItem(ATTR_HOR_JUSTIFY)).GetValue();
//STRIP001 
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_VER_JUSTIFY, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		eAttrVerJust = (SvxCellVerJustify)
//STRIP001 			((const SvxVerJustifyItem*)pCondItem)->GetValue();
//STRIP001 	else
//STRIP001 		eAttrVerJust = (SvxCellVerJustify)
//STRIP001 			((const SvxVerJustifyItem&)pPattern->GetItem(ATTR_VER_JUSTIFY)).GetValue();
//STRIP001 	if ( eAttrVerJust == SVX_VER_JUSTIFY_STANDARD )
//STRIP001 		eAttrVerJust = SVX_VER_JUSTIFY_BOTTOM;
//STRIP001 
//STRIP001 	//	Umbruch
//STRIP001 
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_LINEBREAK, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		bLineBreak = ((const SfxBoolItem*)pCondItem)->GetValue();
//STRIP001 	else
//STRIP001 		bLineBreak = ((const SfxBoolItem&)pPattern->GetItem(ATTR_LINEBREAK)).GetValue();
//STRIP001 
//STRIP001 	//	Zahlenformat
//STRIP001 
//STRIP001 	ULONG nOld = nValueFormat;
//STRIP001 	nValueFormat = pPattern->GetNumberFormat( pFormatter, pCondSet );

/*	s.u.
	if (nValueFormat != nOld)
		pLastCell = NULL;			// immer neu formatieren
*/
//STRIP001 	//	Raender
//STRIP001 
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_MARGIN, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		pMargin = (const SvxMarginItem*)pCondItem;
//STRIP001 	else
//STRIP001 		pMargin = (const SvxMarginItem*)&pPattern->GetItem(ATTR_MARGIN);
//STRIP001 	if ( eAttrHorJust == SVX_HOR_JUSTIFY_LEFT )
//STRIP001 	{
//STRIP001 		if ( pCondSet && pCondSet->GetItemState( ATTR_INDENT, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 			nIndent = ((const SfxUInt16Item*)pCondItem)->GetValue();
//STRIP001 		else
//STRIP001 			nIndent = ((const SfxUInt16Item&)pPattern->GetItem(ATTR_INDENT)).GetValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nIndent = 0;
//STRIP001 
//STRIP001 	//	zumindest die Text-Groesse muss neu geholt werden
//STRIP001 	//!	unterscheiden, und den Text nicht neu vom Numberformatter holen?
//STRIP001 
//STRIP001 	pLastCell = NULL;
//STRIP001 }

//STRIP001 void ScDrawStringsVars::SetPatternSimple( const ScPatternAttr* pNew, const SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	//	wird gerufen, wenn sich die Font-Variablen nicht aendern (!StringDiffer)
//STRIP001 
//STRIP001 	pPattern = pNew;
//STRIP001 	pCondSet = pSet;		//! noetig ???
//STRIP001 
//STRIP001 	//	Zahlenformat
//STRIP001 
//STRIP001 	ULONG nOld = nValueFormat;
//STRIP001 //	nValueFormat = pPattern->GetNumberFormat( pFormatter );
//STRIP001 	const SfxPoolItem* pFormItem;
//STRIP001 	if ( !pCondSet || pCondSet->GetItemState(ATTR_VALUE_FORMAT,TRUE,&pFormItem) != SFX_ITEM_SET )
//STRIP001 		pFormItem = &pPattern->GetItem(ATTR_VALUE_FORMAT);
//STRIP001 	const SfxPoolItem* pLangItem;
//STRIP001 	if ( !pCondSet || pCondSet->GetItemState(ATTR_LANGUAGE_FORMAT,TRUE,&pLangItem) != SFX_ITEM_SET )
//STRIP001 		pLangItem = &pPattern->GetItem(ATTR_LANGUAGE_FORMAT);
//STRIP001 	nValueFormat = pFormatter->GetFormatForLanguageIfBuiltIn(
//STRIP001 					((SfxUInt32Item*)pFormItem)->GetValue(),
//STRIP001 					((SvxLanguageItem*)pLangItem)->GetLanguage() );
//STRIP001 
//STRIP001 	if (nValueFormat != nOld)
//STRIP001 		pLastCell = NULL;			// immer neu formatieren
//STRIP001 
//STRIP001 	//	Raender
//STRIP001 
//STRIP001 	const SfxPoolItem* pCondItem;
//STRIP001 	if ( pCondSet && pCondSet->GetItemState( ATTR_MARGIN, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 		pMargin = (const SvxMarginItem*)pCondItem;
//STRIP001 	else
//STRIP001 		pMargin = (const SvxMarginItem*)&pPattern->GetItem(ATTR_MARGIN);
//STRIP001 	if ( eAttrHorJust == SVX_HOR_JUSTIFY_LEFT )
//STRIP001 	{
//STRIP001 		if ( pCondSet && pCondSet->GetItemState( ATTR_INDENT, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 			nIndent = ((const SfxUInt16Item*)pCondItem)->GetValue();
//STRIP001 		else
//STRIP001 			nIndent = ((const SfxUInt16Item&)pPattern->GetItem(ATTR_INDENT)).GetValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nIndent = 0;
//STRIP001 }

//STRIP001 inline BOOL SameValue( ScBaseCell* pCell, ScBaseCell* pOldCell )	// pCell ist != 0
//STRIP001 {
//STRIP001 	return pOldCell && pOldCell->GetCellType() == CELLTYPE_VALUE &&
//STRIP001 			pCell->GetCellType() == CELLTYPE_VALUE &&
//STRIP001 			((ScValueCell*)pCell)->GetValue() == ((ScValueCell*)pOldCell)->GetValue();
//STRIP001 }

//STRIP001 BOOL ScDrawStringsVars::SetText( ScBaseCell* pCell )
//STRIP001 {
//STRIP001 	BOOL bChanged = FALSE;
//STRIP001 
//STRIP001 	if (pCell)
//STRIP001 	{
//STRIP001 		if ( !SameValue( pCell, pLastCell ) )
//STRIP001 		{
//STRIP001 			pLastCell = pCell;			//	Zelle merken
//STRIP001 
//STRIP001 			Color* pColor;
//STRIP001 			ULONG nFormat = GetValueFormat();
//STRIP001 			ScCellFormat::GetString( pCell,
//STRIP001 									 nFormat, aString, &pColor,
//STRIP001 									 *pFormatter,
//STRIP001 									 pOutput->bShowNullValues,
//STRIP001 									 pOutput->bShowFormulas,
//STRIP001 									 ftCheck );
//STRIP001 
//STRIP001 			if (aString.Len() > DRAWTEXT_MAX)
//STRIP001 				aString.Erase(DRAWTEXT_MAX);
//STRIP001 
//STRIP001 			if ( pColor && !pOutput->bSyntaxMode && !( pOutput->bUseStyleColor && pOutput->bForceAutoColor ) )
//STRIP001 			{
//STRIP001 				OutputDevice* pDev = pOutput->pDev;
//STRIP001 				aFont.SetColor(*pColor);
//STRIP001 				pDev->SetFont( aFont );	// nur fuer Ausgabe
//STRIP001 				bChanged = TRUE;
//STRIP001 				pLastCell = NULL;		// naechstes Mal wieder hierherkommen
//STRIP001 			}
//STRIP001 
//STRIP001 			OutputDevice* pRefDevice = pOutput->pRefDevice;
//STRIP001 			OutputDevice* pFmtDevice = pOutput->pFmtDevice;
//STRIP001 			aTextSize.Width() = pFmtDevice->GetTextWidth( aString );
//STRIP001 			aTextSize.Height() = pFmtDevice->GetTextHeight();
//STRIP001 
//STRIP001 			if ( !pRefDevice->GetConnectMetaFile() || pRefDevice->GetOutDevType() == OUTDEV_PRINTER )
//STRIP001 			{
//STRIP001 				double fMul = pOutput->GetStretch();
//STRIP001 				aTextSize.Width() = (long)(aTextSize.Width() / fMul + 0.5);
//STRIP001 			}
//STRIP001 
//STRIP001 			aTextSize.Height() = aMetric.GetAscent() + aMetric.GetDescent();
//STRIP001 			if ( GetOrient() != SVX_ORIENTATION_STANDARD )
//STRIP001 			{
//STRIP001 				long nTemp = aTextSize.Height();
//STRIP001 				aTextSize.Height() = aTextSize.Width();
//STRIP001 				aTextSize.Width() = nTemp;
//STRIP001 			}
//STRIP001 
//STRIP001 			nOriginalWidth = aTextSize.Width();
//STRIP001 			if ( bPixelToLogic )
//STRIP001 				aTextSize = pRefDevice->LogicToPixel( aTextSize );
//STRIP001 		}
//STRIP001 		//	sonst String/Groesse behalten
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aString.Erase();
//STRIP001 		pLastCell = NULL;
//STRIP001 		aTextSize = Size(0,0);
//STRIP001 		nOriginalWidth = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bChanged;
//STRIP001 }

//STRIP001 void ScDrawStringsVars::ResetText()
//STRIP001 {
//STRIP001 	aString.Erase();
//STRIP001 	pLastCell = NULL;
//STRIP001 	aTextSize = Size(0,0);
//STRIP001 	nOriginalWidth = 0;
//STRIP001 }

//STRIP001 void ScDrawStringsVars::SetHashText()
//STRIP001 {
//STRIP001 	aString = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("###"));
//STRIP001 
//STRIP001 	OutputDevice* pRefDevice = pOutput->pRefDevice;
//STRIP001 	OutputDevice* pFmtDevice = pOutput->pFmtDevice;
//STRIP001 	aTextSize.Width() = pFmtDevice->GetTextWidth( aString );
//STRIP001 	aTextSize.Height() = pFmtDevice->GetTextHeight();
//STRIP001 
//STRIP001 	if ( !pRefDevice->GetConnectMetaFile() || pRefDevice->GetOutDevType() == OUTDEV_PRINTER )
//STRIP001 	{
//STRIP001 		double fMul = pOutput->GetStretch();
//STRIP001 		aTextSize.Width() = (long)(aTextSize.Width() / fMul + 0.5);
//STRIP001 	}
//STRIP001 
//STRIP001 	aTextSize.Height() = aMetric.GetAscent() + aMetric.GetDescent();
//STRIP001 	if ( GetOrient() != SVX_ORIENTATION_STANDARD )
//STRIP001 	{
//STRIP001 		long nTemp = aTextSize.Height();
//STRIP001 		aTextSize.Height() = aTextSize.Width();
//STRIP001 		aTextSize.Width() = nTemp;
//STRIP001 	}
//STRIP001 
//STRIP001 	nOriginalWidth = aTextSize.Width();
//STRIP001 	if ( bPixelToLogic )
//STRIP001 		aTextSize = pRefDevice->LogicToPixel( aTextSize );
//STRIP001 
//STRIP001 	pLastCell = NULL;		// derselbe Text kann in der naechsten Zelle wieder passen
//STRIP001 }

//STRIP001 BOOL ScDrawStringsVars::IsRightToLeftAttr() const
//STRIP001 {
//STRIP001 	SvxFrameDirection eCellDir = (SvxFrameDirection)((const SvxFrameDirectionItem&)
//STRIP001 									pPattern->GetItem( ATTR_WRITINGDIR, pCondSet )).GetValue();
//STRIP001 	return ( eCellDir == FRMDIR_HORI_RIGHT_TOP ||
//STRIP001 			( eCellDir == FRMDIR_ENVIRONMENT && pOutput->nTabTextDirection == EE_HTEXTDIR_R2L ) );
//STRIP001 }

//==================================================================

//STRIP001 double ScOutputData::GetStretch()
//STRIP001 {
//STRIP001 	if ( pRefDevice->IsMapMode() )
//STRIP001 	{
//STRIP001 		//	#95920# If a non-trivial MapMode is set, its scale is now already
//STRIP001 		//	taken into account in the OutputDevice's font handling
//STRIP001 		//	(OutputDevice::ImplNewFont, see #95414#).
//STRIP001 		//	The old handling below is only needed for pixel output.
//STRIP001 		return 1.0;
//STRIP001 	}
//STRIP001 
//STRIP001 	// calculation in double is faster than Fraction multiplication
//STRIP001 	// and doesn't overflow
//STRIP001 
//STRIP001 	if ( pRefDevice == pFmtDevice )
//STRIP001 	{
//STRIP001 		MapMode aOld = pRefDevice->GetMapMode();
//STRIP001 		return ((double)aOld.GetScaleY()) / ((double)aOld.GetScaleX()) * ((double)aZoomY) / ((double)aZoomX);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// when formatting for printer, device map mode has already been taken care of
//STRIP001 		return ((double)aZoomY) / ((double)aZoomX);
//STRIP001 	}
//STRIP001 }

//==================================================================

//
//	Strings ausgeben
//

//STRIP001 void ScOutputData::SetSyntaxColor( Font* pFont, ScBaseCell* pCell )
//STRIP001 {
//STRIP001 	if (pCell)
//STRIP001 	{
//STRIP001 		switch (pCell->GetCellType())
//STRIP001 		{
//STRIP001 			case CELLTYPE_VALUE:
//STRIP001 				pFont->SetColor( *pValueColor );
//STRIP001 				break;
//STRIP001 			case CELLTYPE_STRING:
//STRIP001 				pFont->SetColor( *pTextColor );
//STRIP001 				break;
//STRIP001 			case CELLTYPE_FORMULA:
//STRIP001 				pFont->SetColor( *pFormulaColor );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void lcl_SetEditColor( EditEngine& rEngine, const Color& rColor )
//STRIP001 {
//STRIP001 	ESelection aSel( 0, 0, rEngine.GetParagraphCount(), 0 );
//STRIP001 	SfxItemSet aSet( rEngine.GetEmptyItemSet() );
//STRIP001 	aSet.Put( SvxColorItem( rColor, EE_CHAR_COLOR ) );
//STRIP001 	rEngine.QuickSetAttribs( aSet, aSel );
//STRIP001 	// function is called with update mode set to FALSE
//STRIP001 }

//STRIP001 void ScOutputData::SetEditSyntaxColor( EditEngine& rEngine, ScBaseCell* pCell )
//STRIP001 {
//STRIP001 	if (pCell)
//STRIP001 	{
//STRIP001 		Color aColor;
//STRIP001 		switch (pCell->GetCellType())
//STRIP001 		{
//STRIP001 			case CELLTYPE_VALUE:
//STRIP001 				aColor = *pValueColor;
//STRIP001 				break;
//STRIP001 			case CELLTYPE_STRING:
//STRIP001 				aColor = *pTextColor;
//STRIP001 				break;
//STRIP001 			case CELLTYPE_FORMULA:
//STRIP001 				aColor = *pFormulaColor;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		lcl_SetEditColor( rEngine, aColor );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScOutputData::GetMergeOrigin( USHORT nX, USHORT nY, USHORT nArrY,
//STRIP001 									USHORT& rOverX, USHORT& rOverY,
//STRIP001 									long& rVirtPosX, long& rVirtPosY,
//STRIP001 									BOOL bClipVirt, BOOL bVisRowChanged )
//STRIP001 {
//STRIP001 	BOOL bDoMerge = FALSE;
//STRIP001 	BOOL bIsLeft = ( nX == nVisX1 );
//STRIP001 	BOOL bIsTop  = ( nY == nVisY1 ) || bVisRowChanged;
//STRIP001 
//STRIP001 	CellInfo* pInfo = &pRowInfo[nArrY].pCellInfo[nX+1];
//STRIP001 	if ( pInfo->bHOverlapped && pInfo->bVOverlapped )
//STRIP001 		bDoMerge = bIsLeft && bIsTop;
//STRIP001 	else if ( pInfo->bHOverlapped )
//STRIP001 		bDoMerge = bIsLeft;
//STRIP001 	else if ( pInfo->bVOverlapped )
//STRIP001 		bDoMerge = bIsTop;

									// weiter solange versteckt
/*	if (!bDoMerge)
		return FALSE;
*/

//STRIP001 	rOverX = nX;
//STRIP001 	rOverY = nY;
//STRIP001 	BOOL bHOver = pInfo->bHOverlapped;
//STRIP001 	BOOL bVOver = pInfo->bVOverlapped;
//STRIP001 	BOOL bHidden;
//STRIP001 
//STRIP001 	while (bHOver)				// nY konstant
//STRIP001 	{
//STRIP001 		--rOverX;
//STRIP001 		bHidden = ( (pDoc->GetColFlags(rOverX,nTab) & CR_HIDDEN) != 0 );
//STRIP001 		if ( !bDoMerge && !bHidden )
//STRIP001 			return FALSE;
//STRIP001 
//STRIP001 		if (rOverX >= nX1 && !bHidden)
//STRIP001 		{
//STRIP001 			rVirtPosX -= pRowInfo[0].pCellInfo[rOverX+1].nWidth;
//STRIP001 			bHOver = pRowInfo[nArrY].pCellInfo[rOverX+1].bHOverlapped;
//STRIP001 			bVOver = pRowInfo[nArrY].pCellInfo[rOverX+1].bVOverlapped;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (!bClipVirt)
//STRIP001 				rVirtPosX -= (long) (pDoc->GetColWidth( rOverX, nTab ) * nPPTX);
//STRIP001 			USHORT nOverlap = ((ScMergeFlagAttr*)pDoc->GetAttr(
//STRIP001 								rOverX, rOverY, nTab, ATTR_MERGE_FLAG ))->GetValue();
//STRIP001 			bHOver = ((nOverlap & SC_MF_HOR) != 0);
//STRIP001 			bVOver = ((nOverlap & SC_MF_VER) != 0);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	while (bVOver)
//STRIP001 	{
//STRIP001 		--rOverY;
//STRIP001 		bHidden = ( (pDoc->GetRowFlags(rOverY,nTab) & CR_HIDDEN) != 0 );
//STRIP001 		if ( !bDoMerge && !bHidden )
//STRIP001 			return FALSE;
//STRIP001 
//STRIP001 		if (nArrY>0)
//STRIP001 			--nArrY;						// lokale Kopie !
//STRIP001 
//STRIP001 		if (rOverX >= nX1 && rOverY >= nY1 &&
//STRIP001 			(pDoc->GetColFlags(rOverX,nTab) & CR_HIDDEN) == 0 &&
//STRIP001 			(pDoc->GetRowFlags(rOverY,nTab) & CR_HIDDEN) == 0 &&
//STRIP001 			pRowInfo[nArrY].nRowNo == rOverY)
//STRIP001 		{
//STRIP001 			rVirtPosY -= pRowInfo[nArrY].nHeight;
//STRIP001 			bHOver = pRowInfo[nArrY].pCellInfo[rOverX+1].bHOverlapped;
//STRIP001 			bVOver = pRowInfo[nArrY].pCellInfo[rOverX+1].bVOverlapped;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (!bClipVirt)
//STRIP001 				rVirtPosY -= (long) (pDoc->GetRowHeight( rOverY, nTab ) * nPPTY);
//STRIP001 			USHORT nOverlap = ((ScMergeFlagAttr*)pDoc->GetAttr(
//STRIP001 								rOverX, rOverY, nTab, ATTR_MERGE_FLAG ))->GetValue();
//STRIP001 			bHOver = ((nOverlap & SC_MF_HOR) != 0);
//STRIP001 			bVOver = ((nOverlap & SC_MF_VER) != 0);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 inline BOOL StringDiffer( const ScPatternAttr*& rpOldPattern, const ScPatternAttr*& rpNewPattern )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rpNewPattern, "pNewPattern" );
//STRIP001 
//STRIP001 	if ( rpNewPattern == rpOldPattern )
//STRIP001 		return FALSE;
//STRIP001 	else if ( !rpOldPattern )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT ) != &rpOldPattern->GetItem( ATTR_FONT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CJK_FONT ) != &rpOldPattern->GetItem( ATTR_CJK_FONT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CTL_FONT ) != &rpOldPattern->GetItem( ATTR_CTL_FONT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_HEIGHT ) != &rpOldPattern->GetItem( ATTR_FONT_HEIGHT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CJK_FONT_HEIGHT ) != &rpOldPattern->GetItem( ATTR_CJK_FONT_HEIGHT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CTL_FONT_HEIGHT ) != &rpOldPattern->GetItem( ATTR_CTL_FONT_HEIGHT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_WEIGHT ) != &rpOldPattern->GetItem( ATTR_FONT_WEIGHT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CJK_FONT_WEIGHT ) != &rpOldPattern->GetItem( ATTR_CJK_FONT_WEIGHT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CTL_FONT_WEIGHT ) != &rpOldPattern->GetItem( ATTR_CTL_FONT_WEIGHT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_POSTURE ) != &rpOldPattern->GetItem( ATTR_FONT_POSTURE ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CJK_FONT_POSTURE ) != &rpOldPattern->GetItem( ATTR_CJK_FONT_POSTURE ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_CTL_FONT_POSTURE ) != &rpOldPattern->GetItem( ATTR_CTL_FONT_POSTURE ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_UNDERLINE ) != &rpOldPattern->GetItem( ATTR_FONT_UNDERLINE ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_WORDLINE ) != &rpOldPattern->GetItem( ATTR_FONT_WORDLINE ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_CROSSEDOUT ) != &rpOldPattern->GetItem( ATTR_FONT_CROSSEDOUT ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_CONTOUR ) != &rpOldPattern->GetItem( ATTR_FONT_CONTOUR ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_SHADOWED ) != &rpOldPattern->GetItem( ATTR_FONT_SHADOWED ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_COLOR ) != &rpOldPattern->GetItem( ATTR_FONT_COLOR ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_HOR_JUSTIFY ) != &rpOldPattern->GetItem( ATTR_HOR_JUSTIFY ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_VER_JUSTIFY ) != &rpOldPattern->GetItem( ATTR_VER_JUSTIFY ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_ORIENTATION ) != &rpOldPattern->GetItem( ATTR_ORIENTATION ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_LINEBREAK ) != &rpOldPattern->GetItem( ATTR_LINEBREAK ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_MARGIN ) != &rpOldPattern->GetItem( ATTR_MARGIN ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_ROTATE_VALUE ) != &rpOldPattern->GetItem( ATTR_ROTATE_VALUE ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FORBIDDEN_RULES ) != &rpOldPattern->GetItem( ATTR_FORBIDDEN_RULES ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_EMPHASISMARK ) != &rpOldPattern->GetItem( ATTR_FONT_EMPHASISMARK ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_FONT_RELIEF ) != &rpOldPattern->GetItem( ATTR_FONT_RELIEF ) )
//STRIP001 		return TRUE;
//STRIP001 	else if ( &rpNewPattern->GetItem( ATTR_BACKGROUND ) != &rpOldPattern->GetItem( ATTR_BACKGROUND ) )
//STRIP001 		return TRUE;	// needed with automatic text color
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rpOldPattern = rpNewPattern;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 inline void lcl_CreateInterpretProgress( BOOL& bProgress, ScDocument* pDoc,
//STRIP001 		ScFormulaCell* pFCell )
//STRIP001 {
//STRIP001 	if ( !bProgress && pFCell->GetDirty() )
//STRIP001 	{
//STRIP001 		ScProgress::CreateInterpretProgress( pDoc, TRUE );
//STRIP001 		bProgress = TRUE;
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL lcl_IsValueDataAtPos( BOOL& bProgress, ScDocument* pDoc,
//STRIP001 		USHORT nCol, USHORT nRow, USHORT nTab )
//STRIP001 {
//STRIP001 	ScBaseCell* pCell;
//STRIP001 	pDoc->GetCell( nCol, nRow, nTab, pCell );
//STRIP001 	if ( pCell )
//STRIP001 	{
//STRIP001 		if ( pCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 		{	// kein weiteres Interpret anstossen
//STRIP001 			ScFormulaCell* pFCell = (ScFormulaCell*) pCell;
//STRIP001 			if ( pFCell->IsRunning() )
//STRIP001 				return TRUE;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				lcl_CreateInterpretProgress( bProgress, pDoc, pFCell );
//STRIP001 				return pFCell->HasValueData();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			return pCell->HasValueData();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 inline BYTE GetScriptType( ScDocument* pDoc, ScBaseCell* pCell,
//STRIP001 							const ScPatternAttr* pPattern,
//STRIP001 							const SfxItemSet* pCondSet )
//STRIP001 {
//STRIP001 	return pDoc->GetCellScriptType( pCell, pPattern->GetNumberFormat( pDoc->GetFormatTable(), pCondSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 inline BOOL IsAmbiguousScript( BYTE nScript )
//STRIP001 {
//STRIP001 	return ( nScript != SCRIPTTYPE_LATIN &&
//STRIP001 			 nScript != SCRIPTTYPE_ASIAN &&
//STRIP001 			 nScript != SCRIPTTYPE_COMPLEX );
//STRIP001 }

//STRIP001 BOOL ScOutputData::IsEmptyCellText( RowInfo* pThisRowInfo, USHORT nX, USHORT nY )
//STRIP001 {
//STRIP001 	// pThisRowInfo may be NULL
//STRIP001 
//STRIP001 	BOOL bEmpty = pThisRowInfo && nX <= nX2 && pThisRowInfo->pCellInfo[nX+1].bEmptyCellText;
//STRIP001 	if ( !bEmpty && ( nX < nX1 || nX > nX2 || !pThisRowInfo ) )
//STRIP001 	{
//STRIP001 		//	for the range nX1..nX2 in RowInfo, cell protection attribute is already evaluated
//STRIP001 		//	into bEmptyCellText in ScDocument::FillInfo / lcl_HidePrint (printfun)
//STRIP001 
//STRIP001 		BOOL bIsPrint = ( eType == OUTTYPE_PRINTER );
//STRIP001 
//STRIP001 		if ( bIsPrint || bTabProtected )
//STRIP001 		{
//STRIP001 			const ScProtectionAttr* pAttr = (const ScProtectionAttr*)
//STRIP001 					pDoc->GetEffItem( nX, nY, nTab, ATTR_PROTECTION );
//STRIP001 			if ( bIsPrint && pAttr->GetHidePrint() )
//STRIP001 				bEmpty = TRUE;
//STRIP001 			else if ( bTabProtected )
//STRIP001 			{
//STRIP001 				if ( pAttr->GetHideCell() )
//STRIP001 					bEmpty = TRUE;
//STRIP001 				else if ( bShowFormulas && pAttr->GetHideFormula() )
//STRIP001 				{
//STRIP001 					ScBaseCell* pCell = pDoc->GetCell( ScAddress( nX, nY, nTab ) );
//STRIP001 					if ( pCell && pCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 						bEmpty = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bEmpty;
//STRIP001 }
//STRIP001 
//STRIP001 void ScOutputData::GetVisibleCell( USHORT nCol, USHORT nRow, USHORT nTab, ScBaseCell*& rpCell )
//STRIP001 {
//STRIP001 	pDoc->GetCell( nCol, nRow, nTab, rpCell );
//STRIP001 	if ( rpCell && IsEmptyCellText( NULL, nCol, nRow ) )
//STRIP001 		rpCell = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScOutputData::IsAvailable( USHORT nX, USHORT nY )
//STRIP001 {
//STRIP001 	//	apply the same logic here as in DrawStrings/DrawEdit:
//STRIP001 	//	Stop at non-empty or merged or overlapped cell,
//STRIP001 	//	where a note is empty as well as a cell that's hidden by protection settings
//STRIP001 
//STRIP001 	const ScBaseCell* pCell = pDoc->GetCell( ScAddress( nX, nY, nTab ) );
//STRIP001 	if ( pCell && pCell->GetCellType() != CELLTYPE_NOTE && !IsEmptyCellText( NULL, nX, nY ) )
//STRIP001 	{
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	const ScPatternAttr* pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 	if ( ((const ScMergeAttr&)pPattern->GetItem(ATTR_MERGE)).IsMerged() ||
//STRIP001 		 ((const ScMergeFlagAttr&)pPattern->GetItem(ATTR_MERGE_FLAG)).IsOverlapped() )
//STRIP001 	{
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 long ScOutputData::GetAvailableWidth( USHORT nX, USHORT nY, long nNeeded )
//STRIP001 {
//STRIP001 	//	get the pixel width that's available for the cell's text,
//STRIP001 	//	including cells outside of the current screen area
//STRIP001 
//STRIP001 	long nAvailable = (long) ( pDoc->GetColWidth( nX, nTab ) * nPPTX );		// cell itself
//STRIP001 
//STRIP001 	const ScMergeAttr* pMerge = (const ScMergeAttr*)pDoc->GetAttr( nX, nY, nTab, ATTR_MERGE );
//STRIP001 	if ( pMerge->IsMerged() )
//STRIP001 	{
//STRIP001 		//	for merged cells, allow only the merged area
//STRIP001 		USHORT nCount = pMerge->GetColMerge();
//STRIP001 		for (USHORT nAdd=1; nAdd<nCount; nAdd++)
//STRIP001 			nAvailable += (long) ( pDoc->GetColWidth( nX + nAdd, nTab ) * nPPTX );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	look for empty cells into which the text can be extended
//STRIP001 		while ( nAvailable < nNeeded && nX < MAXCOL && IsAvailable( nX+1, nY ) )
//STRIP001 		{
//STRIP001 			++nX;
//STRIP001 			nAvailable += (long) ( pDoc->GetColWidth( nX, nTab ) * nPPTX );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bMarkClipped && nAvailable < nNeeded )
//STRIP001 		nAvailable -= (long)( SC_CLIPMARK_SIZE * nPPTX );
//STRIP001 
//STRIP001 	return nAvailable;
//STRIP001 }

/*N*/ void ScOutputData::DrawStrings( BOOL bPixelToLogic )
/*N*/ {
/*N*/ 	DBG_ASSERT( pDev == pRefDevice ||
/*N*/ 				pDev->GetMapMode().GetMapUnit() == pRefDevice->GetMapMode().GetMapUnit(),
/*N*/ 				"DrawStrings: unterschiedliche MapUnits ?!?!" );
/*N*/ 
/*N*/ 	BOOL bWasIdleDisabled = pDoc->IsIdleDisabled();
/*N*/ 	pDoc->DisableIdle( TRUE );
/*N*/ 	Size aMinSize = pRefDevice->PixelToLogic(Size(0,100));		// erst darueber wird ausgegeben
/*N*/ 	UINT32 nMinHeight = aMinSize.Height() / 200;				// 1/2 Pixel
/*N*/ 
/*N*/ 	ScDrawStringsVars aVars( this, bPixelToLogic );
/*N*/ 
/*N*/ 	const ScPatternAttr* pOldPattern = NULL;
/*N*/ 	const SfxItemSet* pOldCondSet = NULL;
/*N*/ 	BYTE nOldScript = 0;
/*N*/ 
/*N*/ 	BOOL bProgress = FALSE;
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged )
				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			USHORT nY = pThisRowInfo->nRowNo;
//STRIP001 /*?*/ 			long nCellHeight = (long) pThisRowInfo->nHeight;
//STRIP001 /*?*/ 			long nPosX = nScrX;
//STRIP001 /*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				ScForceTextFmt eForceText = ftDontForce;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				BOOL bLeftOver	= FALSE;			// Ueberhang von langem String (immer linksb.)
//STRIP001 /*?*/ 				BOOL bMergeOver	= FALSE;			// Rest von zusammengefassten Zellen
//STRIP001 /*?*/ 				BOOL bMergeEmpty= FALSE;
//STRIP001 /*?*/ 				long nVirtPosX	= nPosX;
//STRIP001 /*?*/ 				long nVirtPosY	= nPosY;
//STRIP001 /*?*/ 				long nOutWidth	= 0;
//STRIP001 /*?*/ 				long nOutHeight = nCellHeight;
//STRIP001 /*?*/ 				USHORT nOverX;						// Start der zusammengefassten Zellen
//STRIP001 /*?*/ 				USHORT nOverY;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				CellInfo*	pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 				BOOL bEmpty = pInfo->bEmptyCellText;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				USHORT nCellX = nX;					// position where the cell really starts
//STRIP001 /*?*/ 				USHORT nCellY = nY;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				//
//STRIP001 /*?*/ 				//	Teil von zusammengefasster Zelle ?
//STRIP001 /*?*/ 				//
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( pInfo->bHOverlapped || pInfo->bVOverlapped )
//STRIP001 /*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 //STRIP001 /*?*/ 					bEmpty = TRUE;
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 					BOOL bVisChanged = !pRowInfo[nArrY-1].bChanged;
//STRIP001 //STRIP001 /*?*/ 					if (GetMergeOrigin( nX,nY, nArrY, nOverX,nOverY, nVirtPosX,nVirtPosY,
//STRIP001 //STRIP001 /*?*/ 											FALSE, bVisChanged ))
//STRIP001 //STRIP001 /*?*/ 					{
//STRIP001 //STRIP001 /*?*/ 						ScBaseCell* pCell;
//STRIP001 /*?*/ 						GetVisibleCell( nOverX, nOverY, nTab, pCell );
//STRIP001 //STRIP001 /*?*/ 						if (pCell)
//STRIP001 //STRIP001 /*?*/ 						{
//STRIP001 //STRIP001 /*?*/ 							BOOL bEdit = ( pCell->GetCellType() == CELLTYPE_EDIT );
//STRIP001 //STRIP001 /*?*/ 							if (!bEdit)
//STRIP001 //STRIP001 /*?*/ 							{
//STRIP001 //STRIP001 /*?*/ 								const ScPatternAttr* pPattern =
//STRIP001 //STRIP001 /*?*/ 										pDoc->GetPattern( nOverX, nOverY, nTab );
//STRIP001 //STRIP001 /*?*/ 								const SfxItemSet* pCondSet =
//STRIP001 //STRIP001 /*?*/ 										pDoc->GetCondResult( nOverX, nOverY, nTab );
//STRIP001 //STRIP001 /*?*/ 								BYTE nScript = GetScriptType( pDoc, pCell, pPattern, pCondSet );
//STRIP001 //STRIP001 /*?*/ 								if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 //STRIP001 /*?*/ 								if ( pPattern != pOldPattern || pCondSet != pOldCondSet ||
//STRIP001 //STRIP001 /*?*/ 									 nScript != nOldScript || bSyntaxMode )
//STRIP001 //STRIP001 /*?*/ 								{
//STRIP001 //STRIP001 /*?*/ 									if ( StringDiffer(pOldPattern,pPattern) ||
//STRIP001 //STRIP001 /*?*/ 										 pCondSet != pOldCondSet || nScript != nOldScript || bSyntaxMode )
//STRIP001 //STRIP001 /*?*/ 										aVars.SetPattern( pPattern, pCondSet, pCell, nScript );
//STRIP001 //STRIP001 /*?*/ 									else
//STRIP001 //STRIP001 /*?*/ 										aVars.SetPatternSimple( pPattern, pCondSet );
//STRIP001 //STRIP001 /*?*/ 									pOldPattern = pPattern;
//STRIP001 //STRIP001 /*?*/ 									pOldCondSet = pCondSet;
//STRIP001 //STRIP001 /*?*/ 									nOldScript = nScript;
//STRIP001 //STRIP001 /*?*/ 								}
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 								if ( aVars.GetOrient() == SVX_ORIENTATION_STACKED ||
//STRIP001 //STRIP001 /*?*/ 									 aVars.IsRotated() || IsAmbiguousScript(nScript) )
//STRIP001 //STRIP001 /*?*/ 									bEdit = TRUE;
//STRIP001 //STRIP001 /*?*/ 							}
//STRIP001 //STRIP001 /*?*/ 							if (!bEdit)
//STRIP001 //STRIP001 /*?*/ 							{
//STRIP001 //STRIP001 /*?*/ 								if ( pCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 //STRIP001 /*?*/ 									lcl_CreateInterpretProgress( bProgress,
//STRIP001 //STRIP001 /*?*/ 										pDoc, (ScFormulaCell*)pCell );
//STRIP001 //STRIP001 /*?*/ 								if ( aVars.SetText(pCell) )
//STRIP001 //STRIP001 /*?*/ 									pOldPattern = NULL;
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 								if (nOverX >= nX1)
//STRIP001 //STRIP001 /*?*/ 									nOutWidth = ((long)pRowInfo[0].pCellInfo[nOverX+1].nWidth) - 1;
//STRIP001 //STRIP001 /*?*/ 								else
//STRIP001 //STRIP001 /*?*/ 									nOutWidth = ((long)(pDoc->GetColWidth( nOverX, nTab ) *
//STRIP001 //STRIP001 /*?*/ 													nPPTX)) - 1;
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 								nOutHeight = (long) (pDoc->GetRowHeight( nOverY, nTab ) * nPPTY);
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 								bMergeOver = TRUE;
//STRIP001 //STRIP001 /*?*/ 								nCellX = nOverX;
//STRIP001 //STRIP001 /*?*/ 								nCellY = nOverY;
//STRIP001 //STRIP001 /*?*/ 							}
//STRIP001 //STRIP001 /*?*/ 							else							// Edit-Zelle
//STRIP001 //STRIP001 /*?*/ 							{
//STRIP001 //STRIP001 /*?*/ 								if (nOverY == nY || bVisChanged)
//STRIP001 //STRIP001 /*?*/ 									pThisRowInfo->pCellInfo[nOverX+1].bEditEngine = TRUE;
//STRIP001 //STRIP001 /*?*/ 								else
//STRIP001 //STRIP001 /*?*/ 									pRowInfo[0].pCellInfo[nOverX+1].bEditEngine = TRUE;
//STRIP001 //STRIP001 /*?*/ 							}
//STRIP001 //STRIP001 /*?*/ 						}
//STRIP001 //STRIP001 /*?*/ 					}
//STRIP001 //STRIP001 /*?*/ 					bMergeEmpty = TRUE;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				//
//STRIP001 /*?*/ 				//	Rest von langem Text weiter links ?
//STRIP001 /*?*/ 				//
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				//	nJustPosX ist incl. Ausrichtung, nVirtPosX fuer Clipping ohne Ausrichtung
//STRIP001 /*?*/ 				long nJustPosX = nVirtPosX;
//STRIP001 /*?*/ 				BOOL bRightAdjusted = FALSE;		// to correct text width calculation later
//STRIP001 /*?*/ 				if ( bEmpty && !bMergeEmpty )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if (nX==nX1)					// links Zellen zum Weiterzeichnen ?
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						nOutWidth = ((long)pRowInfo[0].pCellInfo[nX+1].nWidth) - 1;
//STRIP001 /*?*/ 						USHORT nTempX=nX;
//STRIP001 /*?*/ 						while (nTempX > 0 && IsEmptyCellText( pThisRowInfo, nTempX, nY ))
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							--nTempX;
//STRIP001 /*?*/ 							nVirtPosX -= pRowInfo[0].pCellInfo[nTempX+1].nWidth;
//STRIP001 /*?*/ 							nOutWidth += pRowInfo[0].pCellInfo[nTempX+1].nWidth;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						nJustPosX = nVirtPosX;
//STRIP001 /*?*/ 						if ( !IsEmptyCellText( pThisRowInfo, nTempX, nY ) )
//STRIP001 /*?*/ 						{{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 
//STRIP001 //STRIP001 /*?*/ 							ScBaseCell* pCell = pThisRowInfo->pCellInfo[nTempX+1].pCell;
//STRIP001 //STRIP001 /*?*/ 							CellType eCellType = pCell->GetCellType();
//STRIP001 //STRIP001 /*?*/ 							if ( eCellType == CELLTYPE_STRING ||
//STRIP001 //STRIP001 /*?*/ 								(eCellType == CELLTYPE_FORMULA
//STRIP001 //STRIP001 /*?*/ 									&& !lcl_IsValueDataAtPos( bProgress, pDoc,
//STRIP001 //STRIP001 /*?*/ 										nTempX, nY, nTab )) )
//STRIP001 //STRIP001 /*?*/ 							{
//STRIP001 //STRIP001 /*?*/ 								const ScPatternAttr* pPattern =
//STRIP001 //STRIP001 /*?*/ 										pDoc->GetPattern( nTempX, nY, nTab );
//STRIP001 //STRIP001 /*?*/ 								const SfxItemSet* pCondSet =
//STRIP001 //STRIP001 /*?*/ 										pDoc->GetCondResult( nTempX, nY, nTab );
//STRIP001 //STRIP001 /*?*/ 								BYTE nScript = GetScriptType( pDoc, pCell, pPattern, pCondSet );
//STRIP001 //STRIP001 /*?*/ 								if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 //STRIP001 /*?*/ 								if ( pPattern != pOldPattern || pCondSet != pOldCondSet ||
//STRIP001 //STRIP001 /*?*/ 									 nScript != nOldScript || bSyntaxMode )
//STRIP001 //STRIP001 /*?*/ 								{
//STRIP001 //STRIP001 /*?*/ 									if ( StringDiffer(pOldPattern,pPattern) ||
//STRIP001 //STRIP001 /*?*/ 										 pCondSet != pOldCondSet || nScript != nOldScript || bSyntaxMode )
//STRIP001 //STRIP001 /*?*/ 										aVars.SetPattern( pPattern, pCondSet, pCell, nScript );
//STRIP001 //STRIP001 /*?*/ 									else
//STRIP001 //STRIP001 /*?*/ 										aVars.SetPatternSimple( pPattern, pCondSet );
//STRIP001 //STRIP001 /*?*/ 									pOldPattern = pPattern;
//STRIP001 //STRIP001 /*?*/ 									pOldCondSet = pCondSet;
//STRIP001 //STRIP001 /*?*/ 									nOldScript = nScript;
//STRIP001 //STRIP001 /*?*/ 								}
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 								if ( aVars.GetOrient() == SVX_ORIENTATION_STANDARD &&
//STRIP001 //STRIP001 /*?*/ 										!aVars.GetLineBreak() && !aVars.IsRotated() &&
//STRIP001 //STRIP001 /*?*/ 										aVars.GetHorJust() != SVX_HOR_JUSTIFY_BLOCK )
//STRIP001 //STRIP001 /*?*/ 								{
//STRIP001 //STRIP001 /*?*/ 									if ( IsAmbiguousScript(nScript) )
//STRIP001 //STRIP001 /*?*/ 									{
//STRIP001 //STRIP001 /*?*/ 										// need edit engine
//STRIP001 //STRIP001 /*?*/ 										if ( !pDoc->HasAttrib( nTempX,nY,nTab, nX,nY,nTab,
//STRIP001 //STRIP001 /*?*/ 															HASATTR_MERGED | HASATTR_OVERLAPPED ) )
//STRIP001 //STRIP001 /*?*/ 											pThisRowInfo->pCellInfo[nTempX+1].bEditEngine = TRUE;
//STRIP001 //STRIP001 /*?*/ 									}
//STRIP001 //STRIP001 /*?*/ 									else
//STRIP001 //STRIP001 /*?*/ 									{
//STRIP001 //STRIP001 /*?*/ 										if ( eCellType == CELLTYPE_FORMULA )
//STRIP001 //STRIP001 /*?*/ 											lcl_CreateInterpretProgress( bProgress,
//STRIP001 //STRIP001 /*?*/ 												pDoc, (ScFormulaCell*)pCell );
//STRIP001 //STRIP001 /*?*/ 										if ( aVars.SetText(pCell) )
//STRIP001 //STRIP001 /*?*/ 											pOldPattern = NULL;
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 										nJustPosX += (long) ( aVars.GetLeftTotal() * nPPTX );
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 										if ( nJustPosX + aVars.GetTextSize().Width() + 1 > nPosX &&
//STRIP001 //STRIP001 /*?*/ 												!pDoc->HasAttrib( nTempX,nY,nTab, nX,nY,nTab,
//STRIP001 //STRIP001 /*?*/ 														HASATTR_MERGED | HASATTR_OVERLAPPED ) )
//STRIP001 //STRIP001 /*?*/ 										{
//STRIP001 //STRIP001 /*?*/ 											bLeftOver = TRUE;
//STRIP001 //STRIP001 /*?*/ 										}
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 										nCellX = nTempX;
//STRIP001 //STRIP001 /*?*/ 									}
//STRIP001 //STRIP001 /*?*/ 								}
//STRIP001 //STRIP001 /*?*/ 							}
//STRIP001 //STRIP001 /*?*/ 							else if (eCellType == CELLTYPE_EDIT)
//STRIP001 //STRIP001 /*?*/ 							{
//STRIP001 //STRIP001 /*?*/ 								if ( !pDoc->HasAttrib( nTempX,nY,nTab, nX,nY,nTab,
//STRIP001 //STRIP001 /*?*/ 													HASATTR_MERGED | HASATTR_OVERLAPPED ) )
//STRIP001 //STRIP001 /*?*/ 									pThisRowInfo->pCellInfo[nTempX+1].bEditEngine = TRUE;
//STRIP001 //STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bEditMode)
//STRIP001 /*?*/ 					if ( nX == nEditCol && nY == nEditRow )
//STRIP001 /*?*/ 						bLeftOver = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (!bEmpty)
//STRIP001 /*?*/ 					if (pInfo->pCell->GetCellType() == CELLTYPE_EDIT)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pInfo->bEditEngine = TRUE;
//STRIP001 /*?*/ 						bEmpty = TRUE;							// Edit-Zelle hier nicht zeichnen
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				//	zu kleinen Text in der Druckvorschau als Pixel zeichnen:
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( !bEmpty && eType == OUTTYPE_PRINTER &&
//STRIP001 /*?*/ 					pDev->GetOutDevType() == OUTDEV_WINDOW &&
//STRIP001 /*?*/ 					((const SvxFontHeightItem&)pInfo->pPatternAttr->
//STRIP001 /*?*/ 					GetItem(ATTR_FONT_HEIGHT)).GetHeight() <= nMinHeight )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					Point aPos(nPosX,nPosY);
//STRIP001 /*?*/ 					Color aFontColor = ((const SvxColorItem&)pInfo->pPatternAttr->
//STRIP001 /*?*/ 											GetItem( ATTR_FONT_COLOR )).GetValue();
//STRIP001 /*?*/ 					if ( ( aFontColor == COL_AUTO || bForceAutoColor ) && bUseStyleColor )
//STRIP001 /*?*/                         aFontColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
//STRIP001 /*?*/ 					pDev->DrawPixel( aPos, aFontColor );
//STRIP001 /*?*/ 					bEmpty = TRUE;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (!bEmpty)								// bei MergeOver schon geschehen
//STRIP001 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 //STRIP001 /*?*/ 					const ScPatternAttr* pPattern = pInfo->pPatternAttr;
//STRIP001 //STRIP001 /*?*/ 					const SfxItemSet* pCondSet = pInfo->pConditionSet;
//STRIP001 //STRIP001 /*?*/ 					BYTE nScript = GetScriptType( pDoc, pInfo->pCell, pPattern, pCondSet );
//STRIP001 //STRIP001 /*?*/ 					if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 //STRIP001 /*?*/ 					if ( pPattern != pOldPattern || pCondSet != pOldCondSet ||
//STRIP001 //STRIP001 /*?*/ 						 nScript != nOldScript || bSyntaxMode )
//STRIP001 //STRIP001 /*?*/ 					{
//STRIP001 //STRIP001 /*?*/ 						if ( StringDiffer(pOldPattern,pPattern) ||
//STRIP001 //STRIP001 /*?*/ 							 pCondSet != pOldCondSet || nScript != nOldScript || bSyntaxMode )
//STRIP001 //STRIP001 /*?*/ 							aVars.SetPattern( pPattern, pCondSet, pInfo->pCell, nScript );
//STRIP001 //STRIP001 /*?*/ 						else
//STRIP001 //STRIP001 /*?*/ 							aVars.SetPatternSimple( pPattern, pCondSet );
//STRIP001 //STRIP001 /*?*/ 						pOldPattern = pPattern;
//STRIP001 //STRIP001 /*?*/ 						pOldCondSet = pCondSet;
//STRIP001 //STRIP001 /*?*/ 						nOldScript = nScript;
//STRIP001 //STRIP001 /*?*/ 					}
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 					if ( aVars.GetOrient() == SVX_ORIENTATION_STACKED ||
//STRIP001 //STRIP001 /*?*/ 						 aVars.IsRotated() || IsAmbiguousScript(nScript) )
//STRIP001 //STRIP001 /*?*/ 					{
//STRIP001 //STRIP001 /*?*/ 						pInfo->bEditEngine = TRUE;
//STRIP001 //STRIP001 /*?*/ 						bEmpty = TRUE;
//STRIP001 //STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( !bEmpty || bLeftOver || bMergeOver )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					CellType			eCellType;
//STRIP001 /*?*/ 					SvxCellHorJustify	eOutHorJust;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					BOOL bMergeHClip = FALSE;			// Teil von zusammengefassten ausserhalb?
//STRIP001 /*?*/ 					BOOL bMergeVClip = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( !bEmpty || bMergeOver )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (!bEmpty)
//STRIP001 /*?*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 //STRIP001 /*?*/ 							if ( pInfo->pCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 //STRIP001 /*?*/ 								lcl_CreateInterpretProgress( bProgress,
//STRIP001 //STRIP001 /*?*/ 									pDoc, (ScFormulaCell*)pInfo->pCell );
//STRIP001 //STRIP001 /*?*/ 							if ( aVars.SetText(pInfo->pCell) )
//STRIP001 //STRIP001 /*?*/ 								pOldPattern = NULL;
//STRIP001 //STRIP001 /*?*/ 
//STRIP001 //STRIP001 /*?*/ 							nOutWidth = ((long)pRowInfo[0].pCellInfo[nX+1].nWidth)-1;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						BOOL bMerged = bMergeOver ? TRUE : pInfo->bMerged;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( bMerged )						// Zusammengefasst
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if (!bMergeOver)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								nOverX = nX;
//STRIP001 /*?*/ 								nOverY = nY;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							USHORT i;
//STRIP001 /*?*/ 							const ScMergeAttr* pMerge =
//STRIP001 /*?*/ 									(ScMergeAttr*)&aVars.GetPattern()->GetItem(ATTR_MERGE);
//STRIP001 /*?*/ 							USHORT nCountX = pMerge->GetColMerge();
//STRIP001 /*?*/ 							for (i=1; i<nCountX; i++)
//STRIP001 /*?*/ 								nOutWidth += (long) ( pDoc->GetColWidth(nOverX+i,nTab) * nPPTX );
//STRIP001 /*?*/ 							USHORT nCountY = pMerge->GetRowMerge();
//STRIP001 /*?*/ 							for (i=1; i<nCountY; i++)
//STRIP001 /*?*/ 								nOutHeight += (long) ( pDoc->GetRowHeight(nOverY+i,nTab) * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (nOverX+nCountX > nX2+1)
//STRIP001 /*?*/ 								bMergeHClip = TRUE;
//STRIP001 /*?*/ 							if (nOverY+nCountY > nY2+1)
//STRIP001 /*?*/ 								bMergeVClip = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (bEditMode)
//STRIP001 /*?*/ 							if ( nX == nEditCol && nY == nEditRow )
//STRIP001 									{DBG_BF_ASSERT(0, "STRIP");} //STRIP001							aVars.ResetText();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						// GetTextSize ist schon bei SetText passiert
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (bMergeOver)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							ScBaseCell* pBCell;
//STRIP001 /*?*/ 							GetVisibleCell( nOverX, nOverY, nTab, pBCell );
//STRIP001 /*?*/ 							eCellType = (pBCell ? pBCell->GetCellType() : CELLTYPE_NONE);
//STRIP001 /*?*/ 							if ( aVars.GetHorJust() != SVX_HOR_JUSTIFY_STANDARD )
//STRIP001 /*?*/ 								eOutHorJust = aVars.GetHorJust();
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								switch( eCellType )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									case CELLTYPE_STRING:
//STRIP001 /*?*/ 										eOutHorJust = SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 									case CELLTYPE_VALUE:
//STRIP001 /*?*/ 										eOutHorJust = ( eForceText == ftForce )
//STRIP001 /*?*/ 													? SVX_HOR_JUSTIFY_LEFT
//STRIP001 /*?*/ 													: SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 									case CELLTYPE_FORMULA:
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										ScFormulaCell* pFCell = (ScFormulaCell*)pBCell;
//STRIP001 /*?*/ 										if ( pFCell->IsRunning() )
//STRIP001 /*?*/ 											eOutHorJust = SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											lcl_CreateInterpretProgress( bProgress, pDoc, pFCell );
//STRIP001 /*?*/ 											if ( pFCell->HasValueData() )
//STRIP001 /*?*/ 												eOutHorJust = SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 											else
//STRIP001 /*?*/ 												eOutHorJust = SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 									default:
//STRIP001 /*?*/ 										eOutHorJust = SVX_HOR_JUSTIFY_CENTER;		// unbekannt
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							eCellType = pInfo->pCell->GetCellType();
//STRIP001 /*?*/ 							if ( aVars.GetHorJust() != SVX_HOR_JUSTIFY_STANDARD )
//STRIP001 /*?*/ 								eOutHorJust = aVars.GetHorJust();
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								switch( eCellType )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									case CELLTYPE_STRING:
//STRIP001 /*?*/ 										eOutHorJust = SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 									case CELLTYPE_VALUE:
//STRIP001 /*?*/ 										eOutHorJust = ( eForceText == ftForce )
//STRIP001 /*?*/ 													? SVX_HOR_JUSTIFY_LEFT
//STRIP001 /*?*/ 													: SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 									case CELLTYPE_FORMULA:
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										ScFormulaCell* pFCell = (ScFormulaCell*)pInfo->pCell;
//STRIP001 /*?*/ 										if ( pFCell->IsRunning() )
//STRIP001 /*?*/ 											eOutHorJust = SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											lcl_CreateInterpretProgress( bProgress, pDoc, pFCell );
//STRIP001 /*?*/ 											if ( pFCell->IsValue() )
//STRIP001 /*?*/ 												eOutHorJust = SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 											else
//STRIP001 /*?*/ 												eOutHorJust = SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 									default:
//STRIP001 /*?*/ 										eOutHorJust = SVX_HOR_JUSTIFY_CENTER;		// unbekannt
//STRIP001 /*?*/ 										break;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else											// Leftover (langer String)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						eCellType	= CELLTYPE_STRING;
//STRIP001 /*?*/ 						eOutHorJust	= SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( eOutHorJust == SVX_HOR_JUSTIFY_BLOCK || eOutHorJust == SVX_HOR_JUSTIFY_REPEAT )
//STRIP001 /*?*/ 						eOutHorJust = SVX_HOR_JUSTIFY_LEFT;		// noch nicht implementiert
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 													// Clipping testen
//STRIP001 /*?*/ 					BOOL bHClip = FALSE;
//STRIP001 /*?*/ 					BOOL bVClip = FALSE;
//STRIP001 /*?*/ //					BOOL bExtended = FALSE;
//STRIP001 /*?*/ 					CellInfo* pClipRight = NULL;	// Zelle mit Clipping-Markierung (rechts)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					long nJustOutWidth = nOutWidth;			// fuer Ausrichtung
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					long nNeededWidth;
//STRIP001 /*?*/ 					if (eType == OUTTYPE_WINDOW)
//STRIP001 /*?*/ 						nNeededWidth = aVars.GetTextSize().Width() +
//STRIP001 /*?*/ 										(long) ( aVars.GetLeftTotal() * nPPTX ) +
//STRIP001 /*?*/ 										(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						nNeededWidth = aVars.GetTextSize().Width();			// in Margin zeichnen erlaubt
//STRIP001 /*?*/ 						switch (eOutHorJust)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							case SVX_HOR_JUSTIFY_LEFT:
//STRIP001 /*?*/ 								nNeededWidth += (long) ( aVars.GetLeftTotal() * nPPTX );
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							case SVX_HOR_JUSTIFY_RIGHT:
//STRIP001 /*?*/ 								nNeededWidth += (long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							case SVX_HOR_JUSTIFY_CENTER:
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							default:
//STRIP001 /*?*/ 								nNeededWidth += (long) ( aVars.GetLeftTotal() * nPPTX ) +
//STRIP001 /*?*/ 												(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					//
//STRIP001 /*?*/ 					//		horizontalen Platz testen
//STRIP001 /*?*/ 					//
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					BOOL bNeedEditEngine = FALSE;
//STRIP001 /*?*/ 					if ( aVars.GetLineBreak() ||
//STRIP001 /*?*/ 						 aVars.GetHorJust() == SVX_HOR_JUSTIFY_BLOCK )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 														//! hier immer Margin beruecksichtigen ???
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						BOOL bBig;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						//if (aVars.GetString().Search((sal_Unicode)10) != STRING_NOTFOUND)
//STRIP001 /*?*/ 						//	bBig = TRUE;
//STRIP001 /*?*/ 						//else ...
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (aVars.GetOrient() == SVX_ORIENTATION_STANDARD)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							long nCmpWidth = nOutWidth;		// auch hier AutoFilter abziehen
//STRIP001 /*?*/ 							if ( eType==OUTTYPE_WINDOW && pInfo && pInfo->bAutoFilter )
//STRIP001 /*?*/ 								nCmpWidth -= Min( pThisRowInfo->nHeight,
//STRIP001 /*?*/ 													(USHORT) DROPDOWN_BITMAP_SIZE );
//STRIP001 /*?*/ 							bBig = (nNeededWidth+1 > nCmpWidth);
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							bBig = (aVars.GetTextSize().Height() > nOutHeight);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (bBig)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if (bMergeOver)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								// BOOL bVisChanged = !pRowInfo[nArrY-1].bChanged
//STRIP001 /*?*/ 								if (nOverY == nY || !pRowInfo[nArrY-1].bChanged )
//STRIP001 /*?*/ 									pThisRowInfo->pCellInfo[nOverX+1].bEditEngine = TRUE;
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									pRowInfo[0].pCellInfo[nOverX+1].bEditEngine = TRUE;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								pInfo->bEditEngine = TRUE;
//STRIP001 /*?*/ 							bNeedEditEngine = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (!bNeedEditEngine)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if ( eCellType == CELLTYPE_STRING ||
//STRIP001 /*?*/ 							(eCellType == CELLTYPE_FORMULA
//STRIP001 /*?*/ 								&& !lcl_IsValueDataAtPos( bProgress, pDoc,
//STRIP001 /*?*/ 									nX, nY, nTab )) )
//STRIP001 /*?*/ 						{														// rechts Platz suchen
//STRIP001 /*?*/ 							if (nNeededWidth+1 > nOutWidth )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								if ( bMergeOver )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	zusammengefasste zu klein - nicht weitersuchen
//STRIP001 /*?*/ 									eOutHorJust = SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 									bHClip = TRUE;
//STRIP001 /*?*/ 									//	The flag for clip marks can be set for any cell
//STRIP001 /*?*/ 									//	in the merged area (handled by DrawClipMarks)
//STRIP001 /*?*/ 									pClipRight = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if ( aVars.GetOrient() == SVX_ORIENTATION_STANDARD )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										if ( !pThisRowInfo->pCellInfo[nX+1].bMerged )
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											USHORT nTempX = nX+1;
//STRIP001 /*?*/ 											BOOL bCont = TRUE;
//STRIP001 /*?*/ 											while (bCont)
//STRIP001 /*?*/ 											{
//STRIP001 /*?*/ 												BOOL bMayCont = pThisRowInfo->pCellInfo[nTempX+1].bEmptyCellText &&
//STRIP001 /*?*/ 															   !pThisRowInfo->pCellInfo[nTempX+1].bMerged &&
//STRIP001 /*?*/ 															   !pThisRowInfo->pCellInfo[nTempX+1].bHOverlapped &&
//STRIP001 /*?*/ 															   !pThisRowInfo->pCellInfo[nTempX+1].bVOverlapped;
//STRIP001 /*?*/ 												bCont = bMayCont && (nTempX<=nX2);
//STRIP001 /*?*/ 												if ( bEditMode && nTempX == nEditCol && nY == nEditRow )
//STRIP001 /*?*/ 													bCont = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 												//	Grid (fuer nTempX-1) abschalten ?
//STRIP001 /*?*/ 												//
//STRIP001 /*?*/ 												if (nOutWidth < nNeededWidth)
//STRIP001 /*?*/ 												{
//STRIP001 /*?*/ 													if (bMayCont)
//STRIP001 /*?*/ 														pThisRowInfo->pCellInfo[nTempX].bHideGrid = TRUE;
//STRIP001 /*?*/ 													else
//STRIP001 /*?*/ 														pClipRight = &pThisRowInfo->pCellInfo[nTempX];
//STRIP001 /*?*/ 														// auf "Hindernis" gestossen
//STRIP001 /*?*/ 												}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 												if (bCont)
//STRIP001 /*?*/ 													nOutWidth += (long) pRowInfo[0].pCellInfo[nTempX+1].nWidth;
//STRIP001 /*?*/ 												++nTempX;
//STRIP001 /*?*/ 											}
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											//	The flag for clip marks can be set for any cell
//STRIP001 /*?*/ 											//	in the merged area (handled by DrawClipMarks)
//STRIP001 /*?*/ 											if ( nOutWidth < nNeededWidth )
//STRIP001 /*?*/ 												pClipRight = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ //									bExtended = TRUE;
//STRIP001 /*?*/ 									eOutHorJust = SVX_HOR_JUSTIFY_LEFT;
//STRIP001 /*?*/ 									bHClip = bLeftOver || (nNeededWidth + 1 > nOutWidth);
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								bHClip = bLeftOver || bMergeOver;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else								// Zahlen, Formeln
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if (nNeededWidth + 1 > nOutWidth)
//STRIP001 /*?*/ 							{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 //STRIP001 /*?*/ 								aVars.SetHashText();
//STRIP001 //STRIP001 /*?*/ 								nNeededWidth = aVars.GetTextSize().Width() +
//STRIP001 //STRIP001 /*?*/ 											(long) ( aVars.GetLeftTotal() * nPPTX ) +
//STRIP001 //STRIP001 /*?*/ 											(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 //STRIP001 /*?*/ 								bHClip = (nNeededWidth + 1 > nOutWidth);
//STRIP001 //STRIP001 /*?*/ 								if (bHClip)		// #56609# Clip-Markierung auch fuer Zahlen
//STRIP001 //STRIP001 /*?*/ 									pClipRight = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							if (bMergeOver)
//STRIP001 /*?*/ 								bHClip = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( !bLeftOver )							// sonst ist schon
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							long nAvailWidth = nJustOutWidth;
//STRIP001 /*?*/ 							if (eType==OUTTYPE_WINDOW && pInfo->bAutoFilter)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ #ifndef MAC
//STRIP001 /*?*/ 								if (pRowInfo[nArrY].nHeight < DROPDOWN_BITMAP_SIZE)
//STRIP001 /*?*/ 									nAvailWidth -= pRowInfo[nArrY].nHeight;
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									nAvailWidth -= DROPDOWN_BITMAP_SIZE;		// Bitmap-Groesse
//STRIP001 /*?*/ #else
//STRIP001 /*?*/ 								nAvailWidth -= pRefDevice->LogicToPixel( Size(22,0), MAP_POINT ).Width();
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								long nComp = aVars.GetTextSize().Width() +
//STRIP001 /*?*/ 												(long) ( aVars.GetLeftTotal() * nPPTX ) +
//STRIP001 /*?*/ 												(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 								if (nAvailWidth<nComp) nAvailWidth=nComp;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							switch (eOutHorJust)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								case SVX_HOR_JUSTIFY_LEFT:
//STRIP001 /*?*/ 									nJustPosX += (long) ( aVars.GetLeftTotal() * nPPTX );
//STRIP001 /*?*/ 									break;
//STRIP001 /*?*/ 								case SVX_HOR_JUSTIFY_RIGHT:
//STRIP001 /*?*/ 									nJustPosX += nAvailWidth - aVars.GetTextSize().Width() -
//STRIP001 /*?*/ 												(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 									bRightAdjusted = TRUE;
//STRIP001 /*?*/ 									break;
//STRIP001 /*?*/ 								case SVX_HOR_JUSTIFY_CENTER:
//STRIP001 /*?*/ 									nJustPosX += ( nAvailWidth - aVars.GetTextSize().Width() +
//STRIP001 /*?*/ 												(long) ( aVars.GetLeftTotal() * nPPTX ) -
//STRIP001 /*?*/ 												(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX ) ) / 2;
//STRIP001 /*?*/ 									break;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nTestClipHeight = aVars.GetTextSize().Height();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nJustPosY = nVirtPosY;
//STRIP001 /*?*/ //						long nLongBot = (long) ( aVars.GetMargin()->GetBottomMargin() * nPPTY );
//STRIP001 /*?*/ 						switch (aVars.GetVerJust())
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							case SVX_VER_JUSTIFY_TOP:
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									long nTop = (long)( aVars.GetMargin()->GetTopMargin() * nPPTY );
//STRIP001 /*?*/ 									nJustPosY += nTop;
//STRIP001 /*?*/ 									nTestClipHeight += nTop;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							case SVX_VER_JUSTIFY_BOTTOM:
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									long nBot = (long)( aVars.GetMargin()->GetBottomMargin() * nPPTY );
//STRIP001 /*?*/ 									nJustPosY += nOutHeight - aVars.GetTextSize().Height() - nBot;
//STRIP001 /*?*/ 									nTestClipHeight += nBot;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							case SVX_VER_JUSTIFY_CENTER:
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									long nTop = (long)( aVars.GetMargin()->GetTopMargin() * nPPTY );
//STRIP001 /*?*/ 									long nBot = (long)( aVars.GetMargin()->GetBottomMargin() * nPPTY );
//STRIP001 /*?*/ 									nJustPosY += ( nOutHeight + nTop -
//STRIP001 /*?*/ 													aVars.GetTextSize().Height() - nBot ) / 2;
//STRIP001 /*?*/ 									nTestClipHeight += Abs( nTop - nBot );
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( nTestClipHeight > nOutHeight )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//	kein vertikales Clipping beim Drucken von Zellen mit
//STRIP001 /*?*/ 							//	optimaler Hoehe, ausser bei Groesse in bedingter Formatierung
//STRIP001 /*?*/ 							if ( eType != OUTTYPE_PRINTER ||
//STRIP001 /*?*/ 									( pDoc->GetRowFlags( nY, nTab ) & CR_MANUALSIZE ) ||
//STRIP001 /*?*/ 									( aVars.HasCondHeight() ) )
//STRIP001 /*?*/ 								bVClip = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						if ( bMergeOver )
//STRIP001 /*?*/ 							bVClip = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						Rectangle aClipRect( nPosX, nPosY, nVirtPosX+nOutWidth-1,
//STRIP001 /*?*/ 															nVirtPosY+nOutHeight-1 );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( bMergeHClip )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//	don't limit to end of screen if clip mark is subtracted below
//STRIP001 /*?*/ 							if ( aClipRect.Right() > nScrX+nScrW && !( pClipRight && bMarkClipped ) )
//STRIP001 /*?*/ 								aClipRect.Right() = nScrX+nScrW;
//STRIP001 /*?*/ 							bHClip = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						if ( bMergeVClip )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if ( aClipRect.Bottom() > nScrY+nScrH )
//STRIP001 /*?*/ 								aClipRect.Bottom() = nScrY+nScrH;
//STRIP001 /*?*/ 							bVClip = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( bHClip || bVClip )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if ( pClipRight && bMarkClipped )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								//	rechts markieren
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								pClipRight->bStandard = TRUE;	//!	umbenennen in bClipped
//STRIP001 /*?*/ 								bAnyClipped = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								long nMarkPixel = (long)( SC_CLIPMARK_SIZE * nPPTX );
//STRIP001 /*?*/ 								aClipRect.Right() -= nMarkPixel;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	nur die betroffene Dimension clippen,
//STRIP001 /*?*/ 							//	damit bei nicht-proportionalem Resize nicht alle
//STRIP001 /*?*/ 							//	rechtsbuendigen Zahlen abgeschnitten werden:
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (!bHClip)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								aClipRect.Left() = nScrX;
//STRIP001 /*?*/ 								aClipRect.Right() = nScrX+nScrW;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							if (!bVClip)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								aClipRect.Top() = nScrY;
//STRIP001 /*?*/ 								aClipRect.Bottom() = nScrY+nScrH;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*							//! Test
//STRIP001 							if ( pDev->GetOutDevType() != OUTDEV_PRINTER )
//STRIP001 							{
//STRIP001 								pDev->SetPen(PEN_NULL);
//STRIP001 								pDev->SetFillInBrush(Brush(Color(COL_LIGHTRED)));
//STRIP001 								pDev->DrawRect( aClipRect );
//STRIP001 							}
//STRIP001 							//! Test
//STRIP001 */
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	aClipRect is not used after SetClipRegion/IntersectClipRegion,
//STRIP001 /*?*/ 							//	so it can be modified here
//STRIP001 /*?*/ 							if (bPixelToLogic)
//STRIP001 /*?*/ 								aClipRect = pRefDevice->PixelToLogic( aClipRect );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (bMetaFile)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								pDev->Push();
//STRIP001 /*?*/ 								pDev->IntersectClipRegion( aClipRect );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								pDev->SetClipRegion( Region( aClipRect ) );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						switch (aVars.GetOrient())
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							case SVX_ORIENTATION_STANDARD:
//STRIP001 /*?*/ 								nJustPosY += aVars.GetAscent();
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							case SVX_ORIENTATION_TOPBOTTOM:
//STRIP001 /*?*/ 								nJustPosX += aVars.GetTextSize().Width() - aVars.GetAscent();
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							case SVX_ORIENTATION_BOTTOMTOP:
//STRIP001 /*?*/ 								nJustPosY += aVars.GetTextSize().Height();
//STRIP001 /*?*/ 								nJustPosX += aVars.GetAscent();
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ #ifdef MAC_DOCH_NICHT
//STRIP001 /*?*/ 						nJustPosY++;	// Passt sonst nicht zur EditEngine
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ #ifdef OS2_AUCH_NICHT
//STRIP001 /*?*/ 						nJustPosY++;	// Passt sonst nicht zur EditEngine
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						BOOL bMoveClipped = bHClip && aVars.IsRightToLeftAttr();
//STRIP001 /*?*/ 						if ( bMoveClipped )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//	#i9731# if long text is clipped, and the cell is formatted as rtl,
//STRIP001 /*?*/ 							//	move the start position so the right end is visible
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							long nNeeded = aVars.GetTextSize().Width() + 
//STRIP001 /*?*/ 										(long) ( aVars.GetLeftTotal() * nPPTX ) +
//STRIP001 /*?*/ 										(long) ( aVars.GetMargin()->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 							long nAvailable = GetAvailableWidth( nCellX, nCellY, nNeeded );
//STRIP001 /*?*/ 							if ( nAvailable < nNeeded )
//STRIP001 /*?*/ 								nJustPosX -= nNeeded - nAvailable;		// move the start position
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						Point aDrawTextPos( nJustPosX, nJustPosY );
//STRIP001 /*?*/ 						if ( bPixelToLogic )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//	undo text width adjustment in pixels
//STRIP001 /*?*/ 							if (bRightAdjusted)
//STRIP001 /*?*/ 								aDrawTextPos.X() += aVars.GetTextSize().Width();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							aDrawTextPos = pRefDevice->PixelToLogic( aDrawTextPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	redo text width adjustment in logic units
//STRIP001 /*?*/ 							if (bRightAdjusted)
//STRIP001 /*?*/ 								aDrawTextPos.X() -= aVars.GetOriginalWidth();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						//	in Metafiles immer DrawTextArray, damit die Positionen mit
//STRIP001 /*?*/ 						//	aufgezeichnet werden (fuer nicht-proportionales Resize):
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						String aString = aVars.GetString();
//STRIP001 /*?*/ 						if (bMetaFile || pFmtDevice != pDev || aZoomX != aZoomY)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							long* pDX = new long[aString.Len()];
//STRIP001 /*?*/ 							pFmtDevice->GetTextArray( aString, pDX );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if ( !pRefDevice->GetConnectMetaFile() ||
//STRIP001 /*?*/ 									pRefDevice->GetOutDevType() == OUTDEV_PRINTER )
//STRIP001 /*?*/ 							{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 //STRIP001 /*?*/ 								double fMul = GetStretch();
//STRIP001 //STRIP001 /*?*/ 								xub_StrLen nLen = aString.Len();
//STRIP001 //STRIP001 /*?*/ 								for (xub_StrLen i=0; i<nLen; i++)
//STRIP001 //STRIP001 /*?*/ 									pDX[i] = (long)(pDX[i] / fMul + 0.5);
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							pDev->DrawTextArray( aDrawTextPos, aString, pDX );
//STRIP001 /*?*/ 							delete[] pDX;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							pDev->DrawText( aDrawTextPos, aString );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( bHClip || bVClip )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if (bMetaFile)
//STRIP001 /*?*/ 								pDev->Pop();
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								pDev->SetClipRegion();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 /*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 	}
/*N*/ 	if ( bProgress )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ScProgress::DeleteInterpretProgress();
/*N*/ 	pDoc->DisableIdle( bWasIdleDisabled );
/*N*/ }

//	-------------------------------------------------------------------------------

//STRIP001 Size lcl_GetVertPaperSize( ScDocument* pDoc, USHORT nCol, USHORT nRow, USHORT nTab )
//STRIP001 {
//STRIP001 	const double nPPTY = HMM_PER_TWIPS;
//STRIP001 
//STRIP001 	const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 	const ScMergeAttr& rMerge = (const ScMergeAttr&)pPattern->GetItem(ATTR_MERGE);
//STRIP001 
//STRIP001 	long nCellY = (long) ( pDoc->GetRowHeight(nRow,nTab) * nPPTY );
//STRIP001 	if ( rMerge.GetRowMerge() > 1 )
//STRIP001 	{
//STRIP001 		USHORT nCountY = rMerge.GetRowMerge();
//STRIP001 		for (USHORT i=1; i<nCountY; i++)
//STRIP001 			nCellY += (long) ( pDoc->GetRowHeight(nRow+i,nTab) * nPPTY );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	only top/bottom margin are interesting
//STRIP001 	const SvxMarginItem& rMargin = (const SvxMarginItem&)pPattern->GetItem(ATTR_MARGIN);
//STRIP001 	nCellY -= (long) ( rMargin.GetTopMargin() * nPPTY );
//STRIP001 	nCellY -= (long) ( rMargin.GetBottomMargin() * nPPTY );
//STRIP001 
//STRIP001 	return Size( nCellY - 1, 1000000 );		// cell height as width for PaperSize
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_ClearEdit( EditEngine& rEngine )		// Text und Attribute
//STRIP001 {
//STRIP001 	rEngine.SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	rEngine.SetText(EMPTY_STRING);
//STRIP001 	//	keine Para-Attribute uebrigbehalten...
//STRIP001 	const SfxItemSet& rPara = rEngine.GetParaAttribs(0);
//STRIP001 	if (rPara.Count())
//STRIP001 		rEngine.SetParaAttribs( 0,
//STRIP001 					SfxItemSet( *rPara.GetPool(), rPara.GetRanges() ) );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL lcl_SafeIsValue( ScBaseCell* pCell )
//STRIP001 {
//STRIP001 	if (!pCell)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	switch ( pCell->GetCellType() )
//STRIP001 	{
//STRIP001 		case CELLTYPE_VALUE:
//STRIP001 			bRet = TRUE;
//STRIP001 			break;
//STRIP001 		case CELLTYPE_FORMULA:
//STRIP001 			{
//STRIP001 				ScFormulaCell* pFCell = (ScFormulaCell*)pCell;
//STRIP001 				if ( pFCell->IsRunning() || pFCell->IsValue() )
//STRIP001 					bRet = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

/*N*/ void ScOutputData::DrawEdit(BOOL bPixelToLogic)
/*N*/ {
/*N*/ 	Size aMinSize = pRefDevice->PixelToLogic(Size(0,100));		// erst darueber wird ausgegeben
/*N*/ 	UINT32 nMinHeight = aMinSize.Height() / 200;				// 1/2 Pixel
/*N*/ 
/*N*/ 	SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
/*N*/ 
/*M*/ 	ScModule* pScMod = SC_MOD();
/*N*/     sal_Int32 nConfBackColor = pScMod->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor;
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor &&
/*N*/ 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
/*M*/ 
/*N*/ 	ScFieldEditEngine* pEngine = NULL;
/*N*/ 	BOOL bHyphenatorSet = FALSE;
/*N*/ 	const ScPatternAttr* pPattern;
/*N*/ 	const SfxItemSet*	 pCondSet;
/*N*/ 	const ScPatternAttr* pOldPattern = NULL;
/*N*/ 	const SfxItemSet*	 pOldCondSet = NULL;
/*N*/ 	ScBaseCell* pCell = NULL;
/*N*/ 
/*N*/ 	long nRowPosY = nScrY;
/*N*/ 	for (USHORT nArrY=0; nArrY+1<nArrCount; nArrY++)			// 0 fuer Reste von zusammengefassten
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		long nCellHeight = (long) pThisRowInfo->nHeight;
/*N*/ 		if (nArrY==1) nRowPosY = nScrY;							// vorher wird einzeln berechnet
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged || nArrY==0 )
/*N*/ 		{
/*N*/ 			long nPosX = 0;
/*N*/ 			for (USHORT nX=0; nX<=nX2; nX++)					// wegen Ueberhaengen
/*N*/ 			{
/*N*/ 				if (nX==nX1) nPosX = nScrX;						// vorher wird einzeln berechnet
/*N*/ 
/*N*/ 				CellInfo*	pInfo = &pThisRowInfo->pCellInfo[nX+1];
/*N*/ 				if (pInfo->bEditEngine)
/*N*/ 				{
/*?*/ 					USHORT nY = pThisRowInfo->nRowNo;
/*?*/ 
/*?*/ 					BOOL bHidden = FALSE;
/*?*/ 					if (bEditMode)
/*?*/ 						if ( nX == nEditCol && nY == nEditRow )
/*?*/ 							bHidden = TRUE;
/*?*/ 
/*?*/ 					if (!bHidden)
						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 						if (!pEngine)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//	Ein RefDevice muss auf jeden Fall gesetzt werden,
//STRIP001 /*?*/ 							//	sonst legt sich die EditEngine ein VirtualDevice an!
//STRIP001 /*?*/ 							pEngine = new ScFieldEditEngine( pDoc->GetEnginePool() );
//STRIP001 /*?*/ 							pEngine->SetUpdateMode( FALSE );
//STRIP001 /*?*/ 							pEngine->SetRefDevice( pFmtDevice );	// always set
//STRIP001 /*?*/ 							ULONG nCtrl = pEngine->GetControlWord();
//STRIP001 /*?*/ 							if ( bShowSpellErrors )
//STRIP001 /*?*/ 								nCtrl |= EE_CNTRL_ONLINESPELLING;
//STRIP001 /*?*/ 							if ( eType == OUTTYPE_PRINTER )
//STRIP001 /*?*/ 								nCtrl &= ~EE_CNTRL_MARKFIELDS;
//STRIP001 /*?*/ 							pEngine->SetControlWord( nCtrl );
//STRIP001 /*?*/ 							pEngine->SetForbiddenCharsTable( pDoc->GetForbiddenCharacters() );
//STRIP001 /*?*/ 							pEngine->SetAsianCompressionMode( pDoc->GetAsianCompression() );
//STRIP001 /*?*/ 							pEngine->SetKernAsianPunctuation( pDoc->GetAsianKerning() );
//STRIP001 /*?*/ 							pEngine->EnableAutoColor( bUseStyleColor );
//STRIP001 /*M*/ 							pEngine->SetDefaultHorizontalTextDirection(
//STRIP001 /*M*/ 								(EEHorizontalTextDirection)pDoc->GetEditTextDirection( nTab ) );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							lcl_ClearEdit( *pEngine );		// also calls SetUpdateMode(FALSE)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nPosY = nRowPosY;
//STRIP001 /*?*/ 						BOOL bVisChanged = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( nArrY==0 )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							nPosY = nScrY;
//STRIP001 /*?*/ 							nY = pRowInfo[1].nRowNo;
//STRIP001 /*?*/ 							pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 /*?*/ 							while (((ScMergeFlagAttr&)pPattern->GetItem(ATTR_MERGE_FLAG)).IsVerOverlapped())
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								--nY;
//STRIP001 /*?*/ 								nPosY -= (long) (pDoc->FastGetRowHeight(nY,nTab) * nPPTY);
//STRIP001 /*?*/ 								pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							pInfo = NULL;
//STRIP001 /*?*/ 							pCondSet = pDoc->GetCondResult( nX, nY, nTab );
//STRIP001 /*?*/ 							GetVisibleCell( nX, nY, nTab, pCell );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							BOOL bFromDoc = FALSE;
//STRIP001 /*?*/ 							pPattern = pInfo->pPatternAttr;
//STRIP001 /*?*/ 							pCondSet = pInfo->pConditionSet;
//STRIP001 /*?*/ 							if (!pPattern)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 /*?*/ 								bFromDoc = TRUE;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							pCell = pInfo->pCell;
//STRIP001 /*?*/ 							if ( bFromDoc && !pCell )
//STRIP001 /*?*/ 								GetVisibleCell( nX, nY, nTab, pCell );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							bVisChanged = !pRowInfo[nArrY-1].bChanged;
//STRIP001 /*?*/ 							if (bVisChanged)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								while (((ScMergeFlagAttr&)pPattern->GetItem(ATTR_MERGE_FLAG)).IsVerOverlapped())
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									--nY;
//STRIP001 /*?*/ 									nPosY -= (long) (pDoc->FastGetRowHeight(nY,nTab) * nPPTY);
//STRIP001 /*?*/ 									pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 /*?*/ 									bFromDoc = TRUE;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								pInfo = NULL;
//STRIP001 /*?*/ 								GetVisibleCell( nX, nY, nTab, pCell );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							if (bFromDoc)
//STRIP001 /*?*/ 								pCondSet = pDoc->GetCondResult( nX, nY, nTab );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						BOOL bIsValue = lcl_SafeIsValue(pCell);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nCellWidth = (long) pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						const SfxPoolItem* pCondItem;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SvxCellHorJustify eHorJust;
//STRIP001 /*?*/ 						if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 									ATTR_HOR_JUSTIFY, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 							eHorJust = (SvxCellHorJustify) ((const SvxHorJustifyItem*)
//STRIP001 /*?*/ 																pCondItem)->GetValue();
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							eHorJust = (SvxCellHorJustify)((const SvxHorJustifyItem&)pPattern->
//STRIP001 /*?*/ 													GetItem(ATTR_HOR_JUSTIFY)).GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						BOOL bBreak;
//STRIP001 /*?*/ 						if ( eHorJust == SVX_HOR_JUSTIFY_BLOCK )
//STRIP001 /*?*/ 							bBreak = TRUE;
//STRIP001 /*?*/ 						else if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 									ATTR_LINEBREAK, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 							bBreak = ((const SfxBoolItem*)pCondItem)->GetValue();
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							bBreak = ((const SfxBoolItem&)pPattern->GetItem(ATTR_LINEBREAK)).GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SvxCellOrientation eOrient;
//STRIP001 /*?*/ 						if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 									ATTR_ORIENTATION, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 							eOrient = (SvxCellOrientation)((const SvxOrientationItem*)
//STRIP001 /*?*/ 											pCondItem)->GetValue();
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							eOrient = (SvxCellOrientation)((const SvxOrientationItem&)
//STRIP001 /*?*/ 											pPattern->GetItem(ATTR_ORIENTATION)).GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nAttrRotate;
//STRIP001 /*?*/ 						if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 									ATTR_ROTATE_VALUE, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 							nAttrRotate = ((const SfxInt32Item*)pCondItem)->GetValue();
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							nAttrRotate = ((const SfxInt32Item&)pPattern->
//STRIP001 /*?*/ 											GetItem(ATTR_ROTATE_VALUE)).GetValue();
//STRIP001 /*?*/ 						if ( eOrient==SVX_ORIENTATION_STANDARD && nAttrRotate )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//!	Flag setzen, um die Zelle in DrawRotated wiederzufinden ?
//STRIP001 /*?*/ 							//!	(oder Flag schon bei DrawBackground, dann hier keine Abfrage)
//STRIP001 /*?*/ 							bHidden = TRUE;		// gedreht wird getrennt ausgegeben
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						BOOL bAsianVertical = ( eOrient == SVX_ORIENTATION_STACKED &&
//STRIP001 /*?*/ 								((const SfxBoolItem&)pPattern->GetItem( ATTR_VERTICAL_ASIAN, pCondSet )).GetValue() );
//STRIP001 /*?*/ 						if ( bAsianVertical )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// in asian mode, use EditEngine::SetVertical instead of EE_CNTRL_ONECHARPERLINE
//STRIP001 /*?*/ 							eOrient = SVX_ORIENTATION_STANDARD;
//STRIP001 /*?*/ 							// default alignment for asian vertical mode is top-right
//STRIP001 /*?*/ 							if ( eHorJust == SVX_HOR_JUSTIFY_STANDARD )
//STRIP001 /*?*/ 								eHorJust = SVX_HOR_JUSTIFY_RIGHT;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						const ScMergeAttr* pMerge =
//STRIP001 /*?*/ 								(ScMergeAttr*)&pPattern->GetItem(ATTR_MERGE);
//STRIP001 /*?*/ 						BOOL bMerged = pMerge->GetColMerge() > 1 || pMerge->GetRowMerge() > 1;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nStartX = nPosX;
//STRIP001 /*?*/ 						long nStartY = nPosY;
//STRIP001 /*?*/ 						if (nX<nX1)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if ((bBreak || eOrient!=SVX_ORIENTATION_STANDARD) && !bMerged && !bAsianVertical)
//STRIP001 /*?*/ 								bHidden = TRUE;
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								nStartX = nScrX;
//STRIP001 /*?*/ 								USHORT nCol = nX1;
//STRIP001 /*?*/ 								while (nCol > nX)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									--nCol;
//STRIP001 /*?*/ 									nStartX -= (long) pRowInfo[0].pCellInfo[nCol+1].nWidth;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( !bHidden && eType == OUTTYPE_PRINTER &&
//STRIP001 /*?*/ 							pDev->GetOutDevType() == OUTDEV_WINDOW &&
//STRIP001 /*?*/ 							((const SvxFontHeightItem&)pPattern->
//STRIP001 /*?*/ 							GetItem(ATTR_FONT_HEIGHT)).GetHeight() <= nMinHeight )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							Point aPos( nStartX, nStartY );
//STRIP001 /*?*/ 							pDev->DrawPixel( aPos,
//STRIP001 /*?*/ 											((const SvxColorItem&)pPattern->
//STRIP001 /*?*/ 											GetItem( ATTR_FONT_COLOR )).GetValue() );
//STRIP001 /*?*/ 							bHidden = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (!bHidden)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							BOOL bMergeClip = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							long nOutWidth = nCellWidth - 1;
//STRIP001 /*?*/ 							long nOutHeight;
//STRIP001 /*?*/ 							if (pInfo)
//STRIP001 /*?*/ 								nOutHeight = nCellHeight;
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								nOutHeight = (long) ( pDoc->GetRowHeight(nY,nTab) * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if ( bMerged )								// Zusammengefasst
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								USHORT i;
//STRIP001 /*?*/ 								const ScMergeAttr* pMerge =
//STRIP001 /*?*/ 										(ScMergeAttr*)&pPattern->GetItem(ATTR_MERGE);
//STRIP001 /*?*/ 								USHORT nCountX = pMerge->GetColMerge();
//STRIP001 /*?*/ 								for (i=1; i<nCountX; i++)
//STRIP001 /*?*/ 									nOutWidth += (long) ( pDoc->GetColWidth(nX+i,nTab) * nPPTX );
//STRIP001 /*?*/ 								USHORT nCountY = pMerge->GetRowMerge();
//STRIP001 /*?*/ 								for (i=1; i<nCountY; i++)
//STRIP001 /*?*/ 									nOutHeight += (long) ( pDoc->GetRowHeight(nY+i,nTab) * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( nX+nCountX > nX2+1 || nY+nCountY > nY2+1 )
//STRIP001 /*?*/ 									bMergeClip = TRUE;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	aCellRect: Margins nicht abgezogen
//STRIP001 /*?*/ 							Rectangle aCellRect( nStartX, nStartY,
//STRIP001 /*?*/ 											nStartX+nOutWidth-1, nStartY+nOutHeight-1 );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							SvxCellVerJustify eVerJust;
//STRIP001 /*?*/ 							if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 										ATTR_VER_JUSTIFY, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 								eVerJust = (SvxCellVerJustify) ((const SvxVerJustifyItem*)
//STRIP001 /*?*/ 																	pCondItem)->GetValue();
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								eVerJust = (SvxCellVerJustify)((const SvxVerJustifyItem&)pPattern->
//STRIP001 /*?*/ 														GetItem(ATTR_VER_JUSTIFY)).GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							// default alignment for asian vertical mode is top-right
//STRIP001 /*?*/ 							if ( bAsianVertical && eVerJust == SVX_VER_JUSTIFY_STANDARD )
//STRIP001 /*?*/ 								eVerJust = SVX_VER_JUSTIFY_TOP;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							// Syntax-Modus wird hier ignoriert...
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							// StringDiffer doesn't look at hyphenate, language items
//STRIP001 /*?*/ 							if ( pPattern != pOldPattern || pCondSet != pOldCondSet )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								SfxItemSet* pSet = new SfxItemSet( pEngine->GetEmptyItemSet() );
//STRIP001 /*?*/ 								pPattern->FillEditItemSet( pSet, pCondSet );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								pEngine->SetDefaults( pSet );
//STRIP001 /*?*/ 								pOldPattern = pPattern;
//STRIP001 /*?*/ 								pOldCondSet = pCondSet;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								ULONG nControl = pEngine->GetControlWord();
//STRIP001 /*?*/ 								if (eOrient==SVX_ORIENTATION_STACKED)
//STRIP001 /*?*/ 									nControl |= EE_CNTRL_ONECHARPERLINE;
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									nControl &= ~EE_CNTRL_ONECHARPERLINE;
//STRIP001 /*?*/ 								pEngine->SetControlWord( nControl );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( !bHyphenatorSet && ((const SfxBoolItem&)pSet->Get(EE_PARA_HYPHENATE)).GetValue() )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	set hyphenator the first time it is needed
//STRIP001 /*?*/                                     ::com::sun::star::uno::Reference< ::com::sun::star::linguistic2::XHyphenator> xXHyphenator( LinguMgr::GetHyphenator() );
//STRIP001 /*?*/ 									pEngine->SetHyphenator( xXHyphenator );
//STRIP001 /*?*/ 									bHyphenatorSet = TRUE;
//STRIP001 /*M*/ 								}
//STRIP001 /*M*/ 
//STRIP001 /*M*/ 								Color aBackCol = ((const SvxBrushItem&)
//STRIP001 /*M*/ 									pPattern->GetItem( ATTR_BACKGROUND, pCondSet )).GetColor();
//STRIP001 /*M*/ 								if ( bUseStyleColor && ( aBackCol.GetTransparency() > 0 || bCellContrast ) )
//STRIP001 /*M*/ 									aBackCol.SetColor( nConfBackColor );
//STRIP001 /*M*/ 								pEngine->SetBackgroundColor( aBackCol );
//STRIP001 /*M*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	horizontal alignment now may depend on cell content
//STRIP001 /*?*/ 							//	(for values with number formats with mixed script types)
//STRIP001 /*?*/ 							//	-> always set adjustment
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							SvxAdjust eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 /*?*/ 							if (eOrient==SVX_ORIENTATION_STACKED)
//STRIP001 /*?*/ 								eSvxAdjust = SVX_ADJUST_CENTER;
//STRIP001 /*?*/ 							else if (bBreak)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								if (eOrient==SVX_ORIENTATION_STANDARD && !bAsianVertical)
//STRIP001 /*?*/ 									switch (eHorJust)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_STANDARD:
//STRIP001 /*?*/ 											eSvxAdjust = bIsValue ? SVX_ADJUST_RIGHT : SVX_ADJUST_LEFT;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_LEFT:
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_REPEAT:			// nicht implementiert
//STRIP001 /*?*/ 											eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_RIGHT:
//STRIP001 /*?*/ 											eSvxAdjust = SVX_ADJUST_RIGHT;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_CENTER:
//STRIP001 /*?*/ 											eSvxAdjust = SVX_ADJUST_CENTER;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_BLOCK:
//STRIP001 /*?*/ 											eSvxAdjust = SVX_ADJUST_BLOCK;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									switch (eVerJust)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										case SVX_VER_JUSTIFY_TOP:
//STRIP001 /*?*/ 											eSvxAdjust = (eOrient==SVX_ORIENTATION_TOPBOTTOM || bAsianVertical) ?
//STRIP001 /*?*/ 														SVX_ADJUST_LEFT : SVX_ADJUST_RIGHT;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 										case SVX_VER_JUSTIFY_CENTER:
//STRIP001 /*?*/ 											eSvxAdjust = SVX_ADJUST_CENTER;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 										case SVX_VER_JUSTIFY_BOTTOM:
//STRIP001 /*?*/ 										case SVX_HOR_JUSTIFY_STANDARD:
//STRIP001 /*?*/ 											eSvxAdjust = (eOrient==SVX_ORIENTATION_TOPBOTTOM || bAsianVertical) ?
//STRIP001 /*?*/ 														SVX_ADJUST_RIGHT : SVX_ADJUST_LEFT;
//STRIP001 /*?*/ 											break;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							pEngine->SetDefaultItem( SvxAdjustItem( eSvxAdjust, EE_PARA_JUST ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	Raender
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//!		Position und Papersize auf EditUtil umstellen !!!
//STRIP001 /*?*/ 
//STRIP001 /*							Rectangle aPixRect = ScEditUtil( pDoc,
//STRIP001 												nX,nY,nTab, Point(nStartX,nStartY),
//STRIP001 												pDev, nPPTX, nPPTY, nZoom )
//STRIP001 												.GetEditArea( pPattern );
//STRIP001 
//STRIP001 							pDev->SetFillInBrush(Brush(Color(COL_LIGHTRED)));
//STRIP001 							pDev->DrawRect(pDev->PixelToLogic(aPixRect));
//STRIP001 */
//STRIP001 /*?*/ 							const SvxMarginItem* pMargin;
//STRIP001 /*?*/ 							if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 										ATTR_MARGIN, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 								pMargin = (const SvxMarginItem*)pCondItem;
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								pMargin = (const SvxMarginItem*)&pPattern->GetItem(ATTR_MARGIN);
//STRIP001 /*?*/ 							USHORT nIndent = 0;
//STRIP001 /*?*/ 							if ( eHorJust == SVX_HOR_JUSTIFY_LEFT )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								if ( pCondSet && pCondSet->GetItemState(
//STRIP001 /*?*/ 											ATTR_INDENT, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 /*?*/ 									nIndent = ((const SfxUInt16Item*)pCondItem)->GetValue();
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									nIndent = ((const SfxUInt16Item&)pPattern->
//STRIP001 /*?*/ 													GetItem(ATTR_INDENT)).GetValue();
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							long nLeftM = (long) ( (pMargin->GetLeftMargin() + nIndent) * nPPTX );
//STRIP001 /*?*/ 							long nTopM  = (long) ( pMargin->GetTopMargin() * nPPTY );
//STRIP001 /*?*/ 							nStartX += nLeftM;
//STRIP001 /*?*/ 							nStartY += nTopM;
//STRIP001 /*?*/ 							nOutWidth -= nLeftM + (long) ( pMargin->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 							nOutHeight -= nTopM + (long) ( pMargin->GetBottomMargin() * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							Size aPaperSize = Size( 1000000, 1000000 );
//STRIP001 /*?*/ 							if ( eOrient==SVX_ORIENTATION_STACKED )
//STRIP001 /*?*/ 								aPaperSize.Width() = nOutWidth;				// zum Zentrieren
//STRIP001 /*?*/ 							else if (bAsianVertical)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								aPaperSize.Width() = nOutWidth;
//STRIP001 /*?*/ 								if (bBreak)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	add some extra height (default margin value) for safety
//STRIP001 /*?*/ 									//	as long as GetEditArea isn't used below
//STRIP001 /*?*/ 									long nExtraHeight = (long)( 20 * nPPTY );
//STRIP001 /*?*/ 									aPaperSize.Height() = nOutHeight + nExtraHeight;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else if (bBreak)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								if (eOrient == SVX_ORIENTATION_STANDARD)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if (eType==OUTTYPE_WINDOW &&
//STRIP001 /*?*/ 											eOrient!=SVX_ORIENTATION_STACKED &&
//STRIP001 /*?*/ 											pInfo && pInfo->bAutoFilter)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										long nSub = Min( pRowInfo[nArrY].nHeight,
//STRIP001 /*?*/ 														(USHORT) DROPDOWN_BITMAP_SIZE );
//STRIP001 /*?*/ 										if ( nOutWidth > nSub )
//STRIP001 /*?*/ 											nOutWidth -= nSub;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									aPaperSize.Width() = nOutWidth;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									aPaperSize.Width() = nOutHeight - 1;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							if (bPixelToLogic)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								//!	also handle bAsianVertical in GetEditArea
//STRIP001 /*?*/ 								if ( bBreak && pFmtDevice != pRefDevice && !bAsianVertical )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	calculate PaperSize for automatic line breaks from logic size,
//STRIP001 /*?*/ 									//	not pixel sizes, to get the same breaks at all scales
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									if ( eOrient == SVX_ORIENTATION_STANDARD )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										Fraction aFract(1,1);
//STRIP001 /*?*/ 										Rectangle aUtilRect = ScEditUtil( pDoc,nX,nY,nTab,
//STRIP001 /*?*/ 																Point(nStartX,nStartY), pDev,
//STRIP001 /*?*/ 																HMM_PER_TWIPS, HMM_PER_TWIPS, aFract, aFract )
//STRIP001 /*?*/ 															.GetEditArea( pPattern, FALSE );
//STRIP001 /*?*/ 										Size aLogic = aUtilRect.GetSize();
//STRIP001 /*?*/ 										pEngine->SetPaperSize( aLogic );
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									else
//STRIP001 /*?*/ 										pEngine->SetPaperSize( lcl_GetVertPaperSize(pDoc,nX,nY,nTab) );
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									pEngine->SetPaperSize(pRefDevice->PixelToLogic(aPaperSize));
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								pEngine->SetPaperSize(aPaperSize);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							//	Read content from cell
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							BOOL bWrapFields = FALSE;
//STRIP001 /*?*/ 							if (pCell)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								if (pCell->GetCellType() == CELLTYPE_EDIT)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									const EditTextObject* pData;
//STRIP001 /*?*/ 									((ScEditCell*)pCell)->GetData(pData);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									if (pData)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										pEngine->SetText(*pData);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										if ( bBreak && !bAsianVertical && pData->HasField() )
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											//	Fields aren't wrapped, so clipping is enabled to prevent
//STRIP001 /*?*/ 											//	a field from being drawn beyond the cell size
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											bWrapFields = TRUE;
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									else
//STRIP001 /*?*/ 										DBG_ERROR("pData == 0");
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									ULONG nFormat = pPattern->GetNumberFormat(
//STRIP001 /*?*/ 																pFormatter, pCondSet );
//STRIP001 /*?*/ 									String aString;
//STRIP001 /*?*/ 									Color* pColor;
//STRIP001 /*?*/ 									ScCellFormat::GetString( pCell,
//STRIP001 /*?*/ 															 nFormat,aString, &pColor,
//STRIP001 /*?*/ 															 *pFormatter,
//STRIP001 /*?*/ 															 bShowNullValues,
//STRIP001 /*?*/ 															 bShowFormulas,
//STRIP001 /*?*/ 															 ftCheck );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									pEngine->SetText(aString);
//STRIP001 /*?*/ 									if ( pColor && !bSyntaxMode && !( bUseStyleColor && bForceAutoColor ) )
//STRIP001 /*?*/ 										lcl_SetEditColor( *pEngine, *pColor );
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( bSyntaxMode )
//STRIP001 /*?*/ 									SetEditSyntaxColor( *pEngine, pCell );
//STRIP001 /*?*/ 								else if ( bUseStyleColor && bForceAutoColor )
//STRIP001 /*?*/ 									lcl_SetEditColor( *pEngine, COL_AUTO );		//! or have a flag at EditEngine
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								DBG_ERROR("pCell == NULL");
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							pEngine->SetVertical( bAsianVertical );
//STRIP001 /*?*/ 							pEngine->SetUpdateMode( TRUE );		// after SetText, before CalcTextWidth/GetTextHeight
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							long nEngineWidth;
//STRIP001 /*?*/ 							if ( bBreak && eOrient != SVX_ORIENTATION_STACKED && !bAsianVertical )
//STRIP001 /*?*/ 								nEngineWidth = 0;
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								nEngineWidth = (long) pEngine->CalcTextWidth();
//STRIP001 /*?*/ 							long nEngineHeight = pEngine->GetTextHeight();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (eOrient != SVX_ORIENTATION_STANDARD &&
//STRIP001 /*?*/ 								eOrient != SVX_ORIENTATION_STACKED)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								long nTemp = nEngineWidth;
//STRIP001 /*?*/ 								nEngineWidth = nEngineHeight;
//STRIP001 /*?*/ 								nEngineHeight = nTemp;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (eOrient == SVX_ORIENTATION_STACKED)
//STRIP001 /*?*/ 								nEngineWidth = nEngineWidth * 11 / 10;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (nX<nX1 && !bMerged)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								long nEnginePixel = bPixelToLogic ?
//STRIP001 /*?*/ 										pRefDevice->LogicToPixel(Size(nEngineWidth,0)).Width() :
//STRIP001 /*?*/ 										nEngineWidth;
//STRIP001 /*?*/ 								if ( nStartX + nEnginePixel < (long) nScrX )
//STRIP001 /*?*/ 									bHidden = TRUE;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (!bHidden)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								BOOL bExtend = FALSE;			// ueber Zellenrand geschrieben ?
//STRIP001 /*?*/ 								BOOL bClip = bMergeClip;		// clip to draw only part of merged cell
//STRIP001 /*?*/ 								CellInfo* pClipRight = NULL;	// Zelle mit Clipping-Markierung
//STRIP001 /*?*/ 								BOOL bSimClip = FALSE;
//STRIP001 /*?*/ 								Size aClipSize = Size( nScrX+nScrW-nStartX, nScrY+nScrH-nStartY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( bWrapFields )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	Fields in a cell with automatic breaks: clip to cell width
//STRIP001 /*?*/ 									bClip = TRUE;
//STRIP001 /*?*/ 									aClipSize.Width() = nOutWidth;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								//	Zelle, an der Clipping-Markierung gesetzt wird, wenn
//STRIP001 /*?*/ 								//	vertikal zu klein
//STRIP001 /*?*/ 								CellInfo* pEndInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								//	weiterschreiben
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								Size aCellSize;
//STRIP001 /*?*/ 								if (bPixelToLogic)
//STRIP001 /*?*/ 									aCellSize = pRefDevice->PixelToLogic( Size( nOutWidth, nOutHeight ) );
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									aCellSize = Size( nOutWidth, nOutHeight );
//STRIP001 /*?*/ 								if ( bIsValue )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if ( nEngineWidth > aCellSize.Width() )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										pEngine->SetText( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("###")) );
//STRIP001 /*?*/ 										//if ( bSyntaxMode )
//STRIP001 /*?*/ 										//	SetEditSyntaxColor( *pEngine, pCell );
//STRIP001 /*?*/ 										nEngineWidth = (long) pEngine->CalcTextWidth();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										if ( nEngineWidth > aCellSize.Width() )		// still too big?
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											// handle clipping like for text (may also be a merged cell)
//STRIP001 /*?*/ 											bExtend = TRUE;
//STRIP001 /*?*/ 											bClip = TRUE;
//STRIP001 /*?*/ 											aClipSize.Width() = nOutWidth;
//STRIP001 /*?*/ 											USHORT nClipX = ( nX < nX1 ) ? nX1 : nX;
//STRIP001 /*?*/ 											pClipRight = &pRowInfo[nArrY ? nArrY : 1].pCellInfo[nClipX+1];
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else if ( !bBreak || eOrient!=SVX_ORIENTATION_STANDARD || bAsianVertical )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if ( eOrient == SVX_ORIENTATION_STANDARD && !bMerged )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										USHORT nNextX = nX + 1;
//STRIP001 /*?*/ 										BOOL bCont = TRUE;
//STRIP001 /*?*/ 										while (bCont)
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											BOOL bMayCont =
//STRIP001 /*?*/ 													pThisRowInfo->pCellInfo[nNextX+1].bEmptyCellText &&
//STRIP001 /*?*/ 													!pThisRowInfo->pCellInfo[nNextX+1].bMerged &&
//STRIP001 /*?*/ 													!pThisRowInfo->pCellInfo[nNextX+1].bHOverlapped &&
//STRIP001 /*?*/ 													!pThisRowInfo->pCellInfo[nNextX+1].bVOverlapped;
//STRIP001 /*?*/ 											bCont = bMayCont && (nNextX<=nX2);
//STRIP001 /*?*/ 											if ( bEditMode && nNextX==nEditCol && nY==nEditRow )
//STRIP001 /*?*/ 												bCont = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											//	Grid (fuer nNextX-1) abschalten
//STRIP001 /*?*/ 											//
//STRIP001 /*?*/ 											if ( nEngineWidth > aCellSize.Width() )
//STRIP001 /*?*/ 											{
//STRIP001 /*?*/ 												if (bMayCont)
//STRIP001 /*?*/ 												{
//STRIP001 /*?*/ 													pThisRowInfo->pCellInfo[nNextX].bHideGrid = TRUE;
//STRIP001 /*?*/ 													pEndInfo = &pThisRowInfo->pCellInfo[nNextX+1];
//STRIP001 /*?*/ 												}
//STRIP001 /*?*/ 												else
//STRIP001 /*?*/ 													pClipRight = &pThisRowInfo->pCellInfo[nNextX];
//STRIP001 /*?*/ 													// auf "Hindernis" gestossen
//STRIP001 /*?*/ 											}
//STRIP001 /*?*/ 											else
//STRIP001 /*?*/ 												bCont = FALSE;	// #55142# bExtend nicht zu oft
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											if (bCont)
//STRIP001 /*?*/ 											{
//STRIP001 /*?*/ 												long nAdd = pRowInfo[0].pCellInfo[nNextX+1].nWidth;
//STRIP001 /*?*/ 												aCellRect.Right() += nAdd;
//STRIP001 /*?*/ 												nOutWidth += nAdd;
//STRIP001 /*?*/ 												if (bPixelToLogic)
//STRIP001 /*?*/ 													aCellSize = pRefDevice->PixelToLogic( Size( nOutWidth, nOutHeight ) );
//STRIP001 /*?*/ 												else
//STRIP001 /*?*/ 													aCellSize = Size( nOutWidth, nOutHeight );
//STRIP001 /*?*/ 												bExtend = TRUE;
//STRIP001 /*?*/ 											}
//STRIP001 /*?*/ 											++nNextX;
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									if ( nEngineWidth > aCellSize.Width() )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										bExtend = TRUE;		// -> immer linksbuendig
//STRIP001 /*?*/ 										bClip = TRUE;
//STRIP001 /*?*/ 										aClipSize.Width() = nOutWidth;		// Pixel
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										if ( bMerged )		// otherwise it's handled above
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											//	anywhere in the merged area...
//STRIP001 /*?*/ 											USHORT nClipX = ( nX < nX1 ) ? nX1 : nX;
//STRIP001 /*?*/ 											pClipRight = &pRowInfo[nArrY ? nArrY : 1].pCellInfo[nClipX+1];
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								if ( nEngineHeight > aCellSize.Height() )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	kein vertikales Clipping beim Drucken von Zellen mit
//STRIP001 /*?*/ 									//	optimaler Hoehe, ausser bei Groesse in bedingter
//STRIP001 /*?*/ 									//	Formatierung
//STRIP001 /*?*/ 									if ( eType != OUTTYPE_PRINTER ||
//STRIP001 /*?*/ 										( pDoc->GetRowFlags( nY, nTab ) & CR_MANUALSIZE ) ||
//STRIP001 /*?*/ 										( pCondSet && SFX_ITEM_SET ==
//STRIP001 /*?*/ 											pCondSet->GetItemState(ATTR_FONT_HEIGHT, TRUE) ) )
//STRIP001 /*?*/ 										bClip = TRUE;
//STRIP001 /*?*/ 									else
//STRIP001 /*?*/ 										bSimClip = TRUE;
//STRIP001 /*?*/ 									aClipSize.Height() = nOutHeight;		// Pixel
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									//	Show clip marks if height is at least 5pt too small and
//STRIP001 /*?*/ 									//	there are several lines of text.
//STRIP001 /*?*/ 									//	Not for asian vertical text, because that would interfere
//STRIP001 /*?*/ 									//	with the default right position of the text.
//STRIP001 /*?*/ 									if ( nEngineHeight - aCellSize.Height() > 100 && !bAsianVertical &&
//STRIP001 /*?*/ 										 ( pEngine->GetParagraphCount() > 1 ||
//STRIP001 /*?*/ 										   pEngine->GetLineCount(0) > 1 ) )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										if ( bMerged )
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											//	anywhere in the merged area...
//STRIP001 /*?*/ 											USHORT nClipX = ( nX < nX1 ) ? nX1 : nX;
//STRIP001 /*?*/ 											pClipRight = &pRowInfo[nArrY ? nArrY : 1].pCellInfo[nClipX+1];
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 											pClipRight = pEndInfo;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								long nClipStartX = nStartX;
//STRIP001 /*?*/ 								if (nX<nX1)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//! Clipping unnoetig, wenn links am Fenster
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									bClip = TRUE;					// nur Rest ausgeben!
//STRIP001 /*?*/ 									if (nStartX<nScrX)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										long nDif = nScrX - nStartX;
//STRIP001 /*?*/ 										nClipStartX = nScrX;
//STRIP001 /*?*/ 										aClipSize.Width() -= nDif;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								long nClipStartY = nStartY;
//STRIP001 /*?*/ 								if (nArrY==0 || bVisChanged)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if ( nClipStartY < nRowPosY )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										long nDif = nRowPosY - nClipStartY;
//STRIP001 /*?*/ 										bClip = TRUE;
//STRIP001 /*?*/ 										nClipStartY = nRowPosY;
//STRIP001 /*?*/ 										aClipSize.Height() -= nDif;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								Rectangle aClipRect;
//STRIP001 /*?*/ 								if (bClip || bSimClip)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if ( pClipRight && bMarkClipped )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										//	rechts markieren
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										pClipRight->bStandard = TRUE;	//!	umbenennen in bClipped
//STRIP001 /*?*/ 										bAnyClipped = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										long nMarkPixel = (long)( SC_CLIPMARK_SIZE * nPPTX );
//STRIP001 /*?*/ 										long nMarkLeft = aCellRect.Right()-nMarkPixel+1;
//STRIP001 /*?*/ 										long nClipEnd = nClipStartX + aClipSize.Width();
//STRIP001 /*?*/ 										if (nClipEnd > nMarkLeft)
//STRIP001 /*?*/ 											aClipSize.Width() -= nClipEnd - nMarkLeft;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									if (bPixelToLogic)
//STRIP001 /*?*/ 										aClipRect = pRefDevice->PixelToLogic( Rectangle(
//STRIP001 /*?*/ 														Point(nClipStartX,nClipStartY), aClipSize ) );
//STRIP001 /*?*/ 									else
//STRIP001 /*?*/ 										aClipRect = Rectangle(Point(nClipStartX, nClipStartY), aClipSize);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ #if 0
//STRIP001 /*?*/ 									//! Test
//STRIP001 /*?*/ 									if ( pDev->GetOutDevType() != OUTDEV_PRINTER )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										pDev->SetPen(PEN_NULL);
//STRIP001 /*?*/ 										if (bClip)
//STRIP001 /*?*/ 											pDev->SetFillInBrush(Brush(Color(COL_LIGHTGREEN)));
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 											pDev->SetFillInBrush(Brush(Color(COL_LIGHTRED)));
//STRIP001 /*?*/ 										pDev->DrawRect( aClipRect );
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									//! Test
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									if (bClip)	// bei bSimClip nur aClipRect initialisieren
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										if (bMetaFile)
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											pDev->Push();
//STRIP001 /*?*/ 											pDev->IntersectClipRegion( aClipRect );
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 											pDev->SetClipRegion( Region( aClipRect ) );
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								Point aLogicStart;
//STRIP001 /*?*/ 								if (bPixelToLogic)
//STRIP001 /*?*/ 									aLogicStart = pRefDevice->PixelToLogic( Point(nStartX,nStartY) );
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 									aLogicStart = Point(nStartX, nStartY);
//STRIP001 /*?*/ 								if ( (eOrient!=SVX_ORIENTATION_STANDARD || bAsianVertical || !bBreak) && !bExtend )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									long nAvailWidth = aCellSize.Width();
//STRIP001 /*?*/ 									if (eType==OUTTYPE_WINDOW &&
//STRIP001 /*?*/ 											eOrient!=SVX_ORIENTATION_STACKED &&
//STRIP001 /*?*/ 											pInfo && pInfo->bAutoFilter)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										USHORT nSub = Min( pRowInfo[nArrY].nHeight,
//STRIP001 /*?*/ 															(USHORT) DROPDOWN_BITMAP_SIZE );
//STRIP001 /*?*/ 										if (bPixelToLogic)
//STRIP001 /*?*/ 											nAvailWidth -= pRefDevice->PixelToLogic(Size(0,nSub)).Height();
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 											nAvailWidth -= nSub;
//STRIP001 /*?*/ 										if (nAvailWidth < nEngineWidth) nAvailWidth = nEngineWidth;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										nOutWidth -= nSub;
//STRIP001 /*?*/ 										long nEnginePixel = bPixelToLogic ?
//STRIP001 /*?*/ 												pRefDevice->LogicToPixel(Size(nEngineWidth,0)).Width() :
//STRIP001 /*?*/ 												nEngineWidth;
//STRIP001 /*?*/ 										if (nOutWidth <= nEnginePixel) nOutWidth = nEnginePixel+1;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									//	horizontale Ausrichtung
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									if (eOrient==SVX_ORIENTATION_STANDARD && !bAsianVertical)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										if (eHorJust==SVX_HOR_JUSTIFY_RIGHT ||
//STRIP001 /*?*/ 											eHorJust==SVX_HOR_JUSTIFY_CENTER ||
//STRIP001 /*?*/ 											(eHorJust==SVX_HOR_JUSTIFY_STANDARD && bIsValue) )
//STRIP001 /*?*/ 										{
//STRIP001 /*?*/ 											pEngine->SetUpdateMode( FALSE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											SvxAdjust eSvxAdjust =
//STRIP001 /*?*/ 												(eHorJust==SVX_HOR_JUSTIFY_CENTER) ?
//STRIP001 /*?*/ 													SVX_ADJUST_CENTER : SVX_ADJUST_RIGHT;
//STRIP001 /*?*/ 											pEngine->SetDefaultItem(
//STRIP001 /*?*/ 												SvxAdjustItem( eSvxAdjust, EE_PARA_JUST ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											// #55142# Adjustment fuer naechste Zelle wieder zurueck
//STRIP001 /*?*/ 											pOldPattern = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											aPaperSize.Width() = nOutWidth;
//STRIP001 /*?*/ 											if (bPixelToLogic)
//STRIP001 /*?*/ 												pEngine->SetPaperSize(pRefDevice->PixelToLogic(aPaperSize));
//STRIP001 /*?*/ 											else
//STRIP001 /*?*/ 												pEngine->SetPaperSize(aPaperSize);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											pEngine->SetUpdateMode( TRUE );
//STRIP001 /*?*/ 										}
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									else
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										if (eHorJust==SVX_HOR_JUSTIFY_RIGHT)
//STRIP001 /*?*/ 											aLogicStart.X() += nAvailWidth - nEngineWidth;
//STRIP001 /*?*/ 										else if (eHorJust==SVX_HOR_JUSTIFY_CENTER)
//STRIP001 /*?*/ 											aLogicStart.X() += (nAvailWidth - nEngineWidth) / 2;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( bAsianVertical )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									// paper size is subtracted below (with or without bExtend)
//STRIP001 /*?*/ 									aLogicStart.X() += nEngineWidth;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( ( eOrient==SVX_ORIENTATION_STANDARD && !bAsianVertical ) ||
//STRIP001 /*?*/ 									 eOrient==SVX_ORIENTATION_STACKED || !bBreak )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if (eVerJust==SVX_VER_JUSTIFY_BOTTOM ||
//STRIP001 /*?*/ 										eVerJust==SVX_VER_JUSTIFY_STANDARD)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										// if pRefDevice != pFmtDevice, stick with logic units
//STRIP001 /*?*/ 										if (bPixelToLogic && pRefDevice == pFmtDevice)
//STRIP001 /*?*/ 											aLogicStart.Y() += pRefDevice->PixelToLogic( Size(0,
//STRIP001 /*?*/ 															pRefDevice->LogicToPixel(aCellSize).Height() -
//STRIP001 /*?*/ 															pRefDevice->LogicToPixel(Size(0,nEngineHeight)).Height()
//STRIP001 /*?*/ 															)).Height();
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 											aLogicStart.Y() += aCellSize.Height() - nEngineHeight;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									else if (eVerJust==SVX_VER_JUSTIFY_CENTER)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										if (bPixelToLogic)
//STRIP001 /*?*/ 											aLogicStart.Y() += pRefDevice->PixelToLogic( Size(0,(
//STRIP001 /*?*/ 															pRefDevice->LogicToPixel(aCellSize).Height() -
//STRIP001 /*?*/ 															pRefDevice->LogicToPixel(Size(0,nEngineHeight)).Height())
//STRIP001 /*?*/ 															/ 2)).Height();
//STRIP001 /*?*/ 										else
//STRIP001 /*?*/ 											aLogicStart.Y() += (aCellSize.Height() - nEngineHeight) / 2;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								short nOriVal = 0;
//STRIP001 /*?*/ 								if (eOrient==SVX_ORIENTATION_TOPBOTTOM)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									// nOriVal = -900;
//STRIP001 /*?*/ 									nOriVal = 2700;
//STRIP001 /*?*/ 									aLogicStart.X() += nEngineWidth;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else if (eOrient==SVX_ORIENTATION_BOTTOMTOP)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									nOriVal = 900;
//STRIP001 /*?*/ 									aLogicStart.Y() += bBreak ? aCellSize.Height() :
//STRIP001 /*?*/ 																nEngineHeight;
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else if (eOrient==SVX_ORIENTATION_STACKED)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									Size aPaperLogic = pEngine->GetPaperSize();
//STRIP001 /*?*/ 									aPaperLogic.Width() = nEngineWidth;
//STRIP001 /*?*/ 									pEngine->SetPaperSize(aPaperLogic);
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*M*/ 								if ( pEngine->IsRightToLeft( 0 ) )
//STRIP001 /*M*/ 								{
//STRIP001 /*M*/ 									//	For right-to-left, EditEngine always calculates its lines
//STRIP001 /*M*/ 									//	beginning from the right edge, but EditLine::nStartPosX is
//STRIP001 /*M*/ 									//	of USHORT type, so the PaperSize must be limited to USHRT_MAX.
//STRIP001 /*M*/ 									Size aLogicPaper = pEngine->GetPaperSize();
//STRIP001 /*M*/ 									if ( aLogicPaper.Width() > USHRT_MAX )
//STRIP001 /*M*/ 									{
//STRIP001 /*M*/ 										aLogicPaper.Width() = USHRT_MAX;
//STRIP001 /*M*/ 										pEngine->SetPaperSize(aLogicPaper);
//STRIP001 /*M*/ 									}
//STRIP001 /*M*/ 								}
//STRIP001 /*M*/ 
//STRIP001 /*?*/ 								BOOL bMoveClipped = FALSE;
//STRIP001 /*?*/ 								if ( bExtend )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									SvxFrameDirection eCellDir = (SvxFrameDirection)((const SvxFrameDirectionItem&)
//STRIP001 /*?*/ 											pPattern->GetItem( ATTR_WRITINGDIR, pCondSet )).GetValue();
//STRIP001 /*?*/ 									bMoveClipped = ( eCellDir == FRMDIR_HORI_RIGHT_TOP ||
//STRIP001 /*?*/ 										( eCellDir == FRMDIR_ENVIRONMENT && nTabTextDirection == EE_HTEXTDIR_R2L ) );
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								if ( bMoveClipped )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	#i9731# if long text is clipped, and the cell is formatted as rtl,
//STRIP001 /*?*/ 									//	move the start position so the right end is visible
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									long nNeeded = bPixelToLogic ?
//STRIP001 /*?*/ 											pRefDevice->LogicToPixel(Size(nEngineWidth,0)).Width() :
//STRIP001 /*?*/ 											nEngineWidth;
//STRIP001 /*?*/ 									nNeeded += (long) ( (pMargin->GetLeftMargin() + nIndent) * nPPTX ) +
//STRIP001 /*?*/ 											   (long) ( pMargin->GetRightMargin() * nPPTX );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									long nAvailable = GetAvailableWidth( nX, nY, nNeeded );
//STRIP001 /*?*/ 									if ( nAvailable < nNeeded )
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										long nDiff = nNeeded - nAvailable;
//STRIP001 /*?*/ 										aLogicStart.X() -= bPixelToLogic ?
//STRIP001 /*?*/ 												pRefDevice->PixelToLogic(Size(nDiff,0)).Width() :
//STRIP001 /*?*/ 												nDiff;
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if ( bSimClip && !nOriVal && !bAsianVertical )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									//	kein hartes Clipping, aber nur die betroffenen
//STRIP001 /*?*/ 									//	Zeilen ausgeben
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 									Point aDocStart = aClipRect.TopLeft();
//STRIP001 /*?*/ 									aDocStart -= aLogicStart;
//STRIP001 /*?*/ 									pEngine->Draw( pDev, aClipRect, aDocStart, FALSE );
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 								else
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if (bAsianVertical)
//STRIP001 /*?*/ 									{
//STRIP001 /*?*/ 										//	with SetVertical, the start position is top left of
//STRIP001 /*?*/ 										//	the whole output area, not the text itself
//STRIP001 /*?*/ 										aLogicStart.X() -= pEngine->GetPaperSize().Width();
//STRIP001 /*?*/ 									}
//STRIP001 /*?*/ 									pEngine->Draw( pDev, aLogicStart, nOriVal );
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if (bClip)
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									if (bMetaFile)
//STRIP001 /*?*/ 										pDev->Pop();
//STRIP001 /*?*/ 									else
//STRIP001 /*?*/ 										pDev->SetClipRegion();
//STRIP001 /*?*/ 								}
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
/*?*/ 					}
/*N*/ 				}
/*N*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*N*/ 			}
/*N*/ 		}
/*N*/ 		nRowPosY += pRowInfo[nArrY].nHeight;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pEngine;
/*N*/ 
/*N*/ 	if (bAnyRotated)
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		DrawRotated(bPixelToLogic);		//! von aussen rufen ?
/*N*/ }

//	-------------------------------------------------------------------------------

//STRIP001 void ScOutputData::DrawRotated(BOOL bPixelToLogic)
//STRIP001 {
//STRIP001 	//!	nRotMax speichern
//STRIP001 	USHORT nRotMax = nX2;
//STRIP001 	for (USHORT nRotY=0; nRotY<nArrCount; nRotY++)
//STRIP001 		if (pRowInfo[nRotY].nRotMaxCol != SC_ROTMAX_NONE && pRowInfo[nRotY].nRotMaxCol > nRotMax)
//STRIP001 			nRotMax = pRowInfo[nRotY].nRotMaxCol;
//STRIP001 
//STRIP001 
//STRIP001 	SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001     sal_Int32 nConfBackColor = pScMod->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor;
//STRIP001 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
//STRIP001 	BOOL bCellContrast = bUseStyleColor &&
//STRIP001 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001 
//STRIP001 	ScFieldEditEngine* pEngine = NULL;
//STRIP001 	BOOL bHyphenatorSet = FALSE;
//STRIP001 	const ScPatternAttr* pPattern;
//STRIP001 	const SfxItemSet*	 pCondSet;
//STRIP001 	const ScPatternAttr* pOldPattern = NULL;
//STRIP001 	const SfxItemSet*	 pOldCondSet = NULL;
//STRIP001 	ScBaseCell* pCell = NULL;
//STRIP001 
//STRIP001 	long nRowPosY = nScrY;
//STRIP001 	for (USHORT nArrY=0; nArrY+1<nArrCount; nArrY++)			// 0 fuer Reste von zusammengefassten
//STRIP001 	{
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 		long nCellHeight = (long) pThisRowInfo->nHeight;
//STRIP001 		if (nArrY==1) nRowPosY = nScrY;							// vorher wird einzeln berechnet
//STRIP001 
//STRIP001 		if ( ( pThisRowInfo->bChanged || nArrY==0 ) && pThisRowInfo->nRotMaxCol != SC_ROTMAX_NONE )
//STRIP001 		{
//STRIP001 			long nPosX = 0;
//STRIP001 			for (USHORT nX=0; nX<=nRotMax; nX++)
//STRIP001 			{
//STRIP001 				if (nX==nX1) nPosX = nScrX;						// vorher wird einzeln berechnet
//STRIP001 
//STRIP001 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 				if ( pInfo->nRotateDir != SC_ROTDIR_NONE )
//STRIP001 				{
//STRIP001 					USHORT nY = pThisRowInfo->nRowNo;
//STRIP001 
//STRIP001 					BOOL bHidden = FALSE;
//STRIP001 					if (bEditMode)
//STRIP001 						if ( nX == nEditCol && nY == nEditRow )
//STRIP001 							bHidden = TRUE;
//STRIP001 
//STRIP001 					if (!bHidden)
//STRIP001 					{
//STRIP001 						if (!pEngine)
//STRIP001 						{
//STRIP001 							//	Ein RefDevice muss auf jeden Fall gesetzt werden,
//STRIP001 							//	sonst legt sich die EditEngine ein VirtualDevice an!
//STRIP001 							pEngine = new ScFieldEditEngine( pDoc->GetEnginePool() );
//STRIP001 							pEngine->SetUpdateMode( FALSE );
//STRIP001 							pEngine->SetRefDevice( pFmtDevice );	// always set
//STRIP001 							ULONG nCtrl = pEngine->GetControlWord();
//STRIP001 							if ( bShowSpellErrors )
//STRIP001 								nCtrl |= EE_CNTRL_ONLINESPELLING;
//STRIP001 							if ( eType == OUTTYPE_PRINTER )
//STRIP001 								nCtrl &= ~EE_CNTRL_MARKFIELDS;
//STRIP001 							pEngine->SetControlWord( nCtrl );
//STRIP001 							pEngine->SetForbiddenCharsTable( pDoc->GetForbiddenCharacters() );
//STRIP001 							pEngine->SetAsianCompressionMode( pDoc->GetAsianCompression() );
//STRIP001 							pEngine->SetKernAsianPunctuation( pDoc->GetAsianKerning() );
//STRIP001 							pEngine->EnableAutoColor( bUseStyleColor );
//STRIP001 							pEngine->SetDefaultHorizontalTextDirection(
//STRIP001 								(EEHorizontalTextDirection)pDoc->GetEditTextDirection( nTab ) );
//STRIP001 						}
//STRIP001 						else
//STRIP001 							lcl_ClearEdit( *pEngine );		// also calls SetUpdateMode(FALSE)
//STRIP001 
//STRIP001 						long nPosY = nRowPosY;
//STRIP001 						BOOL bVisChanged = FALSE;
//STRIP001 
//STRIP001 						//!	Rest von zusammengefasster Zelle weiter oben funktioniert nicht!
//STRIP001 
//STRIP001 						BOOL bFromDoc = FALSE;
//STRIP001 						pPattern = pInfo->pPatternAttr;
//STRIP001 						pCondSet = pInfo->pConditionSet;
//STRIP001 						if (!pPattern)
//STRIP001 						{
//STRIP001 							pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 							bFromDoc = TRUE;
//STRIP001 						}
//STRIP001 						pCell = pInfo->pCell;
//STRIP001 						if (bFromDoc)
//STRIP001 							pCondSet = pDoc->GetCondResult( nX, nY, nTab );
//STRIP001 
//STRIP001 						if (!pCell && nX>nX2)
//STRIP001 							GetVisibleCell( nX, nY, nTab, pCell );
//STRIP001 
//STRIP001 						if ( !pCell || IsEmptyCellText( pThisRowInfo, nX, nY ) )
//STRIP001 							bHidden = TRUE;		// nRotateDir is also set without a cell
//STRIP001 
//STRIP001 						long nCellWidth = (long) pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 
//STRIP001 						const SfxPoolItem* pCondItem;
//STRIP001 
//STRIP001 						SvxCellHorJustify eHorJust;
//STRIP001 						if ( pCondSet && pCondSet->GetItemState(
//STRIP001 									ATTR_HOR_JUSTIFY, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 							eHorJust = (SvxCellHorJustify) ((const SvxHorJustifyItem*)
//STRIP001 																pCondItem)->GetValue();
//STRIP001 						else
//STRIP001 							eHorJust = (SvxCellHorJustify)((const SvxHorJustifyItem&)pPattern->
//STRIP001 													GetItem(ATTR_HOR_JUSTIFY)).GetValue();
//STRIP001 
//STRIP001 						BOOL bBreak;
//STRIP001 						if ( eHorJust == SVX_HOR_JUSTIFY_BLOCK )
//STRIP001 							bBreak = TRUE;
//STRIP001 						else if ( pCondSet && pCondSet->GetItemState(
//STRIP001 									ATTR_LINEBREAK, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 							bBreak = ((const SfxBoolItem*)pCondItem)->GetValue();
//STRIP001 						else
//STRIP001 							bBreak = ((const SfxBoolItem&)pPattern->GetItem(ATTR_LINEBREAK)).GetValue();
//STRIP001 
//STRIP001 						SvxCellOrientation eOrient;
//STRIP001 						if ( pCondSet && pCondSet->GetItemState(
//STRIP001 									ATTR_ORIENTATION, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 							eOrient = (SvxCellOrientation)((const SvxOrientationItem*)
//STRIP001 											pCondItem)->GetValue();
//STRIP001 						else
//STRIP001 							eOrient = (SvxCellOrientation)((const SvxOrientationItem&)
//STRIP001 											pPattern->GetItem(ATTR_ORIENTATION)).GetValue();
//STRIP001 
//STRIP001 						const ScMergeAttr* pMerge =
//STRIP001 								(ScMergeAttr*)&pPattern->GetItem(ATTR_MERGE);
//STRIP001 						BOOL bMerged = pMerge->GetColMerge() > 1 || pMerge->GetRowMerge() > 1;
//STRIP001 
//STRIP001 						long nStartX = nPosX;
//STRIP001 						long nStartY = nPosY;
//STRIP001 						if (nX<nX1)
//STRIP001 						{
//STRIP001 							if ((bBreak || eOrient!=SVX_ORIENTATION_STANDARD) && !bMerged)
//STRIP001 								bHidden = TRUE;
//STRIP001 							else
//STRIP001 							{
//STRIP001 								nStartX = nScrX;
//STRIP001 								USHORT nCol = nX1;
//STRIP001 								while (nCol > nX)
//STRIP001 								{
//STRIP001 									--nCol;
//STRIP001 									nStartX -= (long) pRowInfo[0].pCellInfo[nCol+1].nWidth;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						//	Ersatzdarstellung fuer zu kleinen Text weggelassen
//STRIP001 
//STRIP001 						if (!bHidden)
//STRIP001 						{
//STRIP001 							long nOutWidth = nCellWidth - 1;
//STRIP001 							long nOutHeight;
//STRIP001 							if (pInfo)
//STRIP001 								nOutHeight = nCellHeight;
//STRIP001 							else
//STRIP001 								nOutHeight = (long) ( pDoc->GetRowHeight(nY,nTab) * nPPTY );
//STRIP001 
//STRIP001 							if ( bMerged )								// Zusammengefasst
//STRIP001 							{
//STRIP001 								USHORT i;
//STRIP001 								const ScMergeAttr* pMerge =
//STRIP001 										(ScMergeAttr*)&pPattern->GetItem(ATTR_MERGE);
//STRIP001 								USHORT nCountX = pMerge->GetColMerge();
//STRIP001 								for (i=1; i<nCountX; i++)
//STRIP001 									nOutWidth += (long) ( pDoc->GetColWidth(nX+i,nTab) * nPPTX );
//STRIP001 								USHORT nCountY = pMerge->GetRowMerge();
//STRIP001 								for (i=1; i<nCountY; i++)
//STRIP001 									nOutHeight += (long) ( pDoc->GetRowHeight(nY+i,nTab) * nPPTY );
//STRIP001 							}
//STRIP001 
//STRIP001 							SvxCellVerJustify eVerJust;
//STRIP001 							if ( pCondSet && pCondSet->GetItemState(
//STRIP001 										ATTR_VER_JUSTIFY, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 								eVerJust = (SvxCellVerJustify) ((const SvxVerJustifyItem*)
//STRIP001 																	pCondItem)->GetValue();
//STRIP001 							else
//STRIP001 								eVerJust = (SvxCellVerJustify)((const SvxVerJustifyItem&)pPattern->
//STRIP001 														GetItem(ATTR_VER_JUSTIFY)).GetValue();
//STRIP001 
//STRIP001 							// Syntax-Modus wird hier ignoriert...
//STRIP001 
//STRIP001 							// StringDiffer doesn't look at hyphenate, language items
//STRIP001 							if ( pPattern != pOldPattern || pCondSet != pOldCondSet )
//STRIP001 							{
//STRIP001 								SfxItemSet* pSet = new SfxItemSet( pEngine->GetEmptyItemSet() );
//STRIP001 								pPattern->FillEditItemSet( pSet, pCondSet );
//STRIP001 
//STRIP001 																	// Ausrichtung fuer EditEngine
//STRIP001 								SvxAdjust eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 								if (eOrient==SVX_ORIENTATION_STACKED)
//STRIP001 									eSvxAdjust = SVX_ADJUST_CENTER;
//STRIP001 								// Adjustment fuer bBreak ist hier weggelassen
//STRIP001 								pSet->Put( SvxAdjustItem( eSvxAdjust, EE_PARA_JUST ) );
//STRIP001 
//STRIP001 								pEngine->SetDefaults( pSet );
//STRIP001 								pOldPattern = pPattern;
//STRIP001 								pOldCondSet = pCondSet;
//STRIP001 
//STRIP001 								ULONG nControl = pEngine->GetControlWord();
//STRIP001 								if (eOrient==SVX_ORIENTATION_STACKED)
//STRIP001 									nControl |= EE_CNTRL_ONECHARPERLINE;
//STRIP001 								else
//STRIP001 									nControl &= ~EE_CNTRL_ONECHARPERLINE;
//STRIP001 								pEngine->SetControlWord( nControl );
//STRIP001 
//STRIP001 								if ( !bHyphenatorSet && ((const SfxBoolItem&)pSet->Get(EE_PARA_HYPHENATE)).GetValue() )
//STRIP001 								{
//STRIP001 									//	set hyphenator the first time it is needed
//STRIP001                                     ::com::sun::star::uno::Reference< ::com::sun::star::linguistic2::XHyphenator> xXHyphenator( LinguMgr::GetHyphenator() );
//STRIP001 									pEngine->SetHyphenator( xXHyphenator );
//STRIP001 									bHyphenatorSet = TRUE;
//STRIP001 								}
//STRIP001 
//STRIP001 								Color aBackCol = ((const SvxBrushItem&)
//STRIP001 									pPattern->GetItem( ATTR_BACKGROUND, pCondSet )).GetColor();
//STRIP001 								if ( bUseStyleColor && ( aBackCol.GetTransparency() > 0 || bCellContrast ) )
//STRIP001 									aBackCol.SetColor( nConfBackColor );
//STRIP001 								pEngine->SetBackgroundColor( aBackCol );
//STRIP001 							}
//STRIP001 
//STRIP001 							//	Raender
//STRIP001 
//STRIP001 							//!		Position und Papersize auf EditUtil umstellen !!!
//STRIP001 
//STRIP001 							const SvxMarginItem* pMargin;
//STRIP001 							if ( pCondSet && pCondSet->GetItemState(
//STRIP001 										ATTR_MARGIN, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 								pMargin = (const SvxMarginItem*)pCondItem;
//STRIP001 							else
//STRIP001 								pMargin = (const SvxMarginItem*)&pPattern->GetItem(ATTR_MARGIN);
//STRIP001 							USHORT nIndent = 0;
//STRIP001 							if ( eHorJust == SVX_HOR_JUSTIFY_LEFT )
//STRIP001 							{
//STRIP001 								if ( pCondSet && pCondSet->GetItemState(
//STRIP001 											ATTR_INDENT, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 									nIndent = ((const SfxUInt16Item*)pCondItem)->GetValue();
//STRIP001 								else
//STRIP001 									nIndent = ((const SfxUInt16Item&)pPattern->
//STRIP001 													GetItem(ATTR_INDENT)).GetValue();
//STRIP001 							}
//STRIP001 
//STRIP001 							long nTotalHeight = nOutHeight;	// ohne Rand abzuziehen
//STRIP001 							if ( bPixelToLogic )
//STRIP001 								nTotalHeight = pRefDevice->PixelToLogic(Size(0,nTotalHeight)).Height();
//STRIP001 
//STRIP001 							long nLeftM = (long) ( (pMargin->GetLeftMargin() + nIndent) * nPPTX );
//STRIP001 							long nTopM  = (long) ( pMargin->GetTopMargin() * nPPTY );
//STRIP001 							nStartX += nLeftM;
//STRIP001 							nStartY += nTopM;
//STRIP001 							nOutWidth -= nLeftM + (long) ( pMargin->GetRightMargin() * nPPTX );
//STRIP001 							nOutHeight -= nTopM + (long) ( pMargin->GetBottomMargin() * nPPTY );
//STRIP001 
//STRIP001 							//	Rotation schon hier, um bei Umbruch auch PaperSize anzupassen
//STRIP001 							long nAttrRotate = 0;
//STRIP001 							double nSin = 0.0;
//STRIP001 							double nCos = 1.0;
//STRIP001 							SvxRotateMode eRotMode = SVX_ROTATE_MODE_STANDARD;
//STRIP001 							if ( eOrient == SVX_ORIENTATION_STANDARD )
//STRIP001 							{
//STRIP001 								if ( pCondSet && pCondSet->GetItemState(
//STRIP001 											ATTR_ROTATE_VALUE, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 									nAttrRotate = ((const SfxInt32Item*)pCondItem)->GetValue();
//STRIP001 								else
//STRIP001 									nAttrRotate = ((const SfxInt32Item&)pPattern->
//STRIP001 													GetItem(ATTR_ROTATE_VALUE)).GetValue();
//STRIP001 								if ( nAttrRotate )
//STRIP001 								{
//STRIP001 									if ( pCondSet && pCondSet->GetItemState(
//STRIP001 											ATTR_ROTATE_MODE, TRUE, &pCondItem ) == SFX_ITEM_SET )
//STRIP001 										eRotMode = (SvxRotateMode)((const SvxRotateModeItem*)
//STRIP001 												pCondItem)->GetValue();
//STRIP001 									else
//STRIP001 										eRotMode = (SvxRotateMode)((const SvxRotateModeItem&)
//STRIP001 												pPattern->GetItem(ATTR_ROTATE_MODE)).GetValue();
//STRIP001 
//STRIP001 									if ( nAttrRotate == 18000 )
//STRIP001 										eRotMode = SVX_ROTATE_MODE_STANDARD;	// keinen Ueberlauf
//STRIP001 
//STRIP001 									double nRealOrient = nAttrRotate * F_PI18000;	// 1/100 Grad
//STRIP001 									nCos = cos( nRealOrient );
//STRIP001 									nSin = sin( nRealOrient );
//STRIP001 								}
//STRIP001 							}
//STRIP001 
//STRIP001 							Size aPaperSize = Size( 1000000, 1000000 );
//STRIP001 							if (eOrient==SVX_ORIENTATION_STACKED)
//STRIP001 								aPaperSize.Width() = nOutWidth;				// zum Zentrieren
//STRIP001 							else if (bBreak)
//STRIP001 							{
//STRIP001 								if (nAttrRotate)
//STRIP001 								{
//STRIP001 									//!	richtige PaperSize fuer Umbruch haengt von der Zeilenzahl
//STRIP001 									//!	ab, solange die Zeilen nicht einzeln versetzt ausgegeben
//STRIP001 									//!	werden koennen -> darum unbegrenzt, also kein Umbruch.
//STRIP001 									//!	Mit versetzten Zeilen waere das folgende richtig:
//STRIP001 									aPaperSize.Width() = (long)(nOutHeight / fabs(nSin));
//STRIP001 								}
//STRIP001 								else if (eOrient == SVX_ORIENTATION_STANDARD)
//STRIP001 									aPaperSize.Width() = nOutWidth;
//STRIP001 								else
//STRIP001 									aPaperSize.Width() = nOutHeight - 1;
//STRIP001 							}
//STRIP001 							if (bPixelToLogic)
//STRIP001 								pEngine->SetPaperSize(pRefDevice->PixelToLogic(aPaperSize));
//STRIP001 							else
//STRIP001 								pEngine->SetPaperSize(aPaperSize);	// Scale ist immer 1
//STRIP001 
//STRIP001 							//	Daten aus Zelle lesen
//STRIP001 
//STRIP001 							if (pCell)
//STRIP001 							{
//STRIP001 								if (pCell->GetCellType() == CELLTYPE_EDIT)
//STRIP001 								{
//STRIP001 									const EditTextObject* pData;
//STRIP001 									((ScEditCell*)pCell)->GetData(pData);
//STRIP001 
//STRIP001 									if (pData)
//STRIP001 										pEngine->SetText(*pData);
//STRIP001 									else
//STRIP001 										DBG_ERROR("pData == 0");
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									ULONG nFormat = pPattern->GetNumberFormat(
//STRIP001 																pFormatter, pCondSet );
//STRIP001 									String aString;
//STRIP001 									Color* pColor;
//STRIP001 									ScCellFormat::GetString( pCell,
//STRIP001 															 nFormat,aString, &pColor,
//STRIP001 															 *pFormatter,
//STRIP001 															 bShowNullValues,
//STRIP001 															 bShowFormulas,
//STRIP001 															 ftCheck );
//STRIP001 
//STRIP001 									pEngine->SetText(aString);
//STRIP001 									if ( pColor && !bSyntaxMode && !( bUseStyleColor && bForceAutoColor ) )
//STRIP001 										lcl_SetEditColor( *pEngine, *pColor );
//STRIP001 								}
//STRIP001 
//STRIP001 								if ( bSyntaxMode )
//STRIP001 									SetEditSyntaxColor( *pEngine, pCell );
//STRIP001 								else if ( bUseStyleColor && bForceAutoColor )
//STRIP001 									lcl_SetEditColor( *pEngine, COL_AUTO );		//! or have a flag at EditEngine
//STRIP001 							}
//STRIP001 							else
//STRIP001 								DBG_ERROR("pCell == NULL");
//STRIP001 
//STRIP001 							pEngine->SetUpdateMode( TRUE );		// after SetText, before CalcTextWidth/GetTextHeight
//STRIP001 
//STRIP001 							long nEngineWidth  = (long) pEngine->CalcTextWidth();
//STRIP001 							long nEngineHeight = pEngine->GetTextHeight();
//STRIP001 
//STRIP001 							if (nAttrRotate && bBreak)
//STRIP001 							{
//STRIP001 								double nAbsCos = fabs( nCos );
//STRIP001 								double nAbsSin = fabs( nSin );
//STRIP001 
//STRIP001 								// #47740# adjust witdh of papersize for height of text
//STRIP001 								int nSteps = 5;
//STRIP001 								while (nSteps > 0)
//STRIP001 								{
//STRIP001 									// everything is in pixels
//STRIP001 									long nEnginePixel = pRefDevice->LogicToPixel(
//STRIP001 															Size(0,nEngineHeight)).Height();
//STRIP001 									long nEffHeight = nOutHeight - (long)(nEnginePixel * nAbsCos) + 2;
//STRIP001 									long nNewWidth = (long)(nEffHeight / nAbsSin) + 2;
//STRIP001 									BOOL bFits = ( nNewWidth >= aPaperSize.Width() );
//STRIP001 									if ( bFits )
//STRIP001 										nSteps = 0;
//STRIP001 									else
//STRIP001 									{
//STRIP001 										if ( nNewWidth < 4 )
//STRIP001 										{
//STRIP001 											// can't fit -> fall back to using half height
//STRIP001 											nEffHeight = nOutHeight / 2;
//STRIP001 											nNewWidth = (long)(nEffHeight / nAbsSin) + 2;
//STRIP001 											nSteps = 0;
//STRIP001 										}
//STRIP001 										else
//STRIP001 											--nSteps;
//STRIP001 
//STRIP001 										// set paper width and get new text height
//STRIP001 										aPaperSize.Width() = nNewWidth;
//STRIP001 										if (bPixelToLogic)
//STRIP001 											pEngine->SetPaperSize(pRefDevice->PixelToLogic(aPaperSize));
//STRIP001 										else
//STRIP001 											pEngine->SetPaperSize(aPaperSize);	// Scale ist immer 1
//STRIP001 										//pEngine->QuickFormatDoc( TRUE );
//STRIP001 										nEngineWidth  = (long) pEngine->CalcTextWidth();
//STRIP001 										nEngineHeight = pEngine->GetTextHeight();
//STRIP001 									}
//STRIP001 								}
//STRIP001 							}
//STRIP001 
//STRIP001 							long nRealWidth  = nEngineWidth;
//STRIP001 							long nRealHeight = nEngineHeight;
//STRIP001 
//STRIP001 							//	wenn gedreht, Groesse anpassen
//STRIP001 							if (nAttrRotate)
//STRIP001 							{
//STRIP001 								double nAbsCos = fabs( nCos );
//STRIP001 								double nAbsSin = fabs( nSin );
//STRIP001 
//STRIP001 								if ( eRotMode == SVX_ROTATE_MODE_STANDARD )
//STRIP001 									nEngineWidth = (long) ( nRealWidth * nAbsCos +
//STRIP001 															nRealHeight * nAbsSin );
//STRIP001 								else
//STRIP001 									nEngineWidth = (long) ( nRealHeight / nAbsSin );
//STRIP001 								//!	begrenzen !!!
//STRIP001 
//STRIP001 								nEngineHeight = (long) ( nRealHeight * nAbsCos +
//STRIP001 														 nRealWidth * nAbsSin );
//STRIP001 							}
//STRIP001 
//STRIP001 							if (!nAttrRotate)			//	hier nur gedrehter Text
//STRIP001 								bHidden = TRUE;			//! vorher abfragen !!!
//STRIP001 
//STRIP001 							//!	weglassen, was nicht hereinragt
//STRIP001 
//STRIP001 							if (!bHidden)
//STRIP001 							{
//STRIP001 								BOOL bExtend = FALSE;			// ueber Zellenrand geschrieben ?
//STRIP001 								BOOL bClip = FALSE;
//STRIP001 								BOOL bSimClip = FALSE;
//STRIP001 								Size aClipSize = Size( nScrX+nScrW-nStartX, nScrY+nScrH-nStartY );
//STRIP001 
//STRIP001 								//	weiterschreiben
//STRIP001 
//STRIP001 								Size aCellSize;
//STRIP001 								if (bPixelToLogic)
//STRIP001 									aCellSize = pRefDevice->PixelToLogic( Size( nOutWidth, nOutHeight ) );
//STRIP001 								else
//STRIP001 									aCellSize = Size( nOutWidth, nOutHeight );	// Scale ist 1
//STRIP001 
//STRIP001 								long nGridWidth = nEngineWidth;
//STRIP001 								BOOL bNegative = FALSE;
//STRIP001 								if ( eRotMode != SVX_ROTATE_MODE_STANDARD )
//STRIP001 								{
//STRIP001 									nGridWidth = aCellSize.Width() +
//STRIP001 											Abs((long) ( aCellSize.Height() * nCos / nSin ));
//STRIP001 									bNegative = ( pInfo->nRotateDir == SC_ROTDIR_LEFT );
//STRIP001 								}
//STRIP001 
//STRIP001 								if ( !bBreak ||	eOrient!=SVX_ORIENTATION_STANDARD )
//STRIP001 								{
//STRIP001 									if ( eOrient == SVX_ORIENTATION_STANDARD && !bMerged )
//STRIP001 									{
//STRIP001 										USHORT nNextX = bNegative ? (nX - 1) : (nX + 1);
//STRIP001 										//	Unterlauf wird durch nNextX<=nX2 abgefangen
//STRIP001 										while (	nGridWidth > aCellSize.Width() &&
//STRIP001 												nNextX>=nX1 && nNextX<=nX2 &&
//STRIP001 												!pThisRowInfo->pCellInfo[nNextX+1].bHOverlapped &&
//STRIP001 												!pThisRowInfo->pCellInfo[nNextX+1].bVOverlapped &&
//STRIP001 												!( bEditMode && nNextX==nEditCol && nY==nEditRow ) )
//STRIP001 										{
//STRIP001 											nOutWidth += pRowInfo[0].pCellInfo[nNextX+1].nWidth;
//STRIP001 											if (bPixelToLogic)
//STRIP001 												aCellSize = pRefDevice->PixelToLogic( Size( nOutWidth, nOutHeight ) );
//STRIP001 											else
//STRIP001 												aCellSize = Size( nOutWidth, nOutHeight );
//STRIP001 
//STRIP001 											//	Grid abschalten
//STRIP001 											if (bNegative)
//STRIP001 											{
//STRIP001 												pThisRowInfo->pCellInfo[nNextX+1].bHideGrid = TRUE;
//STRIP001 												--nNextX;
//STRIP001 											}
//STRIP001 											else
//STRIP001 											{
//STRIP001 												pThisRowInfo->pCellInfo[nNextX].bHideGrid = TRUE;
//STRIP001 												++nNextX;
//STRIP001 											}
//STRIP001 											bExtend = TRUE;
//STRIP001 										}
//STRIP001 									}
//STRIP001 									if ( nGridWidth > aCellSize.Width() )
//STRIP001 									{
//STRIP001 										bExtend = TRUE;		// -> immer linksbuendig
//STRIP001 										bClip = TRUE;
//STRIP001 										aClipSize.Width() = nOutWidth;		// Pixel
//STRIP001 									}
//STRIP001 								}
//STRIP001 								if ( nEngineHeight > aCellSize.Height() )
//STRIP001 								{
//STRIP001 									//	kein vertikales Clipping beim Drucken von Zellen mit
//STRIP001 									//	optimaler Hoehe, ausser bei Groesse in bedingter
//STRIP001 									//	Formatierung
//STRIP001 									if ( eType != OUTTYPE_PRINTER ||
//STRIP001 										( pDoc->GetRowFlags( nY, nTab ) & CR_MANUALSIZE ) ||
//STRIP001 										( pCondSet && SFX_ITEM_SET ==
//STRIP001 											pCondSet->GetItemState(ATTR_FONT_HEIGHT, TRUE) ) )
//STRIP001 										bClip = TRUE;
//STRIP001 									else
//STRIP001 										bSimClip = TRUE;
//STRIP001 									aClipSize.Height() = nOutHeight;		// Pixel
//STRIP001 								}
//STRIP001 
//STRIP001 								long nClipStartX = nStartX;
//STRIP001 								if (nX<nX1)
//STRIP001 								{
//STRIP001 									//! Clipping unnoetig, wenn links am Fenster
//STRIP001 
//STRIP001 									bClip = TRUE;					// nur Rest ausgeben!
//STRIP001 									if (nStartX<nScrX)
//STRIP001 									{
//STRIP001 										long nDif = nScrX - nStartX;
//STRIP001 										nClipStartX = nScrX;
//STRIP001 										aClipSize.Width() -= nDif;
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								long nClipStartY = nStartY;
//STRIP001 								if (nArrY==0 || bVisChanged)
//STRIP001 								{
//STRIP001 									if ( nClipStartY < nRowPosY )
//STRIP001 									{
//STRIP001 										long nDif = nRowPosY - nClipStartY;
//STRIP001 										bClip = TRUE;
//STRIP001 										nClipStartY = nRowPosY;
//STRIP001 										aClipSize.Height() -= nDif;
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								bClip = TRUE;		//! Test !!!!
//STRIP001 
//STRIP001 								Rectangle aClipRect;
//STRIP001 								if (bClip || bSimClip)
//STRIP001 								{
//STRIP001 									if ( nAttrRotate /* && eRotMode != SVX_ROTATE_MODE_STANDARD */ )
//STRIP001 									{
//STRIP001 										//	gedrehten, ausgerichteten Text nur an den
//STRIP001 										//	Seitengrenzen clippen
//STRIP001 										nClipStartX = nScrX;
//STRIP001 										aClipSize.Width() = nScrW;
//STRIP001 									}
//STRIP001 
//STRIP001 									if (bPixelToLogic)
//STRIP001 										aClipRect = pRefDevice->PixelToLogic( Rectangle(
//STRIP001 														Point(nClipStartX,nClipStartY), aClipSize ) );
//STRIP001 									else
//STRIP001 										aClipRect = Rectangle(Point(nClipStartX, nClipStartY),
//STRIP001 																aClipSize );	// Scale = 1
//STRIP001 
//STRIP001 									if (bClip)	// bei bSimClip nur aClipRect initialisieren
//STRIP001 									{
//STRIP001 										if (bMetaFile)
//STRIP001 										{
//STRIP001 											pDev->Push();
//STRIP001 											pDev->IntersectClipRegion( aClipRect );
//STRIP001 										}
//STRIP001 										else
//STRIP001 											pDev->SetClipRegion( Region( aClipRect ) );
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								Point aLogicStart;
//STRIP001 								if (bPixelToLogic)
//STRIP001 									aLogicStart = pRefDevice->PixelToLogic( Point(nStartX,nStartY) );
//STRIP001 								else
//STRIP001 									aLogicStart = Point(nStartX, nStartY);
//STRIP001 								if ( (eOrient!=SVX_ORIENTATION_STANDARD || !bBreak) && !bExtend )
//STRIP001 								{
//STRIP001 									long nAvailWidth = aCellSize.Width();
//STRIP001 									if (eType==OUTTYPE_WINDOW &&
//STRIP001 											eOrient!=SVX_ORIENTATION_STACKED &&
//STRIP001 											pInfo && pInfo->bAutoFilter)
//STRIP001 									{
//STRIP001 										if (pRowInfo[nArrY].nHeight < DROPDOWN_BITMAP_SIZE)
//STRIP001 										{
//STRIP001 											if (bPixelToLogic)
//STRIP001 												nAvailWidth -= pRefDevice->PixelToLogic(Size(0,pRowInfo[nArrY].nHeight)).Height();
//STRIP001 											else
//STRIP001 												nAvailWidth -= pRowInfo[nArrY].nHeight;
//STRIP001 										}
//STRIP001 										else
//STRIP001 										{
//STRIP001 											if (bPixelToLogic)
//STRIP001 												nAvailWidth -= pRefDevice->PixelToLogic(Size(0,DROPDOWN_BITMAP_SIZE)).Height();
//STRIP001 											else
//STRIP001 												nAvailWidth -= DROPDOWN_BITMAP_SIZE;
//STRIP001 										}
//STRIP001 										long nComp = nEngineWidth;
//STRIP001 										if (nAvailWidth<nComp) nAvailWidth=nComp;
//STRIP001 									}
//STRIP001 
//STRIP001 									//	horizontale Ausrichtung
//STRIP001 
//STRIP001 									if (eOrient==SVX_ORIENTATION_STANDARD && !nAttrRotate)
//STRIP001 									{
//STRIP001 										if (eHorJust==SVX_HOR_JUSTIFY_RIGHT ||
//STRIP001 											eHorJust==SVX_HOR_JUSTIFY_CENTER)
//STRIP001 										{
//STRIP001 											pEngine->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 											SvxAdjust eSvxAdjust =
//STRIP001 												(eHorJust==SVX_HOR_JUSTIFY_RIGHT) ?
//STRIP001 													SVX_ADJUST_RIGHT : SVX_ADJUST_CENTER;
//STRIP001 											pEngine->SetDefaultItem(
//STRIP001 												SvxAdjustItem( eSvxAdjust, EE_PARA_JUST ) );
//STRIP001 
//STRIP001 											aPaperSize.Width() = nOutWidth;
//STRIP001 											if (bPixelToLogic)
//STRIP001 												pEngine->SetPaperSize(pRefDevice->PixelToLogic(aPaperSize));
//STRIP001 											else
//STRIP001 												pEngine->SetPaperSize(aPaperSize);
//STRIP001 
//STRIP001 											pEngine->SetUpdateMode( TRUE );
//STRIP001 										}
//STRIP001 									}
//STRIP001 									else
//STRIP001 									{
//STRIP001 										//	bei gedrehtem Text ist Standard zentriert
//STRIP001 										if (eHorJust==SVX_HOR_JUSTIFY_RIGHT)
//STRIP001 											aLogicStart.X() += nAvailWidth - nEngineWidth;
//STRIP001 										else if (eHorJust==SVX_HOR_JUSTIFY_CENTER ||
//STRIP001 												 eHorJust==SVX_HOR_JUSTIFY_STANDARD)
//STRIP001 											aLogicStart.X() += (nAvailWidth - nEngineWidth) / 2;
//STRIP001 									}
//STRIP001 								}
//STRIP001 								else if (bExtend && eRotMode != SVX_ROTATE_MODE_STANDARD)
//STRIP001 								{
//STRIP001 									//	Ausrichtung mit Bezugskante
//STRIP001 
//STRIP001 									long nRealWidth = nCellWidth - 1;	//! Merge beruecksichtigen?
//STRIP001 									if (bPixelToLogic)
//STRIP001 										nRealWidth = pRefDevice->PixelToLogic(
//STRIP001 														Size( nRealWidth, 0 ) ).Width();
//STRIP001 
//STRIP001 									//	hier ist Standard links (?)
//STRIP001 									if (eHorJust==SVX_HOR_JUSTIFY_RIGHT)
//STRIP001 										aLogicStart.X() += nRealWidth - nEngineWidth;
//STRIP001 									else if (eHorJust==SVX_HOR_JUSTIFY_CENTER)
//STRIP001 										aLogicStart.X() += (nRealWidth - nEngineWidth) / 2;
//STRIP001 								}
//STRIP001 
//STRIP001 								if ( eOrient==SVX_ORIENTATION_STANDARD ||
//STRIP001 									 eOrient==SVX_ORIENTATION_STACKED || !bBreak )
//STRIP001 								{
//STRIP001 									if (eVerJust==SVX_VER_JUSTIFY_BOTTOM ||
//STRIP001 										eVerJust==SVX_VER_JUSTIFY_STANDARD)
//STRIP001 									{
//STRIP001 										if (bPixelToLogic)
//STRIP001 											aLogicStart.Y() += pRefDevice->PixelToLogic( Size(0,
//STRIP001 															pRefDevice->LogicToPixel(aCellSize).Height() -
//STRIP001 															pRefDevice->LogicToPixel(Size(0,nEngineHeight)).Height()
//STRIP001 															)).Height();
//STRIP001 										else
//STRIP001 											aLogicStart.Y() += aCellSize.Height() - nEngineHeight;
//STRIP001 									}
//STRIP001 
//STRIP001 									else if (eVerJust==SVX_VER_JUSTIFY_CENTER)
//STRIP001 									{
//STRIP001 										if (bPixelToLogic)
//STRIP001 											aLogicStart.Y() += pRefDevice->PixelToLogic( Size(0,(
//STRIP001 															pRefDevice->LogicToPixel(aCellSize).Height() -
//STRIP001 															pRefDevice->LogicToPixel(Size(0,nEngineHeight)).Height())
//STRIP001 															/ 2)).Height();
//STRIP001 										else
//STRIP001 											aLogicStart.Y() += (aCellSize.Height() - nEngineHeight) / 2;
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								// TOPBOTTON and BOTTOMTOP are handled in DrawStrings/DrawEdit
//STRIP001 								DBG_ASSERT( eOrient == SVX_ORIENTATION_STANDARD && nAttrRotate,
//STRIP001 											"DrawRotated: no rotation" );
//STRIP001 
//STRIP001 								long nOriVal = 0;
//STRIP001 								if ( nAttrRotate )
//STRIP001 								{
//STRIP001 									// Attribut ist 1/100, Font 1/10 Grad
//STRIP001 									nOriVal = nAttrRotate / 10;
//STRIP001 
//STRIP001 									double nAddX = 0.0;
//STRIP001 									double nAddY = 0.0;
//STRIP001 									if ( nCos > 0.0 && eRotMode != SVX_ROTATE_MODE_STANDARD )
//STRIP001 									{
//STRIP001 										//!	begrenzen !!!
//STRIP001 										double nH = nRealHeight * nCos;
//STRIP001 										nAddX += nH * ( nCos / fabs(nSin) );
//STRIP001 									}
//STRIP001 									if ( nCos < 0.0 && eRotMode == SVX_ROTATE_MODE_STANDARD )
//STRIP001 										nAddX -= nRealWidth * nCos;
//STRIP001 									if ( nSin < 0.0 )
//STRIP001 										nAddX -= nRealHeight * nSin;
//STRIP001 									if ( nSin > 0.0 )
//STRIP001 										nAddY += nRealWidth * nSin;
//STRIP001 									if ( nCos < 0.0 )
//STRIP001 										nAddY -= nRealHeight * nCos;
//STRIP001 
//STRIP001 									if ( eRotMode != SVX_ROTATE_MODE_STANDARD )
//STRIP001 									{
//STRIP001 										//!	begrenzen !!!
//STRIP001 										double nSkew = nTotalHeight * nCos / fabs(nSin);
//STRIP001 										if ( eRotMode == SVX_ROTATE_MODE_CENTER )
//STRIP001 											nAddX -= nSkew * 0.5;
//STRIP001 										if ( ( eRotMode == SVX_ROTATE_MODE_TOP && nSin > 0.0 ) ||
//STRIP001 											 ( eRotMode == SVX_ROTATE_MODE_BOTTOM && nSin < 0.0 ) )
//STRIP001 											nAddX -= nSkew;
//STRIP001 
//STRIP001 										long nUp = 0;
//STRIP001 										if ( eVerJust == SVX_VER_JUSTIFY_CENTER )
//STRIP001 											nUp = ( aCellSize.Height() - nEngineHeight ) / 2;
//STRIP001 										else if ( eVerJust == SVX_VER_JUSTIFY_TOP )
//STRIP001 										{
//STRIP001 											if ( nSin > 0.0 )
//STRIP001 												nUp = aCellSize.Height() - nEngineHeight;
//STRIP001 										}
//STRIP001 										else	// BOTTOM / STANDARD
//STRIP001 										{
//STRIP001 											if ( nSin < 0.0 )
//STRIP001 												nUp = aCellSize.Height() - nEngineHeight;
//STRIP001 										}
//STRIP001 										if ( nUp )
//STRIP001 											nAddX += ( nUp * nCos / fabs(nSin) );
//STRIP001 									}
//STRIP001 
//STRIP001 									aLogicStart.X() += (long) nAddX;
//STRIP001 									aLogicStart.Y() += (long) nAddY;
//STRIP001 								}
//STRIP001 
//STRIP001 								//!	bSimClip is not used here (because nOriVal is set)
//STRIP001 
//STRIP001 								if ( pEngine->IsRightToLeft( 0 ) )
//STRIP001 								{
//STRIP001 									//	For right-to-left, EditEngine always calculates its lines
//STRIP001 									//	beginning from the right edge, but EditLine::nStartPosX is
//STRIP001 									//	of USHORT type, so the PaperSize must be limited to USHRT_MAX.
//STRIP001 									Size aLogicPaper = pEngine->GetPaperSize();
//STRIP001 									if ( aLogicPaper.Width() > USHRT_MAX )
//STRIP001 									{
//STRIP001 										aLogicPaper.Width() = USHRT_MAX;
//STRIP001 										pEngine->SetPaperSize(aLogicPaper);
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								pEngine->Draw( pDev, aLogicStart, (short)nOriVal );
//STRIP001 
//STRIP001 								if (bClip)
//STRIP001 								{
//STRIP001 									if (bMetaFile)
//STRIP001 										pDev->Pop();
//STRIP001 									else
//STRIP001 										pDev->SetClipRegion();
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nRowPosY += pRowInfo[nArrY].nHeight;
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pEngine;
//STRIP001 }



}
