/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_viewutil.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:42:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------
// auto strip #include <tools/list.hxx>
#include "scitems.hxx"
// auto strip #include <bf_svx/charmap.hxx>
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #include <bf_svx/langitem.hxx>
#include <bf_svx/scripttypeitem.hxx>
#include <svtools/itempool.hxx>
#include <svtools/itemset.hxx>
// auto strip #include <vcl/svapp.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <vcl/wrkwin.hxx>

// auto strip #include <com/sun/star/i18n/TransliterationModules.hpp>

#include "viewutil.hxx"
// auto strip #include "global.hxx"
// auto strip #include "chgtrack.hxx"
// auto strip #include "chgviset.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//==================================================================

//	static
/*N*/ void ScViewUtil::PutItemScript( SfxItemSet& rShellSet, const SfxItemSet& rCoreSet,
/*N*/ 								USHORT nWhichId, USHORT nScript )
/*N*/ {
/*N*/ 	//	take the effective item from rCoreSet according to nScript
/*N*/ 	//	and put in rShellSet under the (base) nWhichId
/*N*/ 
/*N*/ 	SfxItemPool& rPool = *rShellSet.GetPool();
/*N*/ 	SvxScriptSetItem aSetItem( rPool.GetSlotId(nWhichId), rPool );
/*N*/ 	//	use PutExtended with eDefaultAs = SFX_ITEM_SET, so defaults from rCoreSet
/*N*/ 	//	(document pool) are read and put into rShellSet (MessagePool)
/*N*/ 	aSetItem.GetItemSet().PutExtended( rCoreSet, SFX_ITEM_DONTCARE, SFX_ITEM_SET );
/*N*/ 	const SfxPoolItem* pI = aSetItem.GetItemOfScript( nScript );
/*N*/ 	if (pI)
/*N*/ 		rShellSet.Put( *pI, nWhichId );
/*N*/ 	else
/*?*/ 		rShellSet.InvalidateItem( nWhichId );
/*N*/ }

//	static
//STRIP001 USHORT ScViewUtil::GetEffLanguage( ScDocument* pDoc, const ScAddress& rPos )
//STRIP001 {
//STRIP001 	//	used for thesaurus
//STRIP001 
//STRIP001 	BYTE nScript = pDoc->GetScriptType( rPos.Col(), rPos.Row(), rPos.Tab() );
//STRIP001 	USHORT nWhich = ( nScript == SCRIPTTYPE_ASIAN ) ? ATTR_CJK_FONT_LANGUAGE :
//STRIP001 					( ( nScript == SCRIPTTYPE_COMPLEX ) ? ATTR_CTL_FONT_LANGUAGE : ATTR_FONT_LANGUAGE );
//STRIP001 	const SfxPoolItem* pItem = pDoc->GetAttr( rPos.Col(), rPos.Row(), rPos.Tab(), nWhich);
//STRIP001 	SvxLanguageItem* pLangIt = PTR_CAST( SvxLanguageItem, pItem );
//STRIP001 	LanguageType eLnge;
//STRIP001 	if (pLangIt)
//STRIP001 	{
//STRIP001 		eLnge = (LanguageType) pLangIt->GetValue();
//STRIP001 		if (eLnge == LANGUAGE_DONTKNOW)					//! can this happen?
//STRIP001 		{
//STRIP001 			LanguageType eLatin, eCjk, eCtl;
//STRIP001 			pDoc->GetLanguage( eLatin, eCjk, eCtl );
//STRIP001 			eLnge = ( nScript == SCRIPTTYPE_ASIAN ) ? eCjk :
//STRIP001 					( ( nScript == SCRIPTTYPE_COMPLEX ) ? eCtl : eLatin );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eLnge = LANGUAGE_ENGLISH_US;
//STRIP001 	if ( eLnge == LANGUAGE_SYSTEM )
//STRIP001         eLnge = Application::GetSettings().GetLanguage();   // never use SYSTEM for spelling
//STRIP001 
//STRIP001 	return eLnge;
//STRIP001 }

//	static
//STRIP001 sal_Int32 ScViewUtil::GetTransliterationType( USHORT nSlotID )
//STRIP001 {
//STRIP001 	sal_Int32 nType = 0;
//STRIP001 	switch ( nSlotID )
//STRIP001 	{
//STRIP001 		case SID_TRANSLITERATE_UPPER:
//STRIP001 			nType = ::com::sun::star::i18n::TransliterationModules_LOWERCASE_UPPERCASE;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_LOWER:
//STRIP001 			nType = ::com::sun::star::i18n::TransliterationModules_UPPERCASE_LOWERCASE;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 			nType = ::com::sun::star::i18n::TransliterationModules_FULLWIDTH_HALFWIDTH;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 			nType = ::com::sun::star::i18n::TransliterationModules_HALFWIDTH_FULLWIDTH;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 			nType = ::com::sun::star::i18n::TransliterationModules_KATAKANA_HIRAGANA;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_KATAGANA:
//STRIP001 			nType = ::com::sun::star::i18n::TransliterationModules_HIRAGANA_KATAKANA;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return nType;
//STRIP001 }

//	static
//STRIP001 BOOL ScViewUtil::IsActionShown( const ScChangeAction& rAction,
//STRIP001 								const ScChangeViewSettings& rSettings,
//STRIP001 								ScDocument& rDocument )
//STRIP001 {
//STRIP001 	// abgelehnte werden durch eine invertierende akzeptierte Action dargestellt,
//STRIP001 	// die Reihenfolge von ShowRejected/ShowAccepted ist deswegen wichtig
//STRIP001 
//STRIP001 	if ( !rSettings.IsShowRejected() && rAction.IsRejecting() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	if ( !rSettings.IsShowAccepted() && rAction.IsAccepted() && !rAction.IsRejecting() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	if ( rSettings.HasAuthor() )
//STRIP001 	{
//STRIP001 		if ( rSettings.IsEveryoneButMe() )
//STRIP001 		{
//STRIP001 			//	GetUser() am ChangeTrack ist der aktuelle Benutzer
//STRIP001 			ScChangeTrack* pTrack = rDocument.GetChangeTrack();
//STRIP001 			if ( !pTrack || rAction.GetUser() == pTrack->GetUser() )
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 		else if ( rAction.GetUser() != rSettings.GetTheAuthorToShow() )
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rSettings.HasComment() )
//STRIP001 	{
//STRIP001 		String aComStr=rAction.GetComment();
//STRIP001 		aComStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM( " (" ));
//STRIP001 		rAction.GetDescription( aComStr, &rDocument );
//STRIP001 		aComStr+=')';
//STRIP001 
//STRIP001 		if(!rSettings.IsValidComment(&aComStr))
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rSettings.HasRange() )
//STRIP001 		if ( !rSettings.GetTheRangeList().Intersects( rAction.GetBigRange().MakeRange() ) )
//STRIP001 			return FALSE;
//STRIP001 
//STRIP001 	if ( rSettings.HasDate() && rSettings.GetTheDateMode() != SCDM_NO_DATEMODE )
//STRIP001 	{
//STRIP001 		DateTime aDateTime = rAction.GetDateTime();
//STRIP001 		const DateTime& rFirst = rSettings.GetTheFirstDateTime();
//STRIP001 		const DateTime& rLast  = rSettings.GetTheLastDateTime();
//STRIP001 		switch ( rSettings.GetTheDateMode() )
//STRIP001 		{	// korrespondiert mit ScHighlightChgDlg::OKBtnHdl
//STRIP001 			case SCDM_DATE_BEFORE:
//STRIP001 				if ( aDateTime > rFirst )
//STRIP001 					return FALSE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SCDM_DATE_SINCE:
//STRIP001 				if ( aDateTime < rFirst )
//STRIP001 					return FALSE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SCDM_DATE_EQUAL:
//STRIP001 			case SCDM_DATE_BETWEEN:
//STRIP001 				if ( aDateTime < rFirst || aDateTime > rLast )
//STRIP001 					return FALSE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SCDM_DATE_NOTEQUAL:
//STRIP001 				if ( aDateTime >= rFirst && aDateTime <= rLast )
//STRIP001 					return FALSE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SCDM_DATE_SAVE:
//STRIP001 				{
//STRIP001 				ScChangeTrack* pTrack = rDocument.GetChangeTrack();
//STRIP001 				if ( !pTrack || pTrack->GetLastSavedActionNumber() >=
//STRIP001 						rAction.GetActionNumber() )
//STRIP001 					return FALSE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//==================================================================

//STRIP001 BOOL ScViewUtil::ExecuteCharMap( const SvxFontItem& rOldFont,
//STRIP001 								 SvxFontItem& 		rNewFont,
//STRIP001 								 String&			rString )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	Font aFont;
//STRIP001 	aFont.SetName	 ( rOldFont.GetFamilyName() );
//STRIP001 	aFont.SetStyleName( rOldFont.GetStyleName() );
//STRIP001 	aFont.SetFamily	 ( rOldFont.GetFamily() );
//STRIP001 	aFont.SetCharSet  ( rOldFont.GetCharSet() );
//STRIP001 	aFont.SetPitch	 ( rOldFont.GetPitch() );
//STRIP001 
//STRIP001 	SvxCharacterMap* pDlg = new SvxCharacterMap( NULL, FALSE );
//STRIP001 	pDlg->SetCharFont( aFont );
//STRIP001 
//STRIP001 	if ( pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		rString  = pDlg->GetCharacters();
//STRIP001 		aFont    = pDlg->GetCharFont();
//STRIP001 		rNewFont = SvxFontItem( aFont.GetFamily(), aFont.GetName(),
//STRIP001 								aFont.GetStyleName(), aFont.GetPitch(),
//STRIP001 								aFont.GetCharSet() );					//	nId egal
//STRIP001 
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	delete pDlg;
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 ScUpdateRect::ScUpdateRect( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2 )
//STRIP001 {
//STRIP001 	PutInOrder( nX1, nX2 );
//STRIP001 	PutInOrder( nY1, nY2 );
//STRIP001 
//STRIP001 	nOldStartX = nX1;
//STRIP001 	nOldStartY = nY1;
//STRIP001 	nOldEndX = nX2;
//STRIP001 	nOldEndY = nY2;
//STRIP001 }
//STRIP001 
//STRIP001 void ScUpdateRect::SetNew( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2 )
//STRIP001 {
//STRIP001 	PutInOrder( nX1, nX2 );
//STRIP001 	PutInOrder( nY1, nY2 );
//STRIP001 
//STRIP001 	nNewStartX = nX1;
//STRIP001 	nNewStartY = nY1;
//STRIP001 	nNewEndX = nX2;
//STRIP001 	nNewEndY = nY2;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScUpdateRect::GetDiff( USHORT& rX1, USHORT& rY1, USHORT& rX2, USHORT& rY2 )
//STRIP001 {
//STRIP001 	if ( nNewStartX == nOldStartX && nNewEndX == nOldEndX &&
//STRIP001 		 nNewStartY == nOldStartY && nNewEndY == nOldEndY )
//STRIP001 	{
//STRIP001 		rX1 = nNewStartX;
//STRIP001 		rY1 = nNewStartY;
//STRIP001 		rX2 = nNewStartX;
//STRIP001 		rY2 = nNewStartY;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	rX1 = Min(nNewStartX,nOldStartX);
//STRIP001 	rY1 = Min(nNewStartY,nOldStartY);
//STRIP001 	rX2 = Max(nNewEndX,nOldEndX);
//STRIP001 	rY2 = Max(nNewEndY,nOldEndY);
//STRIP001 
//STRIP001 	if ( nNewStartX == nOldStartX && nNewEndX == nOldEndX )
//STRIP001 	{
//STRIP001 		if ( nNewStartY == nOldStartY )
//STRIP001 		{
//STRIP001 			rY1 = Min( nNewEndY, nOldEndY );
//STRIP001 			rY2 = Max( nNewEndY, nOldEndY );
//STRIP001 		}
//STRIP001 		else if ( nNewEndY == nOldEndY )
//STRIP001 		{
//STRIP001 			rY1 = Min( nNewStartY, nOldStartY );
//STRIP001 			rY2 = Max( nNewStartY, nOldStartY );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( nNewStartY == nOldStartY && nNewEndY == nOldEndY )
//STRIP001 	{
//STRIP001 		if ( nNewStartX == nOldStartX )
//STRIP001 		{
//STRIP001 			rX1 = Min( nNewEndX, nOldEndX );
//STRIP001 			rX2 = Max( nNewEndX, nOldEndX );
//STRIP001 		}
//STRIP001 		else if ( nNewEndX == nOldEndX )
//STRIP001 		{
//STRIP001 			rX1 = Min( nNewStartX, nOldStartX );
//STRIP001 			rX2 = Max( nNewStartX, nOldStartX );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScUpdateRect::GetXorDiff( USHORT& rX1, USHORT& rY1, USHORT& rX2, USHORT& rY2, BOOL& rCont )
//STRIP001 {
//STRIP001 	rCont = FALSE;
//STRIP001 
//STRIP001 	if ( nNewStartX == nOldStartX && nNewEndX == nOldEndX &&
//STRIP001 		 nNewStartY == nOldStartY && nNewEndY == nOldEndY )
//STRIP001 	{
//STRIP001 		rX1 = nNewStartX;
//STRIP001 		rY1 = nNewStartY;
//STRIP001 		rX2 = nNewStartX;
//STRIP001 		rY2 = nNewStartY;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	rX1 = Min(nNewStartX,nOldStartX);
//STRIP001 	rY1 = Min(nNewStartY,nOldStartY);
//STRIP001 	rX2 = Max(nNewEndX,nOldEndX);
//STRIP001 	rY2 = Max(nNewEndY,nOldEndY);
//STRIP001 
//STRIP001 	if ( nNewStartX == nOldStartX && nNewEndX == nOldEndX )				// nur vertikal
//STRIP001 	{
//STRIP001 		if ( nNewStartY == nOldStartY )
//STRIP001 		{
//STRIP001 			rY1 = Min( nNewEndY, nOldEndY ) + 1;
//STRIP001 			rY2 = Max( nNewEndY, nOldEndY );
//STRIP001 		}
//STRIP001 		else if ( nNewEndY == nOldEndY )
//STRIP001 		{
//STRIP001 			rY1 = Min( nNewStartY, nOldStartY );
//STRIP001 			rY2 = Max( nNewStartY, nOldStartY ) - 1;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rY1 = Min( nNewStartY, nOldStartY );
//STRIP001 			rY2 = Max( nNewStartY, nOldStartY ) - 1;
//STRIP001 			rCont = TRUE;
//STRIP001 			nContY1 = Min( nNewEndY, nOldEndY ) + 1;
//STRIP001 			nContY2 = Max( nNewEndY, nOldEndY );
//STRIP001 			nContX1 = rX1;
//STRIP001 			nContX2 = rX2;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( nNewStartY == nOldStartY && nNewEndY == nOldEndY )		// nur horizontal
//STRIP001 	{
//STRIP001 		if ( nNewStartX == nOldStartX )
//STRIP001 		{
//STRIP001 			rX1 = Min( nNewEndX, nOldEndX ) + 1;
//STRIP001 			rX2 = Max( nNewEndX, nOldEndX );
//STRIP001 		}
//STRIP001 		else if ( nNewEndX == nOldEndX )
//STRIP001 		{
//STRIP001 			rX1 = Min( nNewStartX, nOldStartX );
//STRIP001 			rX2 = Max( nNewStartX, nOldStartX ) - 1;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rX1 = Min( nNewStartX, nOldStartX );
//STRIP001 			rX2 = Max( nNewStartX, nOldStartX ) - 1;
//STRIP001 			rCont = TRUE;
//STRIP001 			nContX1 = Min( nNewEndX, nOldEndX ) + 1;
//STRIP001 			nContX2 = Max( nNewEndX, nOldEndX );
//STRIP001 			nContY1 = rY1;
//STRIP001 			nContY2 = rY2;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( nNewEndX == nOldEndX && nNewEndY == nOldEndY )			// links oben
//STRIP001 	{
//STRIP001 		if ( (nNewStartX<nOldStartX) == (nNewStartY<nOldStartY) )
//STRIP001 			rX1 = Min( nNewStartX, nOldStartX );
//STRIP001 		else
//STRIP001 			rX1 = Max( nNewStartX, nOldStartX );			// Ecke weglassen
//STRIP001 		rX2 = nOldEndX;
//STRIP001 		rY1 = Min( nNewStartY, nOldStartY );				// oben
//STRIP001 		rY2 = Max( nNewStartY, nOldStartY ) - 1;
//STRIP001 		rCont = TRUE;
//STRIP001 		nContY1 = rY2+1;
//STRIP001 		nContY2 = nOldEndY;
//STRIP001 		nContX1 = Min( nNewStartX, nOldStartX );			// links
//STRIP001 		nContX2 = Max( nNewStartX, nOldStartX ) - 1;
//STRIP001 	}
//STRIP001 	else if ( nNewStartX == nOldStartX && nNewEndY == nOldEndY )		// rechts oben
//STRIP001 	{
//STRIP001 		if ( (nNewEndX<nOldEndX) != (nNewStartY<nOldStartY) )
//STRIP001 			rX2 = Max( nNewEndX, nOldEndX );
//STRIP001 		else
//STRIP001 			rX2 = Min( nNewEndX, nOldEndX );				// Ecke weglassen
//STRIP001 		rX1 = nOldStartX;
//STRIP001 		rY1 = Min( nNewStartY, nOldStartY );				// oben
//STRIP001 		rY2 = Max( nNewStartY, nOldStartY ) - 1;
//STRIP001 		rCont = TRUE;
//STRIP001 		nContY1 = rY2+1;
//STRIP001 		nContY2 = nOldEndY;
//STRIP001 		nContX1 = Min( nNewEndX, nOldEndX ) + 1;			// rechts
//STRIP001 		nContX2 = Max( nNewEndX, nOldEndX );
//STRIP001 	}
//STRIP001 	else if ( nNewEndX == nOldEndX && nNewStartY == nOldStartY )		// links unten
//STRIP001 	{
//STRIP001 		if ( (nNewStartX<nOldStartX) != (nNewEndY<nOldEndY) )
//STRIP001 			rX1 = Min( nNewStartX, nOldStartX );
//STRIP001 		else
//STRIP001 			rX1 = Max( nNewStartX, nOldStartX );			// Ecke weglassen
//STRIP001 		rX2 = nOldEndX;
//STRIP001 		rY1 = Min( nNewEndY, nOldEndY ) + 1;				// unten
//STRIP001 		rY2 = Max( nNewEndY, nOldEndY );
//STRIP001 		rCont = TRUE;
//STRIP001 		nContY1 = nOldStartY;
//STRIP001 		nContY2 = rY1-1;
//STRIP001 		nContX1 = Min( nNewStartX, nOldStartX );			// links
//STRIP001 		nContX2 = Max( nNewStartX, nOldStartX ) - 1;
//STRIP001 	}
//STRIP001 	else if ( nNewStartX == nOldStartX && nNewStartY == nOldStartY )	// rechts unten
//STRIP001 	{
//STRIP001 		if ( (nNewEndX<nOldEndX) == (nNewEndY<nOldEndY) )
//STRIP001 			rX2 = Max( nNewEndX, nOldEndX );
//STRIP001 		else
//STRIP001 			rX2 = Min( nNewEndX, nOldEndX );				// Ecke weglassen
//STRIP001 		rX1 = nOldStartX;
//STRIP001 		rY1 = Min( nNewEndY, nOldEndY ) + 1;				// unten
//STRIP001 		rY2 = Max( nNewEndY, nOldEndY );
//STRIP001 		rCont = TRUE;
//STRIP001 		nContY1 = nOldStartY;
//STRIP001 		nContY2 = rY1-1;
//STRIP001 		nContX1 = Min( nNewEndX, nOldEndX ) + 1;			// rechts
//STRIP001 		nContX2 = Max( nNewEndX, nOldEndX );
//STRIP001 	}
//STRIP001 	else																// Ueberschlag
//STRIP001 	{
//STRIP001 		rX1 = nOldStartX;
//STRIP001 		rY1 = nOldStartY;
//STRIP001 		rX2 = nOldEndX;
//STRIP001 		rY2 = nOldEndY;
//STRIP001 		rCont = TRUE;
//STRIP001 		nContX1 = nNewStartX;
//STRIP001 		nContY1 = nNewStartY;
//STRIP001 		nContX2 = nNewEndX;
//STRIP001 		nContY2 = nNewEndY;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void ScUpdateRect::GetContDiff( USHORT& rX1, USHORT& rY1, USHORT& rX2, USHORT& rY2 )
//STRIP001 {
//STRIP001 	rX1 = nContX1;
//STRIP001 	rY1 = nContY1;
//STRIP001 	rX2 = nContX2;
//STRIP001 	rY2 = nContY2;
//STRIP001 }






}
