/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_SchPersistentObjectPointer.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:48:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
 
// auto strip #include	"SchPersistentObjectPointer.hxx"


#ifndef _SCH_DATAPOIN_HXX
# include	"datapoin.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
# include	"datarow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
# include	"objid.hxx"
#endif
#ifndef	_DEFINES_HXX
# include	"defines.hxx"
#endif
#ifndef	_TOOLS_DEBUG_HXX
# include	<tools/debug.hxx>
#endif
#ifndef _CHTMODEL_HXX
# include	"chtmodel.hxx"
#endif

namespace binfilter {
//	Id for invalid persistent object pointer.  Largest defined CHOBJID_...
//	is CHOBJID_DIAGRAM_TITLE_C_AXIS == 70.
const	UINT16	CHOBJID_INVALID = 666;

//STRIP001 SchPersistentObjectPointer::SchPersistentObjectPointer	(
//STRIP001 		UINT16		nObjectId, 
//STRIP001 		long 		nSeries,
//STRIP001 		long		nIndex)
//STRIP001 	:	mnObjectId (nObjectId),
//STRIP001 		mnSeries (nSeries),
//STRIP001 		mnIndex (nIndex)
//STRIP001 {
//STRIP001 }




//STRIP001 SchPersistentObjectPointer::SchPersistentObjectPointer	(
//STRIP001 		const SdrObject * pObject)
//STRIP001 	:	mnSeries (-1),
//STRIP001 		mnIndex (-1)
//STRIP001 {
//STRIP001 	mnObjectId = CHOBJID_INVALID;
//STRIP001 	
//STRIP001 	//	Determine marked object if no valid object is given.
//STRIP001 	if (pObject == NULL)
//STRIP001 		return;
//STRIP001 
//STRIP001 	//	Determine the id of the object.
//STRIP001 	SchObjectId * pId = ::GetObjectId (*pObject);
//STRIP001 	if (pId == NULL)
//STRIP001 		return;
//STRIP001 	mnObjectId = pId->GetObjId ();
//STRIP001 	
//STRIP001 	//	For certain objects we need more information to describe the object
//STRIP001 	//	unambiguously.
//STRIP001 	switch (mnObjectId)
//STRIP001 	{
//STRIP001 		case	CHOBJID_DIAGRAM_DATA:		//	31: a single data point
//STRIP001 		{
//STRIP001 			SchDataPoint * pDataPoint = GetDataPoint (*pObject);
//STRIP001 			if (pDataPoint == NULL)
//STRIP001 				mnObjectId = CHOBJID_INVALID;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				mnSeries = pDataPoint->GetRow();
//STRIP001 				mnIndex = pDataPoint->GetCol();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		
//STRIP001 		case	CHOBJID_DIAGRAM_ROWS			:	//	29
//STRIP001 		case	CHOBJID_DIAGRAM_ROWGROUP		:	//	28: a data row
//STRIP001 		case	CHOBJID_DIAGRAM_SPECIAL_GROUP	:	//	55
//STRIP001 		{
//STRIP001 			SchDataRow * pDataRow = GetDataRow (*pObject);
//STRIP001 			if (pDataRow == NULL)
//STRIP001 				mnObjectId = CHOBJID_INVALID;
//STRIP001 			else
//STRIP001 				mnSeries = pDataRow->GetRow();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }



		
//STRIP001 SchPersistentObjectPointer::~SchPersistentObjectPointer	(void)
//STRIP001 {
//STRIP001 }



	
//STRIP001 UINT16	SchPersistentObjectPointer::GetObjectId	(void)	const	
//STRIP001 {
//STRIP001 	if (mnObjectId == CHOBJID_INVALID)
//STRIP001 		//	This id is not known outside this file.  Should be transformed to
//STRIP001 		//	something.
//STRIP001 		return mnObjectId;
//STRIP001 	else
//STRIP001 		return mnObjectId;
//STRIP001 }




//STRIP001 long	SchPersistentObjectPointer::GetSeries	(void)	const
//STRIP001 {
//STRIP001 	return mnSeries;
//STRIP001 }




//STRIP001 long	SchPersistentObjectPointer::GetIndex	(void)	const
//STRIP001 {
//STRIP001 	return mnIndex;
//STRIP001 }




/**
	@decr	Use methods of the given chart model to transform the
		object id and indices into a list of valid object pointers.
*/
//STRIP001 const std::vector<SdrObject*>	&	SchPersistentObjectPointer::GetPointers	(
//STRIP001 	ChartModel	*	pModel)
//STRIP001 {
//STRIP001 	maObjectList.clear();
//STRIP001 	
//STRIP001 	switch (mnObjectId)
//STRIP001 	{
//STRIP001 		//	Data row.
//STRIP001 		case	CHOBJID_DIAGRAM_ROWS			:
//STRIP001 		case	CHOBJID_DIAGRAM_ROWGROUP		:
//STRIP001 		case	CHOBJID_DIAGRAM_SPECIAL_GROUP	:
//STRIP001 			{
//STRIP001 				//	Iteratate recursively over all objects of the model's page.
//STRIP001 				SdrPage * pPage = pModel->GetPage (0);
//STRIP001 				SdrObjListIter aIterator (*pPage, IM_DEEPWITHGROUPS);
//STRIP001 				while (aIterator.IsMore())
//STRIP001 				{
//STRIP001 					SdrObject * pObj = aIterator.Next();
//STRIP001 					SchObjectId* pObjId = ::GetObjectId(*pObj);
//STRIP001 					SchDataRow * pDataRow = GetDataRow(*pObj);
//STRIP001 					if (pObjId && pObjId->GetObjId() == mnObjectId)
//STRIP001 						//CHOBJID_DIAGRAM_SPECIAL_GROUP))
//STRIP001 						if (pDataRow != NULL && pDataRow->GetRow() == mnSeries)
//STRIP001 								maObjectList.push_back (pObj);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		
//STRIP001 		//	Data point.
//STRIP001 		case	CHOBJID_DIAGRAM_DATA:
//STRIP001 			maObjectList.push_back (pModel->GetDataPointObj (mnIndex, mnSeries));
//STRIP001 			break;
//STRIP001 		
//STRIP001 		//	Unknown object.
//STRIP001 		case	CHOBJID_INVALID:
//STRIP001 			break;
//STRIP001 			
//STRIP001 		//	Everything else.
//STRIP001 		default	:
//STRIP001 			maObjectList.push_back (pModel->GetChartObj (mnObjectId));
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	
//STRIP001 	return maObjectList;
//STRIP001 }
}
