/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_animobjs.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:46:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
// auto strip #include <com/sun/star/presentation/AnimationEffect.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
// auto strip #include <com/sun/star/presentation/AnimationSpeed.hpp>
// auto strip #endif

#define _ANIMATION			//animation freischalten

#define _SV_BITMAPEX
// auto strip #include <bf_svx/xoutbmp.hxx>
// auto strip #include <bf_svx/xoutx.hxx>

#include <time.h>

// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_PROGRESS_HXX //autogen
// auto strip #include <bf_sfx2/progress.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
//STRIP001 #include "anminfo.hxx"
#include "animobjs.hxx"
#include "animobjs.hrc"
//STRIP001 #include "anmdef.hxx"
#include "app.hrc"
namespace binfilter {
//STRIP001 #include "strings.hrc"
//STRIP001 #include "sdresid.hxx"
//STRIP001 #include "sdview.hxx"
//STRIP001 #include "drawdoc.hxx"
//STRIP001 #include "sdpage.hxx"
//STRIP001 #include "res_bmp.hrc"
//STRIP001 #include "viewshel.hxx"

//STRIP001 #include <string>
//STRIP001 #include <algorithm>

//STRIP001 using namespace ::com::sun::star;
/*N*/ SFX_IMPL_DOCKINGWINDOW( SdAnimationChildWindow, SID_ANIMATION_OBJECTS)

//STRIP001 /*************************************************************************
//STRIP001 |*	SdDisplay - Control
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdDisplay::SdDisplay( Window* pWin, SdResId Id ) :
//STRIP001 		Control( pWin, Id ),
//STRIP001 		aScale( 1, 1 )
//STRIP001 {
//STRIP001 	SetMapMode( MAP_PIXEL );
//STRIP001 	const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 	SetBackground( Wallpaper( Color( rStyles.GetFieldColor() ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdDisplay::~SdDisplay()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdDisplay::SetBitmapEx( BitmapEx* pBmpEx )
//STRIP001 {
//STRIP001 	if( pBmpEx )
//STRIP001 	{
//STRIP001 		aBitmapEx = *pBmpEx;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 		const Color aFillColor = rStyles.GetFieldColor();
//STRIP001 		aBitmapEx.Erase(aFillColor);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdDisplay::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Point aPt;
//STRIP001 	Size aSize = GetOutputSize();
//STRIP001 	Size aBmpSize = aBitmapEx.GetBitmap().GetSizePixel();
//STRIP001 	aBmpSize.Width() = (long) ( (double) aBmpSize.Width() * (double) aScale );
//STRIP001 	aBmpSize.Height() = (long) ( (double) aBmpSize.Height() * (double) aScale );
//STRIP001 
//STRIP001 	if( aBmpSize.Width() < aSize.Width() )
//STRIP001 		aPt.X() = ( aSize.Width() - aBmpSize.Width() ) / 2;
//STRIP001 	if( aBmpSize.Height() < aSize.Height() )
//STRIP001 		aPt.Y() = ( aSize.Height() - aBmpSize.Height() ) / 2;
//STRIP001 
//STRIP001 	aBitmapEx.Draw( this, aPt, aBmpSize );
//STRIP001 	//DrawBitmap( aPt, aBmpSize, *pBitmap );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdDisplay::SetScale( const Fraction& rFrac )
//STRIP001 {
//STRIP001 	aScale = rFrac;
//STRIP001 }
//STRIP001 
//STRIP001 void SdDisplay::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Control::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 		SetBackground( Wallpaper( Color( rStyles.GetFieldColor() ) ) );
//STRIP001 		SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*	SdAnimationWin - FloatingWindow
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdAnimationWin::SdAnimationWin( SfxBindings* pInBindings,
//STRIP001 				SfxChildWindow *pCW, Window* pParent, const SdResId& rSdResId ) :
//STRIP001 		SfxDockingWindow    ( pInBindings, pCW, pParent, rSdResId ),
//STRIP001 		aCtlDisplay         ( this, SdResId( CTL_DISPLAY ) ),
//STRIP001 		aBtnFirst           ( this, SdResId( BTN_FIRST ) ),
//STRIP001 		aBtnReverse         ( this, SdResId( BTN_REVERSE ) ),
//STRIP001 		aBtnStop            ( this, SdResId( BTN_STOP ) ),
//STRIP001 		aBtnPlay            ( this, SdResId( BTN_PLAY ) ),
//STRIP001 		aBtnLast            ( this, SdResId( BTN_LAST ) ),
//STRIP001 		aNumFldBitmap       ( this, SdResId( NUM_FLD_BITMAP ) ),
//STRIP001 		aTimeField          ( this, SdResId( TIME_FIELD ) ),
//STRIP001 		aLbLoopCount        ( this, SdResId( LB_LOOP_COUNT ) ),
//STRIP001 		aBtnGetOneObject    ( this, SdResId( BTN_GET_ONE_OBJECT ) ),
//STRIP001 		aBtnGetAllObjects   ( this, SdResId( BTN_GET_ALL_OBJECTS ) ),
//STRIP001 		aBtnRemoveBitmap    ( this, SdResId( BTN_REMOVE_BITMAP ) ),
//STRIP001 		aBtnRemoveAll       ( this, SdResId( BTN_REMOVE_ALL ) ),
//STRIP001 		aFtCount            ( this, SdResId( FT_COUNT ) ),
//STRIP001 		aFiCount            ( this, SdResId( FI_COUNT ) ),
//STRIP001 		aGrpBitmap          ( this, SdResId( GRP_BITMAP ) ),
//STRIP001 		aRbtGroup           ( this, SdResId( RBT_GROUP ) ),
//STRIP001 		aRbtBitmap          ( this, SdResId( RBT_BITMAP ) ),
//STRIP001 		aFtAdjustment       ( this, SdResId( FT_ADJUSTMENT ) ),
//STRIP001 		aLbAdjustment       ( this, SdResId( LB_ADJUSTMENT ) ),
//STRIP001 		aBtnCreateGroup     ( this, SdResId( BTN_CREATE_GROUP ) ),
//STRIP001 		aGrpAnimation       ( this, SdResId( GRP_ANIMATION_GROUP ) ),
//STRIP001 		pBindings			( pInBindings ),
//STRIP001 		pWin   				( pParent ),
//STRIP001 		pBitmapEx			( NULL ),
//STRIP001 		bMovie				( FALSE ),
//STRIP001 		bAllObjects			( FALSE )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aBtnGetOneObject.SetModeImage( Image( SdResId( IMG_GET1OBJECT_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnGetAllObjects.SetModeImage( Image( SdResId( IMG_GETALLOBJECT_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnRemoveBitmap.SetModeImage( Image( SdResId( IMG_REMOVEBMP_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnRemoveAll.SetModeImage( Image( SdResId( IMG_REMOVEALLBMP_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	// neues Dokument mit Seite erzeugen
//STRIP001 	pMyDoc = new SdDrawDocument(DOCUMENT_TYPE_IMPRESS, NULL);
//STRIP001 	SdPage* pPage = (SdPage*) pMyDoc->AllocPage(FALSE);
//STRIP001 	pMyDoc->InsertPage(pPage);
//STRIP001 
//STRIP001 	pControllerItem = new SdAnimationControllerItem( SID_ANIMATOR_STATE, this, pBindings );
//STRIP001 
//STRIP001 	// Solange noch nicht in der Resource
//STRIP001 	aTimeField.SetFormat( TIMEF_SEC_CS );
//STRIP001 
//STRIP001 	aBtnFirst.SetClickHdl( LINK( this, SdAnimationWin, ClickFirstHdl ) );
//STRIP001 	aBtnReverse.SetClickHdl( LINK( this, SdAnimationWin, ClickPlayHdl ) );
//STRIP001 	aBtnStop.SetClickHdl( LINK( this, SdAnimationWin, ClickStopHdl ) );
//STRIP001 	aBtnPlay.SetClickHdl( LINK( this, SdAnimationWin, ClickPlayHdl ) );
//STRIP001 	aBtnLast.SetClickHdl( LINK( this, SdAnimationWin, ClickLastHdl ) );
//STRIP001 
//STRIP001 	aBtnGetOneObject.SetClickHdl( LINK( this, SdAnimationWin, ClickGetObjectHdl ) );
//STRIP001 	aBtnGetAllObjects.SetClickHdl( LINK( this, SdAnimationWin, ClickGetObjectHdl ) );
//STRIP001 	aBtnRemoveBitmap.SetClickHdl( LINK( this, SdAnimationWin, ClickRemoveBitmapHdl ) );
//STRIP001 	aBtnRemoveAll.SetClickHdl( LINK( this, SdAnimationWin, ClickRemoveBitmapHdl ) );
//STRIP001 
//STRIP001 	aRbtGroup.SetClickHdl( LINK( this, SdAnimationWin, ClickRbtHdl ) );
//STRIP001 	aRbtBitmap.SetClickHdl( LINK( this, SdAnimationWin, ClickRbtHdl ) );
//STRIP001 	aBtnCreateGroup.SetClickHdl( LINK( this, SdAnimationWin, ClickCreateGroupHdl ) );
//STRIP001 	aNumFldBitmap.SetModifyHdl( LINK( this, SdAnimationWin, ModifyBitmapHdl ) );
//STRIP001 	aTimeField.SetModifyHdl( LINK( this, SdAnimationWin, ModifyTimeHdl ) );
//STRIP001 
//STRIP001 	// disable 3D border
//STRIP001 	aCtlDisplay.SetBorderStyle(WINDOW_BORDER_MONO);
//STRIP001 	aDisplaySize = aCtlDisplay.GetOutputSize();
//STRIP001 
//STRIP001 	aSize = GetOutputSizePixel();
//STRIP001 	SetMinOutputSizePixel( aSize );
//STRIP001 
//STRIP001 	ResetAttrs();
//STRIP001 
//STRIP001 	// der Animator ist leer; es kann keine Animationsgruppe erstellt werden
//STRIP001 	aBtnCreateGroup.Disable();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdAnimationWin::~SdAnimationWin()
//STRIP001 {
//STRIP001 	ULONG i, nCount;
//STRIP001     
//STRIP001     delete pControllerItem;
//STRIP001 
//STRIP001 	// Bitmapliste bereinigen
//STRIP001 	for( i = 0, nCount = aBmpExList.Count(); i < nCount; i++ )
//STRIP001 		delete static_cast< BitmapEx* >( aBmpExList.GetObject( i ) );
//STRIP001 	aBmpExList.Clear();
//STRIP001 
//STRIP001 	// Timeliste bereinigen
//STRIP001 	for( i = 0, nCount = aTimeList.Count(); i < nCount; i++ )
//STRIP001 		delete static_cast< Time* >( aTimeList.GetObject( i ) );
//STRIP001 	aTimeList.Clear();
//STRIP001 
//STRIP001 	// die Clones loeschen
//STRIP001 	delete pMyDoc;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickFirstHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aBmpExList.First();
//STRIP001 	pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetCurObject() );
//STRIP001 	UpdateControl( aBmpExList.GetCurPos() );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickStopHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	bMovie = FALSE;
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickPlayHdl, void *, p )
//STRIP001 {
//STRIP001 	bMovie = TRUE;
//STRIP001 	BOOL bDisableCtrls = FALSE;
//STRIP001 	ULONG nCount = aBmpExList.Count();
//STRIP001 	BOOL bReverse = p == &aBtnReverse;
//STRIP001 
//STRIP001 	// Kann spaeter schwer ermittelt werden
//STRIP001 	BOOL bRbtGroupEnabled = aRbtGroup.IsEnabled();
//STRIP001 	BOOL bBtnGetAllObjectsEnabled = aBtnGetAllObjects.IsEnabled();
//STRIP001 	BOOL bBtnGetOneObjectEnabled = aBtnGetOneObject.IsEnabled();
//STRIP001 
//STRIP001 	// Gesamtzeit ermitteln
//STRIP001 	Time aTime( 0 );
//STRIP001 	long nFullTime;
//STRIP001 	if( aRbtBitmap.IsChecked() )
//STRIP001 	{
//STRIP001 		for( ULONG i = 0; i < nCount; i++ )
//STRIP001 			aTime += *static_cast< Time* >( aTimeList.GetObject( i ) );
//STRIP001 		nFullTime  = aTime.GetMSFromTime();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nFullTime = nCount * 100;
//STRIP001 		aTime.MakeTimeFromMS( nFullTime );
//STRIP001 	}
//STRIP001 
//STRIP001 	// StatusBarManager ab 1 Sekunde
//STRIP001 	SfxProgress* pProgress = NULL;
//STRIP001 	if( nFullTime >= 1000 )
//STRIP001 	{
//STRIP001 		bDisableCtrls = TRUE;
//STRIP001 		aBtnStop.Enable();
//STRIP001 		String aStr( RTL_CONSTASCII_USTRINGPARAM( "Animator:" ) ); // Hier sollte man sich noch etwas gescheites ausdenken!
//STRIP001 		pProgress = new SfxProgress( NULL, aStr, nFullTime );
//STRIP001 	}
//STRIP001 
//STRIP001 	ULONG nTmpTime = 0;
//STRIP001 	long i = 0;
//STRIP001 	BOOL bCount = i < (long) nCount;
//STRIP001 	if( bReverse )
//STRIP001 	{
//STRIP001 		i = nCount - 1;
//STRIP001 		bCount = i >= 0;
//STRIP001 	}
//STRIP001 	while( bCount && bMovie )
//STRIP001 	{
//STRIP001 		// Um Konsistenz zwischen Liste und Anzeige zu erwirken
//STRIP001 		aBmpExList.Seek( i );
//STRIP001 		pBitmapEx = static_cast< BitmapEx* >(  aBmpExList.GetCurObject() );
//STRIP001 
//STRIP001 		UpdateControl( i, bDisableCtrls );
//STRIP001 
//STRIP001 		if( aRbtBitmap.IsChecked() )
//STRIP001 		{
//STRIP001 			Time* pTime = static_cast< Time* >( aTimeList.GetObject( i ) );
//STRIP001 			DBG_ASSERT( pTime, "Keine Zeit gefunden!" );
//STRIP001 
//STRIP001 			aTimeField.SetTime( *pTime );
//STRIP001 			ULONG nTime = pTime->GetMSFromTime();
//STRIP001 
//STRIP001 			WaitInEffect( nTime, nTmpTime, pProgress );
//STRIP001 			nTmpTime += nTime;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			WaitInEffect( 100, nTmpTime, pProgress );
//STRIP001 			nTmpTime += 100;
//STRIP001 		}
//STRIP001 		if( bReverse )
//STRIP001 		{
//STRIP001 			i--;
//STRIP001 			bCount = i >= 0;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			i++;
//STRIP001 			bCount = i < (long) nCount;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Um die Controls wieder zu enablen
//STRIP001 	bMovie = FALSE;
//STRIP001 	UpdateControl( i - 1 );
//STRIP001 
//STRIP001 	if( pProgress )
//STRIP001 	{
//STRIP001 		delete pProgress;
//STRIP001 		aBtnStop.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	aRbtGroup.Enable( bRbtGroupEnabled );
//STRIP001 	aBtnGetAllObjects.Enable( bBtnGetAllObjectsEnabled );
//STRIP001 	aBtnGetOneObject.Enable( bBtnGetOneObjectEnabled );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickLastHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aBmpExList.Last();
//STRIP001 	pBitmapEx = static_cast< BitmapEx* >(  aBmpExList.GetCurObject() );
//STRIP001     UpdateControl( aBmpExList.GetCurPos() );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickRbtHdl, void *, p )
//STRIP001 {
//STRIP001 	if( !pBitmapEx || p == &aRbtGroup || aRbtGroup.IsChecked() )
//STRIP001 	{
//STRIP001 		aTimeField.SetText( String() );
//STRIP001 		aTimeField.Enable( FALSE );
//STRIP001 		aLbLoopCount.Enable( FALSE );
//STRIP001 	}
//STRIP001 	else if( p == &aRbtBitmap || aRbtBitmap.IsChecked() )
//STRIP001 	{
//STRIP001 		ULONG n = aNumFldBitmap.GetValue() - 1;
//STRIP001 		if( n >= 0 )
//STRIP001 		{
//STRIP001 			Time* pTime = static_cast< Time* >( aTimeList.GetObject( n ) );
//STRIP001 			aTimeField.SetTime( *pTime );
//STRIP001 		}
//STRIP001 		aTimeField.Enable();
//STRIP001 		aLbLoopCount.Enable();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickGetObjectHdl, void *, pBtn )
//STRIP001 {
//STRIP001 	bAllObjects = pBtn == &aBtnGetAllObjects;
//STRIP001 
//STRIP001 	// Code jetzt in AddObj()
//STRIP001 	SfxBoolItem aItem( SID_ANIMATOR_ADD, TRUE );
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute( 
//STRIP001 		SID_ANIMATOR_ADD, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickRemoveBitmapHdl, void *, pBtn )
//STRIP001 {
//STRIP001 	SdPage*		pPage = pMyDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 	SdrObject*  pObject;
//STRIP001 
//STRIP001 	if( pBtn == &aBtnRemoveBitmap )
//STRIP001 	{
//STRIP001 		ULONG nPos = aBmpExList.GetCurPos();
//STRIP001 		pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetCurObject() );
//STRIP001 		if( pBitmapEx )
//STRIP001 		{
//STRIP001 			delete pBitmapEx;
//STRIP001 			aBmpExList.Remove();
//STRIP001 			pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetCurObject() );
//STRIP001 		}
//STRIP001 		Time* pTime = static_cast< Time* >( aTimeList.GetObject( nPos ) );
//STRIP001 		if( pTime )
//STRIP001 		{
//STRIP001 			delete pTime;
//STRIP001 			aTimeList.Remove( nPos );
//STRIP001 		}
//STRIP001 
//STRIP001 		pObject = pPage->GetObj( nPos );
//STRIP001 		// Durch Uebernahme der AnimatedGIFs muessen nicht unbedingt
//STRIP001 		// Objekte vorhanden sein.
//STRIP001 		if( pObject )
//STRIP001 		{
//STRIP001 			pObject = pPage->RemoveObject(nPos);
//STRIP001 			DBG_ASSERT(pObject, "Clone beim Loeschen nicht gefunden");
//STRIP001 			delete pObject;
//STRIP001 			pPage->RecalcObjOrdNums();
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	else // Alles loeschen
//STRIP001 	{
//STRIP001 		WarningBox aWarnBox( this, WB_YES_NO, String( SdResId( STR_ASK_DELETE_ALL_PICTURES ) ) );
//STRIP001 		short nReturn = aWarnBox.Execute();
//STRIP001 
//STRIP001 		if( nReturn == RET_YES )
//STRIP001 		{
//STRIP001 			// Bitmapliste bereinigen
//STRIP001 			long nCount = aBmpExList.Count();
//STRIP001 			for( long i = nCount - 1; i >= 0; i-- )
//STRIP001 			{
//STRIP001 				pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetObject( i ) );
//STRIP001 				delete pBitmapEx;
//STRIP001 
//STRIP001 				pObject = pPage->GetObj( i );
//STRIP001 				if( pObject )
//STRIP001 				{
//STRIP001 					pObject = pPage->RemoveObject( i );
//STRIP001 					DBG_ASSERT(pObject, "Clone beim Loeschen nicht gefunden");
//STRIP001 					delete pObject;
//STRIP001 					//pPage->RecalcObjOrdNums();
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 			aBmpExList.Clear();
//STRIP001 
//STRIP001 			// Timeliste bereinigen
//STRIP001 			nCount = aTimeList.Count();
//STRIP001 			for( i = 0; i < nCount; i++ )
//STRIP001 			{
//STRIP001 				delete static_cast< Time* >( aTimeList.GetObject( i ) );
//STRIP001 			}
//STRIP001 			aTimeList.Clear();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// kann noch eine Animationsgruppe erstellt werden?
//STRIP001 	if (aBmpExList.Count() == 0)
//STRIP001 	{
//STRIP001 		aBtnCreateGroup.Disable();
//STRIP001 		// Falls vorher durch Uebernahme von AnimatedGIFs disabled:
//STRIP001 		//aRbtBitmap.Enable();
//STRIP001 		aRbtGroup.Enable();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Zoom fuer DisplayWin berechnen und setzen
//STRIP001 	Fraction aFrac( GetScale() );
//STRIP001 	aCtlDisplay.SetScale( aFrac );
//STRIP001 
//STRIP001 	UpdateControl( aBmpExList.GetCurPos() );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ClickCreateGroupHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	// Code jetzt in CreatePresObj()
//STRIP001 	SfxBoolItem aItem( SID_ANIMATOR_CREATE, TRUE );
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute( 
//STRIP001 		SID_ANIMATOR_CREATE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ModifyBitmapHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ULONG nBmp = aNumFldBitmap.GetValue();
//STRIP001 
//STRIP001 	if( nBmp > aBmpExList.Count() )
//STRIP001 		nBmp = aBmpExList.Count();
//STRIP001 
//STRIP001 	pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetObject( nBmp - 1 ) );
//STRIP001 
//STRIP001 	// Positionieren in der Liste
//STRIP001 	aBmpExList.Seek( nBmp - 1 );
//STRIP001 
//STRIP001 	UpdateControl( nBmp - 1 );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdAnimationWin, ModifyTimeHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ULONG nPos = aNumFldBitmap.GetValue() - 1;
//STRIP001 
//STRIP001 	Time* pTime = static_cast< Time* >( aTimeList.GetObject( nPos ) );
//STRIP001 	DBG_ASSERT( pTime, "Zeit nicht gefunden!" )
//STRIP001 
//STRIP001 	*pTime = aTimeField.GetTime();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::UpdateControl( ULONG nListPos, BOOL bDisableCtrls )
//STRIP001 {
//STRIP001 	String aString;
//STRIP001 
//STRIP001 	if( pBitmapEx )
//STRIP001 	{
//STRIP001 		BitmapEx aBmp( *pBitmapEx );
//STRIP001 
//STRIP001 		SdPage* pPage = pMyDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 		SdrObject* pObject = (SdrObject*) pPage->GetObj( (ULONG) nListPos );
//STRIP001 		if( pObject )
//STRIP001 		{
//STRIP001 			SdrPaintInfoRec aPaintInfoRec;
//STRIP001 			VirtualDevice	aVD;
//STRIP001 			Rectangle		aObjRect( pObject->GetBoundRect() );
//STRIP001 			Size			aObjSize( aObjRect.GetSize() );
//STRIP001 			Point			aOrigin( Point( -aObjRect.Left(), -aObjRect.Top() ) );
//STRIP001 			MapMode 		aMap( aVD.GetMapMode() );
//STRIP001 			aMap.SetMapUnit( MAP_100TH_MM );
//STRIP001 			aMap.SetOrigin( aOrigin );
//STRIP001 			aVD.SetMapMode( aMap );
//STRIP001 			aVD.SetOutputSize( aObjSize );
//STRIP001 			const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 			aVD.SetBackground( Wallpaper( rStyles.GetFieldColor() ) );
//STRIP001 			//AdjustVDev( &aVD );
//STRIP001 			ExtOutputDevice aOut( &aVD );
//STRIP001 			aVD.SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 			aVD.Erase();
//STRIP001 			pObject->Paint( aOut, aPaintInfoRec );
//STRIP001 			aBmp = BitmapEx( aVD.GetBitmap( aObjRect.TopLeft(), aObjSize ) );
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		aCtlDisplay.SetBitmapEx( &aBmp );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aCtlDisplay.SetBitmapEx( pBitmapEx );
//STRIP001 	}
//STRIP001 	aCtlDisplay.Invalidate();
//STRIP001 	aCtlDisplay.Update();
//STRIP001 
//STRIP001 	aFiCount.SetText( UniString::CreateFromInt32( aBmpExList.Count() ) );
//STRIP001 
//STRIP001 	if( pBitmapEx && !bMovie )
//STRIP001 	{
//STRIP001 		aNumFldBitmap.SetValue( nListPos + 1 );
//STRIP001 
//STRIP001 		// Wenn mind. 1 Objekt in der Liste ist
//STRIP001 		aBtnFirst.Enable();
//STRIP001 		aBtnReverse.Enable();
//STRIP001 		aBtnPlay.Enable();
//STRIP001 		aBtnLast.Enable();
//STRIP001 		aNumFldBitmap.Enable();
//STRIP001 		aTimeField.Enable();
//STRIP001 		aLbLoopCount.Enable();
//STRIP001 		aBtnRemoveBitmap.Enable();
//STRIP001 		aBtnRemoveAll.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//aFiCount.SetText( String( SdResId( STR_NULL ) ) );
//STRIP001 
//STRIP001 		// Wenn kein Objekt in der Liste ist
//STRIP001 		aBtnFirst.Enable( FALSE );
//STRIP001 		aBtnReverse.Enable( FALSE );
//STRIP001 		aBtnPlay.Enable( FALSE );
//STRIP001 		aBtnLast.Enable( FALSE );
//STRIP001 		aNumFldBitmap.Enable( FALSE );
//STRIP001 		aTimeField.Enable( FALSE );
//STRIP001 		aLbLoopCount.Enable( FALSE );
//STRIP001 		aBtnRemoveBitmap.Enable( FALSE );
//STRIP001 		aBtnRemoveAll.Enable( FALSE );
//STRIP001 
//STRIP001 		//aFtAdjustment.Enable();
//STRIP001 		//aLbAdjustment.Enable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bMovie && bDisableCtrls )
//STRIP001 	{
//STRIP001 		aBtnGetOneObject.Enable( FALSE );
//STRIP001 		aBtnGetAllObjects.Enable( FALSE );
//STRIP001 		aRbtGroup.Enable( FALSE );
//STRIP001 		aRbtBitmap.Enable( FALSE );
//STRIP001 		aBtnCreateGroup.Enable( FALSE );
//STRIP001 		aFtAdjustment.Enable( FALSE );
//STRIP001 		aLbAdjustment.Enable( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// 'Gruppenobjekt' nur dann enablen, wenn es kein Animated GIF ist
//STRIP001 		if (aBmpExList.Count() == 0)
//STRIP001 			aRbtGroup.Enable();
//STRIP001 
//STRIP001 		aRbtBitmap.Enable();
//STRIP001 		aBtnCreateGroup.Enable(aBmpExList.Count() != 0);
//STRIP001 		aFtAdjustment.Enable( TRUE );
//STRIP001 		aLbAdjustment.Enable( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	ClickRbtHdl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::ResetAttrs()
//STRIP001 {
//STRIP001 	aRbtGroup.Check();
//STRIP001 	aLbAdjustment.SelectEntryPos( BA_CENTER );
//STRIP001 	// LoopCount
//STRIP001 	aLbLoopCount.SelectEntryPos( aLbLoopCount.GetEntryCount() - 1);
//STRIP001 
//STRIP001 	UpdateControl( 0 );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::WaitInEffect( ULONG nMilliSeconds ) const
//STRIP001 {
//STRIP001 	ULONG nEnd = Time::GetSystemTicks() + nMilliSeconds;
//STRIP001 	ULONG nCurrent = Time::GetSystemTicks();
//STRIP001 	while (nCurrent < nEnd)
//STRIP001 	{
//STRIP001 		nCurrent = Time::GetSystemTicks();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::WaitInEffect( ULONG nMilliSeconds, ULONG nTime,
//STRIP001 									SfxProgress* pProgress ) const
//STRIP001 {
//STRIP001 	clock_t aEnd = Time::GetSystemTicks() + nMilliSeconds;
//STRIP001 	clock_t aCurrent = Time::GetSystemTicks();
//STRIP001 	while (aCurrent < aEnd)
//STRIP001 	{
//STRIP001 		aCurrent = Time::GetSystemTicks();
//STRIP001 
//STRIP001 		if( pProgress )
//STRIP001 			pProgress->SetState( nTime + nMilliSeconds + aCurrent - aEnd );
//STRIP001 
//STRIP001 		if( !bMovie )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Fraction SdAnimationWin::GetScale()
//STRIP001 {
//STRIP001 	Fraction aFrac;
//STRIP001 	ULONG nPos = aBmpExList.GetCurPos();
//STRIP001 	ULONG nCount = aBmpExList.Count();
//STRIP001 	if( nCount > 0 )
//STRIP001 	{
//STRIP001 		aBmpSize.Width() = 0;
//STRIP001 		aBmpSize.Height() = 0;
//STRIP001 		for( ULONG i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetObject( i ) );
//STRIP001 			Size aSize( pBitmapEx->GetBitmap().GetSizePixel() );
//STRIP001 			aBmpSize.Width() = Max( aBmpSize.Width(), aSize.Width() );
//STRIP001 			aBmpSize.Height() = Max( aBmpSize.Height(), aSize.Height() );
//STRIP001 		}
//STRIP001 
//STRIP001 		aBmpSize.Width() += 10;
//STRIP001 		aBmpSize.Height() += 10;
//STRIP001 
//STRIP001 		aFrac = Fraction( std::min( (double)aDisplaySize.Width() / (double)aBmpSize.Width(),
//STRIP001 							 (double)aDisplaySize.Height() / (double)aBmpSize.Height() ) );
//STRIP001 	}
//STRIP001 	// Liste wieder auf alten Stand bringen
//STRIP001 	pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetObject( nPos ) );
//STRIP001 	return( aFrac );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::Resize()
//STRIP001 {
//STRIP001 	//if( !IsZoomedIn() )
//STRIP001 	if ( !IsFloatingMode() ||
//STRIP001 		 !GetFloatingWindow()->IsRollUp() )
//STRIP001 	{
//STRIP001 		Size aWinSize( GetOutputSizePixel() ); // vorher rSize im Resizing()
//STRIP001 
//STRIP001 		Size aDiffSize;
//STRIP001 		aDiffSize.Width() = aWinSize.Width() - aSize.Width();
//STRIP001 		aDiffSize.Height() = aWinSize.Height() - aSize.Height();
//STRIP001 
//STRIP001 		// Umgroessern des Display-Controls
//STRIP001 		aDisplaySize.Width() += aDiffSize.Width();
//STRIP001 		aDisplaySize.Height() += aDiffSize.Height();
//STRIP001 		aCtlDisplay.SetOutputSizePixel( aDisplaySize );
//STRIP001 
//STRIP001 		Point aPt;
//STRIP001 		// aPt.X() = aDiffSize.Width() / 2;
//STRIP001 		aPt.Y() = aDiffSize.Height();
//STRIP001 
//STRIP001 		// Verschieben der anderen Controls
//STRIP001 		aBtnFirst.Hide();
//STRIP001 		aBtnReverse.Hide();
//STRIP001 		aBtnStop.Hide();
//STRIP001 		aBtnPlay.Hide();
//STRIP001 		aBtnLast.Hide();
//STRIP001 		aTimeField.Hide();
//STRIP001 		aLbLoopCount.Hide();
//STRIP001 		aNumFldBitmap.Hide();
//STRIP001 		aFtCount.Hide();
//STRIP001 		aFiCount.Hide();
//STRIP001 		aBtnGetOneObject.Hide();
//STRIP001 		aBtnGetAllObjects.Hide();
//STRIP001 		aBtnRemoveBitmap.Hide();
//STRIP001 		aBtnRemoveAll.Hide();
//STRIP001 		aGrpBitmap.Hide();
//STRIP001 		aRbtGroup.Hide();
//STRIP001 		aRbtBitmap.Hide();
//STRIP001 		aFtAdjustment.Hide();
//STRIP001 		aLbAdjustment.Hide();
//STRIP001 		aBtnCreateGroup.Hide();
//STRIP001 		aGrpAnimation.Hide();
//STRIP001 
//STRIP001 
//STRIP001 		aBtnFirst.SetPosPixel( aBtnFirst.GetPosPixel() + aPt );
//STRIP001 		aBtnReverse.SetPosPixel( aBtnReverse.GetPosPixel() + aPt );
//STRIP001 		aBtnStop.SetPosPixel( aBtnStop.GetPosPixel() + aPt );
//STRIP001 		aBtnPlay.SetPosPixel( aBtnPlay.GetPosPixel() + aPt );
//STRIP001 		aBtnLast.SetPosPixel( aBtnLast.GetPosPixel() + aPt );
//STRIP001 		aNumFldBitmap.SetPosPixel( aNumFldBitmap.GetPosPixel() + aPt );
//STRIP001 		aTimeField.SetPosPixel( aTimeField.GetPosPixel() + aPt );
//STRIP001 		aLbLoopCount.SetPosPixel( aLbLoopCount.GetPosPixel() + aPt );
//STRIP001 		aFtCount.SetPosPixel( aFtCount.GetPosPixel() + aPt );
//STRIP001 		aFiCount.SetPosPixel( aFiCount.GetPosPixel() + aPt );
//STRIP001 		aRbtGroup.SetPosPixel( aRbtGroup.GetPosPixel() + aPt );
//STRIP001 		aRbtBitmap.SetPosPixel( aRbtBitmap.GetPosPixel() + aPt );
//STRIP001 		aFtAdjustment.SetPosPixel( aFtAdjustment.GetPosPixel() + aPt );
//STRIP001 		aLbAdjustment.SetPosPixel( aLbAdjustment.GetPosPixel() + aPt );
//STRIP001 		aBtnGetOneObject.SetPosPixel( aBtnGetOneObject.GetPosPixel() + aPt );
//STRIP001 		aBtnGetAllObjects.SetPosPixel( aBtnGetAllObjects.GetPosPixel() + aPt );
//STRIP001 		aBtnRemoveBitmap.SetPosPixel( aBtnRemoveBitmap.GetPosPixel() + aPt );
//STRIP001 		aBtnRemoveAll.SetPosPixel( aBtnRemoveAll.GetPosPixel() + aPt );
//STRIP001 		aBtnCreateGroup.SetPosPixel( aBtnCreateGroup.GetPosPixel() + aPt );
//STRIP001 		aGrpBitmap.SetPosPixel( aGrpBitmap.GetPosPixel() + aPt );
//STRIP001 		aGrpAnimation.SetPosPixel( aGrpAnimation.GetPosPixel() + aPt );
//STRIP001 
//STRIP001 		// Zoom fuer DisplayWin berechnen und setzen
//STRIP001 		Fraction aFrac( GetScale() );
//STRIP001 		aCtlDisplay.SetScale( aFrac );
//STRIP001 
//STRIP001 		aBtnFirst.Show();
//STRIP001 		aBtnReverse.Show();
//STRIP001 		aBtnStop.Show();
//STRIP001 		aBtnPlay.Show();
//STRIP001 		aBtnLast.Show();
//STRIP001 		aNumFldBitmap.Show();
//STRIP001 		aTimeField.Show();
//STRIP001 		aLbLoopCount.Show();
//STRIP001 		aFtCount.Show();
//STRIP001 		aFiCount.Show();
//STRIP001 		aFtAdjustment.Show();
//STRIP001 		aLbAdjustment.Show();
//STRIP001 		aBtnGetOneObject.Show();
//STRIP001 		aBtnGetAllObjects.Show();
//STRIP001 		aBtnRemoveBitmap.Show();
//STRIP001 		aBtnRemoveAll.Show();
//STRIP001 		aGrpBitmap.Show();
//STRIP001 		aRbtGroup.Show();
//STRIP001 		aRbtBitmap.Show();
//STRIP001 		aFtAdjustment.Show();
//STRIP001 		aLbAdjustment.Show();
//STRIP001 		aBtnCreateGroup.Show();
//STRIP001 		aGrpAnimation.Show();
//STRIP001 
//STRIP001 		aSize = aWinSize;
//STRIP001 
//STRIP001 		//aFltWinSize = GetSizePixel();
//STRIP001 	}
//STRIP001 	SfxDockingWindow::Resize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdAnimationWin::Close()
//STRIP001 {
//STRIP001 	SfxBoolItem aItem( SID_ANIMATION_OBJECTS, FALSE );
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute( 
//STRIP001 		SID_ANIMATION_OBJECTS, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 	SfxDockingWindow::Close();
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::FillInfo( SfxChildWinInfo& rInfo ) const
//STRIP001 {
//STRIP001 	SfxDockingWindow::FillInfo( rInfo ) ;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::AddObj( SdView& rView )
//STRIP001 {
//STRIP001 	// Texteingabemodus beenden, damit Bitmap mit
//STRIP001 	// Objekt identisch ist.
//STRIP001 	if( rView.IsTextEdit() )
//STRIP001 		rView.EndTextEdit();
//STRIP001 
//STRIP001 	// Objekt(e) clonen und den/die Clone(s) in die Liste stellen
//STRIP001 	const SdrMarkList& rMarkList   = rView.GetMarkList();
//STRIP001 	ULONG			   nMarkCount  = rMarkList.GetMarkCount();
//STRIP001 	SdPage* 		   pPage	   = pMyDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 	ULONG			   nCloneCount = pPage->GetObjCount();
//STRIP001 
//STRIP001 	if (nMarkCount > 0)
//STRIP001 	{
//STRIP001 		// Wenn es sich um EIN Animationsobjekt oder ein Gruppenobjekt
//STRIP001 		// handelt, das 'einzeln uebernommen' wurde,
//STRIP001 		// werden die einzelnen Objekte eingefuegt
//STRIP001 		BOOL bAnimObj = FALSE;
//STRIP001 		if( nMarkCount == 1 )
//STRIP001 		{
//STRIP001 			SdrMark*		    pMark = rMarkList.GetMark(0);
//STRIP001 			SdrObject*		    pObject = pMark->GetObj();
//STRIP001 			SdAnimationInfo*    pAnimInfo = rView.GetDoc()->GetAnimationInfo( pObject );
//STRIP001 			UINT32              nInv = pObject->GetObjInventor();
//STRIP001 			UINT16              nId = pObject->GetObjIdentifier();
//STRIP001 
//STRIP001 			// Animated Bitmap (GIF)
//STRIP001 			if( nInv == SdrInventor && nId == OBJ_GRAF && ( (SdrGrafObj*) pObject )->IsAnimated() )
//STRIP001 			{
//STRIP001 				const SdrGrafObj*	pGrafObj = (SdrGrafObj*) pObject;
//STRIP001 				Graphic				aGraphic( pGrafObj->GetTransformedGraphic() );
//STRIP001 				USHORT              nCount = 0;
//STRIP001 
//STRIP001 				if( aGraphic.IsAnimated() )
//STRIP001 					nCount = aGraphic.GetAnimation().Count();
//STRIP001 
//STRIP001 				if( nCount > 0 )
//STRIP001 				{
//STRIP001 					const Animation aAnimation( aGraphic.GetAnimation() );
//STRIP001 
//STRIP001 					for( USHORT i = 0; i < nCount; i++ )
//STRIP001 					{
//STRIP001 						const AnimationBitmap& rAnimBmp = aAnimation.Get( i );
//STRIP001 
//STRIP001 						pBitmapEx = new BitmapEx( rAnimBmp.aBmpEx );
//STRIP001 						aBmpExList.Insert( pBitmapEx, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 						// LoopCount
//STRIP001 						if( i == 0 )
//STRIP001 						{
//STRIP001 							long nLoopCount = aAnimation.GetLoopCount();
//STRIP001 
//STRIP001 							if( !nLoopCount ) // unendlich
//STRIP001 								aLbLoopCount.SelectEntryPos( aLbLoopCount.GetEntryCount() - 1);
//STRIP001 							else
//STRIP001 								aLbLoopCount.SelectEntry( UniString::CreateFromInt32( nLoopCount ) );
//STRIP001 						}
//STRIP001 
//STRIP001 						// Time
//STRIP001 						long nTime = rAnimBmp.nWait;
//STRIP001 						Time* pTime = new Time( 0, 0, nTime / 100, nTime % 100 );
//STRIP001 						aTimeList.Insert( pTime, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 						// Weiterschalten der BitmapListe
//STRIP001 						aBmpExList.Next();
//STRIP001 					}
//STRIP001 					// Nachdem ein animated GIF uebernommen wurde, kann auch nur ein solches erstellt werden
//STRIP001 					aRbtBitmap.Check();
//STRIP001 					aRbtGroup.Enable( FALSE );
//STRIP001 					bAnimObj = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( bAllObjects || ( pAnimInfo && pAnimInfo->bIsMovie ) )
//STRIP001 			{
//STRIP001 				// Mehrere Objekte
//STRIP001 				SdrObjList* pObjList = ((SdrObjGroup*)pObject)->GetSubList();
//STRIP001 
//STRIP001 				for( USHORT nObject = 0; nObject < pObjList->GetObjCount(); nObject++ )
//STRIP001 				{
//STRIP001 					SdrObject* pSnapShot = (SdrObject*) pObjList->GetObj( (ULONG) nObject );
//STRIP001 				
//STRIP001 					pBitmapEx = new BitmapEx( SdrExchangeView::GetObjGraphic( pSnapShot->GetModel(), pSnapShot ).GetBitmapEx() );
//STRIP001 					aBmpExList.Insert( pBitmapEx, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 					// Time
//STRIP001 					Time* pTime = new Time( aTimeField.GetTime() );
//STRIP001 					aTimeList.Insert( pTime, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 					// Clone
//STRIP001 					pPage->InsertObject( pSnapShot->Clone(), aBmpExList.GetCurPos() + 1 );
//STRIP001 					
//STRIP001                     // Weiterschalten der BitmapListe
//STRIP001 					aBmpExList.Next();
//STRIP001 				}
//STRIP001 				bAnimObj = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// Auch ein einzelnes animiertes Objekt
//STRIP001 		if( !bAnimObj && !( bAllObjects && nMarkCount > 1 ) )
//STRIP001 		{
//STRIP001 			pBitmapEx = new BitmapEx( rView.GetAllMarkedGraphic().GetBitmapEx() );
//STRIP001 			aBmpExList.Insert( pBitmapEx, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 			// Time
//STRIP001 			Time* pTime = new Time( aTimeField.GetTime() );
//STRIP001 			aTimeList.Insert( pTime, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 		}
//STRIP001 
//STRIP001 		// ein einzelnes Objekt
//STRIP001 		if( nMarkCount == 1 && !bAnimObj )
//STRIP001 		{
//STRIP001 			SdrMark*	pMark	= rMarkList.GetMark(0);
//STRIP001 			SdrObject*	pObject = pMark->GetObj();
//STRIP001 			SdrObject*	pClone	= pObject->Clone();
//STRIP001 			pPage->InsertObject(pClone, aBmpExList.GetCurPos() + 1);
//STRIP001 		}
//STRIP001 		// mehrere Objekte: die Clones zu einer Gruppe zusammenfassen
//STRIP001 		else if (nMarkCount > 1)
//STRIP001 		{
//STRIP001 			// Objekte einzeln uebernehmen
//STRIP001 			if( bAllObjects )
//STRIP001 			{
//STRIP001 				for( ULONG nObject= 0; nObject < nMarkCount; nObject++ )
//STRIP001 				{
//STRIP001 					// Clone
//STRIP001 					SdrObject* pObject = rMarkList.GetMark( nObject )->GetObj();
//STRIP001 
//STRIP001 					pBitmapEx = new BitmapEx( SdrExchangeView::GetObjGraphic( pObject->GetModel(), pObject ).GetBitmapEx() );
//STRIP001 					aBmpExList.Insert( pBitmapEx, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 					// Time
//STRIP001 					Time* pTime = new Time( aTimeField.GetTime() );
//STRIP001 					aTimeList.Insert( pTime, aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 					pPage->InsertObject( pObject->Clone(), aBmpExList.GetCurPos() + 1 );
//STRIP001 
//STRIP001 					aBmpExList.Next();
//STRIP001 				}
//STRIP001 				bAnimObj = TRUE; // damit nicht nochmal weitergeschaltet wird
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SdrObjGroup* pCloneGroup = new SdrObjGroup;
//STRIP001 				SdrObjList*  pObjList	 = pCloneGroup->GetSubList();
//STRIP001 
//STRIP001 				for (ULONG nObject= 0; nObject < nMarkCount; nObject++)
//STRIP001 					pObjList->InsertObject(rMarkList.GetMark(nObject)->GetObj()->Clone(), LIST_APPEND);
//STRIP001 
//STRIP001 				pPage->InsertObject(pCloneGroup, aBmpExList.GetCurPos() + 1);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bAnimObj )
//STRIP001 			aBmpExList.Next();
//STRIP001 
//STRIP001 		// wenn vorher nichts im Animator war und jetzt was da ist, kann eine
//STRIP001 		// Animationsgruppe erstellt werden
//STRIP001 		if (nCloneCount == 0 && aBmpExList.Count() > 0)
//STRIP001 			aBtnCreateGroup.Enable();
//STRIP001 
//STRIP001 		// Zoom fuer DisplayWin berechnen und setzen
//STRIP001 		Fraction aFrac( GetScale() );
//STRIP001 		aCtlDisplay.SetScale( aFrac );
//STRIP001 
//STRIP001 		UpdateControl( aBmpExList.GetCurPos() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationWin::CreateAnimObj( SdView& rView )
//STRIP001 {
//STRIP001 	Window*		pOutWin = (Window*) rView.GetWin( 0 );
//STRIP001 	DBG_ASSERT( pOutWin, "Window ist nicht vorhanden!" );
//STRIP001 
//STRIP001 	// die Fentermitte ermitteln
//STRIP001 	const MapMode		aMap100( MAP_100TH_MM );
//STRIP001 	Size				aMaxSizeLog;
//STRIP001 	Size				aMaxSizePix;
//STRIP001 	Size				aTemp( pOutWin->GetOutputSizePixel() );
//STRIP001 	const Point			aWindowCenter( pOutWin->PixelToLogic( Point( aTemp.Width() >> 1, aTemp.Height() >> 1 ) ) );
//STRIP001 	const OutputDevice*	pDefDev = Application::GetDefaultDevice();
//STRIP001 	const ULONG			nCount = aBmpExList.Count();
//STRIP001 	BitmapAdjustment	eBA = (BitmapAdjustment) aLbAdjustment.GetSelectEntryPos();
//STRIP001 
//STRIP001 	// Groesste Bitmap ermitteln
//STRIP001 	for( ULONG i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		const BitmapEx& rBmpEx = *static_cast< BitmapEx* >( aBmpExList.GetObject( i ) );
//STRIP001         const Graphic	aGraphic( rBmpEx );
//STRIP001 		Size			aTmpSizeLog;
//STRIP001 		const Size		aTmpSizePix( rBmpEx.GetSizePixel() );
//STRIP001 
//STRIP001 		if ( aGraphic.GetPrefMapMode().GetMapUnit() == MAP_PIXEL )
//STRIP001 			aTmpSizeLog = pDefDev->PixelToLogic( aGraphic.GetPrefSize(), aMap100 );
//STRIP001 		else
//STRIP001 			aTmpSizeLog = pDefDev->LogicToLogic( aGraphic.GetPrefSize(), aGraphic.GetPrefMapMode(), aMap100 );
//STRIP001 
//STRIP001 		aMaxSizeLog.Width() = Max( aMaxSizeLog.Width(), aTmpSizeLog.Width() );
//STRIP001 		aMaxSizeLog.Height() = Max( aMaxSizeLog.Height(), aTmpSizeLog.Height() );
//STRIP001 
//STRIP001 		aMaxSizePix.Width() = Max( aMaxSizePix.Width(), aTmpSizePix.Width() );
//STRIP001 		aMaxSizePix.Height() = Max( aMaxSizePix.Height(), aTmpSizePix.Height() );
//STRIP001 	}
//STRIP001 
//STRIP001 	SdrPageView* pPV = rView.GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 	if( aRbtBitmap.IsChecked() )
//STRIP001 	{
//STRIP001 		// Bitmapgruppe erzeugen (Animated GIF)
//STRIP001 		Animation	aAnimation;
//STRIP001 		Point		aPt;
//STRIP001 
//STRIP001 		for( i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			Time* pTime = static_cast< Time* >( aTimeList.GetObject( i ) );
//STRIP001 			long  nTime = pTime->Get100Sec();
//STRIP001 			nTime += pTime->GetSec() * 100;
//STRIP001 
//STRIP001 			pBitmapEx = static_cast< BitmapEx* >( aBmpExList.GetObject( i ) );
//STRIP001 
//STRIP001 			// Offset fuer die gewuenschte Ausrichtung bestimmen
//STRIP001 			const Size aBmpSize( pBitmapEx->GetSizePixel() );
//STRIP001 
//STRIP001 			switch( eBA )
//STRIP001 			{
//STRIP001 				case BA_LEFT_UP:
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_LEFT:
//STRIP001 					aPt.Y() = (aMaxSizePix.Height() - aBmpSize.Height()) >> 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_LEFT_DOWN:
//STRIP001 					aPt.Y() = aMaxSizePix.Height() - aBmpSize.Height();
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_UP:
//STRIP001 					aPt.X() = (aMaxSizePix.Width() - aBmpSize.Width()) >> 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_CENTER:
//STRIP001 					aPt.X()  = (aMaxSizePix.Width() - aBmpSize.Width()) >> 1;
//STRIP001 					aPt.Y() = (aMaxSizePix.Height() - aBmpSize.Height()) >> 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_DOWN:
//STRIP001 					aPt.X()  = (aMaxSizePix.Width() - aBmpSize.Width()) >> 1;
//STRIP001 					aPt.Y() = aMaxSizePix.Height() - aBmpSize.Height();
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_RIGHT_UP:
//STRIP001 					aPt.X() = aMaxSizePix.Width() - aBmpSize.Width();
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_RIGHT:
//STRIP001 					aPt.X()  = aMaxSizePix.Width() - aBmpSize.Width();
//STRIP001 					aPt.Y() = (aMaxSizePix.Height() - aBmpSize.Height()) >> 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_RIGHT_DOWN:
//STRIP001 					aPt.X()  = aMaxSizePix.Width() - aBmpSize.Width();
//STRIP001 					aPt.Y() = aMaxSizePix.Height() - aBmpSize.Height();
//STRIP001 				break;
//STRIP001 
//STRIP001 			}
//STRIP001 
//STRIP001 			// LoopCount (Anzahl der Durchlaeufe) ermitteln
//STRIP001 			AnimationBitmap aAnimBmp;
//STRIP001 			long            nLoopCount = 0L;
//STRIP001 			USHORT          nPos = aLbLoopCount.GetSelectEntryPos();
//STRIP001 			
//STRIP001             if( nPos != LISTBOX_ENTRY_NOTFOUND && nPos != aLbLoopCount.GetEntryCount() - 1 ) // unendlich
//STRIP001 				nLoopCount = (long) aLbLoopCount.GetSelectEntry().ToInt32();
//STRIP001 
//STRIP001 			aAnimBmp.aBmpEx = *pBitmapEx;
//STRIP001 			aAnimBmp.aPosPix = aPt;
//STRIP001 			aAnimBmp.aSizePix = aBmpSize;
//STRIP001 			aAnimBmp.nWait = nTime;
//STRIP001 			aAnimBmp.eDisposal = DISPOSE_BACK;
//STRIP001 			aAnimBmp.bUserInput = FALSE;
//STRIP001 
//STRIP001 			aAnimation.Insert( aAnimBmp );
//STRIP001 			aAnimation.SetDisplaySizePixel( aMaxSizePix );
//STRIP001 			aAnimation.SetLoopCount( nLoopCount );
//STRIP001 		}
//STRIP001 
//STRIP001 		SdrGrafObj* pGrafObj = new SdrGrafObj( Graphic( aAnimation ) );
//STRIP001 		const Point	aOrg( aWindowCenter.X() - ( aMaxSizeLog.Width() >> 1 ), aWindowCenter.Y() - ( aMaxSizeLog.Height() >> 1 ) );
//STRIP001 
//STRIP001 		pGrafObj->SetLogicRect( Rectangle( aOrg, aMaxSizeLog ) );
//STRIP001 		rView.InsertObject( pGrafObj, *pPV, SDRINSERT_SETDEFLAYER);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Offset fuer die gewuenschte Ausrichtung bestimmen
//STRIP001 		Size aOffset;
//STRIP001 		SdrObject * pClone = NULL;
//STRIP001 		SdPage* pPage = pMyDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 
//STRIP001 		for(i = 0; i < nCount; i++)
//STRIP001 		{
//STRIP001 			pClone = pPage->GetObj(i);
//STRIP001 			Rectangle aRect( pClone->GetSnapRect() );
//STRIP001 
//STRIP001 			switch( eBA )
//STRIP001 			{
//STRIP001 				case BA_LEFT_UP:
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_LEFT:
//STRIP001 					aOffset.Height() = (aMaxSizeLog.Height() - aRect.GetHeight()) / 2;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_LEFT_DOWN:
//STRIP001 					aOffset.Height() = aMaxSizeLog.Height() - aRect.GetHeight();
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_UP:
//STRIP001 					aOffset.Width() = (aMaxSizeLog.Width() - aRect.GetWidth()) / 2;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_CENTER:
//STRIP001 					aOffset.Width()  = (aMaxSizeLog.Width() - aRect.GetWidth()) / 2;
//STRIP001 					aOffset.Height() = (aMaxSizeLog.Height() - aRect.GetHeight()) / 2;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_DOWN:
//STRIP001 					aOffset.Width()  = (aMaxSizeLog.Width() - aRect.GetWidth()) / 2;
//STRIP001 					aOffset.Height() = aMaxSizeLog.Height() - aRect.GetHeight();
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_RIGHT_UP:
//STRIP001 					aOffset.Width() = aMaxSizeLog.Width() - aRect.GetWidth();
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_RIGHT:
//STRIP001 					aOffset.Width()  = aMaxSizeLog.Width() - aRect.GetWidth();
//STRIP001 					aOffset.Height() = (aMaxSizeLog.Height() - aRect.GetHeight()) / 2;
//STRIP001 				break;
//STRIP001 
//STRIP001 				case BA_RIGHT_DOWN:
//STRIP001 					aOffset.Width()  = aMaxSizeLog.Width() - aRect.GetWidth();
//STRIP001 					aOffset.Height() = aMaxSizeLog.Height() - aRect.GetHeight();
//STRIP001 				break;
//STRIP001 
//STRIP001 			}
//STRIP001 			//aRect.SetPos(aWindowCenter + Point(aOffset.Width(), aOffset.Height()));
//STRIP001 			//pClone->SetSnapRect( aRect );
//STRIP001 			// SetSnapRect ist fuer Ellipsen leider nicht implementiert !!!
//STRIP001 			Point aMovePt( aWindowCenter + Point( aOffset.Width(), aOffset.Height() ) - aRect.TopLeft() );
//STRIP001 			Size aMoveSize( aMovePt.X(), aMovePt.Y() );
//STRIP001 			pClone->NbcMove( aMoveSize );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Animationsgruppe erzeugen
//STRIP001 		SdrObjGroup* pGroup   = new SdrObjGroup;
//STRIP001 		SdrObjList*  pObjList = pGroup->GetSubList();
//STRIP001 
//STRIP001 		for (i = 0; i < nCount; i++)
//STRIP001 		{
//STRIP001 			// der Clone verbleibt im Animator; in die Gruppe kommt ein Clone
//STRIP001 			// des Clones
//STRIP001 			pClone = pPage->GetObj(i);
//STRIP001 			SdrObject* pCloneOfClone = pClone->Clone();
//STRIP001 			//SdrObject* pCloneOfClone = pPage->GetObj(i)->Clone();
//STRIP001 			pObjList->InsertObject(pCloneOfClone, LIST_APPEND);
//STRIP001 		}
//STRIP001 
//STRIP001 		// bis jetzt liegt die linke obere Ecke der Gruppe in der Fenstermitte;
//STRIP001 		// jetzt noch um die Haelfte der Groesse nach oben und links korrigieren
//STRIP001 		aTemp = aMaxSizeLog;
//STRIP001 		aTemp.Height() = - aTemp.Height() / 2;
//STRIP001 		aTemp.Width()  = - aTemp.Width() / 2;
//STRIP001 		pGroup->NbcMove(aTemp);
//STRIP001 
//STRIP001 		// Animationsinformation erzeugen
//STRIP001 		SdDrawDocument* pDoc = (SdDrawDocument*)rView.GetModel();
//STRIP001 		SdAnimationInfo* pInfo = new SdAnimationInfo(pDoc);
//STRIP001 		// pInfo->aStart = Point();
//STRIP001 		pInfo->eEffect = presentation::AnimationEffect_NONE;
//STRIP001 		pInfo->eSpeed = presentation::AnimationSpeed_MEDIUM;
//STRIP001 		pInfo->bActive = TRUE;
//STRIP001 		pInfo->bIsMovie = TRUE;
//STRIP001 		pInfo->aBlueScreen = COL_WHITE;
//STRIP001 		pGroup->InsertUserData( pInfo );
//STRIP001 
//STRIP001 		rView.InsertObject( pGroup, *pPV, SDRINSERT_SETDEFLAYER);
//STRIP001 	}
//STRIP001 
//STRIP001 	ClickFirstHdl( this );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ableitung vom SfxChildWindow als "Behaelter" fuer Animator
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
SdAnimationChildWindow::SdAnimationChildWindow( Window* pParent,
														 USHORT nId,
														 SfxBindings* pBindings,
														 SfxChildWinInfo* pInfo ) :
	SfxChildWindow( pParent, nId )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SdAnimationWin* pAnimWin = new SdAnimationWin( pBindings, this, pParent,
//STRIP001 										SdResId( FLT_WIN_ANIMATION ) );
//STRIP001 	pWindow = pAnimWin;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001 	pAnimWin->Initialize( pInfo );
//STRIP001 	/*
//STRIP001 	if ( pInfo->aSize.Width() != 0 && pInfo->aSize.Height() != 0 )
//STRIP001 	{
//STRIP001 		pWindow->SetPosSizePixel( pInfo->aPos, pInfo->aSize );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pWindow->SetPosPixel(SFX_APPWINDOW->OutputToScreenPixel(
//STRIP001 								SFX_APPWINDOW->GetClientAreaPixel().TopLeft()));
//STRIP001 
//STRIP001 	if ( pInfo->nFlags & SFX_CHILDWIN_ZOOMIN )
//STRIP001 		pAnimWin->ZoomIn();
//STRIP001 
//STRIP001 	pAnimWin->aFltWinSize = pWindow->GetSizePixel();
//STRIP001 	*/
//STRIP001 	SetHideNotDelete( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 void SdAnimationWin::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SfxDockingWindow::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		UpdateControl( aBmpExList.GetCurPos() );
//STRIP001 	}
}
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ControllerItem fuer Animator
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdAnimationControllerItem::SdAnimationControllerItem( USHORT nId,
//STRIP001 								SdAnimationWin* pAnimWin,
//STRIP001 								SfxBindings*	pBindings) :
//STRIP001 	SfxControllerItem( nId, *pBindings ),
//STRIP001 	pAnimationWin( pAnimWin )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdAnimationControllerItem::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( eState >= SFX_ITEM_AVAILABLE && nSId == SID_ANIMATOR_STATE )
//STRIP001 	{
//STRIP001 		const SfxUInt16Item* pStateItem = PTR_CAST( SfxUInt16Item, pItem );
//STRIP001 		DBG_ASSERT( pStateItem, "SfxUInt16Item erwartet");
//STRIP001 		UINT16 nState = pStateItem->GetValue();
//STRIP001 
//STRIP001 		pAnimationWin->aBtnGetOneObject.Enable( nState & 1 );
//STRIP001 		pAnimationWin->aBtnGetAllObjects.Enable( nState & 2 );
//STRIP001 	}
//STRIP001 }


}
