/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_speedctl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:24:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef WNT
#include <tools/svwin.h>
#endif // WNT

#include <math.h>
// auto strip #include <tools/time.hxx>
// auto strip #include <tools/poly.hxx>
// auto strip #include <vcl/salbtype.hxx>
// auto strip #include <vcl/svapp.hxx>
#include <vcl/window.hxx>
// auto strip #include "speedctl.hxx"
namespace binfilter {

// -----------
// - Defines -
// -----------

#define SPEED_MAGIC                 0x56789ABC
#define SPEED_SCALINGDIST			10000
#define SPEED_TIMEDIST_MS			40
#define SPEED_MIN_INC			    0.001
#define SPEED_RESCHEDULE			5
#define TIME_TO_MSEC( _aTime )		((_aTime).Seconds*1000UL+(_aTime).Nanosec/1000000)

// --------------
// - DistStruct -
// --------------

struct DistInfo
{
	Point	maPt;
	double	mfCumulatedDist;
};

// ----------------
// - SpeedControl -
// ----------------

//STRIP001 SpeedControl::SpeedControl() :
//STRIP001 	mpWin				( NULL ),
//STRIP001 	mfUnitsPerSec		( 0.0 ),
//STRIP001 	mfCurStep			( 0.0 ),
//STRIP001 	mfLastStep			( 0.0 ),
//STRIP001 	mfCumulatedSteps	( 0.0 ),
//STRIP001 	mfLastCumulatedSteps( 0.0 ),
//STRIP001 	mnLastTime			( 0UL ),
//STRIP001 	mnCurStep			( 0UL ),
//STRIP001 	mnLastStep			( 0UL ),
//STRIP001 	mnMagic     		( SPEED_MAGIC )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SpeedControl::~SpeedControl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SpeedControl::ImplInit( Window* pWin, const double& rUnitsPerSec )
//STRIP001 {
//STRIP001 	mpWin = pWin;
//STRIP001 	mfUnitsPerSec = rUnitsPerSec;
//STRIP001 	mfCurStep =	mfLastStep = mfCumulatedSteps = mfLastCumulatedSteps = 0.0;
//STRIP001 	mnLastTime = 0UL;
//STRIP001 	mnCurStep = mnLastStep = 0UL;
//STRIP001 	mnMagic = SPEED_MAGIC;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SpeedControl::Reset( Window* pWin, const double& rUnitsPerSec )
//STRIP001 {
//STRIP001 	ImplInit( pWin, rUnitsPerSec );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 ULONG SpeedControl::GetNextStep()
//STRIP001 {
//STRIP001 	if( SPEED_MAGIC != mnMagic )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	static ULONG nTimeCount = 0UL;
//STRIP001 
//STRIP001 	if( !mnLastTime )
//STRIP001 		mnLastTime = Time::GetSystemTicks();
//STRIP001 
//STRIP001 	const ULONG	nDiff = Time::GetSystemTicks() - mnLastTime;
//STRIP001 
//STRIP001 	if( nDiff >= SPEED_TIMEDIST_MS )
//STRIP001 	{
//STRIP001 		const double mfCurSpeed = ( mfCumulatedSteps - mfLastCumulatedSteps ) * 1000. / nDiff;
//STRIP001 
//STRIP001 		mfLastStep = mfCurStep;
//STRIP001 
//STRIP001 		if( mfCurSpeed > 0. )
//STRIP001 			mfCurStep *= ( mfUnitsPerSec / mfCurSpeed );
//STRIP001 		else
//STRIP001 			mfCurStep = SPEED_MIN_INC;
//STRIP001 
//STRIP001 		mfCurStep = ( mfCurStep + mfLastStep ) * 0.5;
//STRIP001 		mfLastCumulatedSteps = mfCumulatedSteps;
//STRIP001 
//STRIP001 		// reschedule only a few times
//STRIP001 		if( !( nTimeCount++ % SPEED_RESCHEDULE ) )
//STRIP001 			Application::Reschedule();
//STRIP001 
//STRIP001 		if( SPEED_MAGIC != mnMagic )
//STRIP001 			return 0;
//STRIP001 
//STRIP001 		mnLastTime = Time::GetSystemTicks();
//STRIP001 	}
//STRIP001 
//STRIP001 	mfCumulatedSteps += mfCurStep;
//STRIP001 	mnLastStep = mnCurStep;
//STRIP001 	mnCurStep = (ULONG) ( mfCumulatedSteps + .5 );
//STRIP001 
//STRIP001 	if( ( SPEED_MAGIC == mnMagic ) && mpWin )
//STRIP001 		mpWin->Sync();
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 		Sleep( 1 );
//STRIP001 #endif // WNT
//STRIP001 
//STRIP001 	return( mnCurStep - mnLastStep );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------
//STRIP001 // - MoverSpeedControl -
//STRIP001 // ---------------------
//STRIP001 
//STRIP001 MoverSpeedControl::MoverSpeedControl() :
//STRIP001 	mpDist			( NULL ),
//STRIP001 	mnDistCount		( 0UL ),
//STRIP001 	mnActDistPos	( 0UL ),
//STRIP001 	mfTotalDist		( 0.0 ),
//STRIP001 	mfStartScaleX	( 1.0 ),
//STRIP001 	mfStartScaleY	( 1.0 ),
//STRIP001 	mfEndScaleX		( 1.0 ),
//STRIP001 	mfEndScaleY		( 1.0 ),
//STRIP001 	mbScaleOnly		( FALSE )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 MoverSpeedControl::~MoverSpeedControl()
//STRIP001 {
//STRIP001 	delete[] mpDist;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void MoverSpeedControl::Reset( const Polygon& rPath, Window* pWin, const double& rUnitsPerSec, 
//STRIP001 							   const double& rStartScaleX, const double& rEndScaleX,
//STRIP001 							   const double& rStartScaleY, const double& rEndScaleY )
//STRIP001 {
//STRIP001 	ImplInit( pWin, rUnitsPerSec );
//STRIP001 
//STRIP001 	delete[] mpDist;
//STRIP001 	
//STRIP001 	mnDistCount = rPath.GetSize();
//STRIP001 	mnActDistPos = 0UL;
//STRIP001 	mfStartScaleX = rStartScaleX;
//STRIP001 	mfStartScaleY = rStartScaleY;
//STRIP001 	mfEndScaleX = rEndScaleX;
//STRIP001 	mfEndScaleY = rEndScaleY;
//STRIP001 
//STRIP001 	if( mnDistCount )
//STRIP001 	{
//STRIP001 		Point		aLast( rPath[ 0 ] );
//STRIP001 		DistInfo*	pTmp = ( mpDist = new DistInfo[ mnDistCount ] );
//STRIP001 
//STRIP001 		pTmp->maPt = aLast;
//STRIP001 		pTmp->mfCumulatedDist = 0.0;
//STRIP001 		pTmp++;
//STRIP001 
//STRIP001 		for( USHORT i = 1; i < mnDistCount; i++, pTmp++ )
//STRIP001 		{
//STRIP001 			const Point&	rAct = rPath[ i ];
//STRIP001 			const double	fDistX = rAct.X() - aLast.X();
//STRIP001 			const double	fDistY = rAct.Y() - aLast.Y();
//STRIP001 
//STRIP001 			pTmp->maPt = rAct;
//STRIP001 			pTmp->mfCumulatedDist = ( pTmp - 1 )->mfCumulatedDist + sqrt( fDistX * fDistX + fDistY * fDistY );
//STRIP001 			aLast = rAct;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( mpDist[ mnDistCount - 1 ].mfCumulatedDist != 0.0 )
//STRIP001 		{
//STRIP001 			mfTotalDist = mpDist[ mnDistCount - 1 ].mfCumulatedDist;
//STRIP001 			mbScaleOnly = FALSE;
//STRIP001 		}
//STRIP001 		else if( ( rStartScaleX != 1.0 ) || ( rEndScaleX != 1.0 ) ||
//STRIP001 				 ( rStartScaleY != 1.0 ) || ( rEndScaleY != 1.0 ) )
//STRIP001 		{
//STRIP001 			mfTotalDist = SPEED_SCALINGDIST;
//STRIP001 			mbScaleOnly = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			mfTotalDist = 0.0;
//STRIP001 			mbScaleOnly = FALSE;
//STRIP001 		}
//STRIP001 					
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		mfTotalDist = 0.0;
//STRIP001 		mbScaleOnly = FALSE;
//STRIP001 		mpDist = NULL;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL MoverSpeedControl::GetNextPathPoint( Point& rPt, double& rScaleX, double& rScaleY )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( SPEED_MAGIC != mnMagic )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	if( mpDist )
//STRIP001 	{
//STRIP001 		BOOL bFound = FALSE;
//STRIP001 
//STRIP001 		if( !mnLastTime )
//STRIP001 		{
//STRIP001 			rPt = mpDist[ 0 ].maPt;
//STRIP001 			rScaleX = mfStartScaleX;
//STRIP001 			rScaleY = mfStartScaleY;
//STRIP001 			mnLastTime = Time::GetSystemTicks();
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			GetNextStep();
//STRIP001 
//STRIP001         	if( SPEED_MAGIC != mnMagic )
//STRIP001 				return FALSE;
//STRIP001 
//STRIP001 			if( mfCumulatedSteps <= mfTotalDist )
//STRIP001 			{
//STRIP001 				const double fTau = ( ( mfTotalDist != 0.0 ) ? ( mfCumulatedSteps / mfTotalDist ) : 1.0 );
//STRIP001 
//STRIP001 				if( mbScaleOnly )
//STRIP001 				{
//STRIP001 					rPt = mpDist[ 0 ].maPt;
//STRIP001 					rScaleX = mfStartScaleX + ( mfEndScaleX - mfStartScaleX ) * fTau;
//STRIP001 					rScaleY = mfStartScaleY + ( mfEndScaleY - mfStartScaleY ) * fTau;
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					for( ULONG i = mnActDistPos + 1; i < mnDistCount; i++, mnActDistPos++ )
//STRIP001 					{
//STRIP001 						const DistInfo& rAct = mpDist[ i ];
//STRIP001 
//STRIP001 						if( rAct.mfCumulatedDist >= mfCumulatedSteps )
//STRIP001 						{
//STRIP001 							const DistInfo&	rLast = mpDist[ i - 1UL ];
//STRIP001 							const Point&	rStart = rLast.maPt;
//STRIP001 							const Point&	rEnd = rAct.maPt;
//STRIP001 							const double	fCurSegmentLength = rAct.mfCumulatedDist - rLast.mfCumulatedDist;
//STRIP001 
//STRIP001 							if( fCurSegmentLength != 0.0 )
//STRIP001 							{
//STRIP001 								const double fFact = ( mfCumulatedSteps - rLast.mfCumulatedDist ) / fCurSegmentLength;
//STRIP001 
//STRIP001 								rPt.X() = rStart.X() + FRound( fFact * ( rEnd.X() - rStart.X() ) );
//STRIP001 								rPt.Y() = rStart.Y() + FRound( fFact * ( rEnd.Y() - rStart.Y() ) );
//STRIP001 							}
//STRIP001 							else
//STRIP001 								rPt = rStart;
//STRIP001 
//STRIP001 							rScaleX = mfStartScaleX + ( mfEndScaleX - mfStartScaleX ) * fTau;
//STRIP001 							rScaleY = mfStartScaleY + ( mfEndScaleY - mfStartScaleY ) * fTau;
//STRIP001 							bRet = TRUE;
//STRIP001 							break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bRet )
//STRIP001 		{
//STRIP001 			rPt = mpDist[ mnDistCount - 1 ].maPt;
//STRIP001 			rScaleX = mfEndScaleX;
//STRIP001 			rScaleY = mfEndScaleY;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rPt = Point();
//STRIP001 		rScaleX = rScaleY = 1.0;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
}
