/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_bmcache.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:33:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <limits.h>     // LONG_MAX
#include <tools/solar.h>
// auto strip #include <goodies/grfmgr.hxx>
// auto strip #include "bmcache.hxx"
namespace binfilter {

// eine Struktur fuer die Cache-Eintraege
//STRIP001 struct BitmapCacheEntry
//STRIP001 {
//STRIP001 	const SdPage*   pPage;
//STRIP001     GraphicObject*  pGraphicObject;
//STRIP001     sal_uInt32      nSizeBytes;
//STRIP001 	long		    nZoom;
//STRIP001 };
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Destruktor, loescht die gespeicherten Bitmaps
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BitmapCache::~BitmapCache()
//STRIP001 {
//STRIP001     for( void* pEntry = aEntries.First();  pEntry; pEntry = aEntries.Next() )
//STRIP001     {
//STRIP001 		delete static_cast< BitmapCacheEntry* >( pEntry )->pGraphicObject;
//STRIP001 		delete static_cast< BitmapCacheEntry* >( pEntry );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Cache-Eintrag einfuegen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void BitmapCache::Add(const SdPage* pPage, const Bitmap& rBmp, long nZoom)
//STRIP001 {
//STRIP001 	BitmapCacheEntry*   pEntry = NULL;
//STRIP001 	ULONG               nSizeOfBitmap = rBmp.GetSizeBytes();
//STRIP001 
//STRIP001 	if( nSizeOfBitmap < nMaxSize )
//STRIP001 	{
//STRIP001 		while (nCurSize + nSizeOfBitmap > nMaxSize)
//STRIP001 		{
//STRIP001 			if( aEntries.Count() )
//STRIP001 			{
//STRIP001 				pEntry = (BitmapCacheEntry*) aEntries.Remove(aEntries.Count() - 1);
//STRIP001 				
//STRIP001                 if( pEntry && pEntry->pGraphicObject )
//STRIP001 				{
//STRIP001 					nCurSize -= pEntry->nSizeBytes;
//STRIP001 					delete pEntry->pGraphicObject;
//STRIP001 				}
//STRIP001 				
//STRIP001                 delete pEntry;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		pEntry = new BitmapCacheEntry;
//STRIP001 		pEntry->pPage = pPage;
//STRIP001 		pEntry->pGraphicObject = new GraphicObject( rBmp );
//STRIP001         pEntry->nSizeBytes = nSizeOfBitmap;
//STRIP001 		pEntry->nZoom = nZoom;
//STRIP001 
//STRIP001 		aEntries.Insert( pEntry, (ULONG) 0 );
//STRIP001 		nCurSize += nSizeOfBitmap;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Cache-Eintrag suchen, Bitmap-Zeiger zurueckgeben (NULL, wenn Bitmap nicht
//STRIP001 |* im Cache)
//STRIP001 |* - auf rZoomPercent wird der Zoomfaktor der Bitmap geschrieben
//STRIP001 |* - abs(nZoomTolerance) gibt die maximal erlaubte Abweichung des
//STRIP001 |*	 Zoomfaktors an; ist die Toleranz negativ, so sucht der Cache den
//STRIP001 |*	 "best fit", sonst den "first fit",
//STRIP001 |* - es werden nur Bitmaps mit Zoomfaktoren kleiner oder gleich rZoomPercent
//STRIP001 |*	 beruecksichtigt, um ein Verkleinern der Bitmap beim Zeichnen zu vermeiden
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 const GraphicObject* BitmapCache::Get( const SdPage* pPage, long& rZoomPercent, long nZoomTolerancePercent)
//STRIP001 {
//STRIP001 	BitmapCacheEntry* pEntry  = NULL;
//STRIP001 	GraphicObject* 	  pGraphicObject = NULL;
//STRIP001 
//STRIP001 	if( nZoomTolerancePercent < 0 )
//STRIP001 	{
//STRIP001 	    // "best fit"-Suche
//STRIP001 		long nTolerance = -nZoomTolerancePercent;
//STRIP001 		BitmapCacheEntry* pBest = NULL;
//STRIP001 		long			  nBest = LONG_MAX;
//STRIP001 		long			  nTest = 0L;
//STRIP001 
//STRIP001 		for( ULONG nPos = 0; nPos < aEntries.Count(); nPos++ )
//STRIP001 		{
//STRIP001 			pEntry = (BitmapCacheEntry*) aEntries.GetObject( nPos );
//STRIP001 			
//STRIP001             if( pEntry->pPage == pPage )
//STRIP001 			{
//STRIP001 				nTest = rZoomPercent - pEntry->nZoom;
//STRIP001 				
//STRIP001                 if( nTest >= 0 && nTest < nBest && nTest <= nTolerance )
//STRIP001 					pBest = pEntry;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		
//STRIP001         pEntry = pBest;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001     	// "first fit"-suche
//STRIP001 		for( ULONG nPos = 0; nPos < aEntries.Count(); nPos++ )
//STRIP001 		{
//STRIP001 			pEntry = (BitmapCacheEntry*)aEntries.GetObject( nPos );
//STRIP001 			
//STRIP001             if (pEntry->pPage == pPage && Abs( pEntry->nZoom - rZoomPercent ) <= nZoomTolerancePercent )
//STRIP001 				break;
//STRIP001 			else
//STRIP001 				pEntry = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// was passendes gefunden?
//STRIP001 	if( pEntry )
//STRIP001 	{
//STRIP001 		pGraphicObject = pEntry->pGraphicObject;
//STRIP001 		aEntries.Remove( pEntry );
//STRIP001 		aEntries.Insert( pEntry, (ULONG) 0 );
//STRIP001 		rZoomPercent = pEntry->nZoom;
//STRIP001 	}
//STRIP001 	
//STRIP001     return pGraphicObject;
//STRIP001 }
//STRIP001 
//STRIP001 void BitmapCache::Remove( const SdPage* pPage )
//STRIP001 {
//STRIP001 	for( ULONG nPos = 0; nPos < aEntries.Count();  )
//STRIP001 	{
//STRIP001 		BitmapCacheEntry* pCand = (BitmapCacheEntry*) aEntries.GetObject( nPos );
//STRIP001 		
//STRIP001 		if( pCand->pPage == pPage )
//STRIP001 		{
//STRIP001 			pCand = (BitmapCacheEntry*) aEntries.Remove((ULONG)nPos);
//STRIP001 			delete pCand->pGraphicObject;
//STRIP001 			delete pCand;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nPos++;
//STRIP001 	}
//STRIP001 }


}
