/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_viewshel.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:47:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SVX_RULER_HXX //autogen
#include <bf_svx/ruler.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _B3D_BASE3D_HXX
// auto strip #include "goodies/base3d.hxx"
// auto strip #endif
#ifndef _SVX_FMSHELL_HXX
#include <bf_svx/fmshell.hxx>
#endif
#ifndef SD_WINDOW_UPDATER_HXX
#include "WindowUpdater.hxx"
#endif

#include "app.hrc"
#include "helpids.h"
#include "strings.hrc"
#include "res_bmp.hrc"
// auto strip #include "viewshel.hxx"
#include "sdview.hxx"
// auto strip #include "sdclient.hxx"
#include "sdresid.hxx"
#include "docshell.hxx"
#include "fuslshow.hxx"
#include "drawdoc.hxx"
// auto strip #include "sdpage.hxx"
#include "zoomlist.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "optsitem.hxx"
#include "grviewsh.hxx"
#include "prevchld.hxx"
//STRIP001 #include "preview.hxx"

// #96090#
// auto strip #ifndef _SFXSLSTITM_HXX
// auto strip #include <svtools/slstitm.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif

#ifndef _SD_SDWINDOW_HXX
#include "sdwindow.hxx"
#endif

namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif

#define DELTA_ZOOM  10

// Use magenta as transparency color instead of the standard gray that is
// imported from vcl/image.hxx
#undef IMAGE_STDBTN_COLOR
#undef IMAGE_STDBTN_COLOR_HC
#define IMAGE_STDBTN_COLOR Color(0xff,0x00,0xff)
#define IMAGE_STDBTN_COLOR_HC Color(0xff,0x00,0xff)

/*************************************************************************
|*
|* SFX-Slotmap und Standardinterface deklarieren
|*
\************************************************************************/
/*N*/ TYPEINIT1( SdViewShell, SfxViewShell);

/*************************************************************************
|*
|* gemeinsamer Initialiserungsanteil der beiden Konstruktoren
|*
\************************************************************************/

/*N*/ void SdViewShell::Construct(void)
/*N*/ {
/*N*/ 	pDocSh->Connect(this);
/*N*/ 
/*N*/ 	pZoomList = new ZoomList( this );
/*N*/ 
/*N*/ 	pWindow = NULL;
/*N*/ 	SetActiveWindow(new SdWindow(&GetViewFrame()->GetWindow()));
/*N*/ //    pWindow->GrabFocus();
/*N*/ 
/*N*/ 	// alle Zeiger mit NULL initialisieren
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 	{
/*N*/ 		pHScrlArray[nX] = NULL;
/*N*/ 		pHRulerArray[nX] = NULL;
/*N*/ 
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		{
/*N*/ 			pVScrlArray[nY] = NULL;
/*N*/ 			pVRulerArray[nY] = NULL;
/*N*/ 			pWinArray[nX][nY] = NULL;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	// Splitter zu Anfang aus
/*N*/ 	bIsHSplit = bIsVSplit = FALSE;
/*N*/ 	// Lineal an
/*N*/ 	bHasRuler = TRUE;
/*N*/ 
/*N*/ 	pWindow->SetCenterAllowed(bCenterAllowed);
/*N*/ 
/*N*/ 	pWinArray[0][0] = pWindow;
/*N*/ 	pWinArray[0][0]->SetViewShell(this);
/*N*/ 
/*N*/ 	pHScrlArray[0] = new ScrollBar(&GetViewFrame()->GetWindow(),
/*N*/ 									WinBits(WB_HSCROLL | WB_DRAG));
/*N*/ 	pHScrlArray[0]->EnableRTL (FALSE);
/*N*/     pHScrlArray[0]->SetRange(Range(0, 32000));
/*N*/ 	pHScrlArray[0]->SetScrollHdl(LINK(this, SdViewShell, HScrollHdl));
/*N*/ 	pHScrlArray[0]->Show();
/*N*/ 
/*N*/ 	pVScrlArray[0] = new ScrollBar(&GetViewFrame()->GetWindow(),
/*N*/ 									WinBits(WB_VSCROLL | WB_DRAG));
/*N*/ 	pVScrlArray[0]->SetRange(Range(0, 32000));
/*N*/ 	pVScrlArray[0]->SetScrollHdl(LINK(this, SdViewShell, VScrollHdl));
/*N*/ 	pVScrlArray[0]->Show();
/*N*/ 	aScrBarWH = Size(pVScrlArray[0]->GetSizePixel().Width(),
/*N*/ 					 pHScrlArray[0]->GetSizePixel().Height());
/*N*/ 
/*N*/ 	aHSplit.SetSplitHdl(LINK(this, SdViewShell, SplitHdl));
/*N*/ 	aVSplit.SetSplitHdl(LINK(this, SdViewShell, SplitHdl));
/*N*/ 	aHSplit.Show();
/*N*/ 	aVSplit.Show();
/*N*/ 
/*N*/ 	if (pScrlBox)
/*N*/ 		pScrlBox->Show();
/*N*/ 
/*N*/ 	if( !this->ISA( SdGraphicViewShell ) )
/*N*/ 	{
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aDrawBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_DRAW ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 		aDrawBtn.SetModeImage( Image( Bitmap( SdResId( BMP_SW_DRAW_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 		aDrawBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aDrawBtn.SetQuickHelpText( String( SdResId( STR_DRAW_MODE ) ) );
/*N*/ 		aDrawBtn.SetHelpId( HID_SD_BTN_DRAW );
/*N*/ 		aDrawBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aSlideBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_SLIDE ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 		aSlideBtn.SetModeImage( Image( Bitmap( SdResId( BMP_SW_SLIDE_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 		aSlideBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aSlideBtn.SetQuickHelpText( String( SdResId( STR_SLIDE_MODE ) ) );
/*N*/ 		aSlideBtn.SetHelpId( HID_SD_BTN_SLIDE );
/*N*/ 		aSlideBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aOutlineBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_OUTLINE ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 		aOutlineBtn.SetModeImage( Image( Bitmap( SdResId( BMP_SW_OUTLINE_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 		aOutlineBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aOutlineBtn.SetQuickHelpText( String( SdResId( STR_OUTLINE_MODE ) ) );
/*N*/ 		aOutlineBtn.SetHelpId( HID_SD_BTN_OUTLINE );
/*N*/ 		aOutlineBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aNotesBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_NOTES ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 		aNotesBtn.SetModeImage( Image( Bitmap( SdResId( BMP_SW_NOTES_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 		aNotesBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aNotesBtn.SetQuickHelpText( String( SdResId( STR_NOTES_MODE ) ) );
/*N*/ 		aNotesBtn.SetHelpId( HID_SD_BTN_NOTES );
/*N*/ 		aNotesBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aHandoutBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_HANDOUT ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 		aHandoutBtn.SetModeImage( Image( Bitmap( SdResId( BMP_SW_HANDOUT_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 		aHandoutBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aHandoutBtn.SetQuickHelpText( String( SdResId( STR_HANDOUT_MODE ) ) );
/*N*/ 		aHandoutBtn.SetHelpId( HID_SD_BTN_HANDOUT );
/*N*/ 		aHandoutBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aPresentationBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_PRESENTATION ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 		aPresentationBtn.SetModeImage( Image( Bitmap( SdResId( BMP_SW_PRESENTATION_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 		aPresentationBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aPresentationBtn.SetQuickHelpText( String( SdResId( STR_START_PRESENTATION ) ) );
/*N*/ 		aPresentationBtn.SetHelpId( HID_SD_BTN_PRESENTATION );
/*N*/ 		aPresentationBtn.Show();
/*N*/ 
/*N*/ 		if (pDocSh->IsPreview())
/*N*/ 		{
/*?*/ 			aPresentationBtn.Disable();
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			aPresentationBtn.Enable();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	String aName( RTL_CONSTASCII_USTRINGPARAM( "ViewShell" ));
/*N*/ 	SetName (aName);

/*N*/ 	pDoc->StartOnlineSpelling(FALSE);

/*N*/     mpWindowUpdater->SetViewShell (*this);
/*N*/     mpWindowUpdater->SetDocument (pDoc);
/*N*/ }

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdViewShell::SdViewShell(SfxViewFrame* pFrame, Window *pParent,
/*N*/ 						 BOOL bAllowCenter) :
/*N*/ 	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST	  |
/*N*/ 						 SFX_VIEW_OPTIMIZE_EACH 	  |
/*N*/ 						 SFX_VIEW_DISABLE_ACCELS	  |
/*N*/ 						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
/*N*/ 						 SFX_VIEW_CAN_PRINT           |
/*N*/ 						 SFX_VIEW_HAS_PRINTOPTIONS),
/*N*/     mpWindowUpdater (new ::binfilter::sd::WindowUpdater()),
/*N*/ 	aHSplit(&pFrame->GetWindow(), WB_HSCROLL),
/*N*/ 	aVSplit(&pFrame->GetWindow(), WB_VSCROLL),
/*N*/ 	aDrawBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aSlideBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aOutlineBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aNotesBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aHandoutBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aPresentationBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	pDocSh( (SdDrawDocShell*) GetViewFrame()->GetObjectShell() ),
/*N*/ 	pDoc( pDocSh->GetDoc() ),
/*N*/ 	pFuActual(NULL),
/*N*/ 	pFuOld(NULL),
/*N*/ 	pFuSearch(NULL),
/*N*/ 	pFuSlideShow(NULL),
/*N*/ 	pZoomList(NULL),
/*N*/ 	nCurrentObjectBar(0),
/*N*/ 	bObjectBarSwitchEnabled(TRUE),
/*N*/ 	pFrameView(NULL),
/*N*/ 	bCenterAllowed(bAllowCenter),
/*N*/ 	bStartShowWithDialog( FALSE ),
/*N*/ 	pScrlBox(NULL),
/*N*/ 	pView(NULL),
/*N*/ 	nPrintedHandoutPageNum(1),
/*N*/ 	bPrintDirectSelected( FALSE )
/*N*/ {
/*N*/ 	pScrlBox = new ScrollBarBox(&pFrame->GetWindow(), WB_3DLOOK | WB_SIZEABLE );
/*N*/ 	Construct();
/*N*/ }

/*************************************************************************
|*
|* Copy-Konstruktor
|*
\************************************************************************/

SdViewShell::SdViewShell(SfxViewFrame* pFrame, const SdViewShell& rShell) :
	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST	  |
						 SFX_VIEW_OPTIMIZE_EACH 	  |
						 SFX_VIEW_DISABLE_ACCELS	  |
						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
						 SFX_VIEW_HAS_PRINTOPTIONS),
	aHSplit(&pFrame->GetWindow(), WB_HSCROLL),
	aVSplit(&pFrame->GetWindow(), WB_VSCROLL),
	aDrawBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aSlideBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aOutlineBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aNotesBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aHandoutBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aPresentationBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	pDocSh( (SdDrawDocShell*) GetViewFrame()->GetObjectShell() ),
	pDoc( pDocSh->GetDoc() ),
	pFuActual(NULL),
	pFuOld(NULL),
	pFuSearch(NULL),
	pFuSlideShow(NULL),
	pZoomList(NULL),
	nCurrentObjectBar(0),
	bObjectBarSwitchEnabled(TRUE),
	pFrameView(NULL),
	bCenterAllowed(rShell.bCenterAllowed),
	pScrlBox(NULL),
	pView(NULL),
	nPrintedHandoutPageNum(1),
	bPrintDirectSelected( FALSE )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	pScrlBox = new ScrollBarBox(&pFrame->GetWindow(), WB_3DLOOK | WB_SIZEABLE );
//STRIP001 	Construct();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdViewShell::~SdViewShell()
/*N*/ {
/*N*/ 	CancelSearching();
/*N*/ 
/*N*/ 	pDocSh->Disconnect(this);
/*N*/ 
/*N*/ 	SetWindow(NULL);
/*N*/ 
/*N*/ 	delete pZoomList;
/*N*/ 
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 	{
/*N*/ 		// Zeiger immer gueltig oder NULL
/*N*/ 		delete pHScrlArray[nX];
/*N*/ 		delete pHRulerArray[nX];
/*N*/ 
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		{
/*N*/ 			if ( pVScrlArray[nY] )
/*N*/ 			{
/*N*/ 				delete pVScrlArray[nY];
/*N*/ 				pVScrlArray[nY] = NULL;
/*N*/ 			}
/*N*/ 			if ( pVRulerArray[nY] )
/*N*/ 			{
/*N*/ 				delete pVRulerArray[nY];
/*N*/ 				pVRulerArray[nY] = NULL;
/*N*/ 			}
/*N*/ 			if ( pWinArray[nX][nY] )
/*N*/ 				delete pWinArray[nX][nY];
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Shells fuer Object Bars loeschen
/*N*/ 	// vorm Zerstoeren der ObjectBarShells den Dispatcher flushen
/*N*/ 	GetViewFrame()->GetDispatcher()->Flush();
/*N*/ 
/*N*/ 	SfxShell* pObjBarShell = (SfxShell*)aShellTable.First();
/*N*/ 	while (pObjBarShell)
/*N*/ 	{
/*N*/ 		delete pObjBarShell;
/*N*/ 		pObjBarShell = (SfxShell*)aShellTable.Next();
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pScrlBox;
/*N*/ }

/*************************************************************************
|*
|* Diese Methode deaktiviert und loescht die aktuelle Funktion. Falls es
|* eine alte Funktion gibt, wird sie als aktuelle Funktion eingesetzt und
|* aktiviert.
|*
\************************************************************************/

/*N*/ void SdViewShell::Cancel()
/*N*/ {
/*N*/ 	if (pFuActual && pFuActual != pFuOld)
/*N*/ 	{
/*?*/ 		FuPoor* pTemp = pFuActual;
/*?*/ 		pFuActual	  = NULL;
/*?*/ 		pTemp->Deactivate();
/*?*/ 		delete pTemp;
/*?*/ 	}
/*N*/ 
/*N*/ 	if (pFuOld)
/*N*/ 	{
/*N*/ 		pFuActual = pFuOld;
/*N*/ 		pFuActual->Activate();
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Aktivierung: Arbeitsfenster den Fokus zuweisen
|*
\************************************************************************/

//STRIP001 void SdViewShell::Activate(BOOL bIsMDIActivate)
//STRIP001 {
//STRIP001 	SfxViewShell::Activate(bIsMDIActivate);
//STRIP001 
//STRIP001 	// Laut MI darf keiner GrabFocus rufen, der nicht genau weiss von
//STRIP001 	// welchem Window der Focus gegrabt wird. Da Activate() vom SFX teilweise
//STRIP001 	// asynchron verschickt wird, kann es sein, dass ein falsches Window
//STRIP001 	// den Focus hat (#29682#):
//STRIP001 	//GetViewFrame()->GetWindow().GrabFocus();
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 		if ( pHRulerArray[nX] )
//STRIP001 			pHRulerArray[nX]->SetActive(TRUE);
//STRIP001 	for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		if ( pVRulerArray[nY] )
//STRIP001 			pVRulerArray[nY]->SetActive(TRUE);
//STRIP001 
//STRIP001 	if (bIsMDIActivate)
//STRIP001 	{
//STRIP001 		// Damit der Navigator auch einen aktuellen Status bekommt
//STRIP001 		SfxBoolItem aItem( SID_NAVIGATOR_INIT, TRUE );
//STRIP001 		GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 			SID_NAVIGATOR_INIT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 		SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_EFFECT_STATE, TRUE, FALSE );
//STRIP001 		rBindings.Invalidate( SID_3D_STATE, TRUE, FALSE );
//STRIP001 
//STRIP001 		if (pFuSlideShow && !pFuSlideShow->IsTerminated() )
//STRIP001 		{
//STRIP001 			pFuSlideShow->Activate();
//STRIP001 		}
//STRIP001 		if (pFuActual)
//STRIP001 		{
//STRIP001 			pFuActual->Activate();
//STRIP001 		}
//STRIP001 
//STRIP001 		if(!pDocSh->IsUIActive())
//STRIP001 			UpdatePreview( GetActualPage(), TRUE );
//STRIP001 
//STRIP001 		SdView* pView = GetView();
//STRIP001 
//STRIP001 		if (pView)
//STRIP001 		{
//STRIP001 			pView->ShowMarkHdl(NULL);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ReadFrameViewData( pFrameView );
//STRIP001 
//STRIP001 	pDocSh->Connect(this);
//STRIP001 }

//STRIP001 void SdViewShell::UIActivate( SvInPlaceObject *pIPObj )
//STRIP001 {
//STRIP001 	SfxViewShell::UIActivate(pIPObj);
//STRIP001 
//STRIP001     // #94252# Disable draw view controls when going inactive
//STRIP001     aDrawBtn.Disable();
//STRIP001     aOutlineBtn.Disable();
//STRIP001     aSlideBtn.Disable();
//STRIP001     aNotesBtn.Disable();
//STRIP001     aHandoutBtn.Disable();
//STRIP001     aPresentationBtn.Disable();
//STRIP001 }

//STRIP001 void SdViewShell::UIDeactivate( SvInPlaceObject *pIPObj )
//STRIP001 {
//STRIP001     // #94252# Enable draw view controls when going active
//STRIP001     aDrawBtn.Enable();
//STRIP001     aOutlineBtn.Enable();
//STRIP001     aSlideBtn.Enable();
//STRIP001     aNotesBtn.Enable();
//STRIP001     aHandoutBtn.Enable();
//STRIP001     aPresentationBtn.Enable();
//STRIP001 
//STRIP001 	SfxViewShell::UIDeactivate(pIPObj);
//STRIP001 }

/*************************************************************************
|*
|* Deaktivierung
|*
\************************************************************************/

/*N*/ void SdViewShell::Deactivate(BOOL bIsMDIActivate)
/*N*/ {
/*N*/ 	// View-Attribute an der FrameView merken
/*N*/ 	WriteFrameViewData();
/*N*/ 
/*N*/ 	if (bIsMDIActivate)
/*N*/ 	{
/*N*/ 		if (pFuSlideShow)
/*N*/ 		{
/*?*/ 			pFuSlideShow->Deactivate();
/*N*/ 		}
/*N*/ 		if (pFuActual)
/*N*/ 		{
/*?*/ 			pFuActual->Deactivate();
/*N*/ 		}
/*N*/ 
/*N*/ 		// ggfs. Preview vom Kontext loesen
/*N*/ 		SfxChildWindow* pPreviewChildWindow =
/*N*/ 			GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
/*N*/ 		if (pPreviewChildWindow)
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdPreviewWin* pPreviewWin =
//STRIP001 /*?*/ 				(SdPreviewWin*)pPreviewChildWindow->GetWindow();
//STRIP001 /*?*/ 			if (pPreviewWin && pPreviewWin->GetDoc() == pDoc)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pPreviewWin->SetContext(NULL, 0, NULL);
//STRIP001 /*?*/ 			}
/*?*/ 		}
/*N*/ 
/*N*/ 		SdView* pView = GetView();
/*N*/ 
/*N*/ 		if (pView)
/*N*/ 		{
/*N*/ 			pView->HideMarkHdl(NULL);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 		if ( pHRulerArray[nX] )
/*N*/ 			pHRulerArray[nX]->SetActive(FALSE);
/*N*/ 	for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		if ( pVRulerArray[nY] )
/*N*/ 			pVRulerArray[nY]->SetActive(FALSE);
/*N*/ 
/*N*/ 	SfxViewShell::Deactivate(bIsMDIActivate);
/*N*/ }

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

//STRIP001 BOOL SdViewShell::KeyInput(const KeyEvent& rKEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	BOOL bReturn(FALSE);
//STRIP001 
//STRIP001 	if(pWin)
//STRIP001 	{
//STRIP001 		SetActiveWindow(pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!bReturn)
//STRIP001 	{
//STRIP001 		// #76008#
//STRIP001 		// give key input first to SfxViewShell to give CTRL+Key
//STRIP001 		// (e.g. CTRL+SHIFT+'+', to front) priority.
//STRIP001 		bReturn = SfxViewShell::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!bReturn)
//STRIP001 	{
//STRIP001 		if(pFuSlideShow)
//STRIP001 		{
//STRIP001 			bReturn = pFuSlideShow->KeyInput(rKEvt);
//STRIP001 		}
//STRIP001 		else if(pFuActual)
//STRIP001 		{
//STRIP001 			bReturn = pFuActual->KeyInput(rKEvt);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!bReturn && pWindow)
//STRIP001 	{
//STRIP001 		KeyCode aKeyCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 		if (aKeyCode.IsMod1() && aKeyCode.IsShift()
//STRIP001 			&& aKeyCode.GetCode() == KEY_R)
//STRIP001 		{
//STRIP001 			// 3D-Kontext wieder zerstoeren
//STRIP001 			Base3D* pBase3D = (Base3D*) pWindow->Get3DContext();
//STRIP001 
//STRIP001 			if (pBase3D)
//STRIP001 			{
//STRIP001 				pBase3D->Destroy(pWindow);
//STRIP001 			}
//STRIP001 
//STRIP001 			InvalidateWindows();
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

//STRIP001 void SdViewShell::MouseButtonDown(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	if ( pWin && !pWin->HasFocus() )
//STRIP001 	{
//STRIP001 		pWin->GrabFocus();
//STRIP001 		SetActiveWindow(pWin);
//STRIP001 //		  GetViewFrame()->GetWindow().GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	// MouseEvent in E3dView eintragen
//STRIP001 	pView->SetMouseEvent(rMEvt);
//STRIP001 
//STRIP001 	if (pFuSlideShow)
//STRIP001 	{
//STRIP001 		pFuSlideShow->MouseButtonDown(rMEvt);
//STRIP001 	}
//STRIP001 	else if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->MouseButtonDown(rMEvt);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

//STRIP001 void SdViewShell::MouseMove(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	if ( pWin )
//STRIP001 	{
//STRIP001 		SetActiveWindow(pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	// MouseEvent in E3dView eintragen
//STRIP001 	pView->SetMouseEvent(rMEvt);
//STRIP001 
//STRIP001 	if (pFuSlideShow)
//STRIP001 	{
//STRIP001 		pFuSlideShow->MouseMove(rMEvt);
//STRIP001 	}
//STRIP001 	else if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->MouseMove(rMEvt);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

//STRIP001 void SdViewShell::MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	if ( pWin )
//STRIP001 	{
//STRIP001 		SetActiveWindow(pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	// MouseEvent in E3dView eintragen
//STRIP001 	pView->SetMouseEvent(rMEvt);
//STRIP001 
//STRIP001 	if (pFuSlideShow)
//STRIP001 	{
//STRIP001 		pFuSlideShow->MouseButtonUp(rMEvt);
//STRIP001 	}
//STRIP001 	else if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->MouseButtonUp(rMEvt);
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

//STRIP001 void SdViewShell::Command(const CommandEvent& rCEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 
//STRIP001 	switch( rCEvt.GetCommand() )
//STRIP001 	{
//STRIP001 		case( COMMAND_WHEEL ):
//STRIP001 		case( COMMAND_STARTAUTOSCROLL ):
//STRIP001 		case( COMMAND_AUTOSCROLL ):
//STRIP001 		{
//STRIP001 			const CommandWheelData* pData = rCEvt.GetWheelData();
//STRIP001 
//STRIP001 			if( pData && pData->IsMod1() )
//STRIP001 			{
//STRIP001 			    if( !pDocSh->IsUIActive() )
//STRIP001 			    {
//STRIP001 				    const long	nOldZoom = pWindow->GetZoom();
//STRIP001 				    long		nNewZoom;
//STRIP001 
//STRIP001 				    if( pData->GetDelta() < 0L )
//STRIP001 					    nNewZoom = Max( (long) pWin->GetMinZoom(), (long)(nOldZoom - DELTA_ZOOM) );
//STRIP001 				    else
//STRIP001 					    nNewZoom = Min( (long) pWin->GetMaxZoom(), (long)(nOldZoom + DELTA_ZOOM) );
//STRIP001 
//STRIP001 				    SetZoom( nNewZoom );
//STRIP001 				    GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 				    bDone = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ScrollBar*	pWinHScroll = NULL;
//STRIP001 				ScrollBar*	pWinVScroll = NULL;
//STRIP001 
//STRIP001 				for( USHORT nX = 0; nX < MAX_HSPLIT_CNT && !bDone; nX++ )
//STRIP001 				{
//STRIP001 					for( USHORT nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001 					{
//STRIP001 						if( pWinArray[ nX ][ nY ] == pWin )
//STRIP001 						{
//STRIP001 							bDone = pWin->HandleScrollCommand( rCEvt,
//STRIP001 															   pHScrlArray[ nX ],
//STRIP001 															   pVScrlArray[ nY ] );
//STRIP001 							break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !bDone )
//STRIP001 	{
//STRIP001 		if (pFuSlideShow)
//STRIP001 		{
//STRIP001 			pFuSlideShow->Command(rCEvt);
//STRIP001 		}
//STRIP001 		else if (pFuActual)
//STRIP001 		{
//STRIP001 			pFuActual->Command(rCEvt);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

//STRIP001 void SdViewShell::InnerResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	Point rP = rPos;
//STRIP001 	Size rS = rSize;
//STRIP001 	rS.Width() += aScrBarWH.Width();
//STRIP001 	rS.Height() += aScrBarWH.Height();
//STRIP001 
//STRIP001 	if ( bHasRuler )
//STRIP001 	{
//STRIP001 		long nHRulerOfs = 0;
//STRIP001 
//STRIP001 		if ( !pVRulerArray[0] )
//STRIP001 		{
//STRIP001 			pVRulerArray[0] = CreateVRuler(pWindow);
//STRIP001 			if ( pVRulerArray[0] )
//STRIP001 			{
//STRIP001 				nHRulerOfs = pVRulerArray[0]->GetSizePixel().Width();
//STRIP001 				pVRulerArray[0]->SetActive(TRUE);
//STRIP001 				pVRulerArray[0]->Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( !pHRulerArray[0] )
//STRIP001 		{
//STRIP001 			pHRulerArray[0] = CreateHRuler(pWindow, TRUE);
//STRIP001 			if ( pHRulerArray[0] )
//STRIP001 			{
//STRIP001 				pHRulerArray[0]->SetWinPos(nHRulerOfs);
//STRIP001 				pHRulerArray[0]->SetActive(TRUE);
//STRIP001 				pHRulerArray[0]->Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pVRulerArray[0] )
//STRIP001 			rS.Width() += pVRulerArray[0]->GetSizePixel().Width();
//STRIP001 		if ( pHRulerArray[0] )
//STRIP001 			rS.Height() += pHRulerArray[0]->GetSizePixel().Height();
//STRIP001 	}
//STRIP001 
//STRIP001 	AdjustPosSizePixel(rP, rS);
//STRIP001 }

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

//STRIP001 void SdViewShell::OuterResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	long nHRulerOfs = 0;
//STRIP001 
//STRIP001 	if( !pFuSlideShow || ( ANIMATIONMODE_PREVIEW == pFuSlideShow->GetAnimationMode() ) )
//STRIP001 	{
//STRIP001 		if ( !pVRulerArray[0] )
//STRIP001 		{
//STRIP001 			pVRulerArray[0] = CreateVRuler(pWindow);
//STRIP001 			if ( pVRulerArray[0] )
//STRIP001 			{
//STRIP001 				nHRulerOfs = pVRulerArray[0]->GetSizePixel().Width();
//STRIP001 				pVRulerArray[0]->SetActive(TRUE);
//STRIP001 				pVRulerArray[0]->Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !pHRulerArray[0] )
//STRIP001 		{
//STRIP001 			pHRulerArray[0] = CreateHRuler(pWindow, TRUE);
//STRIP001 			if ( pHRulerArray[0] )
//STRIP001 			{
//STRIP001 				pHRulerArray[0]->SetWinPos(nHRulerOfs);
//STRIP001 				pHRulerArray[0]->SetActive(TRUE);
//STRIP001 				pHRulerArray[0]->Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	AdjustPosSizePixel(rPos, rSize);
//STRIP001 
//STRIP001 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 	Rectangle aVisArea = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 
//STRIP001 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 	{
//STRIP001 		pDocSh->SetVisArea(aVisArea);
//STRIP001 	}
//STRIP001 
//STRIP001 	VisAreaChanged(aVisArea);
//STRIP001 
//STRIP001 	SdView* pView = GetView();
//STRIP001 
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->VisAreaChanged(pWindow);
//STRIP001 	}
//STRIP001 }


/** After a simple consistency check the given values are stored so that
    they can be accessed by the <member>ArrageGUIElements</member> method
    which is finally called and performs the actual adjustment of sizes and
    positions of the GUI elements.
*/
//STRIP001 void SdViewShell::AdjustPosSizePixel(const Point &rNewPos, const Size &rNewSize)
//STRIP001 {
//STRIP001     // Make sure that the new size is not degenerate.
//STRIP001 	if ( !rNewSize.Width() || !rNewSize.Height() )
//STRIP001 		return;
//STRIP001 
//STRIP001     // Remember the new position and size.
//STRIP001 	aViewPos  = rNewPos;
//STRIP001 	aViewSize = rNewSize;
//STRIP001 
//STRIP001     // Rearrange the UI elements to take care of the new position and size.
//STRIP001     ArrangeGUIElements ();
//STRIP001 }

//STRIP001 void SdViewShell::ArrangeGUIElements (void)
//STRIP001 {
//STRIP001 
//STRIP001 	// Rahmen fuer InPlace-Editing berechnen
//STRIP001 	long nLeft = 0;
//STRIP001 	long nTop  = 0;
//STRIP001 
//STRIP001 	if ( bHasRuler )
//STRIP001 	{
//STRIP001 		if ( pVRulerArray[0] )
//STRIP001 			nLeft = pVRulerArray[0]->GetSizePixel().Width();
//STRIP001 		if ( pHRulerArray[0] )
//STRIP001 			nTop  = pHRulerArray[0]->GetSizePixel().Height();
//STRIP001 	}
//STRIP001 
//STRIP001 	long nRight = aScrBarWH.Width();
//STRIP001 	long nBottom = aScrBarWH.Height();
//STRIP001 	BOOL bSlideShowActive = pFuSlideShow != NULL &&
//STRIP001 							!pFuSlideShow->IsTerminated() &&
//STRIP001 							!pFuSlideShow->IsFullScreen() &&
//STRIP001 							pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_SHOW;
//STRIP001 
//STRIP001 	if( !bSlideShowActive )
//STRIP001 	{
//STRIP001 		SvBorder aSvBorder(nLeft, nTop, nRight, nBottom);
//STRIP001 		// der Sfx darf immer nur das erste Fenster setzen
//STRIP001 		SetActiveWindow(pWinArray[0][0]);
//STRIP001 		// Sfx loest ein Resize fuer die Gesamtgroesse aus; bei aktiven Splittern
//STRIP001 		// darf dann nicht der minimale Zoom neu berechnet werden. Falls kein
//STRIP001 		// Splitter aktiv ist, wird die Berechnung am Ende der Methode nachgeholt
//STRIP001 	//	pWinArray[0][0]->SetMinZoomAutoCalc(FALSE);
//STRIP001 		SetBorderPixel(aSvBorder);
//STRIP001 	//	pWinArray[0][0]->SetMinZoomAutoCalc(TRUE);
//STRIP001 		SetActiveWindow(pWindow);
//STRIP001 	}
//STRIP001 
//STRIP001 	Size	aHBarSize;
//STRIP001 	Size	aVBarSize;
//STRIP001 	Size	aHSplitSize = aHSplit.GetSizePixel();
//STRIP001 	Size	aVSplitSize = aVSplit.GetSizePixel();
//STRIP001 	Size	aBtnSize(aScrBarWH);
//STRIP001 	Point	aHSplitPos, aVSplitPos;
//STRIP001 	long	nPosX = aViewPos.X();
//STRIP001 	long	nPosY = aViewPos.Y();
//STRIP001 	long	nSizeX = aViewSize.Width();
//STRIP001 	long	nSizeY = aViewSize.Height();
//STRIP001 	long	nSplitSize = aScrBarWH.Width() / 4;
//STRIP001 	// TabControl oder aehnliches vorhanden?
//STRIP001 	long	aHCtrlWidth = GetHCtrlWidth();
//STRIP001 	nSizeX -= aScrBarWH.Width();
//STRIP001 	nSizeY -= aScrBarWH.Height();
//STRIP001 
//STRIP001 	// Horizontaler Splitter
//STRIP001 	aHSplitPos = aHSplit.GetPosPixel();
//STRIP001 	aHSplitPos.Y() = nPosY + nSizeY;
//STRIP001 	aHSplit.SetDragRectPixel(
//STRIP001 			Rectangle(Point(nPosX, nPosY), Size(nSizeX, nSizeY)),
//STRIP001 			&GetViewFrame()->GetWindow());
//STRIP001 	if ( !bIsHSplit || (bIsHSplit &&
//STRIP001 		(aHSplitPos.X() < nPosX + MIN_SCROLLBAR_SIZE ||
//STRIP001 		 aHSplitPos.X() > nPosX + nSizeX - MIN_SCROLLBAR_SIZE)) )
//STRIP001 	{
//STRIP001 		aHSplitPos.X() = nPosX + nSizeX - nSplitSize;
//STRIP001 		bIsHSplit = FALSE;
//STRIP001 	}
//STRIP001 	CreateHSplitElems(aHSplitPos.X() + nSplitSize);
//STRIP001 	aHSplitSize.Width()  = nSplitSize;
//STRIP001 	aHSplitSize.Height() = aScrBarWH.Height();
//STRIP001 
//STRIP001 	if ( bIsHSplit )
//STRIP001 	{
//STRIP001 		aHSplitPos.Y() -= nSizeY;
//STRIP001 		aHSplitSize.Height() += nSizeY;
//STRIP001 	}
//STRIP001 	aHSplit.SetPosPixel(aHSplitPos);
//STRIP001 	aHSplit.SetSizePixel(aHSplitSize);
//STRIP001 
//STRIP001 	// Horizontale Scrollbars
//STRIP001 	Point aHPos(nPosX + aHCtrlWidth, nPosY + nSizeY );
//STRIP001 	aHBarSize.Width() = aHSplitPos.X() - aHPos.X();
//STRIP001     aHBarSize.Height() = aScrBarWH.Height();
//STRIP001 	if ( aHBarSize.Width() < MIN_SCROLLBAR_SIZE )
//STRIP001 	{
//STRIP001 		aHPos.X() = aHSplitPos.X() - MIN_SCROLLBAR_SIZE;
//STRIP001 		aHBarSize.Width() = MIN_SCROLLBAR_SIZE;
//STRIP001 	}
//STRIP001 	pHScrlArray[0]->SetPosSizePixel(aHPos, aHBarSize);
//STRIP001 	aHPos.X() += aHBarSize.Width() + nSplitSize;
//STRIP001 
//STRIP001 	if ( pHScrlArray[1] )
//STRIP001 	{
//STRIP001 		aHBarSize = pHScrlArray[1]->GetSizePixel();
//STRIP001 		aHBarSize.Width() = nSizeX - aHPos.X();
//STRIP001 		pHScrlArray[1]->SetPosSizePixel(aHPos, aHBarSize);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Modus-Buttons
//STRIP001 	Point aVPos(nPosX + nSizeX, nPosY);
//STRIP001 	if( !this->ISA( SdGraphicViewShell ) )
//STRIP001 	{
//STRIP001 		aDrawBtn.SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 		aVPos.Y() += aBtnSize.Height();
//STRIP001 		aOutlineBtn.SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 		aVPos.Y() += aBtnSize.Height();
//STRIP001 		aSlideBtn.SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 		aVPos.Y() += aBtnSize.Height();
//STRIP001 		aNotesBtn.SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 		aVPos.Y() += aBtnSize.Height();
//STRIP001 		aHandoutBtn.SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 		aVPos.Y() += aBtnSize.Height();
//STRIP001 		aPresentationBtn.SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 		aVPos.Y() += aBtnSize.Height();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Komisch, dass das hier gemacht werden muss.
//STRIP001 		// Eigentlich sollte man meinen, dass das in Construct() reichen wurde.
//STRIP001 		aDrawBtn.Hide();
//STRIP001 		aSlideBtn.Hide();
//STRIP001 		aOutlineBtn.Hide();
//STRIP001 		aNotesBtn.Hide();
//STRIP001 		aHandoutBtn.Hide();
//STRIP001 		aPresentationBtn.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Vertikaler Splitter
//STRIP001 	aVSplitPos = aVSplit.GetPosPixel();
//STRIP001 	aVSplitPos.X() = nPosX + nSizeX;
//STRIP001 	aVSplit.SetDragRectPixel(
//STRIP001 			Rectangle(Point(nPosX, nPosY), Size(nSizeX, nSizeY)),
//STRIP001 			&GetViewFrame()->GetWindow());

//STRIP001 	if ( !bIsVSplit || (bIsVSplit &&
//STRIP001 		(aVSplitPos.Y() < nPosY + MIN_SCROLLBAR_SIZE ||
//STRIP001 		 aVSplitPos.Y() > nPosY + nSizeY - MIN_SCROLLBAR_SIZE)) )
//STRIP001 	{
//STRIP001 		aVSplitPos.Y() = nPosY + nSizeY - nSplitSize;
//STRIP001 		bIsVSplit = FALSE;
//STRIP001 	}

//STRIP001 	CreateVSplitElems(aVSplitPos.Y() + nSplitSize);
//STRIP001 	aVSplitSize.Width()  = aScrBarWH.Width();
//STRIP001 	aVSplitSize.Height() = nSplitSize;
//STRIP001 
//STRIP001 	if ( bIsVSplit )
//STRIP001 	{
//STRIP001 		aVSplitPos.X() -= nSizeX;
//STRIP001 		aVSplitSize.Width() += nSizeX;
//STRIP001 	}
//STRIP001 	aVSplit.SetPosPixel(aVSplitPos);
//STRIP001 	aVSplit.SetSizePixel(aVSplitSize);
//STRIP001 
//STRIP001 	// Vertikaler Scrollbar
//STRIP001 	aVBarSize.Width() = aScrBarWH.Width();
//STRIP001 	aVBarSize.Height() = aVSplitPos.Y() - aVPos.Y();
/*
	if ( aVBarSize.Height() < MIN_SCROLLBAR_SIZE )
	{
		aVPos.Y() = aVSplitPos.Y() - MIN_SCROLLBAR_SIZE;
		aVBarSize.Height() = MIN_SCROLLBAR_SIZE;
	}
*/
//STRIP001 	pVScrlArray[0]->SetPosSizePixel(aVPos, aVBarSize);
//STRIP001 	aVPos.Y() += aVBarSize.Height() + nSplitSize;
//STRIP001 
//STRIP001 	if ( pVScrlArray[1] )
//STRIP001 	{
//STRIP001 		aVBarSize = pVScrlArray[1]->GetSizePixel();
//STRIP001 		aVBarSize.Height() = nSizeY - aVPos.Y();
//STRIP001 		pVScrlArray[1]->SetPosSizePixel(aVPos, aVBarSize);
//STRIP001 		aVPos.Y() += aVBarSize.Height();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pScrlBox)
//STRIP001 		pScrlBox->SetPosSizePixel(aVPos, aBtnSize);
//STRIP001 
//STRIP001 	aAllWindowRect = Rectangle(pWinArray[0][0]->GetPosPixel(),
//STRIP001 							   pWinArray[0][0]->GetSizePixel());
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			Point	aPos;
//STRIP001 			Size	aSize;
//STRIP001 
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001 				if ( nX == 0 )
//STRIP001 				{
//STRIP001 					aPos.X() = nPosX;
//STRIP001 					aSize.Width() = aHSplitPos.X() - nPosX;
//STRIP001 					if ( !bIsHSplit )
//STRIP001 						aSize.Width() = nSizeX;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aPos.X() = pHScrlArray[nX]->GetPosPixel().X();
//STRIP001 					aSize.Width() = pHScrlArray[nX]->GetSizePixel().Width();
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( nY == 0 )
//STRIP001 				{
//STRIP001 					aPos.Y() = nPosY;
//STRIP001 					aSize.Height() = aVSplitPos.Y() - nPosY;
//STRIP001 					if ( !bIsVSplit )
//STRIP001 						aSize.Height() = nSizeY;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aPos.Y() = pVScrlArray[nY]->GetPosPixel().Y();
//STRIP001 					aSize.Height() = pVScrlArray[nY]->GetSizePixel().Height();
//STRIP001 				}
//STRIP001 
//STRIP001 				Size aHRulerSize(0,0);
//STRIP001 				Size aVRulerSize(0,0);
//STRIP001 
//STRIP001 				if ( bHasRuler )
//STRIP001 				{
//STRIP001 					// Lineale am linken und oberen Rand anpassen
//STRIP001 					if ( pHRulerArray[nX] && nY == 0 )
//STRIP001 					{
//STRIP001 						aHRulerSize = pHRulerArray[nX]->GetSizePixel();
//STRIP001 						aHRulerSize.Width() = aSize.Width();
//STRIP001 						pHRulerArray[nX]->SetPosSizePixel(aPos, aHRulerSize);
//STRIP001 						if ( nX == 0 && pVRulerArray[nY] )
//STRIP001 							pHRulerArray[nX]->SetBorderPos(
//STRIP001 								pVRulerArray[nY]->GetSizePixel().Width()-1);
//STRIP001 						aPos.Y() += aHRulerSize.Height();
//STRIP001 						aSize.Height() -= aHRulerSize.Height();
//STRIP001 					}
//STRIP001 					if ( pVRulerArray[nY] && nX == 0 )
//STRIP001 					{
//STRIP001 						aVRulerSize = pVRulerArray[nY]->GetSizePixel();
//STRIP001 						aVRulerSize.Height() = aSize.Height();
//STRIP001 						pVRulerArray[nY]->SetPosSizePixel(aPos, aVRulerSize);
//STRIP001 						aPos.X() += aVRulerSize.Width();
//STRIP001 						aSize.Width() -= aVRulerSize.Width();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( bIsHSplit || bIsVSplit )
//STRIP001 				{
//STRIP001 					pWinArray[nX][nY]->SetPosSizePixel(aPos, aSize);
//STRIP001 					aAllWindowRect.Union(Rectangle(aPos, aSize));
//STRIP001 				}
//STRIP001 				else	// hier wird die oben verhinderte MinZoom-Berechnung
//STRIP001 				{		// nachgeholt
//STRIP001 //					pWinArray[0][0]->CalcMinZoom();
//STRIP001 				}
//STRIP001 				pWinArray[nX][nY]->UpdateMapOrigin();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	UpdateScrollBars();
//STRIP001 }

/*************************************************************************
|*
|* Splitter-Handling
|*
\************************************************************************/

IMPL_LINK( SdViewShell, SplitHdl, Splitter *, pSplit )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Point	aSplitPos = pSplit->GetPosPixel();
//STRIP001 	long	nNewSplit = pSplit->GetSplitPosPixel();
//STRIP001 
//STRIP001 	if ( pSplit == &aHSplit )
//STRIP001 	{
//STRIP001 		bIsHSplit = TRUE;
//STRIP001 		aSplitPos.X() = nNewSplit;
//STRIP001 	}
//STRIP001 	if ( pSplit == &aVSplit )
//STRIP001 	{
//STRIP001 		bIsVSplit = TRUE;
//STRIP001 		aSplitPos.Y() = nNewSplit;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Wenn IP aktiv, wird der IP-Modus abgebrochen
//STRIP001 	SdClient* pIPClient = (SdClient*)GetIPClient();
//STRIP001 	if (pIPClient)
//STRIP001 	{
//STRIP001 		pIPClient->GetProtocol().Reset2Open();
//STRIP001 	}
//STRIP001 
//STRIP001 	pSplit->SetPosPixel(aSplitPos);
//STRIP001 	AdjustPosSizePixel(aViewPos, aViewSize);
	return 0;
}

/*************************************************************************
|*
|* Fenster und ScrollBars fuer Horizontales Splitting erzeugen
|* bzw. entfernen
|*
\************************************************************************/

//STRIP001 void SdViewShell::CreateHSplitElems(long nSplitXPixel)
//STRIP001 {
//STRIP001 	if ( bIsHSplit )
//STRIP001 	{	// ggf. ScrollBars und Fenster erzeugen
//STRIP001 		if ( !pHScrlArray[1] )
//STRIP001 		{
//STRIP001 			pHScrlArray[1] = new ScrollBar(&GetViewFrame()->GetWindow(),
//STRIP001 											WinBits(WB_HSCROLL | WB_DRAG));
//STRIP001 			pHScrlArray[1]->SetRange(Range(0, 32000));
//STRIP001 			pHScrlArray[1]->SetScrollHdl(LINK(this, SdViewShell, HScrollHdl));
//STRIP001 			pHScrlArray[1]->Show();
//STRIP001 
//STRIP001 			pWinArray[1][0] = new SdWindow(&GetViewFrame()->GetWindow());
//STRIP001 			pWinArray[1][0]->SetCenterAllowed(bCenterAllowed);
//STRIP001 			pWinArray[1][0]->SetViewShell(this);
//STRIP001 			Point aPos = pWinArray[0][0]->GetWinViewPos();
//STRIP001 			aPos.X() += pWindow->PixelToLogic(Size(nSplitXPixel, 0)).Width();
//STRIP001 			pWinArray[1][0]->ShareViewArea(pWinArray[0][0]);
//STRIP001 			pWinArray[1][0]->SetWinViewPos(aPos);
//STRIP001 			AddWindow(pWinArray[1][0]);
//STRIP001 			pWinArray[1][0]->Show();
//STRIP001 
//STRIP001 			pHRulerArray[1] = CreateHRuler(pWinArray[1][0], FALSE);
//STRIP001 			if ( bHasRuler && pHRulerArray[1] )
//STRIP001 			{
//STRIP001 				pHRulerArray[1]->Show();
//STRIP001 				pHRulerArray[1]->SetActive(TRUE);
//STRIP001 			}
//STRIP001 			if ( bIsVSplit )
//STRIP001 			{
//STRIP001 				pWinArray[1][1] = new SdWindow(&GetViewFrame()->GetWindow());
//STRIP001 				pWinArray[1][1]->SetCenterAllowed(bCenterAllowed);
//STRIP001 				pWinArray[1][1]->SetViewShell(this);
//STRIP001 				aPos.Y() = pWinArray[0][1]->GetWinViewPos().Y();
//STRIP001 				pWinArray[1][1]->ShareViewArea(pWinArray[1][0]);
//STRIP001 				pWinArray[1][1]->SetWinViewPos(aPos);
//STRIP001 				AddWindow(pWinArray[1][1]);
//STRIP001 				pWinArray[1][1]->Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{	// Nicht benutzte Elemente loeschen
//STRIP001 		delete pHScrlArray[1];
//STRIP001 		pHScrlArray[1] = NULL;
//STRIP001 
//STRIP001 		if ( pWindow == pWinArray[1][0] || pWindow == pWinArray[1][1] )
//STRIP001 		{
//STRIP001 			SetActiveWindow(pWinArray[0][0]);
//STRIP001 		}
//STRIP001 		if ( pWinArray[1][0] )
//STRIP001 			RemoveWindow(pWinArray[1][0]);
//STRIP001 		delete pWinArray[1][0];
//STRIP001 		pWinArray[1][0] = NULL;
//STRIP001 
//STRIP001 		if ( pWinArray[1][1] )
//STRIP001 			RemoveWindow(pWinArray[1][1]);
//STRIP001 		delete pWinArray[1][1];
//STRIP001 		pWinArray[1][1] = NULL;
//STRIP001 
//STRIP001 		delete pHRulerArray[1];
//STRIP001 		pHRulerArray[1] = NULL;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Fenster und ScrollBars fuer Vertikales Splitting erzeugen
|* bzw. entfernen
|*
\************************************************************************/

//STRIP001 void SdViewShell::CreateVSplitElems(long nSplitYPixel)
//STRIP001 {
//STRIP001 	if ( bIsVSplit )
//STRIP001 	{	// ggf. ScrollBars und Fenster erzeugen
//STRIP001 		if ( !pVScrlArray[1] )
//STRIP001 		{
//STRIP001 			pVScrlArray[1] = new ScrollBar(&GetViewFrame()->GetWindow(),
//STRIP001 											WinBits(WB_VSCROLL | WB_DRAG));
//STRIP001 			pVScrlArray[1]->SetRange(Range(0, 32000));
//STRIP001 			pVScrlArray[1]->SetScrollHdl(LINK(this, SdViewShell, VScrollHdl));
//STRIP001 			pVScrlArray[1]->Show();
//STRIP001 
//STRIP001 			pWinArray[0][1] = new SdWindow(&GetViewFrame()->GetWindow());
//STRIP001 			pWinArray[0][1]->SetCenterAllowed(bCenterAllowed);
//STRIP001 			pWinArray[0][1]->SetViewShell(this);
//STRIP001 			Point aPos = pWinArray[0][0]->GetWinViewPos();
//STRIP001 			aPos.Y() += pWindow->PixelToLogic(Size(0, nSplitYPixel)).Height();
//STRIP001 			pWinArray[0][1]->ShareViewArea(pWinArray[0][0]);
//STRIP001 			pWinArray[0][1]->SetWinViewPos(aPos);
//STRIP001 			AddWindow(pWinArray[0][1]);
//STRIP001 			pWinArray[0][1]->Show();
//STRIP001 
//STRIP001 			pVRulerArray[1] = CreateVRuler(pWinArray[0][1]);
//STRIP001 			if ( bHasRuler && pVRulerArray[1] )
//STRIP001 			{
//STRIP001 				pVRulerArray[1]->Show();
//STRIP001 				pVRulerArray[1]->SetActive(TRUE);
//STRIP001 			}
//STRIP001 			if ( bIsHSplit )
//STRIP001 			{
//STRIP001 				pWinArray[1][1] = new SdWindow(&GetViewFrame()->GetWindow());
//STRIP001 				pWinArray[1][1]->SetCenterAllowed(bCenterAllowed);
//STRIP001 				pWinArray[1][1]->SetViewShell(this);
//STRIP001 				aPos.X() = pWinArray[1][0]->GetWinViewPos().X();
//STRIP001 				pWinArray[1][1]->ShareViewArea(pWinArray[0][1]);
//STRIP001 				pWinArray[1][1]->SetWinViewPos(aPos);
//STRIP001 				AddWindow(pWinArray[1][1]);
//STRIP001 				pWinArray[1][1]->Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{	// Nicht benutzte ScrollBars und Fenster loeschen
//STRIP001 		delete pVScrlArray[1];
//STRIP001 		pVScrlArray[1] = NULL;
//STRIP001 
//STRIP001 		if ( pWindow == pWinArray[0][1] || pWindow == pWinArray[1][1] )
//STRIP001 		{
//STRIP001 			SetActiveWindow(pWinArray[0][0]);
//STRIP001 		}
//STRIP001 		if ( pWinArray[0][1] )
//STRIP001 			RemoveWindow(pWinArray[0][1]);
//STRIP001 		delete pWinArray[0][1];
//STRIP001 		pWinArray[0][1] = NULL;
//STRIP001 
//STRIP001 		if ( pWinArray[1][1] )
//STRIP001 			RemoveWindow(pWinArray[1][1]);
//STRIP001 		delete pWinArray[1][1];
//STRIP001 		pWinArray[1][1] = NULL;
//STRIP001 
//STRIP001 		delete pVRulerArray[1];
//STRIP001 		pVRulerArray[1] = NULL;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Metrik setzen
|*
\************************************************************************/

//STRIP001 void SdViewShell::SetUIUnit(FieldUnit eUnit)
//STRIP001 {
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		// Metrik an den horizontalen Linealen setzen
//STRIP001 		if (pHRulerArray[nX])
//STRIP001 		{
//STRIP001 			pHRulerArray[nX]->SetUnit(eUnit);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 	{
//STRIP001 		// Metrik an den vertikalen Linealen setzen
//STRIP001 		if (pVRulerArray[nY])
//STRIP001 		{
//STRIP001 			pVRulerArray[nY]->SetUnit(eUnit);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* DefTab an den horizontalen Linealen setzen
|*
\************************************************************************/
//STRIP001 void SdViewShell::SetDefTabHRuler( UINT16 nDefTab )
//STRIP001 {
//STRIP001 	for (USHORT nIndex=0; nIndex<MAX_HSPLIT_CNT; nIndex++)
//STRIP001 	{
//STRIP001 		if (pHRulerArray[nIndex])
//STRIP001 		{
//STRIP001 			pHRulerArray[nIndex]->SetDefTabDist( nDefTab );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Der FmShell das PrepareClose mitteilen, damit diese ihre Datensaetze
|* speichern kann.
|*
\************************************************************************/
/*N*/ USHORT SdViewShell::PrepareClose( BOOL bUI, BOOL bForBrowsing )
/*N*/ {
/*N*/ 	USHORT nRet = SfxViewShell::PrepareClose( bUI, bForBrowsing );
/*N*/ 
/*N*/ 	if( nRet == TRUE )
/*N*/ 	{
/*N*/ 		FmFormShell* pShell = (FmFormShell*)aShellTable.Get( RID_FORMLAYER_TOOLBOX );
/*N*/ 		if( pShell )
/*N*/ 			nRet = pShell->PrepareClose( bUI, bForBrowsing );
/*N*/ 	}
/*N*/ 
/*N*/ 	return nRet;
/*N*/ }

/*************************************************************************
|*
|* Update preview context
|*
\************************************************************************/
/*N*/ void SdViewShell::UpdatePreview( SdPage* pPage, BOOL bInit )
/*N*/ {
/*N*/ 	SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow( SdPreviewChildWindow::GetChildWindowId() );
/*N*/ 	if ( pPreviewChildWindow )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdPreviewWin* pPreviewWin = (SdPreviewWin*) pPreviewChildWindow->GetWindow();
//STRIP001 /*?*/ 		if ( pPreviewWin && ( bInit || pPreviewWin->GetDoc() == pDoc ) )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			USHORT nSdPageNo = ( pPage->GetPageNum() - 1 ) / 2;
//STRIP001 /*?*/ 			pPreviewWin->SetContext(pDoc, nSdPageNo, pFrameView);
//STRIP001 /*?*/ 		}
/*?*/ 	}
/*N*/ }

// -----------------------------------------------------------------------------

//STRIP001 SfxUndoManager* SdViewShell::ImpGetUndoManager() const
//STRIP001 {
//STRIP001 	return GetViewFrame()->GetDispatcher()->GetShell(0)->GetUndoManager();
//STRIP001 }

//STRIP001 void SdViewShell::ImpGetUndoStrings(SfxItemSet &rSet) const
//STRIP001 {
//STRIP001 	SfxUndoManager* pUndoManager = ImpGetUndoManager();
//STRIP001 	if(pUndoManager)
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount(pUndoManager->GetUndoActionCount());
//STRIP001 		if(nCount)
//STRIP001 		{
//STRIP001 			// prepare list
//STRIP001 			List aStringList;
//STRIP001 
//STRIP001 			for(sal_uInt16 a(0); a < nCount; a++)
//STRIP001 			{
//STRIP001 				// generate one String in list per undo step
//STRIP001 				String* pInsertString = new String(pUndoManager->GetUndoActionComment(a));
//STRIP001 				aStringList.Insert(pInsertString, LIST_APPEND);
//STRIP001 			}
//STRIP001 
//STRIP001 			// set item
//STRIP001 			rSet.Put(SfxStringListItem(SID_GETUNDOSTRINGS, &aStringList));
//STRIP001 
//STRIP001 			// delete Strings again
//STRIP001 			for(a = 0; a < nCount; a++)
//STRIP001 				delete (String*)aStringList.GetObject(a);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_GETUNDOSTRINGS);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdViewShell::ImpGetRedoStrings(SfxItemSet &rSet) const
//STRIP001 {
//STRIP001 	SfxUndoManager* pUndoManager = ImpGetUndoManager();
//STRIP001 	if(pUndoManager)
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount(pUndoManager->GetRedoActionCount());
//STRIP001 		if(nCount)
//STRIP001 		{
//STRIP001 			// prepare list
//STRIP001 			List aStringList;
//STRIP001 
//STRIP001 			for(sal_uInt16 a(0); a < nCount; a++)
//STRIP001 			{
//STRIP001 				// generate one String in list per undo step
//STRIP001 				String* pInsertString = new String(pUndoManager->GetRedoActionComment(a));
//STRIP001 				aStringList.Insert(pInsertString, LIST_APPEND);
//STRIP001 			}
//STRIP001 
//STRIP001 			// set item
//STRIP001 			rSet.Put(SfxStringListItem(SID_GETREDOSTRINGS, &aStringList));
//STRIP001 
//STRIP001 			// delete Strings again
//STRIP001 			for(a = 0; a < nCount; a++)
//STRIP001 				delete (String*)aStringList.GetObject(a);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_GETREDOSTRINGS);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdViewShell::ImpSidUndo(BOOL bDrawViewShell, SfxRequest& rReq)
//STRIP001 {
//STRIP001 	SfxUndoManager* pUndoManager = ImpGetUndoManager();
//STRIP001 	sal_uInt16 nNumber(1);
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	if(pReqArgs)
//STRIP001 	{
//STRIP001 		SfxUInt16Item* pUIntItem = (SfxUInt16Item*)&pReqArgs->Get(SID_UNDO);
//STRIP001 		nNumber = pUIntItem->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nNumber && pUndoManager)
//STRIP001 	{
//STRIP001 		if(bDrawViewShell)
//STRIP001 		{
//STRIP001 			List* pList = pDoc->GetDeletedPresObjList();
//STRIP001 			if( pList )
//STRIP001 				pList->Clear();
//STRIP001 		}
//STRIP001 
//STRIP001 		sal_uInt16 nCount(pUndoManager->GetUndoActionCount());
//STRIP001 		if(nCount >= nNumber)
//STRIP001 		{
//STRIP001 			// #94637# when UndoStack is cleared by ModifyPageUndoAction
//STRIP001 			// the nCount may have changed, so test GetUndoActionCount()
//STRIP001 			while(nNumber-- && pUndoManager->GetUndoActionCount())
//STRIP001 			{
//STRIP001 				pUndoManager->Undo();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// #91081# refresh rulers, maybe UNDO was move of TAB marker in ruler
//STRIP001 		if(bHasRuler)
//STRIP001 		{
//STRIP001 			Invalidate(SID_ATTR_TABSTOP);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// This one is corresponding to the default handling
//STRIP001 	// of SID_UNDO in sfx2
//STRIP001 	GetViewFrame()->GetBindings().InvalidateAll(sal_False);
//STRIP001 
//STRIP001 	rReq.Done();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdViewShell::ImpSidRedo(BOOL bDrawViewShell, SfxRequest& rReq)
//STRIP001 {
//STRIP001 	SfxUndoManager* pUndoManager = ImpGetUndoManager();
//STRIP001 	sal_uInt16 nNumber(1);
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	if(pReqArgs)
//STRIP001 	{
//STRIP001 		SfxUInt16Item* pUIntItem = (SfxUInt16Item*)&pReqArgs->Get(SID_REDO);
//STRIP001 		nNumber = pUIntItem->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nNumber && pUndoManager)
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount(pUndoManager->GetRedoActionCount());
//STRIP001 		if(nCount >= nNumber)
//STRIP001 		{
//STRIP001 			// #94637# when UndoStack is cleared by ModifyPageRedoAction
//STRIP001 			// the nCount may have changed, so test GetRedoActionCount()
//STRIP001 			while(nNumber-- && pUndoManager->GetRedoActionCount())
//STRIP001 			{
//STRIP001 				pUndoManager->Redo();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// #91081# refresh rulers, maybe REDO was move of TAB marker in ruler
//STRIP001 		if(bHasRuler)
//STRIP001 		{
//STRIP001 			Invalidate(SID_ATTR_TABSTOP);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// This one is corresponding to the default handling
//STRIP001 	// of SID_UNDO in sfx2
//STRIP001 	GetViewFrame()->GetBindings().InvalidateAll(sal_False);
//STRIP001 
//STRIP001 	rReq.Done();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdViewShell::ExecReq( SfxRequest& rReq )
//STRIP001 {
//STRIP001     USHORT nSlot = rReq.GetSlot();
//STRIP001     switch( nSlot )
//STRIP001     {
//STRIP001 		case SID_MAIL_SCROLLBODY_PAGEDOWN:
//STRIP001 		{
//STRIP001 			if( pFuActual )
//STRIP001 			{
//STRIP001 				pFuActual->ScrollStart();
//STRIP001 				ScrollLines( 0, -1 );
//STRIP001 				pFuActual->ScrollEnd();
//STRIP001 			}
//STRIP001 			
//STRIP001             rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_OUTPUT_QUALITY_COLOR:
//STRIP001 		case SID_OUTPUT_QUALITY_GRAYSCALE:
//STRIP001 		case SID_OUTPUT_QUALITY_BLACKWHITE:
//STRIP001 		case SID_OUTPUT_QUALITY_CONTRAST:
//STRIP001 		{
//STRIP001 			ULONG nMode = OUTPUT_DRAWMODE_COLOR;
//STRIP001 
//STRIP001             switch( nSlot )
//STRIP001 			{
//STRIP001 			    case SID_OUTPUT_QUALITY_COLOR: nMode = OUTPUT_DRAWMODE_COLOR; break;
//STRIP001 			    case SID_OUTPUT_QUALITY_GRAYSCALE: nMode = OUTPUT_DRAWMODE_GRAYSCALE; break;
//STRIP001 			    case SID_OUTPUT_QUALITY_BLACKWHITE: nMode = OUTPUT_DRAWMODE_BLACKWHITE; break;
//STRIP001 			    case SID_OUTPUT_QUALITY_CONTRAST: nMode = OUTPUT_DRAWMODE_CONTRAST; break;
//STRIP001 			}
//STRIP001 			
//STRIP001 			pWindow->SetDrawMode( nMode );
//STRIP001             pFrameView->SetDrawMode( nMode );
//STRIP001             GetView()->ReleaseMasterPagePaintCache();
//STRIP001 			pWindow->Invalidate();
//STRIP001 
//STRIP001 			Invalidate();
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001         case SID_PREVIEW_QUALITY_COLOR:
//STRIP001         case SID_PREVIEW_QUALITY_GRAYSCALE:
//STRIP001         case SID_PREVIEW_QUALITY_BLACKWHITE:
//STRIP001         case SID_PREVIEW_QUALITY_CONTRAST:
//STRIP001         {
//STRIP001 	        ULONG nMode = PREVIEW_DRAWMODE_COLOR;
//STRIP001 	        
//STRIP001             switch( nSlot )
//STRIP001 	        {
//STRIP001 		        case SID_PREVIEW_QUALITY_COLOR: nMode = PREVIEW_DRAWMODE_COLOR; break;
//STRIP001 		        case SID_PREVIEW_QUALITY_GRAYSCALE: nMode = PREVIEW_DRAWMODE_GRAYSCALE; break;
//STRIP001 		        case SID_PREVIEW_QUALITY_BLACKWHITE: nMode = PREVIEW_DRAWMODE_BLACKWHITE; break;
//STRIP001 		        case SID_PREVIEW_QUALITY_CONTRAST: nMode = PREVIEW_DRAWMODE_CONTRAST; break;
//STRIP001 	        }
//STRIP001 
//STRIP001             SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 	        SdPreviewWin*	pPreviewWin = (SdPreviewWin*) ( pPreviewChildWindow ? pPreviewChildWindow->GetWindow() : NULL );
//STRIP001 	        FuSlideShow*	pShow = pPreviewWin ? pPreviewWin->GetSlideShow() : NULL;
//STRIP001             SdShowWindow*   pShowWindow = const_cast< SdShowWindow* >( pShow ? pShow->GetShowWindow() : NULL );
//STRIP001 
//STRIP001 	        if( pShowWindow )
//STRIP001             {
//STRIP001                 pShowWindow->SetDrawMode( nMode );
//STRIP001                 pShow->Resize( pShowWindow->GetOutputSizePixel() );
//STRIP001                 pShowWindow->Invalidate();
//STRIP001             }
//STRIP001 
//STRIP001 	        pFrameView->SetPreviewDrawMode( nMode );
//STRIP001 	        SdOptions* pOptions = SD_MOD()->GetSdOptions( pDoc->GetDocumentType() );
//STRIP001 	        pOptions->SetPreviewQuality( nMode );
//STRIP001 			            
//STRIP001             Invalidate();
//STRIP001 	        rReq.Done();
//STRIP001         }
//STRIP001         break;
//STRIP001     }
//STRIP001 }




/** This default implemenation returns only an empty reference.  See derived
    classes for more interesting examples.
*/
//STRIP001 ::com::sun::star::uno::Reference<
//STRIP001     ::com::sun::star::accessibility::XAccessible> 
//STRIP001 SdViewShell::CreateAccessibleDocumentView (SdWindow* pWindow)
//STRIP001 {
//STRIP001     return ::com::sun::star::uno::Reference<
//STRIP001         ::com::sun::star::accessibility::XAccessible> ();
//STRIP001 }



//STRIP001 ::sd::WindowUpdater* SdViewShell::GetWindowUpdater (void) const
//STRIP001 {
//STRIP001     return mpWindowUpdater.get();
//STRIP001 }
}
