/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_sfxpicklist.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:29:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SVTOOLS_HISTORYOPTIONS_HXX
#include <svtools/historyoptions.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_MENUCONFIGURATION_HXX_
#include <framework/menuconfiguration.hxx>
#endif

#ifndef _INETHIST_HXX
#include <svtools/inethist.hxx>
#endif

#ifndef _SFXSTRITEM_HXX
#include <svtools/stritem.hxx>
#endif

#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#include <shell/systemshell.hxx>

// ----------------------------------------------------------------------------

#include "app.hxx"
#include "sfxpicklist.hxx"
#include "sfxuno.hxx"
#include "sfxtypes.hxx"
#include "request.hxx"
#include "sfxsids.hrc"
#include "sfx.hrc"
#include "event.hxx"
#include "objsh.hxx"
#include "docinf.hxx"
#include "bindings.hxx"
#include "referers.hxx"
#include "docfile.hxx"
#include "objshimp.hxx"
#include "docfilt.hxx"

#include <algorithm>
namespace binfilter {

// ----------------------------------------------------------------------------

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::util;

// ----------------------------------------------------------------------------

osl::Mutex*		SfxPickList::pMutex = 0;
SfxPickList*	SfxPickList::pUniqueInstance = 0;

// ----------------------------------------------------------------------------

class StringLength : public ::cppu::WeakImplHelper1< XStringWidth >
{
	public:
		StringLength() {}
		virtual ~StringLength() {}

		// XStringWidth
		sal_Int32 SAL_CALL queryStringWidth( const ::rtl::OUString& aString )
			throw (::com::sun::star::uno::RuntimeException)
		{
			return aString.getLength();
		}
};

// ----------------------------------------------------------------------------

/*N*/ osl::Mutex*	SfxPickList::GetOrCreateMutex()
/*N*/ {
/*N*/ 	if ( !pMutex )
/*N*/ 	{
/*N*/ 		::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
/*N*/ 		if ( !pMutex )
/*N*/ 			pMutex = new osl::Mutex;
/*N*/ 	}
/*N*/ 
/*N*/ 	return pMutex;
/*N*/ }

//STRIP001 void SfxPickList::CreatePicklistMenuTitle( Menu* pMenu, USHORT nItemId, const String& aURLString, sal_uInt32 nNo )
//STRIP001 {
//STRIP001 #ifdef MAC
//STRIP001 	String aPickEntry;
//STRIP001 #else
//STRIP001 	String aPickEntry;
//STRIP001 
//STRIP001 	if ( nNo < 9 )
//STRIP001 	{
//STRIP001 		aPickEntry += '~';
//STRIP001 		aPickEntry += String::CreateFromInt32( nNo + 1 );
//STRIP001 	}
//STRIP001 	else if ( nNo == 9 )
//STRIP001 		aPickEntry += DEFINE_CONST_UNICODE("1~0");
//STRIP001 	else
//STRIP001 		aPickEntry += String::CreateFromInt32( nNo + 1 );
//STRIP001 	aPickEntry += DEFINE_CONST_UNICODE(": ");
//STRIP001 #endif
//STRIP001 
//STRIP001 	INetURLObject	aURL( aURLString );
//STRIP001 	::rtl::OUString	aTipHelpText;
//STRIP001 	::rtl::OUString	aAccessibleName( aPickEntry );
//STRIP001 
//STRIP001 	if ( aURL.GetProtocol() == INET_PROT_FILE )
//STRIP001 	{
//STRIP001 		// Do handle file URL differently => convert it to a system
//STRIP001 		// path and abbreviate it with a special function:
//STRIP001 		String aFileSystemPath( aURL.getFSysPath( INetURLObject::FSYS_DETECT ) );
//STRIP001 
//STRIP001 //		::utl::LocalFileHelper::ConvertURLToPhysicalName( aURLString, aPhysicalName );
//STRIP001 
//STRIP001 		::rtl::OUString	aSystemPath( aFileSystemPath );
//STRIP001 		::rtl::OUString	aCompactedSystemPath;
//STRIP001 
//STRIP001 		aTipHelpText = aSystemPath;
//STRIP001 		aAccessibleName += aSystemPath;
//STRIP001 		oslFileError nError = osl_abbreviateSystemPath( aSystemPath.pData, &aCompactedSystemPath.pData, 46, NULL );
//STRIP001 		if ( !nError )
//STRIP001 			aPickEntry += String( aCompactedSystemPath );
//STRIP001 		else
//STRIP001 			aPickEntry += aFileSystemPath;
//STRIP001 
//STRIP001 		if ( aPickEntry.Len() > 50 )
//STRIP001 		{
//STRIP001 			aPickEntry.Erase( 47 );
//STRIP001 			aPickEntry += DEFINE_CONST_UNICODE("...");
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Use INetURLObject to abbreviate all other URLs
//STRIP001 		String	aShortURL;
//STRIP001 		aShortURL = aURL.getAbbreviated( m_xStringLength, 46, INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 		aPickEntry += aShortURL;
//STRIP001 		aTipHelpText = aURLString;
//STRIP001 		aAccessibleName += aURLString;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Set menu item text, tip help and accessible name
//STRIP001 	pMenu->SetItemText( nItemId, aPickEntry );
//STRIP001 	pMenu->SetTipHelpText( nItemId, aTipHelpText );
//STRIP001 	pMenu->SetAccessibleName( nItemId, aAccessibleName );
//STRIP001 }

//STRIP001 void SfxPickList::RemovePickListEntries()
//STRIP001 {
//STRIP001 	::osl::MutexGuard aGuard( GetOrCreateMutex() );
//STRIP001 	for ( sal_uInt32 i = 0; i < m_aPicklistVector.size(); i++ )
//STRIP001 		delete m_aPicklistVector[i];
//STRIP001 	m_aPicklistVector.clear();
//STRIP001 }

//STRIP001 SfxPickList::PickListEntry*	SfxPickList::GetPickListEntry( sal_uInt32 nIndex )
//STRIP001 {
//STRIP001 	OSL_ASSERT( m_aPicklistVector.size() > nIndex );
//STRIP001 
//STRIP001 	if ( nIndex < m_aPicklistVector.size() )
//STRIP001 		return m_aPicklistVector[ nIndex ];
//STRIP001 	else
//STRIP001 		return 0;
//STRIP001 }

/*N*/ SfxPickList*	SfxPickList::GetOrCreate( const ULONG nMenuSize )
/*N*/ {
/*N*/ 	if ( !pUniqueInstance )
/*N*/ 	{
/*N*/ 		::osl::MutexGuard aGuard( GetOrCreateMutex() );
/*N*/ 		if ( !pUniqueInstance )
/*N*/ 			pUniqueInstance = new SfxPickList( nMenuSize );
/*N*/ 	}
/*N*/ 
/*N*/ 	return pUniqueInstance;
/*N*/ }

//STRIP001 SfxPickList* SfxPickList::Get()
//STRIP001 {
//STRIP001 	::osl::MutexGuard aGuard( GetOrCreateMutex() );
//STRIP001 	return pUniqueInstance;
//STRIP001 }

//STRIP001 void SfxPickList::Delete()
//STRIP001 {
//STRIP001 	::osl::MutexGuard aGuard( GetOrCreateMutex() );
//STRIP001 	DELETEZ( pUniqueInstance );
//STRIP001 }

/*N*/ SfxPickList::SfxPickList( sal_uInt32 nAllowedMenuSize ) :
/*N*/ 	m_nAllowedMenuSize( nAllowedMenuSize )
/*N*/ {
/*N*/ 	m_xStringLength = new StringLength;
/*N*/ 	m_nAllowedMenuSize = ::std::min( m_nAllowedMenuSize, (sal_uInt32)PICKLIST_MAXSIZE );
/*N*/ 	StartListening( *SFX_APP() );
/*N*/ }

//STRIP001 SfxPickList::~SfxPickList()
//STRIP001 {
//STRIP001 	RemovePickListEntries();
//STRIP001 }

//STRIP001 void SfxPickList::CreatePickListEntries()
//STRIP001 {
//STRIP001 	RemovePickListEntries();
//STRIP001 
//STRIP001 	// Einlesen der Pickliste
//STRIP001 	Sequence< Sequence< PropertyValue > > seqPicklist = SvtHistoryOptions().GetList( ePICKLIST );
//STRIP001 
//STRIP001 	sal_uInt32 nCount	= seqPicklist.getLength();
//STRIP001 	sal_uInt32 nEntries	= ::std::min( m_nAllowedMenuSize, nCount );
//STRIP001 
//STRIP001 	for( sal_uInt32 nItem=0; nItem < nEntries; ++nItem )
//STRIP001 	{
//STRIP001 		Sequence< PropertyValue > seqPropertySet = seqPicklist[ nItem ];
//STRIP001 
//STRIP001 		INetURLObject	aURL;
//STRIP001 		::rtl::OUString sURL;
//STRIP001 		::rtl::OUString sFilter;
//STRIP001 		::rtl::OUString sTitle;
//STRIP001 		::rtl::OUString sPassword;
//STRIP001 
//STRIP001 		sal_uInt32 nPropertyCount = seqPropertySet.getLength();
//STRIP001 		for( sal_uInt32 nProperty=0; nProperty<nPropertyCount; ++nProperty )
//STRIP001 		{
//STRIP001 			if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_URL )
//STRIP001 			{
//STRIP001 				seqPropertySet[nProperty].Value >>= sURL;
//STRIP001 			}
//STRIP001 			else if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_FILTER )
//STRIP001 			{
//STRIP001 				seqPropertySet[nProperty].Value >>= sFilter;
//STRIP001 			}
//STRIP001 			else if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_TITLE )
//STRIP001 			{
//STRIP001 				seqPropertySet[nProperty].Value >>= sTitle;
//STRIP001 			}
//STRIP001 			else if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_PASSWORD )
//STRIP001 			{
//STRIP001 				seqPropertySet[nProperty].Value >>= sPassword;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		aURL.SetSmartURL( sURL );
//STRIP001 		aURL.SetPass( SfxStringDecode( sPassword ) );
//STRIP001 
//STRIP001 		PickListEntry *pPick = new PickListEntry( aURL.GetMainURL( INetURLObject::NO_DECODE ), sFilter, sTitle );
//STRIP001 		m_aPicklistVector.push_back( pPick );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxPickList::CreateMenuEntries( Menu* pMenu )
//STRIP001 {
//STRIP001 	static sal_Bool	bPickListMenuInitializing = sal_False;
//STRIP001 
//STRIP001 	::osl::MutexGuard aGuard( GetOrCreateMutex() );
//STRIP001 
//STRIP001 	if ( bPickListMenuInitializing ) // method is not reentrant!
//STRIP001 		return;
//STRIP001 
//STRIP001 	bPickListMenuInitializing = sal_True;
//STRIP001 	CreatePickListEntries();
//STRIP001 
//STRIP001     for ( sal_uInt16 nId = START_ITEMID_PICKLIST; nId <= END_ITEMID_PICKLIST; ++nId )
//STRIP001         pMenu->RemoveItem( pMenu->GetItemPos( nId ) );
//STRIP001 
//STRIP001 	if ( pMenu->GetItemType( pMenu->GetItemCount()-1 ) == MENUITEM_SEPARATOR )
//STRIP001         pMenu->RemoveItem( pMenu->GetItemCount()-1 );
//STRIP001 
//STRIP001     if ( m_aPicklistVector.size() > 0 &&
//STRIP001          pMenu->GetItemType( pMenu->GetItemCount()-1 )
//STRIP001             != MENUITEM_SEPARATOR && m_nAllowedMenuSize )
//STRIP001         pMenu->InsertSeparator();
//STRIP001 
//STRIP001 	::rtl::OUString aEmptyString;
//STRIP001 	for ( sal_uInt32 i = 0; i < m_aPicklistVector.size(); i++ )
//STRIP001 	{
//STRIP001 		PickListEntry* pEntry = GetPickListEntry( i );
//STRIP001 
//STRIP001 		pMenu->InsertItem( (USHORT)(START_ITEMID_PICKLIST + i), aEmptyString );
//STRIP001 		CreatePicklistMenuTitle( pMenu, (USHORT)(START_ITEMID_PICKLIST + i), pEntry->aName, i );
//STRIP001 	}
//STRIP001 
//STRIP001 	bPickListMenuInitializing = sal_False;
//STRIP001 }

//STRIP001 void SfxPickList::ExecuteEntry( sal_uInt32 nIndex )
//STRIP001 {
//STRIP001 	::osl::ClearableMutexGuard aGuard( GetOrCreateMutex() );
//STRIP001 
//STRIP001 	PickListEntry *pPick = SfxPickList::Get()->GetPickListEntry( nIndex );
//STRIP001 
//STRIP001 	if ( pPick )
//STRIP001 	{
//STRIP001 		SfxRequest aReq( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, SFX_APP()->GetPool() );
//STRIP001 		aReq.AppendItem( SfxStringItem( SID_FILE_NAME, pPick->aName ));
//STRIP001 		aReq.AppendItem( SfxStringItem( SID_REFERER, DEFINE_CONST_UNICODE( SFX_REFERER_USER ) ) );
//STRIP001         aReq.AppendItem( SfxStringItem( SID_TARGETNAME, DEFINE_CONST_UNICODE("_default") ) );
//STRIP001 		String aFilter( pPick->aFilter );
//STRIP001 		aGuard.clear();
//STRIP001 
//STRIP001 		USHORT nPos=aFilter.Search('|');
//STRIP001 		if( nPos != STRING_NOTFOUND )
//STRIP001 		{
//STRIP001 			String aOptions(aFilter.Copy( nPos ).GetBuffer()+1);
//STRIP001 			aFilter.Erase( nPos );
//STRIP001 			aReq.AppendItem( SfxStringItem(SID_FILE_FILTEROPTIONS, aOptions));
//STRIP001 		}
//STRIP001 
//STRIP001 		aReq.AppendItem(SfxStringItem( SID_FILTER_NAME, aFilter ));
//STRIP001 		aReq.AppendItem( SfxBoolItem( SID_TEMPLATE, sal_False ) );
//STRIP001 		SFX_APP()->ExecuteSlot( aReq );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxPickList::ExecuteMenuEntry( USHORT nId )
//STRIP001 {
//STRIP001 	ExecuteEntry( (sal_uInt32)( nId - START_ITEMID_PICKLIST ) );
//STRIP001 }

//STRIP001 String SfxPickList::GetMenuEntryTitle( sal_uInt32 nIndex )
//STRIP001 {
//STRIP001 	PickListEntry *pPick = SfxPickList::Get()->GetPickListEntry( nIndex );
//STRIP001 
//STRIP001 	if ( pPick )
//STRIP001 		return pPick->aTitle;
//STRIP001 	else
//STRIP001 		return String();
//STRIP001 }

/*N*/ void SfxPickList::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	if ( rHint.IsA( TYPE( SfxStringHint )))
/*N*/ 	{
/*N*/ 		SfxStringHint* pStringHint = (SfxStringHint*) &rHint;
/*N*/ 
/*N*/ 		if ( pStringHint->GetId() == SID_OPENURL )
/*N*/ 			INetURLHistory::GetOrCreate()->PutUrl( INetURLObject( pStringHint->GetObject() ));
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( rHint.IsA( TYPE( SfxEventHint )))
/*N*/ 	{
/*N*/ 		SfxEventHint* pEventHint = PTR_CAST(SfxEventHint,&rHint);
/*N*/ 		// nur ObjectShell-bezogene Events mit Medium interessieren
/*N*/ 		SfxObjectShell* pDocSh = pEventHint->GetObjShell();
/*N*/ 		if( !pDocSh )
/*N*/ 			return;
/*N*/ 
/*N*/ 		switch ( pEventHint->GetEventId() )
/*N*/ 		{
/*N*/ 			case SFX_EVENT_CREATEDOC:
/*N*/ 			{
/*N*/ 				pDocSh->GetDocInfo().SetCreated( SvtUserOptions().GetFullName() );
/*N*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/             case SFX_EVENT_OPENDOC:
/*N*/             {
/*N*/                 SfxMedium *pMed = pDocSh->GetMedium();
/*N*/                 if( !pMed )
/*N*/                     return;
/*N*/ 
/*N*/                 // unbenannt-Docs und embedded-Docs nicht in History
/*N*/                 if ( !pDocSh->HasName() ||
/*N*/                      SFX_CREATE_MODE_STANDARD != pDocSh->GetCreateMode() )
/*N*/                     return;
/*N*/ 
/*N*/                 // Hilfe nicht in History
/*N*/ 				INetURLObject aURL( pMed->GetOrigURL() );
/*N*/                 if ( aURL.GetProtocol() != INET_PROT_VND_SUN_STAR_HELP )
/*N*/                 {
/*N*/                     ::rtl::OUString     aTitle = pDocSh->GetTitle(SFX_TITLE_PICKLIST);
/*N*/                     ::rtl::OUString     aFilter;
/*N*/ 
/*N*/                     const SfxFilter*    pFilter = pMed->GetOrigFilter();
/*N*/                     if ( pFilter )
/*N*/                         aFilter = pFilter->GetFilterName();
/*N*/ 
/*N*/                     // add to svtool history options
/*N*/                     SvtHistoryOptions().AppendItem( eHISTORY,
/*N*/                             aURL.GetURLNoPass( INetURLObject::NO_DECODE ),
/*N*/                             aFilter,
/*N*/                             aTitle,
/*N*/                             SfxStringEncode( aURL.GetPass() ) );
/*N*/                 }
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/ 			case SFX_EVENT_CLOSEDOC:
/*N*/ 			{
/*N*/ 				SfxMedium *pMed = pDocSh->GetMedium();
/*N*/ 				if( !pMed )
/*N*/ 					return;
/*N*/ 
/*N*/ 				// unbenannt-Docs und embedded-Docs nicht in Pickliste
/*N*/ 				if ( !pDocSh->HasName() ||
/*N*/ 					 SFX_CREATE_MODE_STANDARD != pDocSh->GetCreateMode() )
/*N*/ 					return;
/*N*/ 
/*N*/ 				if( pDocSh->Get_Impl()->bWaitingForPicklist &&
/*N*/ 					!pDocSh->Get_Impl()->bIsHelpObjSh )
/*N*/ 				{
/*N*/ 					// only add r/w document into picklist
/*N*/ 					SfxMedium *pMed = pDocSh->GetMedium();
/*N*/ 					if( !pMed || pDocSh->IsReadOnly() || !pMed->IsUpdatePickList() )
/*N*/ 						return;
/*N*/ 
/*N*/ 					// add no document that forbids this (for example Message-Body)
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_ITEMSET_ARG( pMed->GetItemSet(), pPicklistItem, SfxBoolItem, SID_PICKLIST, sal_False );
//STRIP001 /*?*/ 					if ( pPicklistItem && !pPicklistItem->GetValue() )
//STRIP001 /*?*/ 						return;
//STRIP001 /*?*/ 
//STRIP001 /*?*/                     // ignore hidden documents
//STRIP001 /*?*/                     if ( pDocSh->Get_Impl()->bHidden )
//STRIP001 /*?*/                         return;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					::rtl::OUString		aTitle = pDocSh->GetTitle(SFX_TITLE_PICKLIST);
//STRIP001 /*?*/ 					::rtl::OUString		aFilter;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					INetURLObject		aURL( pMed->GetOrigURL() );
//STRIP001 /*?*/ 					const SfxFilter*	pFilter = pMed->GetOrigFilter();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( pFilter )
//STRIP001 /*?*/                         aFilter = pFilter->GetFilterName();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// add to svtool history options
//STRIP001 /*?*/ 					SvtHistoryOptions().AppendItem( ePICKLIST,
//STRIP001 /*?*/ 							aURL.GetURLNoPass( INetURLObject::NO_DECODE ),
//STRIP001 /*?*/ 							aFilter,
//STRIP001 /*?*/ 							aTitle,
//STRIP001 /*?*/ 							SfxStringEncode( aURL.GetPass() ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pDocSh->Get_Impl()->bWaitingForPicklist = sal_False;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( aURL.GetProtocol() == INET_PROT_FILE )
//STRIP001 /*?*/ 						SystemShell::AddToRecentDocumentList( aURL.GetURLNoPass( INetURLObject::NO_DECODE ) );
/*?*/ 				}
/*?*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }
}
