/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_idpool.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:35:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _GEN_HXX //autogen
// auto strip #include <tools/gen.hxx>
// auto strip #endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#pragma hdrstop

#include "idpool.hxx"
namespace binfilter {

//====================================================================
// locks all ids in the set; returns TRUE if none was locked

/*N*/ BOOL IdPool::Lock( const BitSet& rLockSet )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	// shift the set by offset
/*N*/ 	BitSet aLockSet = rLockSet << nOffset;
/*N*/ 
/*N*/ 	// is none of the numbers in the set already locked?
/*N*/ 	if ( !(aLockSet & *this) )
/*N*/ 	{
/*N*/ 		// lock all the numbers in the range
/*N*/ 		*this |= aLockSet;
/*N*/ 
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

//--------------------------------------------------------------------

// creates a pool of unique numbers between nMin and nMax

/*N*/ IdPool::IdPool( USHORT nMin, USHORT nMax ):
/*N*/ 	nOffset(nMin),
/*N*/ 	nRange(nMax-nMin+1),
/*N*/ 	nNextFree(0)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ }

//--------------------------------------------------------------------

// gets and locks a unique id

//STRIP001 USHORT IdPool::Get()
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	// seek the next free number
//STRIP001 	while ( Contains(nNextFree) && nNextFree < nRange )
//STRIP001 		++nNextFree;
//STRIP001 
//STRIP001 	// was a number available
//STRIP001 	if ( nNextFree < nRange )
//STRIP001 	{   // lock and return the number found
//STRIP001 		*this |= nNextFree;
//STRIP001 		return nNextFree + nOffset;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//--------------------------------------------------------------------

// frees a unique id for recycling

//STRIP001 BOOL IdPool::Put( USHORT nId )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	// is it locked?
//STRIP001 	if ( IsLocked(nId) )
//STRIP001 	{
//STRIP001 		// always store the smallest free number in nNextFree
//STRIP001 		nId -= nOffset;
//STRIP001 		if ( nNextFree > nId )
//STRIP001 			nNextFree = nId;
//STRIP001 
//STRIP001 		// unlock the number and return success
//STRIP001 		*this -= nId;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

//--------------------------------------------------------------------

// marks a range of ids as used, return FALSE if already used

//STRIP001 BOOL IdPool::Lock( const Range& rRange )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	// create a shifted set
//STRIP001 	Range aRange(rRange.Min()-nOffset, rRange.Max()-nOffset);
//STRIP001 	BitSet aLockSet( aRange );
//STRIP001 
//STRIP001 	// is none of the numbers in the set already locked?
//STRIP001 	if ( !(aLockSet & *this) )
//STRIP001 	{
//STRIP001 		// lock all the numbers in the range
//STRIP001 		*this |= aLockSet;
//STRIP001 
//STRIP001 		// adjust the smallest unlocked number in nNextFree
//STRIP001 		if ( nNextFree >= aRange.Min() && nNextFree < aRange.Max() )
//STRIP001 			nNextFree = aRange.Max()+1;
//STRIP001 
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//--------------------------------------------------------------------

// marks a single id as used, return FALSE if already used

//STRIP001 BOOL IdPool::Lock( USHORT nId )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	// is the number already locked?
//STRIP001 	if ( !IsLocked(nId) )
//STRIP001 	{
//STRIP001 		// lock the number
//STRIP001 		*this |= (nId-nOffset);
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


}
