/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_basedlgs.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:52:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <stdlib.h>

// auto strip #ifndef _SV_HELP_HXX
// auto strip #include <vcl/help.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
// auto strip #include <svtools/viewoptions.hxx>
// auto strip #endif
#pragma hdrstop

#include "basedlgs.hxx"
// auto strip #include "viewfrm.hxx"
// auto strip #include "tabdlg.hxx"
// auto strip #include "app.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
// auto strip #include "accmgr.hxx"
// auto strip #include "childwin.hxx"
// auto strip #include "viewsh.hxx"
// auto strip #include "sfxhelp.hxx"
#include "workwin.hxx"
namespace binfilter {

static String aEmptyString;

using namespace ::com::sun::star::uno;
using namespace ::rtl;

#define USERITEM_NAME OUString::createFromAscii( "UserItem" )

class SfxModelessDialog_Impl
{
public:
    ByteString      aWinState;
    SfxChildWindow* pMgr;
	BOOL				bConstructed;
};

class SfxFloatingWindow_Impl
{
public:
    ByteString      aWinState;
    SfxChildWindow* pMgr;
	BOOL				bConstructed;
};

// class SfxModalDefParentHelper -----------------------------------------

//STRIP001 SfxModalDefParentHelper::SfxModalDefParentHelper( Window *pWindow)
//STRIP001 {
//STRIP001 	pOld = Application::GetDefDialogParent();
//STRIP001 	Application::SetDefDialogParent( pWindow );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxModalDefParentHelper::~SfxModalDefParentHelper()
//STRIP001 {
//STRIP001 	Application::SetDefDialogParent( pOld );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SetDialogData_Impl( SfxViewFrame *pFrame, SfxModalDialog *pDlg,
//STRIP001 						 sal_uInt16 nId, const String &rExtraData = aEmptyString )
//STRIP001 {
//STRIP001 	// save settings (position and user data)
//STRIP001 	SvtViewOptions aDlgOpt( E_DIALOG, String::CreateFromInt32( nId ) );
//STRIP001 	aDlgOpt.SetWindowState(
//STRIP001 		OUString::createFromAscii( pDlg->GetWindowState( WINDOWSTATE_MASK_POS ).GetBuffer() ) );
//STRIP001 	if ( rExtraData.Len() )
//STRIP001 		aDlgOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( rExtraData ) ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 String GetDialogData_Impl( SfxViewFrame *pFrame, SfxModalDialog *pDlg, sal_uInt16 nId )
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Hilfsfunktion; liest die Dialogposition aus der Ini-Datei
//STRIP001 	und setzt diese am "ubergebenen Window.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	SvtViewOptions aDlgOpt( E_DIALOG, String::CreateFromInt32( nId ) );
//STRIP001 	if ( aDlgOpt.Exists() )
//STRIP001 	{
//STRIP001 		// load settings
//STRIP001 		pDlg->SetWindowState( ByteString( aDlgOpt.GetWindowState().getStr(), RTL_TEXTENCODING_ASCII_US ) );
//STRIP001 		Any aUserItem = aDlgOpt.GetUserItem( USERITEM_NAME );
//STRIP001 		OUString aTemp;
//STRIP001 		if ( aUserItem >>= aTemp )
//STRIP001 			sRet = String( aTemp );
//STRIP001 	}
//STRIP001 
//STRIP001 	return sRet;
//STRIP001 }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog(Window* pParent, const ResId &rResId)
/*?*/ 
/*      [Beschreibung]

	Konstruktor der allgemeinen Basisklasse f"ur modale Dialoge;
	ResId wird als ID im ini-file verwendet.
	Die dort gespeicherte Position wird gesetzt.
*/
/*?*/ 
/*?*/ :       ModalDialog(pParent, rResId),
/*?*/ 	nUniqId(rResId.GetId())
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_WARNING( "bitte den Ctor mit ViewFrame verwenden" );
//STRIP001 
//STRIP001 	aExtraData = GetDialogData_Impl(0, this, nUniqId);
//STRIP001 	aTimer.SetTimeout( 100 );
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxModalDialog, TimerHdl_Impl ) );
//STRIP001 	aTimer.Start();
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog(Window* pParent,
/*?*/ 							   sal_uInt16 nUniqueId,
/*?*/ 							   WinBits nWinStyle) :
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur modale Dialoge;
//STRIP001 	ID f"ur das ini-file wird explizit "ubergeben.
//STRIP001 	Die dort gespeicherte Position wird gesetzt.
//STRIP001 */

/*?*/ 	ModalDialog(pParent, nWinStyle),
/*?*/ 	nUniqId(nUniqueId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_WARNING( "bitte den Ctor mit ViewFrame verwenden" );
//STRIP001 	aExtraData = GetDialogData_Impl(0, this, nUniqId);
//STRIP001 	aTimer.SetTimeout( 100 );
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxModalDialog, TimerHdl_Impl ) );
//STRIP001 	aTimer.Start();
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog
/*?*/ (
/*?*/ 	SfxViewFrame*   pViewFrame,
/*?*/ 	Window*                 pParent,
/*?*/ 	const ResId&    rResId
/*?*/ )
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur modale Dialoge;
//STRIP001 	ResId wird als ID im ini-file verwendet.
//STRIP001 	Die dort gespeicherte Position wird gesetzt.
//STRIP001 */
//STRIP001 
/*?*/ :       ModalDialog(pParent, rResId),
/*?*/ 	nUniqId(rResId.GetId())
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	aExtraData = GetDialogData_Impl(pViewFrame, this, nUniqId);
//STRIP001 	aTimer.SetTimeout( 100 );
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxModalDialog, TimerHdl_Impl ) );
//STRIP001 	aTimer.Start();
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxModalDialog::SfxModalDialog
/*?*/ (
/*?*/ 	SfxViewFrame*   pViewFrame,
/*?*/ 	Window*                 pParent,
/*?*/ 	sal_uInt16                  nUniqueId,
/*?*/ 	WinBits                 nWinStyle
/*?*/ )
/*?*/ 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur modale Dialoge;
//STRIP001 	ID f"ur das ini-file wird explizit "ubergeben.
//STRIP001 	Die dort gespeicherte Position wird gesetzt.
//STRIP001 */
//STRIP001 
/*?*/ :       ModalDialog(pParent, nWinStyle),
/*?*/ 	nUniqId(nUniqueId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	aExtraData = GetDialogData_Impl(pViewFrame, this, nUniqId);
//STRIP001 	aTimer.SetTimeout( 100 );
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxModalDialog, TimerHdl_Impl ) );
//STRIP001 	aTimer.Start();
/*?*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxModalDialog::~SfxModalDialog()
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Dtor; schreibt Dialogposition in das ini-file
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 /*
//STRIP001 	SfxHelpPI *pHelpPI = SFX_APP()->GetHelpPI();
//STRIP001 	if ( pHelpPI )
//STRIP001 		pHelpPI->ResetTopic();
//STRIP001 */
//STRIP001 	SetDialogData_Impl(0, this, nUniqId, aExtraData);
//STRIP001 	aTimer.Stop();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxModalDialog, TimerHdl_Impl, Timer*, EMPTYARG )
//STRIP001 {
//STRIP001 /*
//STRIP001 	SfxHelpPI *pHelpPI = SFX_APP()->GetHelpPI();
//STRIP001 	if ( pHelpPI )
//STRIP001 		pHelpPI->LoadTopic( GetHelpId() );
//STRIP001  */
//STRIP001 	return 0L;
//STRIP001 }

//-------------------------------------------------------------------------
//STRIP001 void SfxModelessDialog::StateChanged( StateChangedType nStateChange )
//STRIP001 {
//STRIP001 	if ( nStateChange == STATE_CHANGE_INITSHOW )
//STRIP001     {
//STRIP001         if ( pImp->aWinState.Len() )
//STRIP001         {
//STRIP001             SetWindowState( pImp->aWinState );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             Point aPos = GetPosPixel();
//STRIP001             if ( !aPos.X() )
//STRIP001             {
//STRIP001                 aSize = GetSizePixel();
//STRIP001 
//STRIP001                 Size aParentSize = GetParent()->GetOutputSizePixel();
//STRIP001                 Size aSize = GetSizePixel();
//STRIP001                 aPos.X() += ( aParentSize.Width() - aSize.Width() ) / 2;
//STRIP001                 aPos.Y() += ( aParentSize.Height() - aSize.Height() ) / 2;
//STRIP001 
//STRIP001                 Point aPoint;
//STRIP001                 Rectangle aRect = GetDesktopRectPixel();
//STRIP001                 aPoint.X() = aRect.Right() - aSize.Width();
//STRIP001                 aPoint.Y() = aRect.Bottom() - aSize.Height();
//STRIP001 
//STRIP001                 aPoint = OutputToScreenPixel( aPoint );
//STRIP001 
//STRIP001                 if ( aPos.X() > aPoint.X() )
//STRIP001                     aPos.X() = aPoint.X() ;
//STRIP001                 if ( aPos.Y() > aPoint.Y() )
//STRIP001                     aPos.Y() = aPoint.Y();
//STRIP001 
//STRIP001                 if ( aPos.X() < 0 ) aPos.X() = 0;
//STRIP001                 if ( aPos.Y() < 0 ) aPos.Y() = 0;
//STRIP001 
//STRIP001                 SetPosPixel( aPos );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         pImp->bConstructed = TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     ModelessDialog::StateChanged( nStateChange );
//STRIP001 }

//STRIP001 void SfxModelessDialog::Initialize(SfxChildWinInfo *pInfo)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Initialisierung der Klasse SfxModelessDialog "uber ein SfxChildWinInfo.
//STRIP001 	Die Initialisierung erfolgt erst in einem 2.Schritt
//STRIP001 	nach dem ctor und sollte vom ctor der abgeleiteten Klasse
//STRIP001 	oder von dem des SfxChildWindows aufgerufen werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     pImp->aWinState = pInfo->aWinState;
//STRIP001 }

//STRIP001 void SfxModelessDialog::Resize()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse FloatingWindow merkt sich ggf. eine
	ver"anderte Gr"o\se.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	auch SfxFloatingWindow::Resize() gerufen werden.
*/

//STRIP001 {
//STRIP001 	ModelessDialog::Resize();
//STRIP001     if ( pImp->bConstructed && pImp->pMgr )
//STRIP001     {
//STRIP001         if ( !IsRollUp() )
//STRIP001             aSize = GetSizePixel();
//STRIP001         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
//STRIP001         if ( GetStyle() & WB_SIZEABLE )
//STRIP001             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
//STRIP001         pImp->aWinState = GetWindowState( nMask );
//STRIP001         GetBindings().GetWorkWindow_Impl()->ConfigChild_Impl( SFX_CHILDWIN_DOCKINGWINDOW, SFX_ALIGNDOCKINGWINDOW, pImp->pMgr->GetType() );
//STRIP001     }
//STRIP001 }

//STRIP001 void SfxModelessDialog::Move()
//STRIP001 {
//STRIP001     ModelessDialog::Move();
//STRIP001     if ( pImp->bConstructed && pImp->pMgr && IsReallyVisible() )
//STRIP001     {
//STRIP001         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
//STRIP001         if ( GetStyle() & WB_SIZEABLE )
//STRIP001             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
//STRIP001         pImp->aWinState = GetWindowState( nMask );
//STRIP001         GetBindings().GetWorkWindow_Impl()->ConfigChild_Impl( SFX_CHILDWIN_DOCKINGWINDOW, SFX_ALIGNDOCKINGWINDOW, pImp->pMgr->GetType() );
//STRIP001     }
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ SfxModelessDialog::SfxModelessDialog( SfxBindings *pBindinx,
/*N*/ 						SfxChildWindow *pCW,
/*N*/ 						Window* pParent, WinBits nWinBits ) :
/*N*/ 	ModelessDialog (pParent, nWinBits),
/*N*/ 	pBindings(pBindinx),
/*N*/     pImp( new SfxModelessDialog_Impl )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     pImp->pMgr = pCW;
//STRIP001     pImp->bConstructed = FALSE;
//STRIP001 	sal_uInt32 nId = GetHelpId();
//STRIP001 	SetHelpId(0);
//STRIP001 	SetUniqueId( nId );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SfxModelessDialog::SfxModelessDialog( SfxBindings *pBindinx,
/*N*/ 						SfxChildWindow *pCW, Window *pParent,
/*N*/ 						const ResId& rResId ) :
/*N*/ 	ModelessDialog(pParent, rResId),
/*N*/ 	pBindings(pBindinx),
/*N*/     pImp( new SfxModelessDialog_Impl )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     pImp->pMgr = pCW;
//STRIP001     pImp->bConstructed = FALSE;
//STRIP001 	sal_uInt32 nId = GetHelpId();
//STRIP001 	SetHelpId(0);
//STRIP001 	SetUniqueId( nId );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 long SfxModelessDialog::Notify( NotifyEvent& rEvt )
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Wenn ein ModelessDialog aktiviert wird, wird sein ViewFrame aktiviert.
//STRIP001 	Notwendig ist das bei PlugInFrames.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( rEvt.GetType() == EVENT_GETFOCUS )
//STRIP001 	{
//STRIP001 /*
//STRIP001 		SfxViewFrame *pFrame = pBindings->GetDispatcher_Impl()->GetFrame();
//STRIP001 		if ( pFrame )
//STRIP001 			pFrame->MakeActive_Impl();
//STRIP001 
//STRIP001 		if ( rEvt.GetType() == EVENT_MOUSEBUTTONDOWN )
//STRIP001 			ModelessDialog::ParentNotify( rEvt );
//STRIP001 		return sal_True;
//STRIP001  */
//STRIP001         pBindings->SetActiveFrame( pImp->pMgr->GetFrame() );
//STRIP001         pImp->pMgr->Activate_Impl();
//STRIP001         Window* pWindow = rEvt.GetWindow();
//STRIP001         ULONG nHelpId  = 0;
//STRIP001         while ( !nHelpId && pWindow )
//STRIP001         {
//STRIP001             nHelpId = pWindow->GetHelpId();
//STRIP001             pWindow = pWindow->GetParent();
//STRIP001         }
//STRIP001 
//STRIP001         if ( nHelpId )
//STRIP001             SfxHelp::OpenHelpAgent( pBindings->GetDispatcher_Impl()->GetFrame()->GetFrame(), nHelpId );
//STRIP001 	}
//STRIP001     else if ( rEvt.GetType() == EVENT_LOSEFOCUS && !HasChildPathFocus() )
//STRIP001 	{
//STRIP001         pBindings->SetActiveFrame( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > () );
//STRIP001         pImp->pMgr->Deactivate_Impl();
//STRIP001 	}
//STRIP001 	else if( rEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		// KeyInput zuerst f"ur Dialogfunktionen zulassen ( TAB etc. )
//STRIP001 		if ( !ModelessDialog::Notify( rEvt ) )
//STRIP001 			// dann auch global g"ultige Acceleratoren verwenden
//STRIP001 			return SfxViewShell::Current()->GlobalKeyInput_Impl( *rEvt.GetKeyEvent() );
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ModelessDialog::Notify( rEvt );
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ SfxModelessDialog::~SfxModelessDialog()
/*N*/ 
/*      [Beschreibung]

	Dtor
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( pImp->pMgr->GetFrame() == pBindings->GetActiveFrame() )
//STRIP001         pBindings->SetActiveFrame( NULL );
//STRIP001     delete pImp;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 sal_Bool SfxModelessDialog::Close()
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Das Fenster wird geschlossen, indem das ChildWindow durch Ausf"uhren des
//STRIP001 	ChildWindow-Slots zerst"ort wird.
//STRIP001 	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
//STRIP001 	danach SfxModelessDialogWindow::Close() gerufen werden, wenn nicht das
//STRIP001 	Close() mit "return sal_False" abgebrochen wird.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// Execute mit Parametern, da Toggle von einigen ChildWindows ignoriert
//STRIP001 	// werden kann
//STRIP001     SfxBoolItem aValue( pImp->pMgr->GetType(), sal_False);
//STRIP001 	pBindings->GetDispatcher_Impl()->Execute(
//STRIP001         pImp->pMgr->GetType(),
//STRIP001 		SFX_CALLMODE_RECORD|SFX_CALLMODE_SYNCHRON, &aValue, 0L );
//STRIP001 	return sal_True;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void SfxModelessDialog::FillInfo(SfxChildWinInfo& rInfo) const
/*N*/ 
/*  [Beschreibung]

	F"ullt ein SfxChildWinInfo mit f"ur SfxModelessDialof spezifischen Daten,
	damit sie in die INI-Datei geschrieben werden koennen.
	Es wird angenommen, da\s rInfo alle anderen evt. relevanten Daten in
	der ChildWindow-Klasse erh"alt.
	ModelessDialogs haben keine spezifischen Informationen, so da?die
	Basisimplementierung nichts tut und daher nicht gerufen werden mu\s.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	rInfo.aSize  = aSize;
//STRIP001 	if ( IsRollUp() )
//STRIP001 		rInfo.nFlags |= SFX_CHILDWIN_ZOOMIN;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SfxFloatingWindow::Notify( NotifyEvent& rEvt )

/*      [Beschreibung]

	Wenn ein ModelessDialog aktiviert wird, wird sein ViewFrame aktiviert.
	Notwendig ist das bei PlugInFrames.
*/

/*N*/ {
/*
    if ( rEvt.GetType() == EVENT_GETFOCUS || rEvt.GetType() == EVENT_MOUSEBUTTONDOWN )
	{
		SfxViewFrame *pFrame = pBindings->GetDispatcher_Impl()->GetFrame();
		if ( pFrame )
			pFrame->MakeActive_Impl();

		if ( rEvt.GetType() == EVENT_MOUSEBUTTONDOWN )
			FloatingWindow::ParentNotify( rEvt );
		return sal_True;
	}
*/

/*N*/ 	if ( rEvt.GetType() == EVENT_GETFOCUS )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/         pBindings->SetActiveFrame( pImp->pMgr->GetFrame() );
//STRIP001 /*?*/         pImp->pMgr->Activate_Impl();
//STRIP001 /*?*/         Window* pWindow = rEvt.GetWindow();
//STRIP001 /*?*/         ULONG nHelpId  = 0;
//STRIP001 /*?*/         while ( !nHelpId && pWindow )
//STRIP001 /*?*/         {
//STRIP001 /*?*/             nHelpId = pWindow->GetHelpId();
//STRIP001 /*?*/             pWindow = pWindow->GetParent();
//STRIP001 /*?*/         }
//STRIP001 /*?*/ 
//STRIP001 /*?*/         if ( nHelpId )
//STRIP001 /*?*/             SfxHelp::OpenHelpAgent( pBindings->GetDispatcher_Impl()->GetFrame()->GetFrame(), nHelpId );
/*N*/ 	}
/*N*/ 	else if ( rEvt.GetType() == EVENT_LOSEFOCUS )
/*N*/ 	{
/*?*/ 		if ( !HasChildPathFocus() )
/*?*/             pImp->pMgr->Deactivate_Impl();
/*N*/ 	}
/*N*/ 	else if( rEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*N*/ 		// KeyInput zuerst f"ur Dialogfunktionen zulassen
/*?*/ 		if ( !FloatingWindow::Notify( rEvt ) )
/*?*/ 			// dann auch global g"ultige Acceleratoren verwenden
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 return SfxViewShell::Current()->GlobalKeyInput_Impl( *rEvt.GetKeyEvent() );
/*?*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FloatingWindow::Notify( rEvt );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxFloatingWindow::SfxFloatingWindow( SfxBindings *pBindinx,
//STRIP001 						SfxChildWindow *pCW,
//STRIP001 						Window* pParent, WinBits nWinBits) :
//STRIP001 	FloatingWindow (pParent, nWinBits),
//STRIP001 	pBindings(pBindinx),
//STRIP001     pImp( new SfxFloatingWindow_Impl )
//STRIP001 {
//STRIP001     pImp->pMgr = pCW;
//STRIP001     pImp->bConstructed = FALSE;
//STRIP001 	sal_uInt32 nId = GetHelpId();
//STRIP001 	SetHelpId(0);
//STRIP001 	SetUniqueId( nId );
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ SfxFloatingWindow::SfxFloatingWindow( SfxBindings *pBindinx,
/*N*/ 						SfxChildWindow *pCW,
/*N*/ 						Window* pParent,
/*N*/ 						const ResId& rResId) :
/*N*/ 	FloatingWindow(pParent, rResId),
/*N*/ 	pBindings(pBindinx),
/*N*/     pImp( new SfxFloatingWindow_Impl )
/*N*/ {
/*N*/     pImp->pMgr = pCW;
/*N*/     pImp->bConstructed = FALSE;
/*N*/ 	sal_uInt32 nId = GetHelpId();
/*N*/ 	SetHelpId(0);
/*N*/ 	SetUniqueId( nId );
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ sal_Bool SfxFloatingWindow::Close()

/*      [Beschreibung]

	Das Fenster wird geschlossen, indem das ChildWindow durch Ausf"uhren des
	ChildWindow-Slots zerst"ort wird.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	danach SfxFloatingWindow::Close() gerufen werden, wenn nicht das Close()
	mit "return sal_False" abgebrochen wird.

*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	// Execute mit Parametern, da Toggle von einigen ChildWindows ignoriert
//STRIP001 	// werden kann
//STRIP001     SfxBoolItem aValue( pImp->pMgr->GetType(), sal_False);
//STRIP001 	pBindings->GetDispatcher_Impl()->Execute(
//STRIP001             pImp->pMgr->GetType(),
//STRIP001 			SFX_CALLMODE_RECORD|SFX_CALLMODE_SYNCHRON, &aValue, 0L );
//STRIP001 	return sal_True;
/*?*/ }

// -----------------------------------------------------------------------

/*N*/ SfxFloatingWindow::~SfxFloatingWindow()

/*      [Beschreibung]

	Dtor
*/

/*N*/ {
/*N*/     if ( pImp->pMgr->GetFrame() == pBindings->GetActiveFrame() )
/*?*/         pBindings->SetActiveFrame( NULL );
/*N*/     delete pImp;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxFloatingWindow::Resize()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse FloatingWindow merkt sich ggf. eine
	ver"anderte Gr"o\se.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	auch SfxFloatingWindow::Resize() gerufen werden.
*/

/*N*/ {
/*N*/ 	FloatingWindow::Resize();
/*N*/     if ( pImp->bConstructed && pImp->pMgr )
/*N*/     {
/*?*/         if ( !IsRollUp() )
/*?*/             aSize = GetSizePixel();
/*?*/         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
/*?*/         if ( GetStyle() & WB_SIZEABLE )
/*?*/             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
/*?*/         pImp->aWinState = GetWindowState( nMask );
/*?*/         GetBindings().GetWorkWindow_Impl()->ConfigChild_Impl( SFX_CHILDWIN_DOCKINGWINDOW, SFX_ALIGNDOCKINGWINDOW, pImp->pMgr->GetType() );
/*N*/     }
/*N*/ }

/*N*/ void SfxFloatingWindow::Move()
/*N*/ {
/*N*/     FloatingWindow::Move();
/*N*/     if ( pImp->bConstructed && pImp->pMgr )
/*N*/     {
/*?*/         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
/*?*/         if ( GetStyle() & WB_SIZEABLE )
/*?*/             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
/*?*/         pImp->aWinState = GetWindowState( nMask );
/*?*/         GetBindings().GetWorkWindow_Impl()->ConfigChild_Impl( SFX_CHILDWIN_DOCKINGWINDOW, SFX_ALIGNDOCKINGWINDOW, pImp->pMgr->GetType() );
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxFloatingWindow::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/     {
/*N*/         // FloatingWindows are not centered by default
/*N*/         if ( pImp->aWinState.Len() )
/*?*/             SetWindowState( pImp->aWinState );
/*N*/         pImp->bConstructed = TRUE;
/*N*/     }
/*N*/ 
/*N*/     FloatingWindow::StateChanged( nStateChange );
/*N*/ }


//STRIP001 void SfxFloatingWindow::Initialize(SfxChildWinInfo *pInfo)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Initialisierung der Klasse SfxFloatingWindow "uber ein SfxChildWinInfo.
//STRIP001 	Die Initialisierung erfolgt erst in einem 2.Schritt
//STRIP001 	nach dem ctor und sollte vom ctor der abgeleiteten Klasse
//STRIP001 	oder von dem des SfxChildWindows aufgerufen werden.
//STRIP001 */
//STRIP001 {
//STRIP001     pImp->aWinState = pInfo->aWinState;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void SfxFloatingWindow::FillInfo(SfxChildWinInfo& rInfo) const

/*  [Beschreibung]

	F"ullt ein SfxChildWinInfo mit f"ur SfxFloatingWindow spezifischen Daten,
	damit sie in die INI-Datei geschrieben werden koennen.
	Es wird angenommen, da\s rInfo alle anderen evt. relevanten Daten in
	der ChildWindow-Klasse erh"alt.
	Eingetragen werden hier gemerkte Gr"o\se und das ZoomIn-Flag.
	Wird diese Methode "uberschrieben, mu\s zuerst die Basisimplementierung
	gerufen werden.
*/

/*N*/ {
/*N*/ 	rInfo.aSize  = aSize;
/*N*/ 	if ( IsRollUp() )
/*?*/ 		rInfo.nFlags |= SFX_CHILDWIN_ZOOMIN;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxSingleTabDialog, OKHdl_Impl, Button *, pButton )
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Ok_Handler; f"ur die gesetzte Page wird FillItemSet() gerufen.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( !pOutSet )
//STRIP001 	{
//STRIP001 		pOutSet = new SfxItemSet( *pOptions );
//STRIP001 		pOutSet->ClearItem();
//STRIP001 	}
//STRIP001 	sal_Bool bModified = sal_False;
//STRIP001 
//STRIP001 	if ( pPage->HasExchangeSupport() )
//STRIP001 	{
//STRIP001 		int nRet = pPage->DeactivatePage( pOutSet );
//STRIP001 
//STRIP001 		if ( nRet != SfxTabPage::LEAVE_PAGE )
//STRIP001 			return 0;
//STRIP001 		else
//STRIP001 			bModified = ( pOutSet->Count() > 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bModified = pPage->FillItemSet( *pOutSet );
//STRIP001 
//STRIP001 	if ( bModified )
//STRIP001 	{
//STRIP001 		// auch noch schnell User-Daten im IniManager abspeichern
//STRIP001 		pPage->FillUserData();
//STRIP001 		String sData( pPage->GetUserData() );
//STRIP001 		SvtViewOptions aPageOpt( E_TABPAGE, String::CreateFromInt32( GetUniqId() ) );
//STRIP001 		aPageOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( sData ) ) );
//STRIP001 		EndDialog( RET_OK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndDialog( RET_CANCEL );
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxSingleTabDialog::SfxSingleTabDialog
//STRIP001 (
//STRIP001 	Window *pParent,
//STRIP001 	const SfxItemSet& rSet,
//STRIP001 	sal_uInt16 nUniqueId
//STRIP001 ) :
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur SingleTab-Dialoge;
//STRIP001 	ID f"ur das ini-file wird "ubergeben.
//STRIP001 */
//STRIP001 
//STRIP001 	SfxModalDialog( pParent, nUniqueId, WinBits( WB_STDMODAL | WB_3DLOOK ) ),
//STRIP001 
//STRIP001 	pOKBtn          ( 0 ),
//STRIP001 	pCancelBtn      ( 0 ),
//STRIP001 	pHelpBtn        ( 0 ),
//STRIP001 	pPage           ( 0 ),
//STRIP001 	pOptions        ( &rSet ),
//STRIP001 	pOutSet         ( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_WARNING( "please use the ctor with ViewFrame" );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxSingleTabDialog::SfxSingleTabDialog
//STRIP001 (
//STRIP001 	SfxViewFrame*           pViewFrame,
//STRIP001 	Window*                         pParent,
//STRIP001 	const SfxItemSet&       rSet,
//STRIP001 	sal_uInt16                          nUniqueId
//STRIP001 ) :
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur SingleTab-Dialoge;
//STRIP001 	ID f"ur das ini-file wird "ubergeben.
//STRIP001 */
//STRIP001 
//STRIP001 	SfxModalDialog( pParent, nUniqueId, WinBits( WB_STDMODAL | WB_3DLOOK ) ),
//STRIP001 
//STRIP001 	pOKBtn          ( 0 ),
//STRIP001 	pCancelBtn      ( 0 ),
//STRIP001 	pHelpBtn        ( 0 ),
//STRIP001 	pPage           ( 0 ),
//STRIP001 	pOptions        ( &rSet ),
//STRIP001 	pOutSet         ( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxSingleTabDialog::SfxSingleTabDialog
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	sal_uInt16 nUniqueId,
//STRIP001 	const SfxItemSet* pInSet
//STRIP001 )
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur SingleTab-Dialoge;
//STRIP001 	ID f"ur das ini-file wird "ubergeben.
//STRIP001 	Sollte nicht mehr benutzt werden.
//STRIP001  */
//STRIP001 
//STRIP001 :	SfxModalDialog( pParent, nUniqueId, WinBits( WB_STDMODAL | WB_3DLOOK ) ),
//STRIP001 
//STRIP001 	pOKBtn          ( 0 ),
//STRIP001 	pCancelBtn      ( 0 ),
//STRIP001 	pHelpBtn        ( 0 ),
//STRIP001 	pPage           ( 0 ),
//STRIP001 	pOptions        ( pInSet ),
//STRIP001 	pOutSet         ( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_WARNING( "bitte den Ctor mit ViewFrame verwenden" );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxSingleTabDialog::SfxSingleTabDialog
//STRIP001 (
//STRIP001 	SfxViewFrame* pViewFrame,
//STRIP001 	Window* pParent,
//STRIP001 	sal_uInt16 nUniqueId,
//STRIP001 	const SfxItemSet* pInSet
//STRIP001 )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der allgemeinen Basisklasse f"ur SingleTab-Dialoge;
//STRIP001 	ID f"ur das ini-file wird "ubergeben.
//STRIP001 */
//STRIP001 
//STRIP001 :   SfxModalDialog( pParent, nUniqueId, WinBits( WB_STDMODAL | WB_3DLOOK ) ),
//STRIP001 
//STRIP001 	pOKBtn          ( 0 ),
//STRIP001 	pCancelBtn      ( 0 ),
//STRIP001 	pHelpBtn        ( 0 ),
//STRIP001 	pPage           ( 0 ),
//STRIP001 	pOptions        ( pInSet ),
//STRIP001 	pOutSet         ( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxSingleTabDialog::~SfxSingleTabDialog()
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Dtor; l"oscht ggf. die TabPage.
//STRIP001  */
//STRIP001 
//STRIP001 {
//STRIP001 	delete pOKBtn;
//STRIP001 	delete pCancelBtn;
//STRIP001 	delete pHelpBtn;
//STRIP001 	delete pPage;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SfxSingleTabDialog::SetTabPage( SfxTabPage* pTabPage,
//STRIP001 									 GetTabPageRanges pRangesFunc )
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Setzen einer (neuen) TabPage; eine bereits vorhandene Page
//STRIP001 	wird gel"oscht.
//STRIP001 	Die "ubergebene Page wird durch Aufruf von Reset() mit dem
//STRIP001 	initial "ubergebenen Itemset initialisiert.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( !pOKBtn )
//STRIP001 	{
//STRIP001 		pOKBtn = new OKButton( this, WB_DEFBUTTON );
//STRIP001 		pOKBtn->SetClickHdl( LINK( this, SfxSingleTabDialog, OKHdl_Impl ) );
//STRIP001 	}
//STRIP001 	if ( !pCancelBtn )
//STRIP001 		pCancelBtn = new CancelButton( this );
//STRIP001 	if ( !pHelpBtn )
//STRIP001 		pHelpBtn = new HelpButton( this );
//STRIP001 
//STRIP001 	if ( pPage )
//STRIP001 		delete pPage;
//STRIP001 	pPage = pTabPage;
//STRIP001 	fnGetRanges = pRangesFunc;
//STRIP001 
//STRIP001 	if ( pPage )
//STRIP001 	{
//STRIP001 		// erstmal die User-Daten besorgen, dann erst Reset()
//STRIP001 		SvtViewOptions aPageOpt( E_TABPAGE, String::CreateFromInt32( GetUniqId() ) );
//STRIP001 		String sUserData;
//STRIP001 		Any aUserItem = aPageOpt.GetUserItem( USERITEM_NAME );
//STRIP001 		OUString aTemp;
//STRIP001 		if ( aUserItem >>= aTemp )
//STRIP001 			sUserData = String( aTemp );
//STRIP001 		pPage->SetUserData( sUserData );
//STRIP001 		pPage->Reset( *pOptions );
//STRIP001 		pPage->Show();
//STRIP001 
//STRIP001 		// Gr"ossen und Positionen anpassen
//STRIP001 		pPage->SetPosPixel( Point() );
//STRIP001 		Size aOutSz( pPage->GetSizePixel() );
//STRIP001 		Size aBtnSiz = LogicToPixel( Size( 50, 14 ), MAP_APPFONT );
//STRIP001 		Point aPnt( aOutSz.Width(), LogicToPixel( Point( 0, 6 ), MAP_APPFONT ).Y() );
//STRIP001 		aOutSz.Width() += aBtnSiz.Width() + LogicToPixel( Size( 6, 0 ), MAP_APPFONT ).Width();
//STRIP001 		SetOutputSizePixel( aOutSz );
//STRIP001 		pOKBtn->SetPosSizePixel( aPnt, aBtnSiz );
//STRIP001 		pOKBtn->Show();
//STRIP001 		aPnt.Y() = LogicToPixel( Point( 0, 23 ), MAP_APPFONT ).Y();
//STRIP001 		pCancelBtn->SetPosSizePixel( aPnt, aBtnSiz );
//STRIP001 		pCancelBtn->Show();
//STRIP001 		aPnt.Y() = LogicToPixel( Point( 0, 43 ), MAP_APPFONT ).Y();
//STRIP001 		pHelpBtn->SetPosSizePixel( aPnt, aBtnSiz );
//STRIP001 
//STRIP001 		if ( Help::IsContextHelpEnabled() )
//STRIP001 			pHelpBtn->Show();
//STRIP001 
//STRIP001 		// Text der TabPage in den Dialog setzen
//STRIP001 		SetText( pPage->GetText() );
//STRIP001 
//STRIP001 		// Dialog bekommt HelpId der TabPage
//STRIP001 		SetHelpId( pPage->GetHelpId() );
//STRIP001 		SetUniqueId( pPage->GetUniqueId() );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------
// Vergleichsfunktion fuer qsort

//STRIP001 #ifdef WNT
//STRIP001 int __cdecl BaseDlgsCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #else
//STRIP001 #if defined(OS2) && defined(ICC)
//STRIP001 int _Optlink BaseDlgsCmpUS_Impl(        const void* p1, const void* p2 )
//STRIP001 #else
//STRIP001 int BaseDlgsCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #endif
//STRIP001 #endif
//STRIP001 {
//STRIP001 	return *(sal_uInt16*)p1 - *(sal_uInt16*)p2;
//STRIP001 }

// -----------------------------------------------------------------------

/*
	Bildet das Set "uber die Ranges der Page. Die Page muss die statische
	Methode f"ur das Erfragen ihrer	Ranges bei SetTabPage angegeben haben,
	liefert also ihr Set onDemand.
 */
//STRIP001 const sal_uInt16* SfxSingleTabDialog::GetInputRanges( const SfxItemPool& rPool )
//STRIP001 {
//STRIP001 	if ( pOptions )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "Set bereits vorhanden!" );
//STRIP001 		return pOptions->GetRanges();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pRanges )
//STRIP001 		return pRanges;
//STRIP001 	SvUShorts aUS(16, 16);
//STRIP001 
//STRIP001 	if ( fnGetRanges)
//STRIP001 	{
//STRIP001 		const sal_uInt16 *pTmpRanges = (fnGetRanges)();
//STRIP001 		const sal_uInt16 *pIter = pTmpRanges;
//STRIP001 		sal_uInt16 nLen;
//STRIP001 		for ( nLen = 0; *pIter; ++nLen, ++pIter )
//STRIP001 			;
//STRIP001 		aUS.Insert( pTmpRanges, nLen, aUS.Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	//! Doppelte Ids entfernen?
//STRIP001 	sal_uInt16 nCount = aUS.Count();
//STRIP001 
//STRIP001 	for ( sal_uInt16 i = 0; i < nCount; ++i )
//STRIP001 		aUS[i] = rPool.GetWhich( aUS[i]) ;
//STRIP001 
//STRIP001 	// sortieren
//STRIP001 	if ( aUS.Count() > 1 )
//STRIP001 		qsort( (void*)aUS.GetData(), aUS.Count(), sizeof(sal_uInt16), BaseDlgsCmpUS_Impl );
//STRIP001 
//STRIP001 	pRanges = new sal_uInt16[aUS.Count() + 1];
//STRIP001 	memcpy( pRanges, aUS.GetData(), sizeof(sal_uInt16) * aUS.Count() );
//STRIP001 	pRanges[aUS.Count()] = 0;
//STRIP001 	return pRanges;
//STRIP001 }

}
