/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: compview.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:23:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _COMPVIEW_HXX
#define _COMPVIEW_HXX

#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDERINTERCEPTOR_HPP_
#include <com/sun/star/frame/XDispatchProviderInterceptor.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTATUSLISTENER_HPP_
#include <com/sun/star/frame/XStatusListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDERINTERCEPTION_HPP_
#include <com/sun/star/frame/XDispatchProviderInterception.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FEATURESTATEEVENT_HPP_
#include <com/sun/star/frame/FeatureStateEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_DISPATCHDESCRIPTOR_HPP_
#include <com/sun/star/frame/DispatchDescriptor.hpp>
#endif
#include <viewfac.hxx>
#include <viewuno.hxx>
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
class SfxAllItemSet;
namespace binfilter {

class SfxComponentProxyInterface_Impl;
class SfxSlotArr_Impl;
class SfxStatusListener;
class SfxComponentProxy_Impl;

// class SfxComponentViewShell -------------------------------------------

class SfxComponentViewShell : public SfxViewShell
{
private:
	SfxComponentProxy_Impl*	pImp;

	void            		Construct();

protected:
	virtual sal_uInt16  		PrepareClose( sal_Bool bUI = sal_True, sal_Bool bForBrowsing = sal_False );
	virtual void    		OuterResizePixel( const Point &rOfs, const Size &rSize );
	virtual void    		InnerResizePixel( const Point &rOfs, const Size &rSize );
	virtual void    		Activate(sal_Bool IsMDIActivate);
	virtual void    		Deactivate(sal_Bool IsMDIActivate);

public:
	SFX_DECL_VIEWFACTORY(SfxComponentViewShell);
	TYPEINFO();

	SfxComponentViewShell( SfxViewFrame *pFrame, const SfxComponentViewShell& rWin );
	SfxComponentViewShell( SfxViewFrame *pFrame, SfxViewShell *pOld );
	~SfxComponentViewShell();

	virtual	sal_Bool			HasUIFeature( sal_uInt32 nFeature );
	static const SfxFormalArgument*	pSfxFormalArgs_Impl;
	virtual SfxInterface*	GetInterface() const;
	const SfxSlot*  		GetSlotForInterface( sal_uInt16 nId );
	static const SfxSlot*  	GetUnoSlot( sal_uInt16 nId );

	void				    Execute( SfxRequest& rReq );
	void             	    GetState( SfxItemSet& rItemSet );
	::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >				GetDispatch( const String& rName );

	DECL_LINK(				LoadHdl, Timer* );
	void					NewModelConnected( SfxItemSet& rSet );
	void					InvalidateAll();
};


}//end of namespace binfilter
#endif


