/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: templdgi.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:37:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_TEMPDLGI_HXX
#define _SFX_TEMPDLGI_HXX
namespace binfilter {
class SfxTemplateControllerItem;
}//end of namespace binfilter
#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SVTREEBOX_HXX //autogen
#include <svtools/svtreebx.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>		// SvUShorts

#include <rsc/rscsfx.hxx>
#include <tools/rtti.hxx>

#include "childwin.hxx"
#include "templdlg.hxx"
class SfxStyleSheetBasePool;
class SvTreeListBox ;
namespace binfilter {

class SfxStyleFamilies;
class SfxStyleFamilyItem;
class SfxTemplateItem;
class SfxBindings;
class StyleTreeListBox_Impl;
class SfxTemplateDialog_Impl;
class SfxCommonTemplateDialog_Impl;
class SfxTemplateDialogWrapper;
class SfxDockingWindow;

// class DropListBox_Impl ------------------------------------------------

class DropListBox_Impl : public SvTreeListBox
{
private:
//STRIP001 	DECL_LINK( OnAsyncExecuteDrop, SvLBoxEntry* );
//STRIP001 	DECL_LINK( OnAsyncExecuteError, void* );
protected:
	SvLBoxEntry*					pPreDropEntry;
	SfxCommonTemplateDialog_Impl*	pDialog;
	USHORT							nModifier;

public:
	DropListBox_Impl( Window* pParent, const ResId& rId, SfxCommonTemplateDialog_Impl* pD ) :
		SvTreeListBox( pParent, rId ), pDialog( pD ), pPreDropEntry( NULL )
            {}
	DropListBox_Impl( Window* pParent, WinBits nWinBits, SfxCommonTemplateDialog_Impl* pD ) :
		SvTreeListBox( pParent, nWinBits ), pDialog( pD ), pPreDropEntry( NULL )
            {}

	virtual void		MouseButtonDown( const MouseEvent& rMEvt );
	virtual sal_Int8	AcceptDrop( const AcceptDropEvent& rEvt );
	virtual sal_Int8    ExecuteDrop( const ExecuteDropEvent& rEvt );

	USHORT				GetModifier() const { return nModifier; }
	SvLBoxEntry*		GetPreDropEntry() const { return pPreDropEntry; }

	virtual long		Notify( NotifyEvent& rNEvt );
};

// class SfxActionListBox ------------------------------------------------

class SfxActionListBox : public DropListBox_Impl
{
protected:
public:
	SfxActionListBox( SfxCommonTemplateDialog_Impl* pParent, WinBits nWinBits );
//STRIP001 	SfxActionListBox( SfxCommonTemplateDialog_Impl* pParent, const ResId &rResId );

	virtual PopupMenu*	CreateContextMenu( void );
};

// class SfxCommonTemplateDialog_Impl ------------------------------------

class SfxCommonTemplateDialog_Impl : public SfxListener
{
private:
	class ISfxTemplateCommon_Impl : public ISfxTemplateCommon
	{
	private:
		SfxCommonTemplateDialog_Impl* pDialog;
	public:
		ISfxTemplateCommon_Impl( SfxCommonTemplateDialog_Impl* pDialogP ) : pDialog( pDialogP ) {}
		virtual SfxStyleFamily GetActualFamily() const { return pDialog->GetActualFamily(); }
		virtual String GetSelectedEntry() const { return pDialog->GetSelectedEntry(); }
	};

	ISfxTemplateCommon_Impl		aISfxTemplateCommon;

	void	ReadResource();
//STRIP001 	void	ClearResource();

protected:
#define MAX_FAMILIES			5
#define COUNT_BOUND_FUNC		13

#define UPDATE_FAMILY_LIST		0x0001
#define UPDATE_FAMILY			0x0002

	friend class DropListBox_Impl;
	friend class SfxTemplateControllerItem;
	friend class SfxTemplateDialogWrapper;

	SfxBindings*				pBindings;
	SfxTemplateControllerItem*	pBoundItems[COUNT_BOUND_FUNC];

	Window*						pWindow;
	SfxModule*					pModule;
	Timer*						pTimer;

	ResId*						m_pStyleFamiliesId;
	SfxStyleFamilies*			pStyleFamilies;
	SfxTemplateItem*			pFamilyState[MAX_FAMILIES];
	SfxStyleSheetBasePool*		pStyleSheetPool;
	SvTreeListBox*				pTreeBox;
	SfxObjectShell*				pCurObjShell;

	SfxActionListBox			aFmtLb;
	ListBox						aFilterLb;
	Size						aSize;

	USHORT						nActFamily;	// Id in der ToolBox = Position - 1
	USHORT						nActFilter;	// FilterIdx
	USHORT						nAppFilter;	// Filter, den die Applikation gesetzt hat (fuer automatisch)

	BOOL						bDontUpdate				:1,
								bIsWater				:1,
								bEnabled				:1,
								bUpdate					:1,
								bUpdateFamily			:1,
								bCanEdit				:1,
								bCanDel					:1,
								bCanNew					:1,
								bWaterDisabled			:1,
								bNewByExampleDisabled	:1,
								bUpdateByExampleDisabled:1,
								bTreeDrag				:1,
								bHierarchical			:1,
								bBindingUpdate			:1;

	DECL_LINK( FilterSelectHdl, ListBox * );
	DECL_LINK( FmtSelectHdl, SvTreeListBox * );
	DECL_LINK( ApplyHdl, Control * );
//STRIP001 	DECL_LINK( DropHdl, StyleTreeListBox_Impl * );
	DECL_LINK( TimeOut, Timer * );

						// Rechnet von den SFX_STYLE_FAMILY Ids auf 1-5 um
	static USHORT		SfxFamilyIdToNId( USHORT nFamily );

	virtual void		EnableItem( USHORT nMesId, BOOL bCheck = TRUE ) {}
	virtual void		CheckItem( USHORT nMesId, BOOL bCheck = TRUE ) {}
	virtual BOOL		IsCheckedItem( USHORT nMesId ) { return TRUE; }
	virtual void		LoadedFamilies() {}
	virtual void		Update() { UpdateStyles_Impl(UPDATE_FAMILY_LIST); }
	virtual void		InvalidateBindings();
	virtual void		InsertFamilyItem( USHORT nId, const SfxStyleFamilyItem* pIten ) = 0;
	virtual void		EnableFamilyItem( USHORT nId, BOOL bEnabled = TRUE ) = 0;
	virtual void		ClearFamilyList() = 0;

//STRIP001 	void				NewHdl( void* );
//STRIP001 	void				EditHdl( void* );
//STRIP001 	void				DeleteHdl( void* );

//STRIP001 	BOOL				Execute_Impl( USHORT nId, const String& rStr, const String& rRefStr,
//STRIP001 									  USHORT nFamily, USHORT nMask = 0,
//STRIP001 									  USHORT* pIdx = NULL, const USHORT* pModifier = NULL );

	void						UpdateStyles_Impl(USHORT nFlags);
	const SfxStyleFamilyItem*	GetFamilyItem_Impl() const;
	BOOL						IsInitialized() { return nActFamily != 0xffff; }
//STRIP001 	void						ResetFocus();
	void						EnableDelete();
	void						Initialize();

//STRIP001 	void				FilterSelect( USHORT nFilterIdx, BOOL bForce = FALSE );
	void				SetFamilyState( USHORT nSlotId, const SfxTemplateItem* );
	void				SetWaterCanState( const SfxBoolItem* pItem );

	void				SelectStyle( const String& rStyle );
	BOOL				HasSelectedStyle() const;
//STRIP001 	void				FillTreeBox();
	void				Update_Impl();
	void				UpdateFamily_Impl();

	// In welchem FamilyState muss ich nachsehen, um die Info der i-ten
	// Family in der pStyleFamilies zu bekommen.
	USHORT				StyleNrToInfoOffset( USHORT i );
//STRIP001 	USHORT				InfoOffsetToStyleNr( USHORT i );

	void				SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
									const SfxHint& rHint, const TypeId& rHintType );

	void				FamilySelect( USHORT nId );
	void				SetFamily( USHORT nId );
//STRIP001 	void				ActionSelect( USHORT nId );

public:
	TYPEINFO();

	SfxCommonTemplateDialog_Impl( SfxBindings* pB, SfxDockingWindow* );
//STRIP001 	SfxCommonTemplateDialog_Impl( SfxBindings* pB, ModalDialog* );
	~SfxCommonTemplateDialog_Impl();

//STRIP001 	DECL_LINK( MenuSelectHdl, Menu * );

	virtual void		EnableEdit( BOOL b = TRUE )	{ bCanEdit = b; }
	virtual void		EnableDel( BOOL b = TRUE )	{ bCanDel = b; }
	virtual void		EnableNew( BOOL b = TRUE )	{ bCanNew = b; }

	ISfxTemplateCommon*	GetISfxTemplateCommon() { return &aISfxTemplateCommon; }
	Window*				GetWindow() { return pWindow; }

	void				EnableTreeDrag( BOOL b = TRUE );
//STRIP001 	void				ExecuteContextMenu_Impl( const Point& rPos, Window* pWin );
	void				EnableExample_Impl( USHORT nId, BOOL bEnable );
	SfxStyleFamily		GetActualFamily() const;
	String				GetSelectedEntry() const;
	SfxObjectShell*		GetObjectShell() const { return pCurObjShell; }

	virtual void		PrepareDeleteAction();	// disable buttons, change button text, etc. when del is going to happen

	inline BOOL			CanEdit( void ) const	{ return bCanEdit; }
	inline BOOL			CanDel( void ) const	{ return bCanDel; }
	inline BOOL			CanNew( void ) const	{ return bCanNew; }

	// normaly for derivates from SvTreeListBoxes, but in this case the dialog handles context menus
	virtual PopupMenu*	CreateContextMenu( void );
};

// class SfxTemplateDialog_Impl ------------------------------------------

class SfxTemplateDialog_Impl :  public SfxCommonTemplateDialog_Impl
{
private:
	friend class SfxTemplateControllerItem;
	friend class SfxTemplateDialogWrapper;

	SfxTemplateDialog*	m_pFloat;
	BOOL				m_bZoomIn;
	ToolBox				m_aActionTbL;
	ToolBox				m_aActionTbR;

	DECL_LINK( ToolBoxLSelect, ToolBox * );
	DECL_LINK( ToolBoxRSelect, ToolBox * );

protected:
	virtual void	Command( const CommandEvent& rMEvt );
	virtual void	EnableEdit( BOOL = TRUE );
	virtual void	EnableItem( USHORT nMesId, BOOL bCheck = TRUE );
	virtual void	CheckItem( USHORT nMesId, BOOL bCheck = TRUE );
	virtual BOOL	IsCheckedItem( USHORT nMesId );
	virtual void	LoadedFamilies();
	virtual void	InsertFamilyItem( USHORT nId, const SfxStyleFamilyItem* pIten );
	virtual void	EnableFamilyItem( USHORT nId, BOOL bEnabled = TRUE );
	virtual void	ClearFamilyList();

	void 			Resize();
	Size			GetMinOutputSizePixel();

	void			updateFamilyImages();
	void			updateNonFamilyImages();

public:
	friend class SfxTemplateDialog;
	TYPEINFO();

	SfxTemplateDialog_Impl( Window* pParent, SfxBindings*, SfxTemplateDialog* pWindow );
	~SfxTemplateDialog_Impl();
};

// class SfxTemplateCatalog_Impl -----------------------------------------

//STRIP001 class SfxTemplateCatalog_Impl : public SfxCommonTemplateDialog_Impl
//STRIP001 {
//STRIP001 private:
//STRIP001 	friend class SfxTemplateControllerItem;
//STRIP001 	friend class SfxCommonTemplateDialog_Impl;
//STRIP001 
//STRIP001 	ListBox					aFamList;
//STRIP001 	OKButton				aOkBtn;
//STRIP001 	CancelButton			aCancelBtn;
//STRIP001 	PushButton				aNewBtn;
//STRIP001 	PushButton				aChangeBtn;
//STRIP001 	PushButton	   	 		aDelBtn;
//STRIP001 	PushButton				aOrgBtn;
//STRIP001 	HelpButton				aHelpBtn;
//STRIP001 
//STRIP001 	SfxTemplateCatalog*		pReal;
//STRIP001 	SvUShorts				aFamIds;
//STRIP001 	SfxModalDefParentHelper	aHelper;
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void	EnableItem( USHORT nMesId, BOOL bCheck = TRUE );
//STRIP001 	virtual void	CheckItem( USHORT nMesId, BOOL bCheck = TRUE );
//STRIP001 	virtual BOOL	IsCheckedItem( USHORT nMesId );
//STRIP001 	virtual void	InsertFamilyItem( USHORT nId, const SfxStyleFamilyItem* pIten );
//STRIP001 	virtual void	EnableFamilyItem( USHORT nId, BOOL bEnabled = TRUE );
//STRIP001 	virtual void	ClearFamilyList();
//STRIP001 	virtual void	EnableEdit( BOOL = TRUE );
//STRIP001 	virtual void	EnableDel( BOOL = TRUE );
//STRIP001 	virtual void	EnableNew( BOOL = TRUE );
//STRIP001 
//STRIP001 	DECL_LINK( FamListSelect, ListBox * );
//STRIP001 	DECL_LINK( OkHdl, Button * );
//STRIP001 	DECL_LINK( CancelHdl, Button * );
//STRIP001 	DECL_LINK( NewHdl, Button * );
//STRIP001 	DECL_LINK( ChangeHdl, Button * );
//STRIP001 	DECL_LINK( DelHdl, Button * );
//STRIP001 	DECL_LINK( OrgHdl, Button * );
//STRIP001 
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	SfxTemplateCatalog_Impl( Window* pParent, SfxBindings*, SfxTemplateCatalog* pWindow );
//STRIP001 	~SfxTemplateCatalog_Impl();
//STRIP001 
//STRIP001 friend class SfxTemplateCatalog;
//STRIP001 
//STRIP001 	virtual void	PrepareDeleteAction();
//STRIP001 };

}//end of namespace binfilter
#endif // #ifndef _SFX_TEMPDLGI_HXX


