/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_virtmenu.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:42:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include <sot/factory.hxx>
#include <svtools/menuoptions.hxx>
// auto strip #include <svtools/imagemgr.hxx>
#include <svtools/imageitm.hxx>

// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XENUMERATION_HPP_
// auto strip #include <com/sun/star/container/XEnumeration.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XDESKTOP_HPP_
// auto strip #include <com/sun/star/frame/XDesktop.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAMESSUPPLIER_HPP_
// auto strip #include <com/sun/star/frame/XFramesSupplier.hpp>
// auto strip #endif

// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/unohlp.hxx>
#endif
// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif

#pragma hdrstop

#include "virtmenu.hxx"
#include "msgpool.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

// auto strip #include "statcach.hxx"
// auto strip #include "msg.hxx"
#include "idpool.hxx"
// auto strip #include "mnuitem.hxx"
#include "mnumgr.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
// auto strip #include "app.hxx"
#include "accmgr.hxx"
#include "sfxtypes.hxx"
// auto strip #include "arrdecl.hxx"
#include "sfx.hrc"
#include "ipfrm.hxx"
// auto strip #include "ipenv.hxx"
// auto strip #include "appdata.hxx"
#include "viewsh.hxx"
#include "imgmgr.hxx"
// auto strip #include "sfxpicklist.hxx"
// auto strip #include "macrconf.hxx"
// auto strip #include "sfxresid.hxx"
#include "menu.hrc"
// auto strip #include "imagemgr.hxx"

#ifndef __FRAMEWORK_CLASSES_ADDONSOPTIONS_HXX_
#include <framework/addonsoptions.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ADDONMENUS_HXX_
#include <framework/addonmenu.hxx>
#endif

// auto strip #ifndef __FRAMEWORK_CLASSES_MENUCONFIGURATION_HXX_
// auto strip #include <framework/menuconfiguration.hxx>
// auto strip #endif

// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star::container;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::uno;

//=========================================================================

/*N*/ DBG_NAME(SfxVirtualMenu)

static long nAutoDeactivateTimeout_Impl = -1;

//=========================================================================

typedef SfxMenuControl* SfxMenuControlPtr;
//STRIP001 SV_IMPL_PTRARR(SfxMenuCtrlArr_Impl, SfxMenuControlPtr);

class SfxMenuImageControl_Impl : public SfxControllerItem
{
    SfxVirtualMenu*     pMenu;
    long                lRotation;
    BOOL                bIsMirrored;

protected:
    virtual void        StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
public:
                        SfxMenuImageControl_Impl( USHORT nSlotId, SfxBindings& rBindings, SfxVirtualMenu* pVMenu )
                            : SfxControllerItem( nSlotId, rBindings )
                            , pMenu( pVMenu )
                            , lRotation( 0 )
                            , bIsMirrored( FALSE )
                        {}
    void                Update();
};

/*N*/ void SfxMenuImageControl_Impl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/     const SfxImageItem* pItem = PTR_CAST( SfxImageItem, pState );
/*N*/     if ( pItem )
/*N*/     {
/*N*/         lRotation = pItem->GetRotation();
/*N*/         bIsMirrored = pItem->IsMirrored();
/*N*/         Update();
/*N*/     }
/*N*/ }

/*N*/ void SfxMenuImageControl_Impl::Update()
/*N*/ {
/*N*/     SfxViewFrame* pViewFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
/*N*/     SfxModule* pModule = pViewFrame->GetObjectShell()->GetModule();
/*N*/     SfxSlotPool* pPool = pModule->GetSlotPool();
/*N*/     Menu* pSVMenu = pMenu->GetSVMenu();
/*N*/     for (USHORT nPos = 0; nPos<pSVMenu->GetItemCount(); nPos++)
/*N*/     {
/*N*/         USHORT nId = pSVMenu->GetItemId( nPos );
/*N*/         const SfxSlot* pSlot = pPool->GetSlot( nId );
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ) )
/*N*/         {
/*N*/             pSVMenu->SetItemImageMirrorMode( nId, FALSE );
/*N*/             pSVMenu->SetItemImageAngle( nId, lRotation );
/*N*/         }
/*N*/ 
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEREFLECTION ) )
/*N*/             pSVMenu->SetItemImageMirrorMode( nId, bIsMirrored );
/*N*/     }
/*N*/ }

//=========================================================================

//STRIP001 static Image RetrieveAddOnImage( Reference< ::com::sun::star::frame::XFrame >& rFrame,
//STRIP001 								 const ::rtl::OUString& aImageId,
//STRIP001 								 const ::rtl::OUString& aURL,
//STRIP001 								 BOOL bBigImage,
//STRIP001 								 BOOL bHiContrast )
//STRIP001 {
//STRIP001 	Image aImage;
//STRIP001 
//STRIP001 	if ( aImageId.getLength() > 0 )
//STRIP001 	{
//STRIP001 		aImage = GetImage( rFrame, aImageId, bBigImage, bHiContrast );
//STRIP001 		if ( !!aImage )
//STRIP001 			return aImage;
//STRIP001 	}
//STRIP001 
//STRIP001 	aImage = GetImage( rFrame, aURL, bBigImage, bHiContrast );
//STRIP001 	if ( !aImage )
//STRIP001 		aImage = framework::AddonsOptions().GetImageFromURL( aURL, bBigImage, bHiContrast );
//STRIP001 
//STRIP001 	return aImage;
//STRIP001 }

//=========================================================================

/*	Diese Hilfsfunktion pr"uft, ob eine Slot-Id im aktuellen Applikations-
	Status sichtbar ist oder nicht. Dabei bezieht sich der Applikations-Status
	darauf, ob die Applikation OLE-Server ist oder nicht.
*/

/*N*/ BOOL IsItemHidden_Impl( USHORT nItemId, int bOleServer, int bMac )
/*N*/ {
/*N*/ 	return ( bMac &&
/*N*/ 			 ( nItemId == SID_ARRANGEICONS || nItemId == SID_MINIMIZEWINS ) ) ||
/*N*/ 		   (  bOleServer &&
/*N*/ 			 ( nItemId == SID_QUITAPP || nItemId == SID_SAVEDOC ||
/*N*/ 			   nItemId == SID_OPENDOC || nItemId == SID_SAVEASDOC ||
/*N*/ 			   nItemId == SID_NEWDOC ) ) ||
/*N*/ 		   ( !bOleServer &&
/*N*/ 			 ( nItemId == SID_EXITANDRETURN || nItemId == SID_UPDATEDOC ) );
/*N*/ }

//====================================================================

/*N*/ void SfxVirtualMenu::Construct_Impl()
/*N*/ {
/*N*/     pWindowMenu = NULL;
/*N*/     pPickMenu = NULL;
/*N*/     pAddonsMenu = NULL;
/*N*/ 	bIsActive = FALSE;
/*N*/ 	bControllersUnBound = FALSE;
/*N*/ 	pSVMenu->SetHighlightHdl( LINK(this, SfxVirtualMenu, Highlight) );
/*N*/ 	pSVMenu->SetActivateHdl( LINK(this, SfxVirtualMenu, Activate) );
/*N*/ 	pSVMenu->SetDeactivateHdl( LINK(this, SfxVirtualMenu, Deactivate) );
/*N*/ 	pSVMenu->SetSelectHdl( LINK(this, SfxVirtualMenu, Select) );
/*N*/ 
/*N*/ 	// #107258# accelerator keys are needed for accessibility
/*N*/ 	if ( bOLE )
/*N*/ 		InvalidateKeyCodes();
/*N*/ 
/*N*/ 	if ( !pResMgr && pParent )
/*N*/ 		pResMgr = pParent->pResMgr;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxVirtualMenu::SfxVirtualMenu( USHORT nOwnId,
/*N*/ 				SfxVirtualMenu* pOwnParent, Menu& rMenu, BOOL bWithHelp,
/*N*/ 				SfxBindings &rBindings, BOOL bOLEServer, BOOL bRes, BOOL bIsAddonMenu ):
/*N*/ 	pItems(0),
/*N*/ 	pBindings(&rBindings),
/*N*/ 	pResMgr(0),
/*N*/     pImageControl(0),
/*N*/ 	nLocks(0), pAutoDeactivate(0), bHelpInitialized( bWithHelp ),
/*N*/ 	bWasHighContrast( FALSE ),
/*N*/ 	bIsAddonPopupMenu( bIsAddonMenu )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CTOR(SfxVirtualMenu, 0);
/*N*/ 	pSVMenu = &rMenu;
/*N*/ 
/*N*/ 	bResCtor = bRes;
/*N*/ 	bOLE = bOLEServer;
/*N*/ 	nId = nOwnId;
/*N*/ 	pParent = pOwnParent;
/*N*/ 	nVisibleItems = 0;
//STRIP001 /*N*/ 	pAppCtrl = 0;
/*N*/ 	CreateFromSVMenu();
/*N*/ 	Construct_Impl();
/*N*/ 	bHelpInitialized = FALSE;
/*N*/ }

//--------------------------------------------------------------------

// creates a virtual menu from a StarView MenuBar or PopupMenu

/*N*/ SfxVirtualMenu::SfxVirtualMenu( Menu *pStarViewMenu, BOOL bWithHelp,
/*N*/ 					SfxBindings &rBindings, BOOL bOLEServer, BOOL bRes, BOOL bIsAddonMenu ):
/*N*/ 	pItems(0),
/*N*/ 	pBindings(&rBindings),
/*N*/ 	pResMgr(0),
/*N*/     pImageControl(0),
/*N*/ 	nLocks(0), pAutoDeactivate(0),  bHelpInitialized( bWithHelp ),
/*N*/ 	bWasHighContrast( FALSE ),
/*N*/ 	bIsAddonPopupMenu( bIsAddonMenu )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CTOR(SfxVirtualMenu, 0);
/*N*/ 
/*N*/     pSVMenu = pStarViewMenu;
/*N*/ 
/*N*/ 	bResCtor = bRes;
/*N*/ 	bOLE = bOLEServer;
/*N*/ 	nId = 0;
/*N*/ 	pParent = 0;
//STRIP001 /*N*/ 	pAppCtrl = 0;
/*N*/ 	nVisibleItems = 0;
/*N*/ 	CreateFromSVMenu();
/*N*/ 	Construct_Impl();
/*N*/ 	bHelpInitialized = FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*  Der Destruktor der Klasse SfxVirtualMenu gib die gebundenen Items frei
	und klinkt das zugeh"orige StarView-PopupMenu aus seinem Parent aus.
	Falls es sich um das Pickmenu oder das MDI-Menu handelt, wird es
	dort abgemeldet.
*/

/*N*/ SfxVirtualMenu::~SfxVirtualMenu()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_DTOR(SfxVirtualMenu, 0);
/*N*/ 
/*N*/     DELETEZ( pImageControl );
/*N*/     SvtMenuOptions().RemoveListener( LINK( this, SfxVirtualMenu, SettingsChanged ) );
/*N*/ 
/*N*/ 	if ( bIsActive )
/*N*/ 	{
/*?*/ 		pBindings->LEAVEREGISTRATIONS(); --nLocks; bIsActive = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	// QAP-Hack
/*N*/ 	if ( pAutoDeactivate )
/*N*/ 	{
/*N*/ 		if ( pAutoDeactivate->IsActive() )
/*N*/ 			Deactivate(0);
/*N*/ 		DELETEX(pAutoDeactivate);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pItems)
/*N*/ 	{
/*N*/ #ifdef MPW
/*N*/ 		// der MPW-Compiler ruft sonst keine Dtoren!
/*?*/ 		for ( USHORT n = 0; n < nCount; ++n )
/*?*/ 			(pItems+n)->SfxMenuControl::~SfxMenuControl();
/*?*/ 		delete (void*) pItems;
/*N*/ #else
/*N*/ 		delete [] pItems;
/*N*/ #endif
/*N*/ 	}
/*N*/ 
//STRIP001 /*N*/ 	delete pAppCtrl;
/*N*/ 	pBindings = 0;
/*N*/ 
/*N*/ 	// Alle Menues, die von SV erzeugt wurden, werden auch dort wieder
/*N*/ 	// gel"oscht (also die beim Laden aus der Resource erzeugten).
/*N*/ 	// Das Top-Level-Menu wird nie von SV gel"oscht, da die Allocierung
/*N*/ 	// im SFX erfolgt
/*N*/ 	if ( !bResCtor || !pParent)
/*N*/ 	{
/*N*/         if ( pParent )
/*N*/         {
/*?*/             if( pParent->pSVMenu->GetItemPos( nId ) != MENU_ITEM_NOTFOUND )
/*?*/                 pParent->pSVMenu->SetPopupMenu( nId, 0 );
/*?*/             if ( pParent->pPickMenu == pSVMenu )
/*?*/                 pParent->pPickMenu = 0;
/*?*/             if ( pParent->pWindowMenu == pSVMenu)
/*?*/                 pParent->pWindowMenu = 0;
/*N*/             if ( pParent->pAddonsMenu == pSVMenu )
/*N*/ 				pParent->pAddonsMenu = 0;
/*N*/         }
/*N*/ 
/*N*/ 		delete pSVMenu;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_OUTF( ("SfxVirtualMenu %lx destroyed", this) );
/*N*/ 	DBG_ASSERT( !nLocks, "destroying active menu" );
/*N*/ }
//--------------------------------------------------------------------

/*N*/ BOOL SfxVirtualMenu::IsHiContrastMode() const
/*N*/ {
/*N*/ 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 	Color aMenuColor = rSettings.GetMenuColor();
/*N*/ 	if ( aMenuColor.IsDark() )
/*N*/ 		return TRUE;
/*N*/ 	else
/*N*/ 		return FALSE;
/*N*/ }

//--------------------------------------------------------------------
// internal: creates the virtual menu from the pSVMenu

/*N*/ void SfxVirtualMenu::CreateFromSVMenu()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	// Merge Addon popup menus into the SV Menu
/*N*/ 	Reference< ::com::sun::star::frame::XFrame > xFrame( pBindings->GetDispatcher()->GetFrame()->GetFrame()->GetFrameInterface() );
/*N*/ 	
/*N*/ 	if ( pSVMenu->IsMenuBar() )
/*N*/ 	{
/*N*/ 		USHORT nPos = pSVMenu->GetItemPos( SID_MDIWINDOWLIST );
/*N*/ 		if ( nPos != MENU_ITEM_NOTFOUND && xFrame.is() )
/*N*/ 		{
/*N*/ 			// Retrieve addon popup menus and add them to our menu bar
/*N*/ 			Reference< ::com::sun::star::frame::XModel >		xModel;
/*N*/ 			Reference< ::com::sun::star::frame::XController >	xController( xFrame->getController(), UNO_QUERY );
/*N*/ 			if ( xController.is() )
/*N*/ 				xModel = Reference< ::com::sun::star::frame::XModel >( xController->getModel(), UNO_QUERY );
/*N*/ 			framework::AddonMenuManager::MergeAddonPopupMenus( xFrame, xModel, nPos, (MenuBar *)pSVMenu );
/*N*/ 		}
/*N*/ 		
/*N*/         // Merge the Add-Ons help menu items into the Office help menu
/*N*/ 		if ( xFrame.is() )
/*N*/ 		    framework::AddonMenuManager::MergeAddonHelpMenu( xFrame, (MenuBar *)pSVMenu );
/*N*/ 		    
/*N*/         // Set addon menu pointer here to avoid problems. When accessibility is enabled, the whole menu 
/*N*/         // is created immediately!
/*N*/ 		pAddonsMenu = pSVMenu->GetPopupMenu( SID_ADDONLIST );
/*N*/ 	}
/*N*/ 	else if ( pParent )
/*N*/ 	{
/*N*/ 		if ( pSVMenu == pParent->pAddonsMenu &&
/*N*/ 			 framework::AddonsOptions().HasAddonsMenu() &&
/*N*/ 			 !pSVMenu->GetPopupMenu( SID_ADDONS ) )
/*N*/ 		{
/*N*/ 			// Create menu item at the end of the tools popup menu for the addons popup menu
/*?*/ 			DBG_BF_ASSERT(0, "STRIP");//STRIP001 InsertAddOnsMenuItem( pSVMenu );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// get and store the number of items
/*N*/ 	nCount = pSVMenu->GetItemCount();
/*N*/ 
/*N*/ 	// Achtung: nur zu diesem Zeitpunkt ist garantiert, da\s nCount und
/*N*/ 	// der ItemCount des SV-Menues "ubereinstimmen; sp"ater kann das SvMenue
/*N*/ 	// auch mehr Eintr"age haben (Pickliste!)
/*N*/ 	if (nCount)
/*N*/ 		pItems = new SfxMenuControl[nCount];
/*N*/ 
/*N*/ 	// remember some values
/*N*/ 	SfxApplication *pSfxApp = SFX_APP();
/*N*/ 	const int bOleServer = FALSE;
/*N*/ 	const int bMac = FALSE;
/*N*/     SfxViewFrame *pViewFrame = pBindings->GetDispatcher()->GetFrame();
/*N*/     SfxModule* pModule = pViewFrame->GetObjectShell()->GetModule();
/*N*/ 	SvtMenuOptions aOptions;
/*N*/     aOptions.AddListener( LINK( this, SfxVirtualMenu, SettingsChanged ) );
/*N*/ 
/*N*/ 	// iterate through the items
/*N*/ 	pBindings->ENTERREGISTRATIONS(); ++nLocks;
/*N*/     pImageControl = new SfxMenuImageControl_Impl( SID_IMAGE_ORIENTATION, *pBindings, this );
/*N*/ 
/*N*/ 	// Update high contrast state
/*N*/ 	bWasHighContrast = IsHiContrastMode();
/*N*/ 
/*N*/ 	USHORT nSVPos = 0;
/*N*/ 	for ( USHORT nPos=0; nPos<nCount; ++nPos, ++nSVPos )
/*N*/ 	{
/*N*/ 		USHORT nId = pSVMenu->GetItemId(nSVPos);
/*N*/ 		PopupMenu* pPopup = pSVMenu->GetPopupMenu(nId);
/*N*/ 		if( pPopup && nId >= SID_OBJECTMENU0 && nId <= SID_OBJECTMENU_LAST )
/*N*/ 		{
/*N*/ 			// artefact in XML menuconfig: every entry in root menu must have a popup!
/*?*/ 			pSVMenu->SetPopupMenu( nId, NULL );
/*?*/ 			DELETEZ( pPopup );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pPopup )
/*N*/ 		{
/*N*/ 			DBG_ASSERT( SfxMenuManager::IsPopupFunction(nId) ||
/*N*/ 						!SFX_SLOTPOOL().GetIdPool().IsLocked(nId),
/*N*/ 						"popupmenu with existing func-id" );
/*N*/ 			SfxMenuControl *pMnuCtrl =
/*N*/ 				SfxMenuControl::CreateControl(nId, *pPopup, *pBindings);
/*N*/ 
/*N*/ 			if ( pMnuCtrl )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				// Das Popup war offensichtlich kein "echtes"; solche werden
//STRIP001 /*?*/ 				// niemals aus der Resource geladen und m"ussen daher explizit
//STRIP001 /*?*/ 				// gel"oscht werden
//STRIP001 /*?*/ 				if ( pSVMenu->GetPopupMenu( nId ) == pPopup )
//STRIP001 /*?*/ 					pSVMenu->SetPopupMenu( nId, NULL );
//STRIP001 /*?*/ 				DELETEZ( pPopup );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SfxMenuCtrlArr_Impl &rCtrlArr = GetAppCtrl_Impl();
//STRIP001 /*?*/ 				rCtrlArr.C40_INSERT( SfxMenuControl, pMnuCtrl, rCtrlArr.Count() );
//STRIP001 /*?*/ 				(pItems+nPos)->Bind( 0, nId, pSVMenu->GetItemText(nId),
//STRIP001 /*?*/ 									pSVMenu->GetHelpText(nId), *pBindings);
//STRIP001 /*?*/ 				pMnuCtrl->Bind( this, nId, pSVMenu->GetItemText(nId),
//STRIP001 /*?*/ 								pSVMenu->GetHelpText(nId), *pBindings);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 if (  aOptions.IsMenuIconsEnabled() )
//STRIP001 /*?*/                     pSVMenu->SetItemImage( nId, pBindings->GetImageManager()->GetImage( nId, pModule, FALSE, bWasHighContrast ) );
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*
				if ( nId >= SID_SFX_START && !SfxMenuManager::IsPopupFunction(nId) )
				{
					// Echte Popups sollen keine SlotIds haben; leider sind
					// da noch Altlasten mit herumzuschleppen ...
					String aTitle = pSVMenu->GetItemText( nId );
					pSVMenu->SetPopupMenu( nId, NULL );
					USHORT nPos = pSVMenu->GetItemPos( nId );
					pSVMenu->RemoveItem( nPos );
					nId = 1;
					while ( pSVMenu->GetItemPos(nId) != MENU_ITEM_NOTFOUND )
						nId++;
					pSVMenu->InsertItem( nId, aTitle, 0, nPos );
					pSVMenu->SetPopupMenu( nId, pPopup );
				}
*/
/*N*/ 				pSVMenu->SetHelpId( nId, 0L );
/*N*/ 				pMnuCtrl = pItems+nPos;
/*N*/ 
/*N*/ 				// normalerweise jetzt erst im Activate-Handler
/*N*/ 				if ( bOLE )
/*N*/ 				{
/*N*/ 					pMnuCtrl->Bind( this, nId,
/*N*/ 						*new SfxVirtualMenu(nId, this, *pPopup, bHelpInitialized, *pBindings, bOLE, bResCtor),
/*N*/ 						pSVMenu->GetItemText(nId), pSVMenu->GetHelpText(nId),
/*N*/ 						*pBindings );
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			++nVisibleItems;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			switch ( pSVMenu->GetItemType(nSVPos) )
/*N*/ 			{
/*N*/ 				case MENUITEM_STRING:
/*N*/ 				case MENUITEM_STRINGIMAGE:
/*N*/ 				{
/*N*/                     SfxMenuControl *pMnuCtrl=0;
/*N*/ 					String aCmd( pSVMenu->GetItemCommand( nId ) );
/*N*/ 					if ( aCmd.CompareToAscii("slot:", 5) == 0 )
/*N*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 						SfxMacroConfig* pCfg = SFX_APP()->GetMacroConfig();
//STRIP001 /*?*/                         if ( pCfg->IsMacroSlot( nId ) )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if ( pCfg->GetMacroInfo( nId ) )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/                             	pCfg->RegisterSlotId( nId );
//STRIP001 /*?*/ 		                        pSVMenu->SetItemCommand( nId, String() );
//STRIP001 /*?*/ 								aCmd.Erase();
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								pSVMenu->SetItemCommand( nId, String::CreateFromAscii("macro:///macro.not.founc") );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
/*N*/ 					}
/*N*/ 
/*N*/                     if ( aCmd.Len() && (( nId < SID_SFX_START ) || ( nId > SHRT_MAX )) )
/*N*/ 					{{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
//STRIP001 /*N*/                         // try to create control via comand name
//STRIP001 /*N*/                         pMnuCtrl = SfxMenuControl::CreateControl( aCmd, nId, *pSVMenu, *pBindings, this );
//STRIP001 /*N*/ 						if ( pMnuCtrl )
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							SfxMenuCtrlArr_Impl &rCtrlArr = GetAppCtrl_Impl();
//STRIP001 /*N*/                             rCtrlArr.C40_INSERT( SfxMenuControl, pMnuCtrl, rCtrlArr.Count());
//STRIP001 /*N*/                             (pItems+nPos)->Bind( 0, nId, pSVMenu->GetItemText(nId), pSVMenu->GetHelpText(nId), *pBindings);
//STRIP001 /*N*/ 						}
/*N*/ 					}
/*N*/ 
/*N*/                     if ( !pMnuCtrl )
/*N*/ 					{
/*N*/                         // try to create control via Id
/*N*/                         pMnuCtrl = SfxMenuControl::CreateControl(nId, *pSVMenu, *pBindings);
/*N*/ 						if ( pMnuCtrl )
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 							SfxMenuCtrlArr_Impl &rCtrlArr = GetAppCtrl_Impl();
//STRIP001 /*?*/                             rCtrlArr.C40_INSERT( SfxMenuControl, pMnuCtrl, rCtrlArr.Count());
//STRIP001 /*?*/                             (pItems+nPos)->Bind( 0, nId, pSVMenu->GetItemText(nId), pSVMenu->GetHelpText(nId), *pBindings);
/*N*/ 						}
/*N*/ 						else
/*N*/                             // take default control
/*N*/ 							pMnuCtrl = (pItems+nPos);
/*N*/ 
/*N*/                         pMnuCtrl->Bind( this, nId, pSVMenu->GetItemText(nId), pSVMenu->GetHelpText(nId), *pBindings);
/*N*/ 					}
/*N*/ 
/*N*/                     if ( aOptions.IsMenuIconsEnabled() )
/*N*/                     {
/*N*/                         // try to get image via URL
/*N*/ //                        Image aImage = SvFileInformationManager::GetImage( aCmd, FALSE, bWasHighContrast );
/*N*/ //                        if ( !aImage )
/*N*/                             // try to get image via Id
/*N*/ 						Image aImage;
/*N*/ 						if ( bIsAddonPopupMenu || framework::AddonMenuManager::IsAddonMenuId( nId ))
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/ 							::rtl::OUString aCmd( pSVMenu->GetItemCommand( nId ) );
//STRIP001 /*?*/ 							::rtl::OUString aImageId;
//STRIP001 /*?*/ 							
//STRIP001 /*?*/ 							::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 /*?*/ 								(::framework::MenuConfiguration::Attributes*)pSVMenu->GetUserValue( nId );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if ( pMenuAttributes )
//STRIP001 /*?*/ 								aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 /*?*/ 							
//STRIP001 /*?*/ 							aImage = RetrieveAddOnImage( xFrame, aImageId, aCmd, FALSE, bWasHighContrast );
/*N*/ 						}
/*N*/ 						else
/*N*/ 							aImage = pBindings->GetImageManager()->GetImage( nId, pModule, FALSE, bWasHighContrast );
/*N*/ 						
/*N*/ 						if ( !!aImage )
/*N*/ 							pSVMenu->SetItemImage( nId, aImage );
/*N*/                     }
/*N*/ 
/*N*/ 					if ( !IsItemHidden_Impl(nId, bOleServer, bMac) )
/*N*/ 						++nVisibleItems;
/*N*/ 					else
/*N*/ 						pSVMenu->RemoveItem( nSVPos-- );
/*N*/ 					break;
/*N*/ 				}
/*N*/ 
/*N*/ 				case MENUITEM_IMAGE:
/*N*/ 					//! not implemented
/*N*/ 					break;
/*N*/ 
/*N*/ 				case MENUITEM_SEPARATOR:
/*N*/ 					//! not implemented
/*N*/ 					break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	pBindings->LEAVEREGISTRATIONS(); --nLocks;
/*N*/ }

//--------------------------------------------------------------------

// called on activation of the SV-Menu

/*?*/ IMPL_LINK( SfxVirtualMenu, Highlight, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 
//STRIP001 	// eigenes StarView-Menu
//STRIP001 	if ( pMenu == pSVMenu )
//STRIP001 	{
//STRIP001 		// AutoDeactivate ist jetzt nicht mehr n"otig
//STRIP001 		USHORT nId = pMenu->GetCurItemId();
//STRIP001 		if ( pAutoDeactivate )
//STRIP001 			pAutoDeactivate->Stop();
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
/*?*/ }

/*?*/ IMPL_LINK( SfxVirtualMenu, SettingsChanged, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	SvtMenuOptions aOptions;
//STRIP001     USHORT nCount = pSVMenu->GetItemCount();
//STRIP001     SfxViewFrame *pViewFrame = pBindings->GetDispatcher()->GetFrame();
//STRIP001     SfxModule* pModule = pViewFrame->GetObjectShell()->GetModule();
//STRIP001     BOOL bIcons = aOptions.IsMenuIconsEnabled();
//STRIP001 	BOOL bIsHiContrastMode = IsHiContrastMode();
//STRIP001 	Reference< ::com::sun::star::frame::XFrame> xFrame( pViewFrame->GetFrame()->GetFrameInterface() );
//STRIP001 	
//STRIP001 	if ( !bIsAddonPopupMenu )
//STRIP001 	{
//STRIP001 		for ( USHORT nSVPos=0; nSVPos<nCount; ++nSVPos )
//STRIP001 		{
//STRIP001 			USHORT          nId   = pSVMenu->GetItemId( nSVPos );
//STRIP001 			MenuItemType    nType = pSVMenu->GetItemType( nSVPos );
//STRIP001 			if ( nType == MENUITEM_STRING && bIcons )
//STRIP001 			{
//STRIP001 				if ( framework::AddonMenuManager::IsAddonMenuId( nId ))
//STRIP001 				{
//STRIP001                     // Special code for Add-On menu items. They can appear inside the help menu.
//STRIP001 					::rtl::OUString aCmd( pSVMenu->GetItemCommand( nId ) );
//STRIP001 					::rtl::OUString aImageId;
//STRIP001 					
//STRIP001 					::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 						(::framework::MenuConfiguration::Attributes*)pSVMenu->GetUserValue( nId );
//STRIP001 
//STRIP001 					if ( pMenuAttributes )
//STRIP001 						aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 					
//STRIP001 					pSVMenu->SetItemImage( nId, RetrieveAddOnImage( xFrame, aImageId, aCmd, FALSE, bIsHiContrastMode ));
//STRIP001 				}
//STRIP001 				else
//STRIP001 				    pSVMenu->SetItemImage( nId, pBindings->GetImageManager()->GetImage( nId, pModule, FALSE, bIsHiContrastMode ) );
//STRIP001 			}
//STRIP001 			else if( nType == MENUITEM_STRINGIMAGE && !bIcons )
//STRIP001 			{
//STRIP001 				pSVMenu->SetItemImage( nId, Image() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Remove/update images from Add-Ons top-level popup menus when settings have changed
//STRIP001 		if ( !bIcons )
//STRIP001 			RemoveMenuImages( pSVMenu );
//STRIP001 		else
//STRIP001 			UpdateImages( pSVMenu );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Special code to remove menu images from runtime popup menus when settings have changed
//STRIP001 	if ( pParent && pSVMenu == pParent->pAddonsMenu )
//STRIP001 	{
//STRIP001 		if ( !bIcons )
//STRIP001 			RemoveMenuImages( pParent->pAddonsMenu->GetPopupMenu( SID_ADDONS ));
//STRIP001 		else
//STRIP001 			UpdateImages( pParent->pAddonsMenu->GetPopupMenu( SID_ADDONS ));
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pImageControl )
//STRIP001         pImageControl->Update();
//STRIP001 
//STRIP001     return 0;
/*?*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxVirtualMenu::UpdateImages()
//STRIP001 {
//STRIP001 	SvtMenuOptions aOptions;
//STRIP001     BOOL bIcons = aOptions.IsMenuIconsEnabled();
//STRIP001 
//STRIP001 	if ( bIcons )
//STRIP001 	{
//STRIP001 		BOOL			bIsHiContrastMode	= IsHiContrastMode();
//STRIP001 		USHORT			nCount				= pSVMenu->GetItemCount();
//STRIP001 		SfxViewFrame *	pViewFrame			= pBindings->GetDispatcher()->GetFrame();
//STRIP001 		SfxModule*		pModule				= pViewFrame->GetObjectShell()->GetModule();
//STRIP001 		Reference< ::com::sun::star::frame::XFrame> xFrame( pViewFrame->GetFrame()->GetFrameInterface() );
//STRIP001 
//STRIP001 		for ( USHORT nSVPos=0; nSVPos < nCount; ++nSVPos )
//STRIP001 		{
//STRIP001 			USHORT nId = pSVMenu->GetItemId( nSVPos );
//STRIP001 			if ( pSVMenu->GetItemType( nSVPos ) == MENUITEM_STRINGIMAGE )
//STRIP001 			{
//STRIP001                 if ( framework::AddonMenuManager::IsAddonMenuId( nId ))
//STRIP001                 {
//STRIP001                     // Special code for Add-On menu items. They can appear inside the help menu.
//STRIP001 					::rtl::OUString aCmd( pSVMenu->GetItemCommand( nId ) );
//STRIP001 					::rtl::OUString aImageId;
//STRIP001 					
//STRIP001 					::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 						(::framework::MenuConfiguration::Attributes*)pSVMenu->GetUserValue( nId );
//STRIP001 
//STRIP001 					if ( pMenuAttributes )
//STRIP001 						aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 					
//STRIP001 					pSVMenu->SetItemImage( nId, RetrieveAddOnImage( xFrame, aImageId, aCmd, FALSE, bIsHiContrastMode ));
//STRIP001                 }
//STRIP001                 else
//STRIP001 				    pSVMenu->SetItemImage( nId, pBindings->GetImageManager()->GetImage( nId, pModule, FALSE, bIsHiContrastMode ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         if ( pImageControl )
//STRIP001             pImageControl->Update();
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxVirtualMenu::UpdateImages( Menu* pMenu )
//STRIP001 {
//STRIP001 	if ( !pMenu )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SvtMenuOptions				aOptions;
//STRIP001 	framework::AddonsOptions	aAddonOptions;
//STRIP001 
//STRIP001     BOOL bIcons = aOptions.IsMenuIconsEnabled();
//STRIP001 	if ( bIcons )
//STRIP001 	{
//STRIP001 		BOOL			bIsHiContrastMode	= IsHiContrastMode();
//STRIP001 		USHORT			nCount				= pMenu->GetItemCount();
//STRIP001 		SfxViewFrame *	pViewFrame			= pBindings->GetDispatcher()->GetFrame();
//STRIP001 		SfxModule*		pModule				= pViewFrame->GetObjectShell()->GetModule();
//STRIP001 		Reference< ::com::sun::star::frame::XFrame> aXFrame( pBindings->GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
//STRIP001 
//STRIP001 		for ( USHORT nPos=0; nPos < nCount; ++nPos )
//STRIP001 		{
//STRIP001 			USHORT nId = pMenu->GetItemId( nPos );
//STRIP001 			PopupMenu* pPopup = pMenu->GetPopupMenu( nId );
//STRIP001 			if ( pMenu->GetItemType( nPos ) != MENUITEM_SEPARATOR )
//STRIP001 			{
//STRIP001 				sal_Bool	  bImageSet = sal_False;
//STRIP001 				::rtl::OUString aImageId;
//STRIP001 				 
//STRIP001 				::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 					(::framework::MenuConfiguration::Attributes*)pMenu->GetUserValue( nId );
//STRIP001 
//STRIP001 				if ( pMenuAttributes )
//STRIP001 					aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 
//STRIP001 				pMenu->SetItemImage( nId, RetrieveAddOnImage( aXFrame, aImageId, pMenu->GetItemCommand( nId ), FALSE, bIsHiContrastMode ));
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pPopup )
//STRIP001 				UpdateImages( pPopup );
//STRIP001 		}
//STRIP001 
//STRIP001         if ( pImageControl )
//STRIP001             pImageControl->Update();
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxVirtualMenu::RemoveMenuImages( Menu* pMenu )
//STRIP001 {
//STRIP001 	if ( !pMenu )
//STRIP001 		return;
//STRIP001 
//STRIP001 	USHORT	nCount = pMenu->GetItemCount();
//STRIP001 	for ( USHORT nPos=0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		USHORT nId = pMenu->GetItemId( nPos );
//STRIP001 		PopupMenu* pPopup = pMenu->GetPopupMenu( nId );
//STRIP001 		if ( pMenu->GetItemType( nPos ) == MENUITEM_STRINGIMAGE )
//STRIP001 			pMenu->SetItemImage( nId, Image() );
//STRIP001 		if ( pPopup )
//STRIP001 			RemoveMenuImages( pPopup );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 FASTBOOL SfxVirtualMenu::Bind_Impl( Menu *pMenu )
//STRIP001 {
//STRIP001 	// Selber suchen, da SV mit 'USHORT nSID = pSVMenu->GetCurItemId();' immer
//STRIP001 	// 0 liefert. Das ist so, weil die Event-Weiterleitung lt. TH nichts mit
//STRIP001 	// CurItem des Parent-Menus zu tun hat.
//STRIP001 	BOOL bIsMenuBar = pSVMenu->IsMenuBar();
//STRIP001 	sal_uInt32 nAddonsPopupPrefixLen = ADDONSPOPUPMENU_URL_PREFIX.getLength();
//STRIP001 
//STRIP001 	for ( USHORT nPos = 0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		// angesprochenes Sub-Menu gefunden?
//STRIP001 		FASTBOOL bFound = FALSE;
//STRIP001 		USHORT nSID = pSVMenu->GetItemId(nPos);
//STRIP001 		SfxMenuControl &rCtrl = pItems[nPos];
//STRIP001 		bFound = pSVMenu->GetPopupMenu(nSID) == pMenu;
//STRIP001 		SfxVirtualMenu *pSubMenu = rCtrl.GetPopupMenu();
//STRIP001 
//STRIP001 		if ( bFound )
//STRIP001 		{
//STRIP001 			// Nur ein gebundener Menu-Controller hat schon seine Id!
//STRIP001 			if ( !rCtrl.GetId() )
//STRIP001 			{
//STRIP001 				BOOL bIsAddonPopupMenu = FALSE;
//STRIP001 				DBG_ASSERT( !pSubMenu, "Popup schon vorhanden!");
//STRIP001 
//STRIP001 				// Check if the popup is an Add-On popup menu
//STRIP001 				// Either the popup menu has a special ID  or a special command URL prefix!
//STRIP001 				::rtl::OUString aCommand = pSVMenu->GetItemCommand( nSID );
//STRIP001 				if ( ( nSID == SID_ADDONS ) || 
//STRIP001 					 ( nSID == SID_ADDONHELP ) ||
//STRIP001 					 (( (sal_uInt32)aCommand.getLength() > nAddonsPopupPrefixLen ) &&
//STRIP001 					  ( aCommand.indexOf( ADDONSPOPUPMENU_URL_PREFIX ) == 0 )) )
//STRIP001 					bIsAddonPopupMenu = TRUE;
//STRIP001 
//STRIP001 				// VirtualMenu f"ur Sub-Menu erzeugen
//STRIP001 				BOOL bRes = bResCtor;
//STRIP001 				SfxVirtualMenu *pSubMenu = new SfxVirtualMenu( nSID, this,
//STRIP001 						*pMenu, FALSE, *pBindings, bOLE, bRes, bIsAddonPopupMenu );
//STRIP001 
//STRIP001 				DBG_OUTF( ("Neues VirtualMenu %lx erzeugt", pSubMenu) );
//STRIP001 
//STRIP001 				rCtrl.Bind( this, nSID, *pSubMenu,
//STRIP001 					pSVMenu->GetItemText(nSID), pSVMenu->GetHelpText(nSID),
//STRIP001 					*pBindings );
//STRIP001 
//STRIP001 				// Activate weiterleiten
//STRIP001 				pSubMenu->Bind_Impl( pMenu );
//STRIP001 				pSubMenu->Activate( pMenu );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// rekursiv weitersuchen (SV Activate nur am Menu selbst und Top-Menu)
//STRIP001 		if ( !bFound && pSubMenu )
//STRIP001 			bFound = pSubMenu->Bind_Impl( pMenu );
//STRIP001 
//STRIP001 		// gefunden, dann abbrechen
//STRIP001 		if ( bFound )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// nicht in diesem Untermenu gefunden
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void SfxVirtualMenu::BindControllers()
//STRIP001 {
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001 	for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		SfxMenuControl& rCtrl = pItems[nPos];
//STRIP001 		if ( rCtrl.IsBindable_Impl() && !rCtrl.GetPopupMenu() )
//STRIP001 			rCtrl.ReBind();
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxMenuCtrlArr_Impl& rCtrlArr = GetAppCtrl_Impl();
//STRIP001 	for ( nPos=0; nPos<rCtrlArr.Count(); nPos++ )
//STRIP001 	{
//STRIP001 		SfxMenuControl* pCtrl = rCtrlArr[nPos];
//STRIP001 		USHORT nId = pCtrl->GetId();
//STRIP001         if ( !pSVMenu->GetItemCommand(nId).Len() )
//STRIP001 			pCtrl->ReBind();
//STRIP001 	}
//STRIP001 
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	bControllersUnBound = FALSE;
//STRIP001 }

//STRIP001 void SfxVirtualMenu::UnbindControllers()
//STRIP001 {
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 	USHORT nPos;
//STRIP001 	for ( nPos = 0; nPos < nCount; ++nPos )
//STRIP001 	{
//STRIP001 		SfxMenuControl &rCtrl = pItems[nPos];
//STRIP001 		if ( rCtrl.IsBound() )
//STRIP001 			rCtrl.UnBind();
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxMenuCtrlArr_Impl& rCtrlArr = GetAppCtrl_Impl();
//STRIP001 	for ( nPos=0; nPos<rCtrlArr.Count(); nPos++ )
//STRIP001 	{
//STRIP001 		SfxMenuControl* pCtrl = rCtrlArr[nPos];
//STRIP001 		if ( pCtrl->IsBound() )
//STRIP001 			// UnoController sind nicht gebunden!
//STRIP001 			pCtrl->UnBind();
//STRIP001 	}
//STRIP001 
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	bControllersUnBound = TRUE;
//STRIP001 }


//--------------------------------------------------------------------
//STRIP001 void SfxVirtualMenu::InsertAddOnsMenuItem( Menu* pMenu )
//STRIP001 {
//STRIP001 	// Create special popup menu that is filled with the 3rd party components popup menu items
//STRIP001 	Reference< ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001 	::framework::MenuConfiguration aConf( aXMultiServiceFactory );
//STRIP001 	Reference< ::com::sun::star::frame::XFrame> xFrame( pBindings->GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
//STRIP001 	
//STRIP001 	PopupMenu* pAddonMenu = NULL;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		pAddonMenu = framework::AddonMenuManager::CreateAddonMenu( xFrame );
//STRIP001 	}
//STRIP001 	catch ( ::com::sun::star::lang::WrappedTargetException )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	// Create menu item at the end of the tools popup menu for the addons popup menu
//STRIP001 	if ( pAddonMenu && pAddonMenu->GetItemCount() > 0 )
//STRIP001 	{
//STRIP001 	    USHORT nCount = pMenu->GetItemCount();
//STRIP001 	    String aAddonsTitle( SfxResId( STR_MENU_ADDONS ));
//STRIP001 	    if ( nCount > 0 && pMenu->GetItemType( nCount-1 ) != MENUITEM_SEPARATOR )
//STRIP001 		    pMenu->InsertSeparator();
//STRIP001 	    pMenu->InsertItem( SID_ADDONS, aAddonsTitle );
//STRIP001         pMenu->SetPopupMenu( SID_ADDONS, pAddonMenu );
//STRIP001 
//STRIP001 	    if ( SvtMenuOptions().IsMenuIconsEnabled() )
//STRIP001 	    {
//STRIP001 		    SfxModule* pModule = pBindings->GetDispatcher()->GetFrame()->GetObjectShell()->GetModule();
//STRIP001 		    pMenu->SetItemImage( SID_ADDONS, pBindings->GetImageManager()->GetImage( SID_ADDONS, pModule, FALSE, IsHiContrastMode() ) );
//STRIP001 	    }
//STRIP001     }
//STRIP001 	else
//STRIP001 	    delete pAddonMenu;
//STRIP001 }

//--------------------------------------------------------------------

// called on activation of the SV-Menu

/*?*/ IMPL_LINK( SfxVirtualMenu, Activate, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 	DBG_OUTF( ("SfxVirtualMenu %lx activated %lx, own %lx", this, pMenu, pSVMenu));
//STRIP001 
//STRIP001 	// MI: wozu war der noch gut?
//STRIP001 	// MBA: scheint ein alter QAP-Hack gewesen zu sein ( in rev.1.41 eingecheckt ! )
//STRIP001 //	if ( Application::IsInModalMode() )
//STRIP001 //		return TRUE; // abw"urgen
//STRIP001 
//STRIP001 	if ( pMenu )
//STRIP001 	{
//STRIP001 		sal_Bool bDontHide = SvtMenuOptions().IsEntryHidingEnabled();
//STRIP001 		sal_uInt16 nFlag = pMenu->GetMenuFlags();
//STRIP001 		if ( bDontHide )
//STRIP001 			nFlag &= ~MENU_FLAG_HIDEDISABLEDENTRIES;
//STRIP001 		else
//STRIP001 			nFlag |= MENU_FLAG_HIDEDISABLEDENTRIES;
//STRIP001 		pMenu->SetMenuFlags( nFlag );
//STRIP001 	}
//STRIP001 
//STRIP001 	// eigenes StarView-Menu
//STRIP001 	if ( pMenu == pSVMenu )
//STRIP001 	{
//STRIP001 		// doppelt-Activate verhindern
//STRIP001 		if ( bIsActive )
//STRIP001 			return TRUE;
//STRIP001 
//STRIP001 		// ggf. Pick-Menu erzeugen
//STRIP001         if ( pParent && pSVMenu == pParent->pPickMenu )
//STRIP001         {
//STRIP001 			SfxPickList::Get()->CreateMenuEntries( pParent->pPickMenu );
//STRIP001         }
//STRIP001         else
//STRIP001             pPickMenu = pSVMenu->GetPopupMenu(SID_PICKLIST);
//STRIP001 
//STRIP001         if ( pParent && pSVMenu == pParent->pWindowMenu )
//STRIP001         {
//STRIP001 			// update window list
//STRIP001 			::std::vector< ::rtl::OUString > aNewWindowListVector;
//STRIP001 			Reference< XDesktop > xDesktop( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 											DEFINE_CONST_OUSTRING( "com.sun.star.frame.Desktop" ) ), UNO_QUERY );
//STRIP001 
//STRIP001 			USHORT	nActiveItemId = 0;
//STRIP001 			USHORT	nItemId = START_ITEMID_WINDOWLIST;
//STRIP001 
//STRIP001 			if ( xDesktop.is() )
//STRIP001 			{
//STRIP001                 Reference< XFramesSupplier > xTasksSupplier( xDesktop, UNO_QUERY );
//STRIP001 				Reference< XFrame > xCurrentFrame = xDesktop->getCurrentFrame();
//STRIP001                 Reference< XIndexAccess > xList ( xTasksSupplier->getFrames(), UNO_QUERY );
//STRIP001                 sal_Int32 nCount = xList->getCount();
//STRIP001                 for( sal_Int32 i=0; i<nCount; ++i )
//STRIP001 				{
//STRIP001                     Reference< XFrame > xFrame;
//STRIP001                     Any aVal = xList->getByIndex(i);
//STRIP001 					if (!(aVal>>=xFrame) || !xFrame.is() )
//STRIP001 						continue;
//STRIP001 
//STRIP001 					if ( xFrame == xCurrentFrame )
//STRIP001 						nActiveItemId = nItemId;
//STRIP001 
//STRIP001 					Window* pWin = VCLUnoHelper::GetWindow( xFrame->getContainerWindow() );
//STRIP001 					if ( pWin && pWin->IsVisible() )
//STRIP001 					{
//STRIP001 						aNewWindowListVector.push_back( pWin->GetText() );
//STRIP001 						++nItemId;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			int	nRemoveItemCount = 0;
//STRIP001 			int	nItemCount		 = pMenu->GetItemCount();
//STRIP001 
//STRIP001 			if ( nItemCount > 0 )
//STRIP001 			{
//STRIP001 				// remove all old window list entries from menu
//STRIP001 				sal_uInt16 nPos = pMenu->GetItemPos( START_ITEMID_WINDOWLIST );
//STRIP001             	for ( sal_uInt16 n = nPos; n < pMenu->GetItemCount(); )
//STRIP001                 	pMenu->RemoveItem( n );
//STRIP001 
//STRIP001 				if ( pMenu->GetItemType( pMenu->GetItemCount()-1 ) == MENUITEM_SEPARATOR )
//STRIP001                 	pMenu->RemoveItem( pMenu->GetItemCount()-1 );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( aNewWindowListVector.size() > 0 )
//STRIP001 			{
//STRIP001 				// append new window list entries to menu
//STRIP001 				pMenu->InsertSeparator();
//STRIP001 				nItemId = START_ITEMID_WINDOWLIST;
//STRIP001 				for ( sal_uInt32 i = 0; i < aNewWindowListVector.size(); i++ )
//STRIP001 				{
//STRIP001 					pMenu->InsertItem( nItemId, aNewWindowListVector.at( i ), MIB_RADIOCHECK );
//STRIP001 					if ( nItemId == nActiveItemId )
//STRIP001 						pMenu->CheckItem( nItemId );
//STRIP001 					++nItemId;
//STRIP001 				}
//STRIP001 			}
//STRIP001         }
//STRIP001         else
//STRIP001             pWindowMenu = pSVMenu->GetPopupMenu(SID_MDIWINDOWLIST);
//STRIP001 
//STRIP001         if ( !pParent && pSVMenu->IsMenuBar() && !pAddonsMenu )
//STRIP001         {
//STRIP001 			// Store Add-Ons parents of our runtime menu items
//STRIP001 			pAddonsMenu	= pSVMenu->GetPopupMenu( SID_ADDONLIST );
//STRIP001 		}
//STRIP001 
//STRIP001 		// f"ur konstistenten Status sorgen
//STRIP001 		if ( bControllersUnBound )
//STRIP001 			BindControllers();
//STRIP001 
//STRIP001 		InvalidateKeyCodes();
//STRIP001 		pBindings->GetDispatcher_Impl()->Flush();
//STRIP001 		for ( USHORT nPos = 0; nPos < nCount; ++nPos )
//STRIP001 		{
//STRIP001 			USHORT nId = (pItems+nPos)->GetId();
//STRIP001             if ( nId && nId > END_ITEMID_WINDOWLIST )
//STRIP001 				pBindings->Update(nId);
//STRIP001 		}
//STRIP001 
//STRIP001         pBindings->Update( SID_IMAGE_ORIENTATION );
//STRIP001 
//STRIP001 		// HelpText on-demand
//STRIP001 		if ( !bHelpInitialized )
//STRIP001 		{
//STRIP001 			bHelpInitialized = TRUE;
//STRIP001 			SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
//STRIP001 			for ( USHORT nPos = 0; nPos < pMenu->GetItemCount(); ++nPos )
//STRIP001 			{
//STRIP001 				USHORT nId = pMenu->GetItemId(nPos);
//STRIP001 				pMenu->SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// bis zum Deactivate die Statusupdates unterdr"ucken
//STRIP001 		pBindings->ENTERREGISTRATIONS(); ++nLocks; bIsActive = TRUE;
//STRIP001 
//STRIP001 		if ( pAutoDeactivate ) // QAP-Hack
//STRIP001 			pAutoDeactivate->Start();
//STRIP001 
//STRIP001 		if ( IsHiContrastMode() != bWasHighContrast )
//STRIP001 		{
//STRIP001 			// Refresh images as our background color changed and remember it!!
//STRIP001 			bWasHighContrast = IsHiContrastMode();
//STRIP001 			if ( bIsAddonPopupMenu )
//STRIP001 				UpdateImages( pSVMenu );
//STRIP001 			else
//STRIP001 				UpdateImages();
//STRIP001 		}
//STRIP001 
//STRIP001 		// erledigt
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// VirtualMenu fuer SubMenu finden und ggf. an VirtualMenu binden
//STRIP001 		BOOL bRet = Bind_Impl( pMenu );
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		if ( !bRet)
//STRIP001 			DBG_WARNING( "W1: Virtual menu konnte nicht erzeugt werden!" );
//STRIP001 #endif
//STRIP001 		return bRet;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE; // dead code for WTC
/*?*/ }

//--------------------------------------------------------------------

/*?*/ IMPL_LINK( SfxVirtualMenu, Deactivate, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_OUTF( ("SfxVirtualMenu %lx deactivated %lx, own %lx", this, pMenu, pSVMenu) );
//STRIP001 	if ( bIsActive && ( 0 == pMenu || pMenu == pSVMenu ) )
//STRIP001 	{
//STRIP001 		if ( pAutoDeactivate )
//STRIP001 			pAutoDeactivate->Stop();
//STRIP001 
//STRIP001 		// Bis auf die Menubar k"onnen alle Controller unbinded werden, wenn
//STRIP001 		// das Menue deaktiviert ( = zugeklappt ) wird
//STRIP001 		if ( pParent )
//STRIP001 			UnbindControllers();
//STRIP001 		pBindings->LEAVEREGISTRATIONS(); --nLocks; bIsActive = FALSE;
//STRIP001 	}
//STRIP001 	return TRUE;
/*?*/ }
//--------------------------------------------------------------------

// called on activation of the SV-Menu

/*?*/ IMPL_LINK( SfxVirtualMenu, Select, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	USHORT nId = (USHORT) pMenu->GetCurItemId();
//STRIP001 	DBG_OUTF( ("SfxVirtualMenu %lx selected %u from %lx", this, nId, pMenu) );
//STRIP001 /*
//STRIP001 	if ( pSVMenu->GetItemCommand( nId ).Len() )
//STRIP001 	{
//STRIP001 		SfxMenuCtrlArr_Impl& rCtrlArr = GetAppCtrl_Impl();
//STRIP001 		for ( USHORT nPos=0; nPos<rCtrlArr.Count(); nPos++ )
//STRIP001 		{
//STRIP001 			SfxMenuControl* pCtrl = rCtrlArr[nPos];
//STRIP001 			if ( pCtrl->GetId() == nId )
//STRIP001 			{
//STRIP001 				SfxUnoMenuControl *pUnoCtrl = (SfxUnoMenuControl*) pCtrl;
//STRIP001 				pUnoCtrl->Select();
//STRIP001 				return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 */
//STRIP001     if ( nId >= START_ITEMID_WINDOWLIST && nId <= END_ITEMID_WINDOWLIST )
//STRIP001 	{
//STRIP001 		// window list menu item selected
//STRIP001         Reference< XFramesSupplier > xDesktop( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 										DEFINE_CONST_OUSTRING( "com.sun.star.frame.Desktop" ) ), UNO_QUERY );
//STRIP001 		USHORT	nWindowItemId = START_ITEMID_WINDOWLIST;
//STRIP001 
//STRIP001 		if ( xDesktop.is() )
//STRIP001 		{
//STRIP001 			USHORT nTaskId = START_ITEMID_WINDOWLIST;
//STRIP001             Reference< XIndexAccess > xList( xDesktop->getFrames(), UNO_QUERY );
//STRIP001             sal_Int32 nCount = xList->getCount();
//STRIP001             for ( sal_Int32 i=0; i<nCount; ++i )
//STRIP001 			{
//STRIP001                 Any aItem = xList->getByIndex(i);
//STRIP001                 Reference< XFrame > xFrame;
//STRIP001 				if (( aItem >>= xFrame ) && xFrame.is() && nTaskId == nId )
//STRIP001 				{
//STRIP001                     Window* pWin = VCLUnoHelper::GetWindow( xFrame->getContainerWindow() );
//STRIP001 					pWin->GrabFocus();
//STRIP001                     pWin->ToTop( TOTOP_RESTOREWHENMIN );
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				nTaskId++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001     else if ( nId >= START_ITEMID_PICKLIST && nId <= END_ITEMID_PICKLIST )
//STRIP001     {
//STRIP001         SfxPickList::Get()->ExecuteMenuEntry( nId );
//STRIP001         return sal_True;
//STRIP001     }
//STRIP001 
//STRIP001 	if ( pMenu->GetItemCommand( nId ).Len() )
//STRIP001 		pBindings->ExecuteCommand_Impl( pMenu->GetItemCommand( nId ) );
//STRIP001 	else
//STRIP001 		pBindings->Execute( nId );
//STRIP001 
//STRIP001 	return TRUE;
/*?*/ }

//--------------------------------------------------------------------

// returns the associated StarView-menu

/*N*/ Menu* SfxVirtualMenu::GetSVMenu() const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	return pSVMenu;
/*N*/ }

//--------------------------------------------------------------------

// return the position of the specified item

/*N*/ USHORT SfxVirtualMenu::GetItemPos( USHORT nItemId ) const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	for ( USHORT nPos = 0; nPos < nCount; ++nPos )
/*N*/ 		if ( (pItems+nPos)->GetId() == nItemId )
/*N*/ 			return nPos;
/*N*/ 	return MENU_ITEM_NOTFOUND;
/*N*/ }

//--------------------------------------------------------------------

// returns the popup-menu assigned to the item or 0 if none

/*N*/ SfxVirtualMenu* SfxVirtualMenu::GetPopupMenu( USHORT nId ) const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	USHORT nPos = GetItemPos(nId);
/*N*/ 	if ( nPos != MENU_ITEM_NOTFOUND )
/*N*/ 		return (pItems+nPos)->GetPopupMenu();
/*N*/ 	return 0;
/*N*/ }
//--------------------------------------------------------------------

// returns the text of the item as currently shown in the menu

//STRIP001 String SfxVirtualMenu::GetItemText( USHORT nId ) const
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 
//STRIP001 	USHORT nPos = GetItemPos(nId);
//STRIP001 	if ( nPos != MENU_ITEM_NOTFOUND )
//STRIP001 		return (pItems+nPos)->GetTitle();
//STRIP001 	return String();
//STRIP001 }
//--------------------------------------------------------------------

// returns the text of the item as currently shown in the menu

//STRIP001 String SfxVirtualMenu::GetItemHelpText( USHORT nId ) const
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 
//STRIP001 	USHORT nPos = GetItemPos(nId);
//STRIP001 	if ( nPos != MENU_ITEM_NOTFOUND )
//STRIP001 		return (pItems+nPos)->GetHelpText();
//STRIP001 	return String();
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxVirtualMenu::InvalidateKeyCodes()
/*N*/ {
/*N*/ 	DBG_ASSERT( pSVMenu, "invalidating key of incomplete menu" );
/*N*/ 
/*N*/     SfxApplication* pSfxApp = SFX_APP();
/*N*/     SfxViewFrame *pViewFrame = pBindings->GetDispatcher()->GetFrame();
/*N*/     SfxAcceleratorManager* pAccMgr = pViewFrame->GetViewShell()->GetAccMgr_Impl();
/*N*/ 	SfxAcceleratorManager* pAppAccel = pSfxApp->GetAppAccel_Impl();
/*N*/ 	if ( !pAccMgr )
/*N*/ 		pAccMgr = pAppAccel;
/*N*/ 
/*N*/ 	for ( USHORT nPos = 0; nPos < pSVMenu->GetItemCount(); ++nPos )
/*N*/ 	{
/*N*/ 		USHORT nId = pSVMenu->GetItemId(nPos);
/*N*/         SfxVirtualMenu *pPopup = GetPopupMenu(nId);
/*N*/ //        if ( pPopup )
/*N*/ //            pPopup->InvalidateKeyCodes();
/*N*/ //        else if ( nId )
/*N*/         if ( nId && !pSVMenu->GetPopupMenu( nId ) )
/*N*/ 		{
/*N*/ 			KeyCode aCode = pAccMgr->GetKeyCode( nId );
/*N*/ 			if ( !aCode.GetCode() && pAccMgr != pAppAccel )
/*N*/ 				aCode = pAppAccel->GetKeyCode( nId );
/*N*/ 			pSVMenu->SetAccelKey( nId, aCode );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

// set the checkmark of the specified item

/*N*/ void SfxVirtualMenu::CheckItem( USHORT nItemId, BOOL bCheck )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 	DBG_ASSERT( this != 0, "");
/*N*/ 	DBG_ASSERT( pSVMenu != 0, "" );
/*N*/ 	if (pSVMenu->GetItemPos( nItemId ) != MENU_ITEM_NOTFOUND )
/*N*/ 		pSVMenu->CheckItem( nItemId, bCheck );
/*N*/ }
//--------------------------------------------------------------------

// set the enabled-state of the specified item

/*N*/ void SfxVirtualMenu::EnableItem( USHORT nItemId, BOOL bEnable )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 	DBG_ASSERT( this != 0, "");
/*N*/ 	DBG_ASSERT( pSVMenu != 0, "" );
/*N*/ 
/*N*/ 	if (pSVMenu->GetItemPos( nItemId ) != MENU_ITEM_NOTFOUND )
/*N*/ 		pSVMenu->EnableItem( nItemId, bEnable );
/*N*/ }
//--------------------------------------------------------------------

// set the text of the specified item

//STRIP001 void SfxVirtualMenu::SetItemText( USHORT nItemId, const String& rText )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 	DBG_ASSERT( this != 0, "");
//STRIP001 	DBG_ASSERT( pSVMenu != 0, "" );
//STRIP001 	if (pSVMenu->GetItemPos( nItemId ) != MENU_ITEM_NOTFOUND )
//STRIP001 		pSVMenu->SetItemText( nItemId, rText );
//STRIP001 }

//--------------------------------------------------------------------

//

//STRIP001 void SfxVirtualMenu::SetPopupMenu( USHORT nId, PopupMenu *pMenu )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 
//STRIP001 	if (pSVMenu->GetItemPos( nId ) != MENU_ITEM_NOTFOUND )
//STRIP001 		GetSVMenu()->SetPopupMenu( nId, pMenu );
//STRIP001 	for ( USHORT n = 0; n < nCount; ++n )
//STRIP001 	{
//STRIP001 		SfxVirtualMenu *pSubMenu = (pItems+n)->GetPopupMenu();
//STRIP001 		if ( pSubMenu )
//STRIP001 			pSubMenu->SetPopupMenu( nId, pMenu );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

// Erzwingt die Initialisierung, die sonst nur im Activate kommt

//STRIP001 void SfxVirtualMenu::InitPopup( USHORT nPos, BOOL bOLE )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxVirtualMenu, 0);
//STRIP001 
//STRIP001 	USHORT nSID = pSVMenu->GetItemId(nPos);
//STRIP001 	PopupMenu *pMenu = pSVMenu->GetPopupMenu( nSID );
//STRIP001 
//STRIP001 	DBG_ASSERT( pMenu, "Hier gibt es kein Popup!");
//STRIP001 
//STRIP001 	SfxMenuControl &rCtrl = pItems[nPos];
//STRIP001 	if ( !rCtrl.GetId() )
//STRIP001 	{
//STRIP001 		// VirtualMenu f"ur Sub-Menu erzeugen
//STRIP001 		BOOL bRes = bResCtor;
//STRIP001 		SfxVirtualMenu *pSubMenu =
//STRIP001 			new SfxVirtualMenu(nSID, this, *pMenu, FALSE, *pBindings, bOLE, bRes);
//STRIP001 
//STRIP001 		DBG_OUTF( ("Neues VirtualMenu %lx erzeugt", pSubMenu) );
//STRIP001 
//STRIP001 		rCtrl.Bind( this, nSID, *pSubMenu,
//STRIP001 			pSVMenu->GetItemText(nSID), pSVMenu->GetHelpText(nSID),
//STRIP001 			*pBindings );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxVirtualMenu::InitializeHelp()
//STRIP001 {
//STRIP001 	SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
//STRIP001 	for ( USHORT nPos = 0; nPos<pSVMenu->GetItemCount(); ++nPos )
//STRIP001 	{
//STRIP001 		USHORT nId = pSVMenu->GetItemId(nPos);
//STRIP001 		if ( !bHelpInitialized )
//STRIP001 			pSVMenu->SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl( nId ) );
//STRIP001 		SfxMenuControl &rCtrl = pItems[nPos];
//STRIP001 		if ( nId && !rCtrl.GetId() )
//STRIP001 		{
//STRIP001 			InitPopup( nPos, TRUE );
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxVirtualMenu *pSubMenu = rCtrl.GetPopupMenu();
//STRIP001 		if ( pSubMenu )
//STRIP001 			pSubMenu->InitializeHelp();
//STRIP001 	}
//STRIP001 
//STRIP001 	bHelpInitialized = TRUE;
//STRIP001 }

typedef ULONG (__LOADONCALLAPI *HelpIdFunc) ( const String& );

//STRIP001 void SfxVirtualMenu::SetHelpIds( ResMgr *pRes )
//STRIP001 {
//STRIP001 	pResMgr = pRes;
//STRIP001 }

}
