/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hangulhanjadlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:46:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVX_HANGUL_HANJA_DLG_HXX
#include "hangulhanjadlg.hxx"
#endif
#ifndef SVX_HANGUL_HANJA_DLG_HRC
#include "hangulhanjadlg.hrc"
#endif

#ifndef SVX_COMMON_LINGUI_HXX
#include "commonlingui.hxx"
#endif

#ifndef _SVX_DIALMGR_HXX 
#include "dialmgr.hxx"
#endif

#include "dialogs.hrc"
#include "helpid.hrc"

#include <algorithm>

#ifndef _VCL_CONTROLLAYOUT_HXX 
#include <vcl/controllayout.hxx>
#endif
namespace binfilter {

#define HHC HangulHanjaConversion

//.............................................................................
//STRIP001 namespace svx
//STRIP001 {
//STRIP001 //.............................................................................
//STRIP001 /*
//STRIP001 	using HangulHanjaConversion::eSimpleConversion;
//STRIP001 	using HangulHanjaConversion::eHangulBracketed;
//STRIP001 	using HangulHanjaConversion::eHanjaBracketed;
//STRIP001 	using HangulHanjaConversion::eRubyHanjaAbove;
//STRIP001 	using HangulHanjaConversion::eRubyHanjaBelow;
//STRIP001 	using HangulHanjaConversion::eRubyHangulAbove;
//STRIP001 	using HangulHanjaConversion::eRubyHangulBelow;
//STRIP001 */
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	namespace
//STRIP001 	{
//STRIP001 		class FontSwitch
//STRIP001 		{
//STRIP001 		private:
//STRIP001 			OutputDevice& m_rDev;
//STRIP001 
//STRIP001 		public:
//STRIP001 			inline FontSwitch( OutputDevice& _rDev, const Font& _rTemporaryFont )
//STRIP001 				:m_rDev( _rDev )
//STRIP001 			{
//STRIP001 				m_rDev.Push( PUSH_FONT );
//STRIP001 				m_rDev.SetFont( _rTemporaryFont );
//STRIP001 			}
//STRIP001 			inline ~FontSwitch( )
//STRIP001 			{
//STRIP001 				m_rDev.Pop( );
//STRIP001 			}
//STRIP001 		};
//STRIP001 	}
//STRIP001 
//STRIP001 	//=========================================================================
//STRIP001 	//= PseudoRubyText
//STRIP001 	//=========================================================================
//STRIP001 	/** a class which allows to draw two texts in a pseudo-ruby way (which basically
//STRIP001 		means one text above or below the other, and a little bit smaller)
//STRIP001 	*/
//STRIP001 	class PseudoRubyText
//STRIP001 	{
//STRIP001 	public:
//STRIP001 		enum RubyPosition
//STRIP001 		{
//STRIP001 			eAbove, eBelow
//STRIP001 		};
//STRIP001 
//STRIP001 	protected:
//STRIP001 		const String		m_sPrimaryText;
//STRIP001 		const String		m_sSecondaryText;
//STRIP001 		const RubyPosition	m_ePosition;
//STRIP001 
//STRIP001 	public:
//STRIP001 		PseudoRubyText( const String& _rPrimary, const String& _rSecondary, const RubyPosition _ePosition );
//STRIP001 
//STRIP001 	public:
//STRIP001 		void Paint( OutputDevice& _rDevice, const Rectangle& _rRect, USHORT _nTextStyle,
//STRIP001 			Rectangle* _pPrimaryLocation = NULL, Rectangle* _pSecondaryLocation = NULL,
//STRIP001 			::vcl::ControlLayoutData* _pLayoutData = NULL );
//STRIP001 	};
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	PseudoRubyText::PseudoRubyText( const String& _rPrimary, const String& _rSecondary, const RubyPosition _ePosition )
//STRIP001 		:m_sPrimaryText( _rPrimary )
//STRIP001 		,m_sSecondaryText( _rSecondary )
//STRIP001 		,m_ePosition( _ePosition )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void PseudoRubyText::Paint( OutputDevice& _rDevice, const Rectangle& _rRect, USHORT _nTextStyle,
//STRIP001 		Rectangle* _pPrimaryLocation, Rectangle* _pSecondaryLocation, ::vcl::ControlLayoutData* _pLayoutData )
//STRIP001 	{
//STRIP001 		bool			bLayoutOnly	 = NULL != _pLayoutData;
//STRIP001 		MetricVector*	pTextMetrics = bLayoutOnly ? &_pLayoutData->m_aUnicodeBoundRects : NULL;
//STRIP001 		String*			pDisplayText = bLayoutOnly ? &_pLayoutData->m_aDisplayText		 : NULL;
//STRIP001 
//STRIP001 		Size aPlaygroundSize( _rRect.GetSize() );
//STRIP001 
//STRIP001 		// the font for the secondary text:
//STRIP001 		Font aSmallerFont( _rDevice.GetFont() );
//STRIP001 		// heuristic: 80% of the original size
//STRIP001 		aSmallerFont.SetHeight( (long)( 0.8 * aSmallerFont.GetHeight() ) );
//STRIP001 
//STRIP001 		// let's calculate the size of our two texts
//STRIP001 		Rectangle aPrimaryRect = _rDevice.GetTextRect( _rRect, m_sPrimaryText, _nTextStyle );
//STRIP001 		Rectangle aSecondaryRect;
//STRIP001 		{
//STRIP001 			FontSwitch aFontRestore( _rDevice, aSmallerFont );
//STRIP001 			aSecondaryRect = _rDevice.GetTextRect( _rRect, m_sSecondaryText, _nTextStyle );
//STRIP001 		}
//STRIP001 
//STRIP001 		// position these rectangles properly
//STRIP001 		// x-axis:
//STRIP001 		sal_Int32 nCombinedWidth = ::std::max( aSecondaryRect.GetWidth(), aPrimaryRect.GetWidth() );
//STRIP001 			// the rectangle where both texts will reside is as high as possible, and as wide as the
//STRIP001 			// widest of both text rects
//STRIP001 		aPrimaryRect.Left() = aSecondaryRect.Left() = _rRect.Left();
//STRIP001 		aPrimaryRect.Right() = aSecondaryRect.Right() = _rRect.Left() + nCombinedWidth;
//STRIP001 		if ( TEXT_DRAW_RIGHT & _nTextStyle )
//STRIP001 		{
//STRIP001 			// move the rectangles to the right
//STRIP001 			aPrimaryRect.Move( aPlaygroundSize.Width() - nCombinedWidth, 0 );
//STRIP001 			aSecondaryRect.Move( aPlaygroundSize.Width() - nCombinedWidth, 0 );
//STRIP001 		}
//STRIP001 		else if ( TEXT_DRAW_CENTER & _nTextStyle )
//STRIP001 		{
//STRIP001 			// center the rectangles
//STRIP001 			aPrimaryRect.Move( ( aPlaygroundSize.Width() - nCombinedWidth ) / 2, 0 );
//STRIP001 			aSecondaryRect.Move( ( aPlaygroundSize.Width() - nCombinedWidth ) / 2, 0 );
//STRIP001 		}
//STRIP001 
//STRIP001 		// y-axis:
//STRIP001 		sal_Int32 nCombinedHeight = aPrimaryRect.GetHeight() + aSecondaryRect.GetHeight();
//STRIP001 		// align to the top, for the moment
//STRIP001 		aPrimaryRect.Move( 0, _rRect.Top() - aPrimaryRect.Top() );
//STRIP001 		aSecondaryRect.Move( 0, aPrimaryRect.Top() + aPrimaryRect.GetHeight() - aSecondaryRect.Top() );
//STRIP001 		if ( TEXT_DRAW_BOTTOM & _nTextStyle )
//STRIP001 		{
//STRIP001 			// move the rects to the bottom
//STRIP001 			aPrimaryRect.Move( 0, aPlaygroundSize.Height() - nCombinedHeight );
//STRIP001 			aSecondaryRect.Move( 0, aPlaygroundSize.Height() - nCombinedHeight );
//STRIP001 		}
//STRIP001 		else if ( TEXT_DRAW_VCENTER & _nTextStyle )
//STRIP001 		{
//STRIP001 			// move the rects to the bottom
//STRIP001 			aPrimaryRect.Move( 0, ( aPlaygroundSize.Height() - nCombinedHeight ) / 2 );
//STRIP001 			aSecondaryRect.Move( 0, ( aPlaygroundSize.Height() - nCombinedHeight ) / 2 );
//STRIP001 		}
//STRIP001 
//STRIP001 		// 'til here, everything we did assumes that the secondary text is painted _below_ the primary
//STRIP001 		// text. If this isn't the case, we need to correct the rectangles
//STRIP001 		if ( eAbove == m_ePosition )
//STRIP001 		{
//STRIP001 			sal_Int32 nVertDistance = aSecondaryRect.Top() - aPrimaryRect.Top();
//STRIP001 			aSecondaryRect.Move( 0, -nVertDistance );
//STRIP001 			aPrimaryRect.Move( 0, nCombinedHeight - nVertDistance );
//STRIP001 		}
//STRIP001 
//STRIP001 		// now draw the texts
//STRIP001 		// as we already calculated the precise rectangles for the texts, we don't want to
//STRIP001 		// use the alignment flags given - within it's rect, every text is centered
//STRIP001 		USHORT nDrawTextStyle( _nTextStyle );
//STRIP001 		nDrawTextStyle &= ~( TEXT_DRAW_RIGHT | TEXT_DRAW_LEFT | TEXT_DRAW_BOTTOM | TEXT_DRAW_TOP );
//STRIP001 		nDrawTextStyle |= TEXT_DRAW_CENTER | TEXT_DRAW_VCENTER;
//STRIP001 
//STRIP001 		_rDevice.DrawText( aPrimaryRect, m_sPrimaryText, nDrawTextStyle, pTextMetrics, pDisplayText );
//STRIP001 		{
//STRIP001 			FontSwitch aFontRestore( _rDevice, aSmallerFont );
//STRIP001 			_rDevice.DrawText( aSecondaryRect, m_sSecondaryText, nDrawTextStyle, pTextMetrics, pDisplayText );
//STRIP001 		}
//STRIP001 
//STRIP001 		// outta here
//STRIP001 		if ( _pPrimaryLocation )
//STRIP001 			*_pPrimaryLocation = aPrimaryRect;
//STRIP001 		if ( _pSecondaryLocation )
//STRIP001 			*_pSecondaryLocation = aSecondaryRect;
//STRIP001 	}
//STRIP001 
//STRIP001 	//=========================================================================
//STRIP001 	//= RubyRadioButton
//STRIP001 	//=========================================================================
//STRIP001 	class RubyRadioButton	:public RadioButton
//STRIP001 							,protected PseudoRubyText
//STRIP001 	{
//STRIP001 	public:
//STRIP001 		RubyRadioButton(
//STRIP001 			Window* _pParent,
//STRIP001 			const ResId& _rId,			// the text in the resource will be taken as primary text
//STRIP001 			const String& _rSecondary,	// this will be the secondary text which will be printed somewhat smaller
//STRIP001 			const PseudoRubyText::RubyPosition _ePosition );
//STRIP001 
//STRIP001 	protected:
//STRIP001 		virtual void	Paint( const Rectangle& _rRect );
//STRIP001 	};
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	RubyRadioButton::RubyRadioButton( Window* _pParent, const ResId& _rId,
//STRIP001 		const String& _rSecondary, const PseudoRubyText::RubyPosition _ePosition )
//STRIP001 		:RadioButton( _pParent, _rId )
//STRIP001 		,PseudoRubyText( RadioButton::GetText(), _rSecondary, _ePosition )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void RubyRadioButton::Paint( const Rectangle& _rRect )
//STRIP001 	{
//STRIP001 		HideFocus();
//STRIP001 
//STRIP001 		// calculate the size of the radio image - we're to paint our text _after_ this image
//STRIP001 		DBG_ASSERT( !GetImage(), "RubyRadioButton::Paint: images not supported!" );
//STRIP001 		Size aImageSize = GetRadioImage( GetSettings(), 0 ).GetSizePixel();
//STRIP001 		aImageSize.Width()  = CalcZoom( aImageSize.Width() );
//STRIP001 		aImageSize.Height()  = CalcZoom( aImageSize.Height() );
//STRIP001 
//STRIP001 		Rectangle aOverallRect( Point( 0, 0 ), GetOutputSizePixel() );
//STRIP001 		aOverallRect.Left() += aImageSize.Width() + 4;	// 4 is the separator between the image and the text
//STRIP001 		// inflate the rect a little bit (because the VCL radio button does the same)
//STRIP001 		Rectangle aTextRect( aOverallRect );
//STRIP001 		++aTextRect.Left(); --aTextRect.Right();
//STRIP001 		++aTextRect.Top(); --aTextRect.Bottom();
//STRIP001 
//STRIP001 		// calculate the text flags for the painting
//STRIP001 		USHORT nTextStyle = TEXT_DRAW_MNEMONIC;
//STRIP001 		WinBits nStyle = GetStyle( );
//STRIP001 
//STRIP001 		// the horizontal alignment
//STRIP001 		if ( nStyle & WB_RIGHT )
//STRIP001 			nTextStyle |= TEXT_DRAW_RIGHT;
//STRIP001 		else if ( nStyle & WB_CENTER )
//STRIP001 			nTextStyle |= TEXT_DRAW_CENTER;
//STRIP001 		else
//STRIP001 			nTextStyle |= TEXT_DRAW_LEFT;
//STRIP001 		// the vertical alignment
//STRIP001 		if ( nStyle & WB_BOTTOM )
//STRIP001 			nTextStyle |= TEXT_DRAW_BOTTOM;
//STRIP001 		else if ( nStyle & WB_VCENTER )
//STRIP001 			nTextStyle |= TEXT_DRAW_VCENTER;
//STRIP001 		else
//STRIP001 			nTextStyle |= TEXT_DRAW_TOP;
//STRIP001 		// mnemonics
//STRIP001 		if ( 0 == ( nStyle & WB_NOLABEL ) )
//STRIP001 			nTextStyle |= TEXT_DRAW_MNEMONIC;
//STRIP001 
//STRIP001 		// paint the ruby text
//STRIP001 		Rectangle aPrimaryTextLocation, aSecondaryTextLocation;
//STRIP001 		PseudoRubyText::Paint( *this, aTextRect, nTextStyle, &aPrimaryTextLocation, &aSecondaryTextLocation );
//STRIP001 
//STRIP001 		// the focus rectangle is to be painted around both texts
//STRIP001 		Rectangle aCombinedRect( aPrimaryTextLocation );
//STRIP001 		aCombinedRect.Union( aSecondaryTextLocation );
//STRIP001 		SetFocusRect( aCombinedRect );
//STRIP001 
//STRIP001 		// let the base class paint the radio button
//STRIP001 		// for this, give it the proper location to paint the image (vertically centered, relative to our text)
//STRIP001 		Rectangle aImageLocation( Point( 0, 0 ), aImageSize );
//STRIP001 		sal_Int32 nTextHeight = aSecondaryTextLocation.Bottom() - aPrimaryTextLocation.Top();
//STRIP001 		aImageLocation.Top() = aPrimaryTextLocation.Top() + ( nTextHeight - aImageSize.Height() ) / 2;
//STRIP001 		aImageLocation.Bottom() = aImageLocation.Top() + aImageSize.Height();
//STRIP001 		SetStateRect( aImageLocation );
//STRIP001 		DrawRadioButtonState( );
//STRIP001 
//STRIP001 		// mouse clicks should be recognized in a rect which is one pixel larger in each direction, plus
//STRIP001 		// includes the image
//STRIP001 		aCombinedRect.Left() = aImageLocation.Left(); ++aCombinedRect.Right();
//STRIP001 		--aCombinedRect.Top(); ++aCombinedRect.Bottom();
//STRIP001 		SetMouseRect( aCombinedRect );
//STRIP001 
//STRIP001 		// paint the focus rect, if necessary
//STRIP001 		if ( HasFocus() )
//STRIP001 			ShowFocus( aTextRect );
//STRIP001 	}
//STRIP001 
//STRIP001 	//=========================================================================
//STRIP001 	//= HangulHanjaConversionDialog
//STRIP001 	//=========================================================================
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001     HangulHanjaConversionDialog::HangulHanjaConversionDialog( Window* _pParent, HHC::ConversionDirection _ePrimaryDirection )
//STRIP001 		:ModalDialog( _pParent, SVX_RES( RID_SVX_MDLG_HANGULHANJA ) )
//STRIP001 		,m_pPlayground( new SvxCommonLinguisticControl( this ) )
//STRIP001 		,m_aFind			( m_pPlayground.get(), ResId( PB_FIND ) )
//STRIP001 		,m_aSuggestions		( m_pPlayground.get(), ResId( LB_SUGGESTIONS ) )
//STRIP001 		,m_aFormat			( m_pPlayground.get(), ResId( FT_FORMAT ) )
//STRIP001 		,m_aSimpleConversion( m_pPlayground.get(), ResId( RB_SIMPLE_CONVERSION ) )
//STRIP001 		,m_aHangulBracketed	( m_pPlayground.get(), ResId( RB_HANJA_HANGUL_BRACKETED ) )
//STRIP001 		,m_aHanjaBracketed	( m_pPlayground.get(), ResId( RB_HANGUL_HANJA_BRACKETED ) )
//STRIP001 		,m_aConversion		( m_pPlayground.get(), ResId( FT_CONVERSION ) )
//STRIP001 		,m_aHangulOnly		( m_pPlayground.get(), ResId( CB_HANGUL_ONLY ) )
//STRIP001 		,m_aHanjaOnly		( m_pPlayground.get(), ResId( CB_HANJA_ONLY ) )
//STRIP001 		,m_aReplaceByChar	( m_pPlayground.get(), ResId( CB_REPLACE_BY_CHARACTER ) )
//STRIP001 		,m_pIgnoreNonPrimary( NULL )
//STRIP001 		,m_bDocumentMode( true )
//STRIP001 	{
//STRIP001 		// special creation of the 4 pseudo-ruby radio buttons
//STRIP001 		String sSecondaryHangul( ResId( STR_HANGUL ) );
//STRIP001 		String sSecondaryHanja( ResId( STR_HANJA ) );
//STRIP001 		m_pHanjaAbove.reset( new RubyRadioButton( m_pPlayground.get(), ResId( RB_HANGUL_HANJA_ABOVE ), sSecondaryHanja, PseudoRubyText::eAbove ) );
//STRIP001 		m_pHanjaBelow.reset( new RubyRadioButton( m_pPlayground.get(), ResId( RB_HANGUL_HANJA_BELOW ), sSecondaryHanja, PseudoRubyText::eBelow ) );
//STRIP001 		m_pHangulAbove.reset( new RubyRadioButton( m_pPlayground.get(), ResId( RB_HANJA_HANGUL_ABOVE ), sSecondaryHangul, PseudoRubyText::eAbove ) );
//STRIP001 		m_pHangulBelow.reset( new RubyRadioButton( m_pPlayground.get(), ResId( RB_HANJA_HANGUL_BELOW ), sSecondaryHangul, PseudoRubyText::eBelow ) );
//STRIP001 
//STRIP001 		// since these 4 buttons are not created within the other members, they have a wrong initial Z-Order
//STRIP001 		// correct this
//STRIP001 		m_pHanjaAbove->SetZOrder( &m_aHanjaBracketed, WINDOW_ZORDER_BEHIND );
//STRIP001 		m_pHanjaBelow->SetZOrder( m_pHanjaAbove.get(), WINDOW_ZORDER_BEHIND );
//STRIP001 		m_pHangulAbove->SetZOrder( m_pHanjaBelow.get(), WINDOW_ZORDER_BEHIND );
//STRIP001 		m_pHangulBelow->SetZOrder( m_pHangulAbove.get(), WINDOW_ZORDER_BEHIND );
//STRIP001 
//STRIP001 		// VCL automatically sets the WB_GROUP bit, if the previous sibling (at the moment of creation)
//STRIP001 		// is no radion button
//STRIP001 		m_pHanjaAbove->SetStyle( m_pHanjaAbove->GetStyle() & ~WB_GROUP );
//STRIP001 
//STRIP001 		// the "Find" button and the word input control may not have the proper distance/extensions
//STRIP001 		// -> correct this
//STRIP001 		Point aDistance = LogicToPixel( Point( 3, 0 ), MAP_APPFONT );
//STRIP001 		sal_Int32 nTooLargeByPixels =
//STRIP001 			// right margin of the word input control
//STRIP001 			(	m_pPlayground->GetWordInputControl().GetPosPixel().X()
//STRIP001 			+	m_pPlayground->GetWordInputControl().GetSizePixel().Width()
//STRIP001 			)
//STRIP001 			// minus left margin of the find button
//STRIP001 			-	m_aFind.GetPosPixel().X()
//STRIP001 			// plus desired distance between the both
//STRIP001 			+	aDistance.X();
//STRIP001 		// make the word input control smaller
//STRIP001 		Size aSize = m_pPlayground->GetWordInputControl().GetSizePixel();
//STRIP001 		aSize.Width() -= nTooLargeByPixels;
//STRIP001 		m_pPlayground->GetWordInputControl().SetSizePixel( aSize );
//STRIP001 
//STRIP001 		// additionall, the playground is not wide enough (in it's default size)
//STRIP001 		sal_Int32 nEnlargeWidth = 0;
//STRIP001 		{
//STRIP001 			FixedText aBottomAnchor( m_pPlayground.get(), ResId( FT_RESIZE_ANCHOR ) );
//STRIP001 			Point aAnchorPos = aBottomAnchor.GetPosPixel();
//STRIP001 
//STRIP001 			nEnlargeWidth = aAnchorPos.X() - m_pPlayground->GetActionButtonsLocation().X();
//STRIP001 		}
//STRIP001 		m_pPlayground->Enlarge( nEnlargeWidth, 0 );
//STRIP001 
//STRIP001 		// insert our controls into the z-order of the playground
//STRIP001 		m_pPlayground->InsertControlGroup( m_aFind, m_aFind, SvxCommonLinguisticControl::eLeftRightWords );
//STRIP001 		m_pPlayground->InsertControlGroup( m_aSuggestions, m_aHanjaOnly, SvxCommonLinguisticControl::eSuggestionLabel );
//STRIP001 		m_pPlayground->InsertControlGroup( m_aReplaceByChar, m_aReplaceByChar, SvxCommonLinguisticControl::eActionButtons );
//STRIP001 
//STRIP001 		m_pPlayground->SetButtonHandler( SvxCommonLinguisticControl::eClose, LINK( this, HangulHanjaConversionDialog, OnClose ) );
//STRIP001 		m_pPlayground->GetWordInputControl().SetModifyHdl( LINK( this,  HangulHanjaConversionDialog, OnSuggestionModified ) );
//STRIP001 		m_aSuggestions.SetSelectHdl( LINK( this,  HangulHanjaConversionDialog, OnSuggestionSelected ) );
//STRIP001 
//STRIP001 		if ( HangulHanjaConversion::eHangulToHanja == _ePrimaryDirection )
//STRIP001 		{
//STRIP001 			m_aHanjaOnly.Enable( sal_False );
//STRIP001 			m_pIgnoreNonPrimary = &m_aHangulOnly;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			m_aHangulOnly.Enable( sal_False );
//STRIP001 			m_pIgnoreNonPrimary = &m_aHanjaOnly;
//STRIP001 		}
//STRIP001         m_pIgnoreNonPrimary->Check();
//STRIP001 
//STRIP001 		// initial focus
//STRIP001 		FocusSuggestion( );
//STRIP001 
//STRIP001 		// initial control values
//STRIP001 		m_aSimpleConversion.Check();
//STRIP001 
//STRIP001         m_pPlayground->GetButton(SvxCommonLinguisticControl::eClose     )->SetHelpId(HID_HANGULDLG_BUTTON_CLOSE    );
//STRIP001         m_pPlayground->GetButton(SvxCommonLinguisticControl::eIgnore    )->SetHelpId(HID_HANGULDLG_BUTTON_IGNORE   );
//STRIP001         m_pPlayground->GetButton(SvxCommonLinguisticControl::eIgnoreAll )->SetHelpId(HID_HANGULDLG_BUTTON_IGNOREALL);
//STRIP001         m_pPlayground->GetButton(SvxCommonLinguisticControl::eChange    )->SetHelpId(HID_HANGULDLG_BUTTON_CHANGE   );
//STRIP001         m_pPlayground->GetButton(SvxCommonLinguisticControl::eChangeAll )->SetHelpId(HID_HANGULDLG_BUTTON_CHANGEALL);
//STRIP001         m_pPlayground->GetWordInputControl().SetHelpId(HID_HANGULDLG_EDIT_NEWWORD);
//STRIP001         
//STRIP001         FreeResource();
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	HangulHanjaConversionDialog::~HangulHanjaConversionDialog( )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::FillSuggestions( const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rSuggestions )
//STRIP001 	{
//STRIP001 		m_aSuggestions.Clear();
//STRIP001 
//STRIP001 		const ::rtl::OUString* pSuggestions = _rSuggestions.getConstArray();
//STRIP001 		const ::rtl::OUString* pSuggestionsEnd = _rSuggestions.getConstArray() + _rSuggestions.getLength();
//STRIP001 		while ( pSuggestions != pSuggestionsEnd )
//STRIP001 			m_aSuggestions.InsertEntry( *pSuggestions++ );
//STRIP001 
//STRIP001 		// select the first suggestion, and fill in the suggestion edit field
//STRIP001 		String sFirstSuggestion;
//STRIP001 		if ( m_aSuggestions.GetEntryCount() )
//STRIP001 		{
//STRIP001 			sFirstSuggestion = m_aSuggestions.GetEntry( 0 );
//STRIP001 			m_aSuggestions.SelectEntryPos( 0 );
//STRIP001 		}
//STRIP001 		m_pPlayground->GetWordInputControl().SetText( sFirstSuggestion );
//STRIP001 		m_pPlayground->GetWordInputControl().SaveValue();
//STRIP001 		OnSuggestionModified( &m_pPlayground->GetWordInputControl() );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetIgnoreHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_pPlayground->SetButtonHandler( SvxCommonLinguisticControl::eIgnore, _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetIgnoreAllHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_pPlayground->SetButtonHandler( SvxCommonLinguisticControl::eIgnoreAll, _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetChangeHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_pPlayground->SetButtonHandler( SvxCommonLinguisticControl::eChange, _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetChangeAllHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_pPlayground->SetButtonHandler( SvxCommonLinguisticControl::eChangeAll, _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetFindHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_aFind.SetClickHdl( _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetConversionFormatChangedHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_aSimpleConversion.SetClickHdl( _rHdl );
//STRIP001 		m_aHangulBracketed.SetClickHdl( _rHdl );
//STRIP001 		m_aHanjaBracketed.SetClickHdl( _rHdl );
//STRIP001 		m_pHanjaAbove->SetClickHdl( _rHdl );
//STRIP001 		m_pHanjaBelow->SetClickHdl( _rHdl );
//STRIP001 		m_pHangulAbove->SetClickHdl( _rHdl );
//STRIP001 		m_pHangulBelow->SetClickHdl( _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetClickByCharacterHdl( const Link& _rHdl )
//STRIP001 	{
//STRIP001 		m_aReplaceByChar.SetClickHdl( _rHdl );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversionDialog, OnSuggestionSelected, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		m_pPlayground->GetWordInputControl().SetText( m_aSuggestions.GetSelectEntry() );
//STRIP001 		OnSuggestionModified( NULL );
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversionDialog, OnSuggestionModified, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		m_aFind.Enable( m_pPlayground->GetWordInputControl().GetSavedValue() != m_pPlayground->GetWordInputControl().GetText() );
//STRIP001 
//STRIP001 		bool bSameLen = m_pPlayground->GetWordInputControl().GetText().Len() == m_pPlayground->GetCurrentText().Len();
//STRIP001 		m_pPlayground->EnableButton( SvxCommonLinguisticControl::eChange, m_bDocumentMode && bSameLen );
//STRIP001 		m_pPlayground->EnableButton( SvxCommonLinguisticControl::eChangeAll, m_bDocumentMode && bSameLen );
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( HangulHanjaConversionDialog, OnClose, void*, NOTINTERESTEDIN )
//STRIP001 	{
//STRIP001 		Close();
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	String HangulHanjaConversionDialog::GetCurrentString( ) const
//STRIP001 	{
//STRIP001 		return m_pPlayground->GetCurrentText( );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::FocusSuggestion( )
//STRIP001 	{
//STRIP001 		m_pPlayground->GetWordInputControl().GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	namespace
//STRIP001 	{
//STRIP001 		void lcl_modifyWindowStyle( Window* _pWin, WinBits _nSet, WinBits _nReset )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( 0 == ( _nSet & _nReset ), "lcl_modifyWindowStyle: set _and_ reset the same bit?" );
//STRIP001 			if ( _pWin )
//STRIP001 				_pWin->SetStyle( ( _pWin->GetStyle() | _nSet ) & ~_nReset );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetCurrentString( const String& _rNewString,
//STRIP001 		const Sequence< ::rtl::OUString >& _rSuggestions, bool _bOriginatesFromDocument )
//STRIP001 	{
//STRIP001 		m_pPlayground->SetCurrentText( _rNewString );
//STRIP001 
//STRIP001 		bool bOldDocumentMode = m_bDocumentMode;
//STRIP001 		m_bDocumentMode = _bOriginatesFromDocument;	// before FillSuggestions!
//STRIP001 		FillSuggestions( _rSuggestions );
//STRIP001 
//STRIP001 		m_pPlayground->EnableButton( SvxCommonLinguisticControl::eIgnoreAll, m_bDocumentMode );
//STRIP001 			// all other buttons have been implicitly enabled or disabled during filling in the suggestions
//STRIP001 
//STRIP001 		// switch the def button depending if we're working for document text
//STRIP001 		if ( bOldDocumentMode != m_bDocumentMode )
//STRIP001 		{
//STRIP001 			Window* pOldDefButton = NULL;
//STRIP001 			Window* pNewDefButton = NULL;
//STRIP001 			if ( m_bDocumentMode )
//STRIP001 			{
//STRIP001 				pOldDefButton = &m_aFind;
//STRIP001 				pNewDefButton = m_pPlayground->GetButton( SvxCommonLinguisticControl::eChange );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pOldDefButton = m_pPlayground->GetButton( SvxCommonLinguisticControl::eChange );
//STRIP001 				pNewDefButton = &m_aFind;
//STRIP001 			}
//STRIP001 
//STRIP001 			DBG_ASSERT( WB_DEFBUTTON == ( pOldDefButton->GetStyle( ) & WB_DEFBUTTON ),
//STRIP001 				"HangulHanjaConversionDialog::SetCurrentString: wrong previous default button (1)!" );
//STRIP001 			DBG_ASSERT( 0 == ( pNewDefButton->GetStyle( ) & WB_DEFBUTTON ),
//STRIP001 				"HangulHanjaConversionDialog::SetCurrentString: wrong previous default button (2)!" );
//STRIP001 
//STRIP001 			lcl_modifyWindowStyle( pOldDefButton, 0, WB_DEFBUTTON );
//STRIP001 			lcl_modifyWindowStyle( pNewDefButton, WB_DEFBUTTON, 0 );
//STRIP001 
//STRIP001 			// give the focus to the new def button temporarily - VCL is somewhat peculiar
//STRIP001 			// in recognizing a new default button
//STRIP001 			sal_uInt32 nSaveFocusId = Window::SaveFocus();
//STRIP001 			pNewDefButton->GrabFocus();
//STRIP001 			Window::EndSaveFocus( nSaveFocusId );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	String HangulHanjaConversionDialog::GetCurrentSuggestion( ) const
//STRIP001 	{
//STRIP001 		return m_pPlayground->GetWordInputControl().GetText();
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetByCharacter( sal_Bool _bByCharacter )
//STRIP001 	{
//STRIP001 		m_aReplaceByChar.Check( _bByCharacter );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	sal_Bool HangulHanjaConversionDialog::GetByCharacter( ) const
//STRIP001 	{
//STRIP001 		return m_aReplaceByChar.IsChecked();
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	void HangulHanjaConversionDialog::SetUseBothDirections( sal_Bool _bBoth ) const
//STRIP001 	{
//STRIP001 		DBG_ASSERT( m_pIgnoreNonPrimary, "HangulHanjaConversionDialog::SetUseBothDirections: where's the check box pointer?" );
//STRIP001 		m_pIgnoreNonPrimary->Check( !_bBoth );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001 	sal_Bool HangulHanjaConversionDialog::GetUseBothDirections( ) const
//STRIP001 	{
//STRIP001 		DBG_ASSERT( m_pIgnoreNonPrimary, "HangulHanjaConversionDialog::GetUseBothDirections: where's the check box pointer?" );
//STRIP001 		return m_pIgnoreNonPrimary ? !m_pIgnoreNonPrimary->IsChecked( ) : sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001     void HangulHanjaConversionDialog::SetConversionFormat( HHC::ConversionFormat _eType )
//STRIP001 	{
//STRIP001 		switch ( _eType )
//STRIP001 		{
//STRIP001             case HHC::eSimpleConversion: m_aSimpleConversion.Check(); break;
//STRIP001             case HHC::eHangulBracketed: m_aHangulBracketed.Check(); break;
//STRIP001             case HHC::eHanjaBracketed:  m_aHanjaBracketed.Check(); break;
//STRIP001             case HHC::eRubyHanjaAbove:  m_pHanjaAbove->Check(); break;
//STRIP001             case HHC::eRubyHanjaBelow:  m_pHanjaBelow->Check(); break;
//STRIP001             case HHC::eRubyHangulAbove: m_pHangulAbove->Check(); break;
//STRIP001             case HHC::eRubyHangulBelow: m_pHangulBelow->Check(); break;
//STRIP001 		default:
//STRIP001 			DBG_ERROR( "HangulHanjaConversionDialog::SetConversionFormat: unknown type!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------------------------------------------------
//STRIP001     HHC::ConversionFormat HangulHanjaConversionDialog::GetConversionFormat( ) const
//STRIP001 	{
//STRIP001 		if ( m_aSimpleConversion.IsChecked() )
//STRIP001             return HHC::eSimpleConversion;
//STRIP001 		if ( m_aHangulBracketed.IsChecked() )
//STRIP001             return HHC::eHangulBracketed;
//STRIP001 		if ( m_aHanjaBracketed.IsChecked() )
//STRIP001             return HHC::eHanjaBracketed;
//STRIP001 		if ( m_pHanjaAbove->IsChecked() )
//STRIP001             return HHC::eRubyHanjaAbove;
//STRIP001 		if ( m_pHanjaBelow->IsChecked() )
//STRIP001             return HHC::eRubyHanjaBelow;
//STRIP001 		if ( m_pHangulAbove->IsChecked() )
//STRIP001             return HHC::eRubyHangulAbove;
//STRIP001 		if ( m_pHangulBelow->IsChecked() )
//STRIP001             return HHC::eRubyHangulBelow;
//STRIP001 
//STRIP001 		DBG_ERROR( "HangulHanjaConversionDialog::GetConversionFormat: no radio checked?" )
//STRIP001         return HHC::eSimpleConversion;
//STRIP001 	}
//STRIP001 
//STRIP001 //.............................................................................
//STRIP001 }	// namespace svx
//.............................................................................
}
