/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hyphen.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:50:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _COM_SUN_STAR_LINGUISTIC2_XPOSSIBLEHYPHENS_HPP_
#include <com/sun/star/linguistic2/XPossibleHyphens.hpp>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#pragma hdrstop

#define _SVX_HYPHEN_CXX

#include "dialogs.hrc"
#include "hyphen.hrc"

#include "svxenum.hxx"
#include "hyphen.hxx"
#include "splwrap.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _USR_USTRING_HXX
namespace binfilter {
//#include <usr/ustring.hxx>
#endif

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::linguistic2;

//STRIP001 #define S2U(s) 						StringToOUString(s, CHARSET_SYSTEM)
//STRIP001 #define U2S(s)						OUStringToString(s, CHARSET_SYSTEM)

// define ----------------------------------------------------------------

//STRIP001 #define HYPHHERE			'-'
//STRIP001 #define CONTINUE_HYPH       USHRT_MAX

// Dies ist nur ein Hack, weil an dieser Stelle das extern char aus hmwrap
// nicht bekannt ist, wird demnaechst in hmwrap durch ein define ersetzt.
//STRIP001 #define SW_SOFT_HYPHEN  '='

// class SvxHyphenEdit ---------------------------------------------------

//STRIP001 SvxHyphenEdit::SvxHyphenEdit( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	Edit( pParent, rResId )
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHyphenEdit::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	sal_uInt16 nMod  = rKEvt.GetKeyCode().GetModifier();
//STRIP001 	sal_uInt16 nCode = rKEvt.GetKeyCode().GetCode();
//STRIP001 
//STRIP001 	switch ( nCode )
//STRIP001 	{
//STRIP001 		case KEY_LEFT:
//STRIP001 			( (SvxHyphenWordDialog*)GetParent() )->SelLeft();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case KEY_RIGHT:
//STRIP001 			( (SvxHyphenWordDialog*)GetParent() )->SelRight();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case KEY_TAB:
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		case KEY_RETURN:
//STRIP001 			Edit::KeyInput(rKEvt);
//STRIP001 			break;
//STRIP001 #ifdef MAC
//STRIP001 		case KEY_POINT:
//STRIP001 			// Command . abfangen
//STRIP001 			if ( nMod == KEY_MOD1 )
//STRIP001 			{
//STRIP001 				Edit::KeyInput( rKEvt );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			// kein break!
//STRIP001 #endif
//STRIP001 		default:
//STRIP001 			Control::KeyInput( rKEvt );	// An den Dialog weiterleiten
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }

// class SvxHyphenWordDialog ---------------------------------------------

//STRIP001 SvxHyphenWordDialog::SvxHyphenWordDialog( const String &rWord, LanguageType nLang,
//STRIP001 										  Window* pParent,
//STRIP001 										  Reference< XHyphenator >  &xHyphen,
//STRIP001 										  SvxSpellWrapper* pWrapper ) :
//STRIP001 	SfxModalDialog( pParent, SVX_RES( RID_SVXDLG_HYPHENATE ) ),
//STRIP001 
//STRIP001 	aWordEdit	( this, ResId( ED_WORD ) ),
//STRIP001 	aLeftBtn	( this, ResId( BTN_LEFT ) ),
//STRIP001 	aRightBtn	( this, ResId( BTN_RIGHT ) ),
//STRIP001     aWordFT     ( this, ResId( FT_WORD ) ),
//STRIP001 	aContBtn	( this, ResId( BTN_HYPH_CONTINUE ) ),
//STRIP001 	aDelBtn		( this, ResId( BTN_HYPH_DELETE ) ),
//STRIP001 	aOkBtn		( this, ResId( BTN_HYPH_CUT ) ),
//STRIP001 	aCancelBtn	( this, ResId( BTN_HYPH_CANCEL ) ),
//STRIP001 	aHelpBtn	( this, ResId( BTN_HYPH_HELP ) ),
//STRIP001 
//STRIP001 	pHyphWrapper	( pWrapper ),
//STRIP001 	xHyphenator		( xHyphen ),
//STRIP001 	aActWord		( rWord ),
//STRIP001 	nActLanguage	( nLang ),
//STRIP001 	aLabel			( GetText() ),
//STRIP001 	nHyphPos		( 0 ),
//STRIP001 	nOldPos			( 0 ),
//STRIP001 	bBusy			( sal_False )
//STRIP001 {
//STRIP001 	aContBtn.SetClickHdl(
//STRIP001 		LINK( this, SvxHyphenWordDialog, ContinueHdl_Impl ) );
//STRIP001 	aOkBtn.SetClickHdl( LINK( this, SvxHyphenWordDialog, CutHdl_Impl ) );
//STRIP001 	aDelBtn.SetClickHdl( LINK( this, SvxHyphenWordDialog, DeleteHdl_Impl ) );
//STRIP001 	aCancelBtn.SetClickHdl(
//STRIP001 		LINK( this, SvxHyphenWordDialog, CancelHdl_Impl ) );
//STRIP001 	aLeftBtn.SetClickHdl( LINK( this, SvxHyphenWordDialog, Left_Impl ) );
//STRIP001 	aRightBtn.SetClickHdl( LINK( this, SvxHyphenWordDialog, Right_Impl ) );
//STRIP001 
//STRIP001 	aWordEdit.SetGetFocusHdl(
//STRIP001 		LINK( this, SvxHyphenWordDialog, GetFocusHdl_Impl ) );
//STRIP001 
//STRIP001 	Reference< XHyphenatedWord >  xHyphWord( pWrapper ?
//STRIP001 			pWrapper->GetLast() : Reference< XInterface > () , UNO_QUERY );
//STRIP001 	DBG_ASSERT(xHyphWord.is(), "missing hyphenated word");
//STRIP001 	nMaxHyphenationPos = xHyphWord.is() ? xHyphWord->getHyphenationPos() : 0;
//STRIP001 	SetLabel_Impl( nLang );
//STRIP001 
//STRIP001 	InitControls_Impl();
//STRIP001 	aWordEdit.GrabFocus();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// disable controls if service is not available
//STRIP001 	if (!xHyphenator.is())
//STRIP001 		Enable( sal_False );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHyphenWordDialog::SelLeft()
//STRIP001 {
//STRIP001 	String aTxt( aWordEdit.GetText() );
//STRIP001 
//STRIP001 	for ( xub_StrLen i = nOldPos + 1;  i-- > 0 ; )
//STRIP001 	{
//STRIP001 		DBG_ASSERT(0 <= i && i <= aTxt.Len(), "index out of range");
//STRIP001 		if( aTxt.GetChar( i ) == sal_Unicode( SW_SOFT_HYPHEN ) )
//STRIP001 		{
//STRIP001 			aTxt.SetChar( i, sal_Unicode( HYPHHERE ) );
//STRIP001 
//STRIP001 			if ( nOldPos != 0 && nOldPos != aTxt.Len() )
//STRIP001 				aTxt.SetChar( nOldPos, sal_Unicode( SW_SOFT_HYPHEN ) );
//STRIP001 			nOldPos = i;
//STRIP001 			aWordEdit.SetText( aTxt );
//STRIP001 			aWordEdit.GrabFocus();
//STRIP001 			aWordEdit.SetSelection( Selection( i, i + 1 ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nHyphPos = GetHyphIndex_Impl();
//STRIP001 	EnableLRBtn_Impl();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHyphenWordDialog::SelRight()
//STRIP001 {
//STRIP001 	String aTxt( aWordEdit.GetText() );
//STRIP001 
//STRIP001 	for ( xub_StrLen i = nOldPos + 1;  i < aTxt.Len();  ++i )
//STRIP001 	{
//STRIP001 		if( aTxt.GetChar( i ) == sal_Unicode( SW_SOFT_HYPHEN ) )
//STRIP001 		{
//STRIP001 			aTxt.SetChar( i, sal_Unicode( HYPHHERE ) );
//STRIP001 
//STRIP001 			if ( nOldPos != 0 && nOldPos != aTxt.Len() )
//STRIP001 				aTxt.SetChar( nOldPos, sal_Unicode( SW_SOFT_HYPHEN ) );
//STRIP001 			nOldPos = i;
//STRIP001 			aWordEdit.SetText( aTxt );
//STRIP001 			aWordEdit.GrabFocus();
//STRIP001 			aWordEdit.SetSelection( Selection( i, i + 1 ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nHyphPos = GetHyphIndex_Impl();
//STRIP001 	EnableLRBtn_Impl();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHyphenWordDialog::EnableLRBtn_Impl()
//STRIP001 {
//STRIP001 	String	aTxt( aWordEdit.GetText() );
//STRIP001 	xub_StrLen nLen = aTxt.Len();
//STRIP001 	xub_StrLen i;
//STRIP001 
//STRIP001 	aRightBtn.Disable();
//STRIP001 	for ( i = nOldPos + 2; i < nLen; ++i )
//STRIP001 	{
//STRIP001 		if ( aTxt.GetChar( i ) == sal_Unicode( SW_SOFT_HYPHEN ) )
//STRIP001 		{
//STRIP001 			aRightBtn.Enable();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERT(nOldPos < aTxt.Len(), "nOldPos out of range");
//STRIP001 	if (nOldPos >= aTxt.Len())
//STRIP001 		nOldPos = aTxt.Len() - 1;
//STRIP001 	aLeftBtn.Disable();
//STRIP001 	for ( i = nOldPos;  i-- > 0; )
//STRIP001 	{
//STRIP001 		if ( aTxt.GetChar( i ) == sal_Unicode( SW_SOFT_HYPHEN ) )
//STRIP001 		{
//STRIP001 			aLeftBtn.Enable();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 void SvxHyphenWordDialog::SetLabel_Impl( LanguageType nLang )
//STRIP001 {
//STRIP001 	String aLangStr( ::GetLanguageString( nLang ) );
//STRIP001 	String aTmp( aLabel );
//STRIP001 	aTmp.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) );
//STRIP001 	aTmp.Append( aLangStr );
//STRIP001 	aTmp.Append( sal_Unicode( ')' ) );
//STRIP001 	SetText( aTmp );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 String SvxHyphenWordDialog::EraseUnusableHyphens_Impl(
//STRIP001 		Reference< XPossibleHyphens >  &rxPossHyph,
//STRIP001 		sal_uInt16 nMaxHyphenationPos )
//STRIP001 {
//STRIP001 	// returns a String showing only those hyphen positions which will result
//STRIP001 	// in a line break if hyphenation is done there
//STRIP001 
//STRIP001 	String aTxt;
//STRIP001 	DBG_ASSERT(rxPossHyph.is(), "missing possible hyphens");
//STRIP001 	if (rxPossHyph.is())
//STRIP001 	{
//STRIP001 		aTxt = String( rxPossHyph->getPossibleHyphens() );
//STRIP001 
//STRIP001 		Sequence< sal_Int16 > aHyphenationPositions(
//STRIP001 				rxPossHyph->getHyphenationPositions() );
//STRIP001 		sal_Int32 nLen = aHyphenationPositions.getLength();
//STRIP001 		const sal_Int16 *pHyphenationPos = aHyphenationPositions.getConstArray();
//STRIP001 
//STRIP001 		// find position nIdx after which all hyphen positions are unusable
//STRIP001 		sal_Int32 nIdx = -1,
//STRIP001 			  nPos;
//STRIP001 		if (nLen)
//STRIP001 		{
//STRIP001 			sal_Int32 nStart = 0;
//STRIP001 			for (sal_Int32 i = 0;  i < nLen;  ++i)
//STRIP001 			{
//STRIP001 				if (pHyphenationPos[i] > nMaxHyphenationPos)
//STRIP001 					break;
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// find corresponding hyphen pos in string
//STRIP001 					nPos = aTxt.Search( sal_Unicode( SW_SOFT_HYPHEN ), nStart );
//STRIP001 
//STRIP001 					if (nStart == STRING_NOTFOUND)
//STRIP001 						break;
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nIdx = nPos;
//STRIP001 						nStart = nPos + 1;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		DBG_ASSERT(nIdx != -1, "no usable hyphenation position")
//STRIP001 
//STRIP001 		// remove not usable hyphens from string
//STRIP001 		nPos = nIdx == -1 ? 0 : nIdx + 1;
//STRIP001 		String aTmp( sal_Unicode( SW_SOFT_HYPHEN ) ),
//STRIP001 			   aEmpty;
//STRIP001 		while (nPos != STRING_NOTFOUND)
//STRIP001 			nPos = aTxt.SearchAndReplace( aTmp, aEmpty, nPos + 1 );
//STRIP001 	}
//STRIP001 	return aTxt;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHyphenWordDialog::InitControls_Impl()
//STRIP001 {
//STRIP001 	String aTxt;
//STRIP001 	xPossHyph = NULL;
//STRIP001 	if (xHyphenator.is())
//STRIP001 	{
//STRIP001 		lang::Locale aLocale( SvxCreateLocale(nActLanguage) );
//STRIP001 		xPossHyph = xHyphenator->createPossibleHyphens( aActWord, aLocale,
//STRIP001 														Sequence< PropertyValue >() );
//STRIP001 		if (xPossHyph.is())
//STRIP001 		{
//STRIP001 			aTxt = EraseUnusableHyphens_Impl( xPossHyph, nMaxHyphenationPos );
//STRIP001 		}
//STRIP001 		SetLabel_Impl( nActLanguage );
//STRIP001 	}
//STRIP001 	aWordEdit.SetText( aTxt );
//STRIP001 
//STRIP001 	nOldPos = aTxt.Len();
//STRIP001 	SelLeft();
//STRIP001 	EnableLRBtn_Impl();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxHyphenWordDialog::ContinueHyph_Impl( sal_uInt16 nInsPos )
//STRIP001 {
//STRIP001 	if ( nInsPos != CONTINUE_HYPH  &&  xPossHyph.is())
//STRIP001 	{
//STRIP001 		if (nInsPos)
//STRIP001 		{
//STRIP001 			//String aTmp( U2S( xPossHyph->getPossibleHyphens() ) );
//STRIP001 			String aTmp( aWordEdit.GetText() );
//STRIP001 			DBG_ASSERT(nInsPos <= aTmp.Len() - 2, "wrong hyphen position");
//STRIP001 
//STRIP001 			sal_uInt16 nIdxPos = 0;
//STRIP001 			sal_uInt16 i = 0;
//STRIP001 			sal_Unicode  c;
//STRIP001 			while (i < aTmp.Len()  &&  HYPHHERE != (c = aTmp.GetChar(i++)) )
//STRIP001 			{
//STRIP001 				if (SW_SOFT_HYPHEN == c)
//STRIP001 					nIdxPos++;
//STRIP001 			}
//STRIP001 
//STRIP001 			Sequence< sal_Int16 > aSeq = xPossHyph->getHyphenationPositions();
//STRIP001 			sal_Int32 nLen = aSeq.getLength();
//STRIP001 			DBG_ASSERT(nLen, "empty sequence");
//STRIP001 			DBG_ASSERT(nIdxPos < nLen, "index out of range");
//STRIP001 			if (nLen && nIdxPos < nLen)
//STRIP001 			{
//STRIP001 				nInsPos = aSeq.getConstArray()[ nIdxPos ];
//STRIP001 				pHyphWrapper->InsertHyphen( nInsPos );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//! calling with 0 as argument will remove hyphens!
//STRIP001 			pHyphWrapper->InsertHyphen( nInsPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pHyphWrapper->FindSpellError() )
//STRIP001 	{
//STRIP001 		Reference< XHyphenatedWord >  xHyphWord( pHyphWrapper->GetLast(), UNO_QUERY );
//STRIP001 
//STRIP001 		// adapt actual word and language to new found hyphenation result
//STRIP001 		if(xHyphWord.is())
//STRIP001 		{
//STRIP001 			aActWord	 = String( xHyphWord->getWord() );
//STRIP001 			nActLanguage = SvxLocaleToLanguage( xHyphWord->getLocale() );
//STRIP001 			nMaxHyphenationPos = xHyphWord->getHyphenationPos();
//STRIP001 			InitControls_Impl();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndDialog( RET_OK );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_uInt16 SvxHyphenWordDialog::GetHyphIndex_Impl()
//STRIP001 {
//STRIP001 	sal_uInt16 nPos = 0;
//STRIP001 	String aTxt(aWordEdit.GetText());
//STRIP001 
//STRIP001 	for ( sal_uInt16 i=0 ; i < aTxt.Len(); ++i )
//STRIP001 	{
//STRIP001 		sal_Unicode nChar = aTxt.GetChar( i );
//STRIP001 
//STRIP001 		if ( nChar == HYPHHERE )
//STRIP001 			break;
//STRIP001 
//STRIP001 		if ( nChar != SW_SOFT_HYPHEN )
//STRIP001 			nPos++;
//STRIP001 	}
//STRIP001 	return nPos;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, CutHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( !bBusy )
//STRIP001 	{
//STRIP001 		bBusy = sal_True;
//STRIP001 		ContinueHyph_Impl( nHyphPos );
//STRIP001 		bBusy = sal_False;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, CutHdl_Impl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, DeleteHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( !bBusy )
//STRIP001 	{
//STRIP001 		bBusy = sal_True;
//STRIP001 		ContinueHyph_Impl();
//STRIP001 		bBusy = sal_False;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, DeleteHdl_Impl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, ContinueHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( !bBusy )
//STRIP001 	{
//STRIP001 		bBusy = sal_True;
//STRIP001 		ContinueHyph_Impl( CONTINUE_HYPH );
//STRIP001 		bBusy = sal_False;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, ContinueHdl_Impl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, CancelHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( !bBusy )
//STRIP001 	{
//STRIP001 		bBusy = sal_True;
//STRIP001 		pHyphWrapper->SpellEnd();
//STRIP001 		EndDialog( RET_CANCEL );
//STRIP001 		bBusy = sal_False;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, CancelHdl_Impl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, Left_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( !bBusy )
//STRIP001 	{
//STRIP001 		bBusy = sal_True;
//STRIP001 		SelLeft();
//STRIP001 		bBusy = sal_False;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, Left_Impl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, Right_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( !bBusy )
//STRIP001 	{
//STRIP001 		bBusy = sal_True;
//STRIP001 		SelRight();
//STRIP001 		bBusy = sal_False;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, Right_Impl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxHyphenWordDialog, GetFocusHdl_Impl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	aWordEdit.SetSelection( Selection( nOldPos, nOldPos + 1 ) );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHyphenWordDialog, GetFocusHdl_Impl, Edit *, EMPTYARG )

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxHyphenWordDialog, LangError_Impl, void *, nLang )
//STRIP001 {
//STRIP001 	// Status anzeigen
//STRIP001 	String aErr( ::GetLanguageString( (LanguageType)(sal_uInt32)nLang ) );
//STRIP001 	aErr += SVX_RESSTR( RID_SVXSTR_HMERR_CHECKINSTALL );
//STRIP001 	InfoBox( this, aErr ).Execute();
//STRIP001 	return 0;
//STRIP001 }


}
