/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_eehtml.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:24:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <eeng_pch.hxx>

#pragma hdrstop

#include <eehtml.hxx>

#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif

#ifndef _VCL_POINTR_HXX
#include <vcl/pointr.hxx>
#endif

#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif

#include <impedit.hxx>
#include <eeitemid.hxx>
#include <adjitem.hxx>

#ifndef _PSTM_HXX //autogen
#include <tools/pstm.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include "itemdata.hxx"
#endif

#ifndef _DATE_HXX //autogen
#include <tools/date.hxx>
#endif

#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif

#include <flditem.hxx>
#include <tools/urlobj.hxx>
#include "fhgtitem.hxx"
#include "fontitem.hxx"
#include "ulspitem.hxx"
#include "wghtitem.hxx"
#include <svtools/htmltokn.h>
#include <svtools/htmlkywd.hxx>

//#include <vcl/system.hxx>
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//STRIP001 #define ACTION_INSERTTEXT		  1
//STRIP001 #define ACTION_INSERTPARABRK	  2

//STRIP001 #define STYLE_PRE		  		101

//STRIP001 EditHTMLParser::EditHTMLParser( SvStream& rIn, SvKeyValueIterator* pHTTPHeaderAttrs, int bReadNewDoc )
//STRIP001 	: SfxHTMLParser( rIn, bReadNewDoc )
//STRIP001 {
//STRIP001 	pImpEditEngine = 0;
//STRIP001 	pCurAnchor = 0;
//STRIP001 	bInPara = FALSE;
//STRIP001 	bWasInPara = FALSE;
//STRIP001 	nInTable = 0;
//STRIP001 	nInCell = 0;
//STRIP001 	nDefListLevel = 0;
//STRIP001 	nBulletLevel = 0;
//STRIP001 	nNumberingLevel = 0;
//STRIP001 	bFieldsInserted = FALSE;
//STRIP001 
//STRIP001     if ( pHTTPHeaderAttrs )
//STRIP001 		SetEncodingByHTTPHeader( pHTTPHeaderAttrs );
//STRIP001 }

//STRIP001 EditHTMLParser::~EditHTMLParser()
//STRIP001 {
//STRIP001 	delete pCurAnchor;
//STRIP001 }

//STRIP001 SvParserState EditHTMLParser::CallParser( ImpEditEngine* pImpEE, const EditPaM& rPaM )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpEE, "CallParser: ImpEditEngine ?!" );
//STRIP001 	pImpEditEngine = pImpEE;
//STRIP001 	SvParserState eState = SVPAR_NOTSTARTED;
//STRIP001 	if ( pImpEditEngine )
//STRIP001 	{
//STRIP001 		// Umbrechmimik vom RTF-Import einbauen?
//STRIP001 		aCurSel = EditSelection( rPaM, rPaM );
//STRIP001 
//STRIP001 		if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 		{
//STRIP001 			ImportInfo aImportInfo( HTMLIMP_START, this, pImpEditEngine->CreateESel( aCurSel ) );
//STRIP001 			pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 		}
//STRIP001 
//STRIP001 		ImpSetStyleSheet( 0 );
//STRIP001 		eState = HTMLParser::CallParser();
//STRIP001 
//STRIP001 		if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 		{
//STRIP001 			ImportInfo aImportInfo( HTMLIMP_END, this, pImpEditEngine->CreateESel( aCurSel ) );
//STRIP001 			pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bFieldsInserted )
//STRIP001 			pImpEditEngine->UpdateFields();
//STRIP001 	}
//STRIP001 	return eState;
//STRIP001 }

//STRIP001 void EditHTMLParser::NextToken( int nToken )
//STRIP001 {
//STRIP001 	#ifdef DBG_UTIL
//STRIP001 		HTML_TOKEN_IDS xID = (HTML_TOKEN_IDS)nToken;
//STRIP001 	#endif
//STRIP001 
//STRIP001 	switch( nToken )
//STRIP001 	{
//STRIP001     case HTML_META:
//STRIP001     {
//STRIP001 		const HTMLOptions *pOptions = GetOptions();
//STRIP001 		USHORT nArrLen = pOptions->Count();
//STRIP001         BOOL bEquiv = FALSE;
//STRIP001 		for ( USHORT i = 0; i < nArrLen; i++ )
//STRIP001 		{
//STRIP001 			const HTMLOption *pOption = (*pOptions)[i];
//STRIP001 			switch( pOption->GetToken() )
//STRIP001 			{
//STRIP001 				case HTML_O_HTTPEQUIV:
//STRIP001 				{
//STRIP001                     bEquiv = TRUE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case HTML_O_CONTENT:
//STRIP001 				{
//STRIP001                     if ( bEquiv )
//STRIP001                     {
//STRIP001                         rtl_TextEncoding eEnc = GetEncodingByMIME( pOption->GetString() );
//STRIP001                         if ( eEnc != RTL_TEXTENCODING_DONTKNOW )
//STRIP001                             SetSrcEncoding( eEnc );
//STRIP001                     }
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001     }
//STRIP001     break;
//STRIP001 	case HTML_PLAINTEXT_ON:
//STRIP001 	case HTML_PLAINTEXT2_ON:
//STRIP001 		bInPara = TRUE;
//STRIP001 	break;
//STRIP001 	case HTML_PLAINTEXT_OFF:
//STRIP001 	case HTML_PLAINTEXT2_OFF:
//STRIP001 		bInPara = FALSE;
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_LINEBREAK:
//STRIP001 	case HTML_NEWPARA:
//STRIP001 	{
//STRIP001 		if ( ( bInPara || nInTable ) &&
//STRIP001 			( ( nToken == HTML_LINEBREAK ) || HasTextInCurrentPara() ) )
//STRIP001 		{
//STRIP001 			ImpInsertParaBreak();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001 	case HTML_HORZRULE:
//STRIP001 	{
//STRIP001 		if ( HasTextInCurrentPara() )
//STRIP001 			ImpInsertParaBreak();
//STRIP001 		ImpInsertParaBreak();
//STRIP001 	}
//STRIP001 	case HTML_NONBREAKSPACE:
//STRIP001 	{
//STRIP001 		if ( bInPara )
//STRIP001 		{
//STRIP001 			ImpInsertText( String( RTL_CONSTASCII_USTRINGPARAM( " " ) ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001 	case HTML_TEXTTOKEN:
//STRIP001 	{
//STRIP001         if ( !bInPara )
//STRIP001             StartPara( FALSE );
//STRIP001 
//STRIP001 //        if ( bInPara || pCurAnchor )
//STRIP001 		{
//STRIP001 			String aText = aToken;
//STRIP001 			if ( aText.Len() && ( aText.GetChar( 0 ) == ' ' )
//STRIP001 					&& ThrowAwayBlank() && !IsReadPRE() )
//STRIP001 				aText.Erase( 0, 1 );
//STRIP001 
//STRIP001 			if ( pCurAnchor )
//STRIP001 			{
//STRIP001 				pCurAnchor->aText += aText;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Nur bis HTML mit 319 geschrieben ?!
//STRIP001 				if ( IsReadPRE() )
//STRIP001 				{
//STRIP001 					USHORT nTabPos = aText.Search( '\t', 0 );
//STRIP001 					while ( nTabPos != STRING_NOTFOUND )
//STRIP001 					{
//STRIP001 						aText.Erase( nTabPos, 1 );
//STRIP001 						aText.Insert( String( RTL_CONSTASCII_USTRINGPARAM( "        " ) ), nTabPos );
//STRIP001 						nTabPos = aText.Search( '\t', nTabPos+8 );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				ImpInsertText( aText );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_CENTER_ON:
//STRIP001 	case HTML_CENTER_OFF:	// if ( bInPara )
//STRIP001 							{
//STRIP001 								USHORT nNode = pImpEditEngine->GetEditDoc().GetPos( aCurSel.Max().GetNode() );
//STRIP001 								SfxItemSet aItems( aCurSel.Max().GetNode()->GetContentAttribs().GetItems() );
//STRIP001 								aItems.ClearItem( EE_PARA_JUST );
//STRIP001 								if ( nToken == HTML_CENTER_ON )
//STRIP001 									aItems.Put( SvxAdjustItem( SVX_ADJUST_CENTER, EE_PARA_JUST ) );
//STRIP001 								pImpEditEngine->SetParaAttribs( nNode, aItems );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 	case HTML_ANCHOR_ON:	AnchorStart();
//STRIP001 							break;
//STRIP001 	case HTML_ANCHOR_OFF:	AnchorEnd();
//STRIP001 							break;
//STRIP001 
//STRIP001 	case HTML_PARABREAK_ON:
//STRIP001 		if( bInPara && HasTextInCurrentPara() )
//STRIP001 			EndPara( TRUE );
//STRIP001 		StartPara( TRUE );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case HTML_PARABREAK_OFF:
//STRIP001 		if( bInPara )
//STRIP001 			EndPara( TRUE );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case HTML_HEAD1_ON:
//STRIP001 	case HTML_HEAD2_ON:
//STRIP001 	case HTML_HEAD3_ON:
//STRIP001 	case HTML_HEAD4_ON:
//STRIP001 	case HTML_HEAD5_ON:
//STRIP001 	case HTML_HEAD6_ON:
//STRIP001 	{
//STRIP001 		HeadingStart( nToken );
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_HEAD1_OFF:
//STRIP001 	case HTML_HEAD2_OFF:
//STRIP001 	case HTML_HEAD3_OFF:
//STRIP001 	case HTML_HEAD4_OFF:
//STRIP001 	case HTML_HEAD5_OFF:
//STRIP001 	case HTML_HEAD6_OFF:
//STRIP001 	{
//STRIP001 		HeadingEnd( nToken );
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_PREFORMTXT_ON:
//STRIP001 	case HTML_XMP_ON:
//STRIP001 	case HTML_LISTING_ON:
//STRIP001 	{
//STRIP001 		StartPara( TRUE );
//STRIP001 		ImpSetStyleSheet( STYLE_PRE );
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_DEFLIST_ON:
//STRIP001 	{
//STRIP001 		nDefListLevel++;
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_DEFLIST_OFF:
//STRIP001 	{
//STRIP001 		if( nDefListLevel )
//STRIP001 			nDefListLevel--;
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_TABLE_ON:		nInTable++;
//STRIP001 							break;
//STRIP001 	case HTML_TABLE_OFF:	DBG_ASSERT( nInTable, "Nicht in Table, aber TABLE_OFF?" );
//STRIP001 							nInTable--;
//STRIP001 							break;
//STRIP001 
//STRIP001 	case HTML_TABLEHEADER_ON:
//STRIP001 	case HTML_TABLEDATA_ON:
//STRIP001 		nInCell++;
//STRIP001 	// fallthru
//STRIP001 	case HTML_BLOCKQUOTE_ON:
//STRIP001 	case HTML_BLOCKQUOTE_OFF:
//STRIP001 	case HTML_BLOCKQUOTE30_ON:
//STRIP001 	case HTML_BLOCKQUOTE30_OFF:
//STRIP001 	case HTML_LISTHEADER_ON:
//STRIP001 	case HTML_LI_ON:
//STRIP001 	case HTML_DD_ON:
//STRIP001 	case HTML_DT_ON:
//STRIP001 	case HTML_ORDERLIST_ON:
//STRIP001 	case HTML_UNORDERLIST_ON:
//STRIP001 	{
//STRIP001 		BOOL bHasText = HasTextInCurrentPara();
//STRIP001 		if ( bHasText )
//STRIP001 			ImpInsertParaBreak();
//STRIP001 		StartPara( FALSE );
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	case HTML_TABLEHEADER_OFF:
//STRIP001 	case HTML_TABLEDATA_OFF:
//STRIP001 	{
//STRIP001 		if ( nInCell )
//STRIP001 			nInCell--;
//STRIP001 	}
//STRIP001 	// fallthru
//STRIP001 	case HTML_LISTHEADER_OFF:
//STRIP001 	case HTML_LI_OFF:
//STRIP001 	case HTML_DD_OFF:
//STRIP001 	case HTML_DT_OFF:
//STRIP001 	case HTML_ORDERLIST_OFF:
//STRIP001 	case HTML_UNORDERLIST_OFF:	EndPara( FALSE );
//STRIP001 								break;
//STRIP001 
//STRIP001 	case HTML_TABLEROW_ON:
//STRIP001 	case HTML_TABLEROW_OFF:	// Nur nach einem CELL ein RETURN, fuer Calc
//STRIP001 
//STRIP001 	case HTML_COL_ON:
//STRIP001 	case HTML_COLGROUP_ON:
//STRIP001 	case HTML_COLGROUP_OFF: break;
//STRIP001 
//STRIP001 	case HTML_FONT_ON:		// ...
//STRIP001 							break;
//STRIP001 	case HTML_FONT_OFF:		// ...
//STRIP001 							break;
//STRIP001 
//STRIP001 
//STRIP001 	// #58335# kein SkipGroup on/off auf inline markup etc.
//STRIP001 
//STRIP001 	// globals
//STRIP001 	case HTML_HTML_ON:
//STRIP001 	case HTML_HTML_OFF:
//STRIP001 	case HTML_BODY_ON:
//STRIP001 	case HTML_BODY_OFF:
//STRIP001 	case HTML_HEAD_ON:
//STRIP001 	case HTML_HEAD_OFF:
//STRIP001 	case HTML_TITLE_ON:
//STRIP001 	case HTML_TITLE_OFF:
//STRIP001 	case HTML_THEAD_ON:
//STRIP001 	case HTML_THEAD_OFF:
//STRIP001 	case HTML_TBODY_ON:
//STRIP001 	case HTML_TBODY_OFF:
//STRIP001 	// inline elements, structural markup
//STRIP001 	// HTML 3.0
//STRIP001 	case HTML_BANNER_ON:
//STRIP001 	case HTML_BANNER_OFF:
//STRIP001 	case HTML_DIVISION_ON:
//STRIP001 	case HTML_DIVISION_OFF:
//STRIP001 //	case HTML_LISTHEADER_ON:		//! special handling
//STRIP001 //	case HTML_LISTHEADER_OFF:
//STRIP001 	case HTML_NOTE_ON:
//STRIP001 	case HTML_NOTE_OFF:
//STRIP001 	// inline elements, logical markup
//STRIP001 	// HTML 2.0
//STRIP001 	case HTML_ADDRESS_ON:
//STRIP001 	case HTML_ADDRESS_OFF:
//STRIP001 //	case HTML_BLOCKQUOTE_ON:		//! extra Behandlung
//STRIP001 //	case HTML_BLOCKQUOTE_OFF:
//STRIP001 	case HTML_CITIATION_ON:
//STRIP001 	case HTML_CITIATION_OFF:
//STRIP001 	case HTML_CODE_ON:
//STRIP001 	case HTML_CODE_OFF:
//STRIP001 	case HTML_DEFINSTANCE_ON:
//STRIP001 	case HTML_DEFINSTANCE_OFF:
//STRIP001 	case HTML_EMPHASIS_ON:
//STRIP001 	case HTML_EMPHASIS_OFF:
//STRIP001 	case HTML_KEYBOARD_ON:
//STRIP001 	case HTML_KEYBOARD_OFF:
//STRIP001 	case HTML_SAMPLE_ON:
//STRIP001 	case HTML_SAMPLE_OFF:
//STRIP001 	case HTML_STRIKE_ON:
//STRIP001 	case HTML_STRIKE_OFF:
//STRIP001 	case HTML_STRONG_ON:
//STRIP001 	case HTML_STRONG_OFF:
//STRIP001 	case HTML_VARIABLE_ON:
//STRIP001 	case HTML_VARIABLE_OFF:
//STRIP001 	// HTML 3.0
//STRIP001 	case HTML_ABBREVIATION_ON:
//STRIP001 	case HTML_ABBREVIATION_OFF:
//STRIP001 	case HTML_ACRONYM_ON:
//STRIP001 	case HTML_ACRONYM_OFF:
//STRIP001 	case HTML_AUTHOR_ON:
//STRIP001 	case HTML_AUTHOR_OFF:
//STRIP001 //	case HTML_BLOCKQUOTE30_ON:		//! extra Behandlung
//STRIP001 //	case HTML_BLOCKQUOTE30_OFF:
//STRIP001 	case HTML_DELETEDTEXT_ON:
//STRIP001 	case HTML_DELETEDTEXT_OFF:
//STRIP001 	case HTML_INSERTEDTEXT_ON:
//STRIP001 	case HTML_INSERTEDTEXT_OFF:
//STRIP001 	case HTML_LANGUAGE_ON:
//STRIP001 	case HTML_LANGUAGE_OFF:
//STRIP001 	case HTML_PERSON_ON:
//STRIP001 	case HTML_PERSON_OFF:
//STRIP001 	case HTML_SHORTQUOTE_ON:
//STRIP001 	case HTML_SHORTQUOTE_OFF:
//STRIP001 	case HTML_SUBSCRIPT_ON:
//STRIP001 	case HTML_SUBSCRIPT_OFF:
//STRIP001 	case HTML_SUPERSCRIPT_ON:
//STRIP001 	case HTML_SUPERSCRIPT_OFF:
//STRIP001 	// inline elements, visual markup
//STRIP001 	// HTML 2.0
//STRIP001 	case HTML_BOLD_ON:
//STRIP001 	case HTML_BOLD_OFF:
//STRIP001 	case HTML_ITALIC_ON:
//STRIP001 	case HTML_ITALIC_OFF:
//STRIP001 	case HTML_TELETYPE_ON:
//STRIP001 	case HTML_TELETYPE_OFF:
//STRIP001 	case HTML_UNDERLINE_ON:
//STRIP001 	case HTML_UNDERLINE_OFF:
//STRIP001 	// HTML 3.0
//STRIP001 	case HTML_BIGPRINT_ON:
//STRIP001 	case HTML_BIGPRINT_OFF:
//STRIP001 	case HTML_STRIKETHROUGH_ON:
//STRIP001 	case HTML_STRIKETHROUGH_OFF:
//STRIP001 	case HTML_SMALLPRINT_ON:
//STRIP001 	case HTML_SMALLPRINT_OFF:
//STRIP001 	// figures
//STRIP001 	case HTML_FIGURE_ON:
//STRIP001 	case HTML_FIGURE_OFF:
//STRIP001 	case HTML_CAPTION_ON:
//STRIP001 	case HTML_CAPTION_OFF:
//STRIP001 	case HTML_CREDIT_ON:
//STRIP001 	case HTML_CREDIT_OFF:
//STRIP001 	// misc
//STRIP001 	case HTML_DIRLIST_ON:
//STRIP001 	case HTML_DIRLIST_OFF:
//STRIP001 	case HTML_FOOTNOTE_ON:			//! landen so im Text
//STRIP001 	case HTML_FOOTNOTE_OFF:
//STRIP001 	case HTML_MENULIST_ON:
//STRIP001 	case HTML_MENULIST_OFF:
//STRIP001 //	case HTML_PLAINTEXT_ON:			//! extra Behandlung
//STRIP001 //	case HTML_PLAINTEXT_OFF:
//STRIP001 //	case HTML_PREFORMTXT_ON:		//! extra Behandlung
//STRIP001 //	case HTML_PREFORMTXT_OFF:
//STRIP001 	case HTML_SPAN_ON:
//STRIP001 	case HTML_SPAN_OFF:
//STRIP001 	// obsolete
//STRIP001 //	case HTML_XMP_ON:				//! extra Behandlung
//STRIP001 //	case HTML_XMP_OFF:
//STRIP001 //	case HTML_LISTING_ON:			//! extra Behandlung
//STRIP001 //	case HTML_LISTING_OFF:
//STRIP001 	// Netscape
//STRIP001 	case HTML_BLINK_ON:
//STRIP001 	case HTML_BLINK_OFF:
//STRIP001 	case HTML_NOBR_ON:
//STRIP001 	case HTML_NOBR_OFF:
//STRIP001 	case HTML_NOEMBED_ON:
//STRIP001 	case HTML_NOEMBED_OFF:
//STRIP001 	case HTML_NOFRAMES_ON:
//STRIP001 	case HTML_NOFRAMES_OFF:
//STRIP001 	// Internet Explorer
//STRIP001 	case HTML_MARQUEE_ON:
//STRIP001 	case HTML_MARQUEE_OFF:
//STRIP001 //	case HTML_PLAINTEXT2_ON:		//! extra Behandlung
//STRIP001 //	case HTML_PLAINTEXT2_OFF:
//STRIP001 	break;
//STRIP001 
//STRIP001 	default:
//STRIP001 	{
//STRIP001 		if ( nToken & HTML_TOKEN_ONOFF )
//STRIP001 		{
//STRIP001 			if ( ( nToken == HTML_UNKNOWNCONTROL_ON ) || ( nToken == HTML_UNKNOWNCONTROL_OFF ) )
//STRIP001 			{
//STRIP001 				;
//STRIP001 			}
//STRIP001 			else if ( !(nToken & 1) )
//STRIP001 			{
//STRIP001 				DBG_ASSERT( !( nToken & 1 ), "Kein Start-Token ?!" );
//STRIP001 				SkipGroup( nToken + 1 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	}	// SWITCH
//STRIP001 
//STRIP001 	if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 	{
//STRIP001 		ImportInfo aImportInfo( HTMLIMP_NEXTTOKEN, this, pImpEditEngine->CreateESel( aCurSel ) );
//STRIP001 		aImportInfo.nToken = nToken;
//STRIP001 		aImportInfo.nTokenValue = (short)nTokenValue;
//STRIP001 		if ( nToken == HTML_TEXTTOKEN )
//STRIP001 			aImportInfo.aText = aToken;
//STRIP001 		pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 	}
//STRIP001 
//STRIP001 }

//STRIP001 void EditHTMLParser::ImpInsertParaBreak()
//STRIP001 {
//STRIP001 	if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 	{
//STRIP001 		ImportInfo aImportInfo( HTMLIMP_INSERTPARA, this, pImpEditEngine->CreateESel( aCurSel ) );
//STRIP001 		pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 	}
//STRIP001 	aCurSel = pImpEditEngine->ImpInsertParaBreak( aCurSel );
//STRIP001 	nLastAction = ACTION_INSERTPARABRK;
//STRIP001 }

//STRIP001 void EditHTMLParser::ImpSetAttribs( const SfxItemSet& rItems, EditSelection* pSel )
//STRIP001 {
//STRIP001 	// pSel, wenn Zeichenattribute, sonst Absatzattribute fuer den
//STRIP001 	// aktuellen Absatz.
//STRIP001 	DBG_ASSERT( pSel || ( aCurSel.Min().GetNode() == aCurSel.Max().GetNode() ), "ImpInsertAttribs: Selektion?" );
//STRIP001 
//STRIP001 	EditPaM aStartPaM( pSel ? pSel->Min() : aCurSel.Min() );
//STRIP001 	EditPaM aEndPaM( pSel ? pSel->Max() : aCurSel.Max() );
//STRIP001 
//STRIP001 	if ( !pSel )
//STRIP001 	{
//STRIP001 		aStartPaM.SetIndex( 0 );
//STRIP001 		aEndPaM.SetIndex( aEndPaM.GetNode()->Len() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 	{
//STRIP001 		EditSelection aSel( aStartPaM, aEndPaM );
//STRIP001 		ImportInfo aImportInfo( HTMLIMP_SETATTR, this, pImpEditEngine->CreateESel( aSel ) );
//STRIP001 		aImportInfo.pAttrs = (void*)&rItems;
//STRIP001 		pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 	}
//STRIP001 
//STRIP001 	ContentNode* pSN = aStartPaM.GetNode();
//STRIP001 	ContentNode* pEN = aEndPaM.GetNode();
//STRIP001 	USHORT nStartNode = pImpEditEngine->GetEditDoc().GetPos( pSN );
//STRIP001 	USHORT nEndNode = pImpEditEngine->GetEditDoc().GetPos( pEN );
//STRIP001 
//STRIP001 	// Wenn ein Attribut von 0 bis aktuelle Absatzlaenge geht,
//STRIP001 	// soll es ein Absatz-Attribut sein!
//STRIP001 
//STRIP001 	// Achtung: Selektion kann ueber mehrere Absaetze gehen.
//STRIP001 	// Alle vollstaendigen Absaetze sind Absatzattribute...
//STRIP001 
//STRIP001 	// HTML eigentlich nicht:
//STRIP001 	DBG_ASSERT( nStartNode == nEndNode, "ImpSetAttribs: Mehrere Absaetze?" );
//STRIP001 /*
//STRIP001 	for ( USHORT z = nStartNode+1; z < nEndNode; z++ )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( pImpEditEngine->GetEditDoc().SaveGetObject( z ), "Node existiert noch nicht(RTF)" );
//STRIP001 		pImpEditEngine->SetParaAttribs( z, rSet.GetAttrSet() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aStartPaM.GetNode() != aEndPaM.GetNode() )
//STRIP001 	{
//STRIP001 		// Den Rest des StartNodes...
//STRIP001 		if ( aStartPaM.GetIndex() == 0 )
//STRIP001 			pImpEditEngine->SetParaAttribs( nStartNode, rSet.GetAttrSet() );
//STRIP001 		else
//STRIP001 			pImpEditEngine->SetAttribs( EditSelection( aStartPaM, EditPaM( aStartPaM.GetNode(), aStartPaM.GetNode()->Len() ) ), rSet.GetAttrSet() );
//STRIP001 
//STRIP001 		// Den Anfang des EndNodes....
//STRIP001 		if ( aEndPaM.GetIndex() == aEndPaM.GetNode()->Len() )
//STRIP001 			pImpEditEngine->SetParaAttribs( nEndNode, rSet.GetAttrSet() );
//STRIP001 		else
//STRIP001 			pImpEditEngine->SetAttribs( EditSelection( EditPaM( aEndPaM.GetNode(), 0 ), aEndPaM ), rSet.GetAttrSet() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 */
//STRIP001 	{
//STRIP001 		if ( ( aStartPaM.GetIndex() == 0 ) && ( aEndPaM.GetIndex() == aEndPaM.GetNode()->Len() ) )
//STRIP001 		{
//STRIP001 			// Muesse gemergt werden:
//STRIP001 			SfxItemSet aItems( pImpEditEngine->GetParaAttribs( nStartNode ) );
//STRIP001 			aItems.Put( rItems );
//STRIP001 			pImpEditEngine->SetParaAttribs( nStartNode, aItems );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pImpEditEngine->SetAttribs( EditSelection( aStartPaM, aEndPaM ), rItems );
//STRIP001 	}
//STRIP001 }

//STRIP001 void EditHTMLParser::ImpSetStyleSheet( USHORT nHLevel )
//STRIP001 {
//STRIP001 	/*
//STRIP001 		nHLevel:	0: 			Ausschalten
//STRIP001 					1-6: 		Heading
//STRIP001 					STYLE_PRE: 	Preformatted
//STRIP001 	*/
//STRIP001 
//STRIP001 //		if ( pImpEditEngine->GetStatus().DoImportRTFStyleSheets() )
//STRIP001 //		{
//STRIP001 //			SvxRTFStyleType* pS = GetStyleTbl().Get( rSet.StyleNo() );
//STRIP001 //			DBG_ASSERT( pS, "Vorlage in RTF nicht definiert!" );
//STRIP001 //			if ( pS )
//STRIP001 //				pImpEditEngine->SetStyleSheet( EditSelection( aStartPaM, aEndPaM ), pS->sName, SFX_STYLE_FAMILY_ALL );
//STRIP001 //		}
//STRIP001 //		else
//STRIP001 		{
//STRIP001 			// Harte Attribute erzeugen...
//STRIP001 			// Reicht fuer Calc, bei StyleSheets muesste noch geklaert werden,
//STRIP001 			// dass diese auch in der App liegen sollten, damit sie beim
//STRIP001 			// fuettern in eine andere Engine auch noch da sind...
//STRIP001 
//STRIP001 			USHORT nNode = pImpEditEngine->GetEditDoc().GetPos( aCurSel.Max().GetNode() );
//STRIP001 //			SfxItemSet aItems( pImpEditEngine->GetEmptyItemSet() );
//STRIP001 			SfxItemSet aItems( aCurSel.Max().GetNode()->GetContentAttribs().GetItems() );
//STRIP001 
//STRIP001 			aItems.ClearItem( EE_PARA_ULSPACE );
//STRIP001 			aItems.ClearItem( EE_CHAR_FONTHEIGHT );
//STRIP001 			aItems.ClearItem( EE_CHAR_FONTINFO );
//STRIP001 			aItems.ClearItem( EE_CHAR_WEIGHT );
//STRIP001 
//STRIP001 			// Fett in den ersten 3 Headings
//STRIP001 			if ( ( nHLevel >= 1 ) && ( nHLevel <= 3 ) )
//STRIP001 			{
//STRIP001 				SvxWeightItem aWeightItem( WEIGHT_BOLD, EE_CHAR_WEIGHT );
//STRIP001 				aItems.Put( aWeightItem );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Fonthoehe und Abstaende, wenn LogicToLogic moeglich:
//STRIP001 			MapUnit eUnit = pImpEditEngine->GetRefMapMode().GetMapUnit();
//STRIP001 			if ( ( eUnit != MAP_PIXEL ) && ( eUnit != MAP_SYSFONT ) &&
//STRIP001 				 ( eUnit != MAP_APPFONT ) && ( eUnit != MAP_RELATIVE ) )
//STRIP001 			{
//STRIP001 				long nPoints = 10;
//STRIP001 				if ( nHLevel == 1 )
//STRIP001 					nPoints = 22;
//STRIP001 				else if ( nHLevel == 2 )
//STRIP001 					nPoints = 16;
//STRIP001 				else if ( nHLevel == 3 )
//STRIP001 					nPoints = 12;
//STRIP001 				else if ( nHLevel == 4 )
//STRIP001 					nPoints = 11;
//STRIP001 
//STRIP001 				nPoints = OutputDevice::LogicToLogic( nPoints, MAP_POINT, eUnit );
//STRIP001 				SvxFontHeightItem aHeightItem( nPoints, 100, EE_CHAR_FONTHEIGHT );
//STRIP001 				aItems.Put( aHeightItem );
//STRIP001 
//STRIP001 				// Absatzabstaende, wenn Heading:
//STRIP001 				if ( !nHLevel || ( nHLevel >= 1 ) && ( nHLevel <= 6 ) )
//STRIP001 				{
//STRIP001 					SvxULSpaceItem aULSpaceItem( EE_PARA_ULSPACE );
//STRIP001 					aULSpaceItem.SetUpper( (USHORT)OutputDevice::LogicToLogic( 42, MAP_10TH_MM, eUnit ) );
//STRIP001 					aULSpaceItem.SetLower( (USHORT)OutputDevice::LogicToLogic( 35, MAP_10TH_MM, eUnit ) );
//STRIP001 					aItems.Put( aULSpaceItem );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// Bei Pre einen proportionalen Font waehlen
//STRIP001 			if ( nHLevel == STYLE_PRE )
//STRIP001 			{
//STRIP001 				Font aFont = OutputDevice::GetDefaultFont( DEFAULTFONT_FIXED, LANGUAGE_SYSTEM, 0 );
//STRIP001 				SvxFontItem aFontItem( aFont.GetFamily(), aFont.GetName(), XubString(), aFont.GetPitch(), aFont.GetCharSet(), EE_CHAR_FONTINFO );
//STRIP001 				aItems.Put( aFontItem );
//STRIP001 			}
//STRIP001 
//STRIP001 			pImpEditEngine->SetParaAttribs( nNode, aItems );
//STRIP001 		}
//STRIP001 }

//STRIP001 void EditHTMLParser::ImpInsertText( const String& rText )
//STRIP001 {
//STRIP001 	String aText( rText );
//STRIP001 	if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 	{
//STRIP001 		ImportInfo aImportInfo( HTMLIMP_INSERTTEXT, this, pImpEditEngine->CreateESel( aCurSel ) );
//STRIP001 		aImportInfo.aText = aText;
//STRIP001 		pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 	}
//STRIP001 
//STRIP001 	aCurSel = pImpEditEngine->ImpInsertText( aCurSel, aText );
//STRIP001 	nLastAction = ACTION_INSERTTEXT;
//STRIP001 }

//STRIP001 void EditHTMLParser::SkipGroup( int nEndToken )
//STRIP001 {
//STRIP001 	// #69109# groups in cells are closed upon leaving the cell, because those
//STRIP001 	// ******* web authors don't know their job
//STRIP001 	// for example: <td><form></td>   lacks a closing </form>
//STRIP001 	BYTE nCellLevel = nInCell;
//STRIP001 	int nToken;
//STRIP001 	while( nCellLevel <= nInCell && ( (nToken = GetNextToken() ) != nEndToken ) && nToken )
//STRIP001 	{
//STRIP001 		switch ( nToken )
//STRIP001 		{
//STRIP001 			case HTML_TABLEHEADER_ON:
//STRIP001 			case HTML_TABLEDATA_ON:
//STRIP001 				nInCell++;
//STRIP001 			break;
//STRIP001 			case HTML_TABLEHEADER_OFF:
//STRIP001 			case HTML_TABLEDATA_OFF:
//STRIP001 				if ( nInCell )
//STRIP001 					nInCell--;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void EditHTMLParser::StartPara( BOOL bReal )
//STRIP001 {
//STRIP001 	if ( bReal )
//STRIP001 	{
//STRIP001 		const HTMLOptions *pOptions = GetOptions();
//STRIP001 		USHORT nArrLen = pOptions->Count();
//STRIP001 		SvxAdjust eAdjust = SVX_ADJUST_LEFT;
//STRIP001 		for ( USHORT i = 0; i < nArrLen; i++ )
//STRIP001 		{
//STRIP001 			const HTMLOption *pOption = (*pOptions)[i];
//STRIP001 			switch( pOption->GetToken() )
//STRIP001 			{
//STRIP001 				case HTML_O_ALIGN:
//STRIP001 				{
//STRIP001 					if ( pOption->GetString().CompareIgnoreCaseToAscii( sHTML_AL_right ) == COMPARE_EQUAL )
//STRIP001 						eAdjust = SVX_ADJUST_RIGHT;
//STRIP001 					else if ( pOption->GetString().CompareIgnoreCaseToAscii( sHTML_AL_middle ) == COMPARE_EQUAL )
//STRIP001 						eAdjust = SVX_ADJUST_CENTER;
//STRIP001 					else if ( pOption->GetString().CompareIgnoreCaseToAscii( sHTML_AL_center ) == COMPARE_EQUAL )
//STRIP001 						eAdjust = SVX_ADJUST_CENTER;
//STRIP001 					else
//STRIP001 						eAdjust = SVX_ADJUST_LEFT;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		SfxItemSet aItemSet( pImpEditEngine->GetEmptyItemSet() );
//STRIP001 		aItemSet.Put( SvxAdjustItem( eAdjust, EE_PARA_JUST ) );
//STRIP001 		ImpSetAttribs( aItemSet );
//STRIP001 	}
//STRIP001 	bInPara = TRUE;
//STRIP001 }

//STRIP001 void EditHTMLParser::EndPara( BOOL bReal )
//STRIP001 {
//STRIP001 	if ( bInPara )
//STRIP001 	{
//STRIP001 		BOOL bHasText = HasTextInCurrentPara();
//STRIP001 		if ( bHasText )
//STRIP001 			ImpInsertParaBreak();
//STRIP001 		// Nur, wenn ohne Absatzabstaende gearbeitet wird...
//STRIP001 //		if ( !nInTable && bReal && (nNumberingLevel<=1) && (nBulletLevel<=1) )
//STRIP001 //			ImpInsertParaBreak();
//STRIP001 	}
//STRIP001 	bInPara = FALSE;
//STRIP001 }

//STRIP001 BOOL EditHTMLParser::ThrowAwayBlank()
//STRIP001 {
//STRIP001 	// Ein Blank muss weggeschmissen werden, wenn der neue Text mit einem
//STRIP001 	// Blank beginnt und der aktuelle Absatz leer ist oder mit einem
//STRIP001 	// Blank endet...
//STRIP001 	ContentNode* pNode = aCurSel.Max().GetNode();
//STRIP001 	if ( pNode->Len() && ( pNode->GetChar( pNode->Len()-1 ) != ' ' ) )
//STRIP001 		return FALSE;
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 BOOL EditHTMLParser::HasTextInCurrentPara()
//STRIP001 {
//STRIP001 	return aCurSel.Max().GetNode()->Len() ? TRUE : FALSE;
//STRIP001 }

//STRIP001 void EditHTMLParser::AnchorStart()
//STRIP001 {
//STRIP001 	// Anker im Anker ignoriern
//STRIP001 	if ( !pCurAnchor )
//STRIP001 	{
//STRIP001 		const HTMLOptions* pOptions = GetOptions();
//STRIP001 		USHORT nArrLen = pOptions->Count();
//STRIP001 
//STRIP001 		String aRef;
//STRIP001 
//STRIP001 		for ( USHORT i = 0; i < nArrLen; i++ )
//STRIP001 		{
//STRIP001 			const HTMLOption* pOption = (*pOptions)[i];
//STRIP001 			switch( pOption->GetToken() )
//STRIP001 			{
//STRIP001 				case HTML_O_HREF:
//STRIP001 					aRef = pOption->GetString();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aRef.Len() )
//STRIP001 		{
//STRIP001 			// BaseURL muss gesetzt sein!
//STRIP001 			String aURL = aRef;
//STRIP001 			if ( aURL.Len() && ( aURL.GetChar( 0 ) != '#' ) )
//STRIP001 			{
//STRIP001 				INetURLObject aTargetURL;
//STRIP001 				INetURLObject aRootURL( so3::StaticBaseUrl::GetBaseURL() );
//STRIP001 				aRootURL.GetNewAbsURL( aRef, &aTargetURL );
//STRIP001 				aURL = aTargetURL.GetMainURL( INetURLObject::DECODE_TO_IURI );
//STRIP001 			}
//STRIP001 			pCurAnchor = new AnchorInfo;
//STRIP001 			pCurAnchor->aHRef = aURL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void EditHTMLParser::AnchorEnd()
//STRIP001 {
//STRIP001 	if ( pCurAnchor )
//STRIP001 	{
//STRIP001 		// Als URL-Feld einfuegen...
//STRIP001 		SvxFieldItem aFld( SvxURLField( pCurAnchor->aHRef, pCurAnchor->aText, SVXURLFORMAT_REPR ), EE_FEATURE_FIELD  );
//STRIP001 		aCurSel = pImpEditEngine->InsertField( aCurSel, aFld );
//STRIP001 		bFieldsInserted = TRUE;
//STRIP001 		delete pCurAnchor;
//STRIP001 		pCurAnchor = 0;
//STRIP001 
//STRIP001 		if ( pImpEditEngine->aImportHdl.IsSet() )
//STRIP001 		{
//STRIP001 			ImportInfo aImportInfo( HTMLIMP_INSERTFIELD, this, pImpEditEngine->CreateESel( aCurSel ) );
//STRIP001 			pImpEditEngine->aImportHdl.Call( &aImportInfo );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void EditHTMLParser::HeadingStart( int nToken )
//STRIP001 {
//STRIP001 	bWasInPara = bInPara;
//STRIP001 	StartPara( FALSE );
//STRIP001 
//STRIP001 	if ( bWasInPara && HasTextInCurrentPara() )
//STRIP001 		ImpInsertParaBreak();
//STRIP001 
//STRIP001 	USHORT nId = 1 + ( ( nToken - HTML_HEAD1_ON ) / 2 );
//STRIP001 	DBG_ASSERT( (nId >= 1) && (nId <= 9), "HeadingStart: ID kann nicht stimmen!" );
//STRIP001 	ImpSetStyleSheet( nId );
//STRIP001 }

//STRIP001 void EditHTMLParser::HeadingEnd( int nToken )
//STRIP001 {
//STRIP001 	EndPara( FALSE );
//STRIP001 	ImpSetStyleSheet( 0 );
//STRIP001 
//STRIP001 	if ( bWasInPara )
//STRIP001 	{
//STRIP001 		bInPara = TRUE;
//STRIP001 		bWasInPara = FALSE;
//STRIP001 	}
//STRIP001 }
}
