/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_dataaccessdescriptor.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:40:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SVX_DATACCESSDESCRIPTOR_HXX_
// auto strip #include "dataaccessdescriptor.hxx"
// auto strip #endif
// auto strip #ifndef _COMPHELPER_STLTYPES_HXX_
// auto strip #include <comphelper/stl_types.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROPERTSETINFO_HXX_
// auto strip #include <comphelper/propertysetinfo.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_GENERICPROPERTYSET_HXX_
// auto strip #include <comphelper/genericpropertyset.hxx>
// auto strip #endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
// auto strip #include <com/sun/star/sdbc/XConnection.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
// auto strip #include <com/sun/star/beans/PropertyAttribute.hpp>
// auto strip #endif
namespace binfilter {

//........................................................................
//STRIP001 namespace svx
//STRIP001 {
//STRIP001 //........................................................................
//STRIP001 
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 	using namespace ::com::sun::star::sdbc;
//STRIP001 	using namespace ::com::sun::star::beans;
//STRIP001 	using namespace ::comphelper;
//STRIP001 
//STRIP001 	//====================================================================
//STRIP001 	//=
//STRIP001 	//====================================================================
//STRIP001 #define CONST_CHAR( propname ) propname, sizeof(propname) - 1
//STRIP001 
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 	//====================================================================
//STRIP001 	//= ODADescriptorImpl
//STRIP001 	//====================================================================
//STRIP001 	class ODADescriptorImpl
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		sal_Bool					m_bSetOutOfDate			: 1;
//STRIP001 		sal_Bool					m_bSequenceOutOfDate	: 1;
//STRIP001 
//STRIP001 	public:
//STRIP001 		DECLARE_STL_STDKEY_MAP( DataAccessDescriptorProperty, Any, DescriptorValues );
//STRIP001 		DescriptorValues			m_aValues;
//STRIP001 		Sequence< PropertyValue >	m_aAsSequence;
//STRIP001 		Reference< XPropertySet >	m_xAsSet;
//STRIP001 
//STRIP001 	public:
//STRIP001 		ODADescriptorImpl();
//STRIP001 		ODADescriptorImpl(const ODADescriptorImpl& _rSource);
//STRIP001 
//STRIP001 		void invalidateExternRepresentations();
//STRIP001 
//STRIP001 		void updateSequence();
//STRIP001 		void updateSet();
//STRIP001 
//STRIP001 		/** builds the descriptor from a property value sequence
//STRIP001 			@return <TRUE/>
//STRIP001 				if and only if the sequence contained valid properties only
//STRIP001 		*/
//STRIP001 		sal_Bool buildFrom( const Sequence< PropertyValue >& _rValues );
//STRIP001 
//STRIP001 		/** builds the descriptor from a property set
//STRIP001 			@return <TRUE/>
//STRIP001 				if and only if the set contained valid properties only
//STRIP001 		*/
//STRIP001 		sal_Bool buildFrom( const Reference< XPropertySet >& _rValues );
//STRIP001 
//STRIP001 	protected:
//STRIP001 		PropertyValue		buildPropertyValue( const ConstDescriptorValuesIterator& _rPos );
//STRIP001 		PropertyMapEntry*	getPropertyMap( ) const;
//STRIP001 		PropertyMapEntry*	getPropertyMapEntry( const ConstDescriptorValuesIterator& _rPos ) const;
//STRIP001 	};
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODADescriptorImpl::ODADescriptorImpl()
//STRIP001 		:m_bSetOutOfDate(sal_True)
//STRIP001 		,m_bSequenceOutOfDate(sal_True)
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODADescriptorImpl::ODADescriptorImpl(const ODADescriptorImpl& _rSource)
//STRIP001 		:m_aValues( _rSource.m_aValues )
//STRIP001 		,m_bSetOutOfDate( _rSource.m_bSetOutOfDate )
//STRIP001 		,m_bSequenceOutOfDate( _rSource.m_bSequenceOutOfDate )
//STRIP001 	{
//STRIP001 		if (!m_bSetOutOfDate)
//STRIP001 			m_xAsSet = _rSource.m_xAsSet;
//STRIP001 		if (!m_bSequenceOutOfDate)
//STRIP001 			m_aAsSequence = _rSource.m_aAsSequence;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	// Vergleichen von Strings
//STRIP001 	static int
//STRIP001 	#if defined( WNT )
//STRIP001 	 __cdecl
//STRIP001 	#endif
//STRIP001 	#if defined( ICC ) && defined( OS2 )
//STRIP001 	_Optlink
//STRIP001 	#endif
//STRIP001 		PropertySearch(const void* pFirst, const void* pSecond)
//STRIP001 	{
//STRIP001 		return static_cast<const PropertyValue*>(pFirst)->Name.compareToAscii(
//STRIP001 			static_cast<const PropertyMapEntry*>(pSecond)->mpName);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	sal_Bool ODADescriptorImpl::buildFrom( const Sequence< PropertyValue >& _rValues )
//STRIP001 	{
//STRIP001 		PropertyMapEntry* pPropertyMap = getPropertyMap();
//STRIP001 		// determine the size of the map
//STRIP001 		sal_Int32 nMapSize = 0;
//STRIP001 		PropertyMapEntry* pMapLoop = pPropertyMap;
//STRIP001 		while (pMapLoop->mpName)
//STRIP001 		{
//STRIP001 			++nMapSize; ++pMapLoop;
//STRIP001 		}
//STRIP001 
//STRIP001 		sal_Bool bValidPropsOnly = sal_True;
//STRIP001 
//STRIP001 		// loop through the sequence, and fill our m_aValues
//STRIP001 		const PropertyValue* pValues = _rValues.getConstArray();
//STRIP001 		const PropertyValue* pValuesEnd = pValues + _rValues.getLength();
//STRIP001 		for (;pValues != pValuesEnd; ++pValues)
//STRIP001 		{
//STRIP001 			PropertyMapEntry* pPropPos = static_cast<PropertyMapEntry*>(bsearch(pValues, pPropertyMap, nMapSize, sizeof(*pPropertyMap), PropertySearch));
//STRIP001 			if (pPropPos)
//STRIP001 			{
//STRIP001 				DataAccessDescriptorProperty eProperty = (DataAccessDescriptorProperty)pPropPos->mnHandle;
//STRIP001 				m_aValues[eProperty] = pValues->Value;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				// unknown property
//STRIP001 				bValidPropsOnly = sal_False;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bValidPropsOnly)
//STRIP001 		{
//STRIP001 			m_aAsSequence = _rValues;
//STRIP001 			m_bSequenceOutOfDate = sal_False;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			m_bSequenceOutOfDate = sal_True;
//STRIP001 
//STRIP001 		return bValidPropsOnly;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	sal_Bool ODADescriptorImpl::buildFrom( const Reference< XPropertySet >& _rxValues )
//STRIP001 	{
//STRIP001 		Reference< XPropertySetInfo > xPropInfo;
//STRIP001 		if (_rxValues.is())
//STRIP001 			xPropInfo = _rxValues->getPropertySetInfo();
//STRIP001 		if (!xPropInfo.is())
//STRIP001 		{
//STRIP001 			OSL_ENSURE(sal_False, "ODADescriptorImpl::buildFrom: invalid property set!");
//STRIP001 			return sal_False;
//STRIP001 		}
//STRIP001 
//STRIP001 		// build a PropertyValue sequence with the current values
//STRIP001 		Sequence< Property > aProperties = xPropInfo->getProperties();
//STRIP001 		const Property* pProperty = aProperties.getConstArray();
//STRIP001 		const Property* pPropertyEnd = pProperty + aProperties.getLength();
//STRIP001 
//STRIP001 		Sequence< PropertyValue > aValues(aProperties.getLength());
//STRIP001 		PropertyValue* pValues = aValues.getArray();
//STRIP001 
//STRIP001 		for (;pProperty != pPropertyEnd; ++pProperty, ++pValues)
//STRIP001 		{
//STRIP001 			pValues->Name = pProperty->Name;
//STRIP001 			pValues->Value = _rxValues->getPropertyValue(pProperty->Name);
//STRIP001 		}
//STRIP001 
//STRIP001 		sal_Bool bValidPropsOnly = buildFrom(aValues);
//STRIP001 		if (bValidPropsOnly)
//STRIP001 		{
//STRIP001 			m_xAsSet = _rxValues;
//STRIP001 			m_bSetOutOfDate = sal_False;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			m_bSetOutOfDate = sal_True;
//STRIP001 
//STRIP001 		return bValidPropsOnly;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODADescriptorImpl::invalidateExternRepresentations()
//STRIP001 	{
//STRIP001 		m_bSetOutOfDate = sal_True;
//STRIP001 		m_bSequenceOutOfDate = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	PropertyMapEntry* ODADescriptorImpl::getPropertyMap( ) const
//STRIP001 	{
//STRIP001 		// the properties we know
//STRIP001 		static PropertyMapEntry s_aDesriptorProperties[] =
//STRIP001 		{
//STRIP001 			{ CONST_CHAR("ActiveConnection"),	daConnection,		&::getCppuType( static_cast< Reference< XConnection >* >(NULL) ),	PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("BookmarkSelection"),	daBookmarkSelection,&::getBooleanCppuType( ),											PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("Column"),				daColumnObject,		&::getCppuType( static_cast< Reference< XPropertySet >* >(NULL) ),	PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("ColumnName"),			daColumnName,		&::getCppuType( static_cast< ::rtl::OUString* >(NULL) ),			PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("Command"),			daCommand,			&::getCppuType( static_cast< ::rtl::OUString* >(NULL) ),			PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("CommandType"),		daCommandType,		&::getCppuType( static_cast< sal_Int32* >(NULL) ),					PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("Cursor"),				daCursor,			&::getCppuType( static_cast< Reference< XResultSet>* >(NULL) ),		PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("DataSourceName"),		daDataSource,		&::getCppuType( static_cast< ::rtl::OUString* >(NULL) ),			PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("EscapeProcessing"),	daEscapeProcessing,	&::getBooleanCppuType( ),											PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("Filter"),				daFilter,			&::getCppuType( static_cast< ::rtl::OUString* >(NULL) ),			PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ CONST_CHAR("Selection"),			daSelection,		&::getCppuType( static_cast< Sequence< Any >* >(NULL) ),			PropertyAttribute::TRANSIENT, 0 },
//STRIP001 			{ NULL, 0, 0, NULL, 0, 0 }
//STRIP001 		};
//STRIP001 		// MUST be sorted !!
//STRIP001 
//STRIP001 #if OSL_DEBUG_LEVEL > 0
//STRIP001 		PropertyMapEntry* pLoop = s_aDesriptorProperties;
//STRIP001 		if (pLoop->mpName)
//STRIP001 		{
//STRIP001 			::rtl::OUString sLeft = ::rtl::OUString::createFromAscii(pLoop->mpName);
//STRIP001 			::rtl::OUString sRight;
//STRIP001 			while ((++pLoop)->mpName)
//STRIP001 			{
//STRIP001 				sRight = ::rtl::OUString::createFromAscii(pLoop->mpName);
//STRIP001 				OSL_ENSURE(sLeft < sRight, "ODADescriptorImpl::getPropertyMap: property map not sorted!");
//STRIP001 				sLeft = sRight;
//STRIP001 			}
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		return s_aDesriptorProperties;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	PropertyMapEntry* ODADescriptorImpl::getPropertyMapEntry( const ConstDescriptorValuesIterator& _rPos ) const
//STRIP001 	{
//STRIP001 		PropertyMapEntry* pMap = getPropertyMap();
//STRIP001 
//STRIP001 		// the index in the map above (depends on the property requested)
//STRIP001 		sal_Int32 nNeededHandle = (sal_Int32)(_rPos->first);
//STRIP001 
//STRIP001 		PropertyMapEntry* pSearchHandle = pMap;
//STRIP001 		while (pSearchHandle->mpName)
//STRIP001 		{
//STRIP001 			if (nNeededHandle == pSearchHandle->mnHandle)
//STRIP001 				return pSearchHandle;
//STRIP001 
//STRIP001 			++pSearchHandle;
//STRIP001 		}
//STRIP001 		OSL_ENSURE(sal_False, "ODADescriptorImpl::getPropertyMapEntry: could not find the property!");
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	PropertyValue ODADescriptorImpl::buildPropertyValue( const ConstDescriptorValuesIterator& _rPos )
//STRIP001 	{
//STRIP001 		// the map entry
//STRIP001 		PropertyMapEntry* pProp = getPropertyMapEntry(_rPos);
//STRIP001 
//STRIP001 		// build the property value
//STRIP001 		PropertyValue aReturn;
//STRIP001 		aReturn.Name	= ::rtl::OUString::createFromAscii(pProp->mpName);
//STRIP001 		aReturn.Handle	= pProp->mnHandle;
//STRIP001 		aReturn.Value	= _rPos->second;
//STRIP001 		aReturn.State	= PropertyState_DIRECT_VALUE;
//STRIP001 
//STRIP001 #if OSL_DEBUG_LEVEL > 0
//STRIP001 		// check for type consistency
//STRIP001 		if (TypeClass_INTERFACE == pProp->mpType->getTypeClass())
//STRIP001 		{
//STRIP001 			Reference< XInterface > xCurrentValue;
//STRIP001 			_rPos->second >>= xCurrentValue;
//STRIP001 			Any aRequestedIFace;
//STRIP001 			if (xCurrentValue.is())
//STRIP001 				aRequestedIFace = xCurrentValue->queryInterface(*pProp->mpType);
//STRIP001 			OSL_ENSURE(aRequestedIFace.hasValue(), "ODADescriptorImpl::buildPropertyValue: invalid property value type (missing the requested interface)!");
//STRIP001 		}
//STRIP001 		else
//STRIP001 			OSL_ENSURE(pProp->mpType->equals(_rPos->second.getValueType()), "ODADescriptorImpl::buildPropertyValue: invalid property value type!");
//STRIP001 #endif
//STRIP001 
//STRIP001 		// outta here
//STRIP001 		return aReturn;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODADescriptorImpl::updateSequence()
//STRIP001 	{
//STRIP001 		if (!m_bSequenceOutOfDate)
//STRIP001 			return;
//STRIP001 
//STRIP001 		m_aAsSequence.realloc(m_aValues.size());
//STRIP001 		PropertyValue* pValue = m_aAsSequence.getArray();
//STRIP001 
//STRIP001 		// loop through all our values
//STRIP001 		for	(	ConstDescriptorValuesIterator aLoop = m_aValues.begin();
//STRIP001 				aLoop != m_aValues.end();
//STRIP001 				++aLoop, ++pValue
//STRIP001 			)
//STRIP001 		{
//STRIP001 			*pValue = buildPropertyValue(aLoop);
//STRIP001 		}
//STRIP001 
//STRIP001 		// don't need to rebuild next time
//STRIP001 		m_bSequenceOutOfDate = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODADescriptorImpl::updateSet()
//STRIP001 	{
//STRIP001 		if (!m_bSetOutOfDate)
//STRIP001 			return;
//STRIP001 
//STRIP001 		// will be the current values
//STRIP001 		Sequence< PropertyValue > aValuesToSet(m_aValues.size());
//STRIP001 		PropertyValue* pValuesToSet = aValuesToSet.getArray();
//STRIP001 
//STRIP001 		// build a new property set info
//STRIP001 		PropertySetInfo* pPropSetInfo = new PropertySetInfo;
//STRIP001 
//STRIP001 		// loop through all our values
//STRIP001 		for	(	ConstDescriptorValuesIterator aLoop = m_aValues.begin();
//STRIP001 				aLoop != m_aValues.end();
//STRIP001 				++aLoop, ++pValuesToSet
//STRIP001 			)
//STRIP001 		{
//STRIP001 			PropertyMapEntry* pMapEntry = getPropertyMapEntry(aLoop);
//STRIP001 			pPropSetInfo->add( pMapEntry, 1 );
//STRIP001 
//STRIP001 			*pValuesToSet = buildPropertyValue(aLoop);
//STRIP001 		}
//STRIP001 
//STRIP001 		// create the generic set
//STRIP001 		m_xAsSet = GenericPropertySet_CreateInstance( pPropSetInfo );
//STRIP001 
//STRIP001 		// no we have the set, still need to set the current values
//STRIP001 		const PropertyValue* pSetValues = aValuesToSet.getConstArray();
//STRIP001 		const PropertyValue* pSetValuesEnd = pSetValues + aValuesToSet.getLength();
//STRIP001 		for	(; pSetValues != pSetValuesEnd; ++pSetValues)
//STRIP001 			m_xAsSet->setPropertyValue(pSetValues->Name, pSetValues->Value);
//STRIP001 
//STRIP001 		// don't need to rebuild next time
//STRIP001 		m_bSetOutOfDate = sal_True;
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	//====================================================================
//STRIP001 	//= ODataAccessDescriptor
//STRIP001 	//====================================================================
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODataAccessDescriptor::ODataAccessDescriptor()
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		:m_pImpl(new ODADescriptorImpl)
//STRIP001 #else
//STRIP001 		:m_pImpl(NULL)
//STRIP001 #endif
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODataAccessDescriptor::ODataAccessDescriptor( const ODataAccessDescriptor& _rSource )
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		:m_pImpl(new ODADescriptorImpl(*_rSource.m_pImpl))
//STRIP001 #else
//STRIP001 		:m_pImpl(NULL)
//STRIP001 #endif
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	const ODataAccessDescriptor& ODataAccessDescriptor::operator=(const ODataAccessDescriptor& _rSource)
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		delete m_pImpl;
//STRIP001 		m_pImpl = new ODADescriptorImpl(*_rSource.m_pImpl);
//STRIP001 #else
//STRIP001 		OSL_ENSURE(sal_False, "ODataAccessDescriptor::operator=: not available in the SVX_LIGHT version!");
//STRIP001 #endif
//STRIP001 		return *this;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODataAccessDescriptor::ODataAccessDescriptor( const Reference< XPropertySet >& _rValues )
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		:m_pImpl(new ODADescriptorImpl)
//STRIP001 #else
//STRIP001 		:m_pImpl(NULL)
//STRIP001 #endif
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->buildFrom(_rValues);
//STRIP001 #else
//STRIP001 		OSL_ENSURE(sal_False, "ODataAccessDescriptor::ODataAccessDescriptor: not available in the SVX_LIGHT version!");
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODataAccessDescriptor::ODataAccessDescriptor( const Any& _rValues )
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		:m_pImpl(new ODADescriptorImpl)
//STRIP001 #else
//STRIP001 		:m_pImpl(NULL)
//STRIP001 #endif
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		// check if we know the format in the Any
//STRIP001 		Sequence< PropertyValue > aValues;
//STRIP001 		Reference< XPropertySet > xValues;
//STRIP001 		if ( _rValues >>= aValues )
//STRIP001 			m_pImpl->buildFrom( aValues );
//STRIP001 		else if ( _rValues >>= xValues )
//STRIP001 			m_pImpl->buildFrom( xValues );
//STRIP001 #else
//STRIP001 		OSL_ENSURE(sal_False, "ODataAccessDescriptor::ODataAccessDescriptor: not available in the SVX_LIGHT version!");
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODataAccessDescriptor::ODataAccessDescriptor( const Sequence< PropertyValue >& _rValues )
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		:m_pImpl(new ODADescriptorImpl)
//STRIP001 #else
//STRIP001 		:m_pImpl(NULL)
//STRIP001 #endif
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->buildFrom(_rValues);
//STRIP001 #else
//STRIP001 		OSL_ENSURE(sal_False, "ODataAccessDescriptor::ODataAccessDescriptor: not available in the SVX_LIGHT version!");
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ODataAccessDescriptor::~ODataAccessDescriptor()
//STRIP001 	{
//STRIP001 		delete m_pImpl;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODataAccessDescriptor::clear()
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->m_aValues.clear();
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODataAccessDescriptor::erase(DataAccessDescriptorProperty _eWhich)
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		OSL_ENSURE(has(_eWhich), "ODataAccessDescriptor::erase: invalid call!");
//STRIP001 		if (has(_eWhich))
//STRIP001 			m_pImpl->m_aValues.erase(_eWhich);
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	sal_Bool ODataAccessDescriptor::has(DataAccessDescriptorProperty _eWhich) const
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		return m_pImpl->m_aValues.find(_eWhich) != m_pImpl->m_aValues.end();
//STRIP001 #else
//STRIP001 		return sal_False;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	const Any& ODataAccessDescriptor::operator [] ( DataAccessDescriptorProperty _eWhich ) const
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		if (!has(_eWhich))
//STRIP001 		{
//STRIP001 			OSL_ENSURE(sal_False, "ODataAccessDescriptor::operator[]: invalid acessor!");
//STRIP001 			static const Any aDummy;
//STRIP001 			return aDummy;
//STRIP001 		}
//STRIP001 
//STRIP001 		return m_pImpl->m_aValues[_eWhich];
//STRIP001 #else
//STRIP001 		static const Any aDummy;
//STRIP001 		return aDummy;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	Any& ODataAccessDescriptor::operator[] ( DataAccessDescriptorProperty _eWhich )
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->invalidateExternRepresentations();
//STRIP001 		return m_pImpl->m_aValues[_eWhich];
//STRIP001 #else
//STRIP001 		static const Any aDummy;
//STRIP001 		return aDummy;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODataAccessDescriptor::initializeFrom(const Reference< XPropertySet >& _rxValues, sal_Bool _bClear)
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		if (_bClear)
//STRIP001 			clear();
//STRIP001 		m_pImpl->buildFrom(_rxValues);
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ODataAccessDescriptor::initializeFrom(const Sequence< PropertyValue >& _rValues, sal_Bool _bClear)
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		if (_bClear)
//STRIP001 			clear();
//STRIP001 		m_pImpl->buildFrom(_rValues);
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	Sequence< PropertyValue > ODataAccessDescriptor::createPropertyValueSequence()
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->updateSequence();
//STRIP001 		return m_pImpl->m_aAsSequence;
//STRIP001 #else
//STRIP001 		return Sequence< PropertyValue >();
//STRIP001 #endif
//STRIP001 	}
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	Sequence< Any > ODataAccessDescriptor::createAnySequence()
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->updateSequence();
//STRIP001 		Sequence< Any > aRet(m_pImpl->m_aAsSequence.getLength());
//STRIP001 		const PropertyValue* pBegin = m_pImpl->m_aAsSequence.getConstArray();
//STRIP001 		const PropertyValue* pEnd	  = pBegin + m_pImpl->m_aAsSequence.getLength();
//STRIP001 		for(sal_Int32 i=0;pBegin != pEnd;++pBegin,++i)
//STRIP001 			aRet[i] <<= *pBegin;
//STRIP001 		return aRet;
//STRIP001 #else
//STRIP001 		return Sequence< createAnySequence >();
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	Reference< XPropertySet > ODataAccessDescriptor::createPropertySet()
//STRIP001 	{
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 		m_pImpl->updateSet();
//STRIP001 		return m_pImpl->m_xAsSet;
//STRIP001 #else
//STRIP001 		return Reference< XPropertySet >();
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 //........................................................................
//STRIP001 }	// namespace svx
//........................................................................


}
