/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_filtnav.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:40:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

#ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
#include <com/sun/star/awt/XFocusListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

// auto strip #ifndef _SVX_FMCTRLER_HXX
// auto strip #include "fmctrler.hxx"
// auto strip #endif

#ifndef _SVX_FILTNAV_HXX
#include "filtnav.hxx"
#endif

// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATTER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatter.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XFORMCONTROLLER_HPP_
// auto strip #include <com/sun/star/form/XFormController.hpp>
// auto strip #endif

// auto strip #ifndef _SVX_FMEXCH_HXX
// auto strip #include <fmexch.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FMITEMS_HXX
// auto strip #include "fmitems.hxx"
// auto strip #endif

#ifndef _SVX_SVXIDS_HRC
#include "svxids.hrc"
#endif

#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif

#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif

// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include "dialmgr.hxx"
// auto strip #endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_OBJITEM_HXX //autogen
// auto strip #include <bf_sfx2/objitem.hxx>
// auto strip #endif

// auto strip #ifndef _SFXREQUEST_HXX
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FMSHELL_HXX //autogen
// auto strip #include <fmshell.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FMSHIMP_HXX
// auto strip #include <fmshimp.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FMSERVS_HXX
// auto strip #include <fmservs.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include <fmtools.hxx>
// auto strip #endif

// auto strip #ifndef _CPPUHELPER_IMPLBASE1_HXX_
// auto strip #include <cppuhelper/implbase1.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_UNO3_HXX_
// auto strip #include <comphelper/uno3.hxx>
// auto strip #endif
// auto strip #ifndef _CONNECTIVITY_DBTOOLS_HXX_
// auto strip #include <connectivity/dbtools.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
// auto strip #include <com/sun/star/lang/XUnoTunnel.hpp>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_SEQUENCE_HXX_
// auto strip #include <comphelper/sequence.hxx>
// auto strip #endif
#ifndef _SVX_GRIDCELL_HXX
#include "gridcell.hxx"
#endif
// auto strip #ifndef _ISOLANG_HXX
// auto strip #include <tools/isolang.hxx>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

#define SYNC_DELAY						200
#define DROP_ACTION_TIMER_INITIAL_TICKS 	10
	// solange dauert es, bis das Scrollen anspringt
#define DROP_ACTION_TIMER_SCROLL_TICKS		3
	// in diesen Intervallen wird jeweils eine Zeile gescrollt
#define DROP_ACTION_TIMER_TICK_BASE 		10
	// das ist die Basis, mit der beide Angaben multipliziert werden (in ms)

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::util;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::connectivity::simple;
using namespace ::connectivity;


//........................................................................
namespace svxform
{
//STRIP001 //........................................................................
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 OFilterItemExchange::OFilterItemExchange()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void OFilterItemExchange::AddSupportedFormats()
//STRIP001 {
//STRIP001 	AddFormat(getFormatId());
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_uInt32 OFilterItemExchange::getFormatId()
//STRIP001 {
//STRIP001 	static sal_uInt32 s_nFormat = (sal_uInt32)-1;
//STRIP001 	if ((sal_uInt32)-1 == s_nFormat)
//STRIP001 	{
//STRIP001 		s_nFormat = SotExchange::RegisterFormatName(String::CreateFromAscii("application/x-openoffice;windows_formatname=\"form.FilterControlExchange\""));
//STRIP001 		DBG_ASSERT((sal_uInt32)-1 != s_nFormat, "OFilterExchangeHelper::getFormatId: bad exchange id!");
//STRIP001 	}
//STRIP001 	return s_nFormat;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 OLocalExchange* OFilterExchangeHelper::createExchange() const
//STRIP001 {
//STRIP001 	return new OFilterItemExchange;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 TYPEINIT0(FmFilterData);
//STRIP001 Image FmFilterData::GetImage( BmpColorMode _eMode ) const
//STRIP001 {
//STRIP001 	return Image();
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 TYPEINIT1(FmParentData, FmFilterData);
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmParentData::~FmParentData()
//STRIP001 {
//STRIP001 	for (::std::vector<FmFilterData*>::const_iterator i = m_aChilds.begin();
//STRIP001 		 i != m_aChilds.end(); i++)
//STRIP001 		delete (*i);
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 TYPEINIT1(FmFormItem, FmParentData);
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Image FmFormItem::GetImage( BmpColorMode _eMode ) const
//STRIP001 {
//STRIP001 	static Image aImage;
//STRIP001 	static Image aImage_HC;
//STRIP001 
//STRIP001 	if (!aImage)
//STRIP001 	{
//STRIP001 		ImageList aNavigatorImages( SVX_RES( RID_SVXIMGLIST_FMEXPL ) );
//STRIP001 		ImageList aNavigatorImages_HC( SVX_RES( RID_SVXIMGLIST_FMEXPL_HC ) );
//STRIP001 
//STRIP001 		aImage = aNavigatorImages.GetImage( RID_SVXIMG_FORM );
//STRIP001 		aImage_HC = aNavigatorImages_HC.GetImage( RID_SVXIMG_FORM );
//STRIP001 	}
//STRIP001 	return ( BMP_COLOR_HIGHCONTRAST == _eMode ) ? aImage_HC : aImage;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 TYPEINIT1(FmFilterItems, FmParentData);
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterItem* FmFilterItems::Find(const Reference< ::com::sun::star::awt::XTextComponent > & _xText) const
//STRIP001 {
//STRIP001 	for (vector<FmFilterData*>::const_iterator i = m_aChilds.begin();
//STRIP001 		 i != m_aChilds.end(); ++i)
//STRIP001 	{
//STRIP001 		FmFilterItem* pCond = PTR_CAST(FmFilterItem, *i);
//STRIP001 		DBG_ASSERT(pCond, "Wrong element in container");
//STRIP001 		if (_xText == pCond->GetTextComponent())
//STRIP001 			return pCond;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Image FmFilterItems::GetImage( BmpColorMode _eMode ) const
//STRIP001 {
//STRIP001 	static Image aImage;
//STRIP001 	static Image aImage_HC;
//STRIP001 
//STRIP001 	if (!aImage)
//STRIP001 	{
//STRIP001 		ImageList aNavigatorImages( SVX_RES( RID_SVXIMGLIST_FMEXPL ) );
//STRIP001 		ImageList aNavigatorImages_HC( SVX_RES( RID_SVXIMGLIST_FMEXPL_HC ) );
//STRIP001 
//STRIP001 		aImage = aNavigatorImages.GetImage( RID_SVXIMG_FILTER );
//STRIP001 		aImage_HC = aNavigatorImages_HC.GetImage( RID_SVXIMG_FILTER );
//STRIP001 	}
//STRIP001 	return ( BMP_COLOR_HIGHCONTRAST == _eMode ) ? aImage_HC : aImage;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 TYPEINIT1(FmFilterItem, FmFilterData);
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterItem::FmFilterItem(const Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxFactory,
//STRIP001 						   FmFilterItems* pParent,
//STRIP001 					 const ::rtl::OUString& aFieldName,
//STRIP001 					 const ::rtl::OUString& aText,
//STRIP001 					 const Reference< ::com::sun::star::awt::XTextComponent > & _xText)
//STRIP001 		  :FmFilterData(_rxFactory,pParent, aText)
//STRIP001 		  ,m_aFieldName(aFieldName)
//STRIP001 		  ,m_xText(_xText)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Image FmFilterItem::GetImage( BmpColorMode _eMode ) const
//STRIP001 {
//STRIP001 	static Image aImage;
//STRIP001 	static Image aImage_HC;
//STRIP001 
//STRIP001 	if (!aImage)
//STRIP001 	{
//STRIP001 		ImageList aNavigatorImages( SVX_RES( RID_SVXIMGLIST_FMEXPL ) );
//STRIP001 		ImageList aNavigatorImages_HC( SVX_RES( RID_SVXIMGLIST_FMEXPL_HC ) );
//STRIP001 
//STRIP001 		aImage = aNavigatorImages.GetImage( RID_SVXIMG_FIELD );
//STRIP001 		aImage_HC = aNavigatorImages_HC.GetImage( RID_SVXIMG_FIELD );
//STRIP001 	}
//STRIP001 	return ( BMP_COLOR_HIGHCONTRAST == _eMode ) ? aImage_HC : aImage;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // Hints for communicatition between model and view
//STRIP001 //========================================================================
//STRIP001 class FmFilterHint : public SfxHint
//STRIP001 {
//STRIP001 	FmFilterData*	m_pData;
//STRIP001 
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FmFilterHint(FmFilterData* pData):m_pData(pData){}
//STRIP001 	FmFilterData* GetData() const { return m_pData; }
//STRIP001 };
//STRIP001 TYPEINIT1( FmFilterHint, SfxHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 class FmFilterInsertedHint : public FmFilterHint
//STRIP001 {
//STRIP001 	sal_Int32 m_nPos;	// Position relative to the parent of the data
//STRIP001 
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FmFilterInsertedHint(FmFilterData* pData, sal_Int32 nRelPos)
//STRIP001 		:FmFilterHint(pData)
//STRIP001 		,m_nPos(nRelPos){}
//STRIP001 
//STRIP001 	sal_Int32 GetPos() const { return m_nPos; }
//STRIP001 };
//STRIP001 TYPEINIT1( FmFilterInsertedHint, FmFilterHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 class FmFilterReplacedHint : public FmFilterHint
//STRIP001 {
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FmFilterReplacedHint(FmFilterData* pData)
//STRIP001 		:FmFilterHint(pData){}
//STRIP001 
//STRIP001 };
//STRIP001 TYPEINIT1( FmFilterReplacedHint, FmFilterHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 class FmFilterRemovedHint : public FmFilterHint
//STRIP001 {
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FmFilterRemovedHint(FmFilterData* pData)
//STRIP001 		:FmFilterHint(pData){}
//STRIP001 
//STRIP001 };
//STRIP001 TYPEINIT1( FmFilterRemovedHint, FmFilterHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 class FmFilterTextChangedHint : public FmFilterHint
//STRIP001 {
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FmFilterTextChangedHint(FmFilterData* pData)
//STRIP001 		:FmFilterHint(pData){}
//STRIP001 
//STRIP001 };
//STRIP001 TYPEINIT1( FmFilterTextChangedHint, FmFilterHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 class FilterClearingHint : public SfxHint
//STRIP001 {
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FilterClearingHint(){}
//STRIP001 };
//STRIP001 TYPEINIT1( FilterClearingHint, SfxHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 class FmFilterCurrentChangedHint : public SfxHint
//STRIP001 {
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	FmFilterCurrentChangedHint(){}
//STRIP001 };
//STRIP001 TYPEINIT1( FmFilterCurrentChangedHint, SfxHint );
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // class FmFilterAdapter, Listener an den FilterControls
//STRIP001 //========================================================================
//STRIP001 class FmFilterAdapter : public ::cppu::WeakImplHelper1< ::com::sun::star::awt::XTextListener >
//STRIP001 {
//STRIP001 	FmFilterControls		m_aFilterControls;
//STRIP001 	FmFilterModel*			m_pModel;
//STRIP001 
//STRIP001 public:
//STRIP001 	FmFilterAdapter(FmFilterModel* pModel, const Reference< ::com::sun::star::container::XIndexAccess >& xControllers);
//STRIP001 
//STRIP001 // ::com::sun::star::lang::XEventListener
//STRIP001 	virtual void SAL_CALL disposing(const ::com::sun::star::lang::EventObject& Source) throw( RuntimeException );
//STRIP001 
//STRIP001 // ::com::sun::star::awt::XTextListener
//STRIP001 	virtual void SAL_CALL textChanged(const ::com::sun::star::awt::TextEvent& e) throw( ::com::sun::star::uno::RuntimeException );
//STRIP001 
//STRIP001 // helpers
//STRIP001 	void dispose() throw( RuntimeException );
//STRIP001 
//STRIP001 	void InsertElements(const Reference< ::com::sun::star::container::XIndexAccess >& xControllers);
//STRIP001 	void RemoveElement(const Reference< ::com::sun::star::awt::XTextComponent > & xText);
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::beans::XPropertySet > getField(const Reference< ::com::sun::star::awt::XTextComponent > & xText) const;
//STRIP001 	void setText(sal_Int32 nPos,
//STRIP001 		const FmFilterItem* pFilterItem,
//STRIP001 		const ::rtl::OUString& rText);
//STRIP001 	void DeleteItemsByText(::std::vector<FmFilterData*>& rItems, const Reference< ::com::sun::star::awt::XTextComponent > & xText);
//STRIP001 	Reference< ::com::sun::star::form::XForm > findForm(const Reference< ::com::sun::star::container::XChild >& xChild);
//STRIP001 };
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterAdapter::FmFilterAdapter(FmFilterModel* pModel, const Reference< ::com::sun::star::container::XIndexAccess >& xControllers)
//STRIP001 				 :m_pModel(pModel)
//STRIP001 {
//STRIP001 	InsertElements(xControllers);
//STRIP001 
//STRIP001 	// listen on all controls as text listener
//STRIP001 	for (FmFilterControls::const_iterator iter = m_aFilterControls.begin();
//STRIP001 		iter != m_aFilterControls.end(); iter++)
//STRIP001 		(*iter).first->addTextListener(this);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterAdapter::dispose() throw( RuntimeException )
//STRIP001 {
//STRIP001 	// clear the filter control map
//STRIP001 	for (FmFilterControls::const_iterator iter = m_aFilterControls.begin();
//STRIP001 		 iter != m_aFilterControls.end(); iter++)
//STRIP001 		 (*iter).first->removeTextListener(this);
//STRIP001 
//STRIP001 	m_aFilterControls.clear();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------------
//STRIP001 // delete all items relate to the control
//STRIP001 void FmFilterAdapter::DeleteItemsByText(::std::vector<FmFilterData*>& rItems,
//STRIP001 										const Reference< ::com::sun::star::awt::XTextComponent > & xText)
//STRIP001 {
//STRIP001 	for (::std::vector<FmFilterData*>::reverse_iterator i = rItems.rbegin();
//STRIP001 		// link problems with operator ==
//STRIP001 		i.base() != rItems.rend().base(); i++)
//STRIP001 	{
//STRIP001 		FmFilterItems* pFilterItems = PTR_CAST(FmFilterItems, *i);
//STRIP001 		if (pFilterItems)
//STRIP001 		{
//STRIP001 			FmFilterItem* pFilterItem = pFilterItems->Find(xText);
//STRIP001 			if (pFilterItem)
//STRIP001 			{
//STRIP001 				// remove the condition
//STRIP001 				::std::vector<FmFilterData*>& rItems = pFilterItems->GetChilds();
//STRIP001 				::std::vector<FmFilterData*>::iterator j = find(rItems.begin(), rItems.end(), pFilterItem);
//STRIP001 				if (j != rItems.end())
//STRIP001 					m_pModel->Remove(j, pFilterItem);
//STRIP001 			}
//STRIP001 			continue;
//STRIP001 		}
//STRIP001 		FmFormItem* pFormItem = PTR_CAST(FmFormItem, *i);
//STRIP001 		if (pFormItem)
//STRIP001 			DeleteItemsByText(pFormItem->GetChilds(), xText);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterAdapter::InsertElements(const Reference< ::com::sun::star::container::XIndexAccess >& xControllers)
//STRIP001 {
//STRIP001 	for (sal_Int32 i = 0, nLen = xControllers->getCount(); i < nLen; ++i)
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::container::XIndexAccess > xElement;
//STRIP001 		xControllers->getByIndex(i) >>= xElement;
//STRIP001 
//STRIP001 		// Insert the Elements of the controller
//STRIP001 		InsertElements(xElement);
//STRIP001 
//STRIP001 		// store the filter controls
//STRIP001 		FmXFormController* pController = NULL;
//STRIP001 		//	::comphelper::getImplementation(pController, Reference<XUnoTunnel>(xElement, UNO_QUERY));
//STRIP001 		Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(xElement,UNO_QUERY);
//STRIP001 		DBG_ASSERT(xTunnel.is(), "FmFilterAdapter::InsertElements : xTunnel is invalid!");
//STRIP001 		if(xTunnel.is())
//STRIP001 		{
//STRIP001 			pController = (FmXFormController*)xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId());
//STRIP001 		}
//STRIP001 
//STRIP001 		const FmFilterControls& rControls = pController->getFilterControls();
//STRIP001 		for (FmFilterControls::const_iterator iter = rControls.begin(); iter != rControls.end(); ++iter )
//STRIP001 			m_aFilterControls.insert(*iter);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------------
//STRIP001 void FmFilterAdapter::RemoveElement(const Reference< ::com::sun::star::awt::XTextComponent > & xText)
//STRIP001 {
//STRIP001 	if (xText.is())
//STRIP001 	{
//STRIP001 		// alle Level durchlaufen und eintraege entfernen
//STRIP001 		if (m_pModel)
//STRIP001 			DeleteItemsByText(m_pModel->GetChilds(), xText);
//STRIP001 
//STRIP001 		FmFilterControls::iterator iter = m_aFilterControls.find(xText);
//STRIP001 		if (iter != m_aFilterControls.end())
//STRIP001 			m_aFilterControls.erase(iter);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Reference< ::com::sun::star::beans::XPropertySet >	FmFilterAdapter::getField(const Reference< ::com::sun::star::awt::XTextComponent > & xText) const
//STRIP001 {
//STRIP001 	Reference< ::com::sun::star::beans::XPropertySet >	xField;
//STRIP001 	FmFilterControls::const_iterator i = m_aFilterControls.find(xText);
//STRIP001 	if (i != m_aFilterControls.end())
//STRIP001 		xField = (*i).second;
//STRIP001 
//STRIP001 	return xField;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterAdapter::setText(sal_Int32 nRowPos,
//STRIP001 							  const FmFilterItem* pFilterItem,
//STRIP001 							  const ::rtl::OUString& rText)
//STRIP001 {
//STRIP001 	// set the text for the text component
//STRIP001 	Reference< ::com::sun::star::awt::XTextComponent > xText(pFilterItem->GetTextComponent());
//STRIP001 	xText->setText(rText);
//STRIP001 
//STRIP001 	// get the controller of the text component and its filter rows
//STRIP001 	FmFormItem* pFormItem = PTR_CAST(FmFormItem,pFilterItem->GetParent()->GetParent());
//STRIP001 	FmXFormController* pController = NULL;
//STRIP001 	Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(pFormItem->GetController(),UNO_QUERY);
//STRIP001 	DBG_ASSERT(xTunnel.is(), "FmFilterAdapter::InsertElements : xTunnel is invalid!");
//STRIP001 	if(xTunnel.is())
//STRIP001 	{
//STRIP001 		pController = (FmXFormController*)xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId());
//STRIP001 	}
//STRIP001 	//	::comphelper::getImplementation(pController, Reference<XUnoTunnel>(pFormItem->GetController(),UNO_QUERY));
//STRIP001 	FmFilterRows& rRows = pController->getFilterRows();
//STRIP001 
//STRIP001 	DBG_ASSERT(nRowPos < (sal_Int32)rRows.size(), "wrong row pos");
//STRIP001 	// Suchen der aktuellen Row
//STRIP001 	FmFilterRow& rRow = rRows[nRowPos];
//STRIP001 
//STRIP001 	// do we have a new filter
//STRIP001 	if (rText.getLength())
//STRIP001 		rRow[xText] = rText;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// do we have the control in the row
//STRIP001 		FmFilterRow::iterator iter = rRow.find(xText);
//STRIP001 		// erase the entry out of the row
//STRIP001 		if (iter != rRow.end())
//STRIP001 			rRow.erase(iter);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ::com::sun::star::lang::XEventListener
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void SAL_CALL FmFilterAdapter::disposing(const ::com::sun::star::lang::EventObject& e) throw( RuntimeException )
//STRIP001 {
//STRIP001 	Reference< ::com::sun::star::awt::XTextComponent >	xText(e.Source,UNO_QUERY);
//STRIP001 	if (xText.is())
//STRIP001 		RemoveElement(xText);
//STRIP001 }
//STRIP001 
//STRIP001 // XTextListener
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Reference< ::com::sun::star::form::XForm > FmFilterAdapter::findForm(const Reference< ::com::sun::star::container::XChild >& xChild)
//STRIP001 {
//STRIP001 	Reference< ::com::sun::star::form::XForm > xForm;
//STRIP001 	if (xChild.is())
//STRIP001 	{
//STRIP001 		xForm = Reference< ::com::sun::star::form::XForm >(xChild->getParent(), UNO_QUERY);
//STRIP001 		if (!xForm.is())
//STRIP001 			xForm = findForm(Reference< ::com::sun::star::container::XChild >(xChild->getParent(), UNO_QUERY));
//STRIP001 	}
//STRIP001 	return xForm;
//STRIP001 }
//STRIP001 
//STRIP001 // XTextListener
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterAdapter::textChanged(const ::com::sun::star::awt::TextEvent& e) throw( ::com::sun::star::uno::RuntimeException )
//STRIP001 {
//STRIP001 	// Find the according formitem in the
//STRIP001 	Reference< ::com::sun::star::awt::XControl > xControl(e.Source, UNO_QUERY);
//STRIP001 	if (!m_pModel || !xControl.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::form::XForm > xForm(findForm(Reference< ::com::sun::star::container::XChild >(xControl->getModel(), UNO_QUERY)));
//STRIP001 	if (!xForm.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	FmFormItem* pFormItem = m_pModel->Find(m_pModel->m_aChilds, xForm);
//STRIP001 	if (pFormItem)
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::awt::XTextComponent > xText(e.Source, UNO_QUERY);
//STRIP001 		FmFilterItems* pFilter = PTR_CAST(FmFilterItems, pFormItem->GetChilds()[pFormItem->GetCurrentPosition()]);
//STRIP001 		FmFilterItem* pFilterItem = pFilter->Find(xText);
//STRIP001 		if (pFilterItem)
//STRIP001 		{
//STRIP001 			if (xText->getText().getLength())
//STRIP001 			{
//STRIP001 				pFilterItem->SetText(xText->getText());
//STRIP001 				// UI benachrichtigen
//STRIP001 				FmFilterTextChangedHint aChangeHint(pFilterItem);
//STRIP001 				m_pModel->Broadcast( aChangeHint );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// no text anymore so remove the condition
//STRIP001 				m_pModel->Remove(pFilterItem);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// searching the component by field name
//STRIP001 			::rtl::OUString aFieldName = getLabelName(Reference< ::com::sun::star::beans::XPropertySet > (Reference< ::com::sun::star::awt::XControl > (xText, UNO_QUERY)->getModel(),UNO_QUERY));
//STRIP001 
//STRIP001 			pFilterItem = new FmFilterItem(m_pModel->getORB(),pFilter, aFieldName, xText->getText(), xText);
//STRIP001 			m_pModel->Insert(pFilter->GetChilds().end(), pFilterItem);
//STRIP001 		}
//STRIP001 		m_pModel->CheckIntegrity(pFormItem);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // class FmFilterModel
//STRIP001 //========================================================================
//STRIP001 TYPEINIT1(FmFilterModel, FmParentData);
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterModel::FmFilterModel(const Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxFactory)
//STRIP001 			  :FmParentData(_rxFactory,NULL, ::rtl::OUString())
//STRIP001 			  ,OSQLParserClient(_rxFactory)
//STRIP001 			  ,m_pAdapter(NULL)
//STRIP001 			  ,m_pCurrentItems(NULL)
//STRIP001 			  ,m_xORB(_rxFactory)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterModel::~FmFilterModel()
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Clear()
//STRIP001 {
//STRIP001 	// notify
//STRIP001 	FilterClearingHint aClearedHint;
//STRIP001 	Broadcast( aClearedHint );
//STRIP001 
//STRIP001 	// loose endings
//STRIP001 	if (m_pAdapter)
//STRIP001 	{
//STRIP001 		m_pAdapter->dispose();
//STRIP001 		m_pAdapter->release();
//STRIP001 		m_pAdapter= NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	m_pCurrentItems  = NULL;
//STRIP001 	m_xController	 = NULL;
//STRIP001 	m_xControllers	 = NULL;
//STRIP001 
//STRIP001 	for (::std::vector<FmFilterData*>::const_iterator i = m_aChilds.begin();
//STRIP001 		 i != m_aChilds.end(); i++)
//STRIP001 		delete (*i);
//STRIP001 
//STRIP001 	m_aChilds.clear();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Update(const Reference< ::com::sun::star::container::XIndexAccess > & xControllers, const Reference< ::com::sun::star::form::XFormController > & xCurrent)
//STRIP001 {
//STRIP001 	if ((::com::sun::star::form::XFormController*) xCurrent.get() == (::com::sun::star::form::XFormController*) m_xController.get())
//STRIP001 		return;
//STRIP001 
//STRIP001 	if (!xControllers.is())
//STRIP001 	{
//STRIP001 		Clear();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// there is only a new current controller
//STRIP001 	if ((::com::sun::star::container::XIndexAccess*)m_xControllers.get() != (::com::sun::star::container::XIndexAccess*)xControllers.get())
//STRIP001 	{
//STRIP001 		Clear();
//STRIP001 
//STRIP001 		m_xControllers = xControllers;
//STRIP001 		Update(m_xControllers, this);
//STRIP001 
//STRIP001 		DBG_ASSERT(xCurrent.is(), "FmFilterModel::Update(...) no current controller");
//STRIP001 
//STRIP001 		// Listening for TextChanges
//STRIP001 		m_pAdapter = new FmFilterAdapter(this, xControllers);
//STRIP001 		m_pAdapter->acquire();
//STRIP001 
//STRIP001 		SetCurrentController(xCurrent);
//STRIP001 		CheckIntegrity(this);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetCurrentController(xCurrent);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Update(const Reference< ::com::sun::star::container::XIndexAccess > & xControllers, FmParentData* pParent)
//STRIP001 {
//STRIP001 	sal_Int32 nCount = xControllers->getCount();
//STRIP001 	for (sal_Int32 i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::form::XFormController >  xController;
//STRIP001 		xControllers->getByIndex(i) >>= xController;
//STRIP001 		Reference< ::com::sun::star::beans::XPropertySet >	xModelAsSet(xController->getModel(), UNO_QUERY);
//STRIP001 		::rtl::OUString aName = ::comphelper::getString(xModelAsSet->getPropertyValue(FM_PROP_NAME));
//STRIP001 
//STRIP001 		// Insert a new ::com::sun::star::form
//STRIP001 		FmFormItem* pFormItem = new FmFormItem(m_xORB,pParent, xController, aName);
//STRIP001 		Insert(pParent->GetChilds().end(), pFormItem);
//STRIP001 
//STRIP001 		// And now insert the filters for the form
//STRIP001 		FmXFormController* pController = NULL;
//STRIP001 		Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(pFormItem->GetController(),UNO_QUERY);
//STRIP001 		DBG_ASSERT(xTunnel.is(), "FmFilterAdapter::InsertElements : xTunnel is invalid!");
//STRIP001 		if(xTunnel.is())
//STRIP001 		{
//STRIP001 			pController = (FmXFormController*)xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId());
//STRIP001 		}
//STRIP001 		//	::comphelper::getImplementation(pController, Reference<XUnoTunnel>(pFormItem->GetController(),UNO_QUERY));
//STRIP001 
//STRIP001 		INT32 nPos = pController->getCurrentFilterPosition();
//STRIP001 		pFormItem->SetCurrentPosition(nPos);
//STRIP001 
//STRIP001 		String aTitle(SVX_RES(RID_STR_FILTER_FILTER_FOR));
//STRIP001 		const FmFilterRows& rRows = pController->getFilterRows();
//STRIP001 		for (FmFilterRows::const_iterator iter = rRows.begin(); iter != rRows.end(); ++iter)
//STRIP001 		{
//STRIP001 			const FmFilterRow& rRow = *iter;
//STRIP001 			// now add the filter rows
//STRIP001 			// One Row always exists
//STRIP001 
//STRIP001 			FmFilterItems* pFilterItems = new FmFilterItems(m_xORB,pFormItem, aTitle);
//STRIP001 			Insert(pFormItem->GetChilds().end(), pFilterItems);
//STRIP001 			for (FmFilterRow::const_iterator iter1 = rRow.begin(); iter1 != rRow.end(); ++iter1)
//STRIP001 			{
//STRIP001 				// insert new and conditons
//STRIP001 				::rtl::OUString aFieldName = getLabelName(Reference< ::com::sun::star::beans::XPropertySet > (Reference< ::com::sun::star::awt::XControl > ((*iter1).first, UNO_QUERY)->getModel(),UNO_QUERY));
//STRIP001 				FmFilterItem* pANDCondition = new FmFilterItem(m_xORB,pFilterItems, aFieldName, (*iter1).second, (*iter1).first);
//STRIP001 				Insert(pFilterItems->GetChilds().end(), pANDCondition);
//STRIP001 			}
//STRIP001 			// title for the next conditions
//STRIP001 			aTitle = SVX_RES(RID_STR_FILTER_FILTER_OR);
//STRIP001 		}
//STRIP001 
//STRIP001 		// now add dependent controllers
//STRIP001 		Reference< ::com::sun::star::container::XIndexAccess >	xControllerAsIndex(xController, UNO_QUERY);
//STRIP001 		Update(xControllerAsIndex, pFormItem);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFormItem* FmFilterModel::Find(const ::std::vector<FmFilterData*>& rItems, const Reference< ::com::sun::star::form::XFormController > & xController) const
//STRIP001 {
//STRIP001 	for (::std::vector<FmFilterData*>::const_iterator i = rItems.begin();
//STRIP001 		 i != rItems.end(); i++)
//STRIP001 	{
//STRIP001 		FmFormItem* pForm = PTR_CAST(FmFormItem,*i);
//STRIP001 		if (pForm)
//STRIP001 		{
//STRIP001 			if ((::com::sun::star::form::XFormController*)xController.get() == (::com::sun::star::form::XFormController*)pForm->GetController().get())
//STRIP001 				return pForm;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pForm = Find(pForm->GetChilds(), xController);
//STRIP001 				if (pForm)
//STRIP001 					return pForm;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFormItem* FmFilterModel::Find(const ::std::vector<FmFilterData*>& rItems, const Reference< ::com::sun::star::form::XForm >& xForm) const
//STRIP001 {
//STRIP001 	for (::std::vector<FmFilterData*>::const_iterator i = rItems.begin();
//STRIP001 		 i != rItems.end(); i++)
//STRIP001 	{
//STRIP001 		FmFormItem* pForm = PTR_CAST(FmFormItem,*i);
//STRIP001 		if (pForm)
//STRIP001 		{
//STRIP001 			if (xForm == pForm->GetController()->getModel())
//STRIP001 				return pForm;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pForm = Find(pForm->GetChilds(), xForm);
//STRIP001 				if (pForm)
//STRIP001 					return pForm;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::SetCurrentController(const Reference< ::com::sun::star::form::XFormController > & xCurrent)
//STRIP001 {
//STRIP001 	if ((::com::sun::star::form::XFormController*) xCurrent.get() == (::com::sun::star::form::XFormController*) m_xController.get())
//STRIP001 		return;
//STRIP001 
//STRIP001 	m_xController = xCurrent;
//STRIP001 
//STRIP001 	FmFormItem* pItem = Find(m_aChilds, xCurrent);
//STRIP001 	if (pItem)
//STRIP001 	{
//STRIP001 		if ( pItem->GetChilds().size() > pItem->GetCurrentPosition() )
//STRIP001 			SetCurrentItems( static_cast< FmFilterItems* >( pItem->GetChilds()[ pItem->GetCurrentPosition() ] ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::AppendFilterItems(FmFormItem* pFormItem)
//STRIP001 {
//STRIP001 	DBG_ASSERT(pFormItem, "AppendFilterItems(): no form item present");
//STRIP001 
//STRIP001 	FmFilterItems* pFilterItems = new FmFilterItems(m_xORB,pFormItem, ::rtl::OUString(SVX_RES(RID_STR_FILTER_FILTER_OR)));
//STRIP001 	// insert the condition behind the last filter items
//STRIP001 	::std::vector<FmFilterData*>::reverse_iterator iter;
//STRIP001 	for (iter = pFormItem->GetChilds().rbegin();
//STRIP001 		// link problems with operator ==
//STRIP001 		iter.base() != pFormItem->GetChilds().rend().base(); iter++)
//STRIP001 	{
//STRIP001 		if ((*iter)->ISA(FmFilterItems))
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	sal_Int32 nInsertPos = iter.base() - pFormItem->GetChilds().rend().base();
//STRIP001 	::std::vector<FmFilterData*>::iterator i = pFormItem->GetChilds().begin() + nInsertPos;
//STRIP001 
//STRIP001 	Insert(i, pFilterItems);
//STRIP001 
//STRIP001 	// do we need a new row
//STRIP001 	FmXFormController* pController = NULL;
//STRIP001 	Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(pFormItem->GetController(),UNO_QUERY);
//STRIP001 	DBG_ASSERT(xTunnel.is(), "FmFilterAdapter::InsertElements : xTunnel is invalid!");
//STRIP001 	if(xTunnel.is())
//STRIP001 	{
//STRIP001 		pController = (FmXFormController*)xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId());
//STRIP001 	}
//STRIP001 	//	::comphelper::getImplementation(pController, Reference<XUnoTunnel>(pFormItem->GetController(),UNO_QUERY));
//STRIP001 	FmFilterRows& rRows = pController->getFilterRows();
//STRIP001 
//STRIP001 	// determine the filter position
//STRIP001 	if (nInsertPos >= (sal_Int32)rRows.size())
//STRIP001 		rRows.push_back(FmFilterRow());
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Insert(const ::std::vector<FmFilterData*>::iterator& rPos, FmFilterData* pData)
//STRIP001 {
//STRIP001 	::std::vector<FmFilterData*>& rItems = pData->GetParent()->GetChilds();
//STRIP001 	sal_Int32 nPos = rPos == rItems.end() ? LIST_APPEND : rPos - rItems.begin();
//STRIP001 	rItems.insert(rPos, pData);
//STRIP001 
//STRIP001 	// UI benachrichtigen
//STRIP001 	FmFilterInsertedHint aInsertedHint(pData, nPos);
//STRIP001 	Broadcast( aInsertedHint );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Remove(FmFilterData* pData)
//STRIP001 {
//STRIP001 	FmParentData* pParent = pData->GetParent();
//STRIP001 	::std::vector<FmFilterData*>& rItems = pParent->GetChilds();
//STRIP001 
//STRIP001 	// erase the item from the model
//STRIP001 	::std::vector<FmFilterData*>::iterator i = find(rItems.begin(), rItems.end(), pData);
//STRIP001 	DBG_ASSERT(i != rItems.end(), "FmFilterModel::Remove(): unknown Item");
//STRIP001 	// position within the parent
//STRIP001 	sal_Int32 nPos = i - rItems.begin();
//STRIP001 	if (pData->ISA(FmFilterItems))
//STRIP001 	{
//STRIP001 		FmFormItem* pFormItem = (FmFormItem*)pParent;
//STRIP001 		FmXFormController* pController = NULL;
//STRIP001 		Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(pFormItem->GetController(),UNO_QUERY);
//STRIP001 		DBG_ASSERT(xTunnel.is(), "FmFilterAdapter::InsertElements : xTunnel is invalid!");
//STRIP001 		if(xTunnel.is())
//STRIP001 		{
//STRIP001 			pController = (FmXFormController*)xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId());
//STRIP001 		}
//STRIP001 		//	::comphelper::getImplementation(pController, Reference<XUnoTunnel>(pFormItem->GetController(),UNO_QUERY));
//STRIP001 		FmFilterRows& rRows = pController->getFilterRows();
//STRIP001 
//STRIP001 		// how many entries do we have
//STRIP001 		// it's the last row than we just empty it
//STRIP001 		if (nPos == (sal_Int32)(rRows.size() - 1))
//STRIP001 		{
//STRIP001 			// remove all childs and stay current
//STRIP001 			::std::vector<FmFilterData*>& rChilds = ((FmFilterItems*)pData)->GetChilds();
//STRIP001 			while (!rChilds.empty())
//STRIP001 			{
//STRIP001 				::std::vector<FmFilterData*>::iterator j = rChilds.end();
//STRIP001 				j--;
//STRIP001 
//STRIP001 				// we stay on the level so delete each item explizit to clean the controls
//STRIP001 				sal_Int32 nParentPos = j - rChilds.begin();
//STRIP001 				// EmptyText removes the filter
//STRIP001 				FmFilterItem* pFilterItem = PTR_CAST(FmFilterItem, *j);
//STRIP001 				m_pAdapter->setText(nParentPos, pFilterItem, ::rtl::OUString());
//STRIP001 				Remove(j, pFilterItem);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else // delete the row
//STRIP001 		{
//STRIP001 			// if the row is on the current position we have to away from that position.
//STRIP001 			// than we can delete it
//STRIP001 			if (nPos == pFormItem->GetCurrentPosition())
//STRIP001 			{
//STRIP001 				::std::vector<FmFilterData*>::iterator j = i;
//STRIP001 
//STRIP001 				// give a new current postion
//STRIP001 				if (nPos < (sal_Int32)(rRows.size() - 1))
//STRIP001 					// set it to the next row
//STRIP001 					++j;
//STRIP001 				else
//STRIP001 					// set it to the previous row
//STRIP001 					--j;
//STRIP001 
//STRIP001 				// if necessary we have the formItem for the current controller
//STRIP001 				// than we have to adjust the data displayed in the form
//STRIP001 				pFormItem->SetCurrentPosition(j - rItems.begin());
//STRIP001 				pController->setCurrentFilterPosition(j - rItems.begin());
//STRIP001 
//STRIP001 				// Keep the view consistent and force and new painting
//STRIP001 				FmFilterTextChangedHint aChangeHint(*j);
//STRIP001 				Broadcast( aChangeHint );
//STRIP001 			}
//STRIP001 
//STRIP001 			// now delete the entry
//STRIP001 			// before deleting we have to shift the current position of the form if necessary
//STRIP001 			if (nPos < pFormItem->GetCurrentPosition())
//STRIP001 			{
//STRIP001 				pFormItem->SetCurrentPosition(pFormItem->GetCurrentPosition() - 1);
//STRIP001 				pController->decrementCurrentFilterPosition();
//STRIP001 
//STRIP001 				// is it the first row, than the nex row has to recieve a different name
//STRIP001 				if (nPos == 0)
//STRIP001 				{
//STRIP001 					// ensure that the text labels are consistent
//STRIP001 					rItems[1]->SetText(String(SVX_RES(RID_STR_FILTER_FILTER_FOR)));
//STRIP001 					FmFilterTextChangedHint aChangeHint(rItems[1]);
//STRIP001 					Broadcast( aChangeHint );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// delete it
//STRIP001 			rRows.erase(rRows.begin() + nPos);
//STRIP001 
//STRIP001 			// and keep the controller consistent
//STRIP001 			DBG_ASSERT(rRows.size() != 0, "wrong row size");
//STRIP001 
//STRIP001 			// and remove it from the model
//STRIP001 			Remove(i, pData);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else // FormItems can not be deleted
//STRIP001 	{
//STRIP001 		FmFilterItem* pFilterItem = PTR_CAST(FmFilterItem, pData);
//STRIP001 
//STRIP001 		// if its the last condition remove the parent
//STRIP001 		if (rItems.size() == 1)
//STRIP001 			Remove(pFilterItem->GetParent());
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// find the position of the father within his father
//STRIP001 			::std::vector<FmFilterData*>& rItems = pData->GetParent()->GetParent()->GetChilds();
//STRIP001 			::std::vector<FmFilterData*>::iterator j = find(rItems.begin(), rItems.end(), pFilterItem->GetParent());
//STRIP001 			DBG_ASSERT(j != rItems.end(), "FmFilterModel::Remove(): unknown Item");
//STRIP001 			sal_Int32 nParentPos = j - rItems.begin();
//STRIP001 
//STRIP001 			// EmptyText removes the filter
//STRIP001 			m_pAdapter->setText(nParentPos, pFilterItem, ::rtl::OUString());
//STRIP001 			Remove(i, pData);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Remove(const ::std::vector<FmFilterData*>::iterator& rPos, FmFilterData* pData)
//STRIP001 {
//STRIP001 	::std::vector<FmFilterData*>& rItems = pData->GetParent()->GetChilds();
//STRIP001 	rItems.erase(rPos);
//STRIP001 
//STRIP001 	// UI benachrichtigen
//STRIP001 	FmFilterRemovedHint aRemoveHint( pData );
//STRIP001 	Broadcast( aRemoveHint );
//STRIP001 
//STRIP001 	delete pData;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmFilterModel::ValidateText(FmFilterItem* pItem, UniString& rText, UniString& rErrorMsg) const
//STRIP001 {
//STRIP001 	// check the input
//STRIP001 	Reference< XPropertySet >	xField(m_pAdapter->getField(pItem->GetTextComponent()));
//STRIP001 
//STRIP001 	OStaticDataAccessTools aStaticTools;
//STRIP001 	Reference< XConnection > xConnection(aStaticTools.getRowSetConnection(Reference< XRowSet > (m_xController->getModel(), UNO_QUERY)));
//STRIP001 	Reference< XNumberFormatsSupplier >  xFormatSupplier = aStaticTools.getNumberFormats(xConnection, sal_True);
//STRIP001 
//STRIP001 	Reference< XNumberFormatter >  xFormatter(m_xORB->createInstance(FM_NUMBER_FORMATTER), UNO_QUERY);
//STRIP001 	xFormatter->attachNumberFormatsSupplier(xFormatSupplier);
//STRIP001 
//STRIP001 	::rtl::OUString aErr, aTxt(rText);
//STRIP001 	::rtl::Reference< ISQLParseNode > xParseNode = predicateTree(aErr, aTxt, xFormatter, xField);
//STRIP001 	rErrorMsg = aErr;
//STRIP001 	rText = aTxt;
//STRIP001 	if (xParseNode.is())
//STRIP001 	{
//STRIP001 		::rtl::OUString aPreparedText;
//STRIP001 		::com::sun::star::lang::Locale aAppLocale = Application::GetSettings().GetUILocale();
//STRIP001 		xParseNode->parseNodeToPredicateStr(aPreparedText,
//STRIP001 								   xConnection->getMetaData(),
//STRIP001 								   xFormatter,
//STRIP001 								   xField,aAppLocale,'.',
//STRIP001 								   getParseContext());
//STRIP001 		rText = aPreparedText;
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::Append(FmFilterItems* pItems, FmFilterItem* pFilterItem)
//STRIP001 {
//STRIP001 	::std::vector<FmFilterData*>& rParentItems = pItems->GetParent()->GetChilds();
//STRIP001 	::std::vector<FmFilterData*>::iterator i = find(rParentItems.begin(), rParentItems.end(), pItems);
//STRIP001 	sal_Int32 nParentPos = i - rParentItems.begin();
//STRIP001 
//STRIP001 	Insert(pItems->GetChilds().end(), pFilterItem);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::SetText(FmFilterItem* pItem, const ::rtl::OUString& rText)
//STRIP001 {
//STRIP001 	::std::vector<FmFilterData*>& rItems = pItem->GetParent()->GetParent()->GetChilds();
//STRIP001 	::std::vector<FmFilterData*>::iterator i = find(rItems.begin(), rItems.end(), pItem->GetParent());
//STRIP001 	sal_Int32 nParentPos = i - rItems.begin();
//STRIP001 
//STRIP001 	m_pAdapter->setText(nParentPos, pItem, rText);
//STRIP001 
//STRIP001 	if (!rText)
//STRIP001 		Remove(pItem);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Change the text
//STRIP001 		pItem->SetText(rText);
//STRIP001 		FmFilterTextChangedHint aChangeHint(pItem);
//STRIP001 		Broadcast( aChangeHint );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::SetCurrentItems(FmFilterItems* pCurrent)
//STRIP001 {
//STRIP001 	if (m_pCurrentItems == pCurrent)
//STRIP001 		return;
//STRIP001 
//STRIP001 	// search for the condition
//STRIP001 	if (pCurrent)
//STRIP001 	{
//STRIP001 		FmFormItem* pFormItem = (FmFormItem*)pCurrent->GetParent();
//STRIP001 		::std::vector<FmFilterData*>& rItems = pFormItem->GetChilds();
//STRIP001 		::std::vector<FmFilterData*>::const_iterator i = find(rItems.begin(), rItems.end(), pCurrent);
//STRIP001 
//STRIP001 		if (i != rItems.end())
//STRIP001 		{
//STRIP001 			// determine the filter position
//STRIP001 			sal_Int32 nPos = i - rItems.begin();
//STRIP001 			FmXFormController* pController = NULL;
//STRIP001 			Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(pFormItem->GetController(),UNO_QUERY);
//STRIP001 			DBG_ASSERT(xTunnel.is(), "FmFilterAdapter::InsertElements : xTunnel is invalid!");
//STRIP001 			if(xTunnel.is())
//STRIP001 			{
//STRIP001 				pController = (FmXFormController*)xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId());
//STRIP001 			}
//STRIP001 			//	::comphelper::getImplementation(pController, Reference<XUnoTunnel>(pFormItem->GetController(),UNO_QUERY));
//STRIP001 			pController->setCurrentFilterPosition(nPos);
//STRIP001 			pFormItem->SetCurrentPosition(nPos);
//STRIP001 
//STRIP001 			if ((::com::sun::star::form::XFormController*)m_xController.get() != (::com::sun::star::form::XFormController*)pFormItem->GetController().get())
//STRIP001 				// calls SetCurrentItems again
//STRIP001 				SetCurrentController(pFormItem->GetController());
//STRIP001 			else
//STRIP001 				m_pCurrentItems = pCurrent;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			m_pCurrentItems = NULL;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		m_pCurrentItems = NULL;
//STRIP001 
//STRIP001 
//STRIP001 	// UI benachrichtigen
//STRIP001 	FmFilterCurrentChangedHint aHint;
//STRIP001 	Broadcast( aHint );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterModel::CheckIntegrity(FmParentData* pItem)
//STRIP001 {
//STRIP001 	// checks whether for each form there's one free level for input
//STRIP001 
//STRIP001 	::std::vector<FmFilterData*>& rItems = pItem->GetChilds();
//STRIP001 	sal_Bool bAppendLevel = sal_False;
//STRIP001 
//STRIP001 	for (::std::vector<FmFilterData*>::iterator i = rItems.begin();
//STRIP001 		 i != rItems.end(); i++)
//STRIP001 	{
//STRIP001 		FmFilterItems* pItems = PTR_CAST(FmFilterItems, *i);
//STRIP001 		if (pItems)
//STRIP001 		{
//STRIP001 			bAppendLevel = !pItems->GetChilds().empty();
//STRIP001 			continue;
//STRIP001 		}
//STRIP001 
//STRIP001 		FmFormItem* pFormItem = PTR_CAST(FmFormItem, *i);
//STRIP001 		if (pFormItem)
//STRIP001 		{
//STRIP001 			CheckIntegrity(pFormItem);
//STRIP001 			continue;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bAppendLevel)
//STRIP001 		AppendFilterItems((FmFormItem*)pItem);
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // class FmFilterItemsString
//STRIP001 //========================================================================
//STRIP001 class FmFilterItemsString : public SvLBoxString
//STRIP001 {
//STRIP001 public:
//STRIP001 	FmFilterItemsString( SvLBoxEntry* pEntry, sal_uInt16 nFlags,	const XubString& rStr )
//STRIP001 		:SvLBoxString(pEntry,nFlags,rStr){}
//STRIP001 
//STRIP001 	virtual void Paint(const Point& rPos, SvLBox& rDev, sal_uInt16 nFlags, SvLBoxEntry* pEntry);
//STRIP001 	virtual void InitViewData( SvLBox* pView,SvLBoxEntry* pEntry, SvViewDataItem* pViewData);
//STRIP001 };
//STRIP001 
//STRIP001 const int nxDBmp = 12;
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterItemsString::Paint(const Point& rPos, SvLBox& rDev, sal_uInt16 nFlags, SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	FmFilterItems* pRow = (FmFilterItems*)pEntry->GetUserData();
//STRIP001 	FmFormItem* pForm = (FmFormItem*)pRow->GetParent();
//STRIP001 	// current filter is significant painted
//STRIP001 	if (pForm->GetChilds()[pForm->GetCurrentPosition()] == pRow)
//STRIP001 	{
//STRIP001 		Color aLineColor(rDev.GetLineColor());
//STRIP001 		Rectangle aRect(rPos, GetSize(&rDev, pEntry ));
//STRIP001 		Point aFirst(rPos.X(), aRect.Bottom() - 6);
//STRIP001 		Point aSecond(aFirst.X() + 2, aFirst.Y() + 3);
//STRIP001 
//STRIP001 		rDev.SetLineColor(rDev.GetTextColor());
//STRIP001 		rDev.DrawLine(aFirst, aSecond);
//STRIP001 
//STRIP001 		aFirst = aSecond;
//STRIP001 		aFirst.X() += 1;
//STRIP001 		aSecond.X() += 6;
//STRIP001 		aSecond.Y() -= 5;
//STRIP001 
//STRIP001 		rDev.DrawLine(aFirst, aSecond);
//STRIP001 		rDev.SetLineColor( aLineColor );
//STRIP001 	}
//STRIP001 	rDev.DrawText( Point(rPos.X() + nxDBmp, rPos.Y()), GetText() );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterItemsString::InitViewData( SvLBox* pView,SvLBoxEntry* pEntry, SvViewDataItem* pViewData)
//STRIP001 {
//STRIP001 	if( !pViewData )
//STRIP001 		pViewData = pView->GetViewDataItem( pEntry, this );
//STRIP001 
//STRIP001 	Size aSize(pView->GetTextWidth(GetText()), pView->GetTextHeight());
//STRIP001 	aSize.Width() += nxDBmp;
//STRIP001 	pViewData->aSize = aSize;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // class FmFilterString
//STRIP001 //========================================================================
//STRIP001 class FmFilterString : public SvLBoxString
//STRIP001 {
//STRIP001 	UniString m_aName;
//STRIP001 
//STRIP001 public:
//STRIP001 	FmFilterString( SvLBoxEntry* pEntry, sal_uInt16 nFlags, const XubString& rStr, const UniString& aName)
//STRIP001 		:SvLBoxString(pEntry,nFlags,rStr)
//STRIP001 		,m_aName(aName)
//STRIP001 	{
//STRIP001 		m_aName.AppendAscii(": ");
//STRIP001 	}
//STRIP001 
//STRIP001 	virtual void Paint(const Point& rPos, SvLBox& rDev, sal_uInt16 nFlags, SvLBoxEntry* pEntry);
//STRIP001 	virtual void InitViewData( SvLBox* pView,SvLBoxEntry* pEntry, SvViewDataItem* pViewData);
//STRIP001 };
//STRIP001 
//STRIP001 const int nxD = 4;
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterString::InitViewData( SvLBox* pView,SvLBoxEntry* pEntry, SvViewDataItem* pViewData)
//STRIP001 {
//STRIP001 	if( !pViewData )
//STRIP001 		pViewData = pView->GetViewDataItem( pEntry, this );
//STRIP001 
//STRIP001 	Font aOldFont( pView->GetFont());
//STRIP001 	Font aFont( aOldFont );
//STRIP001 	aFont.SetWeight(WEIGHT_BOLD);
//STRIP001 	pView->SetFont( aFont );
//STRIP001 
//STRIP001 	Size aSize(pView->GetTextWidth(m_aName), pView->GetTextHeight());
//STRIP001 	pView->SetFont( aOldFont );
//STRIP001 	aSize.Width() += pView->GetTextWidth(GetText()) + nxD;
//STRIP001 	pViewData->aSize = aSize;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterString::Paint(const Point& rPos, SvLBox& rDev, sal_uInt16 nFlags, SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	Font aOldFont( rDev.GetFont());
//STRIP001 	Font aFont( aOldFont );
//STRIP001 	aFont.SetWeight(WEIGHT_BOLD);
//STRIP001 	rDev.SetFont( aFont );
//STRIP001 
//STRIP001 	Point aPos(rPos);
//STRIP001 	rDev.DrawText( aPos, m_aName );
//STRIP001 
//STRIP001 	// position for the second text
//STRIP001 	aPos.X() += rDev.GetTextWidth(m_aName) + nxD;
//STRIP001 	rDev.SetFont( aOldFont );
//STRIP001 	rDev.DrawText( aPos, GetText() );
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // class FmFilterNavigator
//STRIP001 //========================================================================
//STRIP001 FmFilterNavigator::FmFilterNavigator( Window* pParent )
//STRIP001 				  :SvTreeListBox( pParent, WB_HASBUTTONS|WB_HASLINES|WB_BORDER|WB_HASBUTTONSATROOT )
//STRIP001 				  ,m_aControlExchange(this)
//STRIP001 				  ,m_pEditingCurrently(NULL)
//STRIP001 {
//STRIP001 	SetHelpId( HID_FILTER_NAVIGATOR );
//STRIP001 
//STRIP001 	{
//STRIP001 		{
//STRIP001 			ImageList aNavigatorImages( SVX_RES( RID_SVXIMGLIST_FMEXPL ) );
//STRIP001 			SetNodeBitmaps(
//STRIP001 				aNavigatorImages.GetImage( RID_SVXIMG_COLLAPSEDNODE ),
//STRIP001 				aNavigatorImages.GetImage( RID_SVXIMG_EXPANDEDNODE ),
//STRIP001 				BMP_COLOR_NORMAL
//STRIP001 			);
//STRIP001 		}
//STRIP001 		{
//STRIP001 			ImageList aNavigatorImages( SVX_RES( RID_SVXIMGLIST_FMEXPL_HC ) );
//STRIP001 			SetNodeBitmaps(
//STRIP001 				aNavigatorImages.GetImage( RID_SVXIMG_COLLAPSEDNODE ),
//STRIP001 				aNavigatorImages.GetImage( RID_SVXIMG_EXPANDEDNODE ),
//STRIP001 				BMP_COLOR_HIGHCONTRAST
//STRIP001 			);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	m_pModel = new FmFilterModel(::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001 	StartListening( *m_pModel );
//STRIP001 
//STRIP001 	EnableInplaceEditing( sal_True );
//STRIP001 	SetSelectionMode(MULTIPLE_SELECTION);
//STRIP001 
//STRIP001 	SetDragDropMode(0xFFFF);
//STRIP001 
//STRIP001 	m_aDropActionTimer.SetTimeoutHdl(LINK(this, FmFilterNavigator, OnDropActionTimer));
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterNavigator::~FmFilterNavigator()
//STRIP001 {
//STRIP001 	EndListening( *m_pModel );
//STRIP001 	delete m_pModel;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::Clear()
//STRIP001 {
//STRIP001 	m_pModel->Clear();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::Update(const Reference< ::com::sun::star::container::XIndexAccess > & xControllers, const Reference< ::com::sun::star::form::XFormController > & xCurrent)
//STRIP001 {
//STRIP001 	if (xCurrent == m_pModel->GetCurrentController())
//STRIP001 		return;
//STRIP001 
//STRIP001 	m_pModel->Update(xControllers, xCurrent);
//STRIP001 
//STRIP001 	// expand the filters for the current controller
//STRIP001 	SvLBoxEntry* pEntry = FindEntry(m_pModel->GetCurrentForm());
//STRIP001 	if (pEntry && !IsExpanded(pEntry))
//STRIP001 	{
//STRIP001 		SelectAll(sal_False);
//STRIP001 
//STRIP001 		if (!IsExpanded(pEntry))
//STRIP001 			Expand(pEntry);
//STRIP001 
//STRIP001 		pEntry = FindEntry(m_pModel->GetCurrentItems());
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			if (!IsExpanded(pEntry))
//STRIP001 				Expand(pEntry);
//STRIP001 			Select(pEntry, sal_True);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmFilterNavigator::EditingEntry( SvLBoxEntry* pEntry, Selection& rSelection )
//STRIP001 {
//STRIP001 	m_pEditingCurrently = pEntry;
//STRIP001 	if (!SvTreeListBox::EditingEntry( pEntry, rSelection ))
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	return pEntry && ((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItem);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmFilterNavigator::EditedEntry( SvLBoxEntry* pEntry, const XubString& rNewText )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pEntry == m_pEditingCurrently, "FmFilterNavigator::EditedEntry: suspicious entry!");
//STRIP001 	m_pEditingCurrently = NULL;
//STRIP001 
//STRIP001 	if (EditingCanceled())
//STRIP001 		return sal_True;
//STRIP001 
//STRIP001 	DBG_ASSERT(((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItem),
//STRIP001 					"FmFilterNavigator::EditedEntry() wrong entry");
//STRIP001 
//STRIP001 	UniString aText(rNewText);
//STRIP001 	aText.EraseTrailingChars();
//STRIP001 	aText.EraseLeadingChars();
//STRIP001 	if (aText.Len() == 0)
//STRIP001 	{
//STRIP001 		// deleting the entry asynchron
//STRIP001 		sal_uInt32 nEvent;
//STRIP001 		PostUserEvent(nEvent, LINK(this, FmFilterNavigator, OnRemove), pEntry);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		UniString aErrorMsg;
//STRIP001 
//STRIP001 		if (m_pModel->ValidateText((FmFilterItem*)pEntry->GetUserData(), aText, aErrorMsg))
//STRIP001 		{
//STRIP001 			GrabFocus();
//STRIP001 			// this will set the text at the FmFilterItem, as well as update any filter controls
//STRIP001 			// which are connected to this particular entry
//STRIP001 			m_pModel->SetText( static_cast< FmFilterItem* >( pEntry->GetUserData() ), aText );
//STRIP001 
//STRIP001 			SetCursor( pEntry, sal_True );
//STRIP001 			SetEntryText( pEntry, aText );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// display the error and return sal_False
//STRIP001 
//STRIP001 			SQLContext aError;
//STRIP001 			aError.Message = String(SVX_RES(RID_STR_SYNTAXERROR));
//STRIP001 			aError.Details = aErrorMsg;
//STRIP001 			displayException(aError, this);
//STRIP001 
//STRIP001 			return sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmFilterNavigator, OnRemove, SvLBoxEntry*, pEntry )
//STRIP001 {
//STRIP001 	// now remove the entry
//STRIP001 	m_pModel->Remove((FmFilterData*) pEntry->GetUserData());
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmFilterNavigator, OnDropActionTimer, void*, EMPTYARG )
//STRIP001 {
//STRIP001 	if (--m_aTimerCounter > 0)
//STRIP001 		return 0L;
//STRIP001 
//STRIP001 	if (m_aDropActionType == DA_EXPANDNODE)
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pToExpand = GetEntry(m_aTimerTriggered);
//STRIP001 		if (pToExpand && (GetChildCount(pToExpand) > 0) &&	!IsExpanded(pToExpand))
//STRIP001 			// tja, eigentlich muesste ich noch testen, ob die Node nicht schon expandiert ist, aber ich
//STRIP001 			// habe dazu weder in den Basisklassen noch im Model eine Methode gefunden ...
//STRIP001 			// aber ich denke, die BK sollte es auch so vertragen
//STRIP001 			Expand(pToExpand);
//STRIP001 
//STRIP001 		// nach dem Expand habe ich im Gegensatz zum Scrollen natuerlich nix mehr zu tun
//STRIP001 		m_aDropActionTimer.Stop();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		switch (m_aDropActionType)
//STRIP001 		{
//STRIP001 			case DA_SCROLLUP :
//STRIP001 				ScrollOutputArea(1);
//STRIP001 				break;
//STRIP001 			case DA_SCROLLDOWN :
//STRIP001 				ScrollOutputArea(-1);
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		m_aTimerCounter = DROP_ACTION_TIMER_SCROLL_TICKS;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Int8 FmFilterNavigator::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	Point aDropPos = rEvt.maPosPixel;
//STRIP001 
//STRIP001 	// kuemmern wir uns erst mal um moeglich DropActions (Scrollen und Aufklappen)
//STRIP001 	if (rEvt.mbLeaving)
//STRIP001 	{
//STRIP001 		if (m_aDropActionTimer.IsActive())
//STRIP001 			m_aDropActionTimer.Stop();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		sal_Bool bNeedTrigger = sal_False;
//STRIP001 		// auf dem ersten Eintrag ?
//STRIP001 		if ((aDropPos.Y() >= 0) && (aDropPos.Y() < GetEntryHeight()))
//STRIP001 		{
//STRIP001 			m_aDropActionType = DA_SCROLLUP;
//STRIP001 			bNeedTrigger = sal_True;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// auf dem letzten (bzw. in dem Bereich, den ein Eintrag einnehmen wuerde, wenn er unten genau buendig
//STRIP001 			// abschliessen wuerde) ?
//STRIP001 			if ((aDropPos.Y() < GetSizePixel().Height()) && (aDropPos.Y() >= GetSizePixel().Height() - GetEntryHeight()))
//STRIP001 			{
//STRIP001 				m_aDropActionType = DA_SCROLLDOWN;
//STRIP001 				bNeedTrigger = sal_True;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{	// auf einem Entry mit Childs, der nicht aufgeklappt ist ?
//STRIP001 				SvLBoxEntry* pDropppedOn = GetEntry(aDropPos);
//STRIP001 				if (pDropppedOn && (GetChildCount(pDropppedOn) > 0) && !IsExpanded(pDropppedOn))
//STRIP001 				{
//STRIP001 					// -> aufklappen
//STRIP001 					m_aDropActionType = DA_EXPANDNODE;
//STRIP001 					bNeedTrigger = sal_True;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (bNeedTrigger && (m_aTimerTriggered != aDropPos))
//STRIP001 		{
//STRIP001 			// neu anfangen zu zaehlen
//STRIP001 			m_aTimerCounter = DROP_ACTION_TIMER_INITIAL_TICKS;
//STRIP001 			// die Pos merken, da ich auch QueryDrops bekomme, wenn sich die Maus gar nicht bewegt hat
//STRIP001 			m_aTimerTriggered = aDropPos;
//STRIP001 			// und den Timer los
//STRIP001 			if (!m_aDropActionTimer.IsActive()) // gibt es den Timer schon ?
//STRIP001 			{
//STRIP001 				m_aDropActionTimer.SetTimeout(DROP_ACTION_TIMER_TICK_BASE);
//STRIP001 				m_aDropActionTimer.Start();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (!bNeedTrigger)
//STRIP001 			m_aDropActionTimer.Stop();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	// Hat das Object das richtige Format?
//STRIP001 	if (!m_aControlExchange.isDragSource())
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if (!m_aControlExchange->hasFormat(GetDataFlavorExVector()))
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	// do we conain the formitem?
//STRIP001 	if (!FindEntry(m_aControlExchange->getFormItem()))
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	SvLBoxEntry* pDropTarget = GetEntry(aDropPos);
//STRIP001 	if (!pDropTarget)
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	FmFilterData* pData = (FmFilterData*)pDropTarget->GetUserData();
//STRIP001 	FmFormItem* pForm = NULL;
//STRIP001 	if (pData->ISA(FmFilterItem))
//STRIP001 	{
//STRIP001 		pForm = PTR_CAST(FmFormItem,pData->GetParent()->GetParent());
//STRIP001 		if (pForm != m_aControlExchange->getFormItem())
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 	}
//STRIP001 	else if (pData->ISA(FmFilterItems))
//STRIP001 	{
//STRIP001 		pForm = PTR_CAST(FmFormItem,pData->GetParent());
//STRIP001 		if (pForm != m_aControlExchange->getFormItem())
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	return rEvt.mnAction;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 namespace 
//STRIP001 {
//STRIP001 	FmFilterItems* getTargetItems(SvLBoxEntry* _pTarget)
//STRIP001 	{
//STRIP001 		FmFilterData*	pData = static_cast<FmFilterData*>(_pTarget->GetUserData());
//STRIP001 		FmFilterItems*	pTargetItems = pData->ISA(FmFilterItems) 
//STRIP001 										? 
//STRIP001 										PTR_CAST(FmFilterItems,pData)
//STRIP001 										: 
//STRIP001 									PTR_CAST(FmFilterItems,pData->GetParent());
//STRIP001 		return pTargetItems;
//STRIP001 	}
//STRIP001 }	
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Int8 FmFilterNavigator::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	// ware schlecht, wenn nach dem Droppen noch gescrollt wird ...
//STRIP001 	if (m_aDropActionTimer.IsActive())
//STRIP001 		m_aDropActionTimer.Stop();
//STRIP001 
//STRIP001 	// Format-Ueberpruefung
//STRIP001 	if (!m_aControlExchange.isDragSource())
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	// das Ziel des Drop sowie einige Daten darueber
//STRIP001 	Point aDropPos = rEvt.maPosPixel;
//STRIP001 	SvLBoxEntry* pDropTarget = GetEntry( aDropPos );
//STRIP001 	if (!pDropTarget)
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	// search the container where to add the items
//STRIP001 	FmFilterItems*	pTargetItems = getTargetItems(pDropTarget);
//STRIP001 	SelectAll(sal_False);
//STRIP001 	SvLBoxEntry* pEntry = FindEntry(pTargetItems);
//STRIP001 	Select(pEntry, sal_True);
//STRIP001 	SetCurEntry(pEntry);
//STRIP001 
//STRIP001 	insertFilterItem(m_aControlExchange->getDraggedEntries(),pTargetItems,DND_ACTION_COPY == rEvt.mnAction);
//STRIP001 	
//STRIP001 	return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::InitEntry(SvLBoxEntry* pEntry,
//STRIP001 								  const XubString& rStr,
//STRIP001 								  const Image& rImg1,
//STRIP001 								  const Image& rImg2)
//STRIP001 {
//STRIP001 	SvTreeListBox::InitEntry( pEntry, rStr, rImg1, rImg2 );
//STRIP001 	SvLBoxString* pString = NULL;
//STRIP001 
//STRIP001 	if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItem))
//STRIP001 		pString = new FmFilterString(pEntry, 0, rStr, ((FmFilterItem*)pEntry->GetUserData())->GetFieldName());
//STRIP001 	else if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItems))
//STRIP001 		pString = new FmFilterItemsString(pEntry, 0, rStr );
//STRIP001 
//STRIP001 	if (pString)
//STRIP001 		pEntry->ReplaceItem( pString, 1 );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmFilterNavigator::Select( SvLBoxEntry* pEntry, sal_Bool bSelect )
//STRIP001 {
//STRIP001 	if (bSelect == IsSelected(pEntry))	// das passiert manchmal, ich glaube, die Basisklasse geht zu sehr auf Nummer sicher ;)
//STRIP001 		return sal_True;
//STRIP001 
//STRIP001 	if (SvTreeListBox::Select(pEntry, bSelect))
//STRIP001 	{
//STRIP001 		if (bSelect)
//STRIP001 		{
//STRIP001 			FmFormItem* pFormItem = NULL;
//STRIP001 			if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItem))
//STRIP001 				pFormItem = (FmFormItem*)((FmFilterItem*)pEntry->GetUserData())->GetParent()->GetParent();
//STRIP001 			else if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItems))
//STRIP001 				pFormItem = (FmFormItem*)((FmFilterItem*)pEntry->GetUserData())->GetParent()->GetParent();
//STRIP001 			else if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFormItem))
//STRIP001 				pFormItem = (FmFormItem*)pEntry->GetUserData();
//STRIP001 
//STRIP001 			if (pFormItem)
//STRIP001 			{
//STRIP001 				// will the controller be exchanged?
//STRIP001 				if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItem))
//STRIP001 					m_pModel->SetCurrentItems((FmFilterItems*)((FmFilterItem*)pEntry->GetUserData())->GetParent());
//STRIP001 				else if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFilterItems))
//STRIP001 					m_pModel->SetCurrentItems((FmFilterItems*)pEntry->GetUserData());
//STRIP001 				else if (((FmFilterData*)pEntry->GetUserData())->ISA(FmFormItem))
//STRIP001 					m_pModel->SetCurrentController(((FmFormItem*)pEntry->GetUserData())->GetController());
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	if (rHint.ISA(FmFilterInsertedHint))
//STRIP001 	{
//STRIP001 		FmFilterInsertedHint* pHint = (FmFilterInsertedHint*)&rHint;
//STRIP001 		Insert(pHint->GetData(), pHint->GetPos());
//STRIP001 	}
//STRIP001 	else if( rHint.ISA(FilterClearingHint) )
//STRIP001 	{
//STRIP001 		SvTreeListBox::Clear();
//STRIP001 	}
//STRIP001 	else if( rHint.ISA(FmFilterRemovedHint) )
//STRIP001 	{
//STRIP001 		FmFilterRemovedHint* pHint = (FmFilterRemovedHint*)&rHint;
//STRIP001 		Remove(pHint->GetData());
//STRIP001 	}
//STRIP001 	else if( rHint.ISA(FmFilterTextChangedHint) )
//STRIP001 	{
//STRIP001 		FmFilterTextChangedHint* pHint = (FmFilterTextChangedHint*)&rHint;
//STRIP001 		SvLBoxEntry* pEntry = FindEntry(pHint->GetData());
//STRIP001 		if (pEntry)
//STRIP001 			SetEntryText( pEntry, pHint->GetData()->GetText());
//STRIP001 	}
//STRIP001 	else if( rHint.ISA(FmFilterCurrentChangedHint) )
//STRIP001 	{
//STRIP001 		// invalidate the entries
//STRIP001 		for (SvLBoxEntry* pEntry = First(); pEntry != NULL;
//STRIP001 			 pEntry = Next(pEntry))
//STRIP001 			GetModel()->InvalidateEntry( pEntry );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 SvLBoxEntry* FmFilterNavigator::FindEntry(FmFilterData* pItem)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = NULL;
//STRIP001 	if (pItem)
//STRIP001 	{
//STRIP001 		for (pEntry = First(); pEntry != NULL; pEntry = Next( pEntry ))
//STRIP001 		{
//STRIP001 			FmFilterData* pEntryItem = (FmFilterData*)pEntry->GetUserData();
//STRIP001 			if (pEntryItem == pItem)
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::Insert(FmFilterData* pItem, sal_Int32 nPos)
//STRIP001 {
//STRIP001 	FmParentData* pParent = pItem->GetParent() ? pItem->GetParent() : GetFilterModel();
//STRIP001 
//STRIP001 	// insert the item
//STRIP001 	SvLBoxEntry* pParentEntry = FindEntry(pParent);
//STRIP001 	SvLBoxEntry* pNewEntry = InsertEntry(pItem->GetText(), pItem->GetImage(), pItem->GetImage(), pParentEntry, sal_False, nPos, pItem );
//STRIP001 	if ( pNewEntry )
//STRIP001 	{
//STRIP001 		SetExpandedEntryBmp( pNewEntry, pItem->GetImage( BMP_COLOR_HIGHCONTRAST ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 		SetCollapsedEntryBmp( pNewEntry, pItem->GetImage( BMP_COLOR_HIGHCONTRAST ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::Remove(FmFilterData* pItem)
//STRIP001 {
//STRIP001 	// der Entry zu den Daten
//STRIP001 	SvLBoxEntry* pEntry = FindEntry(pItem);
//STRIP001 
//STRIP001 	if (pEntry == m_pEditingCurrently)
//STRIP001 		// cancel editing
//STRIP001 		EndEditing(sal_True);
//STRIP001 
//STRIP001 	if (pEntry)
//STRIP001 		GetModel()->Remove( pEntry );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 FmFormItem* FmFilterNavigator::getSelectedFilterItems(::std::vector<FmFilterItem*>& _rItemList)
//STRIP001 {
//STRIP001 	// be sure that the data is only used within only one form!
//STRIP001 	FmFormItem* pFirstItem = NULL;
//STRIP001 
//STRIP001 	sal_Bool bHandled = sal_True;
//STRIP001 	sal_Bool bFoundSomething = sal_False;
//STRIP001 	for (SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 		 bHandled && pEntry != NULL;
//STRIP001 		 pEntry = NextSelected(pEntry))
//STRIP001 	{
//STRIP001 		FmFilterItem* pFilter = PTR_CAST(FmFilterItem, (FmFilterData*)pEntry->GetUserData());
//STRIP001 		if (pFilter)
//STRIP001 		{
//STRIP001 			FmFormItem* pForm = PTR_CAST(FmFormItem,pFilter->GetParent()->GetParent());
//STRIP001 			if (!pForm)
//STRIP001 				bHandled = sal_False;
//STRIP001 			else if (!pFirstItem)
//STRIP001 				pFirstItem = pForm;
//STRIP001 			else if (pFirstItem != pForm)
//STRIP001 				bHandled = sal_False;
//STRIP001 
//STRIP001 			if (bHandled)
//STRIP001 			{
//STRIP001 				_rItemList.push_back(pFilter);
//STRIP001 				bFoundSomething = sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( !bHandled || !bFoundSomething )
//STRIP001 		pFirstItem = NULL;
//STRIP001 	return pFirstItem;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::insertFilterItem(const ::std::vector<FmFilterItem*>& _rFilterList,FmFilterItems* _pTargetItems,sal_Bool _bCopy)
//STRIP001 {
//STRIP001 	::std::vector<FmFilterItem*>::const_iterator aEnd = _rFilterList.end();
//STRIP001 	for (::std::vector<FmFilterItem*>::const_iterator i = _rFilterList.begin(); i != aEnd; ++i)
//STRIP001 	{
//STRIP001 		if ((*i)->GetParent() == _pTargetItems)
//STRIP001 			continue;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			FmFilterItem* pFilterItem = _pTargetItems->Find((*i)->GetTextComponent());
//STRIP001 			String aText = (*i)->GetText();
//STRIP001 			if ( !pFilterItem )
//STRIP001 			{
//STRIP001 				pFilterItem = new FmFilterItem(m_pModel->getORB(),_pTargetItems, (*i)->GetFieldName(), aText, (*i)->GetTextComponent());
//STRIP001 				m_pModel->Append(_pTargetItems, pFilterItem);
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( !_bCopy )
//STRIP001 				m_pModel->Remove(*i);
//STRIP001 
//STRIP001 			// now set the text for the new dragged item
//STRIP001 			m_pModel->SetText(pFilterItem, aText);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	m_pModel->CheckIntegrity((FmFormItem*)_pTargetItems->GetParent());
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::StartDrag( sal_Int8 _nAction, const Point& _rPosPixel )
//STRIP001 {
//STRIP001 	EndSelection();
//STRIP001 
//STRIP001 	// be sure that the data is only used within a only one form!
//STRIP001 	m_aControlExchange.prepareDrag();
//STRIP001 
//STRIP001 	::std::vector<FmFilterItem*> aItemList;
//STRIP001 	if ( FmFormItem* pFirstItem = getSelectedFilterItems(aItemList) )
//STRIP001 	{
//STRIP001 		m_aControlExchange->setDraggedEntries(aItemList);
//STRIP001 		m_aControlExchange->setFormItem(pFirstItem);
//STRIP001 		m_aControlExchange.startDrag( DND_ACTION_COPYMOVE );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::Command( const CommandEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Bool bHandled = sal_False;
//STRIP001 	switch (rEvt.GetCommand())
//STRIP001 	{
//STRIP001 		case COMMAND_CONTEXTMENU:
//STRIP001 		{
//STRIP001 			// die Stelle, an der geklickt wurde
//STRIP001 			Point aWhere;
//STRIP001 			SvLBoxEntry* pClicked = NULL;
//STRIP001 			if (rEvt.IsMouseEvent())
//STRIP001 			{
//STRIP001 				aWhere = rEvt.GetMousePosPixel();
//STRIP001 				pClicked = GetEntry(aWhere);
//STRIP001 				if (pClicked == NULL)
//STRIP001 					break;
//STRIP001 
//STRIP001 				if (!IsSelected(pClicked))
//STRIP001 				{
//STRIP001 					SelectAll(sal_False);
//STRIP001 					Select(pClicked, sal_True);
//STRIP001 					SetCurEntry(pClicked);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pClicked = GetCurEntry();
//STRIP001 				if (!pClicked)
//STRIP001 					break;
//STRIP001 				aWhere = GetEntryPos(pClicked);
//STRIP001 			}
//STRIP001 
//STRIP001 			::std::vector<FmFilterData*> aSelectList;
//STRIP001 			for (SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 				 pEntry != NULL;
//STRIP001 				 pEntry = NextSelected(pEntry))
//STRIP001 			{
//STRIP001 				// don't delete forms
//STRIP001 				FmFormItem* pForm = PTR_CAST(FmFormItem, (FmFilterData*)pEntry->GetUserData());
//STRIP001 				if (!pForm)
//STRIP001 					aSelectList.push_back((FmFilterData*)pEntry->GetUserData());
//STRIP001 			}
//STRIP001 			if (aSelectList.size() == 1)
//STRIP001 			{
//STRIP001 				// don't delete the only empty row of a form
//STRIP001 				FmFilterItems* pFilterItems = PTR_CAST(FmFilterItems, aSelectList[0]);
//STRIP001 				if (pFilterItems && pFilterItems->GetChilds().empty()
//STRIP001 					&& pFilterItems->GetParent()->GetChilds().size() == 1)
//STRIP001 					aSelectList.clear();
//STRIP001 			}
//STRIP001 
//STRIP001 			PopupMenu aContextMenu(SVX_RES(RID_FM_FILTER_MENU));
//STRIP001 
//STRIP001 			// every condition could be deleted except the first one if its the only one
//STRIP001 			aContextMenu.EnableItem( SID_FM_DELETE, !aSelectList.empty() );
//STRIP001 
//STRIP001 			//
//STRIP001 			sal_Bool bEdit = PTR_CAST(FmFilterItem, (FmFilterData*)pClicked->GetUserData()) != NULL &&
//STRIP001 				IsSelected(pClicked) && GetSelectionCount() == 1;
//STRIP001 
//STRIP001 			aContextMenu.EnableItem( SID_FM_FILTER_EDIT,
//STRIP001 				bEdit );
//STRIP001 			aContextMenu.EnableItem( SID_FM_FILTER_IS_NULL,
//STRIP001 				bEdit );
//STRIP001 			aContextMenu.EnableItem( SID_FM_FILTER_IS_NOT_NULL,
//STRIP001 				bEdit );
//STRIP001 
//STRIP001 			aContextMenu.RemoveDisabledEntries(sal_True, sal_True);
//STRIP001 			sal_uInt16 nSlotId = aContextMenu.Execute( this, aWhere );
//STRIP001 			switch( nSlotId )
//STRIP001 			{
//STRIP001 				case SID_FM_FILTER_EDIT:
//STRIP001 				{
//STRIP001 					EditEntry( pClicked );
//STRIP001 				}	break;
//STRIP001 				case SID_FM_FILTER_IS_NULL:
//STRIP001 				case SID_FM_FILTER_IS_NOT_NULL:
//STRIP001 				{
//STRIP001 					UniString aErrorMsg;
//STRIP001 					UniString aText;
//STRIP001 					if (nSlotId == SID_FM_FILTER_IS_NULL)
//STRIP001 						aText.AssignAscii("IS NULL");
//STRIP001 					else
//STRIP001 						aText.AssignAscii("IS NOT NULL");
//STRIP001 
//STRIP001 					m_pModel->ValidateText((FmFilterItem*)pClicked->GetUserData(),
//STRIP001 											aText, aErrorMsg);
//STRIP001 					m_pModel->SetText((FmFilterItem*)pClicked->GetUserData(), aText);
//STRIP001 				}	break;
//STRIP001 				case SID_FM_DELETE:
//STRIP001 				{
//STRIP001 					DeleteSelection();
//STRIP001 				}	break;
//STRIP001 			}
//STRIP001 			bHandled = sal_True;
//STRIP001 		} break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bHandled)
//STRIP001 		SvTreeListBox::Command( rEvt );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 SvLBoxEntry* FmFilterNavigator::getNextEntry(SvLBoxEntry* _pStartWith)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = _pStartWith ? _pStartWith : LastSelected();
//STRIP001 	pEntry = Next(pEntry);
//STRIP001 	// we need the next filter entry
//STRIP001 	while( pEntry && GetChildCount( pEntry ) == 0 && pEntry != Last() )
//STRIP001 		pEntry = Next(pEntry);
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 SvLBoxEntry* FmFilterNavigator::getPrevEntry(SvLBoxEntry* _pStartWith)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = _pStartWith ? _pStartWith : FirstSelected();
//STRIP001 	pEntry = Prev(pEntry);
//STRIP001 	// check if the previous entry is a filter, if so get the next prev
//STRIP001 	if ( pEntry && GetChildCount( pEntry ) != 0 )
//STRIP001 	{
//STRIP001 		pEntry = Prev(pEntry);
//STRIP001 		// if the entry is still no leaf return
//STRIP001 		if ( pEntry && GetChildCount( pEntry ) != 0 )
//STRIP001 			pEntry = NULL;
//STRIP001 	}
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	const KeyCode&  rKeyCode = rKEvt.GetKeyCode();
//STRIP001 	if (	rKeyCode.IsMod1() 
//STRIP001 		&&	rKeyCode.IsMod2()
//STRIP001 		&& !rKeyCode.IsShift()
//STRIP001 		&& ( rKeyCode.GetCode() == KEY_UP || rKeyCode.GetCode() == KEY_DOWN )
//STRIP001 		)
//STRIP001 	{
//STRIP001 		::std::vector<FmFilterItem*> aItemList;
//STRIP001 		if ( FmFormItem* pFirstItem = getSelectedFilterItems(aItemList) )
//STRIP001 		{
//STRIP001 			::std::mem_fun1_t<SvLBoxEntry*,FmFilterNavigator,SvLBoxEntry*> aGetEntry = ::std::mem_fun1(&FmFilterNavigator::getNextEntry);
//STRIP001 			if ( rKeyCode.GetCode() == KEY_UP )
//STRIP001 				aGetEntry = ::std::mem_fun1(&FmFilterNavigator::getPrevEntry);
//STRIP001 
//STRIP001 			SvLBoxEntry* pTarget = aGetEntry(this,NULL);
//STRIP001 
//STRIP001 			if ( pTarget )
//STRIP001 			{
//STRIP001 				FmFilterItems* pTargetItems = getTargetItems(pTarget);
//STRIP001 				if ( pTargetItems )
//STRIP001 				{
//STRIP001 					::std::vector<FmFilterItem*>::const_iterator aEnd = aItemList.end();
//STRIP001 					sal_Bool bNextTargetItem = sal_True;
//STRIP001 					while ( bNextTargetItem )
//STRIP001 					{
//STRIP001 						::std::vector<FmFilterItem*>::const_iterator i = aItemList.begin();
//STRIP001 						for (; i != aEnd; ++i)
//STRIP001 						{
//STRIP001 							if ( (*i)->GetParent() == pTargetItems )
//STRIP001 							{
//STRIP001 								pTarget = aGetEntry(this,pTarget);
//STRIP001 								if ( !pTarget )
//STRIP001 									return;
//STRIP001 								pTargetItems = getTargetItems(pTarget);
//STRIP001 								break;
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								FmFilterItem* pFilterItem = pTargetItems->Find((*i)->GetTextComponent());
//STRIP001 								// we found the text component so jump above
//STRIP001 								if ( pFilterItem )
//STRIP001 								{
//STRIP001 									pTarget = aGetEntry(this,pTarget);
//STRIP001 									if ( !pTarget )
//STRIP001 										return;
//STRIP001 									pTargetItems = getTargetItems(pTarget);
//STRIP001 									break;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						bNextTargetItem = i != aEnd && pTargetItems;
//STRIP001 					}
//STRIP001 					if ( pTargetItems )
//STRIP001 					{
//STRIP001 						insertFilterItem(aItemList,pTargetItems);
//STRIP001 						return;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (rKeyCode.GetCode() == KEY_DELETE && !rKeyCode.GetModifier())
//STRIP001 	{
//STRIP001 		if (!IsSelected(First()) || GetEntryCount() > 1)
//STRIP001 			DeleteSelection();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	SvTreeListBox::KeyInput(rKEvt);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------------
//STRIP001 void FmFilterNavigator::DeleteSelection()
//STRIP001 {
//STRIP001 	// to avoid the deletion of an entry twice (e.g. deletion of a parent and afterward
//STRIP001 	// the deletion of it's child, i have to shrink the selecton list
//STRIP001 	::std::vector<SvLBoxEntry*> aEntryList;
//STRIP001 	for (SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 		 pEntry != NULL;
//STRIP001 		 pEntry = NextSelected(pEntry))
//STRIP001 	{
//STRIP001 		FmFilterItem* pFilterItem = PTR_CAST(FmFilterItem, (FmFilterData*)pEntry->GetUserData());
//STRIP001 		if (pFilterItem && IsSelected(GetParent(pEntry)))
//STRIP001 			continue;
//STRIP001 
//STRIP001 		FmFormItem* pForm = PTR_CAST(FmFormItem, (FmFilterData*)pEntry->GetUserData());
//STRIP001 		if (!pForm)
//STRIP001 			aEntryList.push_back(pEntry);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Remove the selection
//STRIP001 	SelectAll(FALSE);
//STRIP001 
//STRIP001 	for (::std::vector<SvLBoxEntry*>::reverse_iterator i = aEntryList.rbegin();
//STRIP001 		// link problems with operator ==
//STRIP001 		i.base() != aEntryList.rend().base(); i++)
//STRIP001 	{
//STRIP001 		m_pModel->Remove((FmFilterData*)(*i)->GetUserData());
//STRIP001 	}
//STRIP001 
//STRIP001 	// now check if we need to insert new items
//STRIP001 	m_pModel->CheckIntegrity(m_pModel);
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // class FmFilterNavigatorWin
//STRIP001 //========================================================================
//STRIP001 FmFilterNavigatorWin::FmFilterNavigatorWin( SfxBindings *pBindings, SfxChildWindow *pMgr,
//STRIP001 							  Window* pParent )
//STRIP001 					 :SfxDockingWindow( pBindings, pMgr, pParent, WinBits(WB_STDMODELESS|WB_SIZEABLE|WB_ROLLABLE|WB_3DLOOK|WB_DOCKABLE) )
//STRIP001 					 ,SfxControllerItem( SID_FM_FILTER_NAVIGATOR_CONTROL, *pBindings )
//STRIP001 {
//STRIP001 	SetHelpId( HID_FILTER_NAVIGATOR_WIN );
//STRIP001 
//STRIP001 	m_pNavigator = new FmFilterNavigator( this );
//STRIP001 	m_pNavigator->Show();
//STRIP001 	SetText( SVX_RES(RID_STR_FILTER_NAVIGATOR) );
//STRIP001 	SfxDockingWindow::SetFloatingSize( Size(200,200) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmFilterNavigatorWin::~FmFilterNavigatorWin()
//STRIP001 {
//STRIP001 	delete m_pNavigator;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 void FmFilterNavigatorWin::Update(FmFormShell* pFormShell)
//STRIP001 {
//STRIP001 	if (!pFormShell)
//STRIP001 		m_pNavigator->Update(Reference< ::com::sun::star::container::XIndexAccess > (), Reference< ::com::sun::star::form::XFormController > ());
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::form::XFormController >  xController(pFormShell->GetImpl()->getActiveInternalController());
//STRIP001 		Reference< ::com::sun::star::container::XIndexAccess >	xContainer;
//STRIP001 		if (xController.is())
//STRIP001 		{
//STRIP001 			Reference< ::com::sun::star::container::XChild >  xChild(xController, UNO_QUERY);
//STRIP001 			for (Reference< XInterface >  xParent(xChild->getParent());
//STRIP001 				 xParent.is();
//STRIP001 				 xParent = xChild.is() ? xChild->getParent() : Reference< XInterface > ())
//STRIP001 			{
//STRIP001 				xContainer = Reference< ::com::sun::star::container::XIndexAccess > (xParent, UNO_QUERY);
//STRIP001 				xChild = Reference< ::com::sun::star::container::XChild > (xParent, UNO_QUERY);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		m_pNavigator->Update(xContainer, xController);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 void FmFilterNavigatorWin::StateChanged( sal_uInt16 nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	if( !pState  || SID_FM_FILTER_NAVIGATOR_CONTROL != nSID )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if( eState >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		FmFormShell* pShell = PTR_CAST( FmFormShell,((SfxObjectItem*)pState)->GetShell() );
//STRIP001 		Update( pShell );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Update( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 sal_Bool FmFilterNavigatorWin::Close()
//STRIP001 {
//STRIP001 	if ( m_pNavigator && m_pNavigator->IsEditingActive() )
//STRIP001 		m_pNavigator->EndEditing();
//STRIP001 
//STRIP001 	if ( m_pNavigator && m_pNavigator->IsEditingActive() )
//STRIP001 		// the EndEditing was vetoed (perhaps of an syntax error or such)
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Update( NULL );
//STRIP001 	return SfxDockingWindow::Close();
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 void FmFilterNavigatorWin::FillInfo( SfxChildWinInfo& rInfo ) const
//STRIP001 {
//STRIP001 	SfxDockingWindow::FillInfo( rInfo );
//STRIP001 	rInfo.bVisible = sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 Size FmFilterNavigatorWin::CalcDockingSize( SfxChildAlignment eAlign )
//STRIP001 {
//STRIP001 	Size aSize = SfxDockingWindow::CalcDockingSize( eAlign );
//STRIP001 
//STRIP001 	switch( eAlign )
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_TOP:
//STRIP001 		case SFX_ALIGN_BOTTOM:
//STRIP001 			return Size();
//STRIP001 		case SFX_ALIGN_LEFT:
//STRIP001 		case SFX_ALIGN_RIGHT:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aSize;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 SfxChildAlignment FmFilterNavigatorWin::CheckAlignment( SfxChildAlignment eActAlign, SfxChildAlignment eAlign )
//STRIP001 {
//STRIP001 	switch (eAlign)
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_LEFT:
//STRIP001 		case SFX_ALIGN_RIGHT:
//STRIP001 		case SFX_ALIGN_NOALIGNMENT:
//STRIP001 			return (eAlign);
//STRIP001 	}
//STRIP001 
//STRIP001 	return (eActAlign);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmFilterNavigatorWin::Resize()
//STRIP001 {
//STRIP001 	SfxDockingWindow::Resize();
//STRIP001 
//STRIP001 	Size aLogOutputSize = PixelToLogic( GetOutputSizePixel(), MAP_APPFONT );
//STRIP001 	Size aLogExplSize = aLogOutputSize;
//STRIP001 	aLogExplSize.Width() -= 6;
//STRIP001 	aLogExplSize.Height() -= 6;
//STRIP001 
//STRIP001 	Point aExplPos = LogicToPixel( Point(3,3), MAP_APPFONT );
//STRIP001 	Size aExplSize = LogicToPixel( aLogExplSize, MAP_APPFONT );
//STRIP001 
//STRIP001 	m_pNavigator->SetPosSizePixel( aExplPos, aExplSize );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 void FmFilterNavigatorWin::GetFocus()
//STRIP001 {
//STRIP001 	// oj #97405#
//STRIP001 	if ( m_pNavigator )
//STRIP001 		m_pNavigator->GrabFocus();
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------


//========================================================================
// class FmFilterNavigatorWinMgr
//========================================================================
/*N*/ SFX_IMPL_DOCKINGWINDOW( FmFilterNavigatorWinMgr, SID_FM_FILTER_NAVIGATOR )

/*?*/ //-----------------------------------------------------------------------
/*?*/ FmFilterNavigatorWinMgr::FmFilterNavigatorWinMgr( Window *pParent, sal_uInt16 nId,
/*?*/ 									SfxBindings *pBindings, SfxChildWinInfo* pInfo )
/*?*/ 				 :SfxChildWindow( pParent, nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 	pWindow = new FmFilterNavigatorWin( pBindings, this, pParent );
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 	((SfxDockingWindow*)pWindow)->Initialize( pInfo );
/*?*/ }
//STRIP001 
//STRIP001 //........................................................................
}	// namespace svxform
//........................................................................
}
