/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_escherex.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:25:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <math.h>
#ifndef _SVX_IMPGRF_HXX
#include "impgrf.hxx"
#endif
#ifndef _ESCHESDO_HXX
#include "eschesdo.hxx"
#endif
#ifndef _SVX_ESCHEREX_HXX
#include "escherex.hxx"
#endif
#ifndef _SVX_UNOAPI_HXX_
#include <unoapi.hxx>
#endif
#ifndef _SVDOBJ_HXX
#include <svdobj.hxx>
#endif
#ifndef _SVDMODEL_HXX
#include <svdmodel.hxx>
#endif
#ifndef _SV_GRADIENT_HXX
#include <vcl/gradient.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif
#ifndef _SV_CVTGRF_HXX
#include <vcl/cvtgrf.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _ZCODEC_HXX
#include <tools/zcodec.hxx>
#endif
#ifndef _INC_STDLIB
#include <stdlib.h>
#endif
#ifndef _FILTER_HXX
#include <svtools/filter.hxx>
#endif
#ifndef _COM_SUN_STAR_AWT_GRADIENTSTYLE_HPP_
#include <com/sun/star/awt/GradientStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_RASTEROPERATION_HPP_
#include <com/sun/star/awt/RasterOperation.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_GRADIENT_HPP_
#include <com/sun/star/awt/Gradient.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINESTYLE_HPP_
#include <com/sun/star/drawing/LineStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FILLSTYLE_HPP_
#include <com/sun/star/drawing/FillStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINEDASH_HPP_
#include <com/sun/star/drawing/LineDash.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_BEZIERPOINT_HPP_
#include <com/sun/star/drawing/BezierPoint.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POLYPOLYGONBEZIERCOORDS_HPP_
#include <com/sun/star/drawing/PolyPolygonBezierCoords.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_CONNECTORTYPE_HPP_
#include <com/sun/star/drawing/ConnectorType.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_CONNECTIONTYPE_HPP_
#include <com/sun/star/drawing/ConnectionType.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_CIRCLEKIND_HPP_
#include <com/sun/star/drawing/CircleKind.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POINTSEQUENCE_HPP_
#include <com/sun/star/drawing/PointSequence.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FLAGSEQUENCE_HPP_
#include <com/sun/star/drawing/FlagSequence.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POLYGONFLAGS_HPP_
#include <com/sun/star/drawing/PolygonFlags.hpp>
#endif
#ifndef _SV_HATCH_HXX_
#include <vcl/hatch.hxx>
#endif
#ifndef _COM_SUN_STAR_DRAWING_HATCH_HPP_
#include <com/sun/star/drawing/Hatch.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XGRAPHICS_HPP_
#include <com/sun/star/awt/XGraphics.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_COLORMODE_HPP_
#include <com/sun/star/drawing/ColorMode.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_BITMAPMODE_HPP_
#include <com/sun/star/drawing/BitmapMode.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_GRAPHICCROP_HPP_
#include <com/sun/star/text/GraphicCrop.hpp>
#endif
#ifndef _UNOTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _TOOLKIT_UNOHLP_HXX
#include <toolkit/unohlp.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif
#ifndef _RTL_CRC_H_
#include <rtl/crc.h>
#endif
#include <vos/xception.hxx>
#ifndef _VOS_NO_NAMESPACE
namespace binfilter {
using namespace vos;
#endif

using namespace ::rtl;

// ---------------------------------------------------------------------------------------------

//STRIP001 EscherExClientRecord_Base::~EscherExClientRecord_Base()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 EscherExClientAnchor_Base::~EscherExClientAnchor_Base()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 struct EscherPropSortStruct
//STRIP001 {
//STRIP001 	sal_uInt8*	pBuf;
//STRIP001 	sal_uInt32	nPropSize;
//STRIP001 	sal_uInt32	nPropValue;
//STRIP001 	sal_uInt16	nPropId;
//STRIP001 };
//STRIP001 
//STRIP001 void EscherPropertyContainer::ImplInit()
//STRIP001 {
//STRIP001 	nSortCount = 0;
//STRIP001 	nCountCount = 0;
//STRIP001 	nCountSize = 0;
//STRIP001 	nSortBufSize = 64;
//STRIP001 	bHasComplexData	= sal_False;
//STRIP001 	bSuppressRotation = sal_False;
//STRIP001 	pSortStruct = new EscherPropSortStruct[ nSortBufSize ];
//STRIP001 }
//STRIP001 
//STRIP001 EscherPropertyContainer::EscherPropertyContainer() :
//STRIP001 	pGraphicProvider	( NULL ),
//STRIP001 	pPicOutStrm			( NULL )
//STRIP001 {
//STRIP001 	ImplInit();
//STRIP001 };
//STRIP001 
//STRIP001 EscherPropertyContainer::EscherPropertyContainer(
//STRIP001 	EscherGraphicProvider& rGraphProv,
//STRIP001 			SvStream* pPiOutStrm,
//STRIP001 				Rectangle& rBoundRect ) :
//STRIP001 
//STRIP001 	pGraphicProvider	( &rGraphProv ),
//STRIP001 	pPicOutStrm			( pPiOutStrm ),
//STRIP001 	pShapeBoundRect		( &rBoundRect )
//STRIP001 {
//STRIP001 	ImplInit();
//STRIP001 }
//STRIP001 
//STRIP001 EscherPropertyContainer::~EscherPropertyContainer()
//STRIP001 {
//STRIP001 	if ( bHasComplexData )
//STRIP001 	{
//STRIP001 		while ( nSortCount-- )
//STRIP001 			delete[] pSortStruct[ nSortCount ].pBuf;
//STRIP001 	}
//STRIP001 	delete[] pSortStruct;
//STRIP001 };
//STRIP001 
//STRIP001 void EscherPropertyContainer::AddOpt( sal_uInt16 nPropID, sal_uInt32 nPropValue, sal_Bool bBlib )
//STRIP001 {
//STRIP001 	AddOpt( nPropID, bBlib, nPropValue, NULL, 0 );
//STRIP001 }
//STRIP001 
//STRIP001 void EscherPropertyContainer::AddOpt( sal_uInt16 nPropID, sal_Bool bBlib, sal_uInt32 nPropValue, sal_uInt8* pProp, sal_uInt32 nPropSize )
//STRIP001 {
//STRIP001 	if ( bBlib )				// bBlib is only valid when fComplex = 0
//STRIP001 		nPropID |= 0x4000;
//STRIP001 	if ( pProp )
//STRIP001 		nPropID |= 0x8000;		// fComplex = TRUE;
//STRIP001 
//STRIP001 	sal_uInt32 i;
//STRIP001 	for( i = 0; i < nSortCount; i++ )
//STRIP001 	{
//STRIP001 		if ( ( pSortStruct[ i ].nPropId &~0xc000 ) == ( nPropID &~0xc000 ) )	// pruefen, ob Property nur ersetzt wird
//STRIP001 		{
//STRIP001 			pSortStruct[ i ].nPropId = nPropID;
//STRIP001 			if ( pSortStruct[ i ].pBuf )
//STRIP001 			{
//STRIP001 				nCountSize -= pSortStruct[ i ].nPropSize;
//STRIP001 				delete[] pSortStruct[ i ].pBuf;
//STRIP001 			}
//STRIP001 			pSortStruct[ i ].pBuf = pProp;
//STRIP001 			pSortStruct[ i ].nPropSize = nPropSize;
//STRIP001 			pSortStruct[ i ].nPropValue = nPropValue;
//STRIP001 			if ( pProp )
//STRIP001 				nCountSize += nPropSize;
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nCountCount++;
//STRIP001 	nCountSize += 6;
//STRIP001 	if ( nSortCount == nSortBufSize )											// buffer vergroessern
//STRIP001 	{
//STRIP001 		nSortBufSize <<= 1;
//STRIP001 		EscherPropSortStruct* pTemp = new EscherPropSortStruct[ nSortBufSize ];
//STRIP001 		for( i = 0; i < nSortCount; i++ )
//STRIP001 		{
//STRIP001 			pTemp[ i ] = pSortStruct[ i ];
//STRIP001 		}
//STRIP001 		delete pSortStruct;
//STRIP001 		pSortStruct = pTemp;
//STRIP001 	}
//STRIP001 	pSortStruct[ nSortCount ].nPropId = nPropID;								// property einfuegen
//STRIP001 	pSortStruct[ nSortCount ].pBuf = pProp;
//STRIP001 	pSortStruct[ nSortCount ].nPropSize = nPropSize;
//STRIP001 	pSortStruct[ nSortCount++ ].nPropValue = nPropValue;
//STRIP001 
//STRIP001 	if ( pProp )
//STRIP001 	{
//STRIP001 		nCountSize += nPropSize;
//STRIP001 		bHasComplexData = sal_True;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherPropertyContainer::GetOpt( sal_uInt16 nPropId, sal_uInt32& nPropValue ) const
//STRIP001 {
//STRIP001 	sal_Bool bRetValue = sal_False;
//STRIP001 	for( sal_uInt32 i = 0; i < nSortCount; i++ )
//STRIP001 	{
//STRIP001 		if ( ( pSortStruct[ i ].nPropId &~0xc000 ) == ( nPropId &~0xc000 ) )
//STRIP001 		{
//STRIP001 			nPropValue = pSortStruct[ i ].nPropValue;
//STRIP001 			bRetValue = sal_True;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 extern "C" int __LOADONCALLAPI EscherPropSortFunc( const void* p1, const void* p2 )
//STRIP001 {
//STRIP001 	INT16	nID1 = ((EscherPropSortStruct*)p1)->nPropId &~0xc000;
//STRIP001 	INT16	nID2 = ((EscherPropSortStruct*)p2)->nPropId &~0xc000;
//STRIP001 
//STRIP001 	if( nID1  < nID2 )
//STRIP001 		return -1;
//STRIP001 	else if( nID1 > nID2 )
//STRIP001 		return 1;
//STRIP001 	else
//STRIP001 		return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherPropertyContainer::Commit( SvStream& rSt, sal_uInt16 nVersion )
//STRIP001 {
//STRIP001 	rSt << (sal_uInt16)( ( nCountCount << 4 ) | ( nVersion & 0xf ) ) << (sal_uInt16)ESCHER_OPT << nCountSize;
//STRIP001 	if ( nSortCount )
//STRIP001 	{
//STRIP001 		qsort( pSortStruct, nSortCount, sizeof( EscherPropSortStruct ), EscherPropSortFunc );
//STRIP001 		sal_uInt32 i;
//STRIP001 
//STRIP001 		for ( i = 0; i < nSortCount; i++ )
//STRIP001 		{
//STRIP001 			sal_uInt32 nPropValue = pSortStruct[ i ].nPropValue;
//STRIP001 			sal_uInt16 nPropId = pSortStruct[ i ].nPropId;
//STRIP001 
//STRIP001 			if ( bSuppressRotation && ( nPropId == ESCHER_Prop_Rotation ) )
//STRIP001 				nPropValue = 0;
//STRIP001 
//STRIP001 			rSt << nPropId
//STRIP001 				<< nPropValue;
//STRIP001 		}
//STRIP001 		if ( bHasComplexData )
//STRIP001 		{
//STRIP001 			for ( i = 0; i < nSortCount; i++ )
//STRIP001 			{
//STRIP001 				if ( pSortStruct[ i ].pBuf )
//STRIP001 					rSt.Write( pSortStruct[ i ].pBuf, pSortStruct[ i ].nPropSize );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt32 EscherPropertyContainer::ImplGetColor( const sal_uInt32 nSOColor, sal_Bool bSwap )
//STRIP001 {
//STRIP001 	if ( bSwap )
//STRIP001 	{
//STRIP001 		sal_uInt32 nColor = nSOColor & 0xff00;		// GRUEN
//STRIP001 		nColor |= (sal_uInt8)( nSOColor ) << 16;	// ROT
//STRIP001 		nColor |= (sal_uInt8)( nSOColor >> 16 );	// BLAU
//STRIP001 		return nColor;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return nSOColor & 0xffffff;
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt32 EscherPropertyContainer::GetGradientColor(
//STRIP001 	const ::com::sun::star::awt::Gradient* pGradient,
//STRIP001 		sal_uInt32 nStartColor )
//STRIP001 {
//STRIP001 	sal_uInt32	nIntensity;
//STRIP001 	Color		aColor;
//STRIP001 
//STRIP001 	if ( pGradient )
//STRIP001 	{
//STRIP001 		if ( nStartColor & 1 )
//STRIP001 		{
//STRIP001 			nIntensity = pGradient->StartIntensity;
//STRIP001 			aColor = pGradient->StartColor;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nIntensity = pGradient->EndIntensity;
//STRIP001 			aColor = pGradient->EndColor;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	sal_uInt32	nRed = ( ( aColor.GetRed() * nIntensity ) / 100 );
//STRIP001 	sal_uInt32	nGreen = ( ( aColor.GetGreen() * nIntensity ) / 100 ) << 8;
//STRIP001 	sal_uInt32	nBlue = ( ( aColor.GetBlue() * nIntensity ) / 100 ) << 16;
//STRIP001 	return nRed | nGreen | nBlue;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherPropertyContainer::CreateGradientProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Any			aAny;
//STRIP001 	::com::sun::star::awt::Gradient*	pGradient = NULL;
//STRIP001 
//STRIP001     sal_uInt32  nFillType = ESCHER_FillShadeScale;
//STRIP001     sal_uInt32  nAngle = 0;
//STRIP001     sal_uInt32  nFillFocus = 0;
//STRIP001     sal_uInt32  nFillLR = 0;
//STRIP001     sal_uInt32  nFillTB = 0;
//STRIP001 	sal_uInt32	nFirstColor = 0;
//STRIP001     bool        bWriteFillTo = false;
//STRIP001 
//STRIP001     if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 			aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillGradient" ) ), sal_False ) )
//STRIP001 	{
//STRIP001 		pGradient = (::com::sun::star::awt::Gradient*)aAny.getValue();
//STRIP001 
//STRIP001         switch ( pGradient->Style )
//STRIP001         {
//STRIP001             case ::com::sun::star::awt::GradientStyle_LINEAR :
//STRIP001             case ::com::sun::star::awt::GradientStyle_AXIAL :
//STRIP001             {
//STRIP001                 nFillType = ESCHER_FillShadeScale;
//STRIP001                 nAngle = (pGradient->Angle * 0x10000) / 10;
//STRIP001                 nFillFocus = (pGradient->Style == GradientStyle_LINEAR) ? 0 : 50;
//STRIP001             }
//STRIP001             break;
//STRIP001             case ::com::sun::star::awt::GradientStyle_RADIAL :
//STRIP001             case ::com::sun::star::awt::GradientStyle_ELLIPTICAL :
//STRIP001             case ::com::sun::star::awt::GradientStyle_SQUARE :
//STRIP001             case ::com::sun::star::awt::GradientStyle_RECT :
//STRIP001             {
//STRIP001                 nFillLR = (pGradient->XOffset * 0x10000) / 100;
//STRIP001                 nFillTB = (pGradient->YOffset * 0x10000) / 100;
//STRIP001                 if ( ((nFillLR > 0) && (nFillLR < 0x10000)) || ((nFillTB > 0) && (nFillTB < 0x10000)) )
//STRIP001                     nFillType = ESCHER_FillShadeShape;
//STRIP001                 else
//STRIP001                     nFillType = ESCHER_FillShadeCenter;
//STRIP001                 nFirstColor = 1;
//STRIP001                 bWriteFillTo = true;
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     AddOpt( ESCHER_Prop_fillType, nFillType );
//STRIP001     AddOpt( ESCHER_Prop_fillAngle, nAngle );
//STRIP001 	AddOpt( ESCHER_Prop_fillColor, GetGradientColor( pGradient, nFirstColor ) );
//STRIP001 	AddOpt( ESCHER_Prop_fillBackColor, GetGradientColor( pGradient, nFirstColor ^ 1 ) );
//STRIP001 	AddOpt( ESCHER_Prop_fillFocus, nFillFocus );
//STRIP001     if ( bWriteFillTo )
//STRIP001     {
//STRIP001         AddOpt( ESCHER_Prop_fillToLeft, nFillLR );
//STRIP001         AddOpt( ESCHER_Prop_fillToTop, nFillTB );
//STRIP001         AddOpt( ESCHER_Prop_fillToRight, nFillLR );
//STRIP001         AddOpt( ESCHER_Prop_fillToBottom, nFillTB );
//STRIP001     }
//STRIP001 };
//STRIP001 
//STRIP001 void EscherPropertyContainer::CreateFillProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 		sal_Bool bEdge )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Any aAny;
//STRIP001     AddOpt( ESCHER_Prop_WrapText, ESCHER_WrapNone );
//STRIP001     AddOpt( ESCHER_Prop_AnchorText, ESCHER_AnchorMiddle );
//STRIP001 
//STRIP001     sal_uInt32 nFillBackColor = 0;
//STRIP001 
//STRIP001     if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 			aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillStyle" ) ), sal_False ) )
//STRIP001     {
//STRIP001 		::com::sun::star::drawing::FillStyle eFS;
//STRIP001 		if ( ! ( aAny >>= eFS ) )
//STRIP001 			eFS = ::com::sun::star::drawing::FillStyle_SOLID;
//STRIP001         switch( eFS )
//STRIP001         {
//STRIP001             case ::com::sun::star::drawing::FillStyle_GRADIENT :
//STRIP001             {
//STRIP001 				CreateGradientProperties( rXPropSet );
//STRIP001                 AddOpt( ESCHER_Prop_fNoFillHitTest, 0x140014 );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case ::com::sun::star::drawing::FillStyle_BITMAP :
//STRIP001             {
//STRIP001                 CreateGraphicProperties( rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillBitmapURL" ) ), sal_True );
//STRIP001                 AddOpt( ESCHER_Prop_fNoFillHitTest, 0x140014 );
//STRIP001                 AddOpt( ESCHER_Prop_fillBackColor, nFillBackColor  );
//STRIP001             }
//STRIP001             break;
//STRIP001             case ::com::sun::star::drawing::FillStyle_HATCH :
//STRIP001 			{
//STRIP001 				CreateGraphicProperties( rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillHatch" ) ), sal_True );
//STRIP001 			}
//STRIP001 			break;
//STRIP001             case ::com::sun::star::drawing::FillStyle_SOLID :
//STRIP001             default:
//STRIP001             {
//STRIP001 				sal_uInt16 nTransparency = ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 												aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillTransparence" ) ), sal_False ) )
//STRIP001 											? *((sal_Int16*)aAny.getValue() )
//STRIP001 											: 0;
//STRIP001                 if ( nTransparency != 100 )
//STRIP001                 {
//STRIP001                     if ( nTransparency )    // opacity
//STRIP001                         AddOpt( ESCHER_Prop_fillOpacity, ( ( 100 - nTransparency ) << 16 ) / 100 );
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 							aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillColor" ) ), sal_False ) )
//STRIP001 					{
//STRIP001                         sal_uInt32 nFillColor = ImplGetColor( *((sal_uInt32*)aAny.getValue()) );
//STRIP001                         nFillBackColor = nFillColor ^ 0xffffff;
//STRIP001                         AddOpt( ESCHER_Prop_fillColor, nFillColor );
//STRIP001 					}
//STRIP001                     AddOpt( ESCHER_Prop_fNoFillHitTest, 0x100010 );
//STRIP001                     AddOpt( ESCHER_Prop_fillBackColor, nFillBackColor );
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001             case ::com::sun::star::drawing::FillStyle_NONE :
//STRIP001                 AddOpt( ESCHER_Prop_fNoFillHitTest, 0x100000 );
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     CreateLineProperties( rXPropSet, bEdge );
//STRIP001 }
//STRIP001 
//STRIP001 static sal_Bool GetLineArrow( const sal_Bool bLineStart,
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 		ESCHER_LineEnd& reLineEnd, sal_Int32& rnArrowLength, sal_Int32& rnArrowWidth )
//STRIP001 {
//STRIP001 	static String sLineStart	( RTL_CONSTASCII_USTRINGPARAM( "LineStart" ) );
//STRIP001 	static String sLineStartName( RTL_CONSTASCII_USTRINGPARAM( "LineStartName" ) );
//STRIP001 	static String sLineEnd		( RTL_CONSTASCII_USTRINGPARAM( "LineEnd" ) );
//STRIP001 	static String sLineEndName	( RTL_CONSTASCII_USTRINGPARAM( "LineEndName" ) );
//STRIP001 
//STRIP001 	const String sLine		( bLineStart ? sLineStart : sLineEnd );
//STRIP001 	const String sLineName	( bLineStart ? sLineStartName : sLineEndName );
//STRIP001 
//STRIP001 	sal_Bool bIsArrow = sal_False;
//STRIP001 
//STRIP001 	::com::sun::star::uno::Any aAny;
//STRIP001     if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 			aAny, rXPropSet, sLine, sal_False ) )
//STRIP001     {
//STRIP001 		PolyPolygon aPolyPoly( EscherPropertyContainer::GetPolyPolygon( aAny ) );
//STRIP001 		if ( aPolyPoly.Count() && aPolyPoly[ 0 ].GetSize() )
//STRIP001 		{
//STRIP001 			bIsArrow = sal_True;
//STRIP001 
//STRIP001 			reLineEnd     = ESCHER_LineArrowEnd;
//STRIP001 			rnArrowLength = 1;
//STRIP001 			rnArrowWidth  = 1;
//STRIP001 
//STRIP001 			if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 				aAny, rXPropSet, sLineName, sal_False ) )
//STRIP001 			{
//STRIP001 				String			aArrowStartName = *(::rtl::OUString*)aAny.getValue();
//STRIP001 				::rtl::OUString	aApiName;
//STRIP001 				sal_Int16		nWhich = bLineStart ? XATTR_LINESTART : XATTR_LINEEND;
//STRIP001 
//STRIP001 				SvxUnogetApiNameForItem( nWhich, aArrowStartName, aApiName );
//STRIP001 				if ( aApiName.getLength() )
//STRIP001 				{
//STRIP001 
//STRIP001 					/* todo:
//STRIP001 					calculate the best option for ArrowLenght and ArrowWidth
//STRIP001 					*/
//STRIP001 					if ( aApiName.equalsAscii( "Arrow concave" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowStealthEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Square 45" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowDiamondEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Small Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Dimension Lines" ) )
//STRIP001 					{
//STRIP001 						rnArrowLength = 0;
//STRIP001 						rnArrowWidth  = 2;
//STRIP001 						reLineEnd = ESCHER_LineArrowOvalEnd;
//STRIP001 					}
//STRIP001 					else if ( aApiName.equalsAscii( "Double Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Rounded short Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Symmetric Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Line Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowOpenEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Rounded large Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Circle" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowOvalEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Square" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowDiamondEnd;
//STRIP001 					else if ( aApiName.equalsAscii( "Arrow" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 				}
//STRIP001 				else if ( aArrowStartName.GetTokenCount( ' ' ) == 2 )
//STRIP001 				{
//STRIP001 					sal_Bool b = sal_True;
//STRIP001 					String aArrowName( aArrowStartName.GetToken( 0, ' ' ) );
//STRIP001 					if (  aArrowName.EqualsAscii( "msArrowEnd" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowEnd;
//STRIP001 					else if (  aArrowName.EqualsAscii( "msArrowOpenEnd" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowOpenEnd;
//STRIP001 					else if ( aArrowName.EqualsAscii( "msArrowStealthEnd" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowStealthEnd;
//STRIP001 					else if ( aArrowName.EqualsAscii( "msArrowDiamondEnd" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowDiamondEnd;
//STRIP001 					else if ( aArrowName.EqualsAscii( "msArrowOvalEnd" ) )
//STRIP001 						reLineEnd = ESCHER_LineArrowOvalEnd;
//STRIP001 					else
//STRIP001 						b = sal_False;
//STRIP001 
//STRIP001 					// now we have the arrow, and try to determine the arrow size;
//STRIP001 					if ( b )
//STRIP001 					{
//STRIP001 						String aArrowSize( aArrowStartName.GetToken( 1, ' ' ) );
//STRIP001 						sal_Int32 nArrowSize = aArrowSize.ToInt32();
//STRIP001 						rnArrowWidth = ( nArrowSize - 1 ) / 3;
//STRIP001 						rnArrowLength = nArrowSize - ( rnArrowWidth * 3 ) - 1;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001 	return bIsArrow;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void EscherPropertyContainer::CreateLineProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 		sal_Bool bEdge )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Any aAny;
//STRIP001     sal_uInt32 nLineFlags = 0x80008;
//STRIP001 
//STRIP001 	ESCHER_LineEnd eLineEnd;
//STRIP001 	sal_Int32 nArrowLength;
//STRIP001 	sal_Int32 nArrowWidth;
//STRIP001 
//STRIP001 	sal_Bool bSwapLineEnds = sal_False;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "CircleKind" ) ), sal_True ) )
//STRIP001 	{
//STRIP001 		::com::sun::star::drawing::CircleKind  eCircleKind;
//STRIP001 		if ( aAny >>= eCircleKind )
//STRIP001 		{
//STRIP001             if ( eCircleKind == ::com::sun::star::drawing::CircleKind_ARC )
//STRIP001 				bSwapLineEnds = sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( GetLineArrow( bSwapLineEnds ? sal_False : sal_True, rXPropSet, eLineEnd, nArrowLength, nArrowWidth ) )
//STRIP001 	{
//STRIP001         AddOpt( ESCHER_Prop_lineStartArrowLength, nArrowLength );
//STRIP001         AddOpt( ESCHER_Prop_lineStartArrowWidth, nArrowWidth );
//STRIP001         AddOpt( ESCHER_Prop_lineStartArrowhead, eLineEnd );
//STRIP001         nLineFlags |= 0x100010;
//STRIP001 	}
//STRIP001 	if ( GetLineArrow( bSwapLineEnds ? sal_True : sal_False, rXPropSet, eLineEnd, nArrowLength, nArrowWidth ) )
//STRIP001 	{
//STRIP001         AddOpt( ESCHER_Prop_lineEndArrowLength, nArrowLength );
//STRIP001         AddOpt( ESCHER_Prop_lineEndArrowWidth, nArrowWidth );
//STRIP001         AddOpt( ESCHER_Prop_lineEndArrowhead, eLineEnd );
//STRIP001         nLineFlags |= 0x100010;
//STRIP001 	}
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 		aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "LineStyle"  ) ), sal_False ) )
//STRIP001     {
//STRIP001 		::com::sun::star::drawing::LineStyle eLS;
//STRIP001 		if ( aAny >>= eLS )
//STRIP001 		{
//STRIP001 			switch ( eLS )
//STRIP001 			{
//STRIP001 				case ::com::sun::star::drawing::LineStyle_NONE :
//STRIP001 					AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x90000 );           // 80000
//STRIP001 				break;
//STRIP001 
//STRIP001 				case ::com::sun::star::drawing::LineStyle_DASH :
//STRIP001 				{
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 						aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "LineDash" ) ), sal_False ) )
//STRIP001 					{
//STRIP001 						ESCHER_LineDashing eDash = ESCHER_LineSolid;
//STRIP001 						::com::sun::star::drawing::LineDash* pLineDash = (::com::sun::star::drawing::LineDash*)aAny.getValue();
//STRIP001 						sal_Int32 nDistance = pLineDash->Distance << 1;
//STRIP001 						switch ( pLineDash->Style )
//STRIP001 						{
//STRIP001 							case ::com::sun::star::drawing::DashStyle_ROUND :
//STRIP001 							case ::com::sun::star::drawing::DashStyle_ROUNDRELATIVE :
//STRIP001 								AddOpt( ESCHER_Prop_lineEndCapStyle, 0 ); // Style Round setzen
//STRIP001 							break;
//STRIP001 						}
//STRIP001 						if ( ((!(pLineDash->Dots )) || (!(pLineDash->Dashes )) ) || ( pLineDash->DotLen == pLineDash->DashLen ) )
//STRIP001 						{
//STRIP001 							sal_Int32 nLen = pLineDash->DotLen;
//STRIP001 							if ( pLineDash->Dashes )
//STRIP001 								nLen = pLineDash->DashLen;
//STRIP001 
//STRIP001 							if ( nLen >= nDistance )
//STRIP001 								eDash = ESCHER_LineLongDashGEL;
//STRIP001 							else if ( pLineDash->Dots )
//STRIP001 								eDash = ESCHER_LineDotSys;
//STRIP001 							else
//STRIP001 								eDash = ESCHER_LineDashGEL;
//STRIP001 						}
//STRIP001 						else                                                            // X Y
//STRIP001 						{
//STRIP001 							if ( pLineDash->Dots != pLineDash->Dashes )
//STRIP001 							{
//STRIP001 								if ( ( pLineDash->DashLen > nDistance ) || ( pLineDash->DotLen > nDistance ) )
//STRIP001 									eDash = ESCHER_LineLongDashDotDotGEL;
//STRIP001 								else
//STRIP001 									eDash = ESCHER_LineDashDotDotSys;
//STRIP001 							}
//STRIP001 							else                                                        // X Y Y
//STRIP001 							{
//STRIP001 								if ( ( pLineDash->DashLen > nDistance ) || ( pLineDash->DotLen > nDistance ) )
//STRIP001 									eDash = ESCHER_LineLongDashDotGEL;
//STRIP001 								else
//STRIP001 									eDash = ESCHER_LineDashDotGEL;
//STRIP001 
//STRIP001 							}
//STRIP001 						}
//STRIP001 						AddOpt( ESCHER_Prop_lineDashing, eDash );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				case ::com::sun::star::drawing::LineStyle_SOLID :
//STRIP001 				default:
//STRIP001 				{
//STRIP001 					AddOpt( ESCHER_Prop_fNoLineDrawDash, nLineFlags );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 			aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "LineColor"  ) ), sal_False ) )
//STRIP001         {
//STRIP001             sal_uInt32 nLineColor = ImplGetColor( *((sal_uInt32*)aAny.getValue()) );
//STRIP001             AddOpt( ESCHER_Prop_lineColor, nLineColor );
//STRIP001             AddOpt( ESCHER_Prop_lineBackColor, nLineColor ^ 0xffffff );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	sal_uInt32 nLineSize = ( EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 		aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "LineWidth"  ) ), sal_False ) )
//STRIP001 		? *((sal_uInt32*)aAny.getValue())
//STRIP001 		: 0;
//STRIP001 
//STRIP001     if ( nLineSize > 1 )
//STRIP001         AddOpt( ESCHER_Prop_lineWidth, nLineSize * 360 );		// 100TH MM -> PT , 1PT = 12700 EMU
//STRIP001     if ( bEdge == sal_False )
//STRIP001     {
//STRIP001         AddOpt( ESCHER_Prop_fFillOK, 0x1001 );
//STRIP001         AddOpt( ESCHER_Prop_fNoFillHitTest, 0x100000 );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 static Size lcl_SizeToEmu(Size aPrefSize, MapMode aPrefMapMode)
//STRIP001 {
//STRIP001     Size aRetSize;
//STRIP001     if (aPrefMapMode == MAP_PIXEL)
//STRIP001         aRetSize = Application::GetDefaultDevice()->PixelToLogic( aPrefSize, MAP_100TH_MM );
//STRIP001     else
//STRIP001         aRetSize = Application::GetDefaultDevice()->LogicToLogic( aPrefSize, aPrefMapMode, MAP_100TH_MM );
//STRIP001     return aRetSize;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherPropertyContainer::ImplCreateGraphicAttributes( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 															sal_uInt32 nBlibId, sal_Bool bCreateCroppingAttributes )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Any aAny;
//STRIP001 
//STRIP001 	sal_uInt32 nPicFlags = 0;
//STRIP001 	::com::sun::star::drawing::ColorMode eColorMode( ::com::sun::star::drawing::ColorMode_STANDARD );
//STRIP001 	sal_Int16 nLuminance = 0;
//STRIP001 	sal_Int32 nContrast = 0;
//STRIP001 	sal_Int16 nRed = 0;
//STRIP001 	sal_Int16 nGreen = 0;
//STRIP001 	sal_Int16 nBlue = 0;
//STRIP001 	double fGamma = 1.0;
//STRIP001 	sal_Int16 nTransparency = 0;
//STRIP001 
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "GraphicColorMode" ) ) ) )
//STRIP001 		aAny >>= eColorMode;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "AdjustLuminance" ) ) ) )
//STRIP001 		aAny >>= nLuminance;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "AdjustContrast" ) ) ) )
//STRIP001 	{
//STRIP001 		sal_Int16 nC;
//STRIP001 		aAny >>= nC;
//STRIP001 		nContrast = nC;
//STRIP001 	}
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "AdjustRed" ) ) ) )
//STRIP001 		aAny >>= nRed;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "AdjustGreen" ) ) ) )
//STRIP001 		aAny >>= nGreen;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "AdjustBlue" ) ) ) )
//STRIP001 		aAny >>= nBlue;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "Gamma" ) ) ) )
//STRIP001 		aAny >>= fGamma;
//STRIP001 	if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "Transparency" ) ) ) )
//STRIP001 		aAny >>= nTransparency;
//STRIP001 
//STRIP001 	if ( eColorMode == ::com::sun::star::drawing::ColorMode_WATERMARK )
//STRIP001 	{
//STRIP001 		eColorMode = ::com::sun::star::drawing::ColorMode_STANDARD;
//STRIP001 		nLuminance += 70;
//STRIP001 		if ( nLuminance > 100 )
//STRIP001 			nLuminance = 100;
//STRIP001 		nContrast -= 70;
//STRIP001 		if ( nContrast < -100 )
//STRIP001 			nContrast = -100;
//STRIP001 	}
//STRIP001 	if ( eColorMode == ::com::sun::star::drawing::ColorMode_GREYS )
//STRIP001 		nPicFlags |= 0x40004;
//STRIP001 	else if ( eColorMode == ::com::sun::star::drawing::ColorMode_MONO )
//STRIP001 		nPicFlags |= 0x60006;
//STRIP001 
//STRIP001 	if ( nContrast )
//STRIP001 	{
//STRIP001 		nContrast += 100;
//STRIP001 		if ( nContrast == 100)
//STRIP001 			nContrast = 0x10000;
//STRIP001 		else if ( nContrast < 100 )
//STRIP001 		{
//STRIP001 			nContrast *= 0x10000;
//STRIP001 			nContrast /= 100;
//STRIP001 		}
//STRIP001 		else if ( nContrast < 200 )
//STRIP001 			nContrast = ( 100 * 0x10000 ) / ( 200 - nContrast );
//STRIP001 		else
//STRIP001 			nContrast = 0x7fffffff;
//STRIP001 		AddOpt( ESCHER_Prop_pictureContrast, nContrast );
//STRIP001 	}
//STRIP001 	if ( nLuminance )
//STRIP001 		AddOpt( ESCHER_Prop_pictureBrightness, nLuminance * 327 );
//STRIP001 	if ( nPicFlags )
//STRIP001 		AddOpt( ESCHER_Prop_pictureActive, nPicFlags );
//STRIP001 
//STRIP001 	if ( bCreateCroppingAttributes && pGraphicProvider )
//STRIP001 	{
//STRIP001 		Size	aPrefSize;
//STRIP001 		MapMode	aPrefMapMode;
//STRIP001 		if ( pGraphicProvider->GetPrefSize( nBlibId, aPrefSize, aPrefMapMode ) )
//STRIP001 		{
//STRIP001             Size aCropSize(lcl_SizeToEmu(aPrefSize, aPrefMapMode));
//STRIP001 			if ( aCropSize.Width() && aCropSize.Height() )
//STRIP001 			{
//STRIP001 				if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "GraphicCrop" ) ) ) )
//STRIP001 				{
//STRIP001 					::com::sun::star::text::GraphicCrop aGraphCrop;
//STRIP001 					if ( aAny >>= aGraphCrop )
//STRIP001 					{
//STRIP001 						if ( aGraphCrop.Left )
//STRIP001 						{
//STRIP001 							sal_uInt32 nLeft = ( aGraphCrop.Left * 65536 ) / aCropSize.Width();
//STRIP001 							AddOpt( ESCHER_Prop_cropFromLeft, nLeft );
//STRIP001 						}
//STRIP001 						if ( aGraphCrop.Top )
//STRIP001 						{
//STRIP001 							sal_uInt32 nTop = ( aGraphCrop.Top * 65536 ) / aCropSize.Height();
//STRIP001 							AddOpt( ESCHER_Prop_cropFromTop, nTop );
//STRIP001 						}
//STRIP001 						if ( aGraphCrop.Right )
//STRIP001 						{
//STRIP001 							sal_uInt32 nRight = ( aGraphCrop.Right * 65536 ) / aCropSize.Width();
//STRIP001 							AddOpt( ESCHER_Prop_cropFromRight, nRight );
//STRIP001 						}
//STRIP001 						if ( aGraphCrop.Bottom )
//STRIP001 						{
//STRIP001 							sal_uInt32 nBottom = ( aGraphCrop.Bottom * 65536 ) / aCropSize.Height();
//STRIP001 							AddOpt( ESCHER_Prop_cropFromBottom, nBottom );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool EscherPropertyContainer::CreateGraphicProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 		const String& rSource, sal_Bool bFillBitmap, sal_Bool bCreateCroppingAttributes )
//STRIP001 {
//STRIP001 	sal_Bool		bRetValue = sal_False;
//STRIP001 
//STRIP001     sal_Bool        bMirrored = sal_False;
//STRIP001     sal_Bool        bRotate   = sal_True;
//STRIP001     GraphicAttr*    pGraphicAttr = NULL;
//STRIP001     GraphicObject   aGraphicObject;
//STRIP001     String          aGraphicUrl;
//STRIP001     ByteString      aUniqueId;
//STRIP001 
//STRIP001     ::com::sun::star::drawing::BitmapMode   eBitmapMode( ::com::sun::star::drawing::BitmapMode_NO_REPEAT );
//STRIP001     ::com::sun::star::uno::Any aAny;
//STRIP001 
//STRIP001     if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, rSource ) )
//STRIP001     {
//STRIP001         if ( rSource == String( RTL_CONSTASCII_USTRINGPARAM( "MetaFile" ) ) )
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Sequence<sal_uInt8> aSeq = *(::com::sun::star::uno::Sequence<sal_uInt8>*)aAny.getValue();
//STRIP001             const sal_uInt8*    pAry = aSeq.getArray();
//STRIP001             sal_uInt32          nAryLen = aSeq.getLength();
//STRIP001 
//STRIP001             // the metafile is already rotated
//STRIP001             bRotate = sal_False;
//STRIP001 
//STRIP001             if ( pAry && nAryLen )
//STRIP001             {
//STRIP001                 Graphic         aGraphic;
//STRIP001                 SvMemoryStream  aTemp( (void*)pAry, nAryLen, STREAM_READ );
//STRIP001                 sal_uInt32 nErrCode = GraphicConverter::Import( aTemp, aGraphic, CVT_WMF );
//STRIP001                 if ( nErrCode == ERRCODE_NONE )
//STRIP001                 {
//STRIP001                     aGraphicObject = aGraphic;
//STRIP001                     aUniqueId = aGraphicObject.GetUniqueID();
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else if ( rSource == String( RTL_CONSTASCII_USTRINGPARAM( "Bitmap" ) ) )
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::awt::XBitmap >xBitmap;
//STRIP001             if ( ::cppu::extractInterface( xBitmap, aAny ) )
//STRIP001             {
//STRIP001                 ::com::sun::star::uno::Reference< ::com::sun::star::awt::XBitmap > xBitmap;
//STRIP001                 if ( aAny >>= xBitmap )
//STRIP001                 {
//STRIP001                     BitmapEx    aBitmapEx( VCLUnoHelper::GetBitmap( xBitmap ) );
//STRIP001                     Graphic     aGraphic( aBitmapEx );
//STRIP001                     aGraphicObject = aGraphic;
//STRIP001                     aUniqueId = aGraphicObject.GetUniqueID();
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else if ( rSource == String( RTL_CONSTASCII_USTRINGPARAM( "FillBitmapURL" ) ) )
//STRIP001         {
//STRIP001             aGraphicUrl = *(::rtl::OUString*)aAny.getValue();
//STRIP001         }
//STRIP001         else if ( rSource == String( RTL_CONSTASCII_USTRINGPARAM( "GraphicURL" ) ) )
//STRIP001         {
//STRIP001             aGraphicUrl = *(::rtl::OUString*)aAny.getValue();
//STRIP001         }
//STRIP001         else if ( rSource == String( RTL_CONSTASCII_USTRINGPARAM( "FillHatch" ) ) )
//STRIP001         {
//STRIP001             ::com::sun::star::drawing::Hatch aHatch;
//STRIP001             if ( aAny >>= aHatch )
//STRIP001             {
//STRIP001                 sal_Bool        bBackground = sal_False;
//STRIP001                 if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001                         String( RTL_CONSTASCII_USTRINGPARAM( "FillBackground" ) ), sal_True ) )
//STRIP001                 {
//STRIP001                     aAny >>= bBackground;
//STRIP001                 }
//STRIP001 
//STRIP001                 const MapMode   aMap100( MAP_100TH_MM );
//STRIP001                 VirtualDevice   aVDev;
//STRIP001                 const Size      aOutSize( aVDev.PixelToLogic( Size( 28, 28 ), aMap100 ) );
//STRIP001 
//STRIP001                 if( aVDev.SetOutputSize( aOutSize ) )
//STRIP001                 {
//STRIP001                     Rectangle aRectangle = Rectangle( Point(), aOutSize );
//STRIP001                     const PolyPolygon   aPolyPoly( aRectangle );
//STRIP001                     Hatch               aVclHatch( (HatchStyle) aHatch.Style, Color( aHatch.Color ), aHatch.Distance, (sal_uInt16)aHatch.Angle );
//STRIP001 
//STRIP001                     if ( bBackground )
//STRIP001                     {
//STRIP001                         if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001                             String( RTL_CONSTASCII_USTRINGPARAM( "FillColor" ) ), sal_False ) )
//STRIP001                         {
//STRIP001                             aVDev.SetLineColor();
//STRIP001                             aVDev.SetFillColor( ImplGetColor( *((sal_uInt32*)aAny.getValue()), sal_False ) );
//STRIP001                             aVDev.DrawRect( Rectangle( Point(), aOutSize ) );
//STRIP001                         }
//STRIP001                     }
//STRIP001                     aVDev.SetMapMode( aMap100 );
//STRIP001                     aVDev.DrawHatch( aPolyPoly, aVclHatch );
//STRIP001                     Bitmap  aBitmap( aVDev.GetBitmap( Point(), aOutSize ) );
//STRIP001 
//STRIP001                     if ( bBackground )
//STRIP001                         aGraphicObject = Graphic( aBitmap );
//STRIP001                     else
//STRIP001                     {
//STRIP001                         VirtualDevice   aMaskVDev( 1 );
//STRIP001                         aMaskVDev.SetMapMode( aMap100 );
//STRIP001                         if( aMaskVDev.SetOutputSize( aOutSize ) )
//STRIP001                         {
//STRIP001                             aVclHatch.SetColor( Color( COL_BLACK ) );
//STRIP001                             aMaskVDev.DrawHatch( aPolyPoly, aVclHatch );
//STRIP001                             Graphic   aGraphic( BitmapEx( aBitmap, aMaskVDev.GetBitmap( Point(), aOutSize ) ) );
//STRIP001                             aGraphicObject = aGraphic;
//STRIP001                         }
//STRIP001                         else
//STRIP001                             aGraphicObject = Graphic( aBitmap );
//STRIP001 
//STRIP001                     }
//STRIP001                     eBitmapMode = ::com::sun::star::drawing::BitmapMode_REPEAT;
//STRIP001                     aUniqueId = aGraphicObject.GetUniqueID();
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         if ( aGraphicUrl.Len() )
//STRIP001         {
//STRIP001             String aVndUrl( RTL_CONSTASCII_USTRINGPARAM( "vnd.sun.star.GraphicObject:" ) );
//STRIP001             xub_StrLen nIndex = aGraphicUrl.Search( aVndUrl, 0 );
//STRIP001             if ( nIndex != STRING_NOTFOUND )
//STRIP001             {
//STRIP001                 nIndex += aVndUrl.Len();
//STRIP001                 if ( aGraphicUrl.Len() > nIndex  )
//STRIP001                     aUniqueId = ByteString( aGraphicUrl, nIndex, aGraphicUrl.Len() - nIndex, RTL_TEXTENCODING_UTF8 );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 INetURLObject   aTmp( aGraphicUrl );
//STRIP001                 SvStream* pIn = ::utl::UcbStreamHelper::CreateStream(
//STRIP001                     aTmp.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001                 if ( pIn )
//STRIP001                 {
//STRIP001                     Graphic aGraphic;
//STRIP001                     sal_uInt32 nErrCode = GraphicConverter::Import( *pIn, aGraphic );
//STRIP001                     if ( nErrCode == ERRCODE_NONE )
//STRIP001                     {
//STRIP001                         aGraphicObject = aGraphic;
//STRIP001                         aUniqueId = aGraphicObject.GetUniqueID();
//STRIP001                     }
//STRIP001                     delete pIn;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         if ( aUniqueId.Len() )
//STRIP001         {
//STRIP001             if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "IsMirrored" ) ), sal_True ) )
//STRIP001                 aAny >>= bMirrored;
//STRIP001 
//STRIP001             if ( bFillBitmap )
//STRIP001             {
//STRIP001                 if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "FillBitmapMode" ) ), sal_True ) )
//STRIP001                     aAny >>= eBitmapMode;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 sal_uInt16 nAngle = bRotate && EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001                                         String( RTL_CONSTASCII_USTRINGPARAM( "RotateAngle" ) ), sal_True )
//STRIP001                                     ? (sal_uInt16)( ( *((sal_Int32*)aAny.getValue() ) ) + 5 ) / 10
//STRIP001                                     : 0;
//STRIP001 
//STRIP001                 if ( bMirrored || nAngle )
//STRIP001                 {
//STRIP001                     pGraphicAttr = new GraphicAttr;
//STRIP001                     if ( bMirrored )
//STRIP001                         pGraphicAttr->SetMirrorFlags( BMP_MIRROR_HORZ );
//STRIP001                     GraphicObject aTmpGraphicObject( aUniqueId );
//STRIP001                     if ( aTmpGraphicObject.GetType() == GRAPHIC_GDIMETAFILE )
//STRIP001                         AddOpt( ESCHER_Prop_Rotation, ( ( ((sal_Int32)nAngle << 16 ) / 10 ) + 0x8000 ) &~ 0xffff );
//STRIP001                     else
//STRIP001                     {
//STRIP001                         pGraphicAttr->SetRotation( nAngle );
//STRIP001                         if ( nAngle && pShapeBoundRect )   // up to xp ppoint does not rotate bitmaps !
//STRIP001                         {
//STRIP001                             Polygon aPoly( *pShapeBoundRect );
//STRIP001                             aPoly.Rotate( pShapeBoundRect->TopLeft(), nAngle );
//STRIP001                             *pShapeBoundRect = aPoly.GetBoundRect();
//STRIP001                             bSuppressRotation = sal_True;
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             if ( eBitmapMode == ::com::sun::star::drawing::BitmapMode_REPEAT )
//STRIP001                 AddOpt( ESCHER_Prop_fillType, ESCHER_FillTexture );
//STRIP001             else
//STRIP001                 AddOpt( ESCHER_Prop_fillType, ESCHER_FillPicture );
//STRIP001 
//STRIP001             if ( pGraphicProvider && pPicOutStrm && pShapeBoundRect )
//STRIP001             {
//STRIP001                 Rectangle aRect( Point( 0, 0 ), pShapeBoundRect->GetSize() );
//STRIP001 
//STRIP001 				sal_uInt32 nBlibId = 0;
//STRIP001 				if ( aUniqueId.Len() )
//STRIP001 					nBlibId = pGraphicProvider->GetBlibID( *pPicOutStrm, aUniqueId, aRect, pGraphicAttr );
//STRIP001 				if ( nBlibId )
//STRIP001 				{
//STRIP001 					if ( bFillBitmap )
//STRIP001 						AddOpt( ESCHER_Prop_fillBlip, nBlibId, sal_True );
//STRIP001 					else
//STRIP001 					{
//STRIP001 						AddOpt( ESCHER_Prop_pib, nBlibId, sal_True );
//STRIP001 						ImplCreateGraphicAttributes( rXPropSet, nBlibId, bCreateCroppingAttributes );
//STRIP001 					}
//STRIP001 					bRetValue = sal_True;
//STRIP001 				}
//STRIP001 			}
//STRIP001             else
//STRIP001             {
//STRIP001                 EscherGraphicProvider aProvider;
//STRIP001                 SvMemoryStream aMemStrm;
//STRIP001                 Rectangle aRect;
//STRIP001 
//STRIP001                 if ( aUniqueId.Len() && aProvider.GetBlibID( aMemStrm, aUniqueId, aRect, pGraphicAttr ) )
//STRIP001                 {
//STRIP001                     // grab BLIP from stream and insert directly as complex property
//STRIP001                     // ownership of stream memory goes to complex property
//STRIP001                     aMemStrm.ObjectOwnsMemory( FALSE );
//STRIP001                     sal_uInt8* pBuf = (sal_uInt8*) aMemStrm.GetData();
//STRIP001                     sal_uInt32 nSize = aMemStrm.Seek( STREAM_SEEK_TO_END );
//STRIP001                     AddOpt( ESCHER_Prop_fillBlip, sal_True, nSize, pBuf, nSize );
//STRIP001                     bRetValue = sal_True;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     delete pGraphicAttr;
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 PolyPolygon EscherPropertyContainer::GetPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rXShape )
//STRIP001 {
//STRIP001     PolyPolygon aRetPolyPoly;
//STRIP001     ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > aXPropSet;
//STRIP001     ::com::sun::star::uno::Any aAny( rXShape->queryInterface(
//STRIP001         ::getCppuType( (const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >*) 0 ) ));
//STRIP001 
//STRIP001     String sPolyPolygonBezier( RTL_CONSTASCII_USTRINGPARAM( "PolyPolygonBezier" ) );
//STRIP001     String sPolyPolygon		( RTL_CONSTASCII_USTRINGPARAM( "PolyPolygon" ) );
//STRIP001     String sPolygon		    ( RTL_CONSTASCII_USTRINGPARAM( "Polygon" ) );
//STRIP001 
//STRIP001     if ( aAny >>= aXPropSet )
//STRIP001     {
//STRIP001         sal_Bool bHasProperty = EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sPolyPolygonBezier, sal_True );
//STRIP001         if ( !bHasProperty )
//STRIP001             bHasProperty = EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sPolyPolygon, sal_True );
//STRIP001         if ( !bHasProperty )
//STRIP001             EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sPolygon, sal_True );
//STRIP001         if ( bHasProperty )
//STRIP001             aRetPolyPoly = GetPolyPolygon( aAny );
//STRIP001     }
//STRIP001     return aRetPolyPoly;
//STRIP001 }
//STRIP001 
//STRIP001 PolyPolygon EscherPropertyContainer::GetPolyPolygon( const ::com::sun::star::uno::Any& rAny )
//STRIP001 {
//STRIP001 	sal_Bool bNoError = sal_True;
//STRIP001 
//STRIP001 	Polygon aPolygon;
//STRIP001 	PolyPolygon aPolyPolygon;
//STRIP001 
//STRIP001 	if ( rAny.getValueType() == ::getCppuType( ( const ::com::sun::star::drawing::PolyPolygonBezierCoords* ) 0 ) )
//STRIP001 	{
//STRIP001 		::com::sun::star::drawing::PolyPolygonBezierCoords* pSourcePolyPolygon
//STRIP001 			= (::com::sun::star::drawing::PolyPolygonBezierCoords*)rAny.getValue();
//STRIP001 		sal_uInt16 nOuterSequenceCount = (sal_uInt16)pSourcePolyPolygon->Coordinates.getLength();
//STRIP001 
//STRIP001 		// Zeiger auf innere sequences holen
//STRIP001 		::com::sun::star::drawing::PointSequence* pOuterSequence = pSourcePolyPolygon->Coordinates.getArray();
//STRIP001 		::com::sun::star::drawing::FlagSequence*  pOuterFlags = pSourcePolyPolygon->Flags.getArray();
//STRIP001 
//STRIP001 		bNoError = pOuterSequence && pOuterFlags;
//STRIP001 		if ( bNoError )
//STRIP001 		{
//STRIP001 			sal_uInt16  a, b, nInnerSequenceCount;
//STRIP001 			::com::sun::star::awt::Point* pArray;
//STRIP001 
//STRIP001 			// dies wird ein Polygon set
//STRIP001 			for ( a = 0; a < nOuterSequenceCount; a++ )
//STRIP001 			{
//STRIP001 				::com::sun::star::drawing::PointSequence* pInnerSequence = pOuterSequence++;
//STRIP001 				::com::sun::star::drawing::FlagSequence*  pInnerFlags = pOuterFlags++;
//STRIP001 
//STRIP001 				bNoError = pInnerSequence && pInnerFlags;
//STRIP001 				if  ( bNoError )
//STRIP001 				{
//STRIP001 					// Zeiger auf Arrays holen
//STRIP001 					pArray = pInnerSequence->getArray();
//STRIP001 					::com::sun::star::drawing::PolygonFlags* pFlags = pInnerFlags->getArray();
//STRIP001 
//STRIP001 					if ( pArray && pFlags )
//STRIP001 					{
//STRIP001 						nInnerSequenceCount = (sal_uInt16)pInnerSequence->getLength();
//STRIP001 						aPolygon = Polygon( nInnerSequenceCount );
//STRIP001 						for( b = 0; b < nInnerSequenceCount; b++)
//STRIP001 						{
//STRIP001 							PolyFlags   ePolyFlags( *( (PolyFlags*)pFlags++ ) );
//STRIP001 							::com::sun::star::awt::Point aPoint( (::com::sun::star::awt::Point)*(pArray++) );
//STRIP001 							aPolygon[ b ] = Point( aPoint.X, aPoint.Y );
//STRIP001 							aPolygon.SetFlags( b, ePolyFlags );
//STRIP001 
//STRIP001 							if ( ePolyFlags == POLY_CONTROL )
//STRIP001 								continue;
//STRIP001 						}
//STRIP001 						aPolyPolygon.Insert( aPolygon, POLYPOLY_APPEND );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( rAny.getValueType() == ::getCppuType( ( const ::com::sun::star::drawing::PointSequenceSequence* ) 0 ) )
//STRIP001 	{
//STRIP001 		::com::sun::star::drawing::PointSequenceSequence* pSourcePolyPolygon
//STRIP001 			= (::com::sun::star::drawing::PointSequenceSequence*)rAny.getValue();
//STRIP001 		sal_uInt16 nOuterSequenceCount = (sal_uInt16)pSourcePolyPolygon->getLength();
//STRIP001 
//STRIP001 		// Zeiger auf innere sequences holen
//STRIP001 		::com::sun::star::drawing::PointSequence* pOuterSequence = pSourcePolyPolygon->getArray();
//STRIP001 		bNoError = pOuterSequence != NULL;
//STRIP001 		if ( bNoError )
//STRIP001 		{
//STRIP001 			sal_uInt16 a, b, nInnerSequenceCount;
//STRIP001 			::com::sun::star::awt::Point* pArray;
//STRIP001 
//STRIP001 			// dies wird ein Polygon set
//STRIP001 			for( a = 0; a < nOuterSequenceCount; a++ )
//STRIP001 			{
//STRIP001 				::com::sun::star::drawing::PointSequence* pInnerSequence = pOuterSequence++;
//STRIP001 				bNoError = pInnerSequence != NULL;
//STRIP001 				if ( bNoError )
//STRIP001 				{
//STRIP001 					// Zeiger auf Arrays holen
//STRIP001 					if ( pArray = pInnerSequence->getArray() )
//STRIP001 					{
//STRIP001 						nInnerSequenceCount = (sal_uInt16)pInnerSequence->getLength();
//STRIP001 						aPolygon = Polygon( nInnerSequenceCount );
//STRIP001 						for( b = 0; b < nInnerSequenceCount; b++)
//STRIP001 						{
//STRIP001 							aPolygon[ b ] = Point( pArray->X, pArray->Y );
//STRIP001 							pArray++;
//STRIP001 						}
//STRIP001 						aPolyPolygon.Insert( aPolygon, POLYPOLY_APPEND );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( rAny.getValueType() == ::getCppuType( ( const ::com::sun::star::drawing::PointSequence* ) 0 ) )
//STRIP001 	{
//STRIP001         ::com::sun::star::drawing::PointSequence* pInnerSequence =
//STRIP001 			(::com::sun::star::drawing::PointSequence*)rAny.getValue();
//STRIP001 
//STRIP001 		bNoError = pInnerSequence != NULL;
//STRIP001 		if ( bNoError )
//STRIP001 		{
//STRIP001 			sal_uInt16 a, nInnerSequenceCount;
//STRIP001 			::com::sun::star::awt::Point* pArray;
//STRIP001 
//STRIP001 			// Zeiger auf Arrays holen
//STRIP001 			if ( pArray = pInnerSequence->getArray() )
//STRIP001 			{
//STRIP001 				nInnerSequenceCount = (sal_uInt16)pInnerSequence->getLength();
//STRIP001 				aPolygon = Polygon( nInnerSequenceCount );
//STRIP001 				for( a = 0; a < nInnerSequenceCount; a++)
//STRIP001 				{
//STRIP001 					aPolygon[ a ] = Point( pArray->X, pArray->Y );
//STRIP001 					pArray++;
//STRIP001 				}
//STRIP001 				aPolyPolygon.Insert( aPolygon, POLYPOLY_APPEND );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aPolyPolygon;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherPropertyContainer::CreatePolygonProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 		sal_uInt32 nFlags,
//STRIP001 			sal_Bool bBezier,
//STRIP001 				::com::sun::star::awt::Rectangle& rGeoRect,
//STRIP001 					Polygon* pPolygon )
//STRIP001 {
//STRIP001 	static String sPolyPolygonBezier( RTL_CONSTASCII_USTRINGPARAM( "PolyPolygonBezier" ) );
//STRIP001 	static String sPolyPolygon		( RTL_CONSTASCII_USTRINGPARAM( "PolyPolygon" ) );
//STRIP001 
//STRIP001 	sal_Bool	bRetValue = sal_True;
//STRIP001 	sal_Bool	bLine = ( nFlags & ESCHER_CREATEPOLYGON_LINE ) != 0;
//STRIP001 
//STRIP001     PolyPolygon aPolyPolygon;
//STRIP001 
//STRIP001     if ( pPolygon )
//STRIP001         aPolyPolygon.Insert( *pPolygon, POLYPOLY_APPEND );
//STRIP001     else
//STRIP001     {
//STRIP001 		::com::sun::star::uno::Any aAny;
//STRIP001 		bRetValue = EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001 						( bBezier ) ? sPolyPolygonBezier : sPolyPolygon, sal_True );
//STRIP001 		if ( bRetValue )
//STRIP001 		{
//STRIP001 			aPolyPolygon = GetPolyPolygon( aAny );
//STRIP001 			bRetValue = aPolyPolygon.Count() != 0;
//STRIP001 		}
//STRIP001     }
//STRIP001 	if ( bRetValue )
//STRIP001 	{
//STRIP001 		if ( bLine )
//STRIP001 		{
//STRIP001 			if ( ( aPolyPolygon.Count() == 1 ) && ( aPolyPolygon[ 0 ].GetSize() == 2 ) )
//STRIP001 			{
//STRIP001 				const Polygon& rPoly = aPolyPolygon[ 0 ];
//STRIP001 				rGeoRect = ::com::sun::star::awt::Rectangle(
//STRIP001 					rPoly[ 0 ].X(),
//STRIP001 						rPoly[ 0 ].Y(),
//STRIP001 							rPoly[ 1 ].X() - rPoly[ 0 ].X(),
//STRIP001 								rPoly[ 1 ].Y() - rPoly[ 0 ].Y() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bRetValue = sal_False;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Polygon aPolygon;
//STRIP001 
//STRIP001 			sal_uInt16 i, j, k, nPoints, nBezPoints, nPolyCount = aPolyPolygon.Count();
//STRIP001 			Rectangle aRect( aPolyPolygon.GetBoundRect() );
//STRIP001 			rGeoRect = ::com::sun::star::awt::Rectangle( aRect.Left(), aRect.Top(), aRect.GetWidth(), aRect.GetHeight() );
//STRIP001 
//STRIP001 			for ( nBezPoints = nPoints = i = 0; i < nPolyCount; i++ )
//STRIP001 			{
//STRIP001 				k = aPolyPolygon[ i ].GetSize();
//STRIP001 				nPoints += k;
//STRIP001 				for ( j = 0; j < k; j++ )
//STRIP001 				{
//STRIP001 					if ( aPolyPolygon[ i ].GetFlags( j ) != POLY_CONTROL )
//STRIP001 						nBezPoints++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			sal_uInt32 nVerticesBufSize = ( nPoints << 2 ) + 6;
//STRIP001 			sal_uInt8* pVerticesBuf = new sal_uInt8[ nVerticesBufSize ];
//STRIP001 
//STRIP001 
//STRIP001 			sal_uInt32 nSegmentBufSize = ( ( nBezPoints << 2 ) + 8 );
//STRIP001 			if ( nPolyCount > 1 )
//STRIP001 				nSegmentBufSize += ( nPolyCount << 1 );
//STRIP001 			sal_uInt8* pSegmentBuf = new sal_uInt8[ nSegmentBufSize ];
//STRIP001 
//STRIP001 			sal_uInt8* pPtr = pVerticesBuf;
//STRIP001 			*pPtr++ = (sal_uInt8)( nPoints );                    // Little endian
//STRIP001 			*pPtr++ = (sal_uInt8)( nPoints >> 8 );
//STRIP001 			*pPtr++ = (sal_uInt8)( nPoints );
//STRIP001 			*pPtr++ = (sal_uInt8)( nPoints >> 8 );
//STRIP001 			*pPtr++ = (sal_uInt8)0xf0;
//STRIP001 			*pPtr++ = (sal_uInt8)0xff;
//STRIP001 
//STRIP001 			for ( j = 0; j < nPolyCount; j++ )
//STRIP001 			{
//STRIP001 				aPolygon = aPolyPolygon[ j ];
//STRIP001 				nPoints = aPolygon.GetSize();
//STRIP001 				for ( i = 0; i < nPoints; i++ )             // Punkte aus Polygon in Buffer schreiben
//STRIP001 				{
//STRIP001 					Point aPoint = aPolygon[ i ];
//STRIP001 					aPoint.X() -= rGeoRect.X;
//STRIP001 					aPoint.Y() -= rGeoRect.Y;
//STRIP001 
//STRIP001 					*pPtr++ = (sal_uInt8)( aPoint.X() );
//STRIP001 					*pPtr++ = (sal_uInt8)( aPoint.X() >> 8 );
//STRIP001 					*pPtr++ = (sal_uInt8)( aPoint.Y() );
//STRIP001 					*pPtr++ = (sal_uInt8)( aPoint.Y() >> 8 );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			pPtr = pSegmentBuf;
//STRIP001 			*pPtr++ = (sal_uInt8)( ( nSegmentBufSize - 6 ) >> 1 );
//STRIP001 			*pPtr++ = (sal_uInt8)( ( nSegmentBufSize - 6 ) >> 9 );
//STRIP001 			*pPtr++ = (sal_uInt8)( ( nSegmentBufSize - 6 ) >> 1 );
//STRIP001 			*pPtr++ = (sal_uInt8)( ( nSegmentBufSize - 6 ) >> 9 );
//STRIP001 			*pPtr++ = (sal_uInt8)2;
//STRIP001 			*pPtr++ = (sal_uInt8)0;
//STRIP001 
//STRIP001 			for ( j = 0; j < nPolyCount; j++ )
//STRIP001 			{
//STRIP001 				*pPtr++ = 0x0;          // Polygon start
//STRIP001 				*pPtr++ = 0x40;
//STRIP001 				aPolygon = aPolyPolygon[ j ];
//STRIP001 				nPoints = aPolygon.GetSize();
//STRIP001 				for ( i = 0; i < nPoints; i++ )         // Polyflags in Buffer schreiben
//STRIP001 				{
//STRIP001 					*pPtr++ = 0;
//STRIP001 					if ( bBezier )
//STRIP001 						*pPtr++ = 0xb3;
//STRIP001 					else
//STRIP001 						*pPtr++ = 0xac;
//STRIP001 					if ( ( i + 1 ) != nPoints )
//STRIP001 					{
//STRIP001 						*pPtr++ = 1;
//STRIP001 						if ( aPolygon.GetFlags( i + 1 ) == POLY_CONTROL )
//STRIP001 						{
//STRIP001 							*pPtr++ = 0x20;
//STRIP001 							i += 2;
//STRIP001 						}
//STRIP001 						else
//STRIP001 							*pPtr++ = 0;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( nPolyCount > 1 )
//STRIP001 				{
//STRIP001 					*pPtr++ = 1;                        // end of polygon
//STRIP001 					*pPtr++ = 0x60;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			*pPtr++ = 0;
//STRIP001 			*pPtr++ = 0x80;
//STRIP001 
//STRIP001 			AddOpt( ESCHER_Prop_geoRight, rGeoRect.Width );
//STRIP001 			AddOpt( ESCHER_Prop_geoBottom, rGeoRect.Height );
//STRIP001 
//STRIP001 			AddOpt( ESCHER_Prop_shapePath, ESCHER_ShapeComplex );
//STRIP001 			AddOpt( ESCHER_Prop_pVertices, TRUE, nVerticesBufSize - 6, (sal_uInt8*)pVerticesBuf, nVerticesBufSize );
//STRIP001 			AddOpt( ESCHER_Prop_pSegmentInfo, TRUE, nSegmentBufSize, (sal_uInt8*)pSegmentBuf, nSegmentBufSize );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherPropertyContainer::CreateConnectorProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rXShape,
//STRIP001 	EscherSolverContainer& rSolverContainer, ::com::sun::star::awt::Rectangle& rGeoRect,
//STRIP001 			sal_uInt16& rShapeType, sal_uInt16& rShapeFlags )
//STRIP001 {
//STRIP001 	static String sEdgeKind				( RTL_CONSTASCII_USTRINGPARAM( "EdgeKind" ) );
//STRIP001 	static String sEdgeStartPoint		( RTL_CONSTASCII_USTRINGPARAM( "EdgeStartPoint" ) );
//STRIP001 	static String sEdgeEndPoint			( RTL_CONSTASCII_USTRINGPARAM( "EdgeEndPoint" ) );
//STRIP001 	static String sEdgeStartConnection	( RTL_CONSTASCII_USTRINGPARAM( "EdgeStartConnection" ) );
//STRIP001 	static String sEdgeEndConnection	( RTL_CONSTASCII_USTRINGPARAM( "EdgeEndConnection" ) );
//STRIP001 
//STRIP001 	sal_Bool bRetValue = sal_False;
//STRIP001 	rShapeType = rShapeFlags = 0;
//STRIP001 
//STRIP001 	if ( rXShape.is() )
//STRIP001 	{
//STRIP001 		::com::sun::star::awt::Point aStartPoint, aEndPoint;
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > aXPropSet;
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > aShapeA, aShapeB;
//STRIP001 		::com::sun::star::uno::Any aAny( rXShape->queryInterface( ::getCppuType( (const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >*) 0 ) ));
//STRIP001 		if ( aAny >>= aXPropSet )
//STRIP001 		{
//STRIP001 			if ( EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sEdgeKind, sal_True ) )
//STRIP001 			{
//STRIP001 				::com::sun::star::drawing::ConnectorType eCt;
//STRIP001 				aAny >>= eCt;
//STRIP001 				if ( EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sEdgeStartPoint ) )
//STRIP001 				{
//STRIP001 					aStartPoint = *(::com::sun::star::awt::Point*)aAny.getValue();
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sEdgeEndPoint ) )
//STRIP001 					{
//STRIP001 						aEndPoint = *(::com::sun::star::awt::Point*)aAny.getValue();
//STRIP001 						sal_Bool bUseConnections = sal_True;
//STRIP001 
//STRIP001 						/* #i11701# SJ: There is a bug in our API - in Writer documents the EdgeStartPoint
//STRIP001 						and EdgeEndPoint properties are in TWIPs instead of 100TH_MM. This is also wrong
//STRIP001 						in our xml file format, but CL do not want to change the file format
//STRIP001 						before 6y and OOo2.0. So there is only following HACK which has to be removed if 
//STRIP001 						the file format is fixed by i13778#
//STRIP001 						*/
//STRIP001 						SdrObject* pCon = GetSdrObjectFromXShape( rXShape );
//STRIP001 						if ( pCon )
//STRIP001 						{
//STRIP001 							SdrModel* pMod = pCon->GetModel();
//STRIP001 							if ( pMod && ( pMod->GetScaleUnit() == MAP_TWIP ) )
//STRIP001 							{
//STRIP001 								Point aStart( OutputDevice::LogicToLogic( Point( aStartPoint.X, aStartPoint.Y ), MAP_TWIP, MAP_100TH_MM ) );
//STRIP001 								Point aEnd( OutputDevice::LogicToLogic( Point( aEndPoint.X, aEndPoint.Y ), MAP_TWIP, MAP_100TH_MM ) );
//STRIP001 								aStartPoint = ::com::sun::star::awt::Point( aStart.X(), aStart.Y() );
//STRIP001 								aEndPoint = ::com::sun::star::awt::Point( aEnd.X(), aEnd.Y() );
//STRIP001 								bUseConnections = sal_False;
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						rShapeFlags = SHAPEFLAG_HAVEANCHOR | SHAPEFLAG_HAVESPT;
//STRIP001 						rGeoRect = ::com::sun::star::awt::Rectangle( aStartPoint.X, aStartPoint.Y,
//STRIP001 															( aEndPoint.X - aStartPoint.X ) + 1, ( aEndPoint.Y - aStartPoint.Y ) + 1 );
//STRIP001 						if ( rGeoRect.Height < 0 )			// justify
//STRIP001 						{
//STRIP001 							rShapeFlags |= SHAPEFLAG_FLIPV;
//STRIP001 							rGeoRect.Y = aEndPoint.Y;
//STRIP001 							rGeoRect.Height = -rGeoRect.Height;
//STRIP001 						}
//STRIP001 						if ( rGeoRect.Width < 0 )
//STRIP001 						{
//STRIP001 							rShapeFlags |= SHAPEFLAG_FLIPH;
//STRIP001 							rGeoRect.X = aEndPoint.X;
//STRIP001 							rGeoRect.Width = -rGeoRect.Width;
//STRIP001 						}
//STRIP001 						sal_uInt32 nAdjustValue1, nAdjustValue2, nAdjustValue3;
//STRIP001 						nAdjustValue1 = nAdjustValue2 = nAdjustValue3 = 0x2a30;
//STRIP001 
//STRIP001 						if( bUseConnections )
//STRIP001 						{
//STRIP001 							if ( EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sEdgeStartConnection ) )
//STRIP001 								aAny >>= aShapeA;
//STRIP001 							if ( EscherPropertyValueHelper::GetPropertyValue( aAny, aXPropSet, sEdgeEndConnection ) )
//STRIP001 								aAny >>= aShapeB;
//STRIP001 						}
//STRIP001 /*
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeLine1Delta" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeLine2Delta" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeLine3Delta" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeNode1HorzDist" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeNode1VertDist" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeNode2HorzDist" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 						if ( ImplGetPropertyValue( String( RTL_CONSTASCII_USTRINGPARAM( "EdgeNode2VertDist" ) ) ) )
//STRIP001 						{
//STRIP001 						}
//STRIP001 */
//STRIP001 						rSolverContainer.AddConnector( rXShape, aStartPoint, aShapeA, aEndPoint, aShapeB );
//STRIP001 						switch ( eCt )
//STRIP001 						{
//STRIP001 							case ::com::sun::star::drawing::ConnectorType_CURVE :
//STRIP001 							{
//STRIP001 								rShapeType = ESCHER_ShpInst_CurvedConnector3;
//STRIP001 								AddOpt( ESCHER_Prop_cxstyle, ESCHER_cxstyleCurved );
//STRIP001 								AddOpt( ESCHER_Prop_adjustValue, nAdjustValue1 );
//STRIP001 								AddOpt( ESCHER_Prop_adjust2Value, -(sal_Int32)nAdjustValue2 );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 							case ::com::sun::star::drawing::ConnectorType_STANDARD :// Connector 2->5
//STRIP001 							{
//STRIP001 								rShapeType = ESCHER_ShpInst_BentConnector3;
//STRIP001 								AddOpt( ESCHER_Prop_cxstyle, ESCHER_cxstyleBent );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 							default:
//STRIP001 							case ::com::sun::star::drawing::ConnectorType_LINE :
//STRIP001 							case ::com::sun::star::drawing::ConnectorType_LINES :	// Connector 2->5
//STRIP001 							{
//STRIP001 								rShapeFlags |= SHAPEFLAG_CONNECTOR;
//STRIP001 								rShapeType = ESCHER_ShpInst_StraightConnector1;
//STRIP001 								AddOpt( ESCHER_Prop_cxstyle, ESCHER_cxstyleStraight );
//STRIP001 							}
//STRIP001 							break;
//STRIP001 						}
//STRIP001 						CreateLineProperties( aXPropSet, sal_False );
//STRIP001 						bRetValue = bSuppressRotation = sal_True;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherPropertyContainer::CreateShadowProperties(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Any aAny;
//STRIP001 
//STRIP001 	sal_Bool	bHasShadow = sal_False;	// shadow is possible only if at least a fillcolor or linecolor is set
//STRIP001 	sal_uInt32	nLineFlags = 0;			// default : shape has no line
//STRIP001 	sal_uInt32	nFillFlags = 0x10;		//			 shape is filled
//STRIP001 
//STRIP001 	GetOpt( ESCHER_Prop_fNoLineDrawDash, nLineFlags );
//STRIP001 	GetOpt( ESCHER_Prop_fNoFillHitTest, nFillFlags );
//STRIP001 
//STRIP001 	if ( ( nLineFlags & 8 ) || ( nFillFlags & 0x10 ) )
//STRIP001 	{
//STRIP001 		if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001 				String( RTL_CONSTASCII_USTRINGPARAM( "Shadow" ) ), sal_True ) )
//STRIP001 		{
//STRIP001 			sal_Bool bBool;
//STRIP001 			if ( aAny >>= bBool )
//STRIP001             {
//STRIP001 				if ( bBool )
//STRIP001 				{
//STRIP001 					bHasShadow = sal_True;
//STRIP001 					AddOpt( ESCHER_Prop_fshadowObscured, 0x20002 );
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001 							String( RTL_CONSTASCII_USTRINGPARAM( "ShadowColor" ) ), sal_False ) )
//STRIP001 						AddOpt( ESCHER_Prop_shadowColor, ImplGetColor( *((sal_uInt32*)aAny.getValue()) ) );
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001 							String( RTL_CONSTASCII_USTRINGPARAM( "ShadowXDistance" ) ), sal_False ) )
//STRIP001 						AddOpt( ESCHER_Prop_shadowOffsetX, *((sal_Int32*)aAny.getValue()) * 360 );
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001 							String( RTL_CONSTASCII_USTRINGPARAM( "ShadowYDistance" ) ), sal_False ) )
//STRIP001 						AddOpt( ESCHER_Prop_shadowOffsetY, *((sal_Int32*)aAny.getValue()) * 360 );
//STRIP001 					if ( EscherPropertyValueHelper::GetPropertyValue( aAny, rXPropSet,
//STRIP001 							String( RTL_CONSTASCII_USTRINGPARAM( "ShadowTransparence" ) ), sal_False ) )
//STRIP001 						AddOpt( ESCHER_Prop_shadowOpacity,  ( ( ( 100 - (*((sal_uInt16*)aAny.getValue()) ) ) << 16 ) / 100 ) );
//STRIP001 				}
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001 	return bHasShadow;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherPersistTable::EscherPersistTable()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherPersistTable::~EscherPersistTable()
//STRIP001 {
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 		delete (EscherPersistEntry*)pPtr;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherPersistTable::PtIsID( UINT32 nID )
//STRIP001 {
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 	{
//STRIP001 		if ( ((EscherPersistEntry*)pPtr)->mnID == nID )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherPersistTable::PtInsert( UINT32 nID, UINT32 nOfs )
//STRIP001 {
//STRIP001 	maPersistTable.Insert( new EscherPersistEntry( nID, nOfs ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherPersistTable::PtDelete( UINT32 nID )
//STRIP001 {
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 	{
//STRIP001 		if ( ((EscherPersistEntry*)pPtr)->mnID == nID )
//STRIP001 		{
//STRIP001 			UINT32 nRetValue = ((EscherPersistEntry*)pPtr)->mnOffset;
//STRIP001 			delete (EscherPersistEntry*) maPersistTable.Remove();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherPersistTable::PtGetOffsetByID( UINT32 nID )
//STRIP001 {
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 	{
//STRIP001 		if ( ((EscherPersistEntry*)pPtr)->mnID == nID )
//STRIP001 			return ((EscherPersistEntry*)pPtr)->mnOffset;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 };
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherPersistTable::PtReplace( UINT32 nID, UINT32 nOfs )
//STRIP001 {
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 	{
//STRIP001 		if ( ((EscherPersistEntry*)pPtr)->mnID == nID )
//STRIP001 		{
//STRIP001 			UINT32 nRetValue = ((EscherPersistEntry*)pPtr)->mnOffset;
//STRIP001 			((EscherPersistEntry*)pPtr)->mnOffset = nOfs;
//STRIP001 			return nRetValue;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherPersistTable::PtReplaceOrInsert( UINT32 nID, UINT32 nOfs )
//STRIP001 {
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 	{
//STRIP001 		if ( ((EscherPersistEntry*)pPtr)->mnID == nID )
//STRIP001 		{
//STRIP001 			UINT32 nRetValue = ((EscherPersistEntry*)pPtr)->mnOffset;
//STRIP001 			((EscherPersistEntry*)pPtr)->mnOffset = nOfs;
//STRIP001 			return nRetValue;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	PtInsert( nID, nOfs );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherPropertyValueHelper::GetPropertyValue(
//STRIP001 	::com::sun::star::uno::Any& rAny,
//STRIP001 		const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 			const String& rString,
//STRIP001 					sal_Bool bTestPropertyAvailability )
//STRIP001 {
//STRIP001     sal_Bool bRetValue = sal_True;
//STRIP001 	if ( bTestPropertyAvailability )
//STRIP001 	{
//STRIP001 		bRetValue = sal_False;
//STRIP001 		try
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo >
//STRIP001 				aXPropSetInfo( rXPropSet->getPropertySetInfo() );
//STRIP001 			if ( aXPropSetInfo.is() )
//STRIP001 				bRetValue = aXPropSetInfo->hasPropertyByName( rString );
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 			bRetValue = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( bRetValue )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			rAny = rXPropSet->getPropertyValue( rString );
//STRIP001 			if ( !rAny.hasValue() )
//STRIP001 				bRetValue = sal_False;
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 			bRetValue = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001     return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 ::com::sun::star::beans::PropertyState EscherPropertyValueHelper::GetPropertyState(
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 		const String& rPropertyName )
//STRIP001 {
//STRIP001 	::com::sun::star::beans::PropertyState eRetValue = ::com::sun::star::beans::PropertyState_AMBIGUOUS_VALUE;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyState >	aXPropState
//STRIP001 				( rXPropSet, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 		if ( aXPropState.is() )
//STRIP001             eRetValue = aXPropState->getPropertyState( rPropertyName );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		//...
//STRIP001 	}
//STRIP001 	return eRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherBlibEntry::EscherBlibEntry( sal_uInt32 nPictureOffset, const GraphicObject& rObject, const ByteString& rId,
//STRIP001 										const GraphicAttr* pGraphicAttr ) :
//STRIP001 	mbIsEmpty		( TRUE ),
//STRIP001 	mnPictureOffset ( nPictureOffset ),
//STRIP001 	mnRefCount		( 1 ),
//STRIP001 	mnSizeExtra		( 0 ),
//STRIP001 	maPrefSize		( rObject.GetPrefSize() ),
//STRIP001 	maPrefMapMode	( rObject.GetPrefMapMode() )
//STRIP001 {
//STRIP001 	mbIsNativeGraphicPossible = ( pGraphicAttr == NULL );
//STRIP001 	meBlibType = UNKNOWN;
//STRIP001 	mnSize = 0;
//STRIP001 
//STRIP001 	sal_uInt32		nLen = rId.Len();
//STRIP001 	const sal_Char* pData = rId.GetBuffer();
//STRIP001 	GraphicType		eType( rObject.GetType() );
//STRIP001 	if ( nLen && pData && ( eType != GRAPHIC_NONE ) )
//STRIP001 	{
//STRIP001 		mnIdentifier[ 0 ] = rtl_crc32( 0,pData, nLen );
//STRIP001 		mnIdentifier[ 1 ] = 0;
//STRIP001 
//STRIP001 		if ( pGraphicAttr )
//STRIP001 		{
//STRIP001 			if ( pGraphicAttr->IsSpecialDrawMode()
//STRIP001 					|| pGraphicAttr->IsMirrored()
//STRIP001 						 || pGraphicAttr->IsCropped()
//STRIP001 							|| pGraphicAttr->IsRotated()
//STRIP001 								|| pGraphicAttr->IsTransparent()
//STRIP001 									|| pGraphicAttr->IsAdjusted() )
//STRIP001 			{
//STRIP001 				SvMemoryStream aSt( sizeof( GraphicAttr ) );
//STRIP001 				aSt << (sal_uInt16)pGraphicAttr->GetDrawMode()
//STRIP001 					<< pGraphicAttr->GetMirrorFlags()
//STRIP001 					<< pGraphicAttr->GetLeftCrop()
//STRIP001 					<< pGraphicAttr->GetTopCrop()
//STRIP001 					<< pGraphicAttr->GetRightCrop()
//STRIP001 					<< pGraphicAttr->GetBottomCrop()
//STRIP001 					<< pGraphicAttr->GetRotation()
//STRIP001 					<< pGraphicAttr->GetLuminance()
//STRIP001 					<< pGraphicAttr->GetContrast()
//STRIP001 					<< pGraphicAttr->GetChannelR()
//STRIP001 					<< pGraphicAttr->GetChannelG()
//STRIP001 					<< pGraphicAttr->GetChannelB()
//STRIP001 					<< pGraphicAttr->GetGamma()
//STRIP001 					<< (BOOL)( pGraphicAttr->IsInvert() == TRUE )
//STRIP001 					<< pGraphicAttr->GetTransparency();
//STRIP001 				mnIdentifier[ 1 ] = rtl_crc32( 0, aSt.GetData(), aSt.Tell() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				mbIsNativeGraphicPossible = TRUE;
//STRIP001 		}
//STRIP001 		sal_uInt32 i, nTmp, n1, n2;
//STRIP001 		n1 = n2 = 0;
//STRIP001 		for ( i = 0; i < nLen; i++ )
//STRIP001 		{
//STRIP001 			nTmp = n2 >> 28;	// rotating 4 bit
//STRIP001 			n2 <<= 4;
//STRIP001 			n2 |= n1 >> 28;
//STRIP001 			n1 <<= 4;
//STRIP001 			n1 |= nTmp;
//STRIP001 			n1 ^= *pData++ - '0';
//STRIP001 		}
//STRIP001 		mnIdentifier[ 2 ] = n1;
//STRIP001 		mnIdentifier[ 3 ] = n2;
//STRIP001 		mbIsEmpty = FALSE;
//STRIP001 	}
//STRIP001 };
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherBlibEntry::WriteBlibEntry( SvStream& rSt, sal_Bool bWritePictureOffset, sal_uInt32 nResize )
//STRIP001 {
//STRIP001 	sal_uInt8	nBlibType = meBlibType;
//STRIP001 	sal_uInt32	nPictureOffset = ( bWritePictureOffset ) ? mnPictureOffset : 0;
//STRIP001 
//STRIP001 	rSt << (sal_uInt32)( ( ESCHER_BSE << 16 ) | ( ( (sal_uInt16)meBlibType << 4 ) | 2 ) )
//STRIP001 		<< (sal_uInt32)( 36 + nResize )
//STRIP001 		<< (sal_uInt8)meBlibType;
//STRIP001 
//STRIP001 	switch ( meBlibType )
//STRIP001 	{
//STRIP001 		case EMF :
//STRIP001 		case WMF :	// EMF/WMF auf OS2 zu Pict Konvertieren
//STRIP001 			rSt << (sal_uInt8)PICT;
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 			rSt << (sal_uInt8)meBlibType;
//STRIP001 	};
//STRIP001 
//STRIP001 	rSt.Write( &mnIdentifier[ 0 ], 16 );
//STRIP001 	rSt << (sal_uInt16)0
//STRIP001 		<< (sal_uInt32)( mnSize + mnSizeExtra )
//STRIP001 		<< mnRefCount
//STRIP001 		<< nPictureOffset
//STRIP001 		<< (sal_uInt32)0;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherBlibEntry::~EscherBlibEntry()
//STRIP001 {
//STRIP001 };
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherBlibEntry::operator==( const EscherBlibEntry& rEscherBlibEntry ) const
//STRIP001 {
//STRIP001 	for ( int i = 0; i < 3; i++ )
//STRIP001 	{
//STRIP001 		if ( mnIdentifier[ i ] != rEscherBlibEntry.mnIdentifier[ i ] )
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherGraphicProvider::EscherGraphicProvider( sal_uInt32 nFlags ) :
//STRIP001 	mnFlags			( nFlags ),
//STRIP001 	mpBlibEntrys	( NULL ),
//STRIP001 	mnBlibBufSize	( 0 ),
//STRIP001 	mnBlibEntrys	( 0 )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 EscherGraphicProvider::~EscherGraphicProvider()
//STRIP001 {
//STRIP001 	for ( UINT32 i = 0; i < mnBlibEntrys; delete mpBlibEntrys[ i++ ] );
//STRIP001 	delete[] mpBlibEntrys;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherGraphicProvider::SetNewBlipStreamOffset( sal_Int32 nOffset )
//STRIP001 {
//STRIP001 	for( sal_uInt32 i = 0; i < mnBlibEntrys; i++ )
//STRIP001 	{
//STRIP001 		EscherBlibEntry* pBlibEntry = mpBlibEntrys[ i ];
//STRIP001 		pBlibEntry->mnPictureOffset += nOffset;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 UINT32 EscherGraphicProvider::ImplInsertBlib( EscherBlibEntry* p_EscherBlibEntry )
//STRIP001 {
//STRIP001 	if ( mnBlibBufSize == mnBlibEntrys )
//STRIP001 	{
//STRIP001 		mnBlibBufSize += 64;
//STRIP001 		EscherBlibEntry** pTemp = new EscherBlibEntry*[ mnBlibBufSize ];
//STRIP001 		for ( UINT32 i = 0; i < mnBlibEntrys; i++ )
//STRIP001 		{
//STRIP001 			pTemp[ i ] = mpBlibEntrys[ i ];
//STRIP001 		}
//STRIP001 		delete[] mpBlibEntrys;
//STRIP001 		mpBlibEntrys = pTemp;
//STRIP001 	}
//STRIP001 	mpBlibEntrys[ mnBlibEntrys++ ] = p_EscherBlibEntry;
//STRIP001 	return mnBlibEntrys;
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt32 EscherGraphicProvider::GetBlibStoreContainerSize( SvStream* pMergePicStreamBSE ) const
//STRIP001 {
//STRIP001 	sal_uInt32 nSize = 44 * mnBlibEntrys + 8;
//STRIP001 	if ( pMergePicStreamBSE )
//STRIP001 	{
//STRIP001 		for ( sal_uInt32 i = 0; i < mnBlibEntrys; i++ )
//STRIP001 			nSize += mpBlibEntrys[ i ]->mnSize + mpBlibEntrys[ i ]->mnSizeExtra;
//STRIP001 	}
//STRIP001 	return nSize;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherGraphicProvider::WriteBlibStoreEntry(SvStream& rSt,
//STRIP001     sal_uInt32 nBlipId, sal_Bool bWritePictureOffSet, sal_uInt32 nResize)
//STRIP001 {
//STRIP001     if (nBlipId > mnBlibEntrys || nBlipId == 0)
//STRIP001         return sal_False;
//STRIP001     mpBlibEntrys[nBlipId-1]->WriteBlibEntry(rSt, bWritePictureOffSet, nResize);
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherGraphicProvider::WriteBlibStoreContainer( SvStream& rSt, SvStream* pMergePicStreamBSE )
//STRIP001 {
//STRIP001 	sal_uInt32	nSize = GetBlibStoreContainerSize( pMergePicStreamBSE );
//STRIP001 	if ( nSize )
//STRIP001 	{
//STRIP001 		rSt << (sal_uInt32)( ( ESCHER_BstoreContainer << 16 ) | 0x1f )
//STRIP001 			<< (sal_uInt32)( nSize - 8 );
//STRIP001 
//STRIP001 		if ( pMergePicStreamBSE )
//STRIP001 		{
//STRIP001 			sal_uInt32 i, nBlipSize, nOldPos = pMergePicStreamBSE->Tell();
//STRIP001 			const nBuf = 0x40000;	// 256KB buffer
//STRIP001 			sal_uInt8* pBuf = new sal_uInt8[ nBuf ];
//STRIP001 
//STRIP001 			for ( i = 0; i < mnBlibEntrys; i++ )
//STRIP001 			{
//STRIP001 				EscherBlibEntry* pBlibEntry = mpBlibEntrys[ i ];
//STRIP001 
//STRIP001 				sal_uInt8 nBlibType = pBlibEntry->meBlibType;
//STRIP001 				nBlipSize = pBlibEntry->mnSize + pBlibEntry->mnSizeExtra;
//STRIP001 				pBlibEntry->WriteBlibEntry( rSt, sal_False, nBlipSize );
//STRIP001 
//STRIP001 				// BLIP
//STRIP001 				pMergePicStreamBSE->Seek( pBlibEntry->mnPictureOffset );
//STRIP001 				UINT16 n16;
//STRIP001 				// record version and instance
//STRIP001 				*pMergePicStreamBSE >> n16;
//STRIP001 				rSt << n16;
//STRIP001 				// record type
//STRIP001 				*pMergePicStreamBSE >> n16;
//STRIP001 				rSt << UINT16( ESCHER_BlipFirst + nBlibType );
//STRIP001 				DBG_ASSERT( n16 == ESCHER_BlipFirst + nBlibType , "EscherEx::Flush: BLIP record types differ" );
//STRIP001 				UINT32 n32;
//STRIP001 				// record size
//STRIP001 				*pMergePicStreamBSE >> n32;
//STRIP001 				nBlipSize -= 8;
//STRIP001 				rSt << nBlipSize;
//STRIP001 				DBG_ASSERT( nBlipSize == n32, "EscherEx::Flush: BLIP sizes differ" );
//STRIP001 				// record
//STRIP001 				while ( nBlipSize )
//STRIP001 				{
//STRIP001 					UINT32 nBytes = ( nBlipSize > nBuf ? nBuf : nBlipSize );
//STRIP001 					pMergePicStreamBSE->Read( pBuf, nBytes );
//STRIP001 					rSt.Write( pBuf, nBytes );
//STRIP001 					nBlipSize -= nBytes;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			delete[] pBuf;
//STRIP001 			pMergePicStreamBSE->Seek( nOldPos );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             for ( sal_uInt32 i = 0; i < mnBlibEntrys; i++ )
//STRIP001                 mpBlibEntrys[ i ]->WriteBlibEntry( rSt, sal_True );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool EscherGraphicProvider::GetPrefSize( const sal_uInt32 nBlibId, Size& rPrefSize, MapMode& rPrefMapMode )
//STRIP001 {
//STRIP001 	sal_Bool bInRange = nBlibId && ( ( nBlibId - 1 ) < mnBlibEntrys );
//STRIP001 	if ( bInRange )
//STRIP001 	{
//STRIP001 		EscherBlibEntry* pEntry = mpBlibEntrys[ nBlibId - 1 ];
//STRIP001 		rPrefSize = pEntry->maPrefSize;
//STRIP001 		rPrefMapMode = pEntry->maPrefMapMode;
//STRIP001 	}
//STRIP001 	return bInRange;
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt32 EscherGraphicProvider::GetBlibID( SvStream& rPicOutStrm, const ByteString& rId,
//STRIP001 												const Rectangle& rBoundRect, const GraphicAttr* pGraphicAttr )
//STRIP001 {
//STRIP001 	sal_uInt32			nBlibId = 0;
//STRIP001 	GraphicObject		aGraphicObject( rId );
//STRIP001 
//STRIP001 	EscherBlibEntry* p_EscherBlibEntry = new EscherBlibEntry( rPicOutStrm.Tell(), aGraphicObject, rId, pGraphicAttr );
//STRIP001 	if ( !p_EscherBlibEntry->IsEmpty() )
//STRIP001 	{
//STRIP001 		for ( UINT32 i = 0; i < mnBlibEntrys; i++ )
//STRIP001 		{
//STRIP001 			if ( *( mpBlibEntrys[ i ] )	== *p_EscherBlibEntry )
//STRIP001 			{
//STRIP001 				mpBlibEntrys[ i ]->mnRefCount++;
//STRIP001 				delete p_EscherBlibEntry;
//STRIP001 				return i + 1;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		sal_Bool			bUseNativeGraphic( FALSE );
//STRIP001 
//STRIP001 		Graphic				aGraphic( aGraphicObject.GetTransformedGraphic( pGraphicAttr ) );
//STRIP001 		GfxLink				aGraphicLink;
//STRIP001 		SvMemoryStream		aStream;
//STRIP001 
//STRIP001 		const sal_uInt8*	pGraphicAry = NULL;
//STRIP001 
//STRIP001 		if ( p_EscherBlibEntry->mbIsNativeGraphicPossible && aGraphic.IsLink() )
//STRIP001 		{
//STRIP001 			aGraphicLink = aGraphic.GetLink();
//STRIP001 
//STRIP001 			p_EscherBlibEntry->mnSize = aGraphicLink.GetDataSize();
//STRIP001 			pGraphicAry = aGraphicLink.GetData();
//STRIP001 
//STRIP001 			if ( p_EscherBlibEntry->mnSize && pGraphicAry )
//STRIP001 			{
//STRIP001 				switch ( aGraphicLink.GetType() )
//STRIP001 				{
//STRIP001 					case GFX_LINK_TYPE_NATIVE_JPG : p_EscherBlibEntry->meBlibType = PEG; break;
//STRIP001 					case GFX_LINK_TYPE_NATIVE_PNG : p_EscherBlibEntry->meBlibType = PNG; break;
//STRIP001 					case GFX_LINK_TYPE_NATIVE_WMF :
//STRIP001 					{
//STRIP001 						if ( pGraphicAry && ( p_EscherBlibEntry->mnSize > 0x2c ) )
//STRIP001 						{
//STRIP001 							if ( ( pGraphicAry[ 0x28 ] == 0x20 ) && ( pGraphicAry[ 0x29 ] == 0x45 )		// check the magic
//STRIP001 								&& ( pGraphicAry[ 0x2a ] == 0x4d ) && ( pGraphicAry[ 0x2b ] == 0x46 ) )	// number ( emf detection )
//STRIP001 							{
//STRIP001 								p_EscherBlibEntry->meBlibType = EMF;
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								p_EscherBlibEntry->meBlibType = WMF;
//STRIP001 								if ( ( pGraphicAry[ 0 ] == 0xd7 ) && ( pGraphicAry[ 1 ] == 0xcd )
//STRIP001 									&& ( pGraphicAry[ 2 ] == 0xc6 ) && ( pGraphicAry[ 3 ] == 0x9a ) )
//STRIP001 								{	// we have to get rid of the metafileheader
//STRIP001 									pGraphicAry += 22;
//STRIP001 									p_EscherBlibEntry->mnSize -= 22;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				if ( p_EscherBlibEntry->meBlibType != UNKNOWN )
//STRIP001 					bUseNativeGraphic = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( !bUseNativeGraphic )
//STRIP001 		{
//STRIP001 			GraphicType eGraphicType = aGraphic.GetType();
//STRIP001 			if ( ( eGraphicType == GRAPHIC_BITMAP ) || ( eGraphicType == GRAPHIC_GDIMETAFILE ) )
//STRIP001 			{
//STRIP001 				sal_uInt32 nErrCode;
//STRIP001 				if ( !aGraphic.IsAnimated() )
//STRIP001 					nErrCode = GraphicConverter::Export( aStream, aGraphic, ( eGraphicType == GRAPHIC_BITMAP ) ? CVT_PNG  : CVT_WMF );
//STRIP001 				else
//STRIP001 				{	// to store a animation, a gif has to be included into the msOG chunk of a png	#I5583#
//STRIP001 					GraphicFilter*	pFilter = GetGrfFilter();
//STRIP001 					SvMemoryStream  aGIFStream;
//STRIP001 					ByteString		aVersion( "MSOFFICE9.0" );
//STRIP001 					aGIFStream.Write( aVersion.GetBuffer(), aVersion.Len() );
//STRIP001 					nErrCode = pFilter->ExportGraphic( aGraphic, String(), aGIFStream, 
//STRIP001 						pFilter->GetExportFormatNumberForShortName( String( RTL_CONSTASCII_USTRINGPARAM( "GIF" ) ) ), sal_False, NULL );
//STRIP001 					::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > aFilterData( 1 );
//STRIP001 					::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > aAdditionalChunkSequence( 1 );
//STRIP001 					sal_uInt32 nGIFSreamLen = aGIFStream.Tell();
//STRIP001 					::com::sun::star::uno::Sequence< sal_Int8 > aGIFSeq( nGIFSreamLen );
//STRIP001 					sal_Int8* pSeq = aGIFSeq.getArray();
//STRIP001 					aGIFStream.Seek( STREAM_SEEK_TO_BEGIN );
//STRIP001 					aGIFStream.Read( pSeq, nGIFSreamLen );
//STRIP001 					::com::sun::star::beans::PropertyValue aChunkProp, aFilterProp;
//STRIP001 					aChunkProp.Name = String( RTL_CONSTASCII_USTRINGPARAM( "msOG" ) );
//STRIP001 					aChunkProp.Value <<= aGIFSeq;
//STRIP001 					aAdditionalChunkSequence[ 0 ] = aChunkProp;
//STRIP001 					aFilterProp.Name = String( RTL_CONSTASCII_USTRINGPARAM( "AdditionalChunks" ) );
//STRIP001 					aFilterProp.Value <<= aAdditionalChunkSequence;
//STRIP001 					aFilterData[ 0 ] = aFilterProp;
//STRIP001 					nErrCode = pFilter->ExportGraphic( aGraphic, String(), aStream,
//STRIP001 						pFilter->GetExportFormatNumberForShortName( String( RTL_CONSTASCII_USTRINGPARAM( "PNG" ) ) ), sal_False,
//STRIP001 							&aFilterData );
//STRIP001 				}
//STRIP001 				if ( nErrCode == ERRCODE_NONE )
//STRIP001 				{
//STRIP001 					p_EscherBlibEntry->meBlibType = ( eGraphicType == GRAPHIC_BITMAP ) ? PNG : WMF;
//STRIP001 					aStream.Seek( STREAM_SEEK_TO_END );
//STRIP001 					p_EscherBlibEntry->mnSize = aStream.Tell();
//STRIP001 					pGraphicAry = (sal_uInt8*)aStream.GetData();
//STRIP001 
//STRIP001 					if ( p_EscherBlibEntry->meBlibType == WMF )		// the fileheader is not used
//STRIP001 					{
//STRIP001 						p_EscherBlibEntry->mnSize -= 22;
//STRIP001 						pGraphicAry += 22;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		ESCHER_BlibType	eBlibType = p_EscherBlibEntry->meBlibType;
//STRIP001 		if ( p_EscherBlibEntry->mnSize && pGraphicAry && ( eBlibType != UNKNOWN ) )
//STRIP001 		{
//STRIP001 			sal_uInt32 nExtra, nAtomSize = 0;
//STRIP001 			sal_uInt32 nInstance, nUncompressedSize = p_EscherBlibEntry->mnSize;
//STRIP001 
//STRIP001 			if ( mnFlags & _E_GRAPH_PROV_USE_INSTANCES )
//STRIP001 			{
//STRIP001 				rPicOutStrm << (UINT32)( 0x7f90000 | (UINT16)( mnBlibEntrys << 4 ) )
//STRIP001 							<< (UINT32)0;
//STRIP001 				nAtomSize = rPicOutStrm.Tell();
//STRIP001  				if ( eBlibType == PNG )
//STRIP001 					rPicOutStrm << (sal_uInt16)0x0606;
//STRIP001 				else if ( eBlibType == WMF )
//STRIP001 					rPicOutStrm << (sal_uInt16)0x0403;
//STRIP001 				else if ( eBlibType == PEG )
//STRIP001 					rPicOutStrm << (sal_uInt16)0x0505;
//STRIP001 			}
//STRIP001 			if ( ( eBlibType == PEG ) || ( eBlibType == PNG ) )
//STRIP001 			{
//STRIP001 				nExtra = 17;
//STRIP001 				p_EscherBlibEntry->mnSizeExtra = nExtra + 8;
//STRIP001 				nInstance = ( eBlibType == PNG ) ? 0xf01e6e00 : 0xf01d46a0;
//STRIP001 				rPicOutStrm << nInstance << (sal_uInt32)( p_EscherBlibEntry->mnSize + nExtra );
//STRIP001 				rPicOutStrm.Write( p_EscherBlibEntry->mnIdentifier, 16 );
//STRIP001 				rPicOutStrm << (sal_uInt8)0xff;
//STRIP001 				rPicOutStrm.Write( pGraphicAry, p_EscherBlibEntry->mnSize );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ZCodec aZCodec( 0x8000, 0x8000 );
//STRIP001 				aZCodec.BeginCompression();
//STRIP001 				SvMemoryStream aDestStrm;
//STRIP001 				aZCodec.Write( aDestStrm, pGraphicAry, p_EscherBlibEntry->mnSize );
//STRIP001 				aZCodec.EndCompression();
//STRIP001 				aDestStrm.Seek( STREAM_SEEK_TO_END );
//STRIP001 				p_EscherBlibEntry->mnSize = aDestStrm.Tell();
//STRIP001 				pGraphicAry = (sal_uInt8*)aDestStrm.GetData();
//STRIP001 				if ( p_EscherBlibEntry->mnSize && pGraphicAry )
//STRIP001 				{
//STRIP001 					nExtra = ( eBlibType == WMF ) ? 0x42 : 0x32;
//STRIP001 					p_EscherBlibEntry->mnSizeExtra = nExtra + 8;
//STRIP001 					nInstance = ( eBlibType == WMF ) ? 0xf01b2170 : 0xf01a3d40;
//STRIP001 					rPicOutStrm << nInstance << (sal_uInt32)( p_EscherBlibEntry->mnSize + nExtra );
//STRIP001 					if ( eBlibType == WMF )
//STRIP001 						rPicOutStrm.Write( p_EscherBlibEntry->mnIdentifier, 16 );
//STRIP001 					rPicOutStrm.Write( p_EscherBlibEntry->mnIdentifier, 16 );
//STRIP001 
//STRIP001                     /*
//STRIP001                      ##913##
//STRIP001                      For Word the stored size of the graphic is critical the
//STRIP001                      metafile boundaries must match the actual graphics
//STRIP001                      boundaries, and the width and height must be in EMU's
//STRIP001 
//STRIP001                      If you don't do it this way then objects edited in the
//STRIP001                      msoffice app may show strange behaviour as the size jumps
//STRIP001                      around, and the original size and scaling factor in word
//STRIP001                      will be a very strange figure
//STRIP001                     */
//STRIP001                     UINT32 nPrefWidth = p_EscherBlibEntry->maPrefSize.Width();
//STRIP001                     UINT32 nPrefHeight = p_EscherBlibEntry->maPrefSize.Height();
//STRIP001                     Size aPrefSize(lcl_SizeToEmu(p_EscherBlibEntry->maPrefSize, p_EscherBlibEntry->maPrefMapMode));
//STRIP001                     UINT32 nWidth = aPrefSize.Width() * 360;
//STRIP001                     UINT32 nHeight = aPrefSize.Height() * 360;
//STRIP001 
//STRIP001                     rPicOutStrm	<< nUncompressedSize // WMFSize without FileHeader
//STRIP001                     << (sal_Int32)0		// da die Originalgroesse des WMF's (ohne FileHeader)
//STRIP001                     << (sal_Int32)0		// nicht mehr feststellbar ist, schreiben wir 10cm / x
//STRIP001                     << nPrefWidth
//STRIP001                     << nPrefHeight
//STRIP001                     << nWidth
//STRIP001                     << nHeight
//STRIP001                     << p_EscherBlibEntry->mnSize
//STRIP001                     << (sal_uInt16)0xfe00;	// compression Flags
//STRIP001                     rPicOutStrm.Write( pGraphicAry, p_EscherBlibEntry->mnSize );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if ( nAtomSize )
//STRIP001 			{
//STRIP001 				sal_uInt32	nPos = rPicOutStrm.Tell();
//STRIP001 				rPicOutStrm.Seek( nAtomSize - 4 );
//STRIP001 				rPicOutStrm << (sal_uInt32)( nPos - nAtomSize );
//STRIP001 				rPicOutStrm.Seek( nPos );
//STRIP001 			}
//STRIP001 			nBlibId = ImplInsertBlib( p_EscherBlibEntry ), p_EscherBlibEntry = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( p_EscherBlibEntry )
//STRIP001 		delete p_EscherBlibEntry;
//STRIP001 	return nBlibId;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 struct EscherConnectorRule
//STRIP001 {
//STRIP001 	sal_uInt32	nRuleId;
//STRIP001 	sal_uInt32	nShapeA;		// SPID of shape A
//STRIP001 	sal_uInt32	nShapeB;		// SPID of shape B
//STRIP001 	sal_uInt32	nShapeC;		// SPID of connector shape
//STRIP001 	sal_uInt32	ncptiA;			// Connection site Index of shape A
//STRIP001 	sal_uInt32	ncptiB;			// Connection site Index of shape B
//STRIP001 };
//STRIP001 
//STRIP001 struct EscherConnectorListEntry
//STRIP001 {
//STRIP001 	::com::sun::star::awt::Point			maPointA;
//STRIP001 	::com::sun::star::awt::Point			maPointB;
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape	>	mXConnector;
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape	>	mXConnectToA;
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape	>	mXConnectToB;
//STRIP001 
//STRIP001 	sal_uInt32		GetConnectorRule( sal_Bool bFirst );
//STRIP001 
//STRIP001 					EscherConnectorListEntry( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rC,
//STRIP001 										const ::com::sun::star::awt::Point& rPA,
//STRIP001 										::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rSA ,
//STRIP001 										const ::com::sun::star::awt::Point& rPB,
//STRIP001 										::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rSB ) :
//STRIP001 											mXConnector	( rC ),
//STRIP001 											maPointA	( rPA ),
//STRIP001 											maPointB	( rPB ),
//STRIP001 											mXConnectToA( rSA ),
//STRIP001 											mXConnectToB( rSB ) {}
//STRIP001 
//STRIP001 	sal_uInt32		GetClosestPoint( const Polygon& rPoly, const ::com::sun::star::awt::Point& rP );
//STRIP001 };
//STRIP001 
//STRIP001 struct EscherShapeListEntry
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape	>	aXShape;
//STRIP001 	sal_uInt32			n_EscherId;
//STRIP001 
//STRIP001 						EscherShapeListEntry( const ::com::sun::star::uno::Reference
//STRIP001 							< ::com::sun::star::drawing::XShape > & rShape, sal_uInt32 nId ) :
//STRIP001 										aXShape		( rShape ),
//STRIP001 										n_EscherId	( nId ) {}
//STRIP001 };
//STRIP001 
//STRIP001 sal_uInt32 EscherConnectorListEntry::GetClosestPoint( const Polygon& rPoly, const ::com::sun::star::awt::Point& rPoint )
//STRIP001 {
//STRIP001 	sal_uInt16 nCount = rPoly.GetSize();
//STRIP001 	sal_uInt16 nClosest = nCount;
//STRIP001 	double fDist = (sal_uInt32)0xffffffff;
//STRIP001 	while( nCount-- )
//STRIP001 	{
//STRIP001 		double fDistance = hypot( rPoint.X - rPoly[ nCount ].X(), rPoint.Y - rPoly[ nCount ].Y() );
//STRIP001 		if ( fDistance < fDist )
//STRIP001 		{
//STRIP001 			nClosest =  nCount;
//STRIP001 			fDist = fDistance;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nClosest;
//STRIP001 };
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // bei Rechtecken           bei Ellipsen    bei Polygonen
//STRIP001 //
//STRIP001 // nRule =  0 ->Top         0 ->Top         nRule = Index auf ein (Poly)Polygon Punkt
//STRIP001 //          1 ->Left        2 ->Left
//STRIP001 //          2 ->Bottom      4 ->Bottom
//STRIP001 //          3 ->Right       6 ->Right
//STRIP001 
//STRIP001 sal_uInt32 EscherConnectorListEntry::GetConnectorRule( sal_Bool bFirst )
//STRIP001 {
//STRIP001     sal_uInt32 nRule = 0;
//STRIP001 
//STRIP001 	::com::sun::star::uno::Any aAny;
//STRIP001     ::com::sun::star::awt::Point aRefPoint( ( bFirst ) ? maPointA : maPointB );
//STRIP001     ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >
//STRIP001 		aXShape( ( bFirst ) ? mXConnectToA : mXConnectToB );
//STRIP001 
//STRIP001 	String aString( (::rtl::OUString)aXShape->getShapeType() );
//STRIP001     ByteString aType( aString, RTL_TEXTENCODING_UTF8 );
//STRIP001     aType.Erase( 0, 19 );   // "smart.com.sun.star." entfernen
//STRIP001     sal_uInt16 nPos = aType.Search( "Shape" );
//STRIP001     aType.Erase( nPos, 5 );
//STRIP001 
//STRIP001     ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
//STRIP001 		aPropertySet( aXShape, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 
//STRIP001     if ( aType == "drawing.PolyPolygon" || aType == "drawing.PolyLine" )
//STRIP001     {
//STRIP001         if ( aPropertySet.is() )
//STRIP001         {
//STRIP001 			if ( EscherPropertyValueHelper::GetPropertyValue( aAny,
//STRIP001 					aPropertySet, String( RTL_CONSTASCII_USTRINGPARAM( "PolyPolygon" ) ) ) )
//STRIP001 			{
//STRIP001                 ::com::sun::star::drawing::PointSequenceSequence* pSourcePolyPolygon =
//STRIP001 					(::com::sun::star::drawing::PointSequenceSequence*)aAny.getValue();
//STRIP001                 sal_Int32 nOuterSequenceCount = pSourcePolyPolygon->getLength();
//STRIP001                 ::com::sun::star::drawing::PointSequence* pOuterSequence = pSourcePolyPolygon->getArray();
//STRIP001 
//STRIP001                 if ( pOuterSequence )
//STRIP001                 {
//STRIP001                     sal_Int32 a, b, nIndex = 0;
//STRIP001                     sal_uInt32 nDistance = 0xffffffff;
//STRIP001                     for( a = 0; a < nOuterSequenceCount; a++ )
//STRIP001                     {
//STRIP001                         ::com::sun::star::drawing::PointSequence* pInnerSequence = pOuterSequence++;
//STRIP001                         if ( pInnerSequence )
//STRIP001                         {
//STRIP001                             ::com::sun::star::awt::Point* pArray = pInnerSequence->getArray();
//STRIP001                             if ( pArray )
//STRIP001                             {
//STRIP001                                 for ( b = 0; b < pInnerSequence->getLength(); b++, nIndex++, pArray++ )
//STRIP001                                 {
//STRIP001                                     sal_uInt32 nDist = (sal_uInt32)hypot( aRefPoint.X - pArray->X, aRefPoint.Y - pArray->Y );
//STRIP001                                     if ( nDist < nDistance )
//STRIP001                                     {
//STRIP001                                         nRule = nIndex;
//STRIP001                                         nDistance = nDist;
//STRIP001                                     }
//STRIP001                                 }
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001 			}
//STRIP001         }
//STRIP001     }
//STRIP001     else if ( ( aType == "drawing.OpenBezier" ) || ( aType == "drawing.OpenFreeHand" ) || ( aType == "drawing.PolyLinePath" )
//STRIP001         || ( aType == "drawing.ClosedBezier" ) || ( aType == "drawing.ClosedFreeHand" ) || ( aType == "drawing.PolyPolygonPath" ) )
//STRIP001     {
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
//STRIP001 			aPropertySet( aXShape, ::com::sun::star::uno::UNO_QUERY );
//STRIP001         if ( aPropertySet.is() )
//STRIP001         {
//STRIP001 			if ( EscherPropertyValueHelper::GetPropertyValue( aAny,
//STRIP001 					aPropertySet, String( RTL_CONSTASCII_USTRINGPARAM( "PolyPolygonBezier" ) ) ) )
//STRIP001 			{
//STRIP001 				::com::sun::star::drawing::PolyPolygonBezierCoords* pSourcePolyPolygon =
//STRIP001 					(::com::sun::star::drawing::PolyPolygonBezierCoords*)aAny.getValue();
//STRIP001                 sal_Int32 nOuterSequenceCount = pSourcePolyPolygon->Coordinates.getLength();
//STRIP001 
//STRIP001                 // Zeiger auf innere sequences holen
//STRIP001                 ::com::sun::star::drawing::PointSequence* pOuterSequence =
//STRIP001 					pSourcePolyPolygon->Coordinates.getArray();
//STRIP001                 ::com::sun::star::drawing::FlagSequence*  pOuterFlags =
//STRIP001 					pSourcePolyPolygon->Flags.getArray();
//STRIP001 
//STRIP001                 if ( pOuterSequence && pOuterFlags )
//STRIP001                 {
//STRIP001                     sal_Int32 a, b, nIndex = 0;
//STRIP001                     sal_uInt32 nDistance = 0xffffffff;
//STRIP001 
//STRIP001                     for ( a = 0; a < nOuterSequenceCount; a++ )
//STRIP001                     {
//STRIP001                         ::com::sun::star::drawing::PointSequence* pInnerSequence = pOuterSequence++;
//STRIP001                         ::com::sun::star::drawing::FlagSequence*  pInnerFlags = pOuterFlags++;
//STRIP001                         if ( pInnerSequence && pInnerFlags )
//STRIP001                         {
//STRIP001                             ::com::sun::star::awt::Point* pArray = pInnerSequence->getArray();
//STRIP001                             ::com::sun::star::drawing::PolygonFlags* pFlags = pInnerFlags->getArray();
//STRIP001                             if ( pArray && pFlags )
//STRIP001                             {
//STRIP001                                 for ( b = 0; b < pInnerSequence->getLength(); b++, pArray++ )
//STRIP001                                 {
//STRIP001                                     PolyFlags ePolyFlags = *( (PolyFlags*)pFlags++ );
//STRIP001                                     if ( ePolyFlags == POLY_CONTROL )
//STRIP001                                         continue;
//STRIP001                                     sal_uInt32 nDist = (sal_uInt32)hypot( aRefPoint.X - pArray->X, aRefPoint.Y - pArray->Y );
//STRIP001                                     if ( nDist < nDistance )
//STRIP001                                     {
//STRIP001                                         nRule = nIndex;
//STRIP001                                         nDistance = nDist;
//STRIP001                                     }
//STRIP001                                     nIndex++;
//STRIP001                                 }
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001 		::com::sun::star::awt::Point aPoint( aXShape->getPosition() );
//STRIP001 		::com::sun::star::awt::Size	 aSize( aXShape->getSize() );
//STRIP001 
//STRIP001 		Rectangle	aRect( Point( aPoint.X, aPoint.Y ), Size( aSize.Width, aSize.Height ) );
//STRIP001 		Point		aCenter( aRect.Center() );
//STRIP001 		Polygon		aPoly( 4 );
//STRIP001 
//STRIP001 		aPoly[ 0 ] = Point( aCenter.X(), aRect.Top() );
//STRIP001 		aPoly[ 1 ] = Point( aRect.Left(), aCenter.Y() );
//STRIP001 		aPoly[ 2 ] = Point( aCenter.X(), aRect.Bottom() );
//STRIP001 		aPoly[ 3 ] = Point( aRect.Right(), aCenter.Y() );
//STRIP001 
//STRIP001 		sal_Int32 nAngle = ( EscherPropertyValueHelper::GetPropertyValue( aAny,
//STRIP001 			aPropertySet, String( RTL_CONSTASCII_USTRINGPARAM( "RotateAngle" ) ), sal_True ) )
//STRIP001 				? *((sal_Int32*)aAny.getValue() )
//STRIP001 				: 0;
//STRIP001 		if ( nAngle )
//STRIP001 			aPoly.Rotate( aRect.TopLeft(), ( nAngle + 5 ) / 10 );
//STRIP001 		nRule = GetClosestPoint( aPoly, aRefPoint );
//STRIP001     }
//STRIP001     if ( aType == "drawing.Ellipse" )
//STRIP001         nRule <<= 1;    // In PPT hat eine Ellipse 8 Mglichkeiten sich zu connecten
//STRIP001 
//STRIP001     return nRule;
//STRIP001 }
//STRIP001 
//STRIP001 EscherSolverContainer::~EscherSolverContainer()
//STRIP001 {
//STRIP001     for( void* pP = maShapeList.First(); pP; pP = maShapeList.Next() )
//STRIP001         delete (EscherShapeListEntry*)pP;
//STRIP001     for( pP = maConnectorList.First(); pP; pP = maConnectorList.Next() )
//STRIP001         delete (EscherConnectorListEntry*)pP;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherSolverContainer::AddShape( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rXShape, sal_uInt32 nId )
//STRIP001 {
//STRIP001     maShapeList.Insert( new EscherShapeListEntry( rXShape, nId ), LIST_APPEND );
//STRIP001 }
//STRIP001 
//STRIP001 void EscherSolverContainer::AddConnector( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rConnector,
//STRIP001 										const ::com::sun::star::awt::Point& rPA,
//STRIP001 									::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rConA,
//STRIP001 										const ::com::sun::star::awt::Point& rPB,
//STRIP001 									::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rConB )
//STRIP001 {
//STRIP001     maConnectorList.Insert( new EscherConnectorListEntry( rConnector, rPA, rConA, rPB, rConB ), LIST_APPEND );
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt32 EscherSolverContainer::ImplGetId( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rXShape )
//STRIP001 {
//STRIP001     for ( EscherShapeListEntry* pPtr = (EscherShapeListEntry*)maShapeList.First();
//STRIP001 			pPtr; pPtr = (EscherShapeListEntry*)maShapeList.Next() )
//STRIP001     {
//STRIP001         if ( rXShape == pPtr->aXShape )
//STRIP001             return ( pPtr->n_EscherId );
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void EscherSolverContainer::WriteSolver( SvStream& rStrm )
//STRIP001 {
//STRIP001     sal_uInt32 nCount = maConnectorList.Count();
//STRIP001     if ( nCount )
//STRIP001     {
//STRIP001 		sal_uInt32	nRecHdPos, nCurrentPos, nSize;
//STRIP001 		rStrm	<< (sal_uInt16)( ( nCount << 4 ) | 0xf )	// open an ESCHER_SolverContainer
//STRIP001 				<< (sal_uInt16)ESCHER_SolverContainer		//
//STRIP001 				<< (sal_uInt32)0;							//
//STRIP001 
//STRIP001 		nRecHdPos = rStrm.Tell() - 4;
//STRIP001 
//STRIP001         EscherConnectorRule aConnectorRule;
//STRIP001         aConnectorRule.nRuleId = 2;
//STRIP001         for ( EscherConnectorListEntry* pPtr = (EscherConnectorListEntry*)maConnectorList.First();
//STRIP001 				pPtr; pPtr = (EscherConnectorListEntry*)maConnectorList.Next() )
//STRIP001         {
//STRIP001             aConnectorRule.ncptiA = aConnectorRule.ncptiB = 0xffffffff;
//STRIP001             aConnectorRule.nShapeC = ImplGetId( pPtr->mXConnector );
//STRIP001             aConnectorRule.nShapeA = ImplGetId( pPtr->mXConnectToA );
//STRIP001             aConnectorRule.nShapeB = ImplGetId( pPtr->mXConnectToB );
//STRIP001 
//STRIP001             if ( aConnectorRule.nShapeC )
//STRIP001             {
//STRIP001                 if ( aConnectorRule.nShapeA )
//STRIP001                     aConnectorRule.ncptiA = pPtr->GetConnectorRule( sal_True );
//STRIP001                 if ( aConnectorRule.nShapeB )
//STRIP001                     aConnectorRule.ncptiB = pPtr->GetConnectorRule( sal_False );
//STRIP001             }
//STRIP001 			rStrm	<< (sal_uInt32)( ( ESCHER_ConnectorRule << 16 ) | 1 )	// atom hd
//STRIP001 					<< (sal_uInt32)24										//
//STRIP001 					<< aConnectorRule.nRuleId
//STRIP001                     << aConnectorRule.nShapeA
//STRIP001                     << aConnectorRule.nShapeB
//STRIP001                     << aConnectorRule.nShapeC
//STRIP001                     << aConnectorRule.ncptiA
//STRIP001                     << aConnectorRule.ncptiB;
//STRIP001 
//STRIP001             aConnectorRule.nRuleId += 2;
//STRIP001         }
//STRIP001 
//STRIP001 		nCurrentPos = rStrm.Tell();				// close the ESCHER_SolverContainer
//STRIP001 		nSize = ( nCurrentPos - nRecHdPos ) - 4;//
//STRIP001 		rStrm.Seek( nRecHdPos );				//
//STRIP001 		rStrm << nSize;							//
//STRIP001 		rStrm.Seek( nCurrentPos );				//
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherEx::EscherEx( SvStream& rOutStrm, UINT32 nDrawings ) :
//STRIP001 	EscherGraphicProvider	( 0 ),
//STRIP001 	mpOutStrm				( &rOutStrm ),
//STRIP001 	mpOffsets				( new sal_uInt32[ 32 ] ),
//STRIP001 	mpRecTypes				( new sal_uInt16[ 32 ] ),
//STRIP001 	mnDrawings				( nDrawings ),
//STRIP001 	mnLevel					( 0 ),
//STRIP001 	mbEscherSpgr			( FALSE ),
//STRIP001 	mbEscherDgg				( FALSE ),										// TRUE, wenn jemals ein ESCHER_Dgg angelegt wurde, dieser wird dann im Dest. aktualisiert
//STRIP001 	mbEscherDg				( FALSE ),
//STRIP001 	mbOleEmf				( FALSE ),
//STRIP001 	mnGroupLevel			( 0 ),
//STRIP001 	mnHellLayerId			( USHRT_MAX )
//STRIP001 {
//STRIP001 	mnStrmStartOfs = mpOutStrm->Tell();
//STRIP001 	mpImplEscherExSdr = new ImplEscherExSdr( *this );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::Flush( SvStream* pPicStreamMergeBSE /* = NULL */ )
//STRIP001 {
//STRIP001 	if ( mbEscherDgg )														// ESCHER_Dgg anpassen
//STRIP001 	{
//STRIP001 		PtReplaceOrInsert( ESCHER_Persist_CurrentPosition, mpOutStrm->Tell() );
//STRIP001 		if ( DoSeek( ESCHER_Persist_Dgg ) )
//STRIP001 		{
//STRIP001 			*mpOutStrm << mnCurrentShapeID << (UINT32)( mnFIDCLs + 1 ) << mnTotalShapesDgg << mnDrawings;
//STRIP001 		}
//STRIP001 		if ( HasGraphics() )
//STRIP001 		{
//STRIP001 			if ( DoSeek( ESCHER_Persist_BlibStoreContainer ) )			// ESCHER_BlibStoreContainer schreiben
//STRIP001 			{
//STRIP001 				sal_uInt32 nAddBytes = GetBlibStoreContainerSize( pPicStreamMergeBSE );
//STRIP001 				if ( nAddBytes )
//STRIP001 				{
//STRIP001 					InsertAtCurrentPos( nAddBytes, TRUE );					// platz schaffen fuer Blib Container samt seinen Blib Atomen
//STRIP001 					WriteBlibStoreContainer( *mpOutStrm, pPicStreamMergeBSE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		mpOutStrm->Seek( PtGetOffsetByID( ESCHER_Persist_CurrentPosition ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherEx::~EscherEx()
//STRIP001 {
//STRIP001 	delete[] mpRecTypes;
//STRIP001 	delete[] mpOffsets;
//STRIP001 	delete mpImplEscherExSdr;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::InsertAtCurrentPos( UINT32 nBytes, BOOL bContainer )
//STRIP001 {
//STRIP001 	UINT32	i, nSize, nType, nSource, nBufSize, nToCopy, nCurPos = mpOutStrm->Tell();
//STRIP001 	BYTE*	pBuf;
//STRIP001 
//STRIP001 	// Persist table anpassen
//STRIP001 	for ( void* pPtr = maPersistTable.First(); pPtr; pPtr = maPersistTable.Next() )
//STRIP001 	{
//STRIP001 		UINT32 nOfs = ((EscherPersistEntry*)pPtr)->mnOffset;
//STRIP001 		if ( nOfs >= nCurPos )
//STRIP001 			((EscherPersistEntry*)pPtr)->mnOffset += nBytes;
//STRIP001 	}
//STRIP001 
//STRIP001 	// container und atom sizes anpassen
//STRIP001 	mpOutStrm->Seek( mnStrmStartOfs );
//STRIP001 	while ( mpOutStrm->Tell() < nCurPos )
//STRIP001 	{
//STRIP001 		*mpOutStrm >> nType >> nSize;
//STRIP001 		if ( ( mpOutStrm->Tell() + nSize ) >= ( ( bContainer ) ? nCurPos + 1 : nCurPos ) )
//STRIP001 		{
//STRIP001 			mpOutStrm->SeekRel( -4 );
//STRIP001 			*mpOutStrm << (UINT32)( nSize + nBytes );
//STRIP001 			if ( ( nType & 0xf ) != 0xf )
//STRIP001 				mpOutStrm->SeekRel( nSize );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			mpOutStrm->SeekRel( nSize );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Container Offsets verschieben
//STRIP001 	for ( i = 1; i <= (UINT32)mnLevel; i++ )
//STRIP001 	{
//STRIP001 		if ( mpOffsets[ i ] > nCurPos )
//STRIP001 			mpOffsets[ i ] += nBytes;
//STRIP001 	}
//STRIP001 	mpOutStrm->Seek( STREAM_SEEK_TO_END );
//STRIP001 	nSource = mpOutStrm->Tell();
//STRIP001 	nToCopy = nSource - nCurPos;						// Stream um nBytes vergroessern
//STRIP001 	pBuf = new BYTE[ 0x40000 ];							// 256KB Buffer
//STRIP001 	while ( nToCopy )
//STRIP001 	{
//STRIP001 		nBufSize = ( nToCopy >= 0x40000 ) ? 0x40000 : nToCopy;
//STRIP001 		nToCopy -= nBufSize;
//STRIP001 		nSource -= nBufSize;
//STRIP001 		mpOutStrm->Seek( nSource );
//STRIP001 		mpOutStrm->Read( pBuf, nBufSize );
//STRIP001 		mpOutStrm->Seek( nSource + nBytes );
//STRIP001 		mpOutStrm->Write( pBuf, nBufSize );
//STRIP001 	}
//STRIP001 	delete[] pBuf;
//STRIP001 	mpOutStrm->Seek( nCurPos );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherEx::SeekBehindRecHeader( UINT16 nRecType )
//STRIP001 {
//STRIP001 	UINT32	nOldPos, nStreamEnd, nType, nSize;
//STRIP001 
//STRIP001 	nOldPos = mpOutStrm->Tell();
//STRIP001 	nStreamEnd = mpOutStrm->Seek( STREAM_SEEK_TO_END );
//STRIP001 	mpOutStrm->Seek( nOldPos );
//STRIP001 	while ( mpOutStrm->Tell() < nStreamEnd )
//STRIP001 	{
//STRIP001 		*mpOutStrm >> nType >> nSize;
//STRIP001 		if ( ( nType >> 16 ) == nRecType )
//STRIP001 			return TRUE;
//STRIP001 		if ( ( nType & 0xf ) != 0xf )
//STRIP001 			mpOutStrm->SeekRel( nSize );
//STRIP001 	}
//STRIP001 	mpOutStrm->Seek( nOldPos );
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::InsertPersistOffset( UINT32 nKey, UINT32 nOffset )
//STRIP001 {
//STRIP001 	PtInsert( ESCHER_Persist_PrivateEntry | nKey, nOffset );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherEx::DoSeek( UINT32 nKey )
//STRIP001 {
//STRIP001 	UINT32 nPos = PtGetOffsetByID( nKey );
//STRIP001 	if ( nPos )
//STRIP001 		mpOutStrm->Seek( nPos );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (! PtIsID( nKey ) )
//STRIP001 			return FALSE;
//STRIP001 		mpOutStrm->Seek( 0 );
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherEx::SeekToPersistOffset( UINT32 nKey )
//STRIP001 {
//STRIP001 	return DoSeek( ESCHER_Persist_PrivateEntry | nKey );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherEx::InsertAtPersistOffset( UINT32 nKey, UINT32 nValue )
//STRIP001 {
//STRIP001 	UINT32	nOldPos = mpOutStrm->Tell();
//STRIP001 	BOOL	bRetValue = SeekToPersistOffset( nKey );
//STRIP001 	if ( bRetValue )
//STRIP001 	{
//STRIP001 		*mpOutStrm << nValue;
//STRIP001 		mpOutStrm->Seek( nOldPos );
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::OpenContainer( UINT16 nEscherContainer, int nRecInstance )
//STRIP001 {
//STRIP001 	*mpOutStrm << (UINT16)( ( nRecInstance << 4 ) | 0xf  ) << nEscherContainer << (UINT32)0;
//STRIP001 	mpOffsets[ ++mnLevel ] = mpOutStrm->Tell() - 4;
//STRIP001 	mpRecTypes[ mnLevel ] = nEscherContainer;
//STRIP001 
//STRIP001 	switch( nEscherContainer )
//STRIP001 	{
//STRIP001 		case ESCHER_DggContainer :
//STRIP001 		{
//STRIP001 			mbEscherDgg = TRUE;
//STRIP001 			mnFIDCLs = mnDrawings;
//STRIP001 			mnCurrentDg	= 0;
//STRIP001 			mnCurrentShapeID = 0;
//STRIP001 			mnTotalShapesDgg = 0;
//STRIP001 			mnCurrentShapeMaximumID = 0;
//STRIP001 			AddAtom( 16 + ( mnDrawings << 3 ), ESCHER_Dgg );				// an FDGG and several FIDCLs
//STRIP001 			PtReplaceOrInsert( ESCHER_Persist_Dgg, mpOutStrm->Tell() );
//STRIP001 			*mpOutStrm << (UINT32)0											// the current maximum shape ID
//STRIP001 					   << (UINT32)0											// the number of ID clusters + 1
//STRIP001 					   << (UINT32)0											// the number of total shapes saved
//STRIP001 					   << (UINT32)0;										// the total number of drawings saved
//STRIP001 			PtReplaceOrInsert( ESCHER_Persist_Dgg_FIDCL, mpOutStrm->Tell() );
//STRIP001 			for ( UINT32 i = 0; i < mnFIDCLs; i++ )							// Dummy FIDCLs einfuegen
//STRIP001 			{
//STRIP001 				*mpOutStrm << (UINT32)0 << (UINT32)0;						// Drawing Nummer, Anzahl der Shapes in diesem IDCL
//STRIP001 			}
//STRIP001 			PtReplaceOrInsert( ESCHER_Persist_BlibStoreContainer, mpOutStrm->Tell() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case ESCHER_DgContainer :
//STRIP001 		{
//STRIP001 			if ( mbEscherDgg )
//STRIP001 			{
//STRIP001 				if ( !mbEscherDg )
//STRIP001 				{
//STRIP001 					mbEscherDg = TRUE;
//STRIP001 					mnCurrentDg++;
//STRIP001 					mnTotalShapesDg = 0;
//STRIP001 					mnTotalShapeIdUsedDg = 0;
//STRIP001 					mnCurrentShapeID = ( mnCurrentShapeMaximumID &~0x3ff ) + 0x400;	// eine neue Seite bekommt immer eine neue ShapeId die ein vielfaches von 1024 ist,
//STRIP001 																					// damit ist erste aktuelle Shape ID 0x400
//STRIP001 					AddAtom( 8, ESCHER_Dg, 0, mnCurrentDg );
//STRIP001 					PtReplaceOrInsert( ESCHER_Persist_Dg | mnCurrentDg, mpOutStrm->Tell() );
//STRIP001 					*mpOutStrm << (UINT32)0		// The number of shapes in this drawing
//STRIP001 							   << (UINT32)0;	// The last MSOSPID given to an SP in this DG
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case ESCHER_SpgrContainer :
//STRIP001 		{
//STRIP001 			if ( mbEscherDg )
//STRIP001 			{
//STRIP001 				mbEscherSpgr = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case ESCHER_SpContainer :
//STRIP001 		{
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::CloseContainer()
//STRIP001 {
//STRIP001 	sal_uInt32 nSize, nPos = mpOutStrm->Tell();
//STRIP001 	nSize = ( nPos - mpOffsets[ mnLevel ] ) - 4;
//STRIP001 	mpOutStrm->Seek( mpOffsets[ mnLevel ] );
//STRIP001 	*mpOutStrm << nSize;
//STRIP001 
//STRIP001 	switch( mpRecTypes[ mnLevel ] )
//STRIP001 	{
//STRIP001 		case ESCHER_DgContainer :
//STRIP001 		{
//STRIP001 			if ( mbEscherDg )
//STRIP001 			{
//STRIP001 				mbEscherDg = FALSE;
//STRIP001 				if ( DoSeek( ESCHER_Persist_Dg | mnCurrentDg ) )
//STRIP001 				{
//STRIP001 					// shapeanzahl des drawings setzen
//STRIP001 					mnTotalShapesDgg += mnTotalShapesDg;
//STRIP001 					*mpOutStrm << mnTotalShapesDg << mnCurrentShapeMaximumID;
//STRIP001 					if ( DoSeek( ESCHER_Persist_Dgg_FIDCL ) )
//STRIP001 					{
//STRIP001 						if ( mnTotalShapesDg == 0 )
//STRIP001 						{
//STRIP001 							mpOutStrm->SeekRel( 8 );
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							if ( mnTotalShapeIdUsedDg )
//STRIP001 							{
//STRIP001 								// die benutzten Shape Ids des drawings in die fidcls setzen
//STRIP001 								UINT32 i, nFIDCL = ( ( mnTotalShapeIdUsedDg - 1 ) / 0x400 );
//STRIP001 								if ( nFIDCL )
//STRIP001 								{
//STRIP001 									if ( nPos > mpOutStrm->Tell() )
//STRIP001 										nPos += ( nFIDCL << 3 );
//STRIP001 
//STRIP001 									mnFIDCLs += nFIDCL;
//STRIP001 									InsertAtCurrentPos( nFIDCL << 3 );			// platz schaffen fuer weitere FIDCL's
//STRIP001 								}
//STRIP001 								for ( i = 0; i <= nFIDCL; i++ )
//STRIP001 								{
//STRIP001 									*mpOutStrm << mnCurrentDg;
//STRIP001 									if ( i < nFIDCL )
//STRIP001 										*mpOutStrm << (UINT32)0x400;
//STRIP001 									else
//STRIP001 									{
//STRIP001 										UINT32 nShapesLeft = mnTotalShapeIdUsedDg % 0x400;
//STRIP001 										if ( !nShapesLeft )
//STRIP001 											nShapesLeft = 0x400;
//STRIP001 										*mpOutStrm << (UINT32)nShapesLeft;
//STRIP001 									}
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						PtReplaceOrInsert( ESCHER_Persist_Dgg_FIDCL, mpOutStrm->Tell() );	// neuen FIDCL Offset fuer naechste Seite
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case ESCHER_SpgrContainer :
//STRIP001 		{
//STRIP001 			if ( mbEscherSpgr )
//STRIP001 			{
//STRIP001 				mbEscherSpgr = FALSE;
//STRIP001 
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	mnLevel--;
//STRIP001 	mpOutStrm->Seek( nPos );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::BeginAtom()
//STRIP001 {
//STRIP001 	mnCountOfs = mpOutStrm->Tell();
//STRIP001 	*mpOutStrm << (UINT32)0 << (UINT32)0;		// record header wird spaeter geschrieben
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::EndAtom( UINT16 nRecType, int nRecVersion, int nRecInstance )
//STRIP001 {
//STRIP001 	UINT32	nOldPos = mpOutStrm->Tell();
//STRIP001 	mpOutStrm->Seek( mnCountOfs );
//STRIP001 	sal_uInt32 nSize = nOldPos - mnCountOfs;
//STRIP001 	*mpOutStrm << (UINT16)( ( nRecInstance << 4 ) | ( nRecVersion & 0xf ) ) << nRecType << (UINT32)( nSize - 8 );
//STRIP001 	mpOutStrm->Seek( nOldPos );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::AddAtom( UINT32 nAtomSize, UINT16 nRecType, int nRecVersion, int nRecInstance )
//STRIP001 {
//STRIP001 	*mpOutStrm << (UINT16)( ( nRecInstance << 4 ) | ( nRecVersion & 0xf ) ) << nRecType << nAtomSize;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::AddClientAnchor( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	AddAtom( 8, ESCHER_ClientAnchor );
//STRIP001     *mpOutStrm << (sal_Int16)rRect.Top()
//STRIP001                << (sal_Int16)rRect.Left()
//STRIP001                << (sal_Int16)( rRect.GetWidth()  + rRect.Left() )
//STRIP001                << (sal_Int16)( rRect.GetHeight() + rRect.Top() );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherExHostAppData* EscherEx::EnterAdditionalTextGroup()
//STRIP001 {
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherEx::EnterGroup( const Rectangle* pBoundRect )
//STRIP001 {
//STRIP001 	Rectangle aRect;
//STRIP001 	if( pBoundRect )
//STRIP001 		aRect = *pBoundRect;
//STRIP001 
//STRIP001 	OpenContainer( ESCHER_SpgrContainer );
//STRIP001 	OpenContainer( ESCHER_SpContainer );
//STRIP001 	AddAtom( 16, ESCHER_Spgr, 1 );
//STRIP001 	PtReplaceOrInsert( ESCHER_Persist_Grouping_Snap | mnGroupLevel,
//STRIP001 						mpOutStrm->Tell() );
//STRIP001 	*mpOutStrm	<< (INT32)aRect.Left()	// Bounding box fuer die Gruppierten shapes an die sie attached werden
//STRIP001 				<< (INT32)aRect.Top()
//STRIP001 				<< (INT32)aRect.Right()
//STRIP001 				<< (INT32)aRect.Bottom();
//STRIP001 
//STRIP001 	UINT32 nShapeId = GetShapeID();
//STRIP001 	if ( !mnGroupLevel )
//STRIP001 		AddShape( ESCHER_ShpInst_Min, 5, nShapeId );					// Flags: Group | Patriarch
//STRIP001 	else
//STRIP001 	{
//STRIP001 		AddShape( ESCHER_ShpInst_Min, 0x201, nShapeId );				// Flags: Group | HaveAnchor
//STRIP001 		EscherPropertyContainer aPropOpt;
//STRIP001 		aPropOpt.AddOpt( ESCHER_Prop_LockAgainstGrouping, 0x00040004 );
//STRIP001         aPropOpt.AddOpt( ESCHER_Prop_dxWrapDistLeft, 0 );
//STRIP001         aPropOpt.AddOpt( ESCHER_Prop_dxWrapDistRight, 0 );
//STRIP001 		aPropOpt.Commit( *mpOutStrm );
//STRIP001 		if ( mnGroupLevel > 1 )
//STRIP001 		{
//STRIP001 			AddAtom( 16, ESCHER_ChildAnchor );
//STRIP001 			*mpOutStrm	<< (INT32)aRect.Left()
//STRIP001 						<< (INT32)aRect.Top()
//STRIP001 					   	<< (INT32)aRect.Right()
//STRIP001 						<< (INT32)aRect.Bottom();
//STRIP001 		}
//STRIP001 		EscherExHostAppData* pAppData = mpImplEscherExSdr->ImplGetHostData();
//STRIP001 		if( pAppData )
//STRIP001 		{
//STRIP001 			if ( mnGroupLevel <= 1 )
//STRIP001 				pAppData->WriteClientAnchor( *this, aRect );
//STRIP001 			pAppData->WriteClientData( *this );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	CloseContainer();												// ESCHER_SpContainer
//STRIP001 	mnGroupLevel++;
//STRIP001 	return nShapeId;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherEx::SetGroupSnapRect( UINT32 nGroupLevel, const Rectangle& rRect )
//STRIP001 {
//STRIP001 	BOOL bRetValue = FALSE;
//STRIP001 	if ( nGroupLevel )
//STRIP001 	{
//STRIP001 		UINT32 nCurrentPos = mpOutStrm->Tell();
//STRIP001 		if ( DoSeek( ESCHER_Persist_Grouping_Snap | ( nGroupLevel - 1 ) ) )
//STRIP001 		{
//STRIP001 			*mpOutStrm	<< (INT32)rRect.Left()	// Bounding box fuer die Gruppierten shapes an die sie attached werden
//STRIP001 						<< (INT32)rRect.Top()
//STRIP001 						<< (INT32)rRect.Right()
//STRIP001 						<< (INT32)rRect.Bottom();
//STRIP001 			mpOutStrm->Seek( nCurrentPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL EscherEx::SetGroupLogicRect( UINT32 nGroupLevel, const Rectangle& rRect )
//STRIP001 {
//STRIP001 	BOOL bRetValue = FALSE;
//STRIP001 	if ( nGroupLevel )
//STRIP001 	{
//STRIP001 		UINT32 nCurrentPos = mpOutStrm->Tell();
//STRIP001 		if ( DoSeek( ESCHER_Persist_Grouping_Logic | ( nGroupLevel - 1 ) ) )
//STRIP001 		{
//STRIP001 			*mpOutStrm << (INT16)rRect.Top() << (INT16)rRect.Left() << (INT16)rRect.Right() << (INT16)rRect.Bottom();
//STRIP001 			mpOutStrm->Seek( nCurrentPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::LeaveGroup()
//STRIP001 {
//STRIP001 	--mnGroupLevel;
//STRIP001 	PtDelete( ESCHER_Persist_Grouping_Snap | mnGroupLevel );
//STRIP001 	PtDelete( ESCHER_Persist_Grouping_Logic | mnGroupLevel );
//STRIP001 	CloseContainer();
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::AddShape( UINT32 nShpInstance, UINT32 nFlags, UINT32 nShapeID )
//STRIP001 {
//STRIP001 	AddAtom( 8, ESCHER_Sp, 2, nShpInstance );
//STRIP001 
//STRIP001 	if ( !nShapeID )
//STRIP001 		nShapeID = GetShapeID();
//STRIP001 
//STRIP001 	if ( nFlags ^ 1 )							// is this a group shape ?
//STRIP001 	{											// if not
//STRIP001 		if ( mnGroupLevel > 1 )
//STRIP001 			nFlags |= 2;						// this not a topmost shape
//STRIP001 	}
//STRIP001 	*mpOutStrm << nShapeID << nFlags;
//STRIP001 
//STRIP001 	if ( mbEscherSpgr )
//STRIP001 		mnTotalShapesDg++;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherEx::GetShapeID()
//STRIP001 {
//STRIP001 	mnCurrentShapeMaximumID = mnCurrentShapeID;	// maximum setzen
//STRIP001 	mnCurrentShapeID++;							// mnCurrentShape ID auf nachste freie ID
//STRIP001 	mnTotalShapeIdUsedDg++;
//STRIP001 	return mnCurrentShapeMaximumID;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherEx::GetColor( const UINT32 nSOColor, BOOL bSwap )
//STRIP001 {
//STRIP001 	if ( bSwap )
//STRIP001 	{
//STRIP001 		UINT32 nColor = nSOColor & 0xff00;		// GRUEN
//STRIP001 		nColor |= (BYTE)( nSOColor ) << 16;		// ROT
//STRIP001 		nColor |= (BYTE)( nSOColor >> 16 );		// BLAU
//STRIP001 		return nColor;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return nSOColor & 0xffffff;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherEx::GetColor( const Color& rSOColor, BOOL bSwap )
//STRIP001 {
//STRIP001 	UINT32 nColor = ( rSOColor.GetRed() << 16 );
//STRIP001 	nColor |= ( rSOColor.GetGreen() << 8 );
//STRIP001 	nColor |= rSOColor.GetBlue();
//STRIP001 
//STRIP001 	if ( !bSwap )
//STRIP001 		nColor = GetColor( nColor, TRUE );
//STRIP001 
//STRIP001 	return nColor;
//STRIP001 }

// ---------------------------------------------------------------------------------------------
}
