/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdfmtf.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:49:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVDFMTF_HXX
#define _SVDFMTF_HXX

// auto strip #ifndef _SV_METAACT_HXX //autogen
// auto strip #include <vcl/metaact.hxx>
// auto strip #endif

// auto strip #ifndef _SV_VIRDEV_HXX //autogen
// auto strip #include <vcl/virdev.hxx>
// auto strip #endif

#ifndef _SVDOBJ_HXX
#include "svdobj.hxx"
#endif
class SfxItemSet;
namespace binfilter {

//************************************************************
//   Vorausdeklarationen
//************************************************************

class SdrObjList;
class SdrModel;
class SdrPage;
class SdrObject;
class SvdProgressInfo;

//************************************************************
//   Hilfsklasse SdrObjRefList
//************************************************************

class SdrObjRefList
{
	Container					aList;
public:

	SdrObjRefList()
	:	aList(1024,64,64)
	{}

	void Clear() { aList.Clear(); }
	ULONG GetObjCount() const { return aList.Count(); }
	SdrObject* GetObj(ULONG nNum) const { return (SdrObject*)aList.GetObject(nNum); }
	SdrObject* operator[](ULONG nNum) const { return (SdrObject*)aList.GetObject(nNum); }
	void InsertObject(SdrObject* pObj, ULONG nPos=CONTAINER_APPEND) { aList.Insert(pObj,nPos); }
	void RemoveObject(ULONG nPos) { aList.Remove(nPos); }
};

//************************************************************
//   Hilfsklasse ImpSdrGDIMetaFileImport
//************************************************************

//STRIP001 class ImpSdrGDIMetaFileImport
//STRIP001 {
//STRIP001 protected:
//STRIP001 	SdrObjRefList				aTmpList;
//STRIP001 	VirtualDevice				aVD;
//STRIP001 	Rectangle					aScaleRect;
//STRIP001 	ULONG						nMapScalingOfs; // ab hier nocht nicht mit MapScaling bearbeitet
//STRIP001 	SfxItemSet*					pLineAttr;
//STRIP001 	SfxItemSet*					pFillAttr;
//STRIP001 	SfxItemSet*					pTextAttr;
//STRIP001 	SdrPage*					pPage;
//STRIP001 	SdrModel*					pModel;
//STRIP001 	SdrLayerID					nLayer;	
//STRIP001 	Color						aOldLineColor;
//STRIP001 	sal_Int32					nLineWidth;
//STRIP001 
//STRIP001 	sal_Bool					bMov;
//STRIP001 	sal_Bool					bSize;
//STRIP001 	Point						aOfs;
//STRIP001     double                      fScaleX;
//STRIP001     double                      fScaleY;
//STRIP001 	Fraction					aScaleX;
//STRIP001 	Fraction					aScaleY;
//STRIP001 
//STRIP001 	sal_Bool                    bFntDirty;
//STRIP001 
//STRIP001 	// fuer Optimierung von (PenNULL,Brush,DrawPoly),(Pen,BrushNULL,DrawPoly) -> aus 2 mach ein
//STRIP001 	sal_Bool                    bLastObjWasPolyWithoutLine;
//STRIP001 	sal_Bool                    bNoLine;
//STRIP001 	sal_Bool                    bNoFill;
//STRIP001 
//STRIP001 	// fuer Optimierung mehrerer Linien zu einer Polyline
//STRIP001 	sal_Bool                    bLastObjWasLine;
//STRIP001 
//STRIP001 protected:
//STRIP001 	void DoAction(MetaPixelAction			& rAct);
//STRIP001 	void DoAction(MetaPointAction			& rAct);
//STRIP001 	void DoAction(MetaLineAction			& rAct);
//STRIP001 	void DoAction(MetaRectAction			& rAct);
//STRIP001 	void DoAction(MetaRoundRectAction		& rAct);
//STRIP001 	void DoAction(MetaEllipseAction			& rAct);
//STRIP001 	void DoAction(MetaArcAction				& rAct);
//STRIP001 	void DoAction(MetaPieAction				& rAct);
//STRIP001 	void DoAction(MetaChordAction			& rAct);
//STRIP001 	void DoAction(MetaPolyLineAction		& rAct);
//STRIP001 	void DoAction(MetaPolygonAction			& rAct);
//STRIP001 	void DoAction(MetaPolyPolygonAction		& rAct);
//STRIP001 	void DoAction(MetaTextAction			& rAct);
//STRIP001 	void DoAction(MetaTextArrayAction		& rAct);
//STRIP001 	void DoAction(MetaStretchTextAction		& rAct);
//STRIP001 	void DoAction(MetaBmpAction				& rAct);
//STRIP001 	void DoAction(MetaBmpScaleAction		& rAct);
//STRIP001 	void DoAction(MetaBmpExAction			& rAct);
//STRIP001 	void DoAction(MetaBmpExScaleAction		& rAct);
//STRIP001 	void DoAction(MetaHatchAction			& rAct);
//STRIP001 	void DoAction(MetaLineColorAction		& rAct);
//STRIP001 	void DoAction(MetaMapModeAction			& rAct);
//STRIP001 	void DoAction(MetaFillColorAction		& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaTextColorAction		& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaTextFillColorAction	& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaFontAction			& rAct) { rAct.Execute(&aVD); bFntDirty=TRUE; }
//STRIP001 	void DoAction(MetaTextAlignAction		& rAct) { rAct.Execute(&aVD); bFntDirty=TRUE; }
//STRIP001 	void DoAction(MetaClipRegionAction		& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaRasterOpAction		& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaPushAction			& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaPopAction				& rAct) { rAct.Execute(&aVD); bFntDirty=TRUE; }
//STRIP001 	void DoAction(MetaMoveClipRegionAction	& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaISectRectClipRegionAction& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaISectRegionClipRegionAction& rAct) { rAct.Execute(&aVD); }
//STRIP001 	void DoAction(MetaCommentAction& rAct, GDIMetaFile* pMtf);
//STRIP001 
//STRIP001 	void ImportText( const Point& rPos, const XubString& rStr, const MetaAction& rAct );
//STRIP001 	void SetAttributes(SdrObject* pObj, FASTBOOL bForceTextAttr=FALSE);
//STRIP001 	void InsertObj( SdrObject* pObj, sal_Bool bScale = sal_True );
//STRIP001 	void MapScaling();
//STRIP001 
//STRIP001 	sal_Bool CheckLastLineMerge(const XPolygon& rSrcPoly);
//STRIP001 	sal_Bool CheckLastPolyLineAndFillMerge(const XPolyPolygon& rPoly);
//STRIP001 
//STRIP001 public:
//STRIP001 	ImpSdrGDIMetaFileImport(SdrModel& rModel);
//STRIP001 	~ImpSdrGDIMetaFileImport();
//STRIP001 	ULONG DoImport(const GDIMetaFile& rMtf, SdrObjList& rDestList, ULONG nInsPos=CONTAINER_APPEND, SvdProgressInfo *pProgrInfo = NULL);
//STRIP001 	void SetLayer(SdrLayerID nLay) { nLayer=nLay; }
//STRIP001 	SdrLayerID GetLayer() const { return nLayer; }
//STRIP001 	void SetScaleRect(const Rectangle& rRect) { aScaleRect=rRect; }
//STRIP001 	const Rectangle& GetScaleRect() const { return aScaleRect; }
//STRIP001 };

////////////////////////////////////////////////////////////////////////////////////////////////////

}//end of namespace binfilter
#endif //_SVDFMTF_HXX

