/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svddrgmt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:52:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #include "svddrgm1.hxx"
//STRIP001 #include <math.h>
//STRIP001 
//STRIP001 #ifndef _MATH_H
//STRIP001 #define _MATH_H
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _BIGINT_HXX //autogen
//STRIP001 #include <tools/bigint.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "xattr.hxx"
//STRIP001 #include "xpoly.hxx"
//STRIP001 #include "svdxout.hxx"
//STRIP001 #include "svdetc.hxx"
//STRIP001 #include "svdtrans.hxx"
//STRIP001 #include "svdundo.hxx"
//STRIP001 #include "svdmark.hxx"
//STRIP001 #include "svdocapt.hxx"
//STRIP001 #include "svdpagv.hxx"
//STRIP001 #include "svdstr.hrc"   // Namen aus der Resource
//STRIP001 #include "svdglob.hxx"  // StringCache
//STRIP001 #include "svddrgv.hxx"
//STRIP001 #include "svdundo.hxx"
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT0(SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragMethod::ImpTakeDescriptionStr(USHORT nStrCacheID, XubString& rStr, USHORT nVal) const
//STRIP001 {
//STRIP001 	USHORT nOpt=0;
//STRIP001 	if (IsDraggingPoints()) {
//STRIP001 		nOpt=IMPSDR_POINTSDESCRIPTION;
//STRIP001 	} else if (IsDraggingGluePoints()) {
//STRIP001 		nOpt=IMPSDR_GLUEPOINTSDESCRIPTION;
//STRIP001 	}
//STRIP001 	rView.ImpTakeDescriptionStr(nStrCacheID,rStr,nVal,nOpt);
//STRIP001 }
//STRIP001 
//STRIP001 SdrObject* SdrDragMethod::GetDragObj() const
//STRIP001 {
//STRIP001 	SdrObject* pObj=NULL;
//STRIP001 	if (rView.pDragHdl!=NULL) pObj=rView.pDragHdl->GetObj();
//STRIP001 	if (pObj==NULL) pObj=rView.pMarkedObj;
//STRIP001 	return pObj;
//STRIP001 }
//STRIP001 
//STRIP001 SdrPageView* SdrDragMethod::GetDragPV() const
//STRIP001 {
//STRIP001 	SdrPageView* pPV=NULL;
//STRIP001 	if (rView.pDragHdl!=NULL) pPV=rView.pDragHdl->GetPageView();
//STRIP001 	if (pPV==NULL) pPV=rView.pMarkedPV;
//STRIP001 	return pPV;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::Draw() const
//STRIP001 {
//STRIP001 	rView.DrawDragObj(rView.pDragWin,TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::Show()
//STRIP001 {
//STRIP001 	rView.ShowDragObj(rView.pDragWin);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::Hide()
//STRIP001 {
//STRIP001 	rView.HideDragObj(rView.pDragWin);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::MovAllPoints()
//STRIP001 {
//STRIP001 	USHORT nPvAnz=rView.GetPageViewCount();
//STRIP001 	for (USHORT nv=0; nv<nPvAnz; nv++) {
//STRIP001 		SdrPageView* pPV=rView.GetPageViewPvNum(nv);
//STRIP001 		if (pPV->HasMarkedObj()) {
//STRIP001 			pPV->DragPoly()=pPV->DragPoly0();
//STRIP001 			USHORT i,j;
//STRIP001 			USHORT nPolyAnz=pPV->DragPoly().Count();
//STRIP001 			for (j=0; j<nPolyAnz; j++) {
//STRIP001 				XPolygon& aPol=pPV->DragPoly()[j];
//STRIP001 				Point aOfs(pPV->GetOffset());
//STRIP001 				USHORT nPtAnz=aPol.GetPointCount();
//STRIP001 				for (i=0; i<nPtAnz; i++) {
//STRIP001 					MovPoint(aPol[i],aOfs);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::MovPoint(Point& rPnt, const Point& rPvOfs)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::Brk()
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMethod::IsMoveOnly() const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMethod::DrawXor(ExtOutputDevice& rXOut, FASTBOOL bFull) const
//STRIP001 {
//STRIP001 	FASTBOOL bGlue=IsDraggingGluePoints();
//STRIP001 	FASTBOOL bPoints=IsDraggingPoints() || bGlue;
//STRIP001 	OutputDevice* pOut=rXOut.GetOutDev();
//STRIP001 	long x=0,y=0;
//STRIP001 	if (bPoints) {
//STRIP001 		long nSiz=bGlue ? 3 : rView.aHdl.GetHdlSize();
//STRIP001 		Size aSiz(pOut->PixelToLogic(Size(nSiz,nSiz)));
//STRIP001 		x=aSiz.Width();
//STRIP001 		y=aSiz.Height();
//STRIP001 		pOut->SetLineColor( Color( COL_BLACK ) );
//STRIP001 	}
//STRIP001 	USHORT nPvAnz=rView.GetPageViewCount();
//STRIP001 	for (USHORT nv=0; nv<nPvAnz; nv++) 
//STRIP001 	{
//STRIP001 		SdrPageView* pPV=rView.GetPageViewPvNum(nv);
//STRIP001 		if (pPV->HasMarkedObj()) 
//STRIP001 		{
//STRIP001 			rXOut.SetOffset(pPV->GetOffset());
//STRIP001 			const XPolyPolygon& rXPP=pPV->DragPoly();
//STRIP001 			USHORT nPolyAnz=rXPP.Count();
//STRIP001 			for (USHORT nPolyNum=0; nPolyNum<nPolyAnz; nPolyNum++) 
//STRIP001 			{
//STRIP001 				const XPolygon& rXP=rXPP[nPolyNum];
//STRIP001 				USHORT nPtAnz=rXP.GetPointCount();
//STRIP001 				if (bPoints) 
//STRIP001 				{
//STRIP001 					for (USHORT nPtNum=0; nPtNum<nPtAnz; nPtNum++) 
//STRIP001 					{
//STRIP001 						Point aPt(rXP[nPtNum]);
//STRIP001 						long x1=aPt.X()-x;
//STRIP001 						long x2=aPt.X()+x;
//STRIP001 						long y1=aPt.Y()-y;
//STRIP001 						long y2=aPt.Y()+y;
//STRIP001 						if (bGlue) 
//STRIP001 						{ // ein Kreuzlein an jedem Punkt
//STRIP001 							pOut->DrawLine(Point(x1,y1),Point(x2,y2));
//STRIP001 							pOut->DrawLine(Point(x1,y2),Point(x2,y1));
//STRIP001 						} 
//STRIP001 						else 
//STRIP001 						{ // oder ein Kaestlein
//STRIP001 							pOut->DrawLine(Point(x1,y1),Point(x2,y1));
//STRIP001 							pOut->DrawLine(Point(x1,y2),Point(x2,y2));
//STRIP001 							pOut->DrawLine(Point(x1,y1),Point(x1,y2));
//STRIP001 							pOut->DrawLine(Point(x2,y1),Point(x2,y2));
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if (rXOut.GetOutDev()->GetOutDevType() == OUTDEV_WINDOW)
//STRIP001 					{
//STRIP001 						Rectangle aRect;
//STRIP001 						Window* pWin = (Window*) rXOut.GetOutDev();
//STRIP001 
//STRIP001 						if ((nPtAnz == 5 || nPtAnz == 6) &&
//STRIP001 							rXP.GetFlags(1) != XPOLY_CONTROL)
//STRIP001 						{
//STRIP001 							/**************************************************
//STRIP001 							* Ist es ein Rechteck? (keine Bezier-Kurve)
//STRIP001 							**************************************************/
//STRIP001 							if (nPtAnz == 6              &&
//STRIP001 								rXP[0].Y() == rXP[1].Y() &&
//STRIP001 								rXP[1].X() == rXP[2].X() &&
//STRIP001 								rXP[2].Y() == rXP[3].Y() &&
//STRIP001 								rXP[3].X() == rXP[4].X() &&
//STRIP001 								rXP[4].Y() == rXP[5].Y() &&
//STRIP001 								rXP[5]     == rXP[0])
//STRIP001 							{
//STRIP001 								// Spezielles Dragging-Rechteck (Drehsinn rechts)
//STRIP001 								aRect = Rectangle(rXP[2], rXP[4]);
//STRIP001 							}
//STRIP001 							else if (nPtAnz == 5              &&
//STRIP001 									 rXP[0].Y() == rXP[1].Y() &&
//STRIP001 									 rXP[1].X() == rXP[2].X() &&
//STRIP001 									 rXP[2].Y() == rXP[3].Y() &&
//STRIP001 									 rXP[3].X() == rXP[4].X() &&
//STRIP001 									 rXP[4]     == rXP[0])
//STRIP001 							{
//STRIP001 								// Rechteck (Drehsinn links)
//STRIP001 								aRect = rXP.GetBoundRect(pWin);
//STRIP001 							}
//STRIP001 							else if (nPtAnz == 5              &&
//STRIP001 									 rXP[0].X() == rXP[1].X() &&
//STRIP001 									 rXP[1].Y() == rXP[2].Y() &&
//STRIP001 									 rXP[2].X() == rXP[3].X() &&
//STRIP001 									 rXP[3].Y() == rXP[4].Y() &&
//STRIP001 									 rXP[4]     == rXP[0])
//STRIP001 							{
//STRIP001 								// Rechteck (Drehsinn rechts)
//STRIP001 								aRect = rXP.GetBoundRect(pWin);
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if (!aRect.IsEmpty())
//STRIP001 						{
//STRIP001 							pWin->InvertTracking(aRect, SHOWTRACK_OBJECT | SHOWTRACK_WINDOW);
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							const Polygon aPoly( XOutCreatePolygon(rXP, pWin) );
//STRIP001 							pWin->InvertTracking(aPoly, SHOWTRACK_WINDOW);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						rXOut.DrawXPolyLine(rXP);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	rView.ImpDrawEdgeXor(rXOut,bFull);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragMovHdl,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragMovHdl::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	rStr=ImpGetResStr(STR_DragMethMovHdl);
//STRIP001 	if (rView.IsDragWithCopy()) rStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMovHdl::Beg()
//STRIP001 {
//STRIP001 	DragStat().Ref1()=GetDragHdl()->GetPos();
//STRIP001 	DragStat().SetShown(!DragStat().IsShown());
//STRIP001 	SdrHdlKind eKind=GetDragHdl()->GetKind();
//STRIP001 	SdrHdl* pH1=GetHdlList().GetHdl(HDL_REF1);
//STRIP001 	SdrHdl* pH2=GetHdlList().GetHdl(HDL_REF2);
//STRIP001 	if (eKind==HDL_MIRX) {
//STRIP001 		if (pH1==NULL || pH2==NULL) {
//STRIP001 			DBG_ERROR("SdrDragMovHdl::Beg(): Verschieben der Spiegelachse: Referenzhandles nicht gefunden");
//STRIP001 			return FALSE;
//STRIP001 		}
//STRIP001 		DragStat().SetActionRect(Rectangle(pH1->GetPos(),pH2->GetPos()));
//STRIP001 	} else {
//STRIP001 		Point aPt(GetDragHdl()->GetPos());
//STRIP001 		DragStat().SetActionRect(Rectangle(aPt,aPt));
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMovHdl::Mov(const Point& rNoSnapPnt)
//STRIP001 {
//STRIP001 	Point aPnt(rNoSnapPnt);
//STRIP001 	if (DragStat().CheckMinMoved(rNoSnapPnt)) {
//STRIP001 		if (GetDragHdl()->GetKind()==HDL_MIRX) {
//STRIP001 			SdrHdl* pH1=GetHdlList().GetHdl(HDL_REF1);
//STRIP001 			SdrHdl* pH2=GetHdlList().GetHdl(HDL_REF2);
//STRIP001 			if (pH1==NULL || pH2==NULL) return;
//STRIP001 			if (!DragStat().IsNoSnap()) {
//STRIP001 				long nBestXSnap=0;
//STRIP001 				long nBestYSnap=0;
//STRIP001 				BOOL bXSnapped=FALSE;
//STRIP001 				BOOL bYSnapped=FALSE;
//STRIP001 				Point aDif(aPnt-DragStat().GetStart());
//STRIP001 				rView.CheckSnap(Ref1()+aDif,NULL,nBestXSnap,nBestYSnap,bXSnapped,bYSnapped);
//STRIP001 				rView.CheckSnap(Ref2()+aDif,NULL,nBestXSnap,nBestYSnap,bXSnapped,bYSnapped);
//STRIP001 				aPnt.X()+=nBestXSnap;
//STRIP001 				aPnt.Y()+=nBestYSnap;
//STRIP001 			}
//STRIP001 			if (aPnt!=DragStat().GetNow()) {
//STRIP001 				Hide();
//STRIP001 				DragStat().NextMove(aPnt);
//STRIP001 				Point aDif(DragStat().GetNow()-DragStat().GetStart());
//STRIP001 				pH1->SetPos(Ref1()+aDif);
//STRIP001 				pH2->SetPos(Ref2()+aDif);
//STRIP001 
//STRIP001 				SdrHdl* pHM = GetHdlList().GetHdl(HDL_MIRX);
//STRIP001 				if(pHM)
//STRIP001 					pHM->Touch();
//STRIP001 
//STRIP001 				Show();
//STRIP001 				DragStat().SetActionRect(Rectangle(pH1->GetPos(),pH2->GetPos()));
//STRIP001 			}
//STRIP001 		} else {
//STRIP001 			if (!DragStat().IsNoSnap()) SnapPos(aPnt);
//STRIP001 			long nSA=0;
//STRIP001 			if (rView.IsAngleSnapEnabled()) nSA=rView.GetSnapAngle();
//STRIP001 			if (rView.IsMirrorAllowed(TRUE,TRUE)) { // eingeschraenkt
//STRIP001 				if (!rView.IsMirrorAllowed(FALSE,FALSE)) nSA=4500;
//STRIP001 				if (!rView.IsMirrorAllowed(TRUE,FALSE)) nSA=9000;
//STRIP001 			}
//STRIP001 			if (rView.IsOrtho() && nSA!=9000) nSA=4500;
//STRIP001 			if (nSA!=0) { // Winkelfang
//STRIP001 				SdrHdlKind eRef=HDL_REF1;
//STRIP001 				if (GetDragHdl()->GetKind()==HDL_REF1) eRef=HDL_REF2;
//STRIP001 				SdrHdl* pH=GetHdlList().GetHdl(eRef);
//STRIP001 				if (pH!=NULL) {
//STRIP001 					Point aRef(pH->GetPos());
//STRIP001 					long nWink=NormAngle360(GetAngle(aPnt-aRef));
//STRIP001 					long nNeuWink=nWink;
//STRIP001 					nNeuWink+=nSA/2;
//STRIP001 					nNeuWink/=nSA;
//STRIP001 					nNeuWink*=nSA;
//STRIP001 					nNeuWink=NormAngle360(nNeuWink);
//STRIP001 					double a=(nNeuWink-nWink)*nPi180;
//STRIP001 					double nSin=sin(a);
//STRIP001 					double nCos=cos(a);
//STRIP001 					RotatePoint(aPnt,aRef,nSin,nCos);
//STRIP001 					// Bei bestimmten Werten Rundungsfehler ausschliessen:
//STRIP001 					if (nSA==9000) {
//STRIP001 						if (nNeuWink==0    || nNeuWink==18000) aPnt.Y()=aRef.Y();
//STRIP001 						if (nNeuWink==9000 || nNeuWink==27000) aPnt.X()=aRef.X();
//STRIP001 					}
//STRIP001 					if (nSA==4500) OrthoDistance8(aRef,aPnt,TRUE);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (aPnt!=DragStat().GetNow()) {
//STRIP001 				Hide();
//STRIP001 				DragStat().NextMove(aPnt);
//STRIP001 				GetDragHdl()->SetPos(DragStat().GetNow());
//STRIP001 				SdrHdl* pHM = GetHdlList().GetHdl(HDL_MIRX);
//STRIP001 				if(pHM)
//STRIP001 					pHM->Touch();
//STRIP001 				Show();
//STRIP001 				DragStat().SetActionRect(Rectangle(aPnt,aPnt));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMovHdl::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	switch (GetDragHdl()->GetKind()) {
//STRIP001 		case HDL_REF1: Ref1()=DragStat().GetNow(); break;
//STRIP001 		case HDL_REF2: Ref2()=DragStat().GetNow(); break;
//STRIP001 		case HDL_MIRX: {
//STRIP001 			Ref1()+=DragStat().GetNow()-DragStat().GetStart();
//STRIP001 			Ref2()+=DragStat().GetNow()-DragStat().GetStart();
//STRIP001 		} break;
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMovHdl::Brk()
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	GetDragHdl()->SetPos(DragStat().GetRef1());
//STRIP001 	SdrHdl* pHM = GetHdlList().GetHdl(HDL_MIRX);
//STRIP001 	if(pHM)
//STRIP001 		pHM->Touch();
//STRIP001 	Draw();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMovHdl::Show()
//STRIP001 {
//STRIP001 	SdrHdl* pDragHdl=GetDragHdl();
//STRIP001 	SdrHdlKind eDragHdl=pDragHdl->GetKind();
//STRIP001 	FASTBOOL bMirX=eDragHdl==HDL_MIRX;
//STRIP001 	FASTBOOL bShown=DragStat().IsShown();
//STRIP001 	if (rView.IsSolidMarkHdl()) {
//STRIP001 		if (!bShown) {
//STRIP001 			const SdrHdlList& rHL=GetHdlList();
//STRIP001 			SdrHdlKind eHdl1=eDragHdl;
//STRIP001 			SdrHdlKind eHdl2=eDragHdl;
//STRIP001 			if (bMirX) { eHdl1=HDL_REF1; eHdl2=HDL_REF2; }
//STRIP001 			SdrHdl* pHdl1=rHL.GetHdl(eHdl1);
//STRIP001 			SdrHdl* pHdl2=rHL.GetHdl(eHdl2);
//STRIP001 			ULONG nHdlNum1=rHL.GetHdlNum(pHdl1);
//STRIP001 			ULONG nHdlNum2=rHL.GetHdlNum(pHdl2);
//STRIP001 			if (nHdlNum1==CONTAINER_ENTRY_NOTFOUND || pHdl1==NULL) {
//STRIP001 				DBG_ERROR("SdrDragMovHdl::Show(): Handle nicht in der HandleList gefunden!");
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			if (bMirX && (nHdlNum2==CONTAINER_ENTRY_NOTFOUND || pHdl2==NULL)) {
//STRIP001 				DBG_ERROR("SdrDragMovHdl::Show(): Handle nicht in der HandleList gefunden!");
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SdrDragMethod::Show();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMovHdl::Hide()
//STRIP001 {
//STRIP001 	SdrHdl* pDragHdl=GetDragHdl();
//STRIP001 	SdrHdlKind eDragHdl=pDragHdl->GetKind();
//STRIP001 	FASTBOOL bMirX=eDragHdl==HDL_MIRX;
//STRIP001 	FASTBOOL bShown=DragStat().IsShown();
//STRIP001 	SdrDragMethod::Hide();
//STRIP001 	if (rView.IsSolidMarkHdl()) {
//STRIP001 		if (bShown) {
//STRIP001 			const SdrHdlList& rHL=GetHdlList();
//STRIP001 			SdrHdlKind eHdl1=eDragHdl;
//STRIP001 			SdrHdlKind eHdl2=eDragHdl;
//STRIP001 			if (bMirX) { eHdl1=HDL_REF1; eHdl2=HDL_REF2; }
//STRIP001 			SdrHdl* pHdl1=rHL.GetHdl(eHdl1);
//STRIP001 			SdrHdl* pHdl2=rHL.GetHdl(eHdl2);
//STRIP001 			ULONG nHdlNum1=rHL.GetHdlNum(pHdl1);
//STRIP001 			ULONG nHdlNum2=rHL.GetHdlNum(pHdl2);
//STRIP001 			if (nHdlNum1==CONTAINER_ENTRY_NOTFOUND || pHdl1==NULL) {
//STRIP001 				DBG_ERROR("SdrDragMovHdl::Hide(): Handle nicht in der HandleList gefunden!");
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			if (bMirX && (nHdlNum2==CONTAINER_ENTRY_NOTFOUND || pHdl2==NULL)) {
//STRIP001 				DBG_ERROR("SdrDragMovHdl::Hide(): Handle nicht in der HandleList gefunden!");
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragMovHdl::GetPointer() const
//STRIP001 {
//STRIP001 	const SdrHdl* pHdl=GetDragHdl();
//STRIP001 	if (pHdl!=NULL) {
//STRIP001 		return pHdl->GetPointer();
//STRIP001 	}
//STRIP001 	return Pointer(POINTER_REFHAND);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragObjOwn,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragObjOwn::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	const SdrObject* pObj=GetDragObj();
//STRIP001 	if (pObj!=NULL) {
//STRIP001 		rStr=pObj->GetDragComment(DragStat(),FALSE,FALSE);
//STRIP001 		// Kein Copy bei ObjOwn
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragObjOwn::Beg()
//STRIP001 {
//STRIP001 	SdrObject* pObj=GetDragObj();
//STRIP001 	return pObj!=NULL ? pObj->BegDrag(DragStat()) : FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragObjOwn::Mov(const Point& rNoSnapPnt)
//STRIP001 {
//STRIP001 	Point aPnt(rNoSnapPnt);
//STRIP001 	SdrPageView* pPV=GetDragPV();
//STRIP001 	if (pPV!=NULL) {
//STRIP001 		if (!DragStat().IsNoSnap()) SnapPos(aPnt);
//STRIP001 		FASTBOOL bOrtho=rView.IsOrtho();
//STRIP001 		if (rView.IsOrtho()) {
//STRIP001 			if (DragStat().IsOrtho8Possible()) OrthoDistance8(DragStat().GetStart(),aPnt,rView.IsBigOrtho());
//STRIP001 			else if (DragStat().IsOrtho4Possible()) OrthoDistance4(DragStat().GetStart(),aPnt,rView.IsBigOrtho());
//STRIP001 		}
//STRIP001 		const SdrHdl* pHdl=DragStat().GetHdl();
//STRIP001 		if (pHdl!=NULL) {
//STRIP001 			aPnt-=pPV->GetOffset();
//STRIP001 		}
//STRIP001 		SdrObject* pObj=GetDragObj();
//STRIP001 		if (pObj!=NULL && DragStat().CheckMinMoved(/*aPnt*/rNoSnapPnt)) {
//STRIP001 			if (aPnt!=DragStat().GetNow()) {
//STRIP001 				Hide();
//STRIP001 				DragStat().NextMove(aPnt);
//STRIP001 				pObj->MovDrag(DragStat());
//STRIP001 				pObj->TakeDragPoly(DragStat(),pPV->DragPoly());
//STRIP001 				Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragObjOwn::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	SdrUndoAction* pUndo=NULL;
//STRIP001 	SdrUndoAction* pUndo2=NULL;
//STRIP001 	FASTBOOL bRet=FALSE;
//STRIP001 	SdrObject* pObj=GetDragObj();
//STRIP001 	if (pObj!=NULL) {
//STRIP001 		if (!rView.IsInsObjPoint()) {
//STRIP001 			if (DragStat().IsEndDragChangesAttributes()) {
//STRIP001 				pUndo=new SdrUndoAttrObj(*pObj);
//STRIP001 				if (DragStat().IsEndDragChangesGeoAndAttributes()) {
//STRIP001 					pUndo2=new SdrUndoGeoObj(*pObj);
//STRIP001 				}
//STRIP001 			} else {
//STRIP001 				pUndo=new SdrUndoGeoObj(*pObj);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		bRet=pObj->EndDrag(DragStat());
//STRIP001 		
//STRIP001 		if(bRet)
//STRIP001 		{
//STRIP001 			if(pUndo) 
//STRIP001 			{
//STRIP001 				// #109992#
//STRIP001 				// Rescue the UNDO text if a 2nd undo is done here and put it
//STRIP001 				// into BegUndo() to have a comment in the UNDO field.
//STRIP001 				if(pUndo2) 
//STRIP001 				{
//STRIP001 					rView.BegUndo(pUndo->GetComment());
//STRIP001 				}
//STRIP001 
//STRIP001 				rView.AddUndo(pUndo);
//STRIP001 
//STRIP001 				if(pUndo2) 
//STRIP001 				{
//STRIP001 					rView.AddUndo(pUndo2);
//STRIP001 					rView.EndUndo();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		} else {
//STRIP001 			delete pUndo;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragObjOwn::DrawXor(ExtOutputDevice& rXOut, FASTBOOL bFull) const
//STRIP001 {
//STRIP001 	SdrPageView* pPV=GetDragPV();
//STRIP001 	if (pPV!=NULL) {
//STRIP001 		rXOut.SetOffset(pPV->GetOffset());
//STRIP001 		const XPolyPolygon& rXPP=pPV->DragPoly();
//STRIP001 		OutputDevice* pOut = rXOut.GetOutDev();
//STRIP001 		USHORT nAnz=rXPP.Count();
//STRIP001 		for (USHORT i=0; i<nAnz; i++) {
//STRIP001 			if (pOut->GetOutDevType() == OUTDEV_WINDOW)
//STRIP001 			{
//STRIP001 				const Polygon aPolygon( XOutCreatePolygon(rXPP[i], pOut) );
//STRIP001 				((Window*) pOut)->InvertTracking(aPolygon, SHOWTRACK_WINDOW);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rXOut.DrawXPolyLine(rXPP[i]);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragObjOwn::GetPointer() const
//STRIP001 {
//STRIP001 	const SdrHdl* pHdl=GetDragHdl();
//STRIP001 	if (pHdl!=NULL) {
//STRIP001 		return pHdl->GetPointer();
//STRIP001 	}
//STRIP001 	return Pointer(POINTER_MOVE);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragMove,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragMove::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 
//STRIP001 	ImpTakeDescriptionStr(STR_DragMethMove, rStr);
//STRIP001 	rStr.AppendAscii(" (x=");
//STRIP001 	rView.GetModel()->TakeMetricStr(DragStat().GetDX(), aStr);
//STRIP001 	rStr += aStr;
//STRIP001 	rStr.AppendAscii(" y=");
//STRIP001 	rView.GetModel()->TakeMetricStr(DragStat().GetDY(), aStr);
//STRIP001 	rStr += aStr;
//STRIP001 	rStr += sal_Unicode(')');
//STRIP001 	
//STRIP001 	if(rView.IsDragWithCopy()) 
//STRIP001 	{
//STRIP001 		if(!rView.IsInsObjPoint() && !rView.IsInsGluePoint()) 
//STRIP001 		{
//STRIP001 			rStr += ImpGetResStr(STR_EditWithCopy);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMove::Beg()
//STRIP001 {
//STRIP001 	SetDragPolys();
//STRIP001 	SetStripes(TRUE);
//STRIP001 	DragStat().SetActionRect(GetMarkedRect());
//STRIP001 	Show();
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMove::MovAllPoints()
//STRIP001 {
//STRIP001 	USHORT nPvAnz=rView.GetPageViewCount();
//STRIP001 	for (USHORT nv=0; nv<nPvAnz; nv++) {
//STRIP001 		SdrPageView* pPV=rView.GetPageViewPvNum(nv);
//STRIP001 		if (pPV->HasMarkedObj()) {
//STRIP001 			pPV->DragPoly()=pPV->DragPoly0();
//STRIP001 			pPV->DragPoly().Move(DragStat().GetDX(),DragStat().GetDY());
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMove::MovPoint(Point& rPnt, const Point& rPvOfs)
//STRIP001 {
//STRIP001 	rPnt.X()+=DragStat().GetDX();
//STRIP001 	rPnt.Y()+=DragStat().GetDY();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMove::ImpCheckSnap(const Point& rPt)
//STRIP001 {
//STRIP001 	Point aPt(rPt);
//STRIP001 	USHORT nRet=SnapPos(aPt);
//STRIP001 	aPt-=rPt;
//STRIP001 	if ((nRet & SDRSNAP_XSNAPPED) !=0) {
//STRIP001 		if (bXSnapped) {
//STRIP001 			if (Abs(aPt.X())<Abs(nBestXSnap)) {
//STRIP001 				nBestXSnap=aPt.X();
//STRIP001 			}
//STRIP001 		} else {
//STRIP001 			nBestXSnap=aPt.X();
//STRIP001 			bXSnapped=TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ((nRet & SDRSNAP_YSNAPPED) !=0) {
//STRIP001 		if (bYSnapped) {
//STRIP001 			if (Abs(aPt.Y())<Abs(nBestYSnap)) {
//STRIP001 				nBestYSnap=aPt.Y();
//STRIP001 			}
//STRIP001 		} else {
//STRIP001 			nBestYSnap=aPt.Y();
//STRIP001 			bYSnapped=TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMove::Mov(const Point& rNoSnapPnt_)
//STRIP001 {
//STRIP001 	nBestXSnap=0;
//STRIP001 	nBestYSnap=0;
//STRIP001 	bXSnapped=FALSE;
//STRIP001 	bYSnapped=FALSE;
//STRIP001 	Point aNoSnapPnt(rNoSnapPnt_);
//STRIP001 	const SdrHdl* pHdl=DragStat().GetHdl();
//STRIP001 	if (pHdl!=NULL && pHdl->GetPageView()!=NULL) {
//STRIP001 		aNoSnapPnt-=pHdl->GetPageView()->GetOffset();
//STRIP001 	}
//STRIP001 	const Rectangle& aSR=GetMarkedRect();
//STRIP001 	long nMovedx=aNoSnapPnt.X()-DragStat().GetStart().X();
//STRIP001 	long nMovedy=aNoSnapPnt.Y()-DragStat().GetStart().Y();
//STRIP001 	Point aLO(aSR.TopLeft());      aLO.X()+=nMovedx; aLO.Y()+=nMovedy;
//STRIP001 	Point aRU(aSR.BottomRight());  aRU.X()+=nMovedx; aRU.Y()+=nMovedy;
//STRIP001 	Point aLU(aLO.X(),aRU.Y());
//STRIP001 	Point aRO(aRU.X(),aLO.Y());
//STRIP001 	ImpCheckSnap(aLO);
//STRIP001 	if (!rView.IsMoveSnapOnlyTopLeft()) {
//STRIP001 		ImpCheckSnap(aRO);
//STRIP001 		ImpCheckSnap(aLU);
//STRIP001 		ImpCheckSnap(aRU);
//STRIP001 	}
//STRIP001 	Point aPnt(aNoSnapPnt.X()+nBestXSnap,aNoSnapPnt.Y()+nBestYSnap);
//STRIP001 	FASTBOOL bOrtho=rView.IsOrtho();
//STRIP001 	if (bOrtho) OrthoDistance8(DragStat().GetStart(),aPnt,rView.IsBigOrtho());
//STRIP001 	if (DragStat().CheckMinMoved(aNoSnapPnt)) {
//STRIP001 		Point aPt1(aPnt);
//STRIP001 		Rectangle aLR(rView.GetWorkArea());
//STRIP001 		FASTBOOL bWorkArea=!aLR.IsEmpty();
//STRIP001 		FASTBOOL bDragLimit=IsDragLimit();
//STRIP001 		if (bDragLimit || bWorkArea) {
//STRIP001 			Rectangle aSR(GetMarkedRect());
//STRIP001 			Point aD(aPt1-DragStat().GetStart());
//STRIP001 			if (bDragLimit) {
//STRIP001 				Rectangle aR2(GetDragLimitRect());
//STRIP001 				if (bWorkArea) aLR.Intersection(aR2);
//STRIP001 				else aLR=aR2;
//STRIP001 			}
//STRIP001 			if (aSR.Left()>aLR.Left() || aSR.Right()<aLR.Right()) { // ist ueberhaupt Platz zum verschieben?
//STRIP001 				aSR.Move(aD.X(),0);
//STRIP001 				if (aSR.Left()<aLR.Left()) {
//STRIP001 					aPt1.X()-=aSR.Left()-aLR.Left();
//STRIP001 				} else if (aSR.Right()>aLR.Right()) {
//STRIP001 					aPt1.X()-=aSR.Right()-aLR.Right();
//STRIP001 				}
//STRIP001 			} else aPt1.X()=DragStat().GetStart().X(); // kein Platz zum verschieben
//STRIP001 			if (aSR.Top()>aLR.Top() || aSR.Bottom()<aLR.Bottom()) { // ist ueberhaupt Platz zum verschieben?
//STRIP001 				aSR.Move(0,aD.Y());
//STRIP001 				if (aSR.Top()<aLR.Top()) {
//STRIP001 					aPt1.Y()-=aSR.Top()-aLR.Top();
//STRIP001 				} else if (aSR.Bottom()>aLR.Bottom()) {
//STRIP001 					aPt1.Y()-=aSR.Bottom()-aLR.Bottom();
//STRIP001 				}
//STRIP001 			} else aPt1.Y()=DragStat().GetStart().Y(); // kein Platz zum verschieben
//STRIP001 		}
//STRIP001 		if (rView.IsDraggingGluePoints()) { // Klebepunkte aufs BoundRect des Obj limitieren
//STRIP001 			aPt1-=DragStat().GetStart();
//STRIP001 			const SdrMarkList& rML=GetMarkList();
//STRIP001 			ULONG nMarkAnz=rML.GetMarkCount();
//STRIP001 			for (ULONG nMarkNum=0; nMarkNum<nMarkAnz; nMarkNum++) {
//STRIP001 				const SdrMark* pM=rML.GetMark(nMarkNum);
//STRIP001 				const SdrUShortCont* pPts=pM->GetMarkedGluePoints();
//STRIP001 				ULONG nPtAnz=pPts==NULL ? 0 : pPts->GetCount();
//STRIP001 				if (nPtAnz!=0) {
//STRIP001 					const SdrObject* pObj=pM->GetObj();
//STRIP001 					const SdrPageView* pPV=pM->GetPageView();
//STRIP001 					const SdrGluePointList* pGPL=pObj->GetGluePointList();
//STRIP001 					Rectangle aBound(pObj->GetBoundRect());
//STRIP001 					for (ULONG nPtNum=0; nPtNum<nPtAnz; nPtNum++) {
//STRIP001 						USHORT nId=pPts->GetObject(nPtNum);
//STRIP001 						USHORT nGlueNum=pGPL->FindGluePoint(nId);
//STRIP001 						if (nGlueNum!=SDRGLUEPOINT_NOTFOUND) {
//STRIP001 							Point aPt((*pGPL)[nGlueNum].GetAbsolutePos(*pObj));
//STRIP001 							aPt+=aPt1; // soviel soll verschoben werden
//STRIP001 							if (aPt.X()<aBound.Left()  ) aPt1.X()-=aPt.X()-aBound.Left()  ;
//STRIP001 							if (aPt.X()>aBound.Right() ) aPt1.X()-=aPt.X()-aBound.Right() ;
//STRIP001 							if (aPt.Y()<aBound.Top()   ) aPt1.Y()-=aPt.Y()-aBound.Top()   ;
//STRIP001 							if (aPt.Y()>aBound.Bottom()) aPt1.Y()-=aPt.Y()-aBound.Bottom();
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			aPt1+=DragStat().GetStart();
//STRIP001 		}
//STRIP001 		if (bOrtho) OrthoDistance8(DragStat().GetStart(),aPt1,FALSE);
//STRIP001 		if (aPt1!=DragStat().GetNow()) {
//STRIP001 			Hide();
//STRIP001 			DragStat().NextMove(aPt1);
//STRIP001 			MovAllPoints();
//STRIP001 			Rectangle aAction(GetMarkedRect());
//STRIP001 			aAction.Move(DragStat().GetDX(),DragStat().GetDY());
//STRIP001 			DragStat().SetActionRect(aAction);
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMove::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	if (rView.IsInsObjPoint() || rView.IsInsGluePoint()) bCopy=FALSE;
//STRIP001 	if (IsDraggingPoints()) {
//STRIP001 		rView.MoveMarkedPoints(Size(DragStat().GetDX(),DragStat().GetDY()),bCopy);
//STRIP001 	} else if (IsDraggingGluePoints()) {
//STRIP001 		rView.MoveMarkedGluePoints(Size(DragStat().GetDX(),DragStat().GetDY()),bCopy);
//STRIP001 	} else {
//STRIP001 		rView.MoveMarkedObj(Size(DragStat().GetDX(),DragStat().GetDY()),bCopy);
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMove::IsMoveOnly() const
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragMove::GetPointer() const
//STRIP001 {
//STRIP001 	if (IsDraggingPoints() || IsDraggingGluePoints()) {
//STRIP001 		return Pointer(POINTER_MOVEPOINT);
//STRIP001 	} else {
//STRIP001 		return Pointer(POINTER_MOVE);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragResize,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragResize::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	ImpTakeDescriptionStr(STR_DragMethResize, rStr);
//STRIP001 	BOOL bEqual(aXFact == aYFact);
//STRIP001 	Fraction aFact1(1,1);
//STRIP001 	Point aStart(DragStat().GetStart());
//STRIP001 	Point aRef(DragStat().GetRef1());
//STRIP001 	INT32 nXDiv(aStart.X() - aRef.X()); 
//STRIP001 	
//STRIP001 	if(!nXDiv) 
//STRIP001 		nXDiv = 1;
//STRIP001 
//STRIP001 	INT32 nYDiv(aStart.Y() - aRef.Y()); 
//STRIP001 	
//STRIP001 	if(!nYDiv) 
//STRIP001 		nYDiv = 1;
//STRIP001 
//STRIP001 	BOOL bX(aXFact != aFact1 && Abs(nXDiv) > 1);
//STRIP001 	BOOL bY(aYFact != aFact1 && Abs(nYDiv) > 1);
//STRIP001 	
//STRIP001 	if(bX || bY) 
//STRIP001 	{
//STRIP001 		XubString aStr;
//STRIP001 
//STRIP001 		rStr.AppendAscii(" (");
//STRIP001 		
//STRIP001 		if(bX) 
//STRIP001 		{
//STRIP001 			if(!bEqual) 
//STRIP001 				rStr.AppendAscii("x=");
//STRIP001 
//STRIP001 			rView.GetModel()->TakePercentStr(aXFact, aStr);
//STRIP001 			rStr += aStr;
//STRIP001 		}
//STRIP001 
//STRIP001 		if(bY && !bEqual) 
//STRIP001 		{
//STRIP001 			if(bX) 
//STRIP001 				rStr += sal_Unicode(' ');
//STRIP001 
//STRIP001 			rStr.AppendAscii("y=");
//STRIP001 			rView.GetModel()->TakePercentStr(aYFact, aStr);
//STRIP001 			rStr += aStr;
//STRIP001 		}
//STRIP001 
//STRIP001 		rStr += sal_Unicode(')');
//STRIP001 	}
//STRIP001 
//STRIP001 	if(rView.IsDragWithCopy()) 
//STRIP001 		rStr += ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragResize::Beg()
//STRIP001 {
//STRIP001 	SdrHdlKind eRefHdl=HDL_MOVE;
//STRIP001 	SdrHdl* pRefHdl=NULL;
//STRIP001 	switch (GetDragHdlKind()) {
//STRIP001 		case HDL_UPLFT: eRefHdl=HDL_LWRGT; break;
//STRIP001 		case HDL_UPPER: eRefHdl=HDL_LOWER; DragStat().SetHorFixed(TRUE); break;
//STRIP001 		case HDL_UPRGT: eRefHdl=HDL_LWLFT; break;
//STRIP001 		case HDL_LEFT : eRefHdl=HDL_RIGHT; DragStat().SetVerFixed(TRUE); break;
//STRIP001 		case HDL_RIGHT: eRefHdl=HDL_LEFT ; DragStat().SetVerFixed(TRUE); break;
//STRIP001 		case HDL_LWLFT: eRefHdl=HDL_UPRGT; break;
//STRIP001 		case HDL_LOWER: eRefHdl=HDL_UPPER; DragStat().SetHorFixed(TRUE); break;
//STRIP001 		case HDL_LWRGT: eRefHdl=HDL_UPLFT; break;
//STRIP001 	}
//STRIP001 	if (eRefHdl!=HDL_MOVE) pRefHdl=GetHdlList().GetHdl(eRefHdl);
//STRIP001 	if (pRefHdl!=NULL && !rView.IsResizeAtCenter()) {
//STRIP001 		DragStat().Ref1()=pRefHdl->GetPos();
//STRIP001 	} else {
//STRIP001 		SdrHdl* pRef1=GetHdlList().GetHdl(HDL_UPLFT);
//STRIP001 		SdrHdl* pRef2=GetHdlList().GetHdl(HDL_LWRGT);
//STRIP001 		if (pRef1!=NULL && pRef2!=NULL) {
//STRIP001 			DragStat().Ref1()=Rectangle(pRef1->GetPos(),pRef2->GetPos()).Center();
//STRIP001 		} else {
//STRIP001 			DragStat().Ref1()=GetMarkedRect().Center();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SetDragPolys();
//STRIP001 	Show();
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragResize::MovPoint(Point& rPnt, const Point& rPvOfs)
//STRIP001 {
//STRIP001 	Point aRef(DragStat().Ref1()-rPvOfs);
//STRIP001 	ResizePoint(rPnt,aRef,aXFact,aYFact);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragResize::Mov(const Point& rNoSnapPnt)
//STRIP001 {
//STRIP001 	Point aPnt(GetSnapPos(rNoSnapPnt));
//STRIP001 	Point aStart(DragStat().GetStart());
//STRIP001 	Point aRef(DragStat().GetRef1());
//STRIP001 	Fraction aMaxFact(0x7FFFFFFF,1);
//STRIP001 	Rectangle aLR(rView.GetWorkArea());
//STRIP001 	FASTBOOL bWorkArea=!aLR.IsEmpty();
//STRIP001 	FASTBOOL bDragLimit=IsDragLimit();
//STRIP001 	if (bDragLimit || bWorkArea) {
//STRIP001 		Rectangle aSR(GetMarkedRect());
//STRIP001 		if (bDragLimit) {
//STRIP001 			Rectangle aR2(GetDragLimitRect());
//STRIP001 			if (bWorkArea) aLR.Intersection(aR2);
//STRIP001 			else aLR=aR2;
//STRIP001 		}
//STRIP001 		if (aPnt.X()<aLR.Left()) aPnt.X()=aLR.Left();
//STRIP001 		else if (aPnt.X()>aLR.Right()) aPnt.X()=aLR.Right();
//STRIP001 		if (aPnt.Y()<aLR.Top()) aPnt.Y()=aLR.Top();
//STRIP001 		else if (aPnt.Y()>aLR.Bottom()) aPnt.Y()=aLR.Bottom();
//STRIP001 		if (aRef.X()>aSR.Left()) {
//STRIP001 			Fraction aMax(aRef.X()-aLR.Left(),aRef.X()-aSR.Left());
//STRIP001 			if (aMax<aMaxFact) aMaxFact=aMax;
//STRIP001 		}
//STRIP001 		if (aRef.X()<aSR.Right()) {
//STRIP001 			Fraction aMax(aLR.Right()-aRef.X(),aSR.Right()-aRef.X());
//STRIP001 			if (aMax<aMaxFact) aMaxFact=aMax;
//STRIP001 		}
//STRIP001 		if (aRef.Y()>aSR.Top()) {
//STRIP001 			Fraction aMax(aRef.Y()-aLR.Top(),aRef.Y()-aSR.Top());
//STRIP001 			if (aMax<aMaxFact) aMaxFact=aMax;
//STRIP001 		}
//STRIP001 		if (aRef.Y()<aSR.Bottom()) {
//STRIP001 			Fraction aMax(aLR.Bottom()-aRef.Y(),aSR.Bottom()-aRef.Y());
//STRIP001 			if (aMax<aMaxFact) aMaxFact=aMax;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	long nXDiv=aStart.X()-aRef.X(); if (nXDiv==0) nXDiv=1;
//STRIP001 	long nYDiv=aStart.Y()-aRef.Y(); if (nYDiv==0) nYDiv=1;
//STRIP001 	long nXMul=aPnt.X()-aRef.X();
//STRIP001 	long nYMul=aPnt.Y()-aRef.Y();
//STRIP001 	if (nXDiv<0) { nXDiv=-nXDiv; nXMul=-nXMul; }
//STRIP001 	if (nYDiv<0) { nYDiv=-nYDiv; nYMul=-nYMul; }
//STRIP001 	FASTBOOL bXNeg=nXMul<0; if (bXNeg) nXMul=-nXMul;
//STRIP001 	FASTBOOL bYNeg=nYMul<0; if (bYNeg) nYMul=-nYMul;
//STRIP001 	FASTBOOL bOrtho=rView.IsOrtho() || !rView.IsResizeAllowed(FALSE);
//STRIP001 	if (!DragStat().IsHorFixed() && !DragStat().IsVerFixed()) {
//STRIP001 		if (Abs(nXDiv)<=1 || Abs(nYDiv)<=1) bOrtho=FALSE;
//STRIP001 		if (bOrtho) {
//STRIP001 			if ((Fraction(nXMul,nXDiv)>Fraction(nYMul,nYDiv)) !=rView.IsBigOrtho()) {
//STRIP001 				nXMul=nYMul;
//STRIP001 				nXDiv=nYDiv;
//STRIP001 			} else {
//STRIP001 				nYMul=nXMul;
//STRIP001 				nYDiv=nXDiv;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	} else {
//STRIP001 		if (bOrtho) {
//STRIP001 			if (DragStat().IsHorFixed()) { bXNeg=FALSE; nXMul=nYMul; nXDiv=nYDiv; }
//STRIP001 			if (DragStat().IsVerFixed()) { bYNeg=FALSE; nYMul=nXMul; nYDiv=nXDiv; }
//STRIP001 		} else {
//STRIP001 			if (DragStat().IsHorFixed()) { bXNeg=FALSE; nXMul=1; nXDiv=1; }
//STRIP001 			if (DragStat().IsVerFixed()) { bYNeg=FALSE; nYMul=1; nYDiv=1; }
//STRIP001 		}
//STRIP001 	}
//STRIP001 	Fraction aNeuXFact(nXMul,nXDiv);
//STRIP001 	Fraction aNeuYFact(nYMul,nYDiv);
//STRIP001 	if (bOrtho) {
//STRIP001 		if (aNeuXFact>aMaxFact) {
//STRIP001 			aNeuXFact=aMaxFact;
//STRIP001 			aNeuYFact=aMaxFact;
//STRIP001 		}
//STRIP001 		if (aNeuYFact>aMaxFact) {
//STRIP001 			aNeuXFact=aMaxFact;
//STRIP001 			aNeuYFact=aMaxFact;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bXNeg) aNeuXFact=Fraction(-aNeuXFact.GetNumerator(),aNeuXFact.GetDenominator());
//STRIP001 	if (bYNeg) aNeuYFact=Fraction(-aNeuYFact.GetNumerator(),aNeuYFact.GetDenominator());
//STRIP001 	if (DragStat().CheckMinMoved(aPnt)) {
//STRIP001 		if ((!DragStat().IsHorFixed() && aPnt.X()!=DragStat().GetNow().X()) ||
//STRIP001 			(!DragStat().IsVerFixed() && aPnt.Y()!=DragStat().GetNow().Y())) {
//STRIP001 			Hide();
//STRIP001 			DragStat().NextMove(aPnt);
//STRIP001 			aXFact=aNeuXFact;
//STRIP001 			aYFact=aNeuYFact;
//STRIP001 			MovAllPoints();
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragResize::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	if (IsDraggingPoints()) {
//STRIP001 		rView.ResizeMarkedPoints(DragStat().Ref1(),aXFact,aYFact,bCopy);
//STRIP001 	} else if (IsDraggingGluePoints()) {
//STRIP001 		rView.ResizeMarkedGluePoints(DragStat().Ref1(),aXFact,aYFact,bCopy);
//STRIP001 	} else {
//STRIP001 		rView.ResizeMarkedObj(DragStat().Ref1(),aXFact,aYFact,bCopy);
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragResize::GetPointer() const
//STRIP001 {
//STRIP001 	const SdrHdl* pHdl=GetDragHdl();
//STRIP001 	if (pHdl!=NULL) {
//STRIP001 		return pHdl->GetPointer();
//STRIP001 	}
//STRIP001 	return Pointer(POINTER_MOVE);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragRotate,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragRotate::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	ImpTakeDescriptionStr(STR_DragMethRotate, rStr);
//STRIP001 	rStr.AppendAscii(" (");
//STRIP001 	XubString aStr;
//STRIP001 	INT32 nTmpWink(NormAngle360(nWink));
//STRIP001 	
//STRIP001 	if(bRight && nWink) 
//STRIP001 	{
//STRIP001 		nTmpWink -= 36000;
//STRIP001 	}
//STRIP001 
//STRIP001 	rView.GetModel()->TakeWinkStr(nTmpWink, aStr);
//STRIP001 	rStr += aStr;
//STRIP001 	rStr += sal_Unicode(')');
//STRIP001 
//STRIP001 	if(rView.IsDragWithCopy()) 
//STRIP001 		rStr += ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragRotate::Beg()
//STRIP001 {
//STRIP001 	SdrHdl* pH=GetHdlList().GetHdl(HDL_REF1);
//STRIP001 	if (pH!=NULL) {
//STRIP001 		SetDragPolys();
//STRIP001 		Show();
//STRIP001 		DragStat().Ref1()=pH->GetPos();
//STRIP001 		nWink0=GetAngle(DragStat().GetStart()-DragStat().GetRef1());
//STRIP001 		return TRUE;
//STRIP001 	} else {
//STRIP001 		DBG_ERROR("SdrDragRotate::Beg(): Kein Referenzpunkt-Handle gefunden");
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragRotate::MovPoint(Point& rPnt, const Point& rPvOfs)
//STRIP001 {
//STRIP001 	RotatePoint(rPnt,DragStat().GetRef1()-rPvOfs,nSin,nCos);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragRotate::Mov(const Point& rPnt_)
//STRIP001 {
//STRIP001 	Point aPnt(rPnt_);
//STRIP001 	const SdrHdl* pHdl=DragStat().GetHdl();
//STRIP001 	if (pHdl!=NULL && pHdl->GetPageView()!=NULL) {
//STRIP001 		aPnt-=pHdl->GetPageView()->GetOffset();
//STRIP001 	}
//STRIP001 	if (DragStat().CheckMinMoved(aPnt)) {
//STRIP001 		long nNeuWink=NormAngle360(GetAngle(aPnt-DragStat().GetRef1())-nWink0);
//STRIP001 		long nSA=0;
//STRIP001 		if (rView.IsAngleSnapEnabled()) nSA=rView.GetSnapAngle();
//STRIP001 		if (!rView.IsRotateAllowed(FALSE)) nSA=9000;
//STRIP001 		if (nSA!=0) { // Winkelfang
//STRIP001 			nNeuWink+=nSA/2;
//STRIP001 			nNeuWink/=nSA;
//STRIP001 			nNeuWink*=nSA;
//STRIP001 		}
//STRIP001 		nNeuWink=NormAngle180(nNeuWink);
//STRIP001 		if (nWink!=nNeuWink) {
//STRIP001 			USHORT nSekt0=GetAngleSector(nWink);
//STRIP001 			USHORT nSekt1=GetAngleSector(nNeuWink);
//STRIP001 			if (nSekt0==0 && nSekt1==3) bRight=TRUE;
//STRIP001 			if (nSekt0==3 && nSekt1==0) bRight=FALSE;
//STRIP001 			nWink=nNeuWink;
//STRIP001 			double a=nWink*nPi180;
//STRIP001 			double nSin1=sin(a); // schonmal berechnen, damit mgl. wenig Zeit
//STRIP001 			double nCos1=cos(a); // zwischen Hide() und Show() vergeht
//STRIP001 			Hide();
//STRIP001 			nSin=nSin1;
//STRIP001 			nCos=nCos1;
//STRIP001 			DragStat().NextMove(aPnt);
//STRIP001 			MovAllPoints();
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragRotate::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	if (nWink!=0) {
//STRIP001 		if (IsDraggingPoints()) {
//STRIP001 			rView.RotateMarkedPoints(DragStat().GetRef1(),nWink,bCopy);
//STRIP001 		} else if (IsDraggingGluePoints()) {
//STRIP001 			rView.RotateMarkedGluePoints(DragStat().GetRef1(),nWink,bCopy);
//STRIP001 		} else {
//STRIP001 			rView.RotateMarkedObj(DragStat().GetRef1(),nWink,bCopy);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragRotate::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_ROTATE);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragShear,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragShear::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	ImpTakeDescriptionStr(STR_DragMethShear, rStr);
//STRIP001 	rStr.AppendAscii(" (");
//STRIP001 	
//STRIP001 	INT32 nTmpWink(nWink);
//STRIP001 	
//STRIP001 	if(bUpSideDown) 
//STRIP001 		nTmpWink += 18000;
//STRIP001 
//STRIP001 	nTmpWink = NormAngle180(nTmpWink);
//STRIP001 
//STRIP001 	XubString aStr;
//STRIP001 	
//STRIP001 	rView.GetModel()->TakeWinkStr(nTmpWink, aStr);
//STRIP001 	rStr += aStr;
//STRIP001 	rStr += sal_Unicode(')');
//STRIP001 	
//STRIP001 	if(rView.IsDragWithCopy()) 
//STRIP001 		rStr += ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragShear::Beg()
//STRIP001 {
//STRIP001 	SdrHdlKind eRefHdl=HDL_MOVE;
//STRIP001 	SdrHdl* pRefHdl=NULL;
//STRIP001 	switch (GetDragHdlKind()) {
//STRIP001 		case HDL_UPPER: eRefHdl=HDL_LOWER; break;
//STRIP001 		case HDL_LOWER: eRefHdl=HDL_UPPER; break;
//STRIP001 		case HDL_LEFT : eRefHdl=HDL_RIGHT; bVertical=TRUE; break;
//STRIP001 		case HDL_RIGHT: eRefHdl=HDL_LEFT ; bVertical=TRUE; break;
//STRIP001 	}
//STRIP001 	if (eRefHdl!=HDL_MOVE) pRefHdl=GetHdlList().GetHdl(eRefHdl);
//STRIP001 	if (pRefHdl!=NULL) {
//STRIP001 		DragStat().Ref1()=pRefHdl->GetPos();
//STRIP001 		nWink0=GetAngle(DragStat().GetStart()-DragStat().GetRef1());
//STRIP001 	} else {
//STRIP001 		DBG_ERROR("SdrDragShear::Beg(): Kein Referenzpunkt-Handle fuer Shear gefunden");
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 	SetDragPolys();
//STRIP001 	Show();
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragShear::MovPoint(Point& rPnt, const Point& rPvOfs)
//STRIP001 {
//STRIP001 	Point aRef(DragStat().GetRef1()-rPvOfs);
//STRIP001 	if (bResize) {
//STRIP001 		if (bVertical) {
//STRIP001 			ResizePoint(rPnt,aRef,aFact,Fraction(1,1));
//STRIP001 		} else {
//STRIP001 			ResizePoint(rPnt,aRef,Fraction(1,1),aFact);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ShearPoint(rPnt,aRef,nTan,bVertical);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragShear::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	if (DragStat().CheckMinMoved(rPnt)) {
//STRIP001 		bResize=!rView.IsOrtho();
//STRIP001 		long nSA=0;
//STRIP001 		if (rView.IsAngleSnapEnabled()) nSA=rView.GetSnapAngle();
//STRIP001 		Point aP0(DragStat().GetStart());
//STRIP001 		Point aPnt(rPnt);
//STRIP001 		Fraction aNeuFact(1,1);
//STRIP001 		// Wenn kein Winkelfang, dann ggf. Rasterfang (ausser bei Slant)
//STRIP001 		if (nSA==0 && !bSlant) aPnt=GetSnapPos(aPnt);
//STRIP001 		if (!bSlant && !bResize) { // Shear ohne Resize
//STRIP001 			if (bVertical) aPnt.X()=aP0.X(); else aPnt.Y()=aP0.Y();
//STRIP001 		}
//STRIP001 		Point aRef(DragStat().GetRef1());
//STRIP001 		Point aDif(aPnt-aRef);
//STRIP001 
//STRIP001 		long nNeuWink=0;
//STRIP001 		if (bSlant) {
//STRIP001 			nNeuWink=NormAngle180(-(GetAngle(aDif)-nWink0));
//STRIP001 			if (bVertical) nNeuWink=NormAngle180(-nNeuWink);
//STRIP001 		} else {
//STRIP001 			if (bVertical) nNeuWink=NormAngle180(GetAngle(aDif));
//STRIP001 			else nNeuWink=NormAngle180(-(GetAngle(aDif)-9000));
//STRIP001 			if (nNeuWink<-9000 || nNeuWink>9000) nNeuWink=NormAngle180(nNeuWink+18000);
//STRIP001 			if (bResize) {
//STRIP001 				Point aPt2(aPnt);
//STRIP001 				if (nSA!=0) aPt2=GetSnapPos(aPnt); // den also in jedem Falle fangen
//STRIP001 				if (bVertical) {
//STRIP001 					aNeuFact=Fraction(aPt2.X()-aRef.X(),aP0.X()-aRef.X());
//STRIP001 				} else {
//STRIP001 					aNeuFact=Fraction(aPt2.Y()-aRef.Y(),aP0.Y()-aRef.Y());
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		FASTBOOL bNeg=nNeuWink<0;
//STRIP001 		if (bNeg) nNeuWink=-nNeuWink;
//STRIP001 		if (nSA!=0) { // Winkelfang
//STRIP001 			nNeuWink+=nSA/2;
//STRIP001 			nNeuWink/=nSA;
//STRIP001 			nNeuWink*=nSA;
//STRIP001 		}
//STRIP001 		nNeuWink=NormAngle360(nNeuWink);
//STRIP001 		bUpSideDown=nNeuWink>9000 && nNeuWink<27000;
//STRIP001 		if (bSlant) { // Resize fuer Slant berechnen
//STRIP001 			// Mit Winkelfang jedoch ohne 89deg Begrenzung
//STRIP001 			long nTmpWink=nNeuWink;
//STRIP001 			if (bUpSideDown) nNeuWink-=18000;
//STRIP001 			if (bNeg) nTmpWink=-nTmpWink;
//STRIP001 			bResize=TRUE;
//STRIP001 			double nCos=cos(nTmpWink*nPi180);
//STRIP001 			aNeuFact=nCos;
//STRIP001 			Kuerzen(aFact,10); // 3 Dezimalstellen sollten reichen
//STRIP001 		}
//STRIP001 		if (nNeuWink>8900) nNeuWink=8900;
//STRIP001 		if (bNeg) nNeuWink=-nNeuWink;
//STRIP001 		if (nWink!=nNeuWink || aFact!=aNeuFact) {
//STRIP001 			nWink=nNeuWink;
//STRIP001 			aFact=aNeuFact;
//STRIP001 			double a=nWink*nPi180;
//STRIP001 			double nTan1=0.0;
//STRIP001 			nTan1=tan(a); // schonmal berechnen, damit mgl. wenig Zeit zwischen Hide() und Show() vergeht
//STRIP001 			Hide();
//STRIP001 			nTan=nTan1;
//STRIP001 			DragStat().NextMove(rPnt);
//STRIP001 			MovAllPoints();
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragShear::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	if (bResize && aFact==Fraction(1,1)) bResize=FALSE;
//STRIP001 	if (nWink!=0 || bResize) {
//STRIP001 		if (nWink!=0 && bResize) {
//STRIP001 			XubString aStr;
//STRIP001 			ImpTakeDescriptionStr(STR_EditShear,aStr);
//STRIP001 			if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 			rView.BegUndo(aStr);
//STRIP001 		}
//STRIP001 		if (bResize) {
//STRIP001 			if (bVertical) {
//STRIP001 				rView.ResizeMarkedObj(DragStat().GetRef1(),aFact,Fraction(1,1),bCopy);
//STRIP001 			} else {
//STRIP001 				rView.ResizeMarkedObj(DragStat().GetRef1(),Fraction(1,1),aFact,bCopy);
//STRIP001 			}
//STRIP001 			bCopy=FALSE;
//STRIP001 		}
//STRIP001 		if (nWink!=0) {
//STRIP001 			rView.ShearMarkedObj(DragStat().GetRef1(),nWink,bVertical,bCopy);
//STRIP001 		}
//STRIP001 		if (nWink!=0 && bResize) rView.EndUndo();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragShear::GetPointer() const
//STRIP001 {
//STRIP001 	if (bVertical) return Pointer(POINTER_VSHEAR);
//STRIP001 	else return Pointer(POINTER_HSHEAR);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragMirror,SdrDragMethod);
//STRIP001 
//STRIP001 FASTBOOL SdrDragMirror::ImpCheckSide(const Point& rPnt) const
//STRIP001 {
//STRIP001 	long nWink1=GetAngle(rPnt-DragStat().GetRef1());
//STRIP001 	nWink1-=nWink;
//STRIP001 	nWink1=NormAngle360(nWink1);
//STRIP001 	return nWink1<18000;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMirror::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	if (aDif.X()==0) ImpTakeDescriptionStr(STR_DragMethMirrorHori,rStr);
//STRIP001 	else if (aDif.Y()==0) ImpTakeDescriptionStr(STR_DragMethMirrorVert,rStr);
//STRIP001 	else if (Abs(aDif.X())==Abs(aDif.Y())) ImpTakeDescriptionStr(STR_DragMethMirrorDiag,rStr);
//STRIP001 	else ImpTakeDescriptionStr(STR_DragMethMirrorFree,rStr);
//STRIP001 	if (rView.IsDragWithCopy()) rStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMirror::Beg()
//STRIP001 {
//STRIP001 	SdrHdl* pH1=GetHdlList().GetHdl(HDL_REF1);
//STRIP001 	SdrHdl* pH2=GetHdlList().GetHdl(HDL_REF2);
//STRIP001 	if (pH1!=NULL && pH2!=NULL) {
//STRIP001 		DragStat().Ref1()=pH1->GetPos();
//STRIP001 		DragStat().Ref2()=pH2->GetPos();
//STRIP001 		Ref1()=pH1->GetPos();
//STRIP001 		Ref2()=pH2->GetPos();
//STRIP001 		aDif=pH2->GetPos()-pH1->GetPos();
//STRIP001 		FASTBOOL b90=(aDif.X()==0) || aDif.Y()==0;
//STRIP001 		FASTBOOL b45=b90 || (Abs(aDif.X())==Abs(aDif.Y()));
//STRIP001 		nWink=NormAngle360(GetAngle(aDif));
//STRIP001 		if (!rView.IsMirrorAllowed(FALSE,FALSE) && !b45) return FALSE; // freier Achsenwinkel nicht erlaubt
//STRIP001 		if (!rView.IsMirrorAllowed(TRUE,FALSE) && !b90) return FALSE;  // 45deg auch nicht erlaubt
//STRIP001 		bSide0=ImpCheckSide(DragStat().GetStart());
//STRIP001 		SetDragPolys();
//STRIP001 		Show();
//STRIP001 		return TRUE;
//STRIP001 	} else {
//STRIP001 		DBG_ERROR("SdrDragMirror::Beg(): Spiegelachse nicht gefunden");
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMirror::MovPoint(Point& rPnt, const Point& rPvOfs)
//STRIP001 {
//STRIP001 	if (bMirrored) {
//STRIP001 		Point aRef1(DragStat().GetRef1()-rPvOfs);
//STRIP001 		Point aRef2(DragStat().GetRef2()-rPvOfs);
//STRIP001 		MirrorPoint(rPnt,aRef1,aRef2);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragMirror::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	if (DragStat().CheckMinMoved(rPnt)) {
//STRIP001 		FASTBOOL bNeuSide=ImpCheckSide(rPnt);
//STRIP001 		FASTBOOL bNeuMirr=bSide0!=bNeuSide;
//STRIP001 		if (bMirrored!=bNeuMirr) {
//STRIP001 			Hide();
//STRIP001 			bMirrored=bNeuMirr;
//STRIP001 			DragStat().NextMove(rPnt);
//STRIP001 			MovAllPoints();
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragMirror::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	if (bMirrored) {
//STRIP001 		rView.MirrorMarkedObj(DragStat().GetRef1(),DragStat().GetRef2(),bCopy);
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragMirror::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_MIRROR);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragGradient, SdrDragMethod);
//STRIP001 
//STRIP001 SdrDragGradient::SdrDragGradient(SdrDragView& rNewView, BOOL bGrad)
//STRIP001 :	SdrDragMethod(rNewView),
//STRIP001 	pIAOHandle(NULL),
//STRIP001 	bIsGradient(bGrad)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragGradient::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	if(IsGradient())
//STRIP001 		ImpTakeDescriptionStr(STR_DragMethGradient, rStr);
//STRIP001 	else
//STRIP001 		ImpTakeDescriptionStr(STR_DragMethTransparence, rStr);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragGradient::Beg()
//STRIP001 {
//STRIP001 	FASTBOOL bRetval(FALSE);
//STRIP001 
//STRIP001 	pIAOHandle = (SdrHdlGradient*)GetHdlList().GetHdl(IsGradient() ? HDL_GRAD : HDL_TRNS);
//STRIP001 	if(pIAOHandle) 
//STRIP001 	{
//STRIP001 		// save old values
//STRIP001 		DragStat().Ref1() = pIAOHandle->GetPos();
//STRIP001 		DragStat().Ref2() = pIAOHandle->Get2ndPos();
//STRIP001 
//STRIP001 		// what was hit?
//STRIP001 		BOOL bHit(FALSE);
//STRIP001 		SdrHdlColor* pColHdl = pIAOHandle->GetColorHdl1();
//STRIP001 		
//STRIP001 		// init handling flags
//STRIP001 		pIAOHandle->SetMoveSingleHandle(FALSE);
//STRIP001 		pIAOHandle->SetMoveFirstHandle(FALSE);
//STRIP001 
//STRIP001 		// test first color handle
//STRIP001 		if(pColHdl)
//STRIP001 		{
//STRIP001 			const B2dIAOGroup& rIAOGroup = pColHdl->GetIAOGroup();
//STRIP001 			if(rIAOGroup.GetIAOCount())
//STRIP001 			{
//STRIP001 				Point aPixelPos(rIAOGroup.GetIAObject(0)->GetManager()->GetWindow()->LogicToPixel(DragStat().GetStart()));
//STRIP001 				if(rIAOGroup.IsHit(aPixelPos))
//STRIP001 				{
//STRIP001 					bHit = TRUE;
//STRIP001 					pIAOHandle->SetMoveSingleHandle(TRUE);
//STRIP001 					pIAOHandle->SetMoveFirstHandle(TRUE);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// test second color handle
//STRIP001 		pColHdl = pIAOHandle->GetColorHdl2();
//STRIP001 		if(!bHit && pColHdl)
//STRIP001 		{
//STRIP001 			const B2dIAOGroup& rIAOGroup = pColHdl->GetIAOGroup();
//STRIP001 			if(rIAOGroup.GetIAOCount())
//STRIP001 			{
//STRIP001 				Point aPixelPos(rIAOGroup.GetIAObject(0)->GetManager()->GetWindow()->LogicToPixel(DragStat().GetStart()));
//STRIP001 				if(rIAOGroup.IsHit(aPixelPos))
//STRIP001 				{
//STRIP001 					bHit = TRUE;
//STRIP001 					pIAOHandle->SetMoveSingleHandle(TRUE);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// test gradient handle itself
//STRIP001 		if(!bHit)
//STRIP001 		{
//STRIP001 			const B2dIAOGroup& rIAOGroup = pIAOHandle->GetIAOGroup();
//STRIP001 			if(rIAOGroup.GetIAOCount())
//STRIP001 			{
//STRIP001 				Point aPixelPos(rIAOGroup.GetIAObject(0)->GetManager()->GetWindow()->LogicToPixel(DragStat().GetStart()));
//STRIP001 				if(rIAOGroup.IsHit(aPixelPos))
//STRIP001 				{
//STRIP001 					bHit = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// everything up and running :o}
//STRIP001 		bRetval = bHit;
//STRIP001 	} 
//STRIP001 	else 
//STRIP001 		DBG_ERROR("SdrDragGradient::Beg(): IAOGradient nicht gefunden");
//STRIP001 
//STRIP001 	return bRetval;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragGradient::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	if(pIAOHandle && DragStat().CheckMinMoved(rPnt)) 
//STRIP001 	{
//STRIP001 		DragStat().NextMove(rPnt);
//STRIP001 		
//STRIP001 		// Do the Move here!!! DragStat().GetStart()
//STRIP001 		Point aMoveDiff = rPnt - DragStat().GetStart();
//STRIP001 
//STRIP001 		if(pIAOHandle->IsMoveSingleHandle())
//STRIP001 		{
//STRIP001 			if(pIAOHandle->IsMoveFirstHandle())
//STRIP001 			{
//STRIP001 				pIAOHandle->SetPos(DragStat().Ref1() + aMoveDiff);
//STRIP001 				if(pIAOHandle->GetColorHdl1())
//STRIP001 					pIAOHandle->GetColorHdl1()->SetPos(DragStat().Ref1() + aMoveDiff);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pIAOHandle->Set2ndPos(DragStat().Ref2() + aMoveDiff);
//STRIP001 				if(pIAOHandle->GetColorHdl2())
//STRIP001 					pIAOHandle->GetColorHdl2()->SetPos(DragStat().Ref2() + aMoveDiff);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pIAOHandle->SetPos(DragStat().Ref1() + aMoveDiff);
//STRIP001 			pIAOHandle->Set2ndPos(DragStat().Ref2() + aMoveDiff);
//STRIP001 			if(pIAOHandle->GetColorHdl1())
//STRIP001 				pIAOHandle->GetColorHdl1()->SetPos(DragStat().Ref1() + aMoveDiff);
//STRIP001 			if(pIAOHandle->GetColorHdl2())
//STRIP001 				pIAOHandle->GetColorHdl2()->SetPos(DragStat().Ref2() + aMoveDiff);
//STRIP001 		}
//STRIP001 		
//STRIP001 		// new state
//STRIP001 		pIAOHandle->FromIAOToItem(rView.GetMarkList().GetMark(0)->GetObj(), FALSE, FALSE);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragGradient::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	// here the result is clear, do something with the values
//STRIP001 	Ref1() = pIAOHandle->GetPos();
//STRIP001 	Ref2() = pIAOHandle->Get2ndPos();
//STRIP001 
//STRIP001 	// new state
//STRIP001 	pIAOHandle->FromIAOToItem(rView.GetMarkList().GetMark(0)->GetObj(), TRUE, TRUE);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragGradient::Brk()
//STRIP001 {
//STRIP001 	// restore old values
//STRIP001 	pIAOHandle->SetPos(DragStat().Ref1());
//STRIP001 	pIAOHandle->Set2ndPos(DragStat().Ref2());
//STRIP001 	if(pIAOHandle->GetColorHdl1())
//STRIP001 		pIAOHandle->GetColorHdl1()->SetPos(DragStat().Ref1());
//STRIP001 	if(pIAOHandle->GetColorHdl2())
//STRIP001 		pIAOHandle->GetColorHdl2()->SetPos(DragStat().Ref2());
//STRIP001 
//STRIP001 	// new state
//STRIP001 	pIAOHandle->FromIAOToItem(rView.GetMarkList().GetMark(0)->GetObj(), TRUE, FALSE);
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragGradient::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_REFHAND);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragCrook,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragCrook::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	ImpTakeDescriptionStr(!bContortion ? STR_DragMethCrook : STR_DragMethCrookContortion, rStr);
//STRIP001 
//STRIP001 	if(bValid) 
//STRIP001 	{
//STRIP001 		rStr.AppendAscii(" (");
//STRIP001 		
//STRIP001 		XubString aStr;
//STRIP001 		INT32 nVal(nWink);
//STRIP001 		
//STRIP001 		if(bAtCenter) 
//STRIP001 			nVal *= 2;
//STRIP001 
//STRIP001 		nVal = Abs(nVal);
//STRIP001 		rView.GetModel()->TakeWinkStr(nVal, aStr);
//STRIP001 		rStr += aStr;
//STRIP001 		rStr += sal_Unicode(')');
//STRIP001 	}
//STRIP001 
//STRIP001 	if(rView.IsDragWithCopy()) 
//STRIP001 		rStr += ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 // #96920#
//STRIP001 void ImplAddDragRaster(XPolyPolygon& rPolyPoly, const Rectangle& rRect, 
//STRIP001 	sal_uInt32 nHorDiv, sal_uInt32 nVerDiv)
//STRIP001 {
//STRIP001 	const sal_uInt32 nXLen(rRect.GetWidth() / nHorDiv);
//STRIP001 	const sal_uInt32 nYLen(rRect.GetHeight() / nVerDiv);
//STRIP001 
//STRIP001 	sal_Int32 nYPos(rRect.Top());
//STRIP001 	const sal_uInt32 nXLenOneThird(nXLen / 3);
//STRIP001 
//STRIP001 	sal_uInt32 a, b;
//STRIP001 
//STRIP001 	for(a = 0; a <= nVerDiv; a++)
//STRIP001 	{
//STRIP001 		// hor lines
//STRIP001 		for(b = 0; b < nHorDiv; b++)
//STRIP001 		{
//STRIP001 			XPolygon aHorLineSegment(4);
//STRIP001 
//STRIP001 			aHorLineSegment[0] = Point(rRect.Left() + (b * nXLen), nYPos);
//STRIP001 			aHorLineSegment[3] = Point(aHorLineSegment[0].X() + nXLen, nYPos);
//STRIP001 			aHorLineSegment[1] = Point(aHorLineSegment[0].X() + nXLenOneThird, nYPos);
//STRIP001 			aHorLineSegment.SetFlags(1, XPOLY_CONTROL);
//STRIP001 			aHorLineSegment[2] = Point(aHorLineSegment[3].X() - nXLenOneThird, nYPos);
//STRIP001 			aHorLineSegment.SetFlags(2, XPOLY_CONTROL);
//STRIP001 			rPolyPoly.Insert(aHorLineSegment);
//STRIP001 		}
//STRIP001 
//STRIP001 		// increments
//STRIP001 		nYPos += nYLen;
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Int32 nXPos(rRect.Left());
//STRIP001 	const sal_uInt32 nYLenOneThird(nYLen / 3);
//STRIP001 
//STRIP001 	for(a = 0; a <= nHorDiv; a++)
//STRIP001 	{
//STRIP001 		// ver lines
//STRIP001 		for(b = 0; b < nVerDiv; b++)
//STRIP001 		{
//STRIP001 			XPolygon aVerLineSegment(4);
//STRIP001 
//STRIP001 			aVerLineSegment[0] = Point(nXPos, rRect.Top() + (b * nYLen));
//STRIP001 			aVerLineSegment[3] = Point(nXPos, aVerLineSegment[0].Y() + nYLen);
//STRIP001 			aVerLineSegment[1] = Point(nXPos, aVerLineSegment[0].Y() + nYLenOneThird);
//STRIP001 			aVerLineSegment.SetFlags(1, XPOLY_CONTROL);
//STRIP001 			aVerLineSegment[2] = Point(nXPos, aVerLineSegment[3].Y() - nYLenOneThird);
//STRIP001 			aVerLineSegment.SetFlags(2, XPOLY_CONTROL);
//STRIP001 			rPolyPoly.Insert(aVerLineSegment);
//STRIP001 		}
//STRIP001 
//STRIP001 		// increments
//STRIP001 		nXPos += nXLen;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // #96920# These defines parametrise the created raster
//STRIP001 // for interactions
//STRIP001 #define DRAG_CROOK_RASTER_MINIMUM	(4)
//STRIP001 #define DRAG_CROOK_RASTER_MAXIMUM	(15)
//STRIP001 #define DRAG_CROOK_RASTER_DISTANCE	(30)
//STRIP001 
//STRIP001 FASTBOOL SdrDragCrook::Beg()
//STRIP001 {
//STRIP001 	bContortionAllowed=rView.IsCrookAllowed(FALSE);
//STRIP001 	bNoContortionAllowed=rView.IsCrookAllowed(TRUE);
//STRIP001 	bResizeAllowed=rView.IsResizeAllowed(FALSE);
//STRIP001 	bRotateAllowed=rView.IsRotateAllowed(FALSE);
//STRIP001 	if (bContortionAllowed || bNoContortionAllowed) {
//STRIP001 		bVertical=(GetDragHdlKind()==HDL_LOWER || GetDragHdlKind()==HDL_UPPER);
//STRIP001 		aMarkRect=GetMarkedRect();
//STRIP001 		aMarkCenter=aMarkRect.Center();
//STRIP001 		nMarkSize=bVertical ? (aMarkRect.GetHeight()-1) : (aMarkRect.GetWidth()-1);
//STRIP001 		aCenter=aMarkCenter;
//STRIP001 		aStart=DragStat().GetStart();
//STRIP001 		SetDragPolysSeparated();
//STRIP001 
//STRIP001 		// #96920# Add extended XOR frame raster
//STRIP001 		const sal_uInt16 nPageViewNum(rView.GetPageViewCount());
//STRIP001 		for(sal_uInt16 a(0); a < nPageViewNum; a++) 
//STRIP001 		{
//STRIP001 			SdrPageView* pPV = rView.GetPageViewPvNum(a);
//STRIP001 			OutputDevice* pOut = (pPV->GetWinList())[0].GetOutputDevice();
//STRIP001 			Rectangle aPixelSize = pOut->LogicToPixel(aMarkRect);
//STRIP001 
//STRIP001 			sal_uInt32 nHorDiv(aPixelSize.GetWidth() / DRAG_CROOK_RASTER_DISTANCE);
//STRIP001 			sal_uInt32 nVerDiv(aPixelSize.GetHeight() / DRAG_CROOK_RASTER_DISTANCE);
//STRIP001 
//STRIP001 			if(nHorDiv > DRAG_CROOK_RASTER_MAXIMUM)
//STRIP001 				nHorDiv = DRAG_CROOK_RASTER_MAXIMUM;
//STRIP001 			if(nHorDiv < DRAG_CROOK_RASTER_MINIMUM)
//STRIP001 				nHorDiv = DRAG_CROOK_RASTER_MINIMUM;
//STRIP001 
//STRIP001 			if(nVerDiv > DRAG_CROOK_RASTER_MAXIMUM)
//STRIP001 				nVerDiv = DRAG_CROOK_RASTER_MAXIMUM;
//STRIP001 			if(nVerDiv < DRAG_CROOK_RASTER_MINIMUM)
//STRIP001 				nVerDiv = DRAG_CROOK_RASTER_MINIMUM;
//STRIP001 
//STRIP001 			ImplAddDragRaster(pPV->DragPoly0(), aMarkRect, nHorDiv, nVerDiv);
//STRIP001 			pPV->DragPoly() = pPV->DragPoly0();
//STRIP001 		}
//STRIP001 
//STRIP001 		Show();
//STRIP001 		return TRUE;
//STRIP001 	} else {
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragCrook::MovAllPoints()
//STRIP001 {
//STRIP001 	USHORT nPvAnz=rView.GetPageViewCount();
//STRIP001 	for (USHORT nv=0; nv<nPvAnz; nv++) {
//STRIP001 		SdrPageView* pPV=rView.GetPageViewPvNum(nv);
//STRIP001 		pPV->DragPoly()=pPV->DragPoly0();
//STRIP001 		if (pPV->HasMarkedObj()) {
//STRIP001 			Point aPvOfs(pPV->GetOffset());
//STRIP001 			USHORT nPolyAnz=pPV->DragPoly().Count();
//STRIP001 			if (!bContortion && !rView.IsNoDragXorPolys()) {
//STRIP001 				USHORT n1st=0,nLast=0;
//STRIP001 				Point aC(aCenter);
//STRIP001 				aC-=aPvOfs;
//STRIP001 				while (n1st<nPolyAnz) {
//STRIP001 					nLast=n1st;
//STRIP001 					while (nLast<nPolyAnz && pPV->DragPoly()[nLast].GetPointCount()!=0) nLast++;
//STRIP001 					Rectangle aBound(pPV->DragPoly()[n1st].GetBoundRect());
//STRIP001 					USHORT i;
//STRIP001 					for (i=n1st+1; i<nLast; i++) {
//STRIP001 						aBound.Union(pPV->DragPoly()[n1st].GetBoundRect());
//STRIP001 					}
//STRIP001 					Point aCtr0(aBound.Center());
//STRIP001 					Point aCtr1(aCtr0);
//STRIP001 					if (bResize) {
//STRIP001 						Fraction aFact1(1,1);
//STRIP001 						if (bVertical) {
//STRIP001 							ResizePoint(aCtr1,aC,aFact1,aFact);
//STRIP001 						} else {
//STRIP001 							ResizePoint(aCtr1,aC,aFact,aFact1);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					FASTBOOL bRotOk=FALSE;
//STRIP001 					double nSin,nCos;
//STRIP001 					if (aRad.X()!=0 && aRad.Y()!=0) {
//STRIP001 						bRotOk=bRotate;
//STRIP001 						switch (eMode) {
//STRIP001 							case SDRCROOK_ROTATE : CrookRotateXPoint (aCtr1,NULL,NULL,aC,aRad,nSin,nCos,bVertical);           break;
//STRIP001 							case SDRCROOK_SLANT  : CrookSlantXPoint  (aCtr1,NULL,NULL,aC,aRad,nSin,nCos,bVertical);           break;
//STRIP001 							case SDRCROOK_STRETCH: CrookStretchXPoint(aCtr1,NULL,NULL,aC,aRad,nSin,nCos,bVertical,aMarkRect); break;
//STRIP001 						} // switch
//STRIP001 					}
//STRIP001 					aCtr1-=aCtr0;
//STRIP001 					for (i=n1st; i<nLast; i++) {
//STRIP001 						if (bRotOk) {
//STRIP001 							RotateXPoly(pPV->DragPoly()[i],aCtr0,nSin,nCos);
//STRIP001 						}
//STRIP001 						pPV->DragPoly()[i].Move(aCtr1.X(),aCtr1.Y());
//STRIP001 					}
//STRIP001 					n1st=nLast+1;
//STRIP001 				}
//STRIP001 			} else {
//STRIP001 				USHORT i,j;
//STRIP001 				for (j=0; j<nPolyAnz; j++) {
//STRIP001 					XPolygon& aPol=pPV->DragPoly()[j];
//STRIP001 					USHORT nPtAnz=aPol.GetPointCount();
//STRIP001 					i=0;
//STRIP001 					while (i<nPtAnz) {
//STRIP001 						Point* pPnt=&aPol[i];
//STRIP001 						Point* pC1=NULL;
//STRIP001 						Point* pC2=NULL;
//STRIP001 						if (i+1<nPtAnz && aPol.IsControl(i)) { // Kontrollpunkt links
//STRIP001 							pC1=pPnt;
//STRIP001 							i++;
//STRIP001 							pPnt=&aPol[i];
//STRIP001 						}
//STRIP001 						i++;
//STRIP001 						if (i<nPtAnz && aPol.IsControl(i)) { // Kontrollpunkt rechts
//STRIP001 							pC2=&aPol[i];
//STRIP001 							i++;
//STRIP001 						}
//STRIP001 						MovPoint(*pPnt,aPvOfs,pC1,pC2);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragCrook::MovPoint(Point& rPnt, const Point& rPvOfs, Point* pC1, Point* pC2)
//STRIP001 {
//STRIP001 	FASTBOOL bSlant=eMode==SDRCROOK_SLANT;
//STRIP001 	FASTBOOL bStretch=eMode==SDRCROOK_STRETCH;
//STRIP001 	FASTBOOL bVert=bVertical;
//STRIP001 	FASTBOOL bC1=pC1!=NULL;
//STRIP001 	FASTBOOL bC2=pC2!=NULL;
//STRIP001 	Point aC(aCenter);
//STRIP001 	aC-=rPvOfs;
//STRIP001 	if (bResize) {
//STRIP001 		Fraction aFact1(1,1);
//STRIP001 		if (bVert) {
//STRIP001 			ResizePoint(rPnt,aC,aFact1,aFact);
//STRIP001 			if (bC1) ResizePoint(*pC1,aC,aFact1,aFact);
//STRIP001 			if (bC2) ResizePoint(*pC2,aC,aFact1,aFact);
//STRIP001 		} else {
//STRIP001 			ResizePoint(rPnt,aC,aFact,aFact1);
//STRIP001 			if (bC1) ResizePoint(*pC1,aC,aFact,aFact1);
//STRIP001 			if (bC2) ResizePoint(*pC2,aC,aFact,aFact1);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (aRad.X()!=0 && aRad.Y()!=0) {
//STRIP001 		double nSin,nCos;
//STRIP001 		switch (eMode) {
//STRIP001 			case SDRCROOK_ROTATE : CrookRotateXPoint (rPnt,pC1,pC2,aC,aRad,nSin,nCos,bVert);           break;
//STRIP001 			case SDRCROOK_SLANT  : CrookSlantXPoint  (rPnt,pC1,pC2,aC,aRad,nSin,nCos,bVert);           break;
//STRIP001 			case SDRCROOK_STRETCH: CrookStretchXPoint(rPnt,pC1,pC2,aC,aRad,nSin,nCos,bVert,aMarkRect); break;
//STRIP001 		} // switch
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragCrook::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	if (DragStat().CheckMinMoved(rPnt)) {
//STRIP001 		Point aPnt(rPnt);
//STRIP001 		FASTBOOL bNeuMoveOnly=rView.IsMoveOnlyDragging();
//STRIP001 		bAtCenter=FALSE;
//STRIP001 		SdrCrookMode eNeuMode=rView.GetCrookMode();
//STRIP001 		FASTBOOL bNeuContortion=!bNeuMoveOnly && ((bContortionAllowed && !rView.IsCrookNoContortion()) || !bNoContortionAllowed);
//STRIP001 		bResize=!rView.IsOrtho() && bResizeAllowed && !bNeuMoveOnly;
//STRIP001 		FASTBOOL bNeuRotate=bRotateAllowed && !bNeuContortion && !bNeuMoveOnly && eNeuMode==SDRCROOK_ROTATE;
//STRIP001 		long nSA=0;
//STRIP001 		if (nSA==0) aPnt=GetSnapPos(aPnt);
//STRIP001 		Point aNeuCenter(aMarkCenter.X(),aStart.Y());
//STRIP001 		if (bVertical) { aNeuCenter.X()=aStart.X(); aNeuCenter.Y()=aMarkCenter.Y(); }
//STRIP001 		if (!rView.IsCrookAtCenter()) {
//STRIP001 			switch (GetDragHdlKind()) {
//STRIP001 				case HDL_UPLFT: aNeuCenter.X()=aMarkRect.Right();  bLft=TRUE; break;
//STRIP001 				case HDL_UPPER: aNeuCenter.Y()=aMarkRect.Bottom(); bUpr=TRUE; break;
//STRIP001 				case HDL_UPRGT: aNeuCenter.X()=aMarkRect.Left();   bRgt=TRUE; break;
//STRIP001 				case HDL_LEFT : aNeuCenter.X()=aMarkRect.Right();  bLft=TRUE; break;
//STRIP001 				case HDL_RIGHT: aNeuCenter.X()=aMarkRect.Left();   bRgt=TRUE; break;
//STRIP001 				case HDL_LWLFT: aNeuCenter.X()=aMarkRect.Right();  bLft=TRUE; break;
//STRIP001 				case HDL_LOWER: aNeuCenter.Y()=aMarkRect.Top();    bLwr=TRUE; break;
//STRIP001 				case HDL_LWRGT: aNeuCenter.X()=aMarkRect.Left();   bRgt=TRUE; break;
//STRIP001 				default: bAtCenter=TRUE;
//STRIP001 			}
//STRIP001 		} else bAtCenter=TRUE;
//STRIP001 		Fraction aNeuFact(1,1);
//STRIP001 		long dx1=aPnt.X()-aNeuCenter.X();
//STRIP001 		long dy1=aPnt.Y()-aNeuCenter.Y();
//STRIP001 		bValid=bVertical ? dx1!=0 : dy1!=0;
//STRIP001 		if (bValid) {
//STRIP001 			if (bVertical) bValid=Abs(dx1)*100>Abs(dy1);
//STRIP001 			else bValid=Abs(dy1)*100>Abs(dx1);
//STRIP001 		}
//STRIP001 		long nNeuRad=0;
//STRIP001 		nWink=0;
//STRIP001 		if (bValid) {
//STRIP001 			double a=0; // Steigung des Radius
//STRIP001 			long nPntWink=0;
//STRIP001 			if (bVertical) {
//STRIP001 				a=((double)dy1)/((double)dx1); // Steigung des Radius
//STRIP001 				nNeuRad=((long)(dy1*a)+dx1) /2;
//STRIP001 				aNeuCenter.X()+=nNeuRad;
//STRIP001 				nPntWink=GetAngle(aPnt-aNeuCenter);
//STRIP001 			} else {
//STRIP001 				a=((double)dx1)/((double)dy1); // Steigung des Radius
//STRIP001 				nNeuRad=((long)(dx1*a)+dy1) /2;
//STRIP001 				aNeuCenter.Y()+=nNeuRad;
//STRIP001 				nPntWink=GetAngle(aPnt-aNeuCenter)-9000;
//STRIP001 			}
//STRIP001 			if (!bAtCenter) {
//STRIP001 				if (nNeuRad<0) {
//STRIP001 					if (bRgt) nPntWink+=18000;
//STRIP001 					if (bLft) nPntWink=18000-nPntWink;
//STRIP001 					if (bLwr) nPntWink=-nPntWink;
//STRIP001 				} else {
//STRIP001 					if (bRgt) nPntWink=-nPntWink;
//STRIP001 					if (bUpr) nPntWink=18000-nPntWink;
//STRIP001 					if (bLwr) nPntWink+=18000;
//STRIP001 				}
//STRIP001 				nPntWink=NormAngle360(nPntWink);
//STRIP001 			} else {
//STRIP001 				if (nNeuRad<0) nPntWink+=18000;
//STRIP001 				if (bVertical) nPntWink=18000-nPntWink;
//STRIP001 				nPntWink=NormAngle180(nPntWink);
//STRIP001 				nPntWink=Abs(nPntWink);
//STRIP001 			}
//STRIP001 			double nUmfang=2*Abs(nNeuRad)*nPi;
//STRIP001 			if (bResize) {
//STRIP001 				if (nSA!=0) { // Winkelfang
//STRIP001 					long nWink0=nPntWink;
//STRIP001 					nPntWink+=nSA/2;
//STRIP001 					nPntWink/=nSA;
//STRIP001 					nPntWink*=nSA;
//STRIP001 					BigInt a(nNeuRad);
//STRIP001 					a*=BigInt(nWink);
//STRIP001 					a/=BigInt(nWink0);
//STRIP001 					nNeuRad=long(a);
//STRIP001 					if (bVertical) aNeuCenter.X()=aStart.X()+nNeuRad;
//STRIP001 					else aNeuCenter.Y()=aStart.Y()+nNeuRad;
//STRIP001 				}
//STRIP001 				long nMul=(long)(nUmfang*NormAngle360(nPntWink)/36000);
//STRIP001 				if (bAtCenter) nMul*=2;
//STRIP001 				aNeuFact=Fraction(nMul,nMarkSize);
//STRIP001 				nWink=nPntWink;
//STRIP001 			} else {
//STRIP001 				nWink=(long)((nMarkSize*360/nUmfang)*100)/2;
//STRIP001 				if (nWink==0) bValid=FALSE;
//STRIP001 				if (bValid && nSA!=0) { // Winkelfang
//STRIP001 					long nWink0=nWink;
//STRIP001 					nWink+=nSA/2;
//STRIP001 					nWink/=nSA;
//STRIP001 					nWink*=nSA;
//STRIP001 					BigInt a(nNeuRad);
//STRIP001 					a*=BigInt(nWink);
//STRIP001 					a/=BigInt(nWink0);
//STRIP001 					nNeuRad=long(a);
//STRIP001 					if (bVertical) aNeuCenter.X()=aStart.X()+nNeuRad;
//STRIP001 					else aNeuCenter.Y()=aStart.Y()+nNeuRad;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (nWink==0 || nNeuRad==0) bValid=FALSE;
//STRIP001 		if (!bValid) nNeuRad=0;
//STRIP001 		if (!bValid && bResize) {
//STRIP001 			long nMul=bVertical ? dy1 : dx1;
//STRIP001 			if (bLft || bUpr) nMul=-nMul;
//STRIP001 			long nDiv=nMarkSize;
//STRIP001 			if (bAtCenter) { nMul*=2; nMul=Abs(nMul); }
//STRIP001 			aNeuFact=Fraction(nMul,nDiv);
//STRIP001 		}
//STRIP001 		if (aNeuCenter!=aCenter || bNeuContortion!=bContortion || aNeuFact!=aFact ||
//STRIP001 			bNeuMoveOnly!=bMoveOnly || bNeuRotate!=bRotate || eNeuMode!=eMode)
//STRIP001 		{
//STRIP001 			Hide();
//STRIP001 			bMoveOnly=bNeuMoveOnly;
//STRIP001 			bRotate=bNeuRotate;
//STRIP001 			eMode=eNeuMode;
//STRIP001 			bContortion=bNeuContortion;
//STRIP001 			aCenter=aNeuCenter;
//STRIP001 			aFact=aNeuFact;
//STRIP001 			aRad=Point(nNeuRad,nNeuRad);
//STRIP001 			bResize=aFact!=Fraction(1,1) && aFact.GetDenominator()!=0 && aFact.IsValid();
//STRIP001 			DragStat().NextMove(aPnt);
//STRIP001 			MovAllPoints();
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragCrook::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	if (bResize && aFact==Fraction(1,1)) bResize=FALSE;
//STRIP001 	FASTBOOL bDoCrook=aCenter!=aMarkCenter && aRad.X()!=0 && aRad.Y()!=0;
//STRIP001 	if (bDoCrook || bResize) {
//STRIP001 		if (bResize) {
//STRIP001 			XubString aStr;
//STRIP001 			ImpTakeDescriptionStr(!bContortion?STR_EditCrook:STR_EditCrookContortion,aStr);
//STRIP001 			if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 			rView.BegUndo(aStr);
//STRIP001 		}
//STRIP001 		if (bResize) {
//STRIP001 			Fraction aFact1(1,1);
//STRIP001 			if (bContortion) {
//STRIP001 				if (bVertical) rView.ResizeMarkedObj(aCenter,aFact1,aFact,bCopy);
//STRIP001 				else rView.ResizeMarkedObj(aCenter,aFact,aFact1,bCopy);
//STRIP001 			} else {
//STRIP001 				if (bCopy) rView.CopyMarkedObj();
//STRIP001 				ULONG nMarkAnz=rView.GetMarkList().GetMarkCount();
//STRIP001 				for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 					SdrMark* pM=rView.GetMarkList().GetMark(nm);
//STRIP001 					SdrObject* pO=pM->GetObj();
//STRIP001 					Point aCtr0(pO->GetSnapRect().Center());
//STRIP001 					Point aCtr1(aCtr0);
//STRIP001 					if (bVertical) ResizePoint(aCtr1,aCenter-pM->GetPageView()->GetOffset(),aFact1,aFact);
//STRIP001 					else ResizePoint(aCtr1,aCenter-pM->GetPageView()->GetOffset(),aFact,aFact1);
//STRIP001 					Size aSiz(aCtr1.X()-aCtr0.X(),aCtr1.Y()-aCtr0.Y());
//STRIP001 					AddUndo(new SdrUndoMoveObj(*pO,aSiz));
//STRIP001 					pO->Move(aSiz);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			bCopy=FALSE;
//STRIP001 		}
//STRIP001 		if (bDoCrook) {
//STRIP001 			rView.CrookMarkedObj(aCenter,aRad,eMode,bVertical,!bContortion,bCopy);
//STRIP001 			rView.SetLastCrookCenter(aCenter);
//STRIP001 		}
//STRIP001 		if (bResize) rView.EndUndo();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragCrook::DrawXor(ExtOutputDevice& rXOut, FASTBOOL bFull) const
//STRIP001 {
//STRIP001 	SdrDragMethod::DrawXor(rXOut,bFull);
//STRIP001 	if (FALSE) {
//STRIP001 		Rectangle aRect(aCenter.X()-aRad.X(),aCenter.Y()-aRad.Y(),aCenter.X()+aRad.X(),aCenter.Y()+aRad.Y());
//STRIP001 
//STRIP001 		Color aLineColorMerk( rXOut.GetOutDev()->GetLineColor() );
//STRIP001 		Color aBlackColor( COL_BLACK );
//STRIP001 		rXOut.GetOutDev()->SetLineColor( aBlackColor );
//STRIP001 		rXOut.GetOutDev()->DrawEllipse(aRect);
//STRIP001 		rXOut.GetOutDev()->SetLineColor( aLineColorMerk );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragCrook::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_CROOK);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 TYPEINIT1(SdrDragDistort,SdrDragMethod);
//STRIP001 
//STRIP001 void SdrDragDistort::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 	ImpTakeDescriptionStr(STR_DragMethDistort, rStr);
//STRIP001 
//STRIP001 	XubString aStr;
//STRIP001 	
//STRIP001 	rStr.AppendAscii(" (x=");
//STRIP001 	rView.GetModel()->TakeMetricStr(DragStat().GetDX(), aStr);
//STRIP001 	rStr += aStr;
//STRIP001 	rStr.AppendAscii(" y=");
//STRIP001 	rView.GetModel()->TakeMetricStr(DragStat().GetDY(), aStr);
//STRIP001 	rStr += aStr;
//STRIP001 	rStr += sal_Unicode(')');
//STRIP001 	
//STRIP001 	if(rView.IsDragWithCopy()) 
//STRIP001 		rStr += ImpGetResStr(STR_EditWithCopy);
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragDistort::Beg()
//STRIP001 {
//STRIP001 	bContortionAllowed=rView.IsDistortAllowed(FALSE);
//STRIP001 	bNoContortionAllowed=rView.IsDistortAllowed(TRUE);
//STRIP001 	if (bContortionAllowed || bNoContortionAllowed) {
//STRIP001 		SdrHdlKind eKind=GetDragHdlKind();
//STRIP001 		nPolyPt=0xFFFF;
//STRIP001 		if (eKind==HDL_UPLFT) nPolyPt=0;
//STRIP001 		if (eKind==HDL_UPRGT) nPolyPt=1;
//STRIP001 		if (eKind==HDL_LWRGT) nPolyPt=2;
//STRIP001 		if (eKind==HDL_LWLFT) nPolyPt=3;
//STRIP001 		if (nPolyPt>3) return FALSE;
//STRIP001 		aMarkRect=GetMarkedRect();
//STRIP001 		aDistortedRect=XPolygon(aMarkRect);
//STRIP001 		SetDragPolys();
//STRIP001 		
//STRIP001 		// #96920# Add extended XOR frame raster
//STRIP001 		const sal_uInt16 nPageViewNum(rView.GetPageViewCount());
//STRIP001 		for(sal_uInt16 a(0); a < nPageViewNum; a++) 
//STRIP001 		{
//STRIP001 			SdrPageView* pPV = rView.GetPageViewPvNum(a);
//STRIP001 			OutputDevice* pOut = (pPV->GetWinList())[0].GetOutputDevice();
//STRIP001 			Rectangle aPixelSize = pOut->LogicToPixel(aMarkRect);
//STRIP001 
//STRIP001 			sal_uInt32 nHorDiv(aPixelSize.GetWidth() / DRAG_CROOK_RASTER_DISTANCE);
//STRIP001 			sal_uInt32 nVerDiv(aPixelSize.GetHeight() / DRAG_CROOK_RASTER_DISTANCE);
//STRIP001 
//STRIP001 			if(nHorDiv > DRAG_CROOK_RASTER_MAXIMUM)
//STRIP001 				nHorDiv = DRAG_CROOK_RASTER_MAXIMUM;
//STRIP001 			if(nHorDiv < DRAG_CROOK_RASTER_MINIMUM)
//STRIP001 				nHorDiv = DRAG_CROOK_RASTER_MINIMUM;
//STRIP001 
//STRIP001 			if(nVerDiv > DRAG_CROOK_RASTER_MAXIMUM)
//STRIP001 				nVerDiv = DRAG_CROOK_RASTER_MAXIMUM;
//STRIP001 			if(nVerDiv < DRAG_CROOK_RASTER_MINIMUM)
//STRIP001 				nVerDiv = DRAG_CROOK_RASTER_MINIMUM;
//STRIP001 
//STRIP001 			ImplAddDragRaster(pPV->DragPoly0(), aMarkRect, nHorDiv, nVerDiv);
//STRIP001 			pPV->DragPoly() = pPV->DragPoly0();
//STRIP001 		}
//STRIP001 
//STRIP001 		Show();
//STRIP001 		return TRUE;
//STRIP001 	} else {
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragDistort::MovAllPoints()
//STRIP001 {
//STRIP001 	if (bContortion) {
//STRIP001 		USHORT nPvAnz=rView.GetPageViewCount();
//STRIP001 		for (USHORT nv=0; nv<nPvAnz; nv++) {
//STRIP001 			SdrPageView* pPV=rView.GetPageViewPvNum(nv);
//STRIP001 			if (pPV->HasMarkedObj()) {
//STRIP001 				Point aOfs(pPV->GetOffset());
//STRIP001 				pPV->DragPoly()=pPV->DragPoly0();
//STRIP001 				if (aOfs.X()==0 && aOfs.Y()==0) {
//STRIP001 					pPV->DragPoly().Distort(aMarkRect,aDistortedRect);
//STRIP001 				} else {
//STRIP001 					Rectangle aR(aMarkRect);
//STRIP001 					XPolygon aXP(aDistortedRect);
//STRIP001 					aR.Move(-aOfs.X(),-aOfs.Y());
//STRIP001 					aXP.Move(-aOfs.X(),-aOfs.Y());
//STRIP001 					pPV->DragPoly().Distort(aR,aXP);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragDistort::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	if (DragStat().CheckMinMoved(rPnt)) {
//STRIP001 		Point aPnt(GetSnapPos(rPnt));
//STRIP001 		if (rView.IsOrtho()) OrthoDistance8(DragStat().GetStart(),aPnt,rView.IsBigOrtho());
//STRIP001 		FASTBOOL bNeuContortion=(bContortionAllowed && !rView.IsCrookNoContortion()) || !bNoContortionAllowed;
//STRIP001 		if (bNeuContortion!=bContortion || aDistortedRect[nPolyPt]!=aPnt) {
//STRIP001 			Hide();
//STRIP001 			aDistortedRect[nPolyPt]=aPnt;
//STRIP001 			bContortion=bNeuContortion;
//STRIP001 			DragStat().NextMove(aPnt);
//STRIP001 			MovAllPoints();
//STRIP001 			Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrDragDistort::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 	FASTBOOL bDoDistort=DragStat().GetDX()!=0 || DragStat().GetDY()!=0;
//STRIP001 	if (bDoDistort) {
//STRIP001 		rView.DistortMarkedObj(aMarkRect,aDistortedRect,!bContortion,bCopy);
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrDragDistort::DrawXor(ExtOutputDevice& rXOut, FASTBOOL bFull) const
//STRIP001 {
//STRIP001 	SdrDragMethod::DrawXor(rXOut,bFull);
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrDragDistort::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_REFHAND);
//STRIP001 }

}
