/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svdibrow.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:56:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #ifndef _EEITEM_HXX //autogen
//STRIP001 #include <eeitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "svdibrow.hxx"
//STRIP001 
//STRIP001 #ifndef _STDLIB_H
//STRIP001 #include <stdlib.h>
//STRIP001 #define _STDLIB_H
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "svditext.hxx"
//STRIP001 #include "flditem.hxx"
//STRIP001 #include "editdata.hxx"
//STRIP001 #include "svdpool.hxx"
//STRIP001 #include "svdattr.hxx"
//STRIP001 #include "svdattrx.hxx"
//STRIP001 #include "svdview.hxx"
//STRIP001 
//STRIP001 #ifndef _XENUM_HXX //autogen
//STRIP001 #include "xenum.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XLINEIT0_HXX //autogen
//STRIP001 #include "xlineit0.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XLNSTWIT_HXX //autogen
//STRIP001 #include "xlnstwit.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XLNEDWIT_HXX //autogen
//STRIP001 #include "xlnedwit.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef SVX_XFILLIT0_HXX //autogen
//STRIP001 #include "xfillit0.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XFLBMTIT_HXX //autogen
//STRIP001 #include "xflbmtit.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_TEXTIT0_HXX //autogen
//STRIP001 #include "xtextit0.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XFLBSTIT_HXX //autogen
//STRIP001 #include "xflbstit.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XFLBTOXY_HXX //autogen
//STRIP001 #include "xflbtoxy.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_XFTSHIT_HXX //autogen
//STRIP001 #include "xftshit.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_COLRITEM_HXX //autogen
//STRIP001 #include "colritem.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _EEITEMID_HXX
//STRIP001 #include <eeitemid.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_FONTITEM_HXX //autogen
//STRIP001 #include "fontitem.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_FHGTITEM_HXX //autogen
//STRIP001 #include "fhgtitem.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #include <charscaleitem.hxx>
//STRIP001 
//STRIP001 #ifndef _SFX_WHITER_HXX //autogen
//STRIP001 #include <svtools/whiter.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SFXFLAGITEM_HXX //autogen
//STRIP001 #include <svtools/flagitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SFXPTITEM_HXX //autogen
//STRIP001 #include <svtools/ptitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SFXRECTITEM_HXX //autogen
//STRIP001 #include <svtools/rectitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SFXRNGITEM_HXX
//STRIP001 #include <svtools/rngitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 #define ITEMBROWSER_WHICHCOL_ID 1
//STRIP001 #define ITEMBROWSER_STATECOL_ID 2
//STRIP001 #define ITEMBROWSER_TYPECOL_ID  3
//STRIP001 #define ITEMBROWSER_NAMECOL_ID  4
//STRIP001 #define ITEMBROWSER_VALUECOL_ID 5
//STRIP001 
//STRIP001 enum ItemType {
//STRIP001 	ITEM_DONTKNOW, ITEM_BYTE, ITEM_INT16, ITEM_UINT16, ITEM_INT32, ITEM_UINT32,
//STRIP001 	ITEM_ENUM, ITEM_BOOL, ITEM_FLAG, ITEM_STRING, ITEM_POINT, ITEM_RECT, ITEM_RANGE, ITEM_LRANGE,
//STRIP001 	ITEM_FRACTION,
//STRIP001 	ITEM_XCOLOR,
//STRIP001 	ITEM_COLOR,
//STRIP001 	ITEM_FONT, ITEM_FONTHEIGHT, ITEM_FONTWIDTH, ITEM_FIELD
//STRIP001 };
//STRIP001 
//STRIP001 class ImpItemListRow 
//STRIP001 {
//STRIP001 public:
//STRIP001 	XubString					aName;
//STRIP001 	XubString					aValue;
//STRIP001 	SfxItemState				eState;
//STRIP001 	UINT16						nWhichId;
//STRIP001 
//STRIP001 	TypeId						pType;
//STRIP001 	ItemType					eItemType;
//STRIP001 	
//STRIP001 	INT32						nVal;
//STRIP001 	INT32						nMin;
//STRIP001 	INT32						nMax;
//STRIP001 
//STRIP001 	BOOL						bComment;
//STRIP001 	BOOL						bIsNum;
//STRIP001 	BOOL						bCanNum;
//STRIP001 
//STRIP001 public:
//STRIP001 	ImpItemListRow() 
//STRIP001 	:	eState(SFX_ITEM_UNKNOWN), 
//STRIP001 		pType(NULL), 
//STRIP001 		eItemType(ITEM_DONTKNOW), 
//STRIP001 		nWhichId(0), 
//STRIP001 		bComment(FALSE), 
//STRIP001 		bIsNum(FALSE), 
//STRIP001 		bCanNum(FALSE), 
//STRIP001 		nVal(0), 
//STRIP001 		nMin(0), 
//STRIP001 		nMax(0) 
//STRIP001 	{}
//STRIP001 	
//STRIP001 	XubString GetItemTypeStr() const;
//STRIP001 	BOOL operator==(const ImpItemListRow& rEntry) const;
//STRIP001 	BOOL operator!=(const ImpItemListRow& rEntry) const { return !operator==(rEntry); }
//STRIP001 };
//STRIP001 
//STRIP001 XubString ImpItemListRow::GetItemTypeStr() const
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	
//STRIP001 	switch(eItemType) 
//STRIP001 	{
//STRIP001 		case ITEM_BYTE		: aStr.AppendAscii("Byte");		break;
//STRIP001 		case ITEM_INT16		: aStr.AppendAscii("Int16");	break;
//STRIP001 		case ITEM_UINT16	: aStr.AppendAscii("UInt16");	break;
//STRIP001 		case ITEM_INT32		: aStr.AppendAscii("Int32");	break;
//STRIP001 		case ITEM_UINT32	: aStr.AppendAscii("UInt32");	break;
//STRIP001 		case ITEM_ENUM		: aStr.AppendAscii("Enum");		break;
//STRIP001 		case ITEM_BOOL		: aStr.AppendAscii("Bool");		break;
//STRIP001 		case ITEM_FLAG		: aStr.AppendAscii("Flag");		break;
//STRIP001 		case ITEM_STRING	: aStr.AppendAscii("String");	break;
//STRIP001 		case ITEM_POINT		: aStr.AppendAscii("Point");	break;
//STRIP001 		case ITEM_RECT		: aStr.AppendAscii("Rectangle");break;
//STRIP001 		case ITEM_RANGE		: aStr.AppendAscii("Range");	break;
//STRIP001 		case ITEM_LRANGE	: aStr.AppendAscii("LRange");	break;
//STRIP001 		case ITEM_FRACTION	: aStr.AppendAscii("Fraction");	break;
//STRIP001 		case ITEM_XCOLOR	: aStr.AppendAscii("XColor");	break;
//STRIP001 		case ITEM_COLOR		: aStr.AppendAscii("Color");	break;
//STRIP001 		case ITEM_FONT		: aStr.AppendAscii("Font");		break;
//STRIP001 		case ITEM_FONTHEIGHT:aStr.AppendAscii("FontHeight");break;
//STRIP001 		case ITEM_FONTWIDTH	:aStr.AppendAscii("FontWidth");	break;
//STRIP001 		case ITEM_FIELD		:aStr.AppendAscii("Field");		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aStr;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ImpItemListRow::operator==(const ImpItemListRow& rEntry) const
//STRIP001 {
//STRIP001 	return (aName.Equals(rEntry.aName)
//STRIP001 		&& aValue.Equals(rEntry.aValue)
//STRIP001 		&& eState==rEntry.eState    
//STRIP001 		&& nWhichId==rEntry.nWhichId  
//STRIP001 		&& bComment==rEntry.bComment  
//STRIP001 		&& bIsNum==rEntry.bIsNum    
//STRIP001 		&& bCanNum==rEntry.bCanNum   
//STRIP001 		&& pType==rEntry.pType     
//STRIP001 		&& eItemType==rEntry.eItemType 
//STRIP001 		&& nVal==rEntry.nVal      
//STRIP001 		&& nMin==rEntry.nMin      
//STRIP001 		&& nMax==rEntry.nMax);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 class ImpItemEdit: public Edit
//STRIP001 {
//STRIP001 	_SdrItemBrowserControl*		pBrowse;
//STRIP001 
//STRIP001 public:
//STRIP001 	ImpItemEdit(Window* pParent, _SdrItemBrowserControl* pBrowse_, WinBits nBits=0)
//STRIP001 	:	Edit(pParent, nBits), 
//STRIP001 		pBrowse(pBrowse_) 
//STRIP001 	{}
//STRIP001 	
//STRIP001 	virtual ~ImpItemEdit();
//STRIP001 	virtual void KeyInput(const KeyEvent& rEvt);
//STRIP001 };
//STRIP001 
//STRIP001 __EXPORT ImpItemEdit::~ImpItemEdit()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ImpItemEdit::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	_SdrItemBrowserControl* pBrowseMerk = pBrowse;
//STRIP001 
//STRIP001 	UINT16 nKeyCode(rKEvt.GetKeyCode().GetCode() + rKEvt.GetKeyCode().GetModifier());
//STRIP001 
//STRIP001 	if(nKeyCode == KEY_RETURN) 
//STRIP001 	{
//STRIP001 		pBrowseMerk->EndChangeEntry();
//STRIP001 		pBrowseMerk->GrabFocus();
//STRIP001 	} 
//STRIP001 	else if(nKeyCode == KEY_ESCAPE) 
//STRIP001 	{
//STRIP001 		pBrowseMerk->BrkChangeEntry();
//STRIP001 		pBrowseMerk->GrabFocus();
//STRIP001 	} 
//STRIP001 	else if(nKeyCode == KEY_UP || nKeyCode == KEY_DOWN) 
//STRIP001 	{
//STRIP001 		pBrowseMerk->EndChangeEntry();
//STRIP001 		pBrowseMerk->GrabFocus();
//STRIP001 		pBrowseMerk->KeyInput(rKEvt);
//STRIP001 	} 
//STRIP001 	else 
//STRIP001 		Edit::KeyInput(rKEvt);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 #define MYBROWSEMODE (BROWSER_THUMBDRAGGING|BROWSER_KEEPHIGHLIGHT|BROWSER_NO_HSCROLL|BROWSER_HIDECURSOR)
//STRIP001 
//STRIP001 _SdrItemBrowserControl::_SdrItemBrowserControl(Window* pParent, WinBits nBits):
//STRIP001 	BrowseBox(pParent,nBits,MYBROWSEMODE),
//STRIP001 	aList(1024,16,16)
//STRIP001 {
//STRIP001 	ImpCtor();
//STRIP001 }
//STRIP001 
//STRIP001 __EXPORT _SdrItemBrowserControl::~_SdrItemBrowserControl()
//STRIP001 {
//STRIP001 	if(pEditControl) 
//STRIP001 		delete pEditControl;
//STRIP001 
//STRIP001 	if(pAktChangeEntry) 
//STRIP001 		delete pAktChangeEntry;
//STRIP001 
//STRIP001 	Clear();
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::ImpCtor()
//STRIP001 {
//STRIP001 	pEditControl = NULL;
//STRIP001 	pAktChangeEntry = NULL;
//STRIP001 	nLastWhichOfs = 0;
//STRIP001 	nLastWhich = 0;
//STRIP001 	nLastWhichOben = 0;  // not implemented yet
//STRIP001 	nLastWhichUnten = 0; // not implemented yet
//STRIP001 	bWhichesButNames = FALSE;
//STRIP001 	bDontHideIneffectiveItems = FALSE;
//STRIP001 	bDontSortItems = FALSE;
//STRIP001 	bShowWhichIds = FALSE;
//STRIP001 	bShowRealValues = FALSE;
//STRIP001 	bShowWhichIds = TRUE;   // not implemented yet
//STRIP001 	bShowRealValues = TRUE; // not implemented yet
//STRIP001 
//STRIP001 	rtl_TextEncoding aTextEncoding = gsl_getSystemTextEncoding();
//STRIP001 
//STRIP001 	InsertDataColumn(
//STRIP001 		ITEMBROWSER_WHICHCOL_ID, 
//STRIP001 		String("Which", aTextEncoding),
//STRIP001 		GetTextWidth(String(" Which ", aTextEncoding)) + 2);
//STRIP001 	InsertDataColumn(
//STRIP001 		ITEMBROWSER_STATECOL_ID,
//STRIP001 		String("State", aTextEncoding),
//STRIP001 		Max(GetTextWidth(String(" State ", aTextEncoding)) + 2 , 
//STRIP001 			GetTextWidth(String("DontCare", aTextEncoding)) + 2));
//STRIP001 	InsertDataColumn(
//STRIP001 		ITEMBROWSER_TYPECOL_ID ,
//STRIP001 		String("Type", aTextEncoding),
//STRIP001 		GetTextWidth(String(" Type_ ", aTextEncoding)) + 2);
//STRIP001 	InsertDataColumn(
//STRIP001 		ITEMBROWSER_NAMECOL_ID ,
//STRIP001 		String("Name", aTextEncoding),
//STRIP001 		150);
//STRIP001 	InsertDataColumn(
//STRIP001 		ITEMBROWSER_VALUECOL_ID,
//STRIP001 		String("Value", aTextEncoding),
//STRIP001 		GetTextWidth(String("12345678901234567890", aTextEncoding)));
//STRIP001 	SetDataRowHeight(
//STRIP001 		GetTextHeight());
//STRIP001 	
//STRIP001 	long nWdt=GetColumnWidth(ITEMBROWSER_WHICHCOL_ID)+
//STRIP001 			  GetColumnWidth(ITEMBROWSER_STATECOL_ID)+
//STRIP001 			  GetColumnWidth(ITEMBROWSER_TYPECOL_ID )+
//STRIP001 			  GetColumnWidth(ITEMBROWSER_NAMECOL_ID )+
//STRIP001 			  GetColumnWidth(ITEMBROWSER_VALUECOL_ID);
//STRIP001 	
//STRIP001 	long nHgt=GetTitleHeight()+16*GetDataRowHeight();
//STRIP001 	
//STRIP001 	SetOutputSizePixel(Size(nWdt,nHgt));
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::Clear()
//STRIP001 {
//STRIP001 	ULONG nAnz=aList.Count();
//STRIP001 	for (ULONG nNum=0; nNum<nAnz; nNum++) {
//STRIP001 		delete ImpGetEntry(nNum);
//STRIP001 	}
//STRIP001 	aList.Clear();
//STRIP001 	BrowseBox::Clear();
//STRIP001 }
//STRIP001 
//STRIP001 long __EXPORT _SdrItemBrowserControl::GetRowCount() const
//STRIP001 {
//STRIP001 	return aList.Count();
//STRIP001 }
//STRIP001 
//STRIP001 BOOL __EXPORT _SdrItemBrowserControl::SeekRow(long nRow)
//STRIP001 {
//STRIP001 	nAktPaintRow=nRow;
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 String _SdrItemBrowserControl::GetCellText(long _nRow, USHORT _nColId) const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	if ( _nRow >= 0 && _nRow < aList.Count() )
//STRIP001 	{
//STRIP001 		ImpItemListRow* pEntry = ImpGetEntry(_nRow);
//STRIP001 		if ( pEntry )
//STRIP001 		{
//STRIP001 			if ( pEntry->bComment )
//STRIP001 			{
//STRIP001 				if (_nColId == ITEMBROWSER_NAMECOL_ID) 
//STRIP001 					sRet = pEntry->aName;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rtl_TextEncoding aTextEncoding = gsl_getSystemTextEncoding();
//STRIP001 		
//STRIP001 				sRet = XubString("???", aTextEncoding);
//STRIP001 				switch (_nColId) 
//STRIP001 				{
//STRIP001 					case ITEMBROWSER_WHICHCOL_ID: 
//STRIP001 						sRet = UniString::CreateFromInt32(pEntry->nWhichId); break;
//STRIP001 					case ITEMBROWSER_STATECOL_ID: 
//STRIP001 					{
//STRIP001 						switch (pEntry->eState) 
//STRIP001 						{
//STRIP001 							case SFX_ITEM_UNKNOWN : sRet=String("Uknown", aTextEncoding);   break;
//STRIP001 							case SFX_ITEM_DISABLED: sRet=String("Disabled", aTextEncoding); break;
//STRIP001 							case SFX_ITEM_DONTCARE: sRet=String("DontCare", aTextEncoding); break;
//STRIP001 							case SFX_ITEM_SET     : sRet=String("Set", aTextEncoding);      break;
//STRIP001 							case SFX_ITEM_DEFAULT : sRet=String("Default", aTextEncoding);  break;
//STRIP001 						} // switch
//STRIP001 					} break;
//STRIP001 					case ITEMBROWSER_TYPECOL_ID: sRet = pEntry->GetItemTypeStr(); break;
//STRIP001 					case ITEMBROWSER_NAMECOL_ID: sRet = pEntry->aName; break;
//STRIP001 					case ITEMBROWSER_VALUECOL_ID: sRet = pEntry->aValue; break;
//STRIP001 				} // switch
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT _SdrItemBrowserControl::PaintField(OutputDevice& rDev, const Rectangle& rRect, USHORT nColumnId) const
//STRIP001 {
//STRIP001 	if (nAktPaintRow<0 || (ULONG)nAktPaintRow>=aList.Count()) {
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	Rectangle aR(rRect);
//STRIP001 	aR.Bottom()++;
//STRIP001 	ImpItemListRow* pEntry=ImpGetEntry(nAktPaintRow);
//STRIP001 	if (pEntry->bComment) 
//STRIP001 	{
//STRIP001 		if (nColumnId==ITEMBROWSER_NAMECOL_ID) 
//STRIP001 		{
//STRIP001 			rDev.SetLineColor();
//STRIP001 			rDev.SetFillColor( Color( COL_LIGHTGRAY ) );
//STRIP001 			aR.Left()=0;
//STRIP001 			aR.Right()=rDev.GetOutputSize().Width();
//STRIP001 			rDev.DrawRect(aR);
//STRIP001 			rDev.DrawText(rRect.TopLeft(),pEntry->aName);
//STRIP001 		}
//STRIP001 	} else {
//STRIP001 		rDev.SetClipRegion(aR);
//STRIP001 		rDev.DrawText(aR.TopLeft(),GetCellText(nAktPaintRow,nColumnId));
//STRIP001 		rDev.SetClipRegion();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ULONG _SdrItemBrowserControl::GetCurrentPos() const
//STRIP001 {
//STRIP001 	ULONG nRet=CONTAINER_ENTRY_NOTFOUND;
//STRIP001 	if (GetSelectRowCount()==1) {
//STRIP001 		long nPos=((BrowseBox*)this)->FirstSelectedRow();
//STRIP001 		if (nPos>=0 && (ULONG)nPos<aList.Count()) {
//STRIP001 			nRet=(ULONG)nPos;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 USHORT _SdrItemBrowserControl::GetCurrentWhich() const
//STRIP001 {
//STRIP001 	USHORT nRet=0;
//STRIP001 	ULONG nPos=GetCurrentPos();
//STRIP001 	if (nPos!=CONTAINER_ENTRY_NOTFOUND) {
//STRIP001 		nRet=ImpGetEntry(nPos)->nWhichId;
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT _SdrItemBrowserControl::DoubleClick(const BrowserMouseEvent&)
//STRIP001 {
//STRIP001 	ULONG nPos=GetCurrentPos();
//STRIP001 	if (nPos!=CONTAINER_ENTRY_NOTFOUND) {
//STRIP001 		BegChangeEntry(nPos);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT _SdrItemBrowserControl::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	USHORT nKeyCode=rKEvt.GetKeyCode().GetCode()+rKEvt.GetKeyCode().GetModifier();
//STRIP001 	FASTBOOL bAusgewertet=FALSE;
//STRIP001 	ULONG nPos=GetCurrentPos();
//STRIP001 	if (nPos!=CONTAINER_ENTRY_NOTFOUND) {
//STRIP001 		if (nKeyCode==KEY_RETURN) {
//STRIP001 			if (BegChangeEntry(nPos)) bAusgewertet=TRUE;
//STRIP001 		} else if (nKeyCode==KEY_ESCAPE) {
//STRIP001 			// ...
//STRIP001 		} else if (rKEvt.GetKeyCode().GetModifier()==KEY_SHIFT+KEY_MOD1+KEY_MOD2) { // Strg
//STRIP001 			if (nKeyCode==KEY_SHIFT+KEY_MOD1+KEY_MOD2+KEY_W) {
//STRIP001 				bWhichesButNames=!bWhichesButNames;
//STRIP001 				SetDirty();
//STRIP001 			}
//STRIP001 			if (nKeyCode==KEY_SHIFT+KEY_MOD1+KEY_MOD2+KEY_I) {
//STRIP001 				bDontHideIneffectiveItems=!bDontHideIneffectiveItems;
//STRIP001 				SetDirty();
//STRIP001 			}
//STRIP001 			if (nKeyCode==KEY_SHIFT+KEY_MOD1+KEY_MOD2+KEY_S) {
//STRIP001 				bDontSortItems=!bDontSortItems;
//STRIP001 				SetDirty();
//STRIP001 			}
//STRIP001 		} 
//STRIP001 /*		else if (XubString::IsPrintable(rKEvt.GetCharCode())) {
//STRIP001 			if (BegChangeEntry(nPos)) {
//STRIP001 				bAusgewertet=TRUE;
//STRIP001 				// folgende 3 Statements, weil
//STRIP001 				// pEditControl->KeyInput(rKEvt) nicht geht
//STRIP001 				pEditControl->SetText(rKEvt.GetCharCode());
//STRIP001 				pEditControl->SetModifyFlag();
//STRIP001 				pEditControl->SetSelection(1);
//STRIP001 			}
//STRIP001 		} */
//STRIP001 	}
//STRIP001 	if (!bAusgewertet) BrowseBox::KeyInput(rKEvt);
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::SetDirty()
//STRIP001 {
//STRIP001 	aSetDirtyHdl.Call(this);
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle _SdrItemBrowserControl::GetFieldCharacterBounds(sal_Int32 _nRow,sal_Int32 _nColumnPos,sal_Int32 nIndex)
//STRIP001 {
//STRIP001     // no accessibility implementation required
//STRIP001     return Rectangle();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 _SdrItemBrowserControl::GetFieldIndexAtPoint(sal_Int32 _nRow,sal_Int32 _nColumnPos,const Point& _rPoint)
//STRIP001 {
//STRIP001     // no accessibility implementation required
//STRIP001     return -1;
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT _SdrItemBrowserControl::Select()
//STRIP001 {
//STRIP001 	EndChangeEntry();
//STRIP001 	BrowseBox::Select();
//STRIP001 	ImpSaveWhich();
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::ImpSaveWhich()
//STRIP001 {
//STRIP001 	USHORT nWh=GetCurrentWhich();
//STRIP001 	if (nWh!=0) {
//STRIP001 		long nPos=GetCurrentPos();
//STRIP001 		long nTop=GetTopRow();
//STRIP001 		long nBtm=GetTopRow()+GetVisibleRows()+1;
//STRIP001 		nLastWhich=nWh;
//STRIP001 		nLastWhichOfs=nPos-nTop;
//STRIP001 		if (nTop<0) nTop=0;
//STRIP001 		if (nBtm>=(long)aList.Count()) nBtm=aList.Count()-1;
//STRIP001 		nLastWhichOben=ImpGetEntry(nTop)->nWhichId;
//STRIP001 		nLastWhichUnten=ImpGetEntry(nBtm)->nWhichId;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::ImpRestoreWhich()
//STRIP001 {
//STRIP001 	if (nLastWhich!=0) {
//STRIP001 		FASTBOOL bFnd=FALSE;
//STRIP001 		USHORT nBestMinWh=0,nBestMaxWh=0xFFFF;       // not implemented yet
//STRIP001 		ULONG nBestMinPos=0,nBestMaxPos=0xFFFFFFFF;  // not implemented yet
//STRIP001 		ULONG nAnz=aList.Count();
//STRIP001 		ULONG nNum;
//STRIP001 		for (nNum=0; nNum<nAnz && !bFnd; nNum++) {
//STRIP001 			ImpItemListRow* pEntry=ImpGetEntry(nNum);
//STRIP001 			if (!pEntry->bComment) {
//STRIP001 				USHORT nWh=pEntry->nWhichId;
//STRIP001 				if (nWh==nLastWhich) bFnd=TRUE;
//STRIP001 				else if (nWh<nLastWhich && nWh>nBestMinWh) nBestMinPos=nNum;
//STRIP001 				else if (nWh>nLastWhich && nWh<nBestMaxWh) nBestMaxPos=nNum;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (bFnd) {
//STRIP001 			long nPos=nNum-1;
//STRIP001 			long nWhichOfs=nPos-GetTopRow();
//STRIP001 			if (nWhichOfs!=nLastWhichOfs) {
//STRIP001 				ScrollRows(nWhichOfs-nLastWhichOfs);
//STRIP001 			}
//STRIP001 			GoToRow(nPos);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL _SdrItemBrowserControl::BegChangeEntry(ULONG nPos)
//STRIP001 {
//STRIP001 	BrkChangeEntry();
//STRIP001 	FASTBOOL bRet=FALSE;
//STRIP001 	ImpItemListRow* pEntry=ImpGetEntry(nPos);
//STRIP001 	if (pEntry!=NULL && !pEntry->bComment) {
//STRIP001 		SetMode(MYBROWSEMODE & ~BROWSER_KEEPHIGHLIGHT);
//STRIP001 		pEditControl=new ImpItemEdit(&GetDataWindow(),this,0/*|WB_BORDER|WB_SVLOOK*/);
//STRIP001 		Rectangle aRect(GetFieldRectPixel(nPos,ITEMBROWSER_VALUECOL_ID,FALSE));
//STRIP001 		aRect.Left()+=2; // Kleiner Offset fuer's Edit, damit's pixelgenau stimmt
//STRIP001 		aRect.Right()--;
//STRIP001 		pEditControl->SetPosSizePixel(aRect.TopLeft(),aRect.GetSize());
//STRIP001 		pEditControl->SetText(pEntry->aValue);
//STRIP001 		pEditControl->SetBackground( Wallpaper(Color(COL_LIGHTGRAY)));
//STRIP001 		Font aFont(pEditControl->GetFont());
//STRIP001 		aFont.SetFillColor(Color(COL_LIGHTGRAY));
//STRIP001 		pEditControl->SetFont(aFont);
//STRIP001 		pEditControl->Show();
//STRIP001 		pEditControl->GrabFocus();
//STRIP001 		pEditControl->SetSelection(Selection(SELECTION_MIN,SELECTION_MAX));
//STRIP001 		Window* pParent=GetParent();
//STRIP001 		aWNamMerk=pParent->GetText();
//STRIP001 		XubString aNeuNam(aWNamMerk);
//STRIP001 		aNeuNam += sal_Unicode(' ');
//STRIP001 		aNeuNam += pEntry->GetItemTypeStr();
//STRIP001 		if (pEntry->bCanNum) {
//STRIP001 			aNeuNam.AppendAscii(": ");
//STRIP001 			aNeuNam += UniString::CreateFromInt32(pEntry->nMin);
//STRIP001 			aNeuNam.AppendAscii("..");
//STRIP001 			aNeuNam += UniString::CreateFromInt32(pEntry->nMax);
//STRIP001 		}
//STRIP001 		aNeuNam.AppendAscii(" - Type 'del' to reset to default.");
//STRIP001 		pParent->SetText(aNeuNam);
//STRIP001 		pAktChangeEntry=new ImpItemListRow(*pEntry);
//STRIP001 		bRet=TRUE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL _SdrItemBrowserControl::EndChangeEntry()
//STRIP001 {
//STRIP001 	FASTBOOL bRet=FALSE;
//STRIP001 	if (pEditControl!=NULL) {
//STRIP001 		aEntryChangedHdl.Call(this);
//STRIP001 		delete pEditControl;
//STRIP001 		pEditControl=NULL;
//STRIP001 		delete pAktChangeEntry;
//STRIP001 		pAktChangeEntry=NULL;
//STRIP001 		Window* pParent=GetParent();
//STRIP001 		pParent->SetText(aWNamMerk);
//STRIP001 		SetMode(MYBROWSEMODE);
//STRIP001 		bRet=TRUE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::BrkChangeEntry()
//STRIP001 {
//STRIP001 	if (pEditControl!=NULL) {
//STRIP001 		delete pEditControl;
//STRIP001 		pEditControl=NULL;
//STRIP001 		delete pAktChangeEntry;
//STRIP001 		pAktChangeEntry=NULL;
//STRIP001 		Window* pParent=GetParent();
//STRIP001 		pParent->SetText(aWNamMerk);
//STRIP001 		SetMode(MYBROWSEMODE);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::ImpSetEntry(const ImpItemListRow& rEntry, ULONG nEntryNum)
//STRIP001 {
//STRIP001 	ImpItemListRow* pAktEntry=ImpGetEntry(nEntryNum);
//STRIP001 	if (pAktEntry==NULL) {
//STRIP001 		aList.Insert(new ImpItemListRow(rEntry),CONTAINER_APPEND);
//STRIP001 		RowInserted(nEntryNum);
//STRIP001 	} else if (*pAktEntry!=rEntry) {
//STRIP001 		FASTBOOL bStateDiff=rEntry.eState!=pAktEntry->eState;
//STRIP001 		FASTBOOL bValueDiff=!rEntry.aValue.Equals(pAktEntry->aValue);
//STRIP001 		FASTBOOL bAllDiff=TRUE;
//STRIP001 		if (bStateDiff || bValueDiff) {
//STRIP001 			// Checken, ob nur State und/oder Value geaendert
//STRIP001 			ImpItemListRow aTest(rEntry);
//STRIP001 			aTest.eState=pAktEntry->eState;
//STRIP001 			aTest.aValue=pAktEntry->aValue;
//STRIP001 			if (aTest==*pAktEntry) bAllDiff=FALSE;
//STRIP001 		}
//STRIP001 		*pAktEntry=rEntry;
//STRIP001 		if (bAllDiff) {
//STRIP001 			RowModified(nEntryNum);
//STRIP001 		} else {
//STRIP001 			if (bStateDiff) RowModified(nEntryNum,ITEMBROWSER_STATECOL_ID);
//STRIP001 			if (bValueDiff) RowModified(nEntryNum,ITEMBROWSER_VALUECOL_ID);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL ImpGetItem(const SfxItemSet& rSet, USHORT nWhich, const SfxPoolItem*& rpItem)
//STRIP001 {
//STRIP001 	SfxItemState eState=rSet.GetItemState(nWhich,TRUE,&rpItem);
//STRIP001 	if (eState==SFX_ITEM_DEFAULT) {
//STRIP001 		rpItem=&rSet.Get(nWhich);
//STRIP001 	}
//STRIP001 	return (eState==SFX_ITEM_DEFAULT || eState==SFX_ITEM_SET) && rpItem!=NULL;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL IsItemIneffective(USHORT nWhich, const SfxItemSet* pSet, USHORT& rIndent)
//STRIP001 {
//STRIP001 	rIndent=0;
//STRIP001 	if (pSet==NULL) return FALSE;
//STRIP001 	const SfxPoolItem* pItem=NULL;
//STRIP001 	FASTBOOL bRet=FALSE;
//STRIP001 	switch (nWhich) {
//STRIP001 		case XATTR_LINEDASH         :
//STRIP001 		case XATTR_LINEWIDTH        :
//STRIP001 		case XATTR_LINECOLOR        :
//STRIP001 		case XATTR_LINESTART        :
//STRIP001 		case XATTR_LINEEND          :
//STRIP001 		case XATTR_LINESTARTWIDTH   :
//STRIP001 		case XATTR_LINEENDWIDTH     :
//STRIP001 		case XATTR_LINESTARTCENTER  :
//STRIP001 		case XATTR_LINEENDCENTER    :
//STRIP001 		case XATTR_LINETRANSPARENCE : {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,XATTR_LINESTYLE,pItem)) {
//STRIP001 				XLineStyle eLineStyle=((const XLineStyleItem*)pItem)->GetValue();
//STRIP001 				if (eLineStyle==XLINE_NONE) return TRUE;
//STRIP001 				if (eLineStyle!=XLINE_DASH && nWhich==XATTR_LINEDASH) return TRUE;
//STRIP001 			}
//STRIP001 			if (nWhich==XATTR_LINESTART || nWhich==XATTR_LINESTARTCENTER) {
//STRIP001 				rIndent=2;
//STRIP001 				if (ImpGetItem(*pSet,XATTR_LINESTARTWIDTH,pItem)) {
//STRIP001 					INT32 nWdt=((const XLineStartWidthItem*)pItem)->GetValue();
//STRIP001 					if (nWdt==0) return TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (nWhich==XATTR_LINEEND || nWhich==XATTR_LINEENDCENTER) {
//STRIP001 				rIndent=2;
//STRIP001 				if (ImpGetItem(*pSet,XATTR_LINEENDWIDTH,pItem)) {
//STRIP001 					INT32 nWdt=((const XLineEndWidthItem*)pItem)->GetValue();
//STRIP001 					if (nWdt==0) return TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 		case XATTR_FILLCOLOR           : /*nur bei Style=Color*/
//STRIP001 		case XATTR_FILLGRADIENT        : /*nur bei Style=Gradient*/
//STRIP001 		case XATTR_FILLHATCH           : /*nur bei Style=Hatch*/
//STRIP001 		case XATTR_FILLTRANSPARENCE    : /*nur bei Style=Color*/
//STRIP001 		case XATTR_GRADIENTSTEPCOUNT   : /*nur bei Style=Gradient*/
//STRIP001 		case XATTR_FILLBACKGROUND	   : /*nur bei Style=Hatch*/
//STRIP001 		{			
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,XATTR_FILLSTYLE,pItem)) {
//STRIP001 				XFillStyle eFillStyle=((const XFillStyleItem*)pItem)->GetValue();
//STRIP001 				if (eFillStyle==XFILL_NONE) return TRUE;
//STRIP001 				// Transparenz z.Zt. nur fuer SolidFill
//STRIP001 				if (eFillStyle!=XFILL_SOLID && (nWhich==XATTR_FILLCOLOR || nWhich==XATTR_FILLTRANSPARENCE)) return TRUE;
//STRIP001 				if (eFillStyle!=XFILL_GRADIENT && (nWhich==XATTR_FILLGRADIENT || nWhich==XATTR_GRADIENTSTEPCOUNT)) return TRUE;
//STRIP001 				if (eFillStyle!=XFILL_HATCH && (nWhich==XATTR_FILLHATCH || nWhich==XATTR_FILLBACKGROUND)) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 		case XATTR_FILLBITMAP          :
//STRIP001 		case XATTR_FILLBMP_TILE        :
//STRIP001 		case XATTR_FILLBMP_POS         : /* z.Zt. nur wenn TILE=TRUE */
//STRIP001 		case XATTR_FILLBMP_SIZEX       : /* nur wenn nicht Stretch */
//STRIP001 		case XATTR_FILLBMP_SIZEY       : /* nur wenn nicht Stretch */
//STRIP001 		case XATTR_FILLBMP_SIZELOG     : /* nur wenn SIZELOG=FALSE zum ruecksetzen auf TRUE (alt) -> doch noch in Gebrauch */
//STRIP001 		case XATTR_FILLBMP_TILEOFFSETX : /* nur wenn TILE=TRUE */
//STRIP001 		case XATTR_FILLBMP_TILEOFFSETY : /* nur wenn TILE=TRUE */
//STRIP001 		case XATTR_FILLBMP_STRETCH     : /* nur wenn TILE=FALSE */
//STRIP001 		case XATTR_FILLBMP_POSOFFSETX  : /* nur wenn TILE=TRUE*/
//STRIP001 		case XATTR_FILLBMP_POSOFFSETY  : { /* nur wenn TILE=TRUE*/
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,XATTR_FILLSTYLE,pItem)) {
//STRIP001 				XFillStyle eFillStyle=((const XFillStyleItem*)pItem)->GetValue();
//STRIP001 				if (eFillStyle!=XFILL_BITMAP) return TRUE;
//STRIP001 			}
//STRIP001 			if (nWhich==XATTR_FILLBITMAP || nWhich==XATTR_FILLBMP_TILE) {
//STRIP001 				return FALSE; // immer anwaehlbar
//STRIP001 			}
//STRIP001 			FASTBOOL bTileTRUE=FALSE;
//STRIP001 			FASTBOOL bTileFALSE=FALSE;
//STRIP001 			FASTBOOL bStretchTRUE=FALSE;
//STRIP001 			FASTBOOL bStretchFALSE=FALSE;
//STRIP001 			if (ImpGetItem(*pSet,XATTR_FILLBMP_TILE,pItem)) {
//STRIP001 				bTileTRUE=((const XFillBmpTileItem*)pItem)->GetValue();
//STRIP001 				bTileFALSE=!bTileTRUE;
//STRIP001 			}
//STRIP001 			if (ImpGetItem(*pSet,XATTR_FILLBMP_STRETCH,pItem)) {
//STRIP001 				bStretchTRUE=((const XFillBmpStretchItem*)pItem)->GetValue();
//STRIP001 				bStretchFALSE=!bStretchTRUE;
//STRIP001 			}
//STRIP001 			// Stretch nicht anwaehlbar, wenn Tile=TRUE
//STRIP001 			if (nWhich==XATTR_FILLBMP_STRETCH) return bTileTRUE;
//STRIP001 			// und uebrig bleiben 7+1 Item (Unterattribute)
//STRIP001 			rIndent=2;
//STRIP001 			// Pos (enum) nicht anwaehlbar, wenn Tile=FALSE
//STRIP001 			if (nWhich==XATTR_FILLBMP_POS) return bTileFALSE;
//STRIP001 			// SizeXY nicht anwaehlbar bei Stretch=TRUE
//STRIP001 			if (nWhich==XATTR_FILLBMP_SIZEX || nWhich==XATTR_FILLBMP_SIZEY) {
//STRIP001 				return bTileFALSE && bStretchTRUE;
//STRIP001 			}
//STRIP001 			// 2 Items speziell fuer Tile
//STRIP001 			if (nWhich==XATTR_FILLBMP_POSOFFSETX  || nWhich==XATTR_FILLBMP_POSOFFSETY) {
//STRIP001 				return bTileFALSE;
//STRIP001 			}
//STRIP001 			// Noch 2 Items speziell fuer Tile die sich jedoch gegenseitig ausschliessen
//STRIP001 			if (nWhich==XATTR_FILLBMP_TILEOFFSETX || nWhich==XATTR_FILLBMP_TILEOFFSETY) {
//STRIP001 				if (bTileFALSE) return TRUE;
//STRIP001 				USHORT nX=0,nY=0;
//STRIP001 				FASTBOOL bX=FALSE,bY=FALSE;
//STRIP001 				if (ImpGetItem(*pSet,XATTR_FILLBMP_TILEOFFSETX,pItem)) {
//STRIP001 					nX=((const XFillBmpTileOffsetXItem*)pItem)->GetValue();
//STRIP001 					bX=TRUE;
//STRIP001 				}
//STRIP001 				if (ImpGetItem(*pSet,XATTR_FILLBMP_TILEOFFSETY,pItem)) {
//STRIP001 					nY=((const XFillBmpTileOffsetYItem*)pItem)->GetValue();
//STRIP001 					bY=TRUE;
//STRIP001 				}
//STRIP001 				if (nWhich==XATTR_FILLBMP_TILEOFFSETX) {
//STRIP001 					if (nX!=0 || !bX) return FALSE;
//STRIP001 					if (nY!=0) return TRUE;
//STRIP001 				} else {
//STRIP001 					if (nY!=0 || !bY) return FALSE;
//STRIP001 					if (nX!=0) return TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			// SizeLog nicht anwaehlbar bei Stretch=TRUE
//STRIP001 			// und sonst auch nur wenn es auf SizeLog=FALSE gesetzt ist.
//STRIP001 			// -> wohl doch noch in Gebrauch
//STRIP001 			// (TRUE ist der statische PoolDefault)
//STRIP001 			if (nWhich==XATTR_FILLBMP_SIZELOG) {
//STRIP001 				if (bTileFALSE && bStretchTRUE) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case XATTR_FORMTXTADJUST    :
//STRIP001 		case XATTR_FORMTXTDISTANCE  :
//STRIP001 		case XATTR_FORMTXTSTART     :
//STRIP001 		case XATTR_FORMTXTMIRROR    :
//STRIP001 		case XATTR_FORMTXTOUTLINE   :
//STRIP001 		case XATTR_FORMTXTSHADOW    :
//STRIP001 		case XATTR_FORMTXTSHDWCOLOR :
//STRIP001 		case XATTR_FORMTXTSHDWXVAL  :
//STRIP001 		case XATTR_FORMTXTSHDWYVAL  :
//STRIP001 		case XATTR_FORMTXTSTDFORM   :
//STRIP001 		case XATTR_FORMTXTHIDEFORM  :
//STRIP001 		case XATTR_FORMTXTSHDWTRANSP: {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,XATTR_FORMTXTSTYLE,pItem)) {
//STRIP001 				XFormTextStyle eStyle=((const XFormTextStyleItem*)pItem)->GetValue();
//STRIP001 				if (eStyle==XFT_NONE) return TRUE;
//STRIP001 			}
//STRIP001 			if ((nWhich>=XATTR_FORMTXTSHDWCOLOR && nWhich<=XATTR_FORMTXTSHDWYVAL) || nWhich>=XATTR_FORMTXTSHDWTRANSP) {
//STRIP001 				rIndent=2;
//STRIP001 				if (ImpGetItem(*pSet,XATTR_FORMTXTSHADOW,pItem)) {
//STRIP001 					XFormTextShadow eShadow=((const XFormTextShadowItem*)pItem)->GetValue();
//STRIP001 					if (eShadow==XFTSHADOW_NONE) return TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case SDRATTR_SHADOWCOLOR       :
//STRIP001 		case SDRATTR_SHADOWXDIST       :
//STRIP001 		case SDRATTR_SHADOWYDIST       :
//STRIP001 		case SDRATTR_SHADOWTRANSPARENCE:
//STRIP001 		case SDRATTR_SHADOW3D          :
//STRIP001 		case SDRATTR_SHADOWPERSP       : {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_SHADOW,pItem)) {
//STRIP001 				FASTBOOL bShadow=((const SdrShadowItem*)pItem)->GetValue();
//STRIP001 				if (!bShadow) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case SDRATTR_CAPTIONANGLE: {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_CAPTIONFIXEDANGLE,pItem)) {
//STRIP001 				FASTBOOL bFixed=((const SdrCaptionFixedAngleItem*)pItem)->GetValue();
//STRIP001 				if (!bFixed) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 		case SDRATTR_CAPTIONESCREL:
//STRIP001 		case SDRATTR_CAPTIONESCABS: {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_CAPTIONESCISREL,pItem)) {
//STRIP001 				FASTBOOL bRel=((const SdrCaptionEscIsRelItem*)pItem)->GetValue();
//STRIP001 				if (bRel && nWhich==SDRATTR_CAPTIONESCABS) return TRUE;
//STRIP001 				if (!bRel && nWhich==SDRATTR_CAPTIONESCREL) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 		case SDRATTR_CAPTIONLINELEN: {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_CAPTIONFITLINELEN,pItem)) {
//STRIP001 				FASTBOOL bFit=((const SdrCaptionFitLineLenItem*)pItem)->GetValue();
//STRIP001 				if (bFit) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case SDRATTR_TEXT_MINFRAMEHEIGHT:
//STRIP001 		case SDRATTR_TEXT_MAXFRAMEHEIGHT: {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_TEXT_AUTOGROWHEIGHT,pItem)) {
//STRIP001 				FASTBOOL bAutoGrow=((const SdrTextAutoGrowHeightItem*)pItem)->GetValue();
//STRIP001 				if (!bAutoGrow) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 		case SDRATTR_TEXT_MINFRAMEWIDTH:
//STRIP001 		case SDRATTR_TEXT_MAXFRAMEWIDTH: {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_TEXT_AUTOGROWWIDTH,pItem)) {
//STRIP001 				FASTBOOL bAutoGrow=((const SdrTextAutoGrowWidthItem*)pItem)->GetValue();
//STRIP001 				if (!bAutoGrow) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 		case SDRATTR_TEXT_VERTADJUST:
//STRIP001 		case SDRATTR_TEXT_HORZADJUST: {
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_TEXT_FITTOSIZE,pItem)) {
//STRIP001 				SdrFitToSizeType eFit=((const SdrTextFitToSizeTypeItem*)pItem)->GetValue();
//STRIP001 				if (eFit!=SDRTEXTFIT_NONE) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case SDRATTR_TEXT_ANIDIRECTION  :
//STRIP001 		case SDRATTR_TEXT_ANISTARTINSIDE:
//STRIP001 		case SDRATTR_TEXT_ANISTOPINSIDE :
//STRIP001 		case SDRATTR_TEXT_ANICOUNT      :
//STRIP001 		case SDRATTR_TEXT_ANIDELAY      :
//STRIP001 		case SDRATTR_TEXT_ANIAMOUNT     : {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_TEXT_ANIKIND,pItem)) {
//STRIP001 				SdrTextAniKind eAniKind=((const SdrTextAniKindItem*)pItem)->GetValue();
//STRIP001 				if (eAniKind==SDRTEXTANI_NONE) return TRUE;
//STRIP001 				if (eAniKind==SDRTEXTANI_BLINK && (nWhich==SDRATTR_TEXT_ANIDIRECTION || nWhich==SDRATTR_TEXT_ANIAMOUNT)) return TRUE;
//STRIP001 				if (eAniKind==SDRTEXTANI_SLIDE && (nWhich==SDRATTR_TEXT_ANISTARTINSIDE || nWhich==SDRATTR_TEXT_ANISTOPINSIDE)) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case SDRATTR_EDGELINEDELTAANZ: return TRUE;
//STRIP001 		case SDRATTR_EDGELINE1DELTA:
//STRIP001 		case SDRATTR_EDGELINE2DELTA:
//STRIP001 		case SDRATTR_EDGELINE3DELTA: {
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_EDGEKIND,pItem)) {
//STRIP001 				SdrEdgeKind eKind=((const SdrEdgeKindItem*)pItem)->GetValue();
//STRIP001 				if (eKind==SDREDGE_THREELINES) {
//STRIP001 					if (nWhich>SDRATTR_EDGELINE2DELTA) return TRUE;
//STRIP001 					else return FALSE;
//STRIP001 				}
//STRIP001 				if (eKind!=SDREDGE_ORTHOLINES && eKind!=SDREDGE_BEZIER) return TRUE;
//STRIP001 			}
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_EDGELINEDELTAANZ,pItem)) {
//STRIP001 				UINT16 nAnz=((const SdrEdgeLineDeltaAnzItem*)pItem)->GetValue();
//STRIP001 				if (nAnz==0) return TRUE;
//STRIP001 				if (nAnz==1 && nWhich>SDRATTR_EDGELINE1DELTA) return TRUE;
//STRIP001 				if (nAnz==2 && nWhich>SDRATTR_EDGELINE2DELTA) return TRUE;
//STRIP001 				if (nAnz==3 && nWhich>SDRATTR_EDGELINE3DELTA) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 
//STRIP001 		case SDRATTR_CIRCSTARTANGLE:
//STRIP001 		case SDRATTR_CIRCENDANGLE  : {
//STRIP001 			rIndent=1;
//STRIP001 			if (ImpGetItem(*pSet,SDRATTR_CIRCKIND,pItem)) {
//STRIP001 				SdrCircKind eKind=((const SdrCircKindItem*)pItem)->GetValue();
//STRIP001 				if (eKind==SDRCIRC_FULL) return TRUE;
//STRIP001 			}
//STRIP001 		} break;
//STRIP001 	} // switch
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 USHORT ImpSortWhich(USHORT nWhich)
//STRIP001 {
//STRIP001 	switch (nWhich) {
//STRIP001 		// Line
//STRIP001 		case XATTR_LINESTART            : nWhich=XATTR_LINETRANSPARENCE     ; break;
//STRIP001 		case XATTR_LINEEND              : nWhich=XATTR_LINESTARTWIDTH       ; break;
//STRIP001 		case XATTR_LINESTARTWIDTH       : nWhich=XATTR_LINESTART            ; break;
//STRIP001 		case XATTR_LINEENDWIDTH         : nWhich=XATTR_LINESTARTCENTER      ; break;
//STRIP001 		case XATTR_LINESTARTCENTER      : nWhich=XATTR_LINEENDWIDTH         ; break;
//STRIP001 		case XATTR_LINEENDCENTER        : nWhich=XATTR_LINEEND              ; break;
//STRIP001 		case XATTR_LINETRANSPARENCE     : nWhich=XATTR_LINEENDCENTER        ; break;
//STRIP001 
//STRIP001 		// Fill
//STRIP001 		case XATTR_FILLBMP_POS          : nWhich=XATTR_FILLBMP_STRETCH      ; break;
//STRIP001 		case XATTR_FILLBMP_SIZEX        : nWhich=XATTR_FILLBMP_POS          ; break;
//STRIP001 		case XATTR_FILLBMP_SIZEY        : nWhich=XATTR_FILLBMP_SIZEX        ; break;
//STRIP001 		case XATTR_FILLBMP_SIZELOG      : nWhich=XATTR_FILLBMP_SIZEY        ; break;
//STRIP001 		case XATTR_FILLBMP_TILEOFFSETX  : nWhich=XATTR_FILLBMP_SIZELOG      ; break;
//STRIP001 		case XATTR_FILLBMP_TILEOFFSETY  : nWhich=XATTR_FILLBMP_TILEOFFSETX  ; break;
//STRIP001 		case XATTR_FILLBMP_STRETCH      : nWhich=XATTR_FILLBMP_TILEOFFSETY  ; break;
//STRIP001 
//STRIP001 		// Fontwork
//STRIP001 		case XATTR_FORMTXTSHADOW        : nWhich=XATTR_FORMTXTSTDFORM       ; break;
//STRIP001 		case XATTR_FORMTXTSHDWCOLOR     : nWhich=XATTR_FORMTXTHIDEFORM      ; break;
//STRIP001 		case XATTR_FORMTXTSHDWXVAL      : nWhich=XATTR_FORMTXTSHADOW        ; break;
//STRIP001 		case XATTR_FORMTXTSHDWYVAL      : nWhich=XATTR_FORMTXTSHDWCOLOR     ; break;
//STRIP001 		case XATTR_FORMTXTSTDFORM       : nWhich=XATTR_FORMTXTSHDWXVAL      ; break;
//STRIP001 		case XATTR_FORMTXTHIDEFORM      : nWhich=XATTR_FORMTXTSHDWYVAL      ; break;
//STRIP001 
//STRIP001 		// Misc
//STRIP001 		case SDRATTR_TEXT_MINFRAMEHEIGHT: nWhich=SDRATTR_TEXT_FITTOSIZE     ; break;
//STRIP001 		case SDRATTR_TEXT_AUTOGROWHEIGHT: nWhich=SDRATTR_TEXT_LEFTDIST      ; break;
//STRIP001 		case SDRATTR_TEXT_FITTOSIZE     : nWhich=SDRATTR_TEXT_RIGHTDIST     ; break;
//STRIP001 		case SDRATTR_TEXT_LEFTDIST      : nWhich=SDRATTR_TEXT_UPPERDIST     ; break;
//STRIP001 		case SDRATTR_TEXT_RIGHTDIST     : nWhich=SDRATTR_TEXT_LOWERDIST     ; break;
//STRIP001 		case SDRATTR_TEXT_UPPERDIST     : nWhich=SDRATTR_TEXT_AUTOGROWWIDTH ; break;
//STRIP001 		case SDRATTR_TEXT_LOWERDIST     : nWhich=SDRATTR_TEXT_MINFRAMEWIDTH ; break;
//STRIP001 		case SDRATTR_TEXT_VERTADJUST    : nWhich=SDRATTR_TEXT_MAXFRAMEWIDTH ; break;
//STRIP001 		case SDRATTR_TEXT_MAXFRAMEHEIGHT: nWhich=SDRATTR_TEXT_AUTOGROWHEIGHT; break;
//STRIP001 		case SDRATTR_TEXT_MINFRAMEWIDTH : nWhich=SDRATTR_TEXT_MINFRAMEHEIGHT; break;
//STRIP001 		case SDRATTR_TEXT_MAXFRAMEWIDTH : nWhich=SDRATTR_TEXT_MAXFRAMEHEIGHT; break;
//STRIP001 		case SDRATTR_TEXT_AUTOGROWWIDTH : nWhich=SDRATTR_TEXT_HORZADJUST    ; break;
//STRIP001 		case SDRATTR_TEXT_HORZADJUST    : nWhich=SDRATTR_TEXT_VERTADJUST    ; break;
//STRIP001 	} // switch
//STRIP001 	return nWhich;
//STRIP001 }
//STRIP001 
//STRIP001 #define INSERTCOMMENT(nStartId,nEndId,aStr) \
//STRIP001     { if (nWhich0<nStartId && nWhich>=nStartId && nWhich<=nEndId) aCommentStr=aStr; }
//STRIP001 
//STRIP001 void _SdrItemBrowserControl::SetAttributes(const SfxItemSet* pSet, const SfxItemSet* p2ndSet)
//STRIP001 {
//STRIP001 	SetMode(MYBROWSEMODE & ~BROWSER_KEEPHIGHLIGHT);
//STRIP001 	if (pSet!=NULL) {
//STRIP001 		rtl_TextEncoding aTextEncoding = gsl_getSystemTextEncoding();
//STRIP001 		USHORT nEntryNum=0;
//STRIP001 		SfxWhichIter aIter(*pSet);
//STRIP001 		const SfxItemPool* pPool=pSet->GetPool();
//STRIP001 		USHORT nWhich0=0;
//STRIP001 		USHORT nWhich=aIter.FirstWhich();
//STRIP001 		while (nWhich!=0) {
//STRIP001 			// Nun erstmal etwas umsortieren
//STRIP001 			// Geht nur, solange keine InvalidItems, d.h. keine Luecken
//STRIP001 			// an dieser Stelle im Set sind
//STRIP001 			if (!bDontSortItems) nWhich=ImpSortWhich(nWhich);
//STRIP001 			SfxItemState eState=pSet->GetItemState(nWhich);
//STRIP001 			if (p2ndSet!=NULL) {
//STRIP001 				SfxItemState e2ndState=p2ndSet->GetItemState(nWhich);
//STRIP001 				if (eState==SFX_ITEM_DEFAULT) eState=SFX_ITEM_DISABLED;
//STRIP001 				else if (e2ndState==SFX_ITEM_DEFAULT) eState=SFX_ITEM_DEFAULT;
//STRIP001 			}
//STRIP001 			if (eState!=SFX_ITEM_DISABLED) {
//STRIP001 				const SfxPoolItem& rItem=pSet->Get(nWhich);
//STRIP001 				USHORT nIndent=0;
//STRIP001 				if (!HAS_BASE(SfxVoidItem,&rItem) && !HAS_BASE(SfxSetItem,&rItem) && (!IsItemIneffective(nWhich,pSet,nIndent) || bDontHideIneffectiveItems)) {
//STRIP001 					XubString aCommentStr;
//STRIP001 
//STRIP001 					INSERTCOMMENT(XATTR_LINE_FIRST,XATTR_LINE_LAST,String("L I N I E", aTextEncoding));
//STRIP001 					INSERTCOMMENT(XATTR_FILL_FIRST,XATTR_FILL_LAST,String("F L  C H E", aTextEncoding));
//STRIP001 					INSERTCOMMENT(XATTR_TEXT_FIRST,XATTR_TEXT_LAST,String("F O N T W O R K", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_SHADOW_FIRST,SDRATTR_SHADOW_LAST,String("S C H A T T E N", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_CAPTION_FIRST,SDRATTR_CAPTION_LAST,String("L E G E N D E", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_MISC_FIRST,SDRATTR_MISC_LAST,String("V E R S C H I E D E N E S", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_EDGE_FIRST,SDRATTR_EDGE_LAST,String("V E R B I N D E R", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_MEASURE_FIRST,SDRATTR_MEASURE_LAST,String("B E M A S S U N G", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_CIRC_FIRST,SDRATTR_CIRC_LAST,String("K R E I S", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_NOTPERSIST_FIRST,SDRATTR_NOTPERSIST_LAST,String("N O T P E R S I S T", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_MOVEX,SDRATTR_VERTSHEARONE,String("Transformationen auf alle Objekte einzeln", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_RESIZEXALL,SDRATTR_VERTSHEARALL,String("Transformationen auf alle Objekte gemeinsam", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_TRANSFORMREF1X,SDRATTR_TRANSFORMREF2Y,String("View-Referenzpunkte", aTextEncoding));
//STRIP001 					INSERTCOMMENT(SDRATTR_GRAF_FIRST,SDRATTR_GRAF_LAST,String("G R A F I K", aTextEncoding));
//STRIP001 					INSERTCOMMENT(EE_ITEMS_START,EE_ITEMS_END,String("E D I T  E N G I N E", aTextEncoding));
//STRIP001 					INSERTCOMMENT(EE_ITEMS_END+1,EE_ITEMS_END+1,String("... by Joe Merten, JME Engineering Berlin ...", aTextEncoding));
//STRIP001 
//STRIP001 					if(aCommentStr.Len()) 
//STRIP001 					{
//STRIP001 						ImpItemListRow aEntry;
//STRIP001 						aEntry.bComment=TRUE;
//STRIP001 						aEntry.aName=aCommentStr;
//STRIP001 						ImpSetEntry(aEntry,nEntryNum);
//STRIP001 						nEntryNum++;
//STRIP001 					}
//STRIP001 					nWhich0=nWhich;
//STRIP001 					ImpItemListRow aEntry;
//STRIP001 					SdrItemPool::TakeItemName(nWhich, aEntry.aName);
//STRIP001 					nIndent*=2;
//STRIP001 					
//STRIP001 					while(nIndent > 0) 
//STRIP001 					{ 
//STRIP001 						aEntry.aName.Insert(sal_Unicode(' '), 0); 
//STRIP001 						nIndent--; 
//STRIP001 					}
//STRIP001 
//STRIP001 					aEntry.eState=eState;
//STRIP001 					aEntry.nWhichId=nWhich;
//STRIP001 					if (!IsInvalidItem(&rItem)) {
//STRIP001 						aEntry.pType=rItem.Type();
//STRIP001 						aEntry.nMax=0x7FFFFFFF;
//STRIP001 						aEntry.nMin=-aEntry.nMax;
//STRIP001 						aEntry.nVal=-4711;
//STRIP001 						if      (HAS_BASE(SfxByteItem     ,&rItem)) aEntry.eItemType=ITEM_BYTE;
//STRIP001 						else if (HAS_BASE(SfxInt16Item    ,&rItem)) aEntry.eItemType=ITEM_INT16;
//STRIP001 						else if (HAS_BASE(SfxUInt16Item   ,&rItem)) aEntry.eItemType=ITEM_UINT16;
//STRIP001 						else if (HAS_BASE(SfxInt32Item    ,&rItem)) aEntry.eItemType=ITEM_INT32;
//STRIP001 						else if (HAS_BASE(SfxUInt32Item   ,&rItem)) aEntry.eItemType=ITEM_UINT32;
//STRIP001 						else if (HAS_BASE(SfxEnumItemInterface,&rItem)) aEntry.eItemType=ITEM_ENUM;
//STRIP001 						else if (HAS_BASE(SfxBoolItem     ,&rItem)) aEntry.eItemType=ITEM_BOOL;
//STRIP001 						else if (HAS_BASE(SfxFlagItem     ,&rItem)) aEntry.eItemType=ITEM_FLAG;
//STRIP001 						else if (HAS_BASE(XColorItem      ,&rItem)) aEntry.eItemType=ITEM_XCOLOR;
//STRIP001 						else if (HAS_BASE(SfxStringItem   ,&rItem)) aEntry.eItemType=ITEM_STRING;
//STRIP001 						else if (HAS_BASE(SfxPointItem    ,&rItem)) aEntry.eItemType=ITEM_POINT;
//STRIP001 						else if (HAS_BASE(SfxRectangleItem,&rItem)) aEntry.eItemType=ITEM_RECT;
//STRIP001 						else if (HAS_BASE(SfxRangeItem    ,&rItem)) aEntry.eItemType=ITEM_RANGE;
//STRIP001 						else if (HAS_BASE(SdrFractionItem ,&rItem)) aEntry.eItemType=ITEM_FRACTION;
//STRIP001 						else if (HAS_BASE(SvxColorItem    ,&rItem)) aEntry.eItemType=ITEM_COLOR;
//STRIP001 						else if (HAS_BASE(SvxFontItem     ,&rItem)) aEntry.eItemType=ITEM_FONT;
//STRIP001 						else if (HAS_BASE(SvxFontHeightItem,&rItem))aEntry.eItemType=ITEM_FONTHEIGHT;
//STRIP001 						else if (HAS_BASE(SvxCharScaleWidthItem,&rItem)) aEntry.eItemType=ITEM_FONTWIDTH;
//STRIP001 						else if (HAS_BASE(SvxFieldItem    ,&rItem)) aEntry.eItemType=ITEM_FIELD;
//STRIP001 						switch (aEntry.eItemType) {
//STRIP001 							case ITEM_BYTE      : aEntry.bIsNum=TRUE;  aEntry.nVal=((SfxByteItem  &)rItem).GetValue(); aEntry.nMin=0;      aEntry.nMax=255;   break;
//STRIP001 							case ITEM_INT16     : aEntry.bIsNum=TRUE;  aEntry.nVal=((SfxInt16Item &)rItem).GetValue(); aEntry.nMin=-32767; aEntry.nMax=32767; break;
//STRIP001 							case ITEM_UINT16    : aEntry.bIsNum=TRUE;  aEntry.nVal=((SfxUInt16Item&)rItem).GetValue(); aEntry.nMin=0;      aEntry.nMax=65535; break;
//STRIP001 							case ITEM_INT32     : aEntry.bIsNum=TRUE;  aEntry.nVal=((SfxInt32Item &)rItem).GetValue();                                        break;
//STRIP001 							case ITEM_UINT32    : aEntry.bIsNum=TRUE;  aEntry.nVal=((SfxUInt32Item&)rItem).GetValue(); aEntry.nMin=0; /*aEntry.nMax=0xFF...*/;break;
//STRIP001 							case ITEM_ENUM      : aEntry.bCanNum=TRUE; aEntry.nVal=((SfxEnumItemInterface&)rItem).GetEnumValue(); aEntry.nMin=0; aEntry.nMax=((SfxEnumItemInterface&)rItem).GetValueCount()-1; break;
//STRIP001 							case ITEM_BOOL      : aEntry.bCanNum=TRUE; aEntry.nVal=((SfxBoolItem  &)rItem).GetValue(); aEntry.nMin=0; aEntry.nMax=1;          break;
//STRIP001 							case ITEM_FLAG      : aEntry.bCanNum=TRUE; aEntry.nVal=((SfxFlagItem  &)rItem).GetValue(); aEntry.nMin=0; aEntry.nMax=0xFFFF;     break;
//STRIP001 							case ITEM_FONTHEIGHT: aEntry.bCanNum=TRUE; aEntry.nVal=((SvxFontHeightItem&)rItem).GetHeight(); aEntry.nMin=0;                    break;
//STRIP001 							case ITEM_FONTWIDTH : aEntry.bCanNum=TRUE; aEntry.nVal=((SvxCharScaleWidthItem&)rItem).GetValue();    aEntry.nMin=0; aEntry.nMax=0xFFFF;break;
//STRIP001 						} // switch
//STRIP001 						if (aEntry.bIsNum) aEntry.bCanNum=TRUE;
//STRIP001 						FASTBOOL bGetPres=TRUE;
//STRIP001 						if (bGetPres) {
//STRIP001 							rItem.GetPresentation(SFX_ITEM_PRESENTATION_NAMELESS,
//STRIP001 												  pPool->GetMetric(nWhich),
//STRIP001 												  SFX_MAPUNIT_MM,aEntry.aValue);
//STRIP001 							if (aEntry.bCanNum) {
//STRIP001 								aEntry.aValue.InsertAscii(": ",0);
//STRIP001 								aEntry.aValue.Insert(UniString::CreateFromInt32(aEntry.nVal),0);
//STRIP001 							}
//STRIP001 						} else {
//STRIP001 							if (aEntry.eItemType==ITEM_BOOL) aEntry.aValue.AppendAscii(aEntry.nVal!=0 ? "True" : "False");
//STRIP001 							else if (aEntry.bCanNum) aEntry.aValue = UniString::CreateFromInt32(aEntry.nVal);
//STRIP001 							else if (aEntry.eItemType==ITEM_STRING) aEntry.aValue=((SfxStringItem&)rItem).GetValue();
//STRIP001 							else if (aEntry.eItemType==ITEM_ENUM && nWhich!=EE_CHAR_WEIGHT) aEntry.aValue=((SfxEnumItemInterface&)rItem).GetValueTextByPos((BOOL)aEntry.nVal);
//STRIP001 							else aEntry.aValue = String("GPF", aTextEncoding);
//STRIP001 						}
//STRIP001 					} else {
//STRIP001 						aEntry.aValue = String("InvalidItem", aTextEncoding);
//STRIP001 					}
//STRIP001 					ImpSetEntry(aEntry,nEntryNum);
//STRIP001 					nEntryNum++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nWhich=aIter.NextWhich();
//STRIP001 		} // while
//STRIP001 
//STRIP001 		if (aList.Count()>nEntryNum) { // evtl. noch zuviele Eintraege
//STRIP001 			ULONG nTooMuch=aList.Count()-nEntryNum;
//STRIP001 			for (ULONG nNum=0; nNum<nTooMuch; nNum++) {
//STRIP001 				delete ImpGetEntry(nEntryNum);
//STRIP001 				aList.Remove(nEntryNum);
//STRIP001 			}
//STRIP001 			RowRemoved(nEntryNum,nTooMuch);
//STRIP001 		}
//STRIP001 	} else {
//STRIP001 		Clear(); // wenn pSet==NULL
//STRIP001 	}
//STRIP001 	ImpRestoreWhich();
//STRIP001 	SetMode(MYBROWSEMODE);
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 _SdrItemBrowserWindow::_SdrItemBrowserWindow(Window* pParent, WinBits nBits):
//STRIP001 	FloatingWindow(pParent,nBits),
//STRIP001 	aBrowse(this)
//STRIP001 {
//STRIP001 	SetOutputSizePixel(aBrowse.GetSizePixel());
//STRIP001 	SetText(String("Joe's ItemBrowser", gsl_getSystemTextEncoding()));
//STRIP001 	aBrowse.Show();
//STRIP001 }
//STRIP001 
//STRIP001 __EXPORT _SdrItemBrowserWindow::~_SdrItemBrowserWindow()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT _SdrItemBrowserWindow::Resize()
//STRIP001 {
//STRIP001 	aBrowse.SetSizePixel(GetOutputSizePixel());
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT _SdrItemBrowserWindow::GetFocus()
//STRIP001 {
//STRIP001 	aBrowse.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 SdrItemBrowser::SdrItemBrowser(SdrView& rView):
//STRIP001 	_SdrItemBrowserWindow(ImpGetViewWin(rView)),
//STRIP001 	pView(&rView),
//STRIP001 	bDirty(FALSE)
//STRIP001 {
//STRIP001 	aIdleTimer.SetTimeoutHdl(LINK(this,SdrItemBrowser,IdleHdl));
//STRIP001 	GetBrowserControl().SetEntryChangedHdl(LINK(this,SdrItemBrowser,ChangedHdl));
//STRIP001 	GetBrowserControl().SetSetDirtyHdl(LINK(this,SdrItemBrowser,SetDirtyHdl));
//STRIP001 	SetDirty();
//STRIP001 }
//STRIP001 
//STRIP001 Window* SdrItemBrowser::ImpGetViewWin(SdrView& rView)
//STRIP001 {
//STRIP001 	USHORT nAnz=rView.GetWinCount();
//STRIP001 	for (USHORT nNum=0; nNum<nAnz; nNum++) {
//STRIP001 		OutputDevice* pOut=rView.GetWin(nNum);
//STRIP001 		if (pOut->GetOutDevType()==OUTDEV_WINDOW) {
//STRIP001 			return (Window*)pOut;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrItemBrowser::ForceParent()
//STRIP001 {
//STRIP001 	Window* pWin=ImpGetViewWin(*pView);
//STRIP001 	if (pWin!=NULL) SetParent(pWin);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrItemBrowser::SetDirty()
//STRIP001 {
//STRIP001 	if (!bDirty) {
//STRIP001 		bDirty=TRUE;
//STRIP001 		aIdleTimer.SetTimeout(1);
//STRIP001 		aIdleTimer.Start();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrItemBrowser::Undirty()
//STRIP001 {
//STRIP001 	aIdleTimer.Stop();
//STRIP001 	bDirty = FALSE;
//STRIP001 
//STRIP001 //	SfxItemSet aSet(pView->GetAttributes());
//STRIP001 	SfxItemSet aSet(pView->GetModel()->GetItemPool());
//STRIP001 	pView->GetAttributes(aSet);
//STRIP001 
//STRIP001 	if(pView->HasMarkedObj())
//STRIP001 	{
//STRIP001 		// SfxItemSet a2ndSet(pView->GetAttributes(TRUE));
//STRIP001 		SfxItemSet a2ndSet(pView->GetModel()->GetItemPool());
//STRIP001 		pView->GetAttributes(a2ndSet, TRUE);
//STRIP001 
//STRIP001 		SetAttributes(&aSet,&a2ndSet);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetAttributes(&aSet);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SdrItemBrowser,IdleHdl,Timer*,aTimer)
//STRIP001 {
//STRIP001 	Undirty();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SdrItemBrowser,ChangedHdl,_SdrItemBrowserControl*,pBrowse)
//STRIP001 {
//STRIP001 	const ImpItemListRow* pEntry=pBrowse->GetAktChangeEntry();
//STRIP001 	if (pEntry!=NULL)
//STRIP001 	{
//STRIP001 //		SfxItemSet aSet(pView->GetAttributes());
//STRIP001 		SfxItemSet aSet(pView->GetModel()->GetItemPool());
//STRIP001 		pView->GetAttributes(aSet);
//STRIP001 
//STRIP001 		SfxItemSet aNewSet(*aSet.GetPool(),pEntry->nWhichId,pEntry->nWhichId);
//STRIP001 		XubString aNewText(pBrowse->GetNewEntryValue());
//STRIP001 		BOOL bDel( aNewText.EqualsAscii("del")
//STRIP001 			|| aNewText.EqualsAscii("Del")
//STRIP001 			|| aNewText.EqualsAscii("DEL")
//STRIP001 			|| aNewText.EqualsAscii("default")
//STRIP001 			|| aNewText.EqualsAscii("Default")
//STRIP001 			|| aNewText.EqualsAscii("DEFAULT"));
//STRIP001 
//STRIP001 		if (!bDel) {
//STRIP001 			SfxPoolItem* pNewItem=aSet.Get(pEntry->nWhichId).Clone();
//STRIP001 			long nLongVal=0;
//STRIP001 			nLongVal = aNewText.ToInt32();
//STRIP001 			if (pEntry->bCanNum) {
//STRIP001 				if (nLongVal>pEntry->nMax) nLongVal=pEntry->nMax;
//STRIP001 				if (nLongVal<pEntry->nMin) nLongVal=pEntry->nMin;
//STRIP001 			}
//STRIP001 			FASTBOOL bPair=FALSE;
//STRIP001 			FASTBOOL bPairX=TRUE;
//STRIP001 			FASTBOOL bPairY=FALSE;
//STRIP001 			USHORT nSepLen=1;
//STRIP001 			long nLongX = aNewText.ToInt32();
//STRIP001 			long nLongY=0;
//STRIP001 			xub_StrLen nPos = aNewText.Search(sal_Unicode('/'));
//STRIP001 			if (nPos==STRING_NOTFOUND) nPos=aNewText.Search(sal_Unicode(':'));
//STRIP001 			if (nPos==STRING_NOTFOUND) nPos=aNewText.Search(sal_Unicode(' '));
//STRIP001 			if (nPos==STRING_NOTFOUND) { nPos=aNewText.SearchAscii(".."); if (nPos!=STRING_NOTFOUND) nSepLen=2; }
//STRIP001 			if (nPos!=STRING_NOTFOUND) {
//STRIP001 				bPair=TRUE;
//STRIP001 				bPairX=nPos>0;
//STRIP001 				XubString s(aNewText);
//STRIP001 				s.Erase(0,nPos+nSepLen);
//STRIP001 				bPairY = (BOOL)aNewText.Len();
//STRIP001 				nLongY = s.ToInt32();
//STRIP001 			}
//STRIP001 			switch (pEntry->eItemType) {
//STRIP001 				case ITEM_BYTE  : ((SfxByteItem  *)pNewItem)->SetValue((BYTE  )nLongVal); break;
//STRIP001 				case ITEM_INT16 : ((SfxInt16Item *)pNewItem)->SetValue((INT16 )nLongVal); break;
//STRIP001 				case ITEM_UINT16: ((SfxUInt16Item*)pNewItem)->SetValue((UINT16)nLongVal); break;
//STRIP001 				case ITEM_INT32: {
//STRIP001 					if(HAS_BASE(SdrAngleItem, pNewItem)) 
//STRIP001 					{
//STRIP001 						aNewText.SearchAndReplace(sal_Unicode(','), sal_Unicode('.'));
//STRIP001 						double nVal = aNewText.ToFloat();
//STRIP001 						nLongVal = (long)(nVal * 100 + 0.5);
//STRIP001 					}
//STRIP001 					((SfxInt32Item *)pNewItem)->SetValue((INT32)nLongVal);
//STRIP001 				} break;
//STRIP001 				case ITEM_UINT32: ((SfxUInt32Item*)pNewItem)->SetValue(aNewText.ToInt32()); break;
//STRIP001 				case ITEM_ENUM  : ((SfxEnumItemInterface*)pNewItem)->SetEnumValue((USHORT)nLongVal); break;
//STRIP001 				case ITEM_BOOL: {
//STRIP001 					aNewText.ToUpperAscii();
//STRIP001 					if (aNewText.EqualsAscii("TRUE")) nLongVal=1;
//STRIP001 					if (aNewText.EqualsAscii("JA")) nLongVal=1;
//STRIP001 					if (aNewText.EqualsAscii("AN")) nLongVal=1;
//STRIP001 					if (aNewText.EqualsAscii("EIN")) nLongVal=1;
//STRIP001 					if (aNewText.EqualsAscii("ON")) nLongVal=1;
//STRIP001 					if (aNewText.EqualsAscii("YES")) nLongVal=1;
//STRIP001 					((SfxBoolItem*)pNewItem)->SetValue((BOOL)nLongVal);
//STRIP001 				} break;
//STRIP001 				case ITEM_FLAG  : ((SfxFlagItem  *)pNewItem)->SetValue((USHORT)nLongVal); break;
//STRIP001 				case ITEM_STRING: ((SfxStringItem*)pNewItem)->SetValue(aNewText); break;
//STRIP001 				case ITEM_POINT : ((SfxPointItem*)pNewItem)->SetValue(Point(nLongX,nLongY)); break;
//STRIP001 				case ITEM_RECT  : break;
//STRIP001 				case ITEM_RANGE : {
//STRIP001 					((SfxRangeItem*)pNewItem)->From()=(USHORT)nLongX;
//STRIP001 					((SfxRangeItem*)pNewItem)->From()=(USHORT)nLongY;
//STRIP001 				} break;
//STRIP001 				case ITEM_LRANGE : {
//STRIP001 				} break;
//STRIP001 				case ITEM_FRACTION: {
//STRIP001 					if (!bPairX) nLongX=1;
//STRIP001 					if (!bPairY) nLongY=1;
//STRIP001 					((SdrFractionItem*)pNewItem)->SetValue(Fraction(nLongX,nLongY));
//STRIP001 				} break;
//STRIP001 				case ITEM_XCOLOR: break;
//STRIP001 				case ITEM_COLOR: break;
//STRIP001 				case ITEM_FONT: {
//STRIP001 					((SvxFontItem*)pNewItem)->GetFamily()=FAMILY_DONTKNOW;
//STRIP001 					((SvxFontItem*)pNewItem)->GetFamilyName()=aNewText;
//STRIP001 					((SvxFontItem*)pNewItem)->GetStyleName().Erase();
//STRIP001 				} break;
//STRIP001 				case ITEM_FONTHEIGHT: {
//STRIP001 					ULONG nHgt=0;
//STRIP001 					USHORT nProp=100;
//STRIP001 					if (aNewText.Search(sal_Unicode('%'))!=STRING_NOTFOUND) {
//STRIP001 						nProp=(USHORT)nLongVal;
//STRIP001 					} else {
//STRIP001 						nHgt=nLongVal;
//STRIP001 					}
//STRIP001 					((SvxFontHeightItem*)pNewItem)->SetHeight(nHgt,nProp);
//STRIP001 				} break;
//STRIP001 				case ITEM_FONTWIDTH: {
//STRIP001 					USHORT nProp=100;
//STRIP001 					if (aNewText.Search(sal_Unicode('%'))!=STRING_NOTFOUND) {
//STRIP001 						nProp=(USHORT)nLongVal;
//STRIP001 					} 
//STRIP001 					((SvxCharScaleWidthItem*)pNewItem)->SetValue(nProp);
//STRIP001 				} break;
//STRIP001 				case ITEM_FIELD: break;
//STRIP001 			} // switch
//STRIP001 			aNewSet.Put(*pNewItem);
//STRIP001 			delete pNewItem;
//STRIP001 		}
//STRIP001 		pView->SetAttributes(aNewSet,bDel);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SdrItemBrowser,SetDirtyHdl,_SdrItemBrowserControl*,pBrowse)
//STRIP001 {
//STRIP001 	SetDirty();
//STRIP001 	return 0;
//STRIP001 }


}
